/*
* accountcache.h
*
* Copyright 2001-2008 by Oracle. All rights reserved.
*
* Oracle is a registered trademarks of Oracle Corporation and/or its
* affiliates.
*
* This software is the confidential and proprietary information of Oracle
* Corporation. You shall not disclose such confidential and proprietary
* information and shall use it only in accordance with the terms of the
* license agreement you entered into with Oracle.
*
* This notice may not be removed or altered.
*/
#ifndef _ACCOUNT_CACHE_H_
#define _ACCOUNT_CACHE_H_

#include "account.h"
#include "cache.h"

/**
 * Cache implementation - assumes that cache keys are instances of java.lang.Integer
 * and values are instances of com.tangosol.examples.cppexample.Account
 */
class AccountCache : public Cache {
public:
    
    AccountCache(const char* pszCacheName);
    
protected:
    
    /**
     * converters to/from native Account class and
     * com.tangosol.examples.cppexample.Account
     */
    virtual jobject convertValToJava(void *pObject);
    virtual void*   convertValFromJava(jobject jObject);
    
    /**
     * convert native key (int) to an instance of java.lang.Integer
     */
    virtual jobject convertKeyToJava(void *pKey);    
    
private:
    jclass m_classBase;                 // com.tangosol.util.Base
    jclass m_classAccount;              // com.tangosol.examples.cppexample.Account
    
    jmethodID m_midBaseMakeInteger;     // Integer Base.makeInteger(int i)
    
    jmethodID m_midAccountCtor;         // Account default constructor
    
    jmethodID m_midAccountGetName;      // String Account.getName()
    jmethodID m_midAccountSetName;      // void   Account.setName(String sName)
    
    jmethodID m_midAccountGetId;        // int  Account.getId()
    jmethodID m_midAccountSetId;        // void Account.setId(int iId)
    
    jmethodID m_midAccountGetBalance;   // double Account.getBalance()
    jmethodID m_midAccountSetBalance;   // void   Account.setBalance(double dBalance)
};

#endif

