/*
* accountcache.cpp
*
* Copyright 2001-2008 by Oracle. All rights reserved.
*
* Oracle is a registered trademarks of Oracle Corporation and/or its
* affiliates.
*
* This software is the confidential and proprietary information of Oracle
* Corporation. You shall not disclose such confidential and proprietary
* information and shall use it only in accordance with the terms of the
* license agreement you entered into with Oracle.
*
* This notice may not be removed or altered.
*/
#include "accountcache.h"
#include "account.h"

/**
 * AccountCache constructor; Initialize super and obtain Base.makeInteger() and
 * com.tangosol.examples.cppexample.Account default constructor, getters and setters
 */
AccountCache::AccountCache(const char* pszCacheName)
: Cache(pszCacheName)
{
    m_classBase            = Utils::ensureClass("com/tangosol/util/Base");
    m_classAccount         = Utils::ensureClass("com/tangosol/examples/cppexample/Account");

    m_midBaseMakeInteger   = Utils::ensureStaticMethod(m_classBase, "makeInteger", "(I)Ljava/lang/Integer;");
    
    m_midAccountCtor       = Utils::ensureMethod(m_classAccount, "<init>"    , "()V");
    m_midAccountGetName    = Utils::ensureMethod(m_classAccount, "getName"   , "()Ljava/lang/String;");
    m_midAccountSetName    = Utils::ensureMethod(m_classAccount, "setName"   , "(Ljava/lang/String;)V");
    m_midAccountGetId      = Utils::ensureMethod(m_classAccount, "getId"     , "()I");
    m_midAccountSetId      = Utils::ensureMethod(m_classAccount, "setId"     , "(I)V");
    m_midAccountGetBalance = Utils::ensureMethod(m_classAccount, "getBalance", "()D");
    m_midAccountSetBalance = Utils::ensureMethod(m_classAccount, "setBalance", "(D)V");
}

/**
 * Convert native Account to an instance of com.tangosol.examples.cppexample.Account
 */
jobject AccountCache::convertValToJava(void *pObject) {
    Account* pAccount = (Account*) pObject;
    jobject account   = Utils::getEnv()->NewObject(m_classAccount, m_midAccountCtor);
    
    jstring jsName    = Utils::getEnv()->NewStringUTF(pAccount->getName());
    jint    jiId      = pAccount->getId();
    jdouble jdBalance = pAccount->getBalance();
    
    Utils::getEnv()->CallVoidMethod(account, m_midAccountSetName   , jsName);
    Utils::getEnv()->CallVoidMethod(account, m_midAccountSetId     , jiId);
    Utils::getEnv()->CallVoidMethod(account, m_midAccountSetBalance, jdBalance);
    Utils::getEnv()->DeleteLocalRef(jsName);
    return account;
}

/**
 * Convert an instance of com.tangosol.examples.cppexample.Account to native Account
 */
void* AccountCache::convertValFromJava(jobject jObject) {
    jstring jsName      = (jstring) Utils::getEnv()->CallObjectMethod(jObject, m_midAccountGetName);
    jint    jiId        = Utils::getEnv()->CallIntMethod(jObject, m_midAccountGetId);
    jdouble jdBalance   = Utils::getEnv()->CallDoubleMethod(jObject, m_midAccountGetBalance);    
    const char *jacName = Utils::getEnv()->GetStringUTFChars(jsName, NULL);
    Account* pAccount   = new Account(jacName, jiId, jdBalance);
    Utils::getEnv()->ReleaseStringUTFChars(jsName, jacName);
    Utils::getEnv()->DeleteLocalRef(jsName);
    return pAccount;    
}

/**
 * Convert int to an instance of java.lang.Integer
 */
jobject AccountCache::convertKeyToJava(void *pKey) {
    int iKey = (int)pKey;
    return Utils::getEnv()->CallStaticObjectMethod(m_classBase, m_midBaseMakeInteger, iKey); 
}    
