/*
* account.h
*
* Copyright 2001-2008 by Oracle. All rights reserved.
*
* Oracle is a registered trademarks of Oracle Corporation and/or its
* affiliates.
*
* This software is the confidential and proprietary information of Oracle
* Corporation. You shall not disclose such confidential and proprietary
* information and shall use it only in accordance with the terms of the
* license agreement you entered into with Oracle.
*
* This notice may not be removed or altered.
*/
#ifndef _ACCOUNT_H_
#define _ACCOUNT_H_

#include <stdlib.h>
#include <string.h>

/**
* Example value class;
* Corresponding Java class is com.tangosol.examples.cppexample.Account
*/
class Account {
public:    
    Account(const char* sName, int iId, double dBalance) {
        m_sName    = strdup(sName);
        m_iId      = iId;
        m_dBalance = dBalance;
    }
    
    ~Account() {
        free(m_sName);
    }
    
    char* getName() const {
        return m_sName;
    }
    
    const int getId() const {
        return m_iId;
    }
    
    void setId(int iId) {
        m_iId = iId;
    }
    
    const double getBalance() const {
        return m_dBalance;
    }
    
    void setBalance(double dBalance) {
        m_dBalance = dBalance;
    }
    
private:    
    char*  m_sName;
    int    m_iId;
    double m_dBalance;
};

#endif

