/*
* TestClient.java
*
* Copyright 2000-2006 by Tangosol, Inc.  All rights reserved.
*
* This software is the confidential and proprietary information of
* Tangosol, Inc.  You shall not disclose such confidential and pro-
* prietary information and shall use it only in accordance with the
* terms of the license agreement you entered into with Tangosol, Inc.
*
* Tangosol, Inc. makes no representations or warranties about the suit-
* ability of the software, either express or implied, including but not
* limited to the implied warranties of merchantability, fitness for a
* particular purpose, or non-infringement.  Tangosol, Inc. shall not be
* liable for any damages suffered by licensee as a result of using,
* modifying or distributing this software or its derivatives.
*
* Tangosol, Inc. is located at http://www.tangosol.com and can be
* contacted by e-mail at info@tangosol.com.
*
* This notice may not be removed or altered.
*/
package com.tangosol.examples.extend;


import com.tangosol.net.CacheFactory;
import com.tangosol.net.NamedCache;

import com.tangosol.net.security.Security;

import com.tangosol.util.Base;

import java.security.Principal;
import java.security.PrivilegedAction;

import java.util.Iterator;

import javax.security.auth.Subject;


/**
* Simple application that demonstrations how to pass client identity
* information to the cluster (via Coherence*Extend), where it is used to
* enforce entitlements on the target NamedCache.
*
* @author jh  2006.12.15
*/
public class TestClient
        extends Base
    {
    /**
    * Application entry point. Usage:
    * <pre>
    * java com.tangosol.examples.extend.TestClient [user] [password]
    * </pre>
    * @param asArg
    */
    public static void main(String[] asArg)
        {
        if (asArg == null || asArg.length == 0)
            {
            usage();
            return;
            }

        final String sUsername = asArg[0];
        final String sPassword = asArg[1];

        log("Authenticating " + sUsername + " ...");

        Subject subject;
        try
            {
            subject = Security.login(sUsername, sPassword.toCharArray());
            }
        catch (Throwable t)
            {
            subject = null;
            log("Authentication error:");
            log(t);
            }

        if (subject != null)
            {
            for (Iterator iter = subject.getPrincipals().iterator(); iter.hasNext(); )
                {
                Principal principal = (Principal) iter.next();
                log("Principal: " + principal.getName());
                }
            }

        Security.runAs(subject, new PrivilegedAction()
            {
            public Object run()
                {
                NamedCache cache = CacheFactory.getCache(CACHE_NAME);

                log("cache.put(\"user\", \"" + sUsername + "\") = " +
                        cache.put("user", sUsername));
                log("cache.put(\"key\", \"value\") = " +
                        cache.put("key", "value"));
                log("cache.get(\"key\") = " + cache.get("key"));

                return null;
                }
            });
        }


    // ----- helper methods -------------------------------------------------

    /**
    * Output command line application usage information.
    */
    public static void usage()
        {
        err("Usage: java " + TestClient.class.getName() + " [user] [password]");
        }


    // ----- constants ------------------------------------------------------

    /**
    * The name of the NamedCache used by this test.
    */
    public static final String CACHE_NAME = "remote-test";
    }
