/*
* WrapperSet.java
*
* Copyright 2001-2007 by Oracle. All rights reserved.
*
* Oracle is a registered trademarks of Oracle Corporation and/or its affiliates.
*
* This software is the confidential and proprietary information of
* Oracle Corporation. You shall not disclose such confidential and
* proprietary information and shall use it only in accordance with the
* terms of the license agreement you entered into with Oracle.
*
* This notice may not be removed or altered.
*/
package com.tangosol.examples.extend;


import java.util.Set;


/**
* Set implementation that delegates to another Set.
*
* @author jh  2007.09.20
*/
public class WrapperSet
        extends WrapperCollection
        implements Set
    {
    // ----- constructors ---------------------------------------------------

    /**
    * Create a new WrapperSet that delegates to the given Set.
    *
    * @param set  the wrapped Set; must not be null
    */
    public WrapperSet(Set set)
        {
        super(set);
        }


    // ----- accessors ------------------------------------------------------

    /**
    * @return the wrapped Set
    */
    protected Set getSet()
        {
        return (Set) getCollection();
        }
    }