/*
* ExtendCacheFactory.java
*
* Copyright 2001-2007 by Oracle. All rights reserved.
*
* Oracle is a registered trademarks of Oracle Corporation and/or its affiliates.
*
* This software is the confidential and proprietary information of
* Oracle Corporation. You shall not disclose such confidential and
* proprietary information and shall use it only in accordance with the
* terms of the license agreement you entered into with Oracle.
*
* This notice may not be removed or altered.
*/
package com.tangosol.examples.extend;


import com.tangosol.net.DefaultConfigurableCacheFactory;

import com.tangosol.run.xml.XmlElement;

import java.util.Map;


/**
* DefaultConfigurableCacheFactory extension that can release ExtendBackingMap
* instances when they are no longer used.
*
* @author jh  2007.12.07
*/
public class ExtendCacheFactory extends DefaultConfigurableCacheFactory
    {
    /**
    * {@inheritDoc}
    */
    public ExtendCacheFactory()
        {
        super();
        }

    /**
    * {@inheritDoc}
    */
    public ExtendCacheFactory(String sPath)
        {
        super(sPath);
        }

    /**
    * {@inheritDoc}
    */
    public ExtendCacheFactory(String sPath, ClassLoader loader)
        {
        super(sPath, loader);
        }

    /**
    * {@inheritDoc}
    */
    public ExtendCacheFactory(XmlElement xmlConfig)
        {
        super(xmlConfig);
        }

    /**
    * {@inheritDoc}
    */
    public void release(Map map, Map mapListeners)
        {
        super.release(map, mapListeners);

        if (map instanceof ExtendBackingMap)
            {
            ((ExtendBackingMap) map).release();
            }
        }
    }