/*
* TestHttpSessionListener.java
*
* Copyright 2000-2005 by Tangosol, Inc.  All rights reserved.
*
* This software is the confidential and proprietary information of
* Tangosol, Inc.  You shall not disclose such confidential and pro-
* prietary information and shall use it only in accordance with the
* terms of the license agreement you entered into with Tangosol, Inc.
*
* Tangosol, Inc. makes no representations or warranties about the suit-
* ability of the software, either express or implied, including but not
* limited to the implied warranties of merchantability, fitness for a
* particular purpose, or non-infringement.  Tangosol, Inc. shall not be
* liable for any damages suffered by licensee as a result of using,
* modifying or distributing this software or its derivatives.
*
* Tangosol, Inc. is located at http://www.tangosol.com and can be
* contacted by e-mail at info@tangosol.com.
*
* This notice may not be removed or altered.
*/
package com.tangosol.examples.coherence.session;


import com.tangosol.net.CacheFactory;

import com.tangosol.util.Base;

import javax.servlet.http.HttpSessionAttributeListener;
import javax.servlet.http.HttpSessionBindingEvent;
import javax.servlet.http.HttpSessionEvent;
import javax.servlet.http.HttpSessionListener;


/**
* HttpSessionListener and HttpSessionAttributeListener implementation that
* logs information about HttpSessionEvents.
*
* @author cp 2003.10.06
* @author jh 2004.10.06
*
* @see HttpSessionListener
* @see HttpSessionAttributeListener
* @see HttpSessionEvent
* @see HttpSessionBindingEvent
*
* @version 2.5
*/
public class TestHttpSessionListener
        extends Base
        implements HttpSessionListener, HttpSessionAttributeListener
    {
    // ----- constructors -----------------------------------------------------

    /**
    * Public default constructor; required by the specification.
    */
    public TestHttpSessionListener()
        {
        }


    // ----- TestHttpSessionListener methods ----------------------------------

    /**
    * Logs information about an HttpSessionBindingEvent.
    *
    * @param sEvent contextual information
    * @param event  the event
    */
    protected void show(String sEvent, HttpSessionBindingEvent event)
        {
        CacheFactory.log(sEvent
                + ": session=" + event.getSession().getId()
                + ", name=" + event.getName()
                + ", value=" + (event.getValue() == null ? "null"
                : event.getValue() == this ? "this"
                : String.valueOf(event.getValue())), 3);
        }


    // ----- HttpSessionListener interface ------------------------------------

    public void sessionCreated(HttpSessionEvent evt)
        {
        CacheFactory.log("sessionCreated: session=" +
                evt.getSession().getId(), 3);
        }

    public void sessionDestroyed(HttpSessionEvent evt)
        {
        CacheFactory.log("sessionDestroyed: session=" +
                evt.getSession().getId(), 3);
        }


    // ----- HttpSessionAttributeListener interface ---------------------------

    public void attributeAdded(HttpSessionBindingEvent evt)
        {
        show("sessionAttributeAdded", evt);
        }

    public void attributeRemoved(HttpSessionBindingEvent evt)
        {
        show("sessionAttributeRemoved", evt);
        }

    public void attributeReplaced(HttpSessionBindingEvent evt)
        {
        show("sessionAttributeReplaced", evt);
        }
    }
