/*
* ReportTask.java
*
* Copyright 2000-2005 by Tangosol, Inc.  All rights reserved.
*
* This software is the confidential and proprietary information of
* Tangosol, Inc.  You shall not disclose such confidential and pro-
* prietary information and shall use it only in accordance with the
* terms of the license agreement you entered into with Tangosol, Inc.
*
* Tangosol, Inc. makes no representations or warranties about the suit-
* ability of the software, either express or implied, including but not
* limited to the implied warranties of merchantability, fitness for a
* particular purpose, or non-infringement.  Tangosol, Inc. shall not be
* liable for any damages suffered by licensee as a result of using,
* modifying or distributing this software or its derivatives.
*
* Tangosol, Inc. is located at http://www.tangosol.com and can be
* contacted by e-mail at info@tangosol.com.
*
* This notice may not be removed or altered.
*/
package com.tangosol.examples.coherence.session;


import com.tangosol.net.AbstractInvocable;


/**
* A runnable task used to report information about a cluster node's VM.
*
* @author erm 2003.09.12
* @author jh 2004.10.06
*
* @see AbstractInvocable
*
* @version 2.5
*/
public class ReportTask
        extends AbstractInvocable
    {
    // ----- Invocable interface ----------------------------------------------

    /**
    * Called exactly once by the InvocationService to invoke this Invocable
    * object.
    */
    public void run()
        {
        // get runtime stats, including free and total VM memory
        Runtime runtime = Runtime.getRuntime();
        long free = runtime.freeMemory();
        long total = runtime.totalMemory();
        NodeInfo nodeInfo = new NodeInfo(free, total);

        // set the result of the invocation
        setResult(nodeInfo);
        }
    }
