/*
* NodeInfo.java
*
* Copyright 2000-2005 by Tangosol, Inc.  All rights reserved.
*
* This software is the confidential and proprietary information of
* Tangosol, Inc.  You shall not disclose such confidential and pro-
* prietary information and shall use it only in accordance with the
* terms of the license agreement you entered into with Tangosol, Inc.
*
* Tangosol, Inc. makes no representations or warranties about the suit-
* ability of the software, either express or implied, including but not
* limited to the implied warranties of merchantability, fitness for a
* particular purpose, or non-infringement.  Tangosol, Inc. shall not be
* liable for any damages suffered by licensee as a result of using,
* modifying or distributing this software or its derivatives.
*
* Tangosol, Inc. is located at http://www.tangosol.com and can be
* contacted by e-mail at info@tangosol.com.
*
* This notice may not be removed or altered.
*/
package com.tangosol.examples.coherence.session;


import java.io.Serializable;


/**
* Encapsulates information about a cluster node.
*
* @author erm 2003.10.06
* @author jh 2004.10.06
*
* @version 2.5
*/
public class NodeInfo
        implements Serializable
    {
    // ----- constructors -----------------------------------------------------

    /**
    * Creates a new NodeInfo with the associated free memory and total memory
    * information.
    *
    * @param lFreeMem  the free memory available on a cluster node (in bytes)
    * @param lTotalMem the total memory available on a cluster node (in bytes)
    */
    NodeInfo(long lFreeMem, long lTotalMem)
        {
        setFreeMem(lFreeMem);
        setTotalMem(lTotalMem);
        }


    // ----- accessors --------------------------------------------------------

    /**
    * Sets the free memory of this NodeInfo.
    *
    * @param lFreeMem the free memory (in bytes)
    */
    public void setFreeMem(long lFreeMem)
        {
        m_lFreeMem = lFreeMem;
        }

    /**
    * Returns the amount of free memory in the cluster node's VM (in bytes).
    *
    * @return the amount of free memory on the cluster node (in bytes)
    */
    public long getFreeMem()
        {
        return m_lFreeMem;
        }

    /**
    * Sets the total memory of this NodeInfo.
    *
    * @param lTotalMem the total memory (in bytes)
    */
    public void setTotalMem(long lTotalMem)
        {
        m_lTotalMem = lTotalMem;
        }

    /**
    * Returns the total amount of memory in the cluster node's VM (in bytes).
    *
    * @return the total amount of memory on the cluster node.
    */
    public long getTotalMem()
        {
        return m_lTotalMem;
        }

    // ----- data members -----------------------------------------------------

    /**
    * The free memory in a cluster nodes' VM (in bytes).
    */
    private long m_lFreeMem;

    /**
    * The total memory in a cluster nodes' VM (in bytes).
    */
    private long m_lTotalMem;
    }
