/*
* HtmlUtils.java
*
* Copyright 2000-2005 by Tangosol, Inc.  All rights reserved.
*
* This software is the confidential and proprietary information of
* Tangosol, Inc.  You shall not disclose such confidential and pro-
* prietary information and shall use it only in accordance with the
* terms of the license agreement you entered into with Tangosol, Inc.
*
* Tangosol, Inc. makes no representations or warranties about the suit-
* ability of the software, either express or implied, including but not
* limited to the implied warranties of merchantability, fitness for a
* particular purpose, or non-infringement.  Tangosol, Inc. shall not be
* liable for any damages suffered by licensee as a result of using,
* modifying or distributing this software or its derivatives.
*
* Tangosol, Inc. is located at http://www.tangosol.com and can be
* contacted by e-mail at info@tangosol.com.
*
* This notice may not be removed or altered.
*/
package com.tangosol.examples.coherence.session;


/**
 * Utility class that contains HTML helper methods.
 *
 * @author jh 2004.11.15
 */
public abstract class HtmlUtils
    {
    /**
     * Formats the given String so that it fits within the specified number of
     * character columns.
     *
     * @param string the String to format
     * @param width  the desired width of the formatted String
     *
     * @return the formatted String
     */
    public static String wrap(String string, int width)
        {
        int iLength = string.length();
        if (iLength <= width)
            {
            return string;
            }

        int index = width;
        StringBuffer buffer = new StringBuffer(string.substring(0, index));

        do
        {
        buffer.append("<br>");
        buffer.append(string.substring(index,
                (index = Math.min(index + width, iLength))));
        }
        while (index < iLength);

        return buffer.toString();
        }
    }