package com.tangosol.examples.l2;


import org.apache.log4j.Logger;
import org.hibernate.HibernateException;
import org.hibernate.Query;
import org.hibernate.SessionFactory;
import org.hibernate.Transaction;
import org.hibernate.classic.Session;

import java.util.List;


/**
 * DAO implementation for SampleEntity that uses Hibernate APIs
 * for its implementation.
 *
 * @author pperalta Jun 7, 2007
 */
public class SampleEntityDao
    {
    private static final Logger LOG = Logger.getLogger(SampleEntityDao.class);

    private SessionFactory sessionFactory;


    public SampleEntityDao(SessionFactory sessionFactory)
        {
        this.sessionFactory = sessionFactory;
        }

    public void saveSimpleEntity(SampleEntity sampleEntity)
        {
        Session session = sessionFactory.openSession();
        Transaction tx = null;
        try
            {
            LOG.debug("Starting new Hibernate Transaction...");
            tx = session.beginTransaction();

            session.saveOrUpdate(sampleEntity);

            LOG.debug("Starting Commit Transaction...");
            tx.commit();
            LOG.debug("Tranaction Complete.");
            tx = null;
            }
        catch (HibernateException ex)
            {
            if (tx != null)
                {
                tx.rollback();
                }
            LOG.warn("Could not save "+sampleEntity, ex);
            }
        finally
            {
            session.close();
            }
        }

    public SampleEntity getSimpleEntity(String id)
        {
        Session session = sessionFactory.openSession();
        SampleEntity se;

        try
            {
            LOG.debug("loading id: " + id);
            se = (SampleEntity) session.get(SampleEntity.class, id);
            LOG.debug("loaded : " + se);
            }
        finally
            {
            session.close();
            }

        return se;
        }

    public List<SampleEntity> getSimpleEntityByName(String name)
        {
        Session session = sessionFactory.openSession();

        try
            {
            Query q = session.createQuery("from SampleEntity s where s.name like ?");
            q.setString(0, name);
            q.setCacheable(true);
            return q.list();
            }
        finally
            {
            session.close();
            }
        }

    public List<SampleEntity> getSimpleEntities()
        {
        Session session = sessionFactory.openSession();

        try
            {
            Query q = session.createQuery("from SampleEntity");
            q.setCacheable(true);
            return q.list();
            }
        finally
            {
            session.close();
            }
        }

    }
