package com.tangosol.examples.l2;

import java.sql.Timestamp;


/**
 * Sample entity object stored by Hibernate.
 *
 * @author pperalta Jun 7, 2007
 */
public class SampleEntity
    {
    // ----- Accessors  -----------------------------------------------------
    public String getId()
        {
        return id;
        }

    public void setId(String id)
        {
        this.id = id;
        }

    public String getName()
        {
        return name;
        }

    public void setName(String name)
        {
        this.name = name;
        }

    public Timestamp getDate()
        {
        return date;
        }

    public void setDate(Timestamp date)
        {
        this.date = date;
        }

    public Integer getAge()
        {
        return age;
        }

    public void setAge(Integer age)
        {
        this.age = age;
        }

    // ----- Object methods equals/hashCode/toString ------------------------
    public boolean equals(Object o)
        {
        if (this == o)
            {
            return true;
            }
        if (o == null || getClass() != o.getClass())
            {
            return false;
            }

        SampleEntity that = (SampleEntity) o;

        if (id != null ? !id.equals(that.id) : that.id != null)
            {
            return false;
            }
        if (name != null ? !name.equals(that.name) : that.name != null)
            {
            return false;
            }

        return true;
        }

    public int hashCode()
        {
        int result;
        result = (id != null ? id.hashCode() : 0);
        result = 31 * result + (name != null ? name.hashCode() : 0);
        return result;
        }

    public String toString()
        {
        return "SampleEntity{" +
                "id='" + id + '\'' +
                ", name='" + name + '\'' +
                ", date=" + date +
                ", age=" + age +
                '}';
        }

    // ----- properties----------------- ------------------------------------

    private String id;
    private String name;
    private Timestamp date;
    private Integer age;
    }
