package com.tangosol.examples.cs;


import com.tangosol.net.NamedCache;
import com.tangosol.util.filter.LikeFilter;
import com.tangosol.util.extractor.ReflectionExtractor;
import org.apache.log4j.Logger;

import java.util.Collection;
import java.util.Collections;
import java.util.Set;


/**
 * DAO implementation for SampleEntity that uses Coherence APIs
 * for its implementation.
 *
 * @author pperalta Jun 7, 2007
 */
public class SampleEntityDao
    {

    private static final Logger LOG = Logger.getLogger(SampleEntityDao.class);

    private NamedCache sampleEntityCache;


    public SampleEntityDao(NamedCache sampleEntityCache)
        {
        this.sampleEntityCache = sampleEntityCache;

        // add index to increase query speed
        // see http://wiki.tangosol.com/display/COH33UG/Querying+the+Cache
        this.sampleEntityCache.addIndex(new ReflectionExtractor("getName"), false, null);
        }

    public void saveSampleEntity(SampleEntity sampleEntity)
        {
        sampleEntityCache.putAll(Collections.singletonMap(
                sampleEntity.getId(), sampleEntity));
        }

    public SampleEntity getSampleEntity(String id)
        {
        return (SampleEntity) sampleEntityCache.get(id);
        }

    public Collection<SampleEntity> getSimpleEntityByName(String s)
        {
        Set keys = sampleEntityCache.keySet(new LikeFilter("getName", s));
        return sampleEntityCache.getAll(keys).values();
        }

    public Collection<SampleEntity> getSimpleEntities()
        {
        return sampleEntityCache.values();
        }
    }
