package com.tangosol.examples.cs;


import com.tangosol.io.ExternalizableLite;
import com.tangosol.util.ExternalizableHelper;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.sql.Timestamp;


/**
 * Sample entity object stored by Coherence and Hibernate.
 * This object implements ExternalizableLite, an optimized
 * serializable format used by Coherence.  See the JavaDoc
 * for {@link ExternalizableLite} for more details.
 *
 * @author pperalta Jun 7, 2007
 */
public class SampleEntity
        implements ExternalizableLite
    {
    // ----- Accessors  -----------------------------------------------------
    public String getId()
        {
        return id;
        }

    public void setId(String id)
        {
        this.id = id;
        }

    public String getName()
        {
        return name;
        }

    public void setName(String name)
        {
        this.name = name;
        }

    public Timestamp getDate()
        {
        return date;
        }

    public void setDate(Timestamp date)
        {
        this.date = date;
        }

    public Integer getAge()
        {
        return age;
        }

    public void setAge(Integer age)
        {
        this.age = age;
        }

    // ----- Object methods equals/hashCode/toString ------------------------
    public boolean equals(Object o)
        {
        if (this == o)
            {
            return true;
            }
        if (o == null || getClass() != o.getClass())
            {
            return false;
            }

        SampleEntity that = (SampleEntity) o;

        if (id != null ? !id.equals(that.id) : that.id != null)
            {
            return false;
            }
        if (name != null ? !name.equals(that.name) : that.name != null)
            {
            return false;
            }

        return true;
        }

    public int hashCode()
        {
        int result;
        result = (id != null ? id.hashCode() : 0);
        result = 31 * result + (name != null ? name.hashCode() : 0);
        return result;
        }

    public String toString()
        {
        return "SampleEntity{" +
                "id='" + id + '\'' +
                ", name='" + name + '\'' +
                ", date=" + date +
                ", age=" + age +
                '}';
        }

    // ----- ExternalizableLite ---------------------------------------------
    public void readExternal(DataInput dataInput)
            throws IOException
        {
        id = ExternalizableHelper.readSafeUTF(dataInput);
        name = ExternalizableHelper.readSafeUTF(dataInput);
        date = new Timestamp(ExternalizableHelper.readLong(dataInput));
        age = ExternalizableHelper.readInt(dataInput);
        }

    public void writeExternal(DataOutput dataOutput)
            throws IOException
        {
        ExternalizableHelper.writeSafeUTF(dataOutput, id);
        ExternalizableHelper.writeSafeUTF(dataOutput, name);
        ExternalizableHelper.writeLong(dataOutput, date.getTime());
        ExternalizableHelper.writeInt(dataOutput, age);
        }

    // ----- properties----------------- ------------------------------------

    private String id;
    private String name;
    private Timestamp date;
    private Integer age;

    }
