package com.tangosol.examples.cs;


import com.tangosol.net.CacheFactory;
import com.tangosol.net.NamedCache;
import org.apache.log4j.Logger;

import java.sql.Timestamp;
import java.util.Collection;
import java.util.Random;
import java.util.UUID;


/**
 * This sample program demonstrates the use of a Hibernate CacheStore.
 * It populates a database with sample {@link SampleEntity} objects
 * via Coherence and performs some queries.
 *
 * See http://wiki.tangosol.com/display/COH33UG/Using+Coherence+and+Hibernate
 * for more details and further documentation.
 *
 * @author pperalta Jun 7, 2007
 */
public class CSMain
    {
    public static void main(String[] args)
        {
        // Set up Coherence properties.  Normally this is set
        // up on the java command line using the -D flag, but it
        // is done here for illustrative purposes

        System.setProperty("tangosol.coherence.cacheconfig", "sample-cache-config.xml");

        // The cache is named after the entity being stored.  This makes
        // the CacheStore configuration in the Coherence cache XML file
        // much simpler.
        NamedCache cache = CacheFactory.getCache(SampleEntity.class.getName());

        SampleEntityDao dao = new SampleEntityDao(cache);

        LOG.info("Populating values....");

        // Seed the cache/database with sample values
        for (int i = 0; i < 1000; i++)
            {
            SampleEntity se = new SampleEntity();
            se.setId(UUID.randomUUID().toString());
            se.setName(getRandomString());
            se.setDate(new Timestamp(System.currentTimeMillis()));
            se.setAge(i);

            dao.saveSampleEntity(se);
            }

        LOG.info("Populated values; now performing query by name using wildcard");

        // Perform a query using the DAO.  This DAO uses the Coherence
        // query API to perform the query
        Collection<SampleEntity> results = dao.getSimpleEntityByName("i%");

        LOG.info("----- Query results -----");
        for (SampleEntity e : results)
            {
            LOG.info(e);
            }

        LOG.info("Query results total: " + results.size());
        }

    /**
     * Generate a random string
     * @return a random string
     */
    public static String getRandomString()
        {
        Random rnd = RANDOM;
        int cch = 10;
        char[] ach = new char[cch];
        for (int of = 0; of < cch; ++of)
            {
            ach[of] = (char) ('a' + rnd.nextInt(26));
            }
        return new String(ach);
        }

    private static Random RANDOM = new Random(System.currentTimeMillis());

    private static final Logger LOG = Logger.getLogger(CSMain.class);
    }
