
package com.tangosol.examples.versionedbeans;


import com.tangosol.io.ExternalizableLite;

import com.tangosol.util.Base;
import com.tangosol.util.Binary;
import com.tangosol.util.ExternalizableHelper;

import java.io.DataOutput;
import java.io.DataInput;
import java.io.IOException;
import java.io.NotActiveException;
import java.io.Serializable;


/**
* JavaBean test class: Address.
*
* @author cp  2005.10.19 - Version 1.0
*/
public class Address
        implements ExternalizableLite
    {
    // ----- constructors ---------------------------------------------------

    /**
    * Default constructor.
    */
    public Address()
        {
        }


    // ----- properties -----------------------------------------------------

    /**
    * Determine the street address.
    *
    * @return the street address to mail to
    */
    public String getStreet()
        {
        return m_sStreet;
        }

    /**
    * Specify the street address.
    *
    * @param sStreet the street address to mail to
    */
    public void setStreet(String sStreet)
        {
        m_sStreet = sStreet;
        }

    /**
    * Determine the city.
    *
    * @return the city to mail to
    */
    public String getCity()
        {
        return m_sCity;
        }

    /**
    * Specify the city.
    *
    * @param sCity the city to mail to
    */
    public void setCity(String sCity)
        {
        m_sCity = sCity;
        }

    /**
    * Determine the state (region).
    *
    * @return the state to mail to
    */
    public String getState()
        {
        return m_sState;
        }

    /**
    * Specify the state (region).
    *
    * @param sState the state to mail to
    */
    public void setState(String sState)
        {
        m_sState = sState;
        }

    /**
    * Determine the post code (zip code).
    *
    * @return the postal code to mail to
    */
    public String getPostCode()
        {
        return m_sPostCode;
        }

    /**
    * Specify the post code (zip code).
    *
    * @param sPostCode the postal code to mail to
    */
    public void setPostCode(String sPostCode)
        {
        m_sPostCode = sPostCode;
        }


    // ----- ExternalizableLite methods -------------------------------------

    /**
    * Restore the contents of this object by loading the object's state from
    * the passed DataInput object.
    *
    * @param in  the DataInput stream to read data from in order to restore
    *            the state of this object
    *
    * @exception IOException         if an I/O exception occurs
    * @exception NotActiveException  if the object is not in its initial
    *            state, and therefore cannot be deserialized into
    */
    public void readExternal(DataInput in)
            throws IOException
        {
        // the stream starts with the serialization version of the JavaBean
        int nVer = in.readInt();

        // version numbers are ascending, starting with version 1
        if (nVer < 1)
            {
            throw new IOException("Illegal version number: " + nVer);
            }

        // remember the version that was read, but upgrade it at
        // least to the current version
        m_nSerVer = Math.max(nVer, CURRENT_VERSION);

        // version 1 deserialization
        setStreet  (ExternalizableHelper.readUTF(in));
        setCity    (ExternalizableHelper.readUTF(in));
        setState   (ExternalizableHelper.readUTF(in));
        setPostCode(ExternalizableHelper.readUTF(in));

        // all the version 2 and later information is stored as a
        // length-encoded binary; store it off for later use
        if (nVer > CURRENT_VERSION)
            {
            Binary bin = new Binary();
            bin.readExternal(in);
            m_binExtra = bin;
            }
        }

    /**
    * Save the contents of this object by storing the object's state into
    * the passed DataOutput object.
    *
    * @param out  the DataOutput stream to write the state of this object to
    *
    * @exception IOException if an I/O exception occurs
    */
    public void writeExternal(DataOutput out)
            throws IOException
        {
        int nVer = m_nSerVer;
        out.writeInt(nVer);

        // version 1 serialization
        ExternalizableHelper.writeUTF(out, getStreet());
        ExternalizableHelper.writeUTF(out, getCity());
        ExternalizableHelper.writeUTF(out, getState());
        ExternalizableHelper.writeUTF(out, getPostCode());

        // all the version 2 and later information is stored as a
        // length-encoded binary (it was read in, stored off, and has not
        // been modified)
        if (nVer > CURRENT_VERSION)
            {
            m_binExtra.writeExternal(out);
            }
        }


    // ----- Object methods -------------------------------------------------

    /**
    * Format the Address as a String.
    *
    * @return a human-readable String containing the address information
    */
    public String toString()
        {
        StringBuffer sb = new StringBuffer();

        sb.append("Address{Street=")
          .append(getStreet())
          .append(", City=")
          .append(getCity())
          .append(", State=")
          .append(getState())
          .append(", PostCode=")
          .append(getPostCode())
          .append(", serialization version=")
          .append(m_nSerVer)
          .append('}');

        return sb.toString();
        }


    // ----- unit test ------------------------------------------------------

    /**
    * Run this from the command line to test the current version of this
    * bean.
    */
    public static void main(String[] asArg)
        {
        Address addr = new Address();
        addr.setStreet("48 Grove St.");
        addr.setCity("Boston");
        addr.setState("MA");
        addr.setPostCode("02144");
        Base.out("\nTest instance:\n" + addr);

        Binary bin = ExternalizableHelper.toBinary(addr);
        Base.out("\nSerialized form:\n" + Base.toHexDump(bin.toByteArray(), 16));

        addr = (Address) ExternalizableHelper.fromBinary(bin);
        Base.out("\nDeserialized form:\n" + addr);
        }


    // ----- constants ------------------------------------------------------

    /**
    * Version indicator for serialization.
    */
    public static final int CURRENT_VERSION = 1;


    // ----- data members ---------------------------------------------------

    /**
    * Serialization version.
    */
    private int    m_nSerVer = CURRENT_VERSION;

    /**
    * Serialization version.
    */
    private Binary m_binExtra;

    /**
    * Holds the value of the Street property.
    */
    private String m_sStreet;

    /**
    * Holds the value of the City property.
    */
    private String m_sCity;

    /**
    * Holds the value of the State property.
    */
    private String m_sState;

    /**
    * Holds the value of the PostCode property.
    */
    private String m_sPostCode;
    }