/*
* CoherenceWrapper.cs
*
* Copyright 2001-2007 by Oracle. All rights reserved.
*
* Oracle is a registered trademarks of Oracle Corporation and/or its
* affiliates.
*
* This software is the confidential and proprietary information of Oracle
* Corporation. You shall not disclose such confidential and proprietary
* information and shall use it only in accordance with the terms of the
* license agreement you entered into with Oracle.
*
* This notice may not be removed or altered.
*/
using System;
using System.Diagnostics;
using System.Runtime.InteropServices;

using Tangosol.Net;
using Tangosol.Util;

/**
* Simple COM interface for accessing a Coherence INamedCache.
*/
public interface ICoherence
{
    int size(String sCacheName);
    void clear(String sCacheName);
    void put(String sCacheName, IntPtr pKey, int lKey, IntPtr pValue, int lValue);
    void get(String sCacheName, IntPtr pKey, int lKey, IntPtr pValue, int lValue);
    void remove(String sCacheName, IntPtr pKey, int lKey);
}

/**
* Simple implementation of the ICoherence interface.
*/
public class Coherence: ICoherence
{
    public Coherence()
    {
    }

    public int size(String sCacheName)
    {
        try
        {
            return CacheFactory.GetCache(sCacheName).Count;
        }
        catch (Exception e)
        {
            Console.WriteLine(e);
            return -1;
        }
    }

    public void clear(String sCacheName)
    {
        try
        {
            CacheFactory.GetCache(sCacheName).Clear();
        }
        catch (Exception e)
        {
            Console.WriteLine(e);
        }
    }

    public void put(String sCacheName, IntPtr pKey, int lKey, IntPtr pValue, int lValue)
    {
        try
        {
            byte[] abKey   = toManaged(pKey, lKey);
            byte[] abValue = toManaged(pValue, lValue);
            CacheFactory.GetCache(sCacheName)[abKey] = abValue;
        }
        catch (Exception e)
        {
            Console.WriteLine(e);
        }
    }

    public void get(String sCacheName, IntPtr pKey, int lKey, IntPtr pValue, int lValue)
    {
        try
        {
            byte[] abKey   = toManaged(pKey, lKey);
            byte[] abValue = (byte[]) CacheFactory.GetCache(sCacheName)[abKey];
            toUnmanaged(abValue, pValue, lValue);
        }
        catch (Exception e)
        {
            Console.WriteLine(e);
        }
    }

    public void remove(String sCacheName, IntPtr pKey, int lKey)
    {
        try
        {
            byte[] abKey = toManaged(pKey, lKey);
            CacheFactory.GetCache(sCacheName).Remove(abKey);
        }
        catch (Exception e)
        {
            Console.WriteLine(e);
        }
    }

    byte[] toManaged(IntPtr p, int len)
    {
        byte[] ab = new byte[len];
        Marshal.Copy(p, ab, 0, len);
        return ab;
    }

    void toUnmanaged(byte[] ab, IntPtr p, int len)
    {
        Debug.Assert(ab.Length == len);
        Marshal.Copy(ab, 0, p, len);
    }
}