/*
* client.cpp
*
* Copyright 2001-2007 by Oracle. All rights reserved.
*
* Oracle is a registered trademarks of Oracle Corporation and/or its
* affiliates.
*
* This software is the confidential and proprietary information of Oracle
* Corporation. You shall not disclose such confidential and proprietary
* information and shall use it only in accordance with the terms of the
* license agreement you entered into with Oracle.
*
* This notice may not be removed or altered.
*/
#include "stdafx.h"

#import "..\..\build\CoherenceWrapper.tlb" raw_interfaces_only

using namespace CoherenceWrapper;

typedef struct
{
    int    key;
    double value;
} myvalue;

int _tmain(int argc, _TCHAR* argv[])
{
    CoInitialize(NULL);

    ICoherencePtr pCoherence(__uuidof(Coherence));

    BSTR cacheName = SysAllocString(L"test");

    for(int i = 0; i < 10; i++)
    {
        myvalue val;
        val.key   = i;
        val.value = i + .1;

        // populate the cache
        pCoherence->put(cacheName, (__int64) &i, sizeof(i), (__int64) &val, sizeof(val));

        // read back the value and output it
        myvalue val2;
        pCoherence->get(cacheName, (__int64) &i, sizeof(i), (__int64) &val2, sizeof(val2));
        printf("%d = [%d, %f]\n", i, val2.key, val2.value);
    }

    long size;
    pCoherence->size(cacheName, &size);

    printf("Cache size: %d\n", size);

    return 0;
}