
package com.tangosol.examples.coherence;


import com.tangosol.net.CacheFactory;
import com.tangosol.net.InvocationService;

import com.tangosol.util.Base;

/**
* An Invocation service example (the server part).
*
* Command:
*   java -cp %classpath%;coherence.jar com.tangosol.examples.coherence.InvocationServer
*/
public class InvocationServer
        extends Base
    {
    /**
    * Entry point.
    */
    public static void main(String[] asArgs)
            throws InterruptedException
        {
        InvocationService service = CacheFactory.getInvocationService("Example");
        out("*** Started invocation service on " + service.getCluster().getLocalMember());
        out("\nHit Ctrl-C to stop the server");

        // wait forever
        Thread.sleep(Long.MAX_VALUE);
        }
    }
