/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.examples;

import com.tangosol.net.AbstractInvocable;
import com.tangosol.net.CacheFactory;
import com.tangosol.net.DefaultConfigurableCacheFactory;
import com.tangosol.net.DistributedCacheService;
import com.tangosol.net.Invocable;
import com.tangosol.net.InvocationService;
import com.tangosol.net.cache.LocalCache;
import com.tangosol.net.cache.ReadWriteBackingMap;
import com.tangosol.util.Base;
import com.tangosol.util.Binary;
import com.tangosol.util.ExternalizableHelper;
import com.tangosol.util.SimpleMapEntry;
import com.tangosol.util.comparator.InverseComparator;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;

public class HotKeyAgent
extends AbstractInvocable {
    protected String m_sCacheName;
    protected int m_cMaxEntries;

    public static void main(String[] asArg) {
        if (asArg.length == 0) {
            System.err.println("You must supply at least the cache name.");
            System.err.println("HotKeyAgent cachename [maxEntries 10] [service Management]");
            System.exit(1);
        }
        String sCache = asArg[0];
        int cMax = asArg.length > 1 ? Integer.parseInt(asArg[1]) : 10;
        String sSvc = asArg.length > 2 ? asArg[2] : "Management";
        System.setProperty("tangosol.coherence.distributed.localstorage", "false");
        Set setMembers = ((DistributedCacheService)CacheFactory.getCache((String)sCache).getCacheService()).getStorageEnabledMembers();
        InvocationService svc = (InvocationService)CacheFactory.getCluster().ensureService(sSvc, "Invocation");
        System.out.println("Using " + sSvc + " service to find top " + cMax + " accessed entries from each of " + setMembers.size() + " cache servers");
        String sResult = Result.toString(svc.query((Invocable)new HotKeyAgent(sCache, cMax), setMembers));
        System.out.println(sResult);
    }

    public HotKeyAgent(String sCacheName, int cMax) {
        this.m_sCacheName = sCacheName;
        this.m_cMaxEntries = cMax;
    }

    public void run() {
        String sCacheName = this.m_sCacheName;
        Map mapLocal = ((DefaultConfigurableCacheFactory.Manager)CacheFactory.getCache((String)sCacheName).getCacheService().getBackingMapManager()).getBackingMap(sCacheName);
        if (mapLocal instanceof ReadWriteBackingMap) {
            mapLocal = ((ReadWriteBackingMap)mapLocal).getInternalCache();
        }
        if (!(mapLocal instanceof LocalCache)) {
            throw new RuntimeException("Backing map must be a LocalCache");
        }
        TreeSet<LocalCache.Entry> setTop = new TreeSet<LocalCache.Entry>((Comparator<LocalCache.Entry>)new InverseComparator((Comparator)new TouchComparator()));
        long cTouches = mapLocal.size();
        int cMaxEntries = this.m_cMaxEntries;
        int cMinTouch = Integer.MAX_VALUE;
        Iterator iter = mapLocal.entrySet().iterator();
        while (iter.hasNext()) {
            LocalCache.Entry entry = (LocalCache.Entry)iter.next();
            int cTouch = entry.getTouchCount();
            if (setTop.size() < cMaxEntries) {
                setTop.add(entry);
                if (cTouch < cMinTouch) {
                    cMinTouch = cTouch;
                }
            } else if (cTouch > cMinTouch) {
                setTop.remove(setTop.last());
                setTop.add(entry);
                cMinTouch = ((LocalCache.Entry)setTop.last()).getTouchCount();
            }
            cTouches += (long)cTouch;
        }
        ArrayList<SimpleMapEntry> listTop = new ArrayList<SimpleMapEntry>(cMaxEntries);
        Iterator iter2 = setTop.iterator();
        while (iter2.hasNext()) {
            LocalCache.Entry entry = (LocalCache.Entry)iter2.next();
            listTop.add(new SimpleMapEntry(entry.getKey(), (Object)Base.makeInteger((int)(entry.getTouchCount() + 1))));
        }
        this.setResult(new Result(cTouches, listTop));
    }

    public static class Result
    implements Serializable {
        public long m_cTouches;
        public List m_listTop;

        public Result(long cTouches, List listTop) {
            this.m_cTouches = cTouches;
            this.m_listTop = listTop;
        }

        public String toString() {
            StringBuffer sbResult = new StringBuffer();
            long cTouches = this.m_cTouches;
            Iterator iter = this.m_listTop.iterator();
            while (iter.hasNext()) {
                Map.Entry entry = (Map.Entry)iter.next();
                long lPct = (long)((Integer)entry.getValue()).intValue() * 10000L / cTouches;
                sbResult.append("Key '").append(ExternalizableHelper.fromBinary((Binary)((Binary)entry.getKey()))).append("' accounted for ").append((float)lPct / 100.0f).append("% of cache access for server\n");
            }
            return sbResult.toString();
        }

        public static String toString(Map mapResults) {
            long cTouchesAll = 0L;
            Iterator iter = mapResults.values().iterator();
            while (iter.hasNext()) {
                cTouchesAll += ((Result)iter.next()).m_cTouches;
            }
            StringBuffer sbResult = new StringBuffer();
            Iterator iter2 = mapResults.entrySet().iterator();
            while (iter2.hasNext()) {
                Map.Entry entry = iter2.next();
                Result result = (Result)entry.getValue();
                long lPct = result.m_cTouches * 10000L / cTouchesAll;
                sbResult.append("\nCacheServer ").append(entry.getKey()).append(" handled ").append((float)lPct / 100.0f).append("% of total cache access\n").append(result);
            }
            return sbResult.toString();
        }
    }

    public static class TouchComparator
    implements Comparator {
        public int compare(Object o1, Object o2) {
            int c2;
            LocalCache.Entry e1 = (LocalCache.Entry)o1;
            LocalCache.Entry e2 = (LocalCache.Entry)o2;
            int c1 = e1.getTouchCount();
            return c1 == (c2 = e2.getTouchCount()) ? ((Binary)e1.getKey()).compareTo(e2.getKey()) : c1 - c2;
        }
    }
}

