#!/bin/sh
#############################################################################
## mig805.sh: Change the "libraryURL" link in pre-805 HTML documents, 
## which points to $ORACLE_DOC/index.htm, to point to the 805 and higher 
## libraryURL, which is $ORACLE_DOC/products.htm.
#############################################################################
if [ "$MIG805_DEBUG" ];then set -x;fi

ver=8.0.5.0.0
PRODDEST="$1"		            # ORACLE_DOC 
PRODS="`ls -1 $PRODDEST`"           # dirs in ORACLE_DOC


# Validate ORACLE_DOC

if [ ! -d "$PRODDEST" ]; then
   echo "mig805.sh: Must specify valid directory for ORACLE_DOC."
   exit 1;		
fi



for p in $PRODS; do
 if [ -d $PRODDEST/$p ]; then
 
# Fix book-level links to LibraryURL

   cd $PRODDEST/$p
   if [ -d a* ]; then
      echo Entering $p directory to adjust links...
      BOOKS="`ls -l | grep drw | awk '{print $NF}' | grep '\<[az].....'`"
echo $BOOKS
      for b in $BOOKS; do
         if [ -f $PRODDEST/$p/$b/*.htm ]; then
            HTMS=`ls -1 $PRODDEST/$p/$b/*.htm`
            cd $PRODDEST/$p/$b
            for h in $HTMS; do
               sed 's/\.\.\/\.\.\/index.htm/\.\.\/\.\.\/products.htm/g' $h > $h.tmp
               mv $h.tmp $h
            done
         fi
         echo Finished $b.
      done
   fi

# Fix libraryURL references in product-level HTML index files

   if [ -f $PRODDEST/$p/index.htm ]; then
      cd $PRODDEST/$p
      sed 's/\.\.\/index.htm/\.\.\/products.htm/g' index.htm > index.tmp
      mv index.tmp index.htm
   fi 
 fi
done


exit 0;

