#!/bin/sh
#############################################################################
## crindex.sh: create master HTML index and OIN files from product-specific 
##             and platform-specific partial files
#############################################################################
if [ "$CRINDEX_DEBUG" ];then set -x;fi

ver=8.0.5.0.0
PRODDEST="$1"			# ORACLE_DOC 
PRODINDEX="index"	
ITYPES="htm tre ind"		# product index file types
PRODS="`ls -l $PRODDEST | grep drw | awk '{print $NF}'`"


# Validate ORACLE_DOC
if [ ! -d "$PRODDEST" ];then
   echo "crpindex.sh: Must specify valid directory for ORACLE_DOC."
   exit 1;		
fi


# Rename old products.htm, index.ind, and index.tre files
if [ -r "$PRODDEST/products.htm" ]; then
   mv -f $PRODDEST/products.htm $PRODDEST/products.htmOLD
fi
if [ -r "$PRODDEST/index.tre" ]; then
   mv -f $PRODDEST/index.tre $PRODDEST/index.treOLD
fi
if [ -r "$PRODDEST/index.ind" ]; then
   mv -f $PRODDEST/index.ind $PRODDEST/index.indOLD
fi

# Generate products.htm

if [ -f "$PRODDEST/install/head.htm" ]; then
   cat $PRODDEST/install/head.htm >> $PRODDEST/products.htm
fi
for p in $PRODS; do
  if [ -f "$PRODDEST/install/prdlinks/$p.htm" ]; then
     cat $PRODDEST/install/prdlinks/$p.htm >> $PRODDEST/products.htm
  fi
done
if [ -f "$PRODDEST/install/tail.htm" ]; then
   cat $PRODDEST/install/tail.htm >> $PRODDEST/products.htm
fi

# Generate index.tre

if [ -f "$PRODDEST/install/head.tre" ]; then
   cat $PRODDEST/install/head.tre >> $PRODDEST/index.tre
fi
for p in $PRODS; do
  if [ -f "$PRODDEST/install/prdlinks/$p.tre" ]; then
     cat $PRODDEST/install/prdlinks/$p.tre >> $PRODDEST/index.tre
  fi
done
if [ -f "$PRODDEST/install/tail.tre" ]; then
   cat $PRODDEST/install/tail.tre >> $PRODDEST/index.tre
fi

# Generate index.ind

if [ -f "$PRODDEST/install/head.ind" ]; then
   cat $PRODDEST/install/head.ind >> $PRODDEST/index.ind
fi
for p in $PRODS; do
  if [ -f "$PRODDEST/install/prdlinks/$p.ind" ]; then
     cat $PRODDEST/install/prdlinks/$p.ind >> $PRODDEST/index.ind
  fi
done


for t in $ITYPES; do

# Rename old prod.rel/index files (.htm .tre .ind)
   for p in $PRODS; do
     if [ -f "$PRODDEST/$p/index.$t" ]; then
        mv -f $PRODDEST/$p/index.$t $PRODDEST/$p/index.${t}OLD
     fi 
   done

# Generate <prod.rel>/index files (.htm .tre .ind)
   for p in $PRODS; do
     if [ -d "$PRODDEST/$p/install" ]; then
       if [ -f "$PRODDEST/$p/install/head.$t" ]; then
          cat $PRODDEST/$p/install/head.$t >> $PRODDEST/$p/index.$t
       fi
       cd $PRODDEST/$p/install
       if [ -f $PRODDEST/$p/install/prod*.$t ]; then
         PORTS="`ls -1 prod*.$t | awk -F. '{print $1}'`"
         for k in $PORTS; do
           if [ -f "$PRODDEST/$p/install/$k.$t" ]; then
              cat $PRODDEST/$p/install/$k.$t >> $PRODDEST/$p/index.$t
           fi
         done
       fi
         if [ -f "$PRODDEST/$p/install/tail.$t" ]; then
            cat $PRODDEST/$p/install/tail.$t >> $PRODDEST/$p/index.$t
         fi
     fi
   done

done



exit 0;

