#
# $Header: dcommon.vrf.pp  96/08/17 15:31:57 <unix> $ Copyr (c) 1992 Oracle
#

/* Copyright (c) Oracle Corporation 1992.  All Rights Reserved */

/***************************************************************************
NAME
    dcommon.vrf.pp

FUNCTION
    Performs the following for the documentation for product :
    - Product depenency analysis to determine whether
      to load the product files.

CREATED
    GBARSKAY		08/15/96

MODIFIED 
***************************************************************************/
{mark{mark{
#include <ss_pp.h>
#include <macros.vrf>
    LOG_MSG("Entering dcommon.vrf", "")
    /*
     * String initialization
     */
	
odoc_prompt=nls("odoc_prompt","Enter the pathname for your $ORACLE_DOC directory:");
odoc_content=nls("odoc_content","ORACLE_DOC");
odoc_help=nls("odoc_help", "ORACLE_DOC is a directory where you installed all Pro
duct Documentation.");
odoc_info1=nls("odoc_info1","You must specify $ORACLE_DOC.");
odoc_info6=nls("odoc_info6","You have entered the wrong ORACLE_DOC directory.");
 
/* This needs to be done in case a path different from
   "Install Doc Only" was selected and therefore ORACLE_DOC
   directory is not defined.
*/
 
        {
           test=OD;
        }
        [ 'UNBOUND_VARIABLE:
        {
          if( empty(odoc_list) )
          {
        {
            Oracle_Base=translate("ORACLE_BASE");
        }
        [ 'UNBOUND_ENVIRONMENT_VARIABLE: {
                Oracle_Base=""; }  ]
 
 
    /* Prompt for Oracle Doc directory */
 
    {
      odoc_dflt=translate("ORACLE_DOC");
      if (odoc_dflt == "")
      {
        if(Oracle_Base != "")
           odoc_dflt = "%Oracle_Base%/doc";
        else
           odoc_dflt = "%Oracle_Home%/doc";
      }
    }
    [ 'UNBOUND_ENVIRONMENT_VARIABLE: {
      if(Oracle_Base != "")
         odoc_dflt="%Oracle_Base%/doc";
      else
         odoc_dflt="%Oracle_Home%/doc"; } ]
 
         Oracle_Doc = "";
 
    while (Oracle_Doc == "")
    {
        TEXT_DLG(odoc_prompt, odoc_dflt, odoc_content, odoc_help, "unix.Oracle_Doc", Oracle_Doc )
 
        if (Oracle_Doc == "")
            information_dialog(odoc_info1);
        else
        {
                {make_directory(Oracle_Doc);}
                [ 'INVALID_FILE_NAME, 'PERMISSION_DENIED, 'FILE_NOT_FOUND,
                  'WRITE_ERROR, 'OS_ERROR:
                     information_dialog(instantiate(odoc_info3));
                ]
        }
     }
 
 
                OD = Oracle_Doc;
                add(odoc_list, Oracle_Doc);
          }
          else
                OD= first(odoc_list);
        }
        ]
 

    /* BEGIN */
    product = dcommon;
    src = "%Stage_Home%/dcommon";

#include <pinit.vrf>

    /*
     * Product dependency analysis.
     */
    depend_size= 0;

#include <panlys.vrf>

    add(Load_Product_List, product);
    /*
     * Return total size of files depending upon options selected ...
     */
    TOTAL_SZ(sum(base, instal, htmldoc, oin), depend_size, total_size)

if (is_upgrade)
{
        RM_html = "Removing html documents before an upgrade ... ";
 
        RM(Rm_html, htmldoc)
 
}

    return(total_size);
    LOG_MSG("Leaving dcommon.vrf", "")
}}}
