/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.je.utilint;

import com.sleepycat.je.EnvironmentFailureException;
import com.sleepycat.je.utilint.Stat;
import com.sleepycat.je.utilint.StatDefinition;
import com.sleepycat.je.utilint.StatGroup;
import java.util.concurrent.atomic.AtomicInteger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AtomicIntStat
extends Stat<Integer>
implements Cloneable {
    private AtomicInteger counter = new AtomicInteger(0);

    public AtomicIntStat(StatGroup group, StatDefinition definition) {
        super(group, definition);
    }

    @Override
    public Integer get() {
        return this.counter.get();
    }

    @Override
    public void set(Integer newValue) {
        this.counter.set(newValue);
    }

    public void increment() {
        this.counter.incrementAndGet();
    }

    public void add(int count) {
        this.counter.addAndGet(count);
    }

    @Override
    public void add(Stat<Integer> other) {
        this.counter.addAndGet(other.get());
    }

    @Override
    public void clear() {
        this.counter.set(0);
    }

    public AtomicIntStat copy() {
        try {
            AtomicIntStat ret = (AtomicIntStat)super.clone();
            ret.counter = new AtomicInteger(this.counter.get());
            return ret;
        }
        catch (CloneNotSupportedException unexpected) {
            throw EnvironmentFailureException.unexpectedException(unexpected);
        }
    }

    @Override
    String getFormattedValue() {
        return Stat.FORMAT.format(this.counter.get());
    }
}

