/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.je;

import com.sleepycat.je.Durability;
import com.sleepycat.je.ReplicaConsistencyPolicy;

public class TransactionConfig
implements Cloneable {
    public static final TransactionConfig DEFAULT = new TransactionConfig();
    private boolean sync = false;
    private boolean noSync = false;
    private boolean writeNoSync = false;
    private Durability durability = null;
    private ReplicaConsistencyPolicy consistencyPolicy;
    private boolean noWait = false;
    private boolean readUncommitted = false;
    private boolean readCommitted = false;
    private boolean serializableIsolation = false;

    public Durability getDurabilityFromSync() {
        if (this.sync) {
            return Durability.COMMIT_SYNC;
        }
        if (this.writeNoSync) {
            return Durability.COMMIT_WRITE_NO_SYNC;
        }
        if (this.noSync) {
            return Durability.COMMIT_NO_SYNC;
        }
        return Durability.COMMIT_SYNC;
    }

    public TransactionConfig setSync(boolean sync) {
        TransactionConfig.checkMixedMode(sync, this.noSync, this.writeNoSync, this.durability);
        this.sync = sync;
        return this;
    }

    public boolean getSync() {
        return this.sync;
    }

    public TransactionConfig setNoSync(boolean noSync) {
        TransactionConfig.checkMixedMode(this.sync, noSync, this.writeNoSync, this.durability);
        this.noSync = noSync;
        return this;
    }

    public boolean getNoSync() {
        return this.noSync;
    }

    public TransactionConfig setWriteNoSync(boolean writeNoSync) {
        TransactionConfig.checkMixedMode(this.sync, this.noSync, writeNoSync, this.durability);
        this.writeNoSync = writeNoSync;
        return this;
    }

    public boolean getWriteNoSync() {
        return this.writeNoSync;
    }

    public TransactionConfig setDurability(Durability durability) {
        TransactionConfig.checkMixedMode(this.sync, this.noSync, this.writeNoSync, durability);
        this.durability = durability;
        return this;
    }

    public Durability getDurability() {
        return this.durability;
    }

    void overrideDurability(Durability durability) {
        this.sync = false;
        this.noSync = false;
        this.writeNoSync = false;
        this.durability = durability;
    }

    public TransactionConfig setConsistencyPolicy(ReplicaConsistencyPolicy consistencyPolicy) {
        this.consistencyPolicy = consistencyPolicy;
        return this;
    }

    public ReplicaConsistencyPolicy getConsistencyPolicy() {
        return this.consistencyPolicy;
    }

    public TransactionConfig setNoWait(boolean noWait) {
        this.noWait = noWait;
        return this;
    }

    public boolean getNoWait() {
        return this.noWait;
    }

    public TransactionConfig setReadUncommitted(boolean readUncommitted) {
        this.readUncommitted = readUncommitted;
        return this;
    }

    public boolean getReadUncommitted() {
        return this.readUncommitted;
    }

    public TransactionConfig setReadCommitted(boolean readCommitted) {
        this.readCommitted = readCommitted;
        return this;
    }

    public boolean getReadCommitted() {
        return this.readCommitted;
    }

    public TransactionConfig setSerializableIsolation(boolean serializableIsolation) {
        this.serializableIsolation = serializableIsolation;
        return this;
    }

    public boolean getSerializableIsolation() {
        return this.serializableIsolation;
    }

    public TransactionConfig clone() {
        try {
            return (TransactionConfig)super.clone();
        }
        catch (CloneNotSupportedException willNeverOccur) {
            return null;
        }
    }

    static void checkMixedMode(boolean sync, boolean noSync, boolean writeNoSync, Durability durability) throws IllegalArgumentException {
        if ((sync || noSync || writeNoSync) && durability != null) {
            throw new IllegalArgumentException("Mixed use of deprecated and current durability APIs is not supported");
        }
        if (sync && noSync || sync && writeNoSync || noSync && writeNoSync) {
            throw new IllegalArgumentException("Only one of TxnSync, TxnNoSync, and TxnWriteNoSync can be set.");
        }
    }

    public String toString() {
        return "sync=" + this.sync + "\nnoSync=" + this.noSync + "\nwriteNoSync=" + this.writeNoSync + "\ndurability=" + this.durability + "\nconsistencyPolicy=" + this.consistencyPolicy + "\nnoWait=" + this.noWait + "\nreadUncommitted=" + this.readUncommitted + "\nreadCommitted=" + this.readCommitted + "\nSerializableIsolation=" + this.serializableIsolation + "\n";
    }
}

