/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.je.utilint;

import com.sleepycat.je.EnvironmentFailureException;
import com.sleepycat.je.utilint.StatDefinition;
import com.sleepycat.je.utilint.StatGroup;
import java.text.DecimalFormat;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Stat<T>
implements Cloneable {
    public static final DecimalFormat FORMAT = new DecimalFormat("###,###,###,###,###,###,###");
    protected final StatDefinition definition;

    Stat(StatGroup group, StatDefinition definition) {
        this.definition = definition;
        group.register(this);
    }

    public abstract T get();

    public abstract void set(T var1);

    public abstract void add(Stat<T> var1);

    public abstract void clear();

    public Stat<T> copy() {
        Object o;
        try {
            o = super.clone();
        }
        catch (CloneNotSupportedException unexpected) {
            throw EnvironmentFailureException.unexpectedException((Exception)unexpected);
        }
        return (Stat)o;
    }

    public Stat<T> copyAndClear() {
        Stat<T> newCopy = this.copy();
        this.clear();
        return newCopy;
    }

    public StatDefinition getDefinition() {
        return this.definition;
    }

    abstract String getFormattedValue();

    public String toString() {
        return this.definition.getName() + "=" + this.getFormattedValue();
    }

    public String toStringVerbose() {
        return this.definition.getName() + "=" + this.getFormattedValue() + "\n\t\t" + this.definition.getDescription();
    }
}

