/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.je.util;

import com.sleepycat.je.Database;
import com.sleepycat.je.DatabaseConfig;
import com.sleepycat.je.DatabaseException;
import com.sleepycat.je.DatabaseStats;
import com.sleepycat.je.DbInternal;
import com.sleepycat.je.Environment;
import com.sleepycat.je.JEVersion;
import com.sleepycat.je.StatsConfig;
import com.sleepycat.je.util.DbVerify;
import com.sleepycat.je.utilint.Tracer;
import java.io.File;
import java.io.PrintStream;
import java.util.logging.Level;

class DbStat
extends DbVerify {
    private int progressInterval = 0;

    public static void main(String[] argv) throws DatabaseException {
        DbStat stat = new DbStat();
        stat.parseArgs(argv);
        int ret = 0;
        try {
            if (!stat.stats(System.err)) {
                ret = 1;
            }
        }
        catch (Throwable T) {
            ret = 1;
            T.printStackTrace(System.err);
        }
        try {
            stat.env.close();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        System.exit(ret);
    }

    DbStat() {
    }

    public DbStat(Environment env, String dbName) {
        super(env, dbName, false);
    }

    void parseArgs(String[] argv) {
        int argc = 0;
        int nArgs = argv.length;
        while (argc < nArgs) {
            String thisArg;
            if ((thisArg = argv[argc++]).equals("-V")) {
                System.out.println(JEVersion.CURRENT_VERSION);
                System.exit(0);
                continue;
            }
            if (thisArg.equals("-h")) {
                if (argc < nArgs) {
                    this.envHome = new File(argv[argc++]);
                    continue;
                }
                this.printUsage("-h requires an argument");
                continue;
            }
            if (thisArg.equals("-s")) {
                if (argc < nArgs) {
                    this.dbName = argv[argc++];
                    continue;
                }
                this.printUsage("-s requires an argument");
                continue;
            }
            if (!thisArg.equals("-v")) continue;
            if (argc < nArgs) {
                this.progressInterval = Integer.parseInt(argv[argc++]);
                if (this.progressInterval > 0) continue;
                this.printUsage("-v requires a positive argument");
                continue;
            }
            this.printUsage("-v requires an argument");
        }
        if (this.envHome == null) {
            this.printUsage("-h is a required argument");
        }
        if (this.dbName == null) {
            this.printUsage("-s is a required argument");
        }
    }

    public boolean stats(PrintStream out) throws DatabaseException {
        try {
            this.openEnv();
            Tracer.trace(Level.INFO, DbInternal.envGetEnvironmentImpl(this.env), "DbStat.stats of " + this.dbName + " starting");
            DatabaseConfig dbConfig = new DatabaseConfig();
            dbConfig.setReadOnly(true);
            dbConfig.setAllowCreate(false);
            DbInternal.setUseExistingConfig(dbConfig, true);
            Database db = this.env.openDatabase(null, this.dbName, dbConfig);
            StatsConfig statsConfig = new StatsConfig();
            if (this.progressInterval > 0) {
                statsConfig.setShowProgressInterval(this.progressInterval);
                statsConfig.setShowProgressStream(out);
            }
            DatabaseStats stats = db.getStats(statsConfig);
            out.println(stats);
            db.close();
            Tracer.trace(Level.INFO, DbInternal.envGetEnvironmentImpl(this.env), "DbStat.stats of " + this.dbName + " ending");
        }
        catch (DatabaseException DE) {
            return false;
        }
        return true;
    }
}

