/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.collections;

import com.sleepycat.collections.BaseIterator;
import com.sleepycat.collections.DataCursor;
import com.sleepycat.collections.StoredCollection;
import com.sleepycat.collections.StoredContainer;
import com.sleepycat.compat.DbCompat;
import com.sleepycat.je.DatabaseEntry;
import com.sleepycat.je.DatabaseException;
import com.sleepycat.je.OperationStatus;
import com.sleepycat.util.keyrange.KeyRange;
import java.util.ListIterator;
import java.util.NoSuchElementException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class BlockIterator<E>
implements BaseIterator<E> {
    private StoredCollection<E> coll;
    private boolean writeAllowed;
    private byte[][] keys;
    private byte[][] priKeys;
    private byte[][] values;
    private int nextIndex;
    private int dataIndex;
    private E dataObject;

    BlockIterator(StoredCollection<E> coll, boolean writeAllowed, int blockSize) {
        this.coll = coll;
        this.writeAllowed = writeAllowed;
        this.keys = new byte[blockSize][];
        this.priKeys = coll.isSecondary() ? new byte[blockSize][] : (byte[][])this.keys;
        this.values = new byte[blockSize][];
        this.nextIndex = blockSize;
        this.dataIndex = -1;
        this.dataObject = null;
    }

    private BlockIterator(BlockIterator<E> o) {
        this.coll = o.coll;
        this.writeAllowed = o.writeAllowed;
        this.keys = this.copyArray(o.keys);
        this.priKeys = this.coll.isSecondary() ? this.copyArray(o.priKeys) : this.keys;
        this.values = this.copyArray(o.values);
        this.nextIndex = o.nextIndex;
        this.dataIndex = o.dataIndex;
        this.dataObject = o.dataObject;
    }

    private byte[][] copyArray(byte[][] a) {
        byte[][] b = new byte[a.length][];
        for (int i = 0; i < b.length; ++i) {
            if (a[i] == null) continue;
            b[i] = KeyRange.copyBytes(a[i]);
        }
        return b;
    }

    private boolean isNextAvailable() {
        return this.nextIndex < this.keys.length && this.keys[this.nextIndex] != null;
    }

    private boolean isPrevAvailable() {
        return this.nextIndex > 0 && this.keys[this.nextIndex - 1] != null;
    }

    private int getRecordNumber(int i) {
        if (this.coll.view.btreeRecNumDb) {
            DataCursor cursor;
            block6: {
                cursor = null;
                cursor = new DataCursor(this.coll.view, false);
                if (!this.moveCursor(i, cursor)) break block6;
                int n = cursor.getCurrentRecordNumber();
                Object var5_6 = null;
                this.closeCursor(cursor);
                return n;
            }
            try {
                try {
                    throw new IllegalStateException();
                }
                catch (DatabaseException e) {
                    throw StoredContainer.convertException(e);
                }
            }
            catch (Throwable throwable) {
                Object var5_7 = null;
                this.closeCursor(cursor);
                throw throwable;
            }
        }
        DatabaseEntry entry = new DatabaseEntry(this.keys[i]);
        return DbCompat.getRecordNumber(entry);
    }

    private void makeDataObject() {
        int i = this.dataIndex;
        DatabaseEntry keyEntry = new DatabaseEntry(this.keys[i]);
        DatabaseEntry priKeyEntry = this.keys != this.priKeys ? new DatabaseEntry(this.priKeys[i]) : keyEntry;
        DatabaseEntry valuesEntry = new DatabaseEntry(this.values[i]);
        this.dataObject = this.coll.makeIteratorData(this, keyEntry, priKeyEntry, valuesEntry);
    }

    private void clearSlots() {
        for (int i = 0; i < this.keys.length; ++i) {
            this.keys[i] = null;
            this.priKeys[i] = null;
            this.values[i] = null;
        }
    }

    private void setSlot(int i, DataCursor cursor) {
        this.keys[i] = KeyRange.getByteArray(cursor.getKeyThang());
        if (this.keys != this.priKeys) {
            this.priKeys[i] = KeyRange.getByteArray(cursor.getPrimaryKeyThang());
        }
        this.values[i] = KeyRange.getByteArray(cursor.getValueThang());
    }

    private void insertSlot(int i, DataCursor cursor) {
        if (i < this.keys.length) {
            for (int j = this.keys.length - 1; j > i; --j) {
                this.keys[j] = this.keys[j - 1];
                this.priKeys[j] = this.priKeys[j - 1];
                this.values[j] = this.values[j - 1];
                if (!this.coll.view.recNumRenumber || this.keys[j] == null) continue;
                this.bumpRecordNumber(j);
            }
            ++this.nextIndex;
        } else {
            if (i != this.keys.length) {
                throw new IllegalStateException();
            }
            --i;
            for (int j = 0; j < i; ++j) {
                this.keys[j] = this.keys[j + 1];
                this.priKeys[j] = this.priKeys[j + 1];
                this.values[j] = this.values[j + 1];
            }
        }
        this.setSlot(i, cursor);
        this.dataIndex = -1;
    }

    private void bumpRecordNumber(int i) {
        DatabaseEntry entry = new DatabaseEntry(this.keys[i]);
        DbCompat.setRecordNumber(entry, DbCompat.getRecordNumber(entry) + 1);
        this.keys[i] = entry.getData();
    }

    private void deleteSlot(int i) {
        for (int j = i + 1; j < this.keys.length; ++j) {
            this.keys[j - 1] = this.keys[j];
            this.priKeys[j - 1] = this.priKeys[j];
            this.values[j - 1] = this.values[j];
        }
        int last = this.keys.length - 1;
        this.keys[last] = null;
        this.priKeys[last] = null;
        this.values[last] = null;
        if (this.nextIndex > i) {
            --this.nextIndex;
        }
        this.dataIndex = -1;
    }

    private boolean moveCursor(int i, DataCursor cursor) throws DatabaseException {
        return cursor.repositionExact(this.keys[i], this.priKeys[i], this.values[i], false);
    }

    private void closeCursor(DataCursor cursor) {
        if (cursor != null) {
            try {
                cursor.close();
            }
            catch (DatabaseException e) {
                throw StoredContainer.convertException(e);
            }
        }
    }

    @Override
    public boolean hasNext() {
        if (this.isNextAvailable()) {
            return true;
        }
        DataCursor cursor = null;
        try {
            cursor = new DataCursor(this.coll.view, this.writeAllowed);
            int prev = this.nextIndex - 1;
            boolean found = false;
            if (this.keys[prev] == null) {
                OperationStatus status = cursor.getFirst(false);
                if (status == OperationStatus.SUCCESS) {
                    found = true;
                    this.nextIndex = 0;
                }
            } else {
                int repos = cursor.repositionRange(this.keys[prev], this.priKeys[prev], this.values[prev], false);
                if (repos == 0) {
                    found = true;
                    this.nextIndex = 1;
                    if (this.dataIndex == prev) {
                        this.dataIndex = 0;
                    } else {
                        this.dataIndex = -1;
                        this.dataObject = null;
                    }
                } else if (repos == 1) {
                    found = true;
                    this.nextIndex = 0;
                    this.dataIndex = -1;
                    this.dataObject = null;
                } else if (repos != 2) {
                    throw new IllegalStateException();
                }
            }
            if (found) {
                this.clearSlots();
                int i = 0;
                boolean done = false;
                while (!done) {
                    this.setSlot(i, cursor);
                    if (++i < this.keys.length) {
                        OperationStatus status = this.coll.iterateDuplicates() ? cursor.getNext(false) : cursor.getNextNoDup(false);
                        if (status == OperationStatus.SUCCESS) continue;
                        done = true;
                        continue;
                    }
                    done = true;
                }
            }
            boolean bl = this.isNextAvailable();
            Object var8_11 = null;
            this.closeCursor(cursor);
            return bl;
        }
        catch (DatabaseException e) {
            try {
                throw StoredContainer.convertException(e);
            }
            catch (Throwable throwable) {
                Object var8_12 = null;
                this.closeCursor(cursor);
                throw throwable;
            }
        }
    }

    @Override
    public boolean hasPrevious() {
        if (this.isPrevAvailable()) {
            return true;
        }
        if (!this.isNextAvailable()) {
            return false;
        }
        DataCursor cursor = null;
        try {
            cursor = new DataCursor(this.coll.view, this.writeAllowed);
            int last = this.keys.length - 1;
            int next = this.nextIndex;
            boolean found = false;
            int repos = cursor.repositionRange(this.keys[next], this.priKeys[next], this.values[next], false);
            if (repos == 0 || repos == 1) {
                found = true;
                this.nextIndex = last;
                if (this.dataIndex == next && repos == 0) {
                    this.dataIndex = last;
                } else {
                    this.dataIndex = -1;
                    this.dataObject = null;
                }
            } else if (repos != 2) {
                throw new IllegalStateException();
            }
            if (found) {
                this.clearSlots();
                int i = last;
                boolean done = false;
                while (!done) {
                    this.setSlot(i, cursor);
                    if (--i >= 0) {
                        OperationStatus status = this.coll.iterateDuplicates() ? cursor.getPrev(false) : cursor.getPrevNoDup(false);
                        if (status == OperationStatus.SUCCESS) continue;
                        done = true;
                        continue;
                    }
                    done = true;
                }
            }
            boolean bl = this.isPrevAvailable();
            Object var10_10 = null;
            this.closeCursor(cursor);
            return bl;
        }
        catch (DatabaseException e) {
            try {
                throw StoredContainer.convertException(e);
            }
            catch (Throwable throwable) {
                Object var10_11 = null;
                this.closeCursor(cursor);
                throw throwable;
            }
        }
    }

    @Override
    public E next() {
        if (this.hasNext()) {
            this.dataIndex = this.nextIndex++;
            this.makeDataObject();
            return this.dataObject;
        }
        throw new NoSuchElementException();
    }

    @Override
    public E previous() {
        if (this.hasPrevious()) {
            --this.nextIndex;
            this.dataIndex = this.nextIndex;
            this.makeDataObject();
            return this.dataObject;
        }
        throw new NoSuchElementException();
    }

    @Override
    public int nextIndex() {
        if (!this.coll.view.recNumAccess) {
            throw new UnsupportedOperationException("Record number access not supported");
        }
        return this.hasNext() ? this.getRecordNumber(this.nextIndex) - this.coll.getIndexOffset() : Integer.MAX_VALUE;
    }

    @Override
    public int previousIndex() {
        if (!this.coll.view.recNumAccess) {
            throw new UnsupportedOperationException("Record number access not supported");
        }
        return this.hasPrevious() ? this.getRecordNumber(this.nextIndex - 1) - this.coll.getIndexOffset() : -1;
    }

    @Override
    public void set(E value) {
        if (this.dataObject == null) {
            throw new IllegalStateException();
        }
        if (!this.coll.hasValues()) {
            throw new UnsupportedOperationException();
        }
        DataCursor cursor = null;
        boolean doAutoCommit = this.coll.beginAutoCommit();
        try {
            cursor = new DataCursor(this.coll.view, this.writeAllowed);
            if (!this.moveCursor(this.dataIndex, cursor)) {
                throw new IllegalStateException();
            }
            cursor.putCurrent(value);
            this.setSlot(this.dataIndex, cursor);
            this.coll.closeCursor(cursor);
            this.coll.commitAutoCommit(doAutoCommit);
        }
        catch (Exception e) {
            this.coll.closeCursor(cursor);
            throw this.coll.handleException(e, doAutoCommit);
        }
    }

    @Override
    public void remove() {
        if (this.dataObject == null) {
            throw new IllegalStateException();
        }
        DataCursor cursor = null;
        boolean doAutoCommit = this.coll.beginAutoCommit();
        try {
            cursor = new DataCursor(this.coll.view, this.writeAllowed);
            if (this.moveCursor(this.dataIndex, cursor)) {
                cursor.delete();
                this.deleteSlot(this.dataIndex);
                this.dataObject = null;
                if (this.nextIndex == 0 && this.keys[0] == null) {
                    OperationStatus status;
                    int i;
                    for (i = 0; i < this.keys.length; ++i) {
                        OperationStatus operationStatus = status = this.coll.iterateDuplicates() ? cursor.getNext(false) : cursor.getNextNoDup(false);
                        if (status != OperationStatus.SUCCESS) break;
                        this.setSlot(i, cursor);
                    }
                    if (this.keys[0] == null) {
                        this.nextIndex = this.keys.length;
                        for (i = this.nextIndex - 1; i >= 0; --i) {
                            OperationStatus operationStatus = status = this.coll.iterateDuplicates() ? cursor.getPrev(false) : cursor.getPrevNoDup(false);
                            if (status != OperationStatus.SUCCESS) break;
                            this.setSlot(i, cursor);
                        }
                    }
                }
            } else {
                throw new IllegalStateException();
            }
            this.coll.closeCursor(cursor);
            this.coll.commitAutoCommit(doAutoCommit);
        }
        catch (Exception e) {
            this.coll.closeCursor(cursor);
            throw this.coll.handleException(e, doAutoCommit);
        }
    }

    @Override
    public void add(E value) {
        this.coll.checkIterAddAllowed();
        OperationStatus status = OperationStatus.SUCCESS;
        DataCursor cursor = null;
        boolean doAutoCommit = this.coll.beginAutoCommit();
        try {
            if (this.coll.view.keysRenumbered || !this.coll.areDuplicatesOrdered()) {
                boolean hasPrev = this.hasPrevious();
                if (!hasPrev && !this.hasNext()) {
                    if (this.coll.view.keysRenumbered) {
                        status = this.coll.view.append(value, null, null);
                    } else if (this.coll.view.dupsAllowed && this.coll.view.range.isSingleKey()) {
                        cursor = new DataCursor(this.coll.view, this.writeAllowed);
                        cursor.useRangeKey();
                        status = cursor.putNoDupData(null, value, null, true);
                        this.coll.closeCursor(cursor);
                        cursor = null;
                    } else {
                        throw new IllegalStateException("Collection is empty, cannot add() duplicate");
                    }
                    if (status == OperationStatus.SUCCESS) {
                        this.next();
                        this.dataIndex = this.nextIndex - 1;
                    }
                } else {
                    int insertIndex;
                    cursor = new DataCursor(this.coll.view, this.writeAllowed);
                    int n = insertIndex = hasPrev ? this.nextIndex - 1 : this.nextIndex;
                    if (!this.moveCursor(insertIndex, cursor)) {
                        throw new IllegalStateException();
                    }
                    OperationStatus operationStatus = status = hasPrev ? cursor.putAfter(value) : cursor.putBefore(value);
                    if (status == OperationStatus.SUCCESS) {
                        this.insertSlot(this.nextIndex, cursor);
                    }
                }
            } else {
                cursor = new DataCursor(this.coll.view, this.writeAllowed);
                if (this.coll.view.range.isSingleKey()) {
                    cursor.useRangeKey();
                } else if (this.dataIndex < 0 || !this.moveCursor(this.dataIndex, cursor)) {
                    throw new IllegalStateException();
                }
                status = cursor.putNoDupData(null, value, null, true);
                if (status == OperationStatus.SUCCESS) {
                    this.clearSlots();
                    this.setSlot(0, cursor);
                    this.dataIndex = 0;
                    this.nextIndex = 1;
                }
            }
            if (status == OperationStatus.KEYEXIST) {
                throw new IllegalArgumentException("Duplicate value");
            }
            if (status != OperationStatus.SUCCESS) {
                throw new IllegalArgumentException("Could not insert: " + status);
            }
            this.dataObject = null;
            this.coll.closeCursor(cursor);
            this.coll.commitAutoCommit(doAutoCommit);
        }
        catch (Exception e) {
            this.coll.closeCursor(cursor);
            throw this.coll.handleException(e, doAutoCommit);
        }
    }

    @Override
    public final ListIterator<E> dup() {
        return new BlockIterator<E>(this);
    }

    @Override
    public final boolean isCurrentData(Object currentData) {
        return this.dataObject == currentData;
    }

    @Override
    public final boolean moveToIndex(int index) {
        DataCursor cursor;
        block5: {
            cursor = null;
            cursor = new DataCursor(this.coll.view, this.writeAllowed);
            OperationStatus status = cursor.getSearchKey(index, null, false);
            if (status != OperationStatus.SUCCESS) break block5;
            this.clearSlots();
            this.setSlot(0, cursor);
            this.nextIndex = 0;
            boolean bl = true;
            Object var6_7 = null;
            this.closeCursor(cursor);
            return bl;
        }
        try {
            boolean bl = false;
            Object var6_8 = null;
            this.closeCursor(cursor);
            return bl;
        }
        catch (DatabaseException e) {
            try {
                throw StoredContainer.convertException(e);
            }
            catch (Throwable throwable) {
                Object var6_9 = null;
                this.closeCursor(cursor);
                throw throwable;
            }
        }
    }
}

