/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.je.log;

import com.sleepycat.je.DatabaseException;
import com.sleepycat.je.EnvironmentLockedException;
import com.sleepycat.je.EnvironmentStats;
import com.sleepycat.je.RunRecoveryException;
import com.sleepycat.je.StatsConfig;
import com.sleepycat.je.config.EnvironmentParams;
import com.sleepycat.je.dbi.DbConfigManager;
import com.sleepycat.je.dbi.EnvironmentImpl;
import com.sleepycat.je.latch.Latch;
import com.sleepycat.je.log.ChecksumValidator;
import com.sleepycat.je.log.DbChecksumException;
import com.sleepycat.je.log.FSyncManager;
import com.sleepycat.je.log.FileHandle;
import com.sleepycat.je.log.FileHeader;
import com.sleepycat.je.log.JEFileFilter;
import com.sleepycat.je.log.LogBuffer;
import com.sleepycat.je.log.LogEntryHeader;
import com.sleepycat.je.log.LogEntryType;
import com.sleepycat.je.log.LogException;
import com.sleepycat.je.log.LogFileNotFoundException;
import com.sleepycat.je.log.LogManager;
import com.sleepycat.je.log.entry.LogEntry;
import com.sleepycat.je.log.entry.SingleItemEntry;
import com.sleepycat.je.utilint.DbLsn;
import com.sleepycat.je.utilint.HexFormatter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.nio.channels.OverlappingFileLockException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.Random;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FileManager {
    static boolean IO_EXCEPTION_TESTING_ON_WRITE = false;
    static boolean IO_EXCEPTION_TESTING_ON_READ = false;
    static boolean THROW_RRE_FOR_UNIT_TESTS = false;
    private static final String DEBUG_NAME = FileManager.class.getName();
    private static final boolean DEBUG = false;
    public static long WRITE_COUNT = 0L;
    public static long STOP_ON_WRITE_COUNT = Long.MAX_VALUE;
    public static long N_BAD_WRITES = Long.MAX_VALUE;
    public static boolean THROW_ON_WRITE = false;
    public static final String JE_SUFFIX = ".jdb";
    public static final String DEL_SUFFIX = ".del";
    public static final String BAD_SUFFIX = ".bad";
    private static final String LOCK_FILE = "je.lck";
    static final String[] DEL_SUFFIXES = new String[]{".del"};
    static final String[] JE_SUFFIXES = new String[]{".jdb"};
    private static final String[] JE_AND_DEL_SUFFIXES = new String[]{".jdb", ".del"};
    private boolean syncAtFileEnd = true;
    private EnvironmentImpl envImpl;
    private long maxFileSize;
    private File dbEnvHome;
    private boolean includeDeletedFiles = false;
    private FileCache fileCache;
    private Latch fileCacheLatch;
    private RandomAccessFile lockFile;
    private FileChannel channel;
    private FileLock envLock;
    private FileLock exclLock;
    private boolean readOnly;
    private long currentFileNum;
    private long nextAvailableLsn;
    private long lastUsedLsn;
    private long prevOffset;
    private boolean forceNewFile;
    private long savedCurrentFileNum;
    private long savedNextAvailableLsn;
    private long savedLastUsedLsn;
    private long savedPrevOffset;
    private boolean savedForceNewFile;
    private LogEndFileDescriptor endOfLog;
    private FSyncManager syncManager;
    private Map<Long, Long> perFileLastUsedLsn;
    private boolean useNIO;
    private long chunkedNIOSize = 0L;
    private final boolean useODSYNC;
    public boolean VERIFY_CHECKSUMS = false;
    long lastFileNumberTouched = -1L;
    long lastFileTouchedOffset = 0L;
    private static final long ADJACENT_TRACK_SEEK_DELTA = 0x100000L;
    long nRandomReads = 0L;
    long nRandomWrites = 0L;
    long nSequentialReads = 0L;
    long nSequentialWrites = 0L;
    long nRandomReadBytes = 0L;
    long nRandomWriteBytes = 0L;
    long nSequentialReadBytes = 0L;
    long nSequentialWriteBytes = 0L;
    int nFileOpens = 0;
    public static final boolean RUNRECOVERY_EXCEPTION_TESTING;
    private static String RRET_PROPERTY_NAME;
    private static final int RUNRECOVERY_EXCEPTION_MAX = 100;
    private int runRecoveryExceptionCounter = 0;
    private boolean runRecoveryExceptionThrown = false;
    private Random runRecoveryExceptionRandom = null;

    public FileManager(EnvironmentImpl envImpl, File dbEnvHome, boolean readOnly) throws DatabaseException {
        String stopOnWriteActionProp;
        this.envImpl = envImpl;
        this.dbEnvHome = dbEnvHome;
        this.readOnly = readOnly;
        DbConfigManager configManager = envImpl.getConfigManager();
        this.maxFileSize = configManager.getLong(EnvironmentParams.LOG_FILE_MAX);
        this.useNIO = configManager.getBoolean(EnvironmentParams.LOG_USE_NIO);
        this.chunkedNIOSize = configManager.getLong(EnvironmentParams.LOG_CHUNKED_NIO);
        this.useODSYNC = configManager.getBoolean(EnvironmentParams.LOG_USE_ODSYNC);
        boolean directNIO = configManager.getBoolean(EnvironmentParams.LOG_DIRECT_NIO);
        this.VERIFY_CHECKSUMS = configManager.getBoolean(EnvironmentParams.LOG_VERIFY_CHECKSUMS);
        if (!this.useNIO && (this.chunkedNIOSize > 0L || directNIO)) {
            throw new IllegalArgumentException(EnvironmentParams.LOG_USE_NIO.getName() + " is false and therefore " + EnvironmentParams.LOG_DIRECT_NIO.getName() + " or " + EnvironmentParams.LOG_CHUNKED_NIO.getName() + " may not be used.");
        }
        if (!envImpl.isMemOnly()) {
            if (!dbEnvHome.exists()) {
                throw new LogException("Environment home " + dbEnvHome + " doesn't exist");
            }
            this.lockEnvironment(readOnly, false);
        }
        this.fileCache = new FileCache(configManager);
        this.fileCacheLatch = new Latch(DEBUG_NAME + "_fileCache");
        this.currentFileNum = 0L;
        this.nextAvailableLsn = DbLsn.makeLsn(this.currentFileNum, FileManager.firstLogEntryOffset());
        this.lastUsedLsn = -1L;
        this.perFileLastUsedLsn = new HashMap<Long, Long>();
        this.prevOffset = 0L;
        this.endOfLog = new LogEndFileDescriptor();
        this.forceNewFile = false;
        this.saveLastPosition();
        String stopOnWriteCountProp = System.getProperty("je.debug.stopOnWriteCount");
        if (stopOnWriteCountProp != null) {
            STOP_ON_WRITE_COUNT = Long.parseLong(stopOnWriteCountProp);
        }
        if ((stopOnWriteActionProp = System.getProperty("je.debug.stopOnWriteAction")) != null) {
            if (stopOnWriteActionProp.compareToIgnoreCase("throw") == 0) {
                THROW_ON_WRITE = true;
            } else if (stopOnWriteActionProp.compareToIgnoreCase("stop") == 0) {
                THROW_ON_WRITE = false;
            } else {
                throw new DatabaseException("unknown value for je.debugStopOnWriteAction: " + stopOnWriteActionProp);
            }
        }
        this.syncManager = new FSyncManager(envImpl);
    }

    public void setLastPosition(long nextAvailableLsn, long lastUsedLsn, long prevOffset) {
        this.lastUsedLsn = lastUsedLsn;
        this.perFileLastUsedLsn.put(DbLsn.getFileNumber(lastUsedLsn), lastUsedLsn);
        this.nextAvailableLsn = nextAvailableLsn;
        this.currentFileNum = DbLsn.getFileNumber(this.nextAvailableLsn);
        this.prevOffset = prevOffset;
        this.saveLastPosition();
    }

    void saveLastPosition() {
        this.savedNextAvailableLsn = this.nextAvailableLsn;
        this.savedLastUsedLsn = this.lastUsedLsn;
        this.savedPrevOffset = this.prevOffset;
        this.savedForceNewFile = this.forceNewFile;
        this.savedCurrentFileNum = this.currentFileNum;
    }

    void restoreLastPosition() {
        this.nextAvailableLsn = this.savedNextAvailableLsn;
        this.lastUsedLsn = this.savedLastUsedLsn;
        this.prevOffset = this.savedPrevOffset;
        this.forceNewFile = this.savedForceNewFile;
        this.currentFileNum = this.savedCurrentFileNum;
    }

    public void setSyncAtFileEnd(boolean sync) {
        this.syncAtFileEnd = sync;
    }

    public Long getFirstFileNum() {
        return this.getFileNum(true);
    }

    public boolean getReadOnly() {
        return this.readOnly;
    }

    public Long getLastFileNum() {
        return this.getFileNum(false);
    }

    public long getCurrentFileNum() {
        return this.currentFileNum;
    }

    public boolean isFileValid(long fileNum) {
        if (fileNum == this.currentFileNum || this.envImpl.isMemOnly()) {
            return true;
        }
        String fileName = this.getFullFileName(fileNum, JE_SUFFIX);
        File file = new File(fileName);
        return file.exists();
    }

    public void setIncludeDeletedFiles(boolean includeDeletedFiles) {
        this.includeDeletedFiles = includeDeletedFiles;
    }

    public Long[] getAllFileNumbers() {
        String[] names = this.listFiles(JE_SUFFIXES);
        Long[] nums = new Long[names.length];
        for (int i = 0; i < nums.length; ++i) {
            nums[i] = this.getNumFromName(names[i]);
        }
        return nums;
    }

    public Long getFollowingFileNum(long currentFileNum, boolean forward) {
        Object[] names = this.listFiles(JE_SUFFIXES);
        String searchName = FileManager.getFileName(currentFileNum, JE_SUFFIX);
        int foundIdx = Arrays.binarySearch(names, searchName);
        boolean foundTarget = false;
        if (foundIdx >= 0) {
            foundIdx = forward ? ++foundIdx : --foundIdx;
        } else {
            foundIdx = Math.abs(foundIdx + 1);
            if (!forward) {
                --foundIdx;
            }
        }
        if (forward && foundIdx < names.length) {
            foundTarget = true;
        } else if (!forward && foundIdx > -1) {
            foundTarget = true;
        }
        if (foundTarget) {
            return this.getNumFromName((String)names[foundIdx]);
        }
        return null;
    }

    public boolean filesExist() {
        String[] names = this.listFiles(JE_SUFFIXES);
        return names.length != 0;
    }

    private Long getFileNum(boolean first) {
        String[] names = this.listFiles(JE_SUFFIXES);
        if (names.length == 0) {
            return null;
        }
        int index = 0;
        if (!first) {
            index = names.length - 1;
        }
        return this.getNumFromName(names[index]);
    }

    public Long getNumFromName(String fileName) {
        String fileNumber = fileName.substring(0, fileName.indexOf("."));
        return Long.parseLong(fileNumber, 16);
    }

    public String[] listFiles(String[] suffixes) {
        Object[] fileNames = this.dbEnvHome.list(new JEFileFilter(suffixes));
        if (fileNames != null) {
            Arrays.sort(fileNames);
        } else {
            fileNames = new String[]{};
        }
        return fileNames;
    }

    public String[] listFiles(long minFileNumber, long maxFileNumber) {
        Object[] fileNames = this.dbEnvHome.list(new JEFileFilter(JE_SUFFIXES, minFileNumber, maxFileNumber));
        Arrays.sort(fileNames);
        return fileNames;
    }

    public static String[] listFiles(File envDirFile, String[] suffixes) {
        Object[] fileNames = envDirFile.list(new JEFileFilter(suffixes));
        if (fileNames != null) {
            Arrays.sort(fileNames);
        } else {
            fileNames = new String[]{};
        }
        return fileNames;
    }

    String[] getFullFileNames(long fileNum) {
        if (this.includeDeletedFiles) {
            int nSuffixes = JE_AND_DEL_SUFFIXES.length;
            String[] ret = new String[nSuffixes];
            for (int i = 0; i < nSuffixes; ++i) {
                ret[i] = this.getFullFileName(FileManager.getFileName(fileNum, JE_AND_DEL_SUFFIXES[i]));
            }
            return ret;
        }
        return new String[]{this.getFullFileName(FileManager.getFileName(fileNum, JE_SUFFIX))};
    }

    public static void removeFiles(File envFile) throws IOException {
        File[] targetFiles = envFile.listFiles();
        for (int i = 0; i < targetFiles.length; ++i) {
            boolean done;
            File f = targetFiles[i];
            if (f.isDirectory() || f.getName().equals("je.properties") || (done = targetFiles[i].delete())) continue;
            System.out.println("Warning, couldn't delete " + targetFiles[i] + " out of " + targetFiles[targetFiles.length - 1]);
        }
    }

    public String getFullFileName(long fileNum, String suffix) {
        return this.getFullFileName(FileManager.getFileName(fileNum, suffix));
    }

    private String getFullFileName(String fileName) {
        return this.dbEnvHome + File.separator + fileName;
    }

    public static String getFileName(long fileNum, String suffix) {
        return FileManager.getFileNumberString(fileNum) + suffix;
    }

    private static String getFileNumberString(long fileNum) {
        return HexFormatter.formatLong(fileNum).substring(10);
    }

    public void renameFile(long fileNum, String newSuffix) throws DatabaseException, IOException {
        int repeatNum = 0;
        boolean renamed = false;
        while (!renamed) {
            String newName;
            File targetFile;
            String generation = "";
            if (repeatNum > 0) {
                generation = "." + repeatNum;
            }
            if ((targetFile = new File(newName = this.getFullFileName(FileManager.getFileName(fileNum, newSuffix) + generation))).exists()) {
                ++repeatNum;
                continue;
            }
            String oldFileName = this.getFullFileNames(fileNum)[0];
            this.clearFileCache(fileNum);
            File oldFile = new File(oldFileName);
            if (oldFile.renameTo(targetFile)) {
                renamed = true;
                continue;
            }
            throw new LogException("Couldn't rename " + oldFileName + " to " + newName);
        }
    }

    public void deleteFile(long fileNum) throws DatabaseException, IOException {
        String fileName = this.getFullFileNames(fileNum)[0];
        this.clearFileCache(fileNum);
        File file = new File(fileName);
        boolean done = file.delete();
        if (!done) {
            throw new LogException("Couldn't delete " + file);
        }
    }

    public int getFileLogVersion(long fileNum) throws LogException, DatabaseException {
        FileHandle handle = this.getFileHandle(fileNum);
        int logVersion = handle.getLogVersion();
        handle.release();
        return logVersion;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    FileHandle getFileHandle(long fileNum) throws LogException, DatabaseException {
        fileId = fileNum;
        fileHandle = null;
        while (true) {
            fileHandle = FileCache.access$000(this.fileCache, fileId);
            newHandle = false;
            if (fileHandle == null) {
                if (EnvironmentImpl.getFairLatches()) {
                    this.fileCacheLatch.acquire();
                    try {
                        fileHandle = FileCache.access$000(this.fileCache, fileId);
                        if (fileHandle != null) ** GOTO lbl28
                        newHandle = true;
                        fileHandle = this.addFileHandle(fileId);
                    }
                    finally {
                        this.fileCacheLatch.release();
                    }
                } else {
                    var6_6 = this.fileCacheLatch;
                    synchronized (var6_6) {
                        fileHandle = FileCache.access$000(this.fileCache, fileId);
                        if (fileHandle == null) {
                            newHandle = true;
                            fileHandle = this.addFileHandle(fileId);
                        }
                    }
                }
            }
lbl28:
            // 5 sources

            if (newHandle) {
                success = false;
                try {
                    this.openFileHandle(fileHandle, FileMode.READ_MODE);
                    success = true;
                }
                finally {
                    if (!success) {
                        fileHandle.release();
                        try {
                            this.clearFileCache(fileNum);
                        }
                        catch (IOException e) {
                            throw new DatabaseException(e);
                        }
                    }
                }
            }
            fileHandle.latch();
            if (fileHandle.getFile() != null) break;
            fileHandle.release();
        }
        return fileHandle;
    }

    private FileHandle addFileHandle(Long fileNum) throws DatabaseException {
        FileHandle fileHandle = new FileHandle(fileNum, FileManager.getFileNumberString(fileNum));
        this.fileCache.add(fileNum, fileHandle);
        fileHandle.latch();
        return fileHandle;
    }

    private FileMode getAppropriateReadWriteMode() {
        if (this.useODSYNC) {
            return FileMode.READWRITE_ODSYNC_MODE;
        }
        return FileMode.READWRITE_MODE;
    }

    private FileHandle makeFileHandle(long fileNum, FileMode mode) throws DatabaseException {
        FileHandle fileHandle = new FileHandle(fileNum, FileManager.getFileNumberString(fileNum));
        this.openFileHandle(fileHandle, mode);
        return fileHandle;
    }

    private void openFileHandle(FileHandle fileHandle, FileMode mode) throws DatabaseException {
        ++this.nFileOpens;
        long fileNum = fileHandle.getFileNum();
        String[] fileNames = this.getFullFileNames(fileNum);
        RandomAccessFile newFile = null;
        String fileName = null;
        try {
            FileNotFoundException FNFE = null;
            for (int i = 0; i < fileNames.length; ++i) {
                fileName = fileNames[i];
                try {
                    newFile = new RandomAccessFile(fileName, mode.getModeValue());
                    break;
                }
                catch (FileNotFoundException e) {
                    if (FNFE != null) continue;
                    FNFE = e;
                    continue;
                }
            }
            if (newFile == null) {
                throw FNFE;
            }
            int logVersion = 6;
            if (newFile.length() == 0L) {
                if (mode.isWritable()) {
                    long lastLsn = DbLsn.longToLsn(this.perFileLastUsedLsn.remove(fileNum - 1L));
                    long headerPrevOffset = 0L;
                    if (lastLsn != -1L) {
                        headerPrevOffset = DbLsn.getFileOffset(lastLsn);
                    }
                    FileHeader fileHeader = new FileHeader(fileNum, headerPrevOffset);
                    this.writeFileHeader(newFile, fileName, fileHeader, fileNum);
                }
            } else {
                logVersion = this.readAndValidateFileHeader(newFile, fileName, fileNum);
            }
            fileHandle.init(newFile, logVersion);
        }
        catch (FileNotFoundException e) {
            throw new LogFileNotFoundException("Couldn't open file " + fileName + ": " + e.getMessage());
        }
        catch (DbChecksumException e) {
            this.closeFileInErrorCase(newFile);
            throw new DbChecksumException(this.envImpl, "Couldn't open file " + fileName, e);
        }
        catch (Throwable t) {
            this.closeFileInErrorCase(newFile);
            throw new DatabaseException("Couldn't open file " + fileName + ": " + t, t);
        }
    }

    private void closeFileInErrorCase(RandomAccessFile file) {
        try {
            if (file != null) {
                file.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private int readAndValidateFileHeader(RandomAccessFile file, String fileName, long fileNum) throws DatabaseException, IOException {
        LogManager logManager = this.envImpl.getLogManager();
        LogEntry headerEntry = logManager.getLogEntry(DbLsn.makeLsn(fileNum, 0L), file);
        FileHeader header = (FileHeader)headerEntry.getMainItem();
        return header.validate(fileName, fileNum);
    }

    private void writeFileHeader(RandomAccessFile file, String fileName, FileHeader header, long fileNum) throws DatabaseException {
        int bytesWritten;
        this.envImpl.checkIfInvalid();
        if (this.envImpl.mayNotWrite()) {
            return;
        }
        SingleItemEntry headerLogEntry = new SingleItemEntry(LogEntryType.LOG_FILE_HEADER, header);
        ByteBuffer headerBuf = this.envImpl.getLogManager().putIntoBuffer(headerLogEntry, 0L);
        try {
            if (RUNRECOVERY_EXCEPTION_TESTING) {
                this.generateRunRecoveryException(file, headerBuf, 0L, fileNum);
            }
            bytesWritten = this.writeToFile(file, headerBuf, 0L, fileNum);
            if (fileNum > this.savedCurrentFileNum) {
                long lsnAfterHeader = DbLsn.makeLsn(fileNum, bytesWritten);
                if (DbLsn.compareTo(this.nextAvailableLsn, lsnAfterHeader) < 0) {
                    this.nextAvailableLsn = lsnAfterHeader;
                }
                this.lastUsedLsn = DbLsn.makeLsn(fileNum, bytesWritten);
                this.prevOffset = bytesWritten;
                this.forceNewFile = false;
                this.currentFileNum = fileNum;
                this.saveLastPosition();
            }
        }
        catch (ClosedChannelException e) {
            throw new RunRecoveryException(this.envImpl, "Channel closed, may be due to thread interrupt", e);
        }
        catch (IOException e) {
            throw new RunRecoveryException(this.envImpl, "IOException during write: " + e);
        }
        if (bytesWritten != headerLogEntry.getSize() + 14) {
            throw new LogException("File " + fileName + " was created with an incomplete header. Only " + bytesWritten + " bytes were written.");
        }
    }

    long getFileHeaderPrevOffset(long fileNum) throws IOException, DatabaseException {
        LogEntry headerEntry = this.envImpl.getLogManager().getLogEntry(DbLsn.makeLsn(fileNum, 0L));
        FileHeader header = (FileHeader)headerEntry.getMainItem();
        return header.getLastEntryInPrevFileOffset();
    }

    long getPrevEntryOffset() {
        return this.prevOffset;
    }

    boolean bumpLsn(long size) {
        this.saveLastPosition();
        boolean flippedFiles = false;
        if (this.forceNewFile || DbLsn.getFileOffset(this.nextAvailableLsn) + size > this.maxFileSize) {
            this.forceNewFile = false;
            ++this.currentFileNum;
            if (this.lastUsedLsn != -1L) {
                this.perFileLastUsedLsn.put(DbLsn.getFileNumber(this.lastUsedLsn), this.lastUsedLsn);
            }
            this.prevOffset = 0L;
            this.lastUsedLsn = DbLsn.makeLsn(this.currentFileNum, FileManager.firstLogEntryOffset());
            flippedFiles = true;
        } else {
            this.prevOffset = this.lastUsedLsn == -1L ? 0L : DbLsn.getFileOffset(this.lastUsedLsn);
            this.lastUsedLsn = this.nextAvailableLsn;
        }
        this.nextAvailableLsn = DbLsn.makeLsn(DbLsn.getFileNumber(this.lastUsedLsn), DbLsn.getFileOffset(this.lastUsedLsn) + size);
        return flippedFiles;
    }

    void writeLogBuffer(LogBuffer fullBuffer) throws DatabaseException {
        this.envImpl.checkIfInvalid();
        if (this.envImpl.mayNotWrite()) {
            return;
        }
        long firstLsn = fullBuffer.getFirstLsn();
        if (firstLsn != -1L) {
            RandomAccessFile file = this.endOfLog.getWritableFile(DbLsn.getFileNumber(firstLsn));
            ByteBuffer data = fullBuffer.getDataBuffer();
            try {
                assert (fullBuffer.getRewriteAllowed() || DbLsn.getFileOffset(firstLsn) >= file.length() || file.length() == (long)FileManager.firstLogEntryOffset()) : "FileManager would overwrite non-empty file 0x" + Long.toHexString(DbLsn.getFileNumber(firstLsn)) + " lsnOffset=0x" + Long.toHexString(DbLsn.getFileOffset(firstLsn)) + " fileLength=0x" + Long.toHexString(file.length());
                if (IO_EXCEPTION_TESTING_ON_WRITE) {
                    throw new IOException("generated for testing (write)");
                }
                if (RUNRECOVERY_EXCEPTION_TESTING) {
                    this.generateRunRecoveryException(file, data, DbLsn.getFileOffset(firstLsn), DbLsn.getFileNumber(firstLsn));
                }
                this.writeToFile(file, data, DbLsn.getFileOffset(firstLsn), DbLsn.getFileNumber(firstLsn));
            }
            catch (ClosedChannelException e) {
                throw new RunRecoveryException(this.envImpl, "File closed, may be due to thread interrupt", e);
            }
            catch (IOException IOE) {
                if (!IO_EXCEPTION_TESTING_ON_WRITE || THROW_RRE_FOR_UNIT_TESTS) {
                    throw new RunRecoveryException(this.envImpl, "IOE during write", IOE);
                }
                this.abortCommittedTxns(data);
                try {
                    if (IO_EXCEPTION_TESTING_ON_WRITE) {
                        throw new IOException("generated for testing (write)");
                    }
                    this.writeToFile(file, data, DbLsn.getFileOffset(firstLsn), DbLsn.getFileNumber(firstLsn));
                }
                catch (IOException IOE2) {
                    fullBuffer.setRewriteAllowed();
                    throw new DatabaseException(IOE2);
                }
            }
            assert (EnvironmentImpl.maybeForceYield());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int writeToFile(RandomAccessFile file, ByteBuffer data, long destOffset, long fileNum) throws IOException, DatabaseException {
        int totalBytesWritten = 0;
        if (this.useNIO) {
            FileChannel chan = file.getChannel();
            if (this.chunkedNIOSize > 0L) {
                ByteBuffer useData = data.duplicate();
                int originalLimit = useData.limit();
                useData.limit(useData.position());
                while (useData.limit() < originalLimit) {
                    this.bumpWriteCount("nio write");
                    useData.limit((int)Math.min((long)useData.limit() + this.chunkedNIOSize, (long)originalLimit));
                    int bytesWritten = chan.write(useData, destOffset);
                    destOffset += (long)bytesWritten;
                    totalBytesWritten += bytesWritten;
                }
            } else {
                totalBytesWritten = chan.write(data, destOffset);
            }
        } else {
            this.bumpWriteCount("write");
            RandomAccessFile randomAccessFile = file;
            synchronized (randomAccessFile) {
                assert (data.hasArray());
                int pos = data.position();
                int size = data.limit() - pos;
                if (this.lastFileNumberTouched == fileNum && Math.abs(destOffset - this.lastFileTouchedOffset) < 0x100000L) {
                    ++this.nSequentialWrites;
                    this.nSequentialWriteBytes += (long)size;
                } else {
                    ++this.nRandomWrites;
                    this.nRandomWriteBytes += (long)size;
                }
                if (this.VERIFY_CHECKSUMS) {
                    this.verifyChecksums(data, destOffset, "pre-write");
                }
                file.seek(destOffset);
                file.write(data.array(), pos + data.arrayOffset(), size);
                if (this.VERIFY_CHECKSUMS) {
                    file.seek(destOffset);
                    file.read(data.array(), pos + data.arrayOffset(), size);
                    this.verifyChecksums(data, destOffset, "post-write");
                }
                data.position(pos + size);
                totalBytesWritten = size;
                this.lastFileNumberTouched = fileNum;
                this.lastFileTouchedOffset = destOffset + (long)size;
            }
        }
        return totalBytesWritten;
    }

    private void bumpWriteCount(String debugMsg) throws IOException {
        if (++WRITE_COUNT >= STOP_ON_WRITE_COUNT && WRITE_COUNT < STOP_ON_WRITE_COUNT + N_BAD_WRITES) {
            if (THROW_ON_WRITE) {
                throw new IOException("IOException generated for testing: " + WRITE_COUNT + " " + debugMsg);
            }
            Runtime.getRuntime().halt(255);
        }
    }

    void readFromFile(RandomAccessFile file, ByteBuffer readBuffer, long offset, long fileNo) throws DatabaseException, IOException {
        try {
            this.readFromFileInternal(file, readBuffer, offset, fileNo);
        }
        catch (IOException IOE) {
            throw new RunRecoveryException(this.envImpl, (Throwable)IOE);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readFromFileInternal(RandomAccessFile file, ByteBuffer readBuffer, long offset, long fileNum) throws DatabaseException, IOException {
        if (this.useNIO) {
            FileChannel chan = file.getChannel();
            if (this.chunkedNIOSize > 0L) {
                int readLength = readBuffer.limit();
                long currentPosition = offset;
                while (readBuffer.position() < readLength) {
                    readBuffer.limit((int)Math.min((long)readBuffer.limit() + this.chunkedNIOSize, (long)readLength));
                    if (IO_EXCEPTION_TESTING_ON_READ) {
                        throw new IOException("generated for testing (read)");
                    }
                    int bytesRead = chan.read(readBuffer, currentPosition);
                    if (bytesRead >= 1) {
                        currentPosition += (long)bytesRead;
                        continue;
                    }
                    break;
                }
            } else {
                if (IO_EXCEPTION_TESTING_ON_READ) {
                    throw new IOException("generated for testing (read)");
                }
                chan.read(readBuffer, offset);
            }
        } else {
            RandomAccessFile randomAccessFile = file;
            synchronized (randomAccessFile) {
                assert (readBuffer.hasArray());
                int pos = readBuffer.position();
                int size = readBuffer.limit() - pos;
                if (this.lastFileNumberTouched == fileNum && Math.abs(offset - this.lastFileTouchedOffset) < 0x100000L) {
                    ++this.nSequentialReads;
                    this.nSequentialReadBytes += (long)size;
                } else {
                    ++this.nRandomReads;
                    this.nRandomReadBytes += (long)size;
                }
                file.seek(offset);
                if (IO_EXCEPTION_TESTING_ON_READ) {
                    throw new IOException("generated for testing (read)");
                }
                int bytesRead = file.read(readBuffer.array(), pos + readBuffer.arrayOffset(), size);
                if (bytesRead > 0) {
                    readBuffer.position(pos + bytesRead);
                }
                this.lastFileNumberTouched = fileNum;
                this.lastFileTouchedOffset = offset + (long)bytesRead;
            }
        }
    }

    private void verifyChecksums(ByteBuffer entryBuffer, long lsn, String comment) {
        int curPos = entryBuffer.position();
        try {
            while (entryBuffer.remaining() > 0) {
                int recStartPos = entryBuffer.position();
                LogEntryHeader header = new LogEntryHeader(this.envImpl, entryBuffer, false);
                this.verifyChecksum(entryBuffer, header, lsn, comment);
                entryBuffer.position(recStartPos + header.getSize() + header.getItemSize());
            }
        }
        catch (DatabaseException DCE) {
            System.err.println("ChecksumException: (" + comment + ") " + DCE);
            System.err.println("start stack trace");
            DCE.printStackTrace(System.err);
            System.err.println("end stack trace");
        }
        entryBuffer.position(curPos);
    }

    private void verifyChecksum(ByteBuffer entryBuffer, LogEntryHeader header, long lsn, String comment) throws DbChecksumException {
        ChecksumValidator validator = null;
        validator = new ChecksumValidator();
        int headerSizeMinusChecksum = header.getSizeMinusChecksum();
        int itemStart = entryBuffer.position();
        entryBuffer.position(itemStart - headerSizeMinusChecksum);
        validator.update(this.envImpl, entryBuffer, headerSizeMinusChecksum, false);
        entryBuffer.position(itemStart);
        int itemSize = header.getItemSize();
        if (entryBuffer.remaining() < itemSize) {
            System.err.println("Couldn't verify checksum (" + comment + ")");
            return;
        }
        validator.update(this.envImpl, entryBuffer, itemSize, false);
        validator.validate(this.envImpl, header.getChecksum(), lsn);
    }

    private void abortCommittedTxns(ByteBuffer data) throws DatabaseException {
        byte commitType = LogEntryType.LOG_TXN_COMMIT.getTypeNum();
        data.position(0);
        while (data.remaining() > 0) {
            int recStartPos = data.position();
            LogEntryHeader header = new LogEntryHeader(this.envImpl, data, false);
            if (header.getType() == commitType) {
                header.convertCommitToAbort(data);
            }
            data.position(recStartPos + header.getSize() + header.getItemSize());
        }
        data.position(0);
    }

    void syncLogEnd() throws DatabaseException {
        try {
            this.endOfLog.force();
        }
        catch (IOException e) {
            throw new RunRecoveryException(this.envImpl, "IOException during fsync", e);
        }
    }

    void syncLogEndAndFinishFile() throws DatabaseException, IOException {
        if (this.syncAtFileEnd) {
            this.syncLogEnd();
        }
        this.endOfLog.close();
    }

    void groupSync() throws DatabaseException {
        this.syncManager.fsync();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() throws IOException, DatabaseException {
        if (EnvironmentImpl.getFairLatches()) {
            this.fileCacheLatch.acquire();
            try {
                this.fileCache.clear();
            }
            finally {
                this.fileCacheLatch.release();
            }
        }
        Latch latch = this.fileCacheLatch;
        synchronized (latch) {
            this.fileCache.clear();
        }
        this.endOfLog.close();
    }

    public void close() throws IOException, DatabaseException {
        if (this.envLock != null) {
            this.envLock.release();
        }
        if (this.exclLock != null) {
            this.exclLock.release();
        }
        if (this.channel != null) {
            this.channel.close();
        }
        if (this.lockFile != null) {
            this.lockFile.close();
            this.lockFile = null;
        }
    }

    public boolean lockEnvironment(boolean readOnly, boolean exclusive) throws DatabaseException {
        try {
            if (this.checkEnvHomePermissions(readOnly)) {
                return true;
            }
            if (this.lockFile == null) {
                this.lockFile = new RandomAccessFile(new File(this.dbEnvHome, LOCK_FILE), FileMode.READWRITE_MODE.getModeValue());
            }
            this.channel = this.lockFile.getChannel();
            boolean throwIt = false;
            try {
                if (exclusive) {
                    this.exclLock = this.channel.tryLock(1L, 1L, false);
                    return this.exclLock != null;
                }
                this.envLock = readOnly ? this.channel.tryLock(1L, 1L, true) : this.channel.tryLock(0L, 1L, false);
                if (this.envLock == null) {
                    throwIt = true;
                }
            }
            catch (OverlappingFileLockException e) {
                throwIt = true;
            }
            if (throwIt) {
                this.close();
                throw new EnvironmentLockedException("A je.lck file exists in " + this.dbEnvHome.getAbsolutePath() + " The environment can not be locked for " + (readOnly ? "shared" : "single writer") + " access.");
            }
        }
        catch (IOException IOE) {
            throw new LogException(IOE.toString());
        }
        return true;
    }

    public void releaseExclusiveLock() throws DatabaseException {
        try {
            if (this.exclLock != null) {
                this.exclLock.release();
            }
        }
        catch (IOException IOE) {
            throw new DatabaseException(IOE);
        }
    }

    public boolean checkEnvHomePermissions(boolean readOnly) throws DatabaseException {
        boolean envDirIsReadOnly;
        boolean bl = envDirIsReadOnly = !this.dbEnvHome.canWrite();
        if (envDirIsReadOnly && !readOnly) {
            throw new DatabaseException("The Environment directory " + this.dbEnvHome.getAbsolutePath() + " is not writable, but the " + "Environment was opened for read-write access.");
        }
        return envDirIsReadOnly;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void truncateLog(long fileNum, long offset) throws IOException, DatabaseException {
        FileHandle handle = this.makeFileHandle(fileNum, this.getAppropriateReadWriteMode());
        RandomAccessFile file = handle.getFile();
        try {
            file.getChannel().truncate(offset);
        }
        finally {
            file.close();
        }
        if (handle.isOldHeaderVersion()) {
            this.forceNewFile = true;
        }
    }

    void forceNewLogFile() {
        this.forceNewFile = true;
    }

    public static int firstLogEntryOffset() {
        return FileHeader.entrySize() + 14;
    }

    public long getNextLsn() {
        return this.nextAvailableLsn;
    }

    public long getLastUsedLsn() {
        return this.lastUsedLsn;
    }

    public long getNFSyncs() {
        return this.syncManager.getNFSyncs();
    }

    public long getNFSyncRequests() {
        return this.syncManager.getNFSyncRequests();
    }

    public long getNFSyncTimeouts() {
        return this.syncManager.getNTimeouts();
    }

    void loadStats(StatsConfig config, EnvironmentStats stats) throws DatabaseException {
        this.syncManager.loadStats(config, stats);
        stats.setNRandomReads(this.nRandomReads);
        stats.setNRandomWrites(this.nRandomWrites);
        stats.setNSequentialReads(this.nSequentialReads);
        stats.setNSequentialWrites(this.nSequentialWrites);
        stats.setNRandomReadBytes(this.nRandomReadBytes);
        stats.setNRandomWriteBytes(this.nRandomWriteBytes);
        stats.setNSequentialReadBytes(this.nSequentialReadBytes);
        stats.setNSequentialWriteBytes(this.nSequentialWriteBytes);
        stats.setNFileOpens(this.nFileOpens);
        stats.setNOpenFiles(this.fileCache.size());
        if (config.getClear()) {
            this.nRandomReads = 0L;
            this.nRandomWrites = 0L;
            this.nSequentialReads = 0L;
            this.nSequentialWrites = 0L;
            this.nRandomReadBytes = 0L;
            this.nRandomWriteBytes = 0L;
            this.nSequentialReadBytes = 0L;
            this.nSequentialWriteBytes = 0L;
            this.nFileOpens = 0;
        }
    }

    Set<Long> getCacheKeys() {
        return this.fileCache.getCacheKeys();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void clearFileCache(long fileNum) throws IOException, DatabaseException {
        if (EnvironmentImpl.getFairLatches()) {
            this.fileCacheLatch.acquire();
            try {
                this.fileCache.remove(fileNum);
            }
            finally {
                this.fileCacheLatch.release();
            }
        }
        Latch latch = this.fileCacheLatch;
        synchronized (latch) {
            this.fileCache.remove(fileNum);
        }
    }

    private void generateRunRecoveryException(RandomAccessFile file, ByteBuffer data, long destOffset, long fileNum) throws DatabaseException, IOException {
        if (this.runRecoveryExceptionThrown) {
            try {
                throw new Exception("Write after RunRecoveryException");
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        ++this.runRecoveryExceptionCounter;
        if (this.runRecoveryExceptionCounter >= 100) {
            this.runRecoveryExceptionCounter = 0;
        }
        if (this.runRecoveryExceptionRandom == null) {
            this.runRecoveryExceptionRandom = new Random(System.currentTimeMillis());
        }
        if (this.runRecoveryExceptionCounter == this.runRecoveryExceptionRandom.nextInt(100)) {
            int len = this.runRecoveryExceptionRandom.nextInt(data.remaining());
            if (len > 0) {
                byte[] a = new byte[len];
                data.get(a, 0, len);
                ByteBuffer buf = ByteBuffer.wrap(a);
                this.writeToFile(file, buf, destOffset, fileNum);
            }
            this.runRecoveryExceptionThrown = true;
            throw new RunRecoveryException(this.envImpl, "Randomly generated for testing");
        }
    }

    static {
        RRET_PROPERTY_NAME = "je.run.recovery.testing";
        RUNRECOVERY_EXCEPTION_TESTING = System.getProperty(RRET_PROPERTY_NAME) != null;
    }

    class LogEndFileDescriptor {
        private RandomAccessFile endOfLogRWFile = null;
        private RandomAccessFile endOfLogSyncFile = null;
        private Object fsyncFileSynchronizer = new Object();

        LogEndFileDescriptor() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        RandomAccessFile getWritableFile(long fileNumber) throws RunRecoveryException {
            try {
                if (this.endOfLogRWFile == null) {
                    this.endOfLogRWFile = FileManager.this.makeFileHandle(fileNumber, FileManager.this.getAppropriateReadWriteMode()).getFile();
                    Object object = this.fsyncFileSynchronizer;
                    synchronized (object) {
                        this.endOfLogSyncFile = FileManager.this.makeFileHandle(fileNumber, FileManager.this.getAppropriateReadWriteMode()).getFile();
                    }
                }
                return this.endOfLogRWFile;
            }
            catch (Exception e) {
                throw new RunRecoveryException(FileManager.this.envImpl, (Throwable)e);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void force() throws DatabaseException, IOException {
            Object object = this.fsyncFileSynchronizer;
            synchronized (object) {
                RandomAccessFile file = this.endOfLogSyncFile;
                if (file != null) {
                    FileManager.this.bumpWriteCount("fsync");
                    FileChannel channel = file.getChannel();
                    try {
                        channel.force(false);
                    }
                    catch (ClosedChannelException e) {
                        throw new RunRecoveryException(FileManager.this.envImpl, "Channel closed, may be due to thread interrupt", e);
                    }
                    assert (EnvironmentImpl.maybeForceYield());
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void close() throws IOException {
            IOException firstException = null;
            if (this.endOfLogRWFile != null) {
                RandomAccessFile file = this.endOfLogRWFile;
                this.endOfLogRWFile = null;
                try {
                    file.close();
                }
                catch (IOException e) {
                    firstException = e;
                }
            }
            Object object = this.fsyncFileSynchronizer;
            synchronized (object) {
                if (this.endOfLogSyncFile != null) {
                    RandomAccessFile file = this.endOfLogSyncFile;
                    this.endOfLogSyncFile = null;
                    file.close();
                }
                if (firstException != null) {
                    throw firstException;
                }
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class FileCache {
        private Map<Long, FileHandle> fileMap = new Hashtable<Long, FileHandle>();
        private LinkedList<Long> fileList = new LinkedList();
        private int fileCacheSize;

        FileCache(DbConfigManager configManager) throws DatabaseException {
            this.fileCacheSize = configManager.getInt(EnvironmentParams.LOG_FILE_CACHE_SIZE);
        }

        private FileHandle get(Long fileId) {
            return this.fileMap.get(fileId);
        }

        private void add(Long fileId, FileHandle fileHandle) throws DatabaseException {
            if (this.fileList.size() >= this.fileCacheSize) {
                Iterator iter = this.fileList.iterator();
                while (iter.hasNext()) {
                    Long evictId = (Long)iter.next();
                    FileHandle evictTarget = this.fileMap.get(evictId);
                    if (!evictTarget.latchNoWait()) continue;
                    try {
                        this.fileMap.remove(evictId);
                        iter.remove();
                        evictTarget.close();
                        break;
                    }
                    catch (IOException e) {
                        throw new DatabaseException(e);
                    }
                    finally {
                        evictTarget.release();
                    }
                }
            }
            this.fileList.add(fileId);
            this.fileMap.put(fileId, fileHandle);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void remove(long fileNum) throws IOException, DatabaseException {
            Iterator iter = this.fileList.iterator();
            while (iter.hasNext()) {
                Long evictId = (Long)iter.next();
                if (evictId != fileNum) continue;
                FileHandle evictTarget = this.fileMap.get(evictId);
                try {
                    evictTarget.latch();
                    this.fileMap.remove(evictId);
                    iter.remove();
                    evictTarget.close();
                }
                finally {
                    evictTarget.release();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void clear() throws IOException, DatabaseException {
            Iterator<FileHandle> iter = this.fileMap.values().iterator();
            while (iter.hasNext()) {
                FileHandle fileHandle = iter.next();
                try {
                    fileHandle.latch();
                    fileHandle.close();
                    iter.remove();
                }
                finally {
                    fileHandle.release();
                }
            }
            this.fileMap.clear();
            this.fileList.clear();
        }

        private Set<Long> getCacheKeys() {
            return this.fileMap.keySet();
        }

        private int size() {
            return this.fileMap.size();
        }

        static /* synthetic */ FileHandle access$000(FileCache x0, Long x1) {
            return x0.get(x1);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum FileMode {
        READ_MODE("r", false),
        READWRITE_MODE("rw", true),
        READWRITE_ODSYNC_MODE("rwd", true),
        READWRITE_OSYNC_MODE("rws", true);

        private String fileModeValue;
        private boolean isWritable;

        private FileMode(String fileModeValue, boolean isWritable) {
            this.fileModeValue = fileModeValue;
            this.isWritable = isWritable;
        }

        public String getModeValue() {
            return this.fileModeValue;
        }

        public boolean isWritable() {
            return this.isWritable;
        }
    }
}

