/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.je;

import com.sleepycat.je.DatabaseException;
import com.sleepycat.je.dbi.DatabaseImpl;
import java.util.Arrays;
import java.util.Comparator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DatabaseConfig
implements Cloneable {
    public static final DatabaseConfig DEFAULT = new DatabaseConfig();
    private boolean allowCreate = false;
    private boolean exclusiveCreate = false;
    private boolean transactional = false;
    private boolean readOnly = false;
    private boolean duplicatesAllowed = false;
    private boolean deferredWrite = false;
    private boolean temporary = false;
    private boolean keyPrefixingEnabled = false;
    private boolean replicated = true;
    private int nodeMax;
    private int nodeMaxDupTree;
    private Comparator<byte[]> btreeComparator = null;
    private Comparator<byte[]> duplicateComparator = null;
    private boolean btreeComparatorByClassName = false;
    private boolean duplicateComparatorByClassName = false;
    private boolean overrideBtreeComparator = false;
    private boolean overrideDupComparator = false;
    private boolean useExistingConfig = false;

    public void setAllowCreate(boolean allowCreate) {
        this.allowCreate = allowCreate;
    }

    public boolean getAllowCreate() {
        return this.allowCreate;
    }

    public void setExclusiveCreate(boolean exclusiveCreate) {
        this.exclusiveCreate = exclusiveCreate;
    }

    public boolean getExclusiveCreate() {
        return this.exclusiveCreate;
    }

    public void setSortedDuplicates(boolean duplicatesAllowed) {
        this.duplicatesAllowed = duplicatesAllowed;
    }

    public boolean getSortedDuplicates() {
        return this.duplicatesAllowed;
    }

    public boolean getKeyPrefixing() {
        return this.keyPrefixingEnabled;
    }

    public void setKeyPrefixing(boolean keyPrefixingEnabled) {
        this.keyPrefixingEnabled = keyPrefixingEnabled;
    }

    public void setTransactional(boolean transactional) {
        this.transactional = transactional;
    }

    public boolean getTransactional() {
        return this.transactional;
    }

    public void setReadOnly(boolean readOnly) {
        this.readOnly = readOnly;
    }

    public boolean getReadOnly() {
        return this.readOnly;
    }

    public void setNodeMaxEntries(int nodeMaxEntries) {
        this.nodeMax = nodeMaxEntries;
    }

    public void setNodeMaxDupTreeEntries(int nodeMaxDupTreeEntries) {
        this.nodeMaxDupTree = nodeMaxDupTreeEntries;
    }

    public int getNodeMaxEntries() {
        return this.nodeMax;
    }

    public int getNodeMaxDupTreeEntries() {
        return this.nodeMaxDupTree;
    }

    public void setBtreeComparator(Comparator<byte[]> btreeComparator) {
        this.btreeComparator = this.validateComparator(btreeComparator, "Btree");
        this.btreeComparatorByClassName = false;
    }

    public void setBtreeComparator(Class<? extends Comparator<byte[]>> btreeComparatorClass) {
        this.btreeComparator = this.validateComparator(btreeComparatorClass, "Btree");
        this.btreeComparatorByClassName = true;
    }

    public Comparator<byte[]> getBtreeComparator() {
        return this.btreeComparator;
    }

    public boolean getBtreeComparatorByClassName() {
        return this.btreeComparatorByClassName;
    }

    public void setOverrideBtreeComparator(boolean override) {
        this.overrideBtreeComparator = override;
    }

    public boolean getOverrideBtreeComparator() {
        return this.overrideBtreeComparator;
    }

    public void setDuplicateComparator(Comparator<byte[]> duplicateComparator) {
        this.duplicateComparator = this.validateComparator(duplicateComparator, "Duplicate");
        this.duplicateComparatorByClassName = false;
    }

    public void setDuplicateComparator(Class<? extends Comparator<byte[]>> duplicateComparatorClass) {
        this.duplicateComparator = this.validateComparator(duplicateComparatorClass, "Duplicate");
        this.duplicateComparatorByClassName = true;
    }

    public Comparator<byte[]> getDuplicateComparator() {
        return this.duplicateComparator;
    }

    public boolean getDuplicateComparatorByClassName() {
        return this.duplicateComparatorByClassName;
    }

    public void setOverrideDuplicateComparator(boolean override) {
        this.overrideDupComparator = override;
    }

    public boolean getOverrideDuplicateComparator() {
        return this.overrideDupComparator;
    }

    public void setTemporary(boolean temporary) {
        this.temporary = temporary;
    }

    public boolean getTemporary() {
        return this.temporary;
    }

    public void setDeferredWrite(boolean deferredWrite) {
        this.deferredWrite = deferredWrite;
    }

    public boolean getDeferredWrite() {
        return this.deferredWrite;
    }

    void setBtreeComparatorInternal(Comparator<byte[]> comparator, boolean byClassName) {
        this.btreeComparator = comparator;
        this.btreeComparatorByClassName = byClassName;
    }

    void setDuplicateComparatorInternal(Comparator<byte[]> comparator, boolean byClassName) {
        this.duplicateComparator = comparator;
        this.duplicateComparatorByClassName = byClassName;
    }

    void setUseExistingConfig(boolean useExistingConfig) {
        this.useExistingConfig = useExistingConfig;
    }

    boolean getUseExistingConfig() {
        return this.useExistingConfig;
    }

    void setReplicated(boolean replicated) {
        this.replicated = replicated;
    }

    boolean getReplicated() {
        return this.replicated;
    }

    public DatabaseConfig cloneConfig() {
        try {
            return (DatabaseConfig)super.clone();
        }
        catch (CloneNotSupportedException willNeverOccur) {
            return null;
        }
    }

    void validate(DatabaseConfig config) throws DatabaseException {
        if (config == null) {
            config = DEFAULT;
        }
        boolean txnMatch = config.transactional == this.transactional;
        boolean roMatch = config.readOnly == this.readOnly;
        boolean sdMatch = config.duplicatesAllowed == this.duplicatesAllowed;
        boolean dwMatch = config.getDeferredWrite() == this.deferredWrite;
        boolean btCmpMatch = true;
        if (config.overrideBtreeComparator) {
            btCmpMatch = this.btreeComparator == null ? config.btreeComparator == null : (config.btreeComparatorByClassName != this.btreeComparatorByClassName ? false : (this.btreeComparatorByClassName ? this.btreeComparator.getClass() == config.btreeComparator.getClass() : Arrays.equals(DatabaseImpl.objectToBytes(this.btreeComparator, "Btree"), DatabaseImpl.objectToBytes(config.btreeComparator, "Btree"))));
        }
        boolean dtCmpMatch = true;
        if (config.overrideDupComparator) {
            dtCmpMatch = this.duplicateComparator == null ? config.duplicateComparator == null : (config.duplicateComparatorByClassName != this.duplicateComparatorByClassName ? false : (this.duplicateComparatorByClassName ? this.duplicateComparator.getClass() == config.duplicateComparator.getClass() : Arrays.equals(DatabaseImpl.objectToBytes(this.duplicateComparator, "Duplicate"), DatabaseImpl.objectToBytes(config.duplicateComparator, "Duplicate"))));
        }
        if (txnMatch && roMatch && sdMatch && dwMatch && btCmpMatch && dtCmpMatch) {
            return;
        }
        String message = this.genDatabaseConfigMismatchMessage(config, txnMatch, roMatch, sdMatch, dwMatch, btCmpMatch, dtCmpMatch);
        throw new DatabaseException(message);
    }

    private String genDatabaseConfigMismatchMessage(DatabaseConfig config, boolean txnMatch, boolean roMatch, boolean sdMatch, boolean dwMatch, boolean btCmpMatch, boolean dtCmpMatch) {
        StringBuffer ret = new StringBuffer("The following DatabaseConfig parameters for the\ncached Database do not match the parameters for the\nrequested Database:\n");
        if (!txnMatch) {
            ret.append(" Transactional\n");
        }
        if (!roMatch) {
            ret.append(" Read-Only\n");
        }
        if (!sdMatch) {
            ret.append(" Sorted Duplicates\n");
        }
        if (!dwMatch) {
            ret.append(" Deferred Write");
        }
        if (!btCmpMatch) {
            ret.append(" Btree Comparator\n");
        }
        if (!dtCmpMatch) {
            ret.append(" Duplicate Comparator\n");
        }
        return ret.toString();
    }

    private Comparator<byte[]> validateComparator(Comparator<byte[]> comparator, String type) throws IllegalArgumentException {
        if (comparator == null) {
            return null;
        }
        try {
            return DatabaseImpl.instantiateComparator(comparator, type);
        }
        catch (DatabaseException e) {
            throw new IllegalArgumentException(type + " comparator is not valid: " + e.getMessage() + "\nThe comparator object must be serializable.");
        }
    }

    private Comparator<byte[]> validateComparator(Class<? extends Comparator<byte[]>> comparatorClass, String type) throws IllegalArgumentException {
        if (comparatorClass == null) {
            return null;
        }
        if (!Comparator.class.isAssignableFrom(comparatorClass)) {
            throw new IllegalArgumentException(comparatorClass.getName() + " is is not valid as a " + type + " comparator because it does not " + " implement java.util.Comparator.");
        }
        try {
            return DatabaseImpl.instantiateComparator(comparatorClass, type);
        }
        catch (DatabaseException e) {
            throw new IllegalArgumentException(type + " comparator is not valid: " + e.getMessage() + "\nPerhaps you have not implemented a zero-parameter " + "constructor for the comparator or the comparator class " + "cannot be found.");
        }
    }

    void validateForNewDb() throws DatabaseException {
        if (this.readOnly) {
            throw new DatabaseException("DatabaseConfig.setReadOnly() must be set to false when creating a Database");
        }
        if (this.transactional && this.deferredWrite) {
            throw new DatabaseException("deferredWrite mode is not yet supported for transactional databases");
        }
    }

    boolean persistentEquals(DatabaseConfig other) {
        if (this.duplicatesAllowed != other.duplicatesAllowed) {
            return false;
        }
        if (this.temporary != other.temporary) {
            return false;
        }
        if (this.replicated != other.replicated) {
            return false;
        }
        if (this.nodeMax != other.nodeMax) {
            return false;
        }
        if (this.nodeMaxDupTree != other.nodeMaxDupTree) {
            return false;
        }
        if (this.btreeComparator == null && other.btreeComparator != null || this.btreeComparator != null && other.btreeComparator == null) {
            return false;
        }
        if (this.btreeComparator != null && this.btreeComparator.getClass() != other.btreeComparator.getClass()) {
            return false;
        }
        if (this.duplicateComparator == null && other.duplicateComparator != null || this.duplicateComparator != null && other.duplicateComparator == null) {
            return false;
        }
        return this.duplicateComparator == null || this.duplicateComparator.getClass() == other.duplicateComparator.getClass();
    }
}

