/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.persist.impl;

import com.sleepycat.persist.evolve.Converter;
import com.sleepycat.persist.impl.Catalog;
import com.sleepycat.persist.impl.Enhanced;
import com.sleepycat.persist.impl.EntityInput;
import com.sleepycat.persist.impl.EntityOutput;
import com.sleepycat.persist.impl.Evolver;
import com.sleepycat.persist.impl.Reader;
import com.sleepycat.persist.impl.RecordInput;
import com.sleepycat.persist.impl.RecordOutput;
import com.sleepycat.persist.impl.SimpleCatalog;
import com.sleepycat.persist.model.ClassMetadata;
import com.sleepycat.persist.model.EntityMetadata;
import com.sleepycat.persist.raw.RawField;
import com.sleepycat.persist.raw.RawObject;
import com.sleepycat.persist.raw.RawType;
import java.io.Serializable;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Format
implements Reader,
RawType,
Serializable {
    private static final long serialVersionUID = 545633644568489850L;
    static final int ID_NULL = 0;
    static final int ID_OBJECT = 1;
    static final int ID_BOOL = 2;
    static final int ID_BOOL_W = 3;
    static final int ID_BYTE = 4;
    static final int ID_BYTE_W = 5;
    static final int ID_SHORT = 6;
    static final int ID_SHORT_W = 7;
    static final int ID_INT = 8;
    static final int ID_INT_W = 9;
    static final int ID_LONG = 10;
    static final int ID_LONG_W = 11;
    static final int ID_FLOAT = 12;
    static final int ID_FLOAT_W = 13;
    static final int ID_DOUBLE = 14;
    static final int ID_DOUBLE_W = 15;
    static final int ID_CHAR = 16;
    static final int ID_CHAR_W = 17;
    static final int ID_STRING = 18;
    static final int ID_BIGINT = 19;
    static final int ID_BIGDEC = 20;
    static final int ID_DATE = 21;
    static final int ID_NUMBER = 22;
    static final int ID_SIMPLE_MIN = 2;
    static final int ID_SIMPLE_MAX = 21;
    static final int ID_PREDEFINED = 30;
    private int id;
    private String className;
    private Reader reader;
    private Format superFormat;
    private Format latestFormat;
    private Format previousFormat;
    private Set<String> supertypes;
    private boolean deleted;
    private boolean unused;
    private transient Catalog catalog;
    private transient Class type;
    private transient Format proxiedFormat;
    private transient boolean initialized;

    static boolean isPredefined(Format format) {
        return format.getId() <= 30;
    }

    Format(Class type) {
        this(type.getName());
        this.type = type;
        this.addSupertypes();
    }

    Format(String className) {
        this.className = className;
        this.latestFormat = this;
        this.supertypes = new HashSet<String>();
    }

    void migrateFromBeta(Map<String, Format> formatMap) {
        if (this.latestFormat == null) {
            this.latestFormat = this;
        }
    }

    final boolean isNew() {
        return this.id == 0;
    }

    final Catalog getCatalog() {
        return this.catalog;
    }

    final int getId() {
        return this.id;
    }

    final void setId(int id) {
        this.id = id;
    }

    final Class getType() {
        return this.type;
    }

    final Class getExistingType() {
        if (this.type == null) {
            try {
                this.type = SimpleCatalog.classForName(this.className);
            }
            catch (ClassNotFoundException e) {
                throw new IllegalStateException(e);
            }
        }
        return this.type;
    }

    final Reader getReader() {
        return this.reader;
    }

    final void setReader(Reader reader) {
        this.reader = reader;
    }

    final Format getSuperFormat() {
        return this.superFormat;
    }

    final void setSuperFormat(Format superFormat) {
        this.superFormat = superFormat;
    }

    final Format getProxiedFormat() {
        return this.proxiedFormat;
    }

    final void setProxiedFormat(Format proxiedFormat) {
        this.proxiedFormat = proxiedFormat;
    }

    final Format getLatestVersion() {
        return this.latestFormat;
    }

    public final Format getPreviousVersion() {
        return this.previousFormat;
    }

    final void setLatestVersion(Format newFormat) {
        if (this.latestFormat == this) {
            newFormat.previousFormat = this;
        }
        this.latestFormat = newFormat;
    }

    final boolean isDeleted() {
        return this.deleted;
    }

    final void setDeleted(boolean deleted) {
        this.deleted = deleted;
    }

    final void setUnused(boolean unused) {
        this.unused = unused;
    }

    void setEvolveNeeded(boolean needed) {
        throw new UnsupportedOperationException();
    }

    boolean getEvolveNeeded() {
        throw new UnsupportedOperationException();
    }

    final boolean isInitialized() {
        return this.initialized;
    }

    final void initializeIfNeeded(Catalog catalog) {
        if (!this.initialized) {
            this.initialized = true;
            this.catalog = catalog;
            if (this.latestFormat == null) {
                this.latestFormat = this;
            }
            if (this.reader == null) {
                this.reader = this;
            }
            if (this.type == null && this.isCurrentVersion() && (this.isSimple() || !catalog.isRawAccess())) {
                this.getExistingType();
            }
            this.initialize(catalog);
            this.reader.initializeReader(catalog, this);
        }
    }

    @Override
    public void initializeReader(Catalog catalog, Format oldFormat) {
    }

    private void addSupertypes() {
        this.addInterfaces(this.type);
        for (Class stype = this.type.getSuperclass(); stype != null && stype != Object.class; stype = stype.getSuperclass()) {
            this.supertypes.add(stype.getName());
            this.addInterfaces(stype);
        }
    }

    private void addInterfaces(Class cls) {
        Class<?>[] interfaces;
        for (Class<?> iface : interfaces = cls.getInterfaces()) {
            if (iface == Enhanced.class) continue;
            this.supertypes.add(iface.getName());
            this.addInterfaces(iface);
        }
    }

    @Override
    public String getClassName() {
        return this.className;
    }

    @Override
    public int getVersion() {
        ClassMetadata meta = this.getClassMetadata();
        if (meta != null) {
            return meta.getVersion();
        }
        return 0;
    }

    @Override
    public Format getSuperType() {
        return this.superFormat;
    }

    @Override
    public boolean isSimple() {
        return false;
    }

    @Override
    public boolean isPrimitive() {
        return false;
    }

    @Override
    public boolean isEnum() {
        return false;
    }

    @Override
    public List<String> getEnumConstants() {
        return null;
    }

    @Override
    public boolean isArray() {
        return false;
    }

    @Override
    public int getDimensions() {
        return 0;
    }

    @Override
    public Format getComponentType() {
        return null;
    }

    @Override
    public Map<String, RawField> getFields() {
        return null;
    }

    boolean isAssignableTo(Format format) {
        if (this.proxiedFormat != null) {
            return this.proxiedFormat.isAssignableTo(format);
        }
        return format == this || format.id == 1 || this.supertypes.contains(format.className);
    }

    Format getWrapperFormat() {
        return null;
    }

    boolean isEntity() {
        return false;
    }

    boolean isModelClass() {
        return false;
    }

    ClassMetadata getClassMetadata() {
        return null;
    }

    EntityMetadata getEntityMetadata() {
        return null;
    }

    Format getEntityFormat() {
        return null;
    }

    abstract boolean evolve(Format var1, Evolver var2);

    boolean evolveMetadata(Format newFormat, Converter converter, Evolver evolver) {
        return true;
    }

    final boolean isCurrentVersion() {
        return this.latestFormat == this && !this.deleted;
    }

    final boolean isSameClass(Format other) {
        return this.latestFormat == other.latestFormat;
    }

    abstract void initialize(Catalog var1);

    abstract void collectRelatedFormats(Catalog var1, Map<String, Format> var2);

    abstract Object newArray(int var1);

    @Override
    public abstract Object newInstance(EntityInput var1, boolean var2);

    @Override
    public abstract Object readObject(Object var1, EntityInput var2, boolean var3);

    abstract void writeObject(Object var1, EntityOutput var2, boolean var3);

    abstract void skipContents(RecordInput var1);

    Format skipToSecKey(RecordInput input, String keyName) {
        throw new UnsupportedOperationException(this.toString());
    }

    void copySecKey(RecordInput input, RecordOutput output) {
        throw new UnsupportedOperationException(this.toString());
    }

    void copySecMultiKey(RecordInput input, Format keyFormat, Set results) {
        throw new UnsupportedOperationException(this.toString());
    }

    boolean nullifySecKey(Catalog catalog, Object entity, String keyName, Object keyElement) {
        throw new UnsupportedOperationException(this.toString());
    }

    boolean isPriKeyNullOrZero(Object o, boolean rawAccess) {
        throw new UnsupportedOperationException(this.toString());
    }

    void writePriKey(Object o, EntityOutput output, boolean rawAccess) {
        throw new UnsupportedOperationException(this.toString());
    }

    @Override
    public void readPriKey(Object o, EntityInput input, boolean rawAccess) {
        throw new UnsupportedOperationException(this.toString());
    }

    Object convertRawObject(Catalog catalog, boolean rawAccess, RawObject rawObject, IdentityHashMap converted) {
        throw new UnsupportedOperationException(this.toString());
    }

    public String toString() {
        return "[RawType class: " + this.getClassName() + " version: " + this.getVersion() + " internal: " + this.getClass().getName() + (this.reader != null ? " reader: " + this.reader.getClass().getName() : "") + ']';
    }
}

