/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.je.cleaner;

import com.sleepycat.je.DatabaseException;
import com.sleepycat.je.cleaner.LNInfo;
import com.sleepycat.je.cleaner.UtilizationProfile;
import com.sleepycat.je.dbi.DatabaseId;
import com.sleepycat.je.tree.LN;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;

public class FileSelector {
    private SortedSet toBeCleanedFiles = new TreeSet();
    private Set beingCleanedFiles;
    private Set cleanedFiles = new HashSet();
    private LinkedList cleanedDeferredWriteDbs = new LinkedList();
    private Set checkpointedFiles = new HashSet();
    private Set fullyProcessedFiles = new HashSet();
    private Set safeToDeleteFiles = new HashSet();
    private Map pendingLNs = new HashMap();
    private Set pendingDBs = new HashSet();
    private boolean anyPendingDuringCheckpoint;
    private Set lowUtilizationFiles = Collections.EMPTY_SET;
    static final /* synthetic */ boolean $assertionsDisabled;

    FileSelector() {
        this.beingCleanedFiles = new HashSet();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Long selectFileForCleaning(UtilizationProfile profile, boolean forceCleaning, boolean calcLowUtilizationFiles, int maxBatchFiles) throws DatabaseException {
        TreeSet availableFiles;
        FileSelector fileSelector;
        HashSet newLowUtilizationFiles;
        HashSet hashSet = newLowUtilizationFiles = calcLowUtilizationFiles ? new HashSet() : null;
        while (true) {
            Long fileNum;
            if (maxBatchFiles > 0) {
                FileSelector fileSelector2 = this;
                synchronized (fileSelector2) {
                    if (this.toBeCleanedFiles.size() >= maxBatchFiles) {
                        break;
                    }
                }
            }
            if ((fileNum = profile.getBestFileForCleaning(this, forceCleaning, newLowUtilizationFiles)) == null) break;
            fileSelector = this;
            synchronized (fileSelector) {
                this.toBeCleanedFiles.add(fileNum);
            }
        }
        if (newLowUtilizationFiles != null) {
            this.lowUtilizationFiles = newLowUtilizationFiles;
        }
        fileSelector = this;
        synchronized (fileSelector) {
            availableFiles = new TreeSet(this.toBeCleanedFiles);
        }
        Long file = profile.getCheapestFileToClean(availableFiles);
        if (file != null) {
            FileSelector fileSelector3 = this;
            synchronized (fileSelector3) {
                this.toBeCleanedFiles.remove(file);
                this.beingCleanedFiles.add(file);
            }
        }
        return file;
    }

    synchronized boolean isFileCleaningInProgress(Long file) {
        return this.toBeCleanedFiles.contains(file) || this.beingCleanedFiles.contains(file) || this.cleanedFiles.contains(file) || this.checkpointedFiles.contains(file) || this.fullyProcessedFiles.contains(file) || this.safeToDeleteFiles.contains(file);
    }

    synchronized void putBackFileForCleaning(Long fileNum) {
        this.toBeCleanedFiles.add(fileNum);
        this.beingCleanedFiles.remove(fileNum);
    }

    synchronized void addCleanedFile(Long fileNum, Set deferredWriteDbs) {
        this.cleanedFiles.add(fileNum);
        this.cleanedDeferredWriteDbs.addAll(deferredWriteDbs);
        this.beingCleanedFiles.remove(fileNum);
    }

    Set getLowUtilizationFiles() {
        return this.lowUtilizationFiles;
    }

    synchronized Set getMustBeCleanedFiles() {
        HashSet set = new HashSet(this.toBeCleanedFiles);
        set.addAll(this.beingCleanedFiles);
        return set;
    }

    synchronized int getBacklog() {
        return this.toBeCleanedFiles.size();
    }

    synchronized CheckpointStartCleanerState getFilesAtCheckpointStart() {
        this.anyPendingDuringCheckpoint = !this.pendingLNs.isEmpty() || !this.pendingDBs.isEmpty();
        CheckpointStartCleanerState info = new CheckpointStartCleanerState(this.cleanedFiles, this.fullyProcessedFiles, this.cleanedDeferredWriteDbs);
        return info;
    }

    synchronized void updateFilesAtCheckpointEnd(CheckpointStartCleanerState info) {
        if (!info.isEmpty()) {
            Set previouslyProcessedFiles;
            Set previouslyCleanedFiles = info.getCleanedFiles();
            if (previouslyCleanedFiles != null) {
                if (this.anyPendingDuringCheckpoint) {
                    this.checkpointedFiles.addAll(previouslyCleanedFiles);
                } else {
                    this.safeToDeleteFiles.addAll(previouslyCleanedFiles);
                }
                this.cleanedFiles.removeAll(previouslyCleanedFiles);
            }
            if ((previouslyProcessedFiles = info.getFullyProcessedFiles()) != null) {
                this.safeToDeleteFiles.addAll(previouslyProcessedFiles);
                this.fullyProcessedFiles.removeAll(previouslyProcessedFiles);
            }
            int previousSize = this.cleanedDeferredWriteDbs.size();
            int numDbsSyncedByCheckpoint = info.getDeferredWriteDbsSize();
            for (int i = 0; i < numDbsSyncedByCheckpoint; ++i) {
                this.cleanedDeferredWriteDbs.removeFirst();
            }
            if (!$assertionsDisabled && this.cleanedDeferredWriteDbs.size() != previousSize - numDbsSyncedByCheckpoint) {
                throw new AssertionError();
            }
            this.updateProcessedFiles();
        }
    }

    synchronized boolean addPendingLN(LN ln, DatabaseId dbId, byte[] key, byte[] dupKey) {
        if (!$assertionsDisabled && ln == null) {
            throw new AssertionError();
        }
        boolean added = this.pendingLNs.put(new Long(ln.getNodeId()), new LNInfo(ln, dbId, key, dupKey)) != null;
        this.anyPendingDuringCheckpoint = true;
        return added;
    }

    synchronized LNInfo[] getPendingLNs() {
        if (this.pendingLNs.size() > 0) {
            LNInfo[] lns = new LNInfo[this.pendingLNs.size()];
            this.pendingLNs.values().toArray(lns);
            return lns;
        }
        return null;
    }

    synchronized void removePendingLN(long nodeId) {
        this.pendingLNs.remove(new Long(nodeId));
        this.updateProcessedFiles();
    }

    synchronized boolean addPendingDB(DatabaseId dbId) {
        boolean added = this.pendingDBs.add(dbId);
        this.anyPendingDuringCheckpoint = true;
        return added;
    }

    synchronized DatabaseId[] getPendingDBs() {
        if (this.pendingDBs.size() > 0) {
            DatabaseId[] dbs = new DatabaseId[this.pendingDBs.size()];
            this.pendingDBs.toArray(dbs);
            return dbs;
        }
        return null;
    }

    synchronized void removePendingDB(DatabaseId dbId) {
        this.pendingDBs.remove(dbId);
        this.updateProcessedFiles();
    }

    synchronized Set copySafeToDeleteFiles() {
        if (this.safeToDeleteFiles.size() == 0) {
            return null;
        }
        return new HashSet(this.safeToDeleteFiles);
    }

    synchronized void removeDeletedFile(Long fileNum) {
        this.safeToDeleteFiles.remove(fileNum);
    }

    private void updateProcessedFiles() {
        if (this.pendingLNs.isEmpty() && this.pendingDBs.isEmpty()) {
            this.fullyProcessedFiles.addAll(this.checkpointedFiles);
            this.checkpointedFiles.clear();
        }
    }

    static {
        $assertionsDisabled = !FileSelector.class.desiredAssertionStatus();
    }

    public static class CheckpointStartCleanerState {
        private Set cleanedFiles;
        private Set fullyProcessedFiles;
        private Set deferredWriteDbs;

        CheckpointStartCleanerState(Set cleanedFiles, Set fullyProcessedFiles, List cleanedDeferredWriteDbs) {
            this.cleanedFiles = new HashSet(cleanedFiles);
            this.fullyProcessedFiles = new HashSet(fullyProcessedFiles);
            this.deferredWriteDbs = new HashSet(cleanedDeferredWriteDbs);
        }

        public boolean isEmpty() {
            return this.cleanedFiles.size() == 0 && this.fullyProcessedFiles.size() == 0 && this.deferredWriteDbs.size() == 0;
        }

        public Set getCleanedFiles() {
            return this.cleanedFiles;
        }

        public Set getFullyProcessedFiles() {
            return this.fullyProcessedFiles;
        }

        public Set getDeferredWriteDbs() {
            return this.deferredWriteDbs;
        }

        public int getDeferredWriteDbsSize() {
            return this.deferredWriteDbs.size();
        }
    }
}

