/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.je;

import com.sleepycat.je.CursorConfig;
import com.sleepycat.je.Database;
import com.sleepycat.je.DatabaseEntry;
import com.sleepycat.je.DatabaseException;
import com.sleepycat.je.DatabaseUtil;
import com.sleepycat.je.LockMode;
import com.sleepycat.je.OperationStatus;
import com.sleepycat.je.RunRecoveryException;
import com.sleepycat.je.Transaction;
import com.sleepycat.je.dbi.CursorImpl;
import com.sleepycat.je.dbi.DatabaseImpl;
import com.sleepycat.je.dbi.GetMode;
import com.sleepycat.je.dbi.PutMode;
import com.sleepycat.je.dbi.RangeRestartException;
import com.sleepycat.je.latch.LatchSupport;
import com.sleepycat.je.tree.BIN;
import com.sleepycat.je.tree.DBIN;
import com.sleepycat.je.tree.Key;
import com.sleepycat.je.tree.LN;
import com.sleepycat.je.tree.Node;
import com.sleepycat.je.txn.BuddyLocker;
import com.sleepycat.je.txn.LockType;
import com.sleepycat.je.txn.Locker;
import com.sleepycat.je.txn.LockerFactory;
import com.sleepycat.je.utilint.InternalException;
import java.util.logging.Level;
import java.util.logging.Logger;

public class Cursor {
    CursorImpl cursorImpl;
    CursorConfig config;
    private boolean updateOperationsProhibited;
    private Database dbHandle;
    private DatabaseImpl dbImpl;
    private boolean readUncommittedDefault;
    private boolean serializableIsolationDefault;
    private Logger logger;
    static final /* synthetic */ boolean $assertionsDisabled;

    Cursor(Database dbHandle, Transaction txn, CursorConfig cursorConfig) throws DatabaseException {
        if (cursorConfig == null) {
            cursorConfig = CursorConfig.DEFAULT;
        }
        Locker locker = LockerFactory.getReadableLocker(dbHandle.getEnvironment(), txn, dbHandle.isTransactional(), false, cursorConfig.getReadCommitted());
        this.init(dbHandle, dbHandle.getDatabaseImpl(), locker, dbHandle.isWritable(), cursorConfig);
    }

    Cursor(Database dbHandle, Locker locker, CursorConfig cursorConfig) throws DatabaseException {
        if (cursorConfig == null) {
            cursorConfig = CursorConfig.DEFAULT;
        }
        locker = LockerFactory.getReadableLocker(dbHandle.getEnvironment(), dbHandle, locker, false, cursorConfig.getReadCommitted());
        this.init(dbHandle, dbHandle.getDatabaseImpl(), locker, dbHandle.isWritable(), cursorConfig);
    }

    Cursor(DatabaseImpl dbImpl, Locker locker, CursorConfig cursorConfig) throws DatabaseException {
        if (cursorConfig == null) {
            cursorConfig = CursorConfig.DEFAULT;
        }
        this.init(null, dbImpl, locker, true, cursorConfig);
    }

    private void init(Database dbHandle, DatabaseImpl dbImpl, Locker locker, boolean isWritable, CursorConfig cursorConfig) throws DatabaseException {
        if (!$assertionsDisabled && locker == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && dbImpl == null) {
            throw new AssertionError();
        }
        this.cursorImpl = new CursorImpl(dbImpl, locker, false);
        this.readUncommittedDefault = cursorConfig.getReadUncommitted() || locker.isReadUncommittedDefault();
        this.serializableIsolationDefault = this.cursorImpl.getLocker().isSerializableIsolation();
        this.updateOperationsProhibited = dbImpl.isTransactional() && !locker.isTransactional() || !isWritable;
        this.dbImpl = dbImpl;
        this.dbHandle = dbHandle;
        if (dbHandle != null) {
            dbHandle.addCursor(this);
        }
        this.config = cursorConfig;
        this.logger = dbImpl.getDbEnvironment().getLogger();
    }

    Cursor(Cursor cursor, boolean samePosition) throws DatabaseException {
        this.readUncommittedDefault = cursor.readUncommittedDefault;
        this.serializableIsolationDefault = cursor.serializableIsolationDefault;
        this.updateOperationsProhibited = cursor.updateOperationsProhibited;
        this.cursorImpl = cursor.cursorImpl.dup(samePosition);
        this.dbImpl = cursor.dbImpl;
        this.dbHandle = cursor.dbHandle;
        if (this.dbHandle != null) {
            this.dbHandle.addCursor(this);
        }
        this.config = cursor.config;
        this.logger = this.dbImpl.getDbEnvironment().getLogger();
    }

    CursorImpl getCursorImpl() {
        return this.cursorImpl;
    }

    public Database getDatabase() {
        return this.dbHandle;
    }

    DatabaseImpl getDatabaseImpl() {
        return this.dbImpl;
    }

    public CursorConfig getConfig() {
        try {
            return this.config.cloneConfig();
        }
        catch (Error E) {
            this.dbImpl.getDbEnvironment().invalidate(E);
            throw E;
        }
    }

    void setNonCloning(boolean nonCloning) {
        this.cursorImpl.setNonCloning(nonCloning);
    }

    public synchronized void close() throws DatabaseException {
        try {
            this.checkState(false);
            this.cursorImpl.close();
            if (this.dbHandle != null) {
                this.dbHandle.removeCursor(this);
            }
        }
        catch (Error E) {
            this.dbImpl.getDbEnvironment().invalidate(E);
            throw E;
        }
    }

    public int count() throws DatabaseException {
        this.checkState(true);
        this.trace(Level.FINEST, "Cursor.count: ", null);
        return this.countInternal(null);
    }

    public Cursor dup(boolean samePosition) throws DatabaseException {
        try {
            this.checkState(false);
            return new Cursor(this, samePosition);
        }
        catch (Error E) {
            this.dbImpl.getDbEnvironment().invalidate(E);
            throw E;
        }
    }

    public OperationStatus delete() throws DatabaseException {
        this.checkState(true);
        this.checkUpdatesAllowed("delete");
        this.trace(Level.FINEST, "Cursor.delete: ", null);
        return this.deleteInternal();
    }

    public OperationStatus put(DatabaseEntry key, DatabaseEntry data) throws DatabaseException {
        this.checkState(false);
        DatabaseUtil.checkForNullDbt(key, "key", true);
        DatabaseUtil.checkForNullDbt(data, "data", true);
        DatabaseUtil.checkForPartialKey(key);
        this.checkUpdatesAllowed("put");
        this.trace(Level.FINEST, "Cursor.put: ", key, data, null);
        return this.putInternal(key, data, PutMode.OVERWRITE);
    }

    public OperationStatus putNoOverwrite(DatabaseEntry key, DatabaseEntry data) throws DatabaseException {
        this.checkState(false);
        DatabaseUtil.checkForNullDbt(key, "key", true);
        DatabaseUtil.checkForNullDbt(data, "data", true);
        DatabaseUtil.checkForPartialKey(key);
        this.checkUpdatesAllowed("putNoOverwrite");
        this.trace(Level.FINEST, "Cursor.putNoOverwrite: ", key, data, null);
        return this.putInternal(key, data, PutMode.NOOVERWRITE);
    }

    public OperationStatus putNoDupData(DatabaseEntry key, DatabaseEntry data) throws DatabaseException {
        this.checkState(false);
        DatabaseUtil.checkForNullDbt(key, "key", true);
        DatabaseUtil.checkForNullDbt(data, "data", true);
        DatabaseUtil.checkForPartialKey(key);
        this.checkUpdatesAllowed("putNoDupData");
        this.trace(Level.FINEST, "Cursor.putNoDupData: ", key, data, null);
        return this.putInternal(key, data, PutMode.NODUP);
    }

    public OperationStatus putCurrent(DatabaseEntry data) throws DatabaseException {
        this.checkState(true);
        DatabaseUtil.checkForNullDbt(data, "data", true);
        this.checkUpdatesAllowed("putCurrent");
        this.trace(Level.FINEST, "Cursor.putCurrent: ", null, data, null);
        return this.putInternal(null, data, PutMode.CURRENT);
    }

    public OperationStatus getCurrent(DatabaseEntry key, DatabaseEntry data, LockMode lockMode) throws DatabaseException {
        try {
            this.checkState(true);
            this.checkArgsNoValRequired(key, data);
            this.trace(Level.FINEST, "Cursor.getCurrent: ", lockMode);
            return this.getCurrentInternal(key, data, lockMode);
        }
        catch (Error E) {
            this.dbImpl.getDbEnvironment().invalidate(E);
            throw E;
        }
    }

    public OperationStatus getFirst(DatabaseEntry key, DatabaseEntry data, LockMode lockMode) throws DatabaseException {
        this.checkState(false);
        this.checkArgsNoValRequired(key, data);
        this.trace(Level.FINEST, "Cursor.getFirst: ", lockMode);
        return this.position(key, data, lockMode, true);
    }

    public OperationStatus getLast(DatabaseEntry key, DatabaseEntry data, LockMode lockMode) throws DatabaseException {
        this.checkState(false);
        this.checkArgsNoValRequired(key, data);
        this.trace(Level.FINEST, "Cursor.getLast: ", lockMode);
        return this.position(key, data, lockMode, false);
    }

    public OperationStatus getNext(DatabaseEntry key, DatabaseEntry data, LockMode lockMode) throws DatabaseException {
        this.checkState(false);
        this.checkArgsNoValRequired(key, data);
        this.trace(Level.FINEST, "Cursor.getNext: ", lockMode);
        if (this.cursorImpl.isNotInitialized()) {
            return this.position(key, data, lockMode, true);
        }
        return this.retrieveNext(key, data, lockMode, GetMode.NEXT);
    }

    public OperationStatus getNextDup(DatabaseEntry key, DatabaseEntry data, LockMode lockMode) throws DatabaseException {
        this.checkState(true);
        this.checkArgsNoValRequired(key, data);
        this.trace(Level.FINEST, "Cursor.getNextDup: ", lockMode);
        return this.retrieveNext(key, data, lockMode, GetMode.NEXT_DUP);
    }

    public OperationStatus getNextNoDup(DatabaseEntry key, DatabaseEntry data, LockMode lockMode) throws DatabaseException {
        this.checkState(false);
        this.checkArgsNoValRequired(key, data);
        this.trace(Level.FINEST, "Cursor.getNextNoDup: ", lockMode);
        if (this.cursorImpl.isNotInitialized()) {
            return this.position(key, data, lockMode, true);
        }
        return this.retrieveNext(key, data, lockMode, GetMode.NEXT_NODUP);
    }

    public OperationStatus getPrev(DatabaseEntry key, DatabaseEntry data, LockMode lockMode) throws DatabaseException {
        this.checkState(false);
        this.checkArgsNoValRequired(key, data);
        this.trace(Level.FINEST, "Cursor.getPrev: ", lockMode);
        if (this.cursorImpl.isNotInitialized()) {
            return this.position(key, data, lockMode, false);
        }
        return this.retrieveNext(key, data, lockMode, GetMode.PREV);
    }

    public OperationStatus getPrevDup(DatabaseEntry key, DatabaseEntry data, LockMode lockMode) throws DatabaseException {
        this.checkState(true);
        this.checkArgsNoValRequired(key, data);
        this.trace(Level.FINEST, "Cursor.getPrevDup: ", lockMode);
        return this.retrieveNext(key, data, lockMode, GetMode.PREV_DUP);
    }

    public OperationStatus getPrevNoDup(DatabaseEntry key, DatabaseEntry data, LockMode lockMode) throws DatabaseException {
        this.checkState(false);
        this.checkArgsNoValRequired(key, data);
        this.trace(Level.FINEST, "Cursor.getPrevNoDup: ", lockMode);
        if (this.cursorImpl.isNotInitialized()) {
            return this.position(key, data, lockMode, false);
        }
        return this.retrieveNext(key, data, lockMode, GetMode.PREV_NODUP);
    }

    public OperationStatus getSearchKey(DatabaseEntry key, DatabaseEntry data, LockMode lockMode) throws DatabaseException {
        this.checkState(false);
        DatabaseUtil.checkForNullDbt(key, "key", true);
        DatabaseUtil.checkForNullDbt(data, "data", false);
        this.trace(Level.FINEST, "Cursor.getSearchKey: ", key, null, lockMode);
        return this.search(key, data, lockMode, CursorImpl.SearchMode.SET);
    }

    public OperationStatus getSearchKeyRange(DatabaseEntry key, DatabaseEntry data, LockMode lockMode) throws DatabaseException {
        this.checkState(false);
        DatabaseUtil.checkForNullDbt(key, "key", true);
        DatabaseUtil.checkForNullDbt(data, "data", false);
        this.trace(Level.FINEST, "Cursor.getSearchKeyRange: ", key, null, lockMode);
        return this.search(key, data, lockMode, CursorImpl.SearchMode.SET_RANGE);
    }

    public OperationStatus getSearchBoth(DatabaseEntry key, DatabaseEntry data, LockMode lockMode) throws DatabaseException {
        this.checkState(false);
        this.checkArgsValRequired(key, data);
        this.trace(Level.FINEST, "Cursor.getSearchBoth: ", key, data, lockMode);
        return this.search(key, data, lockMode, CursorImpl.SearchMode.BOTH);
    }

    public OperationStatus getSearchBothRange(DatabaseEntry key, DatabaseEntry data, LockMode lockMode) throws DatabaseException {
        this.checkState(false);
        this.checkArgsValRequired(key, data);
        this.trace(Level.FINEST, "Cursor.getSearchBothRange: ", key, data, lockMode);
        return this.search(key, data, lockMode, CursorImpl.SearchMode.BOTH_RANGE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int countInternal(LockMode lockMode) throws DatabaseException {
        int n;
        block6: {
            CursorImpl original = null;
            CursorImpl dup = null;
            try {
                original = this.cursorImpl;
                dup = original.cloneCursor(true);
                n = dup.count(this.getLockType(lockMode, false));
                if (dup == original || dup == null) break block6;
            }
            catch (Throwable throwable) {
                try {
                    if (dup != original && dup != null) {
                        dup.close();
                    }
                    throw throwable;
                }
                catch (Error E) {
                    this.dbImpl.getDbEnvironment().invalidate(E);
                    throw E;
                }
            }
            dup.close();
        }
        return n;
    }

    OperationStatus deleteInternal() throws DatabaseException {
        try {
            OperationStatus status;
            boolean doNotifyTriggers;
            DatabaseEntry oldKey = null;
            DatabaseEntry oldData = null;
            boolean bl = doNotifyTriggers = this.dbHandle != null && this.dbHandle.hasTriggers();
            if (doNotifyTriggers && (status = this.getCurrentInternal(oldKey = new DatabaseEntry(), oldData = new DatabaseEntry(), LockMode.RMW)) != OperationStatus.SUCCESS) {
                return OperationStatus.KEYEMPTY;
            }
            if (doNotifyTriggers) {
                this.dbHandle.notifyTriggers(this.cursorImpl.getLocker(), oldKey, oldData, null);
            }
            status = this.deleteNoNotify();
            return status;
        }
        catch (Error E) {
            this.dbImpl.getDbEnvironment().invalidate(E);
            throw E;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    OperationStatus deleteNoNotify() throws DatabaseException {
        boolean success;
        OperationStatus operationStatus;
        OperationStatus status;
        CursorImpl dup;
        CursorImpl original;
        block15: {
            original = null;
            dup = null;
            status = OperationStatus.KEYEMPTY;
            try {
                original = this.cursorImpl;
                dup = original.cloneCursor(true);
                dup.latchBINs();
                operationStatus = status = dup.delete();
                if (original == null) break block15;
            }
            catch (Throwable throwable) {
                boolean success2;
                if (original != null) {
                    original.releaseBINs();
                }
                if (dup != null) {
                    dup.releaseBINs();
                }
                boolean bl = success2 = status == OperationStatus.SUCCESS;
                if (this.cursorImpl == dup) {
                    if (!success2) {
                        this.cursorImpl.reset();
                    }
                } else if (success2) {
                    original.close();
                    this.cursorImpl = dup;
                } else {
                    dup.close();
                }
                throw throwable;
            }
            original.releaseBINs();
        }
        if (dup != null) {
            dup.releaseBINs();
        }
        boolean bl = success = status == OperationStatus.SUCCESS;
        if (this.cursorImpl == dup) {
            if (!success) {
                this.cursorImpl.reset();
            }
        } else if (success) {
            original.close();
            this.cursorImpl = dup;
        } else {
            dup.close();
        }
        return operationStatus;
    }

    OperationStatus putInternal(DatabaseEntry key, DatabaseEntry data, PutMode putMode) throws DatabaseException {
        try {
            boolean doNotifyTriggers;
            DatabaseEntry oldData = null;
            boolean bl = doNotifyTriggers = this.dbHandle != null && this.dbHandle.hasTriggers();
            if (doNotifyTriggers && (putMode == PutMode.CURRENT || putMode == PutMode.OVERWRITE)) {
                oldData = new DatabaseEntry();
                if (key == null && putMode == PutMode.CURRENT) {
                    key = new DatabaseEntry();
                }
            }
            OperationStatus commitStatus = this.putNoNotify(key, data, putMode, oldData);
            if (doNotifyTriggers && commitStatus == OperationStatus.SUCCESS) {
                if (oldData != null && oldData.getData() == null) {
                    oldData = null;
                }
                this.dbHandle.notifyTriggers(this.cursorImpl.getLocker(), key, oldData, data);
            }
            return commitStatus;
        }
        catch (Error E) {
            this.dbImpl.getDbEnvironment().invalidate(E);
            throw E;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    OperationStatus putNoNotify(DatabaseEntry key, DatabaseEntry data, PutMode putMode, DatabaseEntry returnOldData) throws DatabaseException {
        Locker nextKeyLocker = null;
        CursorImpl nextKeyCursor = null;
        try {
            Locker cursorLocker = this.cursorImpl.getLocker();
            if (putMode != PutMode.CURRENT && this.dbImpl.getDbEnvironment().getTxnManager().areOtherSerializableTransactionsActive(cursorLocker)) {
                nextKeyLocker = new BuddyLocker(this.dbImpl.getDbEnvironment(), cursorLocker);
                nextKeyCursor = new CursorImpl(this.dbImpl, nextKeyLocker);
                nextKeyCursor.lockNextKeyForInsert(key, data);
            }
            OperationStatus operationStatus = this.putAllowPhantoms(key, data, putMode, returnOldData, nextKeyCursor);
            return operationStatus;
        }
        finally {
            if (nextKeyCursor != null) {
                nextKeyCursor.close();
            }
            if (nextKeyLocker != null) {
                nextKeyLocker.operationEnd();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private OperationStatus putAllowPhantoms(DatabaseEntry key, DatabaseEntry data, PutMode putMode, DatabaseEntry returnOldData, CursorImpl nextKeyCursor) throws DatabaseException {
        boolean success;
        OperationStatus operationStatus;
        CursorImpl dup;
        OperationStatus status;
        CursorImpl original;
        block25: {
            if (data == null) {
                throw new NullPointerException("put passed a null DatabaseEntry arg");
            }
            if (putMode != PutMode.CURRENT && key == null) {
                throw new IllegalArgumentException("put passed a null DatabaseEntry arg");
            }
            original = null;
            status = OperationStatus.NOTFOUND;
            dup = null;
            try {
                original = this.cursorImpl;
                dup = putMode == PutMode.CURRENT ? original.cloneCursor(true) : original.cloneCursor(false, nextKeyCursor);
                if (putMode == PutMode.CURRENT) {
                    status = dup.putCurrent(data, key, returnOldData);
                } else if (putMode == PutMode.OVERWRITE) {
                    status = dup.put(key, data, returnOldData);
                } else if (putMode == PutMode.NOOVERWRITE) {
                    status = dup.putNoOverwrite(key, data);
                } else if (putMode == PutMode.NODUP) {
                    status = dup.putNoDupData(key, data);
                } else {
                    throw new InternalException("unknown PutMode");
                }
                operationStatus = status;
                if (original == null) break block25;
            }
            catch (Throwable throwable) {
                boolean success2;
                if (original != null) {
                    original.releaseBINs();
                }
                boolean bl = success2 = status == OperationStatus.SUCCESS;
                if (this.cursorImpl == dup) {
                    if (!success2) {
                        this.cursorImpl.reset();
                    }
                } else if (success2) {
                    original.close();
                    this.cursorImpl = dup;
                } else if (dup != null) {
                    dup.close();
                }
                throw throwable;
            }
            original.releaseBINs();
        }
        boolean bl = success = status == OperationStatus.SUCCESS;
        if (this.cursorImpl == dup) {
            if (!success) {
                this.cursorImpl.reset();
            }
        } else if (success) {
            original.close();
            this.cursorImpl = dup;
        } else if (dup != null) {
            dup.close();
        }
        return operationStatus;
    }

    OperationStatus position(DatabaseEntry key, DatabaseEntry data, LockMode lockMode, boolean first) throws DatabaseException {
        try {
            if (!this.isSerializableIsolation(lockMode)) {
                return this.positionAllowPhantoms(key, data, this.getLockType(lockMode, false), first);
            }
            while (true) {
                try {
                    if (!first) {
                        this.cursorImpl.lockEofNode(LockType.RANGE_READ);
                    }
                    LockType lockType = this.getLockType(lockMode, first);
                    OperationStatus status = this.positionAllowPhantoms(key, data, lockType, first);
                    if (first && status != OperationStatus.SUCCESS) {
                        this.cursorImpl.lockEofNode(LockType.RANGE_READ);
                    }
                    return status;
                }
                catch (RangeRestartException e) {
                    continue;
                }
                break;
            }
        }
        catch (Error E) {
            this.dbImpl.getDbEnvironment().invalidate(E);
            throw E;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private OperationStatus positionAllowPhantoms(DatabaseEntry key, DatabaseEntry data, LockType lockType, boolean first) throws DatabaseException {
        CursorImpl dup;
        OperationStatus status;
        block8: {
            if (!($assertionsDisabled || key != null && data != null)) {
                throw new AssertionError();
            }
            status = OperationStatus.NOTFOUND;
            dup = null;
            try {
                dup = this.beginRead(false);
                if (!dup.positionFirstOrLast(first, null)) {
                    status = OperationStatus.NOTFOUND;
                    if (!$assertionsDisabled && LatchSupport.countLatchesHeld() != 0) {
                        throw new AssertionError((Object)LatchSupport.latchesHeldToString());
                    }
                    break block8;
                }
                if (!$assertionsDisabled && LatchSupport.countLatchesHeld() != 1) {
                    throw new AssertionError((Object)LatchSupport.latchesHeldToString());
                }
                status = dup.getCurrentAlreadyLatched(key, data, lockType, first);
                if (status == OperationStatus.SUCCESS) {
                    if (dup.getDupBIN() != null) {
                        dup.incrementLNCount();
                    }
                    break block8;
                }
                status = dup.getNext(key, data, lockType, first, false);
            }
            catch (Throwable throwable) {
                this.cursorImpl.releaseBINs();
                this.endRead(dup, status == OperationStatus.SUCCESS);
                throw throwable;
            }
        }
        this.cursorImpl.releaseBINs();
        this.endRead(dup, status == OperationStatus.SUCCESS);
        return status;
    }

    OperationStatus search(DatabaseEntry key, DatabaseEntry data, LockMode lockMode, CursorImpl.SearchMode searchMode) throws DatabaseException {
        try {
            if (!this.isSerializableIsolation(lockMode)) {
                LockType lockType = this.getLockType(lockMode, false);
                CursorImpl.KeyChangeStatus result = this.searchAllowPhantoms(key, data, lockType, lockType, searchMode);
                return result.status;
            }
            while (true) {
                try {
                    CursorImpl.KeyChangeStatus result;
                    LockType searchLockType = this.getLockType(lockMode, false);
                    LockType advanceLockType = this.getLockType(lockMode, true);
                    DatabaseEntry tryKey = new DatabaseEntry(key.getData(), key.getOffset(), key.getSize());
                    DatabaseEntry tryData = new DatabaseEntry(data.getData(), data.getOffset(), data.getSize());
                    if (searchMode.isExactSearch()) {
                        result = this.searchExactAndRangeLock(tryKey, tryData, searchLockType, advanceLockType, searchMode);
                    } else {
                        result = this.searchAllowPhantoms(tryKey, tryData, searchLockType, advanceLockType, searchMode);
                        if (result.status != OperationStatus.SUCCESS) {
                            this.cursorImpl.lockEofNode(LockType.RANGE_READ);
                        }
                    }
                    if (result.status == OperationStatus.SUCCESS) {
                        key.setData(tryKey.getData(), 0, tryKey.getSize());
                        data.setData(tryData.getData(), 0, tryData.getSize());
                    }
                    return result.status;
                }
                catch (RangeRestartException e) {
                    continue;
                }
                break;
            }
        }
        catch (Error E) {
            this.dbImpl.getDbEnvironment().invalidate(E);
            throw E;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CursorImpl.KeyChangeStatus searchExactAndRangeLock(DatabaseEntry key, DatabaseEntry data, LockType searchLockType, LockType advanceLockType, CursorImpl.SearchMode searchMode) throws DatabaseException {
        boolean noNextKeyFound;
        searchMode = searchMode == CursorImpl.SearchMode.SET ? CursorImpl.SearchMode.SET_RANGE : CursorImpl.SearchMode.BOTH_RANGE;
        CursorImpl.KeyChangeStatus result = null;
        CursorImpl dup = this.beginRead(false);
        try {
            result = this.searchInternal(dup, key, data, searchLockType, advanceLockType, searchMode, true);
            boolean bl = noNextKeyFound = !result.keyChange;
            if (result.keyChange && result.status == OperationStatus.SUCCESS) {
                result.status = OperationStatus.NOTFOUND;
            }
            this.endRead(dup, result != null && result.status == OperationStatus.SUCCESS);
        }
        catch (Throwable throwable) {
            this.endRead(dup, result != null && result.status == OperationStatus.SUCCESS);
            throw throwable;
        }
        if (noNextKeyFound) {
            this.cursorImpl.lockEofNode(LockType.RANGE_READ);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CursorImpl.KeyChangeStatus searchAllowPhantoms(DatabaseEntry key, DatabaseEntry data, LockType searchLockType, LockType advanceLockType, CursorImpl.SearchMode searchMode) throws DatabaseException {
        CursorImpl.KeyChangeStatus keyChangeStatus;
        OperationStatus status = OperationStatus.NOTFOUND;
        CursorImpl dup = this.beginRead(false);
        try {
            CursorImpl.KeyChangeStatus result = this.searchInternal(dup, key, data, searchLockType, advanceLockType, searchMode, false);
            status = result.status;
            keyChangeStatus = result;
            this.endRead(dup, status == OperationStatus.SUCCESS);
        }
        catch (Throwable throwable) {
            this.endRead(dup, status == OperationStatus.SUCCESS);
            throw throwable;
        }
        return keyChangeStatus;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CursorImpl.KeyChangeStatus searchInternal(CursorImpl dup, DatabaseEntry key, DatabaseEntry data, LockType searchLockType, LockType advanceLockType, CursorImpl.SearchMode searchMode, boolean advanceAfterRangeSearch) throws DatabaseException {
        if (!($assertionsDisabled || key != null && data != null)) {
            throw new AssertionError();
        }
        OperationStatus status = OperationStatus.NOTFOUND;
        boolean keyChange = false;
        try {
            int searchResult = dup.searchAndPosition(key, data, searchMode, searchLockType);
            if ((searchResult & 1) != 0) {
                DatabaseEntry useKey;
                boolean exactKeyMatch = (searchResult & 2) != 0;
                boolean exactDataMatch = (searchResult & 4) != 0;
                boolean foundLast = (searchResult & 8) != 0;
                boolean rangeMatch = false;
                if (searchMode == CursorImpl.SearchMode.SET_RANGE && !exactKeyMatch) {
                    rangeMatch = true;
                }
                if (!(searchMode != CursorImpl.SearchMode.BOTH_RANGE || exactKeyMatch && exactDataMatch)) {
                    rangeMatch = true;
                }
                DatabaseEntry databaseEntry = useKey = searchMode == CursorImpl.SearchMode.SET ? null : key;
                if (rangeMatch || (status = dup.getCurrentAlreadyLatched(useKey, data, searchLockType, true)) == OperationStatus.KEYEMPTY) {
                    if (foundLast) {
                        status = OperationStatus.NOTFOUND;
                    } else if (searchMode == CursorImpl.SearchMode.SET) {
                        status = dup.getNextDuplicate(key, data, advanceLockType, true, rangeMatch);
                    } else if (searchMode == CursorImpl.SearchMode.BOTH) {
                        if (status == OperationStatus.KEYEMPTY) {
                            status = OperationStatus.NOTFOUND;
                        }
                    } else {
                        if (!$assertionsDisabled && searchMode.isExactSearch()) {
                            throw new AssertionError();
                        }
                        byte[] searchKey = null;
                        if (searchMode.isDataSearch()) {
                            searchKey = Key.makeKey(key);
                        }
                        if (exactKeyMatch) {
                            CursorImpl.KeyChangeStatus result = dup.getNextWithKeyChangeStatus(key, data, advanceLockType, true, rangeMatch);
                            status = result.status;
                            keyChange = searchMode.isDataSearch() ? status == OperationStatus.SUCCESS : result.keyChange;
                        } else if (searchMode.isDataSearch() && !advanceAfterRangeSearch) {
                            status = OperationStatus.NOTFOUND;
                        } else {
                            status = dup.getNextNoDup(key, data, advanceLockType, true, rangeMatch);
                            boolean bl = keyChange = status == OperationStatus.SUCCESS;
                        }
                        if (status == OperationStatus.SUCCESS && searchMode.isDataSearch() && Key.compareKeys(key.getData(), searchKey, this.dbImpl.getBtreeComparator()) != 0) {
                            status = OperationStatus.NOTFOUND;
                        }
                    }
                }
            }
        }
        finally {
            this.cursorImpl.releaseBINs();
            if (status != OperationStatus.SUCCESS && dup != this.cursorImpl) {
                dup.releaseBINs();
            }
        }
        return new CursorImpl.KeyChangeStatus(status, keyChange);
    }

    OperationStatus retrieveNext(DatabaseEntry key, DatabaseEntry data, LockMode lockMode, GetMode getMode) throws DatabaseException {
        try {
            if (!this.isSerializableIsolation(lockMode)) {
                return this.retrieveNextAllowPhantoms(key, data, this.getLockType(lockMode, false), getMode);
            }
            while (true) {
                try {
                    OperationStatus status;
                    if (getMode == GetMode.NEXT_DUP) {
                        status = this.getNextDupAndRangeLock(key, data, lockMode);
                    } else {
                        if (!getMode.isForward()) {
                            this.rangeLockCurrentPosition(getMode);
                        }
                        LockType lockType = this.getLockType(lockMode, getMode.isForward());
                        status = this.retrieveNextAllowPhantoms(key, data, lockType, getMode);
                        if (getMode.isForward() && status != OperationStatus.SUCCESS) {
                            this.cursorImpl.lockEofNode(LockType.RANGE_READ);
                        }
                    }
                    return status;
                }
                catch (RangeRestartException e) {
                    continue;
                }
                break;
            }
        }
        catch (Error E) {
            this.dbImpl.getDbEnvironment().invalidate(E);
            throw E;
        }
    }

    private OperationStatus getNextDupAndRangeLock(DatabaseEntry key, DatabaseEntry data, LockMode lockMode) throws DatabaseException {
        boolean noNextKeyFound;
        OperationStatus status;
        CursorImpl dup;
        DatabaseEntry tryKey = new DatabaseEntry();
        DatabaseEntry tryData = new DatabaseEntry();
        LockType lockType = this.getLockType(lockMode, true);
        while (true) {
            if (!$assertionsDisabled && LatchSupport.countLatchesHeld() != 0) {
                throw new AssertionError();
            }
            dup = this.beginRead(true);
            try {
                CursorImpl.KeyChangeStatus result = dup.getNextWithKeyChangeStatus(tryKey, tryData, lockType, true, false);
                status = result.status;
                boolean bl = noNextKeyFound = status != OperationStatus.SUCCESS;
                if (result.keyChange && status == OperationStatus.SUCCESS) {
                    status = OperationStatus.NOTFOUND;
                }
            }
            catch (DatabaseException DBE) {
                this.endRead(dup, false);
                throw DBE;
            }
            if (!this.checkForInsertion(GetMode.NEXT, this.cursorImpl, dup)) break;
            this.endRead(dup, false);
        }
        this.endRead(dup, status == OperationStatus.SUCCESS);
        if (!$assertionsDisabled && LatchSupport.countLatchesHeld() != 0) {
            throw new AssertionError();
        }
        if (noNextKeyFound) {
            this.cursorImpl.lockEofNode(LockType.RANGE_READ);
        }
        if (status == OperationStatus.SUCCESS) {
            key.setData(tryKey.getData(), 0, tryKey.getSize());
            data.setData(tryData.getData(), 0, tryData.getSize());
        }
        return status;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void rangeLockCurrentPosition(GetMode getMode) throws DatabaseException {
        OperationStatus status;
        DatabaseEntry tempKey = new DatabaseEntry();
        DatabaseEntry tempData = new DatabaseEntry();
        tempKey.setPartial(0, 0, true);
        tempData.setPartial(0, 0, true);
        CursorImpl dup = this.cursorImpl.cloneCursor(true);
        try {
            status = getMode == GetMode.PREV_NODUP ? dup.getFirstDuplicate(tempKey, tempData, LockType.RANGE_READ) : dup.getCurrent(tempKey, tempData, LockType.RANGE_READ);
            if (status != OperationStatus.SUCCESS) {
                while (true) {
                    if (!$assertionsDisabled && LatchSupport.countLatchesHeld() != 0) {
                        throw new AssertionError();
                    }
                    status = dup.getNext(tempKey, tempData, LockType.RANGE_READ, true, false);
                    if (!this.checkForInsertion(GetMode.NEXT, this.cursorImpl, dup)) break;
                    dup.close();
                    dup = this.cursorImpl.cloneCursor(true);
                }
                if (!$assertionsDisabled && LatchSupport.countLatchesHeld() != 0) {
                    throw new AssertionError();
                }
            }
        }
        finally {
            if (this.cursorImpl == dup) {
                dup.reset();
            } else {
                dup.close();
            }
        }
        if (status != OperationStatus.SUCCESS) {
            this.cursorImpl.lockEofNode(LockType.RANGE_READ);
        }
    }

    private OperationStatus retrieveNextAllowPhantoms(DatabaseEntry key, DatabaseEntry data, LockType lockType, GetMode getMode) throws DatabaseException {
        OperationStatus status;
        CursorImpl dup;
        if (!($assertionsDisabled || key != null && data != null)) {
            throw new AssertionError();
        }
        while (true) {
            block12: {
                if (!$assertionsDisabled && LatchSupport.countLatchesHeld() != 0) {
                    throw new AssertionError();
                }
                dup = this.beginRead(true);
                try {
                    if (getMode == GetMode.NEXT) {
                        status = dup.getNext(key, data, lockType, true, false);
                        break block12;
                    }
                    if (getMode == GetMode.PREV) {
                        status = dup.getNext(key, data, lockType, false, false);
                        break block12;
                    }
                    if (getMode == GetMode.NEXT_DUP) {
                        status = dup.getNextDuplicate(key, data, lockType, true, false);
                        break block12;
                    }
                    if (getMode == GetMode.PREV_DUP) {
                        status = dup.getNextDuplicate(key, data, lockType, false, false);
                        break block12;
                    }
                    if (getMode == GetMode.NEXT_NODUP) {
                        status = dup.getNextNoDup(key, data, lockType, true, false);
                        break block12;
                    }
                    if (getMode == GetMode.PREV_NODUP) {
                        status = dup.getNextNoDup(key, data, lockType, false, false);
                        break block12;
                    }
                    throw new InternalException("unknown GetMode");
                }
                catch (DatabaseException DBE) {
                    this.endRead(dup, false);
                    throw DBE;
                }
            }
            if (!this.checkForInsertion(getMode, this.cursorImpl, dup)) break;
            this.endRead(dup, false);
        }
        this.endRead(dup, status == OperationStatus.SUCCESS);
        if (!$assertionsDisabled && LatchSupport.countLatchesHeld() != 0) {
            throw new AssertionError();
        }
        return status;
    }

    OperationStatus getCurrentInternal(DatabaseEntry key, DatabaseEntry data, LockMode lockMode) throws DatabaseException {
        LockType lockType = this.getLockType(lockMode, false);
        return this.cursorImpl.getCurrent(key, data, lockType);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean checkForInsertion(GetMode getMode, CursorImpl origCursor, CursorImpl dupCursor) throws DatabaseException {
        BIN origBIN = origCursor.getBIN();
        BIN dupBIN = dupCursor.getBIN();
        DBIN origDBIN = origCursor.getDupBIN();
        boolean forward = true;
        if (getMode == GetMode.PREV || getMode == GetMode.PREV_DUP || getMode == GetMode.PREV_NODUP) {
            forward = false;
        }
        boolean ret = false;
        if (origBIN != dupBIN) {
            block15: {
                origCursor.latchBINs();
                try {
                    if (origDBIN != null) break block15;
                    if (forward) {
                        if (origBIN.getNEntries() - 1 <= origCursor.getIndex()) break block15;
                        for (int i = origCursor.getIndex() + 1; i < origBIN.getNEntries(); ++i) {
                            LN ln;
                            Node n;
                            if (origBIN.isEntryKnownDeleted(i) || (n = origBIN.fetchTarget(i)) == null || n.containsDuplicates() || (ln = (LN)n).isDeleted()) continue;
                            ret = true;
                            break block15;
                        }
                        break block15;
                    }
                    if (origCursor.getIndex() <= 0) break block15;
                    for (int i = 0; i < origCursor.getIndex(); ++i) {
                        LN ln;
                        Node n;
                        if (origBIN.isEntryKnownDeleted(i) || (n = origBIN.fetchTarget(i)) == null || n.containsDuplicates() || (ln = (LN)n).isDeleted()) continue;
                        ret = true;
                        break;
                    }
                }
                finally {
                    origCursor.releaseBINs();
                }
            }
            return ret;
        }
        if (origDBIN != dupCursor.getDupBIN() && origCursor.getIndex() == dupCursor.getIndex() && getMode != GetMode.NEXT_NODUP && getMode != GetMode.PREV_NODUP) {
            block16: {
                origCursor.latchBINs();
                try {
                    if (forward) {
                        if (origDBIN.getNEntries() - 1 <= origCursor.getDupIndex()) break block16;
                        for (int i = origCursor.getDupIndex() + 1; i < origDBIN.getNEntries(); ++i) {
                            if (origDBIN.isEntryKnownDeleted(i)) continue;
                            Node n = origDBIN.fetchTarget(i);
                            LN ln = (LN)n;
                            if (n == null || ln.isDeleted()) continue;
                            ret = true;
                            break block16;
                        }
                        break block16;
                    }
                    if (origCursor.getDupIndex() <= 0) break block16;
                    for (int i = 0; i < origCursor.getDupIndex(); ++i) {
                        if (origDBIN.isEntryKnownDeleted(i)) continue;
                        Node n = origDBIN.fetchTarget(i);
                        LN ln = (LN)n;
                        if (n == null || ln.isDeleted()) continue;
                        ret = true;
                        break;
                    }
                }
                finally {
                    origCursor.releaseBINs();
                }
            }
            return ret;
        }
        return false;
    }

    private CursorImpl beginRead(boolean addCursor) throws DatabaseException {
        CursorImpl dup = this.cursorImpl.isNotInitialized() ? this.cursorImpl : this.cursorImpl.cloneCursor(addCursor);
        return dup;
    }

    private void endRead(CursorImpl dup, boolean success) throws DatabaseException {
        if (dup == this.cursorImpl) {
            if (!success) {
                this.cursorImpl.reset();
            }
        } else if (success) {
            this.cursorImpl.close();
            this.cursorImpl = dup;
        } else {
            dup.close();
        }
    }

    boolean advanceCursor(DatabaseEntry key, DatabaseEntry data) {
        return this.cursorImpl.advanceCursor(key, data);
    }

    private LockType getLockType(LockMode lockMode, boolean rangeLock) {
        if (this.isReadUncommittedMode(lockMode)) {
            return LockType.NONE;
        }
        if (lockMode == null || lockMode == LockMode.DEFAULT) {
            return rangeLock ? LockType.RANGE_READ : LockType.READ;
        }
        if (lockMode == LockMode.RMW) {
            return rangeLock ? LockType.RANGE_WRITE : LockType.WRITE;
        }
        if (lockMode == LockMode.READ_COMMITTED) {
            throw new IllegalArgumentException(lockMode.toString() + " not allowed with Cursor methods");
        }
        if (!$assertionsDisabled) {
            throw new AssertionError(lockMode);
        }
        return LockType.NONE;
    }

    boolean isReadUncommittedMode(LockMode lockMode) {
        return lockMode == LockMode.READ_UNCOMMITTED || this.readUncommittedDefault && (lockMode == null || lockMode == LockMode.DEFAULT);
    }

    private boolean isSerializableIsolation(LockMode lockMode) {
        return this.serializableIsolationDefault && !this.isReadUncommittedMode(lockMode);
    }

    protected void checkUpdatesAllowed(String operation) throws DatabaseException {
        if (this.updateOperationsProhibited) {
            throw new DatabaseException("A transaction was not supplied when opening this cursor: " + operation);
        }
    }

    private void checkArgsNoValRequired(DatabaseEntry key, DatabaseEntry data) {
        DatabaseUtil.checkForNullDbt(key, "key", false);
        DatabaseUtil.checkForNullDbt(data, "data", false);
    }

    private void checkArgsValRequired(DatabaseEntry key, DatabaseEntry data) {
        DatabaseUtil.checkForNullDbt(key, "key", true);
        DatabaseUtil.checkForNullDbt(data, "data", true);
    }

    void checkState(boolean mustBeInitialized) throws DatabaseException {
        this.checkEnv();
        this.cursorImpl.checkCursorState(mustBeInitialized);
    }

    void checkEnv() throws RunRecoveryException {
        this.cursorImpl.checkEnv();
    }

    void trace(Level level, String methodName, DatabaseEntry key, DatabaseEntry data, LockMode lockMode) {
        if (this.logger.isLoggable(level)) {
            StringBuffer sb = new StringBuffer();
            sb.append(methodName);
            this.traceCursorImpl(sb);
            if (key != null) {
                sb.append(" key=").append(key.dumpData());
            }
            if (data != null) {
                sb.append(" data=").append(data.dumpData());
            }
            if (lockMode != null) {
                sb.append(" lockMode=").append(lockMode);
            }
            this.logger.log(level, sb.toString());
        }
    }

    void trace(Level level, String methodName, LockMode lockMode) {
        if (this.logger.isLoggable(level)) {
            StringBuffer sb = new StringBuffer();
            sb.append(methodName);
            this.traceCursorImpl(sb);
            if (lockMode != null) {
                sb.append(" lockMode=").append(lockMode);
            }
            this.logger.log(level, sb.toString());
        }
    }

    private void traceCursorImpl(StringBuffer sb) {
        sb.append(" locker=").append(this.cursorImpl.getLocker().getId());
        if (this.cursorImpl.getBIN() != null) {
            sb.append(" bin=").append(this.cursorImpl.getBIN().getNodeId());
        }
        sb.append(" idx=").append(this.cursorImpl.getIndex());
        if (this.cursorImpl.getDupBIN() != null) {
            sb.append(" Dbin=").append(this.cursorImpl.getDupBIN().getNodeId());
        }
        sb.append(" dupIdx=").append(this.cursorImpl.getDupIndex());
    }

    static {
        $assertionsDisabled = !Cursor.class.desiredAssertionStatus();
    }
}

