/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.bind.tuple;

import com.sleepycat.util.FastOutputStream;
import com.sleepycat.util.PackedInteger;
import com.sleepycat.util.UtfOps;

public class TupleOutput
extends FastOutputStream {
    static final int NULL_STRING_UTF_VALUE = -1;

    public TupleOutput() {
    }

    public TupleOutput(byte[] buffer) {
        super(buffer);
    }

    public final TupleOutput writeBytes(String val) {
        this.writeBytes(val.toCharArray());
        return this;
    }

    public final TupleOutput writeChars(String val) {
        this.writeChars(val.toCharArray());
        return this;
    }

    public final TupleOutput writeString(String val) {
        if (val != null) {
            this.writeString(val.toCharArray());
        } else {
            this.writeFast(-1);
        }
        this.writeFast(0);
        return this;
    }

    public final TupleOutput writeChar(int val) {
        this.writeFast((byte)(val >>> 8));
        this.writeFast((byte)val);
        return this;
    }

    public final TupleOutput writeBoolean(boolean val) {
        this.writeFast(val ? 1 : 0);
        return this;
    }

    public final TupleOutput writeByte(int val) {
        this.writeUnsignedByte(val ^ 0x80);
        return this;
    }

    public final TupleOutput writeShort(int val) {
        this.writeUnsignedShort(val ^ 0x8000);
        return this;
    }

    public final TupleOutput writeInt(int val) {
        this.writeUnsignedInt(val ^ Integer.MIN_VALUE);
        return this;
    }

    public final TupleOutput writeLong(long val) {
        this.writeUnsignedLong(val ^ Long.MIN_VALUE);
        return this;
    }

    public final TupleOutput writeFloat(float val) {
        this.writeUnsignedInt(Float.floatToIntBits(val));
        return this;
    }

    public final TupleOutput writeDouble(double val) {
        this.writeUnsignedLong(Double.doubleToLongBits(val));
        return this;
    }

    public final TupleOutput writeSortedFloat(float val) {
        int intVal;
        this.writeUnsignedInt(intVal ^= (intVal = Float.floatToIntBits(val)) < 0 ? -1 : Integer.MIN_VALUE);
        return this;
    }

    public final TupleOutput writeSortedDouble(double val) {
        long longVal;
        this.writeUnsignedLong(longVal ^= (longVal = Double.doubleToLongBits(val)) < 0L ? -1L : Long.MIN_VALUE);
        return this;
    }

    public final TupleOutput writeBytes(char[] chars) {
        for (int i = 0; i < chars.length; ++i) {
            this.writeFast((byte)chars[i]);
        }
        return this;
    }

    public final TupleOutput writeChars(char[] chars) {
        for (int i = 0; i < chars.length; ++i) {
            this.writeFast((byte)(chars[i] >>> 8));
            this.writeFast((byte)chars[i]);
        }
        return this;
    }

    public final TupleOutput writeString(char[] chars) {
        if (chars.length == 0) {
            return this;
        }
        int utfLength = UtfOps.getByteLength(chars);
        this.makeSpace(utfLength);
        UtfOps.charsToBytes(chars, 0, this.getBufferBytes(), this.getBufferLength(), chars.length);
        this.addSize(utfLength);
        return this;
    }

    public final TupleOutput writeUnsignedByte(int val) {
        this.writeFast(val);
        return this;
    }

    public final TupleOutput writeUnsignedShort(int val) {
        this.writeFast((byte)(val >>> 8));
        this.writeFast((byte)val);
        return this;
    }

    public final TupleOutput writeUnsignedInt(long val) {
        this.writeFast((byte)(val >>> 24));
        this.writeFast((byte)(val >>> 16));
        this.writeFast((byte)(val >>> 8));
        this.writeFast((byte)val);
        return this;
    }

    private final TupleOutput writeUnsignedLong(long val) {
        this.writeFast((byte)(val >>> 56));
        this.writeFast((byte)(val >>> 48));
        this.writeFast((byte)(val >>> 40));
        this.writeFast((byte)(val >>> 32));
        this.writeFast((byte)(val >>> 24));
        this.writeFast((byte)(val >>> 16));
        this.writeFast((byte)(val >>> 8));
        this.writeFast((byte)val);
        return this;
    }

    public final void writePackedInt(int val) {
        this.makeSpace(5);
        int oldLen = this.getBufferLength();
        int newLen = PackedInteger.writeInt(this.getBufferBytes(), oldLen, val);
        this.addSize(newLen - oldLen);
    }
}

