/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.persist.raw;

import com.sleepycat.persist.raw.RawType;
import java.util.Arrays;
import java.util.Map;
import java.util.TreeSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RawObject {
    private static final String INDENT = "  ";
    private RawType type;
    private Map<String, Object> values;
    private Object[] elements;
    private String enumConstant;
    private RawObject superObject;

    public RawObject(RawType type, Map<String, Object> values, RawObject superObject) {
        if (type == null || values == null) {
            throw new NullPointerException();
        }
        this.type = type;
        this.values = values;
        this.superObject = superObject;
    }

    public RawObject(RawType type, Object[] elements) {
        if (type == null || elements == null) {
            throw new NullPointerException();
        }
        this.type = type;
        this.elements = elements;
    }

    public RawObject(RawType type, String enumConstant) {
        if (type == null || enumConstant == null) {
            throw new NullPointerException();
        }
        this.type = type;
        this.enumConstant = enumConstant;
    }

    public RawType getType() {
        return this.type;
    }

    public Map<String, Object> getValues() {
        return this.values;
    }

    public Object[] getElements() {
        return this.elements;
    }

    public String getEnum() {
        return this.enumConstant;
    }

    public RawObject getSuper() {
        return this.superObject;
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof RawObject)) {
            return false;
        }
        RawObject o = (RawObject)other;
        if (this.type != o.type) {
            return false;
        }
        if (!Arrays.deepEquals(this.elements, o.elements)) {
            return false;
        }
        if (this.values != null ? !((Object)this.values).equals(o.values) : o.values != null) {
            return false;
        }
        return !(this.superObject != null ? !this.superObject.equals(o.superObject) : o.superObject != null);
    }

    public String toString() {
        StringBuffer buf = new StringBuffer(500);
        this.formatRawObject(buf, "", null, false);
        return buf.toString();
    }

    private void formatRawObject(StringBuffer buf, String indent, String id, boolean isSuper) {
        String endTag;
        String indent2 = indent + INDENT;
        buf.append(indent);
        if (this.type.isArray()) {
            buf.append("<Array");
            endTag = "</Array>";
        } else if (this.type.isEnum()) {
            buf.append("<Enum");
            endTag = "</Enum>";
        } else if (isSuper) {
            buf.append("<Super");
            endTag = "</Super>";
        } else {
            buf.append("<Object");
            endTag = "</Object>";
        }
        if (id != null) {
            RawObject.formatId(buf, id);
        }
        if (this.type.isArray()) {
            buf.append(" length=\"");
            buf.append(this.elements.length);
            buf.append('\"');
        }
        buf.append(" class=\"");
        buf.append(this.type.getClassName());
        buf.append("\">\n");
        if (this.superObject != null) {
            this.superObject.formatRawObject(buf, indent2, null, true);
        }
        if (this.type.isArray()) {
            for (int i = 0; i < this.elements.length; ++i) {
                RawObject.formatValue(buf, indent2, String.valueOf(i), this.elements[i]);
            }
        } else if (this.type.isEnum()) {
            buf.append(this.enumConstant);
        } else {
            TreeSet<String> keys = new TreeSet<String>(this.values.keySet());
            for (String name : keys) {
                RawObject.formatValue(buf, indent2, name, this.values.get(name));
            }
        }
        buf.append(indent);
        buf.append(endTag);
        buf.append("\n");
    }

    private static void formatValue(StringBuffer buf, String indent, String id, Object val) {
        if (val == null) {
            buf.append(indent);
            buf.append("<Null");
            RawObject.formatId(buf, id);
            buf.append("/>\n");
        } else if (val instanceof RawObject) {
            ((RawObject)val).formatRawObject(buf, indent, id, false);
        } else {
            buf.append(indent);
            buf.append("<Value");
            RawObject.formatId(buf, id);
            buf.append(" class=");
            buf.append(val.getClass().getName());
            buf.append("\">");
            buf.append(val.toString());
            buf.append("</Value>\n");
        }
    }

    private static void formatId(StringBuffer buf, String id) {
        if (Character.isDigit(id.charAt(0))) {
            buf.append(" index=\"");
        } else {
            buf.append(" field=\"");
        }
        buf.append(id);
        buf.append('\"');
    }
}

