/*-
* See the file LICENSE for redistribution information.
*
* Copyright (c) 2002-2005
*      Sleepycat Software.  All rights reserved.
*
* $Id: DBINReference.java,v 1.10 2004/12/22 14:11:35 linda Exp $
*/

package com.sleepycat.je.tree;

import com.sleepycat.je.dbi.DatabaseId;

/**
 * A class that embodies a reference to a DBIN that does not rely on a
 * java reference to the actual DBIN.
 */
public class DBINReference extends BINReference {
    private Key dupKey;

    DBINReference(long nodeId, DatabaseId databaseId, Key idKey, Key dupKey) {
	super(nodeId, databaseId, idKey);
	this.dupKey = dupKey;
    }

    public Key getKey() {
	return dupKey;
    }

    public Key getData() {
	return idKey;
    }

    public String toString() {
	return super.toString() + " dupKey=" + dupKey;
    }
}

