/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.je.tree;

import com.sleepycat.je.DatabaseException;
import com.sleepycat.je.config.EnvironmentParams;
import com.sleepycat.je.dbi.CursorImpl;
import com.sleepycat.je.dbi.DatabaseImpl;
import com.sleepycat.je.dbi.DbConfigManager;
import com.sleepycat.je.dbi.EnvironmentImpl;
import com.sleepycat.je.dbi.INList;
import com.sleepycat.je.latch.Latch;
import com.sleepycat.je.log.LogManager;
import com.sleepycat.je.log.LogReadable;
import com.sleepycat.je.log.LogUtils;
import com.sleepycat.je.log.LogWritable;
import com.sleepycat.je.tree.BIN;
import com.sleepycat.je.tree.BINBoundary;
import com.sleepycat.je.tree.ChildReference;
import com.sleepycat.je.tree.DBIN;
import com.sleepycat.je.tree.DIN;
import com.sleepycat.je.tree.DupCountLN;
import com.sleepycat.je.tree.IN;
import com.sleepycat.je.tree.INDeleteInfo;
import com.sleepycat.je.tree.INDupDeleteInfo;
import com.sleepycat.je.tree.InconsistentNodeException;
import com.sleepycat.je.tree.Key;
import com.sleepycat.je.tree.LN;
import com.sleepycat.je.tree.Node;
import com.sleepycat.je.tree.NodeNotEmptyException;
import com.sleepycat.je.tree.SearchResult;
import com.sleepycat.je.tree.SplitRequiredException;
import com.sleepycat.je.tree.TrackingInfo;
import com.sleepycat.je.tree.TreeLocation;
import com.sleepycat.je.tree.TreeStats;
import com.sleepycat.je.tree.TreeUtils;
import com.sleepycat.je.tree.TreeWalkerStatsAccumulator;
import com.sleepycat.je.tree.WithRootLatched;
import com.sleepycat.je.txn.BasicLocker;
import com.sleepycat.je.txn.LockGrantType;
import com.sleepycat.je.txn.LockResult;
import com.sleepycat.je.txn.LockType;
import com.sleepycat.je.txn.Locker;
import com.sleepycat.je.utilint.DbLsn;
import com.sleepycat.je.utilint.Tracer;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.ListIterator;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;

public final class Tree
implements LogWritable,
LogReadable {
    private static final String TRACE_ROOT_SPLIT = "RootSplit:";
    private static final String TRACE_DUP_ROOT_SPLIT = "DupRootSplit:";
    private static final String TRACE_MUTATE = "Mut:";
    private static final String TRACE_INSERT = "Ins:";
    private static final String TRACE_INSERT_DUPLICATE = "InsD:";
    private DatabaseImpl database;
    private ChildReference root;
    private int maxEntriesPerNode;
    private Latch rootLatch;
    private TreeStats treeStats;
    private ThreadLocal treeStatsAccumulatorTL = new ThreadLocal();
    static final /* synthetic */ boolean $assertionsDisabled;

    public Tree(DatabaseImpl database) throws DatabaseException {
        this.init(database);
        this.maxEntriesPerNode = this.getMaxEntriesFromConfig(database);
    }

    public Tree() {
        this.init(null);
        this.maxEntriesPerNode = 0;
    }

    private void init(DatabaseImpl database) {
        this.rootLatch = new Latch("RootLatch", database != null ? database.getDbEnvironment() : null);
        this.treeStats = new TreeStats();
        this.root = null;
        this.database = database;
    }

    public void setDatabase(DatabaseImpl database) throws DatabaseException {
        this.database = database;
        this.maxEntriesPerNode = this.getMaxEntriesFromConfig(database);
    }

    private int getMaxEntriesFromConfig(DatabaseImpl database) throws DatabaseException {
        DbConfigManager configManager = database.getDbEnvironment().getConfigManager();
        return configManager.getInt(EnvironmentParams.NODE_MAX);
    }

    public DatabaseImpl getDatabase() {
        return this.database;
    }

    public void setRoot(ChildReference newRoot) {
        this.root = newRoot;
    }

    TreeStats getTreeStats() {
        return this.treeStats;
    }

    private TreeWalkerStatsAccumulator getTreeStatsAccumulator() {
        if (EnvironmentImpl.getThreadLocalReferenceCount() > 0) {
            return (TreeWalkerStatsAccumulator)this.treeStatsAccumulatorTL.get();
        }
        return null;
    }

    public void setTreeStatsAccumulator(TreeWalkerStatsAccumulator tSA) {
        this.treeStatsAccumulatorTL.set(tSA);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IN withRootLatched(WithRootLatched wrl) throws DatabaseException {
        try {
            this.rootLatch.acquire();
            IN iN = wrl.doWork(this.root);
            return iN;
        }
        finally {
            this.rootLatch.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean delete(Key idKey, Set modifiedFileSummaries) throws DatabaseException {
        INList inMemoryINs = this.database.getDbEnvironment().getInMemoryINs();
        boolean treeEmpty = false;
        IN subtreeRoot = null;
        subtreeRoot = this.search(idKey, SearchType.DELETE, -1L, null);
        LogManager logManager = this.database.getDbEnvironment().getLogManager();
        if (subtreeRoot == null) {
            this.rootLatch.acquire();
            try {
                IN rootIN = (IN)this.root.fetchTarget(this.database, null);
                DbConfigManager configManager = this.database.getDbEnvironment().getConfigManager();
                boolean purgeRoot = configManager.getBoolean(EnvironmentParams.COMPRESSOR_PURGE_ROOT);
                if (!purgeRoot || rootIN.getNEntries() > 1 || !rootIN.validateSubtreeBeforeDelete(0)) return treeEmpty;
                this.accountForSubtreeRemoval(inMemoryINs, rootIN, modifiedFileSummaries);
                this.root = null;
                treeEmpty = true;
                logManager.log(new INDeleteInfo(rootIN.getNodeId(), rootIN.getIdentifierKey(), this.database.getId()));
                return treeEmpty;
            }
            finally {
                this.rootLatch.release();
            }
        }
        try {
            int index = subtreeRoot.findEntry(idKey, false, false);
            IN subtreeRootIN = (IN)subtreeRoot.fetchTarget(index);
            this.accountForSubtreeRemoval(inMemoryINs, subtreeRootIN, modifiedFileSummaries);
            boolean deleteOk = subtreeRoot.deleteEntry(index, true);
            if (!$assertionsDisabled && !deleteOk) {
                throw new AssertionError();
            }
            logManager.log(new INDeleteInfo(subtreeRootIN.getNodeId(), subtreeRootIN.getIdentifierKey(), this.database.getId()));
            return treeEmpty;
        }
        finally {
            subtreeRoot.getLatch().release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public boolean deleteDup(Key idKey, Key dupKey, Set modifiedFileSummaries) throws DatabaseException {
        block27: {
            block28: {
                block29: {
                    ret = true;
                    env = this.database.getDbEnvironment();
                    inMemoryINs = env.getInMemoryINs();
                    in = this.search(dupKey, SearchType.NORMAL, -1L, null);
                    if (!Tree.$assertionsDisabled && !in.getLatch().isOwner()) {
                        throw new AssertionError();
                    }
                    if (!Tree.$assertionsDisabled && !(in instanceof BIN)) {
                        throw new AssertionError();
                    }
                    if (!Tree.$assertionsDisabled && in.getNEntries() <= 0) {
                        throw new AssertionError();
                    }
                    duplicateRoot = null;
                    dupCountLNLocked = false;
                    dcl = null;
                    locker = new BasicLocker(env);
                    logManager = this.database.getDbEnvironment().getLogManager();
                    index = in.findEntry(dupKey, false, true);
                    try {
                        if (index < 0) break block27;
                        duplicateRoot = (DIN)in.fetchTarget(index);
                        duplicateRoot.latch();
                        dclRef = duplicateRoot.getDupCountLNRef();
                        dcl = (DupCountLN)dclRef.fetchTarget(this.database, duplicateRoot);
                        if (locker.nonBlockingReadLock(dcl.getNodeId(), this.database) != LockGrantType.DENIED) break block28;
                        var15_15 = false;
                        var21_17 = null;
                        if (!in.getLatch().isOwner()) break block29;
                    }
                    catch (Throwable var20_28) {
                        var21_19 = null;
                        if (in.getLatch().isOwner()) {
                            in.releaseLatch();
                        }
                        if (duplicateRoot.getLatch().isOwner()) {
                            duplicateRoot.releaseLatch();
                        }
                        if (dupCountLNLocked) {
                            locker.releaseLock(dcl.getNodeId());
                        }
                        throw var20_28;
                    }
                    in.releaseLatch();
                }
                if (duplicateRoot.getLatch().isOwner()) {
                    duplicateRoot.releaseLatch();
                }
                if (dupCountLNLocked) {
                    locker.releaseLock(dcl.getNodeId());
                }
                return var15_15;
            }
            dupCountLNLocked = true;
            try {
                subtreeRoot = this.searchSubTree(duplicateRoot, idKey, SearchType.DELETE, -1L, null);
            }
            catch (NodeNotEmptyException NNEE) {
                in.releaseLatch();
                throw NNEE;
            }
            if (subtreeRoot == null) {
                bin = (BIN)in;
                if (bin.nCursors() == 0) {
                    try {
                        duplicateRoot.latch();
                        if (!duplicateRoot.isValidForDelete()) ** GOTO lbl73
                        this.accountForSubtreeRemoval(inMemoryINs, duplicateRoot, modifiedFileSummaries);
                        deleteOk = bin.deleteEntry(index, true);
                        if (!Tree.$assertionsDisabled && !deleteOk) {
                            throw new AssertionError();
                        }
                        logManager.log(new INDupDeleteInfo(duplicateRoot.getNodeId(), duplicateRoot.getMainTreeKey(), duplicateRoot.getDupTreeKey(), this.database.getId()));
                        if (bin.getNEntries() != 0) ** GOTO lbl73
                        this.database.getDbEnvironment().addToCompressorQueue(bin, null);
                    }
                    finally {
                        duplicateRoot.releaseLatch();
                    }
                } else {
                    ret = false;
                }
lbl73:
                // 4 sources

                in.releaseLatch();
                break block27;
            }
            try {
                in.releaseLatch();
                dupIndex = subtreeRoot.findEntry(idKey, false, false);
                rootIN = (IN)subtreeRoot.fetchTarget(dupIndex);
                this.accountForSubtreeRemoval(inMemoryINs, rootIN, modifiedFileSummaries);
                deleteOk = subtreeRoot.deleteEntry(dupIndex, true);
                if (!Tree.$assertionsDisabled && !deleteOk) {
                    throw new AssertionError();
                }
                logManager.log(new INDupDeleteInfo(rootIN.getNodeId(), rootIN.getMainTreeKey(), rootIN.getDupTreeKey(), this.database.getId()));
            }
            finally {
                subtreeRoot.getLatch().release();
            }
        }
        var21_18 = null;
        if (in.getLatch().isOwner()) {
            in.releaseLatch();
        }
        if (duplicateRoot.getLatch().isOwner()) {
            duplicateRoot.releaseLatch();
        }
        if (dupCountLNLocked) {
            locker.releaseLock(dcl.getNodeId());
        }
        return ret;
    }

    public IN getFirstNode() throws DatabaseException {
        return this.search(null, SearchType.LEFT, -1L, null);
    }

    public IN getLastNode() throws DatabaseException {
        return this.search(null, SearchType.RIGHT, -1L, null);
    }

    public DBIN getFirstNode(DIN duplicateRoot) throws DatabaseException {
        if (duplicateRoot == null) {
            throw new IllegalArgumentException("getFirstNode passed null root");
        }
        if (!$assertionsDisabled && !duplicateRoot.getLatch().isOwner()) {
            throw new AssertionError();
        }
        IN ret = this.searchSubTree(duplicateRoot, null, SearchType.LEFT, -1L, null);
        return (DBIN)ret;
    }

    public DBIN getLastNode(DIN duplicateRoot) throws DatabaseException {
        if (duplicateRoot == null) {
            throw new IllegalArgumentException("getLastNode passed null root");
        }
        if (!$assertionsDisabled && !duplicateRoot.getLatch().isOwner()) {
            throw new AssertionError();
        }
        IN ret = this.searchSubTree(duplicateRoot, null, SearchType.RIGHT, -1L, null);
        return (DBIN)ret;
    }

    public SearchResult getParentINForChildIN(IN child, boolean requireExactMatch) throws DatabaseException {
        return this.getParentINForChildIN(child, requireExactMatch, null);
    }

    public SearchResult getParentINForChildIN(IN child, boolean requireExactMatch, List trackingList) throws DatabaseException {
        if (child == null) {
            throw new IllegalArgumentException("getParentNode passed null");
        }
        if (!$assertionsDisabled && !child.getLatch().isOwner()) {
            throw new AssertionError();
        }
        Key mainTreeKey = child.getMainTreeKey();
        Key dupTreeKey = child.getDupTreeKey();
        boolean isRoot = child.isRoot();
        child.releaseLatch();
        return this.getParentINForChildIN(child.getNodeId(), child.containsDuplicates(), isRoot, mainTreeKey, dupTreeKey, requireExactMatch, trackingList, true);
    }

    public SearchResult getParentINForChildIN(long targetNodeId, boolean targetContainsDuplicates, boolean targetIsRoot, Key targetMainTreeKey, Key targetDupTreeKey, boolean requireExactMatch, List trackingList, boolean doFetch) throws DatabaseException {
        IN rootIN = this.getRootIN();
        SearchResult result = new SearchResult();
        if (rootIN != null) {
            if (trackingList != null) {
                trackingList.add(new TrackingInfo(this.root.getLsn(), rootIN.getNodeId()));
            }
            IN potentialParent = rootIN;
            try {
                while (result.keepSearching) {
                    potentialParent.findParent(SearchType.NORMAL, targetNodeId, targetContainsDuplicates, targetIsRoot, targetMainTreeKey, targetDupTreeKey, result, requireExactMatch, trackingList, doFetch);
                    potentialParent = result.parent;
                }
            }
            catch (Exception e) {
                if (potentialParent.getLatch().isOwner()) {
                    potentialParent.releaseLatch();
                }
                throw new DatabaseException(e);
            }
        }
        return result;
    }

    public boolean getParentBINForChildLN(TreeLocation location, Key mainKey, Key dupKey, LN ln, boolean splitsAllowed, boolean findDeletedEntries, boolean searchDupTree) throws DatabaseException {
        IN searchResult = null;
        try {
            searchResult = splitsAllowed ? this.searchSplitsAllowed(mainKey, ln.getNodeId()) : this.search(mainKey, SearchType.NORMAL, ln.getNodeId(), null);
            location.bin = (BIN)searchResult;
        }
        catch (Exception e) {
            StringBuffer msg = new StringBuffer();
            if (searchResult != null) {
                if (searchResult.getLatch().isOwner()) {
                    searchResult.releaseLatch();
                }
                msg.append("searchResult=" + searchResult.getClass() + " nodeId=" + searchResult.getNodeId() + " nEntries=" + searchResult.getNEntries());
            }
            throw new DatabaseException(msg.toString(), e);
        }
        if (location.bin == null) {
            return false;
        }
        boolean exactSearch = false;
        boolean indicateIfExact = true;
        if (!findDeletedEntries) {
            exactSearch = true;
            indicateIfExact = false;
        }
        location.index = location.bin.findEntry(mainKey, indicateIfExact, exactSearch);
        boolean match = false;
        if (findDeletedEntries) {
            match = location.index >= 0 && (location.index & 0x10000) != 0;
            location.index &= 0xFFFEFFFF;
        } else {
            boolean bl = match = location.index >= 0;
        }
        if (match) {
            if (!location.bin.isEntryKnownDeleted(location.index) && this.database.getSortedDuplicates()) {
                Node childNode = location.bin.fetchTarget(location.index);
                if (ln.containsDuplicates()) {
                    return this.searchDupTreeForDupCountLNParent(location, mainKey, childNode);
                }
                if (childNode.containsDuplicates()) {
                    if (dupKey == null) {
                        return this.searchDupTreeByNodeId(location, childNode, ln, searchDupTree);
                    }
                    return this.searchDupTreeForDBIN(location, dupKey, (DIN)childNode, ln, findDeletedEntries, indicateIfExact, exactSearch, splitsAllowed);
                }
            }
            location.childLsn = location.bin.getLsn(location.index);
            return true;
        }
        location.lnKey = mainKey;
        return false;
    }

    private boolean searchDupTreeByNodeId(TreeLocation location, Node childNode, LN ln, boolean searchDupTree) throws DatabaseException {
        if (searchDupTree) {
            BIN oldBIN = location.bin;
            if (childNode.matchLNByNodeId(location, ln.getNodeId())) {
                location.index &= 0xFFFEFFFF;
                if (oldBIN != null) {
                    oldBIN.releaseLatch();
                }
                location.bin.latch();
                return true;
            }
            return false;
        }
        return false;
    }

    private boolean searchDupTreeForDupCountLNParent(TreeLocation location, Key mainKey, Node childNode) throws DatabaseException {
        location.lnKey = mainKey;
        if (childNode instanceof DIN) {
            DIN duplicateRoot = (DIN)childNode;
            location.childLsn = duplicateRoot.getDupCountLNRef().getLsn();
            return true;
        }
        return false;
    }

    private boolean searchDupTreeForDBIN(TreeLocation location, Key dupKey, DIN duplicateRoot, LN ln, boolean findDeletedEntries, boolean indicateIfExact, boolean exactSearch, boolean splitsAllowed) throws DatabaseException {
        boolean match;
        duplicateRoot.latch();
        if (this.maybeSplitDuplicateRoot(location.bin, location.index)) {
            duplicateRoot = (DIN)location.bin.fetchTarget(location.index);
        }
        location.bin.releaseLatch();
        location.lnKey = dupKey == null ? new Key(ln.getData()) : dupKey;
        location.bin = splitsAllowed ? (BIN)this.searchSubTreeSplitsAllowed(duplicateRoot, location.lnKey, ln.getNodeId()) : (BIN)this.searchSubTree(duplicateRoot, location.lnKey, SearchType.NORMAL, ln.getNodeId(), null);
        location.index = location.bin.findEntry(location.lnKey, indicateIfExact, exactSearch);
        if (findDeletedEntries) {
            match = location.index >= 0 && (location.index & 0x10000) != 0;
            location.index &= 0xFFFEFFFF;
        } else {
            boolean bl = match = location.index >= 0;
        }
        if (match) {
            location.childLsn = location.bin.getLsn(location.index);
            return true;
        }
        return false;
    }

    public BIN getNextBin(BIN bin, DIN duplicateRoot) throws DatabaseException {
        return this.getNextBinInternal(duplicateRoot, bin, true);
    }

    public BIN getPrevBin(BIN bin, DIN duplicateRoot) throws DatabaseException {
        return this.getNextBinInternal(duplicateRoot, bin, false);
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    private BIN getNextBinInternal(DIN duplicateRoot, BIN bin, boolean forward) throws DatabaseException {
        Key idKey = null;
        int nEntries = bin.getNEntries();
        idKey = !forward || nEntries == 0 ? (nEntries == 0 ? bin.getIdentifierKey() : bin.getKey(0)) : bin.getKey(bin.getNEntries() - 1);
        BIN bIN = bin;
        bIN.latch();
        if (!$assertionsDisabled && Latch.countLatchesHeld() != 1) {
            throw new AssertionError((Object)Latch.latchesHeldToString());
        }
        while (true) {
            IN parent;
            block19: {
                void var6_7;
                parent = null;
                SearchResult result = null;
                if (duplicateRoot == null) {
                    result = this.getParentINForChildIN((IN)var6_7, true);
                    if (result.exactParentFound) {
                        parent = result.parent;
                        break block19;
                    } else {
                        if (!$assertionsDisabled && Latch.countLatchesHeld() != 0) {
                            throw new AssertionError((Object)Latch.latchesHeldToString());
                        }
                        return null;
                    }
                }
                if (var6_7 == duplicateRoot) {
                    var6_7.releaseLatch();
                    return null;
                }
                result = this.getParentINForChildIN((IN)var6_7, true);
                if (!result.exactParentFound) {
                    return null;
                }
                parent = result.parent;
            }
            if (!$assertionsDisabled && Latch.countLatchesHeld() != 1) {
                throw new AssertionError((Object)Latch.latchesHeldToString());
            }
            int index = parent.findEntry(idKey, false, false);
            boolean moreEntriesThisBin = false;
            if (forward) {
                if (++index < parent.getNEntries()) {
                    moreEntriesThisBin = true;
                }
            } else {
                if (index > 0) {
                    moreEntriesThisBin = true;
                }
                --index;
            }
            if (moreEntriesThisBin) {
                IN nextIN = (IN)parent.fetchTarget(index);
                nextIN.latch();
                if (!$assertionsDisabled && Latch.countLatchesHeld() != 2) {
                    throw new AssertionError((Object)Latch.latchesHeldToString());
                }
                if (nextIN instanceof BIN) {
                    parent.releaseLatch();
                    TreeWalkerStatsAccumulator treeStatsAccumulator = this.getTreeStatsAccumulator();
                    if (treeStatsAccumulator != null) {
                        nextIN.accumulateStats(treeStatsAccumulator);
                    }
                    return (BIN)nextIN;
                }
                IN ret = this.searchSubTree(nextIN, null, forward ? SearchType.LEFT : SearchType.RIGHT, -1L, null);
                parent.releaseLatch();
                if (!$assertionsDisabled && Latch.countLatchesHeld() != 1) {
                    throw new AssertionError((Object)Latch.latchesHeldToString());
                }
                if (ret instanceof BIN) {
                    return (BIN)ret;
                }
                throw new InconsistentNodeException("subtree did not have a BIN for leaf");
            }
            IN iN = parent;
        }
    }

    private void splitRoot() throws DatabaseException {
        EnvironmentImpl env = this.database.getDbEnvironment();
        LogManager logManager = env.getLogManager();
        INList inMemoryINs = env.getInMemoryINs();
        IN curRoot = null;
        curRoot = (IN)this.root.fetchTarget(this.database, null);
        curRoot.latch();
        Key rootIdKey = curRoot.getKey(0);
        IN newRoot = new IN(this.database, rootIdKey, this.maxEntriesPerNode, curRoot.getLevel() + 1);
        newRoot.setIsRoot(true);
        curRoot.setIsRoot(false);
        long curRootLsn = curRoot.logProvisional(logManager);
        boolean insertOk = newRoot.insertEntry(new ChildReference(curRoot, rootIdKey, curRootLsn));
        if (!$assertionsDisabled && !insertOk) {
            throw new AssertionError();
        }
        long logLsn = newRoot.log(logManager);
        inMemoryINs.add(newRoot);
        this.root.setTarget(newRoot);
        this.root.setLsn(logLsn);
        curRoot.split(newRoot, 0, this.maxEntriesPerNode);
        this.root.setLsn(newRoot.getLastFullVersion());
        curRoot.releaseLatch();
        ++this.treeStats.nRootSplits;
        this.traceSplitRoot(Level.FINE, TRACE_ROOT_SPLIT, newRoot, logLsn, curRoot, curRootLsn);
    }

    public IN search(Key key, SearchType searchType, long nid, BINBoundary binBoundary) throws DatabaseException {
        IN rootIN = this.getRootIN();
        if (rootIN != null) {
            return this.searchSubTree(rootIN, key, searchType, nid, binBoundary);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private IN searchSplitsAllowed(Key key, long nid) throws DatabaseException {
        this.rootLatch.acquire();
        boolean rootLatched = true;
        IN rootIN = null;
        try {
            if (this.root != null) {
                rootIN = (IN)this.root.fetchTarget(this.database, null);
                if (rootIN.needsSplitting()) {
                    this.splitRoot();
                    this.rootLatch.release();
                    rootLatched = false;
                    EnvironmentImpl env = this.database.getDbEnvironment();
                    env.getDbMapTree().modifyDbRoot(this.database);
                    this.rootLatch.acquire();
                    rootLatched = true;
                    rootIN = (IN)this.root.fetchTarget(this.database, null);
                }
                rootIN.latch();
            }
        }
        finally {
            if (rootLatched) {
                this.rootLatch.release();
            }
        }
        return this.searchSubTreeSplitsAllowed(rootIN, key, nid);
    }

    /*
     * WARNING - void declaration
     */
    public IN searchSubTree(IN parent, Key key, SearchType searchType, long nid, BINBoundary binBoundary) throws DatabaseException {
        if (parent == null) {
            return null;
        }
        if ((searchType == SearchType.LEFT || searchType == SearchType.RIGHT) && key != null) {
            throw new IllegalArgumentException("searchSubTree passed key and left/right search");
        }
        if (searchType == SearchType.DELETE && (key == null || nid != -1L)) {
            throw new IllegalArgumentException("bad arguments for DELETE style search");
        }
        if (!$assertionsDisabled && !parent.getLatch().isOwner()) {
            throw new AssertionError();
        }
        if (parent.getNodeId() == nid) {
            parent.releaseLatch();
            return null;
        }
        if (binBoundary != null) {
            binBoundary.isLastBin = true;
            binBoundary.isFirstBin = true;
        }
        IN child = null;
        IN lowestMultipleEntryIN = null;
        TreeWalkerStatsAccumulator treeStatsAccumulator = this.getTreeStatsAccumulator();
        do {
            void var7_9;
            int index;
            if (treeStatsAccumulator != null) {
                parent.accumulateStats(treeStatsAccumulator);
            }
            if (parent.getNEntries() == 0) {
                return parent;
            }
            if (searchType == SearchType.NORMAL) {
                index = parent.findEntry(key, false, false);
            } else if (searchType == SearchType.LEFT) {
                index = 0;
            } else if (searchType == SearchType.RIGHT) {
                index = parent.getNEntries() - 1;
            } else if (searchType == SearchType.DELETE) {
                index = parent.findEntry(key, false, false);
                if (parent.getNEntries() > 1) {
                    if (lowestMultipleEntryIN != null) {
                        lowestMultipleEntryIN.releaseLatch();
                    }
                    lowestMultipleEntryIN = parent;
                }
            } else {
                throw new IllegalArgumentException("Invalid value of searchType: " + searchType);
            }
            if (!$assertionsDisabled && var7_9 < 0) {
                throw new AssertionError();
            }
            if (binBoundary != null) {
                if (var7_9 != parent.getNEntries() - 1) {
                    binBoundary.isLastBin = false;
                }
                if (var7_9 != false) {
                    binBoundary.isFirstBin = false;
                }
            }
            child = (IN)parent.fetchTarget((int)var7_9);
            child.latch();
            if (treeStatsAccumulator != null) {
                child.accumulateStats(treeStatsAccumulator);
            }
            if (child.getNodeId() == nid) {
                child.releaseLatch();
                return parent;
            }
            if (parent == lowestMultipleEntryIN) continue;
            parent.releaseLatch();
        } while (!((parent = child) instanceof BIN));
        if (searchType == SearchType.DELETE) {
            boolean notEmpty;
            boolean bl = notEmpty = child.getNEntries() != 0;
            if (child != lowestMultipleEntryIN) {
                child.releaseLatch();
            }
            if (lowestMultipleEntryIN == null) {
                return null;
            }
            if (notEmpty || ((BIN)child).nCursors() > 0) {
                lowestMultipleEntryIN.releaseLatch();
                throw new NodeNotEmptyException();
            }
            return lowestMultipleEntryIN;
        }
        return child;
    }

    private IN searchSubTreeSplitsAllowed(IN parent, Key key, long nid) throws DatabaseException {
        if (parent != null) {
            while (true) {
                try {
                    return this.searchSubTreeUntilSplit(parent, key, nid);
                }
                catch (SplitRequiredException e) {
                    this.forceSplit(parent, key);
                    continue;
                }
                break;
            }
        }
        return null;
    }

    private IN searchSubTreeUntilSplit(IN parent, Key key, long nid) throws DatabaseException, SplitRequiredException {
        if (parent == null) {
            return null;
        }
        if (!$assertionsDisabled && !parent.getLatch().isOwner()) {
            throw new AssertionError();
        }
        if (parent.getNodeId() == nid) {
            parent.releaseLatch();
            return null;
        }
        IN child = null;
        do {
            if (parent.getNEntries() == 0) {
                return parent;
            }
            int index = parent.findEntry(key, false, false);
            if (!$assertionsDisabled && index < 0) {
                throw new AssertionError();
            }
            child = (IN)parent.fetchTarget(index);
            child.latch();
            if (child.needsSplitting()) {
                child.releaseLatch();
                parent.releaseLatch();
                throw new SplitRequiredException();
            }
            if (child.getNodeId() == nid) {
                child.releaseLatch();
                return parent;
            }
            parent.releaseLatch();
        } while (!((parent = child) instanceof BIN));
        return parent;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void forceSplit(IN parent, Key key) throws DatabaseException {
        int index;
        ArrayList<SplitInfo> nodeLadder = new ArrayList<SplitInfo>();
        boolean allLeftSideDescent = true;
        boolean allRightSideDescent = true;
        IN child = null;
        IN originalParent = parent;
        originalParent.latch();
        while (parent.getNEntries() != 0) {
            index = parent.findEntry(key, false, false);
            if (index != 0) {
                allLeftSideDescent = false;
            }
            if (index != parent.getNEntries() - 1) {
                allRightSideDescent = false;
            }
            if (!$assertionsDisabled && index < 0) {
                throw new AssertionError();
            }
            child = (IN)parent.getTarget(index);
            if (child == null) break;
            child.latch();
            nodeLadder.add(new SplitInfo(parent, child, index));
            parent = child;
            if (!(parent instanceof BIN)) continue;
        }
        boolean startedSplits = false;
        LogManager logManager = this.database.getDbEnvironment().getLogManager();
        ListIterator iter = nodeLadder.listIterator(nodeLadder.size());
        try {
            long lastParentForSplit = -1L;
            while (iter.hasPrevious()) {
                SplitInfo info = (SplitInfo)iter.previous();
                child = info.child;
                parent = info.parent;
                index = info.index;
                if (child.needsSplitting()) {
                    if (allLeftSideDescent || allRightSideDescent) {
                        child.splitSpecial(parent, index, this.maxEntriesPerNode, key, allLeftSideDescent);
                    } else {
                        child.split(parent, index, this.maxEntriesPerNode);
                    }
                    lastParentForSplit = parent.getNodeId();
                    startedSplits = true;
                } else if (startedSplits) {
                    long newLsn = 0L;
                    newLsn = lastParentForSplit == child.getNodeId() ? child.getLastFullVersion() : child.log(logManager);
                    parent.updateEntry(index, newLsn);
                }
                child.releaseLatch();
            }
            Object var18_15 = null;
        }
        catch (Throwable throwable) {
            Object var18_16 = null;
            while (iter.hasPrevious()) {
                SplitInfo info = (SplitInfo)iter.previous();
                info.child.releaseLatch();
            }
            throw throwable;
        }
        while (iter.hasPrevious()) {
            SplitInfo info = (SplitInfo)iter.previous();
            info.child.releaseLatch();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private IN getRootIN() throws DatabaseException {
        this.rootLatch.acquire();
        IN rootIN = null;
        try {
            if (this.root != null) {
                rootIN = (IN)this.root.fetchTarget(this.database, null);
                rootIN.latch();
            }
            IN iN = rootIN;
            return iN;
        }
        finally {
            this.rootLatch.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean insert(LN ln, Key key, boolean allowDuplicates, CursorImpl cursor, LockResult lnLock) throws DatabaseException {
        BIN bin;
        block15: {
            int duplicateEntryIndex;
            INList inMemoryINs;
            LogManager logManager;
            block17: {
                int dupCount;
                block16: {
                    boolean bl;
                    this.validateInsertArgs(allowDuplicates);
                    EnvironmentImpl env = this.database.getDbEnvironment();
                    logManager = env.getLogManager();
                    inMemoryINs = env.getInMemoryINs();
                    bin = null;
                    try {
                        boolean isKnownDeleted;
                        bin = this.findBinForInsert(key, logManager, inMemoryINs, cursor);
                        if (!$assertionsDisabled && !bin.getLatch().isOwner()) {
                            throw new AssertionError();
                        }
                        ChildReference newLNRef = new ChildReference(ln, key, -1L);
                        cursor.setBIN(bin);
                        duplicateEntryIndex = bin.insertEntry1(newLNRef);
                        if ((duplicateEntryIndex & 0x20000) != 0) {
                            lnLock.setAbortLsn(-1L, true, true);
                            long newLsn = ln.log(env, this.database.getId(), key, -1L, cursor.getLocker());
                            cursor.updateBin(bin, duplicateEntryIndex &= 0xFFFDFFFF);
                            bin.updateEntry(duplicateEntryIndex, newLsn);
                            this.traceInsert(Level.FINER, env, bin, ln, newLsn, duplicateEntryIndex);
                            break block15;
                        }
                        LN currentLN = ln;
                        dupCount = -1;
                        Node n = bin.fetchTargetIgnoreKnownDeleted(duplicateEntryIndex &= 0xFFFEFFFF);
                        if (n == null || n instanceof LN) {
                            currentLN = (LN)n;
                        } else {
                            DIN duplicateRoot = (DIN)n;
                            currentLN = (DupCountLN)duplicateRoot.getDupCountLNRef().fetchTarget(this.database, duplicateRoot);
                            dupCount = ((DupCountLN)currentLN).getDupCount();
                        }
                        cursor.updateBin(bin, duplicateEntryIndex);
                        if (n != null) {
                            bin.releaseLatch();
                        }
                        Locker locker = cursor.getLocker();
                        while (n != null) {
                            locker.lock(currentLN.getNodeId(), LockType.WRITE, this.database);
                            bin = cursor.latchBIN();
                            duplicateEntryIndex = cursor.getIndex();
                            n = bin.fetchTargetIgnoreKnownDeleted(duplicateEntryIndex);
                            if (n == null) {
                                currentLN = null;
                                break;
                            }
                            if (n == currentLN || dupCount != -1) break;
                            if (n instanceof LN) {
                                currentLN = (LN)n;
                                dupCount = -1;
                            } else {
                                DIN duplicateRoot = (DIN)n;
                                currentLN = (DupCountLN)duplicateRoot.getDupCountLNRef().fetchTarget(this.database, duplicateRoot);
                                dupCount = ((DupCountLN)currentLN).getDupCount();
                            }
                            bin.releaseLatch();
                        }
                        if (!(isKnownDeleted = bin.isEntryKnownDeleted(duplicateEntryIndex)) && (dupCount != -1 || !((LN)bin.fetchTarget(duplicateEntryIndex)).isDeleted())) break block16;
                        long existingAbortLsn = -1L;
                        if (currentLN != null) {
                            existingAbortLsn = locker.getAbortLsn(currentLN.getNodeId());
                        }
                        lnLock.setAbortLsn(existingAbortLsn, isKnownDeleted);
                        long newLsn = ln.log(env, this.database.getId(), key, -1L, cursor.getLocker());
                        bin.updateEntry(duplicateEntryIndex, ln, newLsn, key);
                        bin.clearKnownDeleted(duplicateEntryIndex);
                        this.traceInsert(Level.FINER, env, bin, ln, newLsn, duplicateEntryIndex);
                        bl = true;
                        Object var23_24 = null;
                        if (bin == null) return bl;
                        if (!bin.getLatch().isOwner()) return bl;
                    }
                    catch (Throwable throwable) {
                        Object var23_28 = null;
                        if (bin == null || !bin.getLatch().isOwner()) throw throwable;
                        bin.releaseLatch();
                        throw throwable;
                    }
                    bin.releaseLatch();
                    return bl;
                }
                if (allowDuplicates || dupCount == 0) break block17;
                boolean bl = false;
                Object var23_25 = null;
                if (bin == null) return bl;
                if (!bin.getLatch().isOwner()) return bl;
                bin.releaseLatch();
                return bl;
            }
            cursor.updateBin(bin, duplicateEntryIndex);
            boolean bl = this.insertDuplicate(key, bin, ln, logManager, inMemoryINs, cursor, lnLock);
            Object var23_26 = null;
            if (bin == null) return bl;
            if (!bin.getLatch().isOwner()) return bl;
            bin.releaseLatch();
            return bl;
        }
        Object var23_27 = null;
        if (bin == null) return true;
        if (!bin.getLatch().isOwner()) return true;
        bin.releaseLatch();
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean insertDuplicate(Key key, BIN bin, LN newLN, LogManager logManager, INList inMemoryINs, CursorImpl cursor, LockResult lnLock) throws DatabaseException {
        int latchCount;
        boolean successfulInsert;
        block22: {
            block21: {
                EnvironmentImpl env = this.database.getDbEnvironment();
                int index = cursor.getIndex();
                successfulInsert = false;
                latchCount = 0;
                if (!$assertionsDisabled && (latchCount = Latch.countLatchesHeld()) <= -1) {
                    throw new AssertionError();
                }
                DIN duplicateRoot = null;
                Node n = bin.fetchTarget(index);
                if (n instanceof DIN) {
                    block20: {
                        IN duplicateBin = null;
                        try {
                            ChildReference newLNRef;
                            Key newLNKey;
                            int duplicateEntryIndex;
                            duplicateRoot = (DIN)n;
                            duplicateRoot.latch();
                            if (this.maybeSplitDuplicateRoot(bin, index)) {
                                duplicateRoot = (DIN)bin.fetchTarget(index);
                            }
                            if (((duplicateEntryIndex = (duplicateBin = (DBIN)this.searchSubTreeSplitsAllowed(duplicateRoot, newLNKey = new Key(newLN.getData()), -1L)).insertEntry1(newLNRef = new ChildReference(newLN, newLNKey, -1L))) & 0x20000) != 0) {
                                lnLock.setAbortLsn(-1L, true, true);
                                cursor.updateDBin((DBIN)duplicateBin, duplicateEntryIndex &= 0xFFFDFFFF);
                                long newLsn = newLN.log(env, this.database.getId(), key, -1L, cursor.getLocker());
                                duplicateBin.setLsn(duplicateEntryIndex, newLsn);
                                this.traceInsertDuplicate(Level.FINER, this.database.getDbEnvironment(), (BIN)duplicateBin, newLN, newLsn, bin);
                                successfulInsert = true;
                            } else {
                                boolean isKnownDeleted;
                                LN currentLN = (LN)duplicateBin.fetchTargetIgnoreKnownDeleted(duplicateEntryIndex &= 0xFFFEFFFF);
                                cursor.updateDBin((DBIN)duplicateBin, duplicateEntryIndex);
                                duplicateBin.releaseLatch();
                                Locker locker = cursor.getLocker();
                                while (currentLN != null) {
                                    locker.lock(currentLN.getNodeId(), LockType.READ, this.database);
                                    while (true) {
                                        duplicateBin = cursor.getDupBIN();
                                        duplicateBin.latch();
                                        if (duplicateBin == cursor.getDupBIN()) break;
                                        duplicateBin.releaseLatch();
                                    }
                                    duplicateEntryIndex = cursor.getDupIndex();
                                    n = duplicateBin.fetchTargetIgnoreKnownDeleted(duplicateEntryIndex);
                                    if (n == null) {
                                        currentLN = null;
                                        break;
                                    }
                                    if (n == currentLN) break;
                                    duplicateBin.releaseLatch();
                                    currentLN = (LN)n;
                                }
                                if ((isKnownDeleted = duplicateBin.isEntryKnownDeleted(duplicateEntryIndex)) || currentLN.isDeleted()) {
                                    cursor.updateDBin((DBIN)duplicateBin, duplicateEntryIndex);
                                    long existingAbortLsn = -1L;
                                    if (currentLN != null) {
                                        existingAbortLsn = locker.getAbortLsn(currentLN.getNodeId());
                                    }
                                    lnLock.setAbortLsn(existingAbortLsn, isKnownDeleted);
                                    long newLsn = newLN.log(env, this.database.getId(), key, -1L, cursor.getLocker());
                                    duplicateBin.updateEntry(duplicateEntryIndex, newLN, newLsn, newLNKey);
                                    ((BIN)duplicateBin).clearKnownDeleted(duplicateEntryIndex);
                                    this.traceInsertDuplicate(Level.FINER, this.database.getDbEnvironment(), (BIN)duplicateBin, newLN, newLsn, bin);
                                    successfulInsert = true;
                                } else {
                                    successfulInsert = false;
                                }
                            }
                            if (successfulInsert) {
                                this.incrementDuplicateCount(env, cursor, key);
                            }
                            Object var26_24 = null;
                            if (duplicateBin == null || !duplicateBin.getLatch().isOwner()) break block20;
                        }
                        catch (Throwable throwable) {
                            Object var26_25 = null;
                            if (duplicateBin != null && duplicateBin.getLatch().isOwner()) {
                                duplicateBin.releaseLatch();
                            }
                            if (!duplicateRoot.getLatch().isOwner()) throw throwable;
                            duplicateRoot.releaseLatch();
                            throw throwable;
                        }
                        duplicateBin.releaseLatch();
                    }
                    if (duplicateRoot.getLatch().isOwner()) {
                        duplicateRoot.releaseLatch();
                    }
                } else {
                    if (!(n instanceof LN)) throw new InconsistentNodeException("neither LN or DIN found in BIN");
                    try {
                        lnLock.setAbortLsn(-1L, true, true);
                        duplicateRoot = this.createDuplicateTree(key, logManager, inMemoryINs, newLN, cursor);
                        Object var28_27 = null;
                        if (duplicateRoot == null) break block21;
                    }
                    catch (Throwable throwable) {
                        Object var28_28 = null;
                        if (duplicateRoot != null) {
                            duplicateRoot.releaseLatch();
                            successfulInsert = true;
                            throw throwable;
                        }
                        successfulInsert = false;
                        throw throwable;
                    }
                    duplicateRoot.releaseLatch();
                    successfulInsert = true;
                }
                break block22;
            }
            successfulInsert = false;
        }
        if ($assertionsDisabled) return successfulInsert;
        if (Latch.countLatchesHeld() == latchCount) return successfulInsert;
        throw new AssertionError((Object)("latchCount=" + latchCount + " held=" + Latch.countLatchesHeld()));
    }

    private void incrementDuplicateCount(EnvironmentImpl env, CursorImpl cursor, Key key) throws DatabaseException {
        DIN duplicateRoot = this.getLatchedDuplicateTreeRoot(cursor);
        DupCountLN dupCountLN = duplicateRoot.getDupCountLN();
        duplicateRoot.releaseLatch();
        cursor.releaseBINs();
        LockResult lockResult = cursor.getLocker().lock(dupCountLN.getNodeId(), LockType.WRITE, this.database);
        LockGrantType lockStatus = lockResult.getLockGrant();
        cursor.latchBIN();
        duplicateRoot = this.getLatchedDuplicateTreeRoot(cursor);
        duplicateRoot.incrementDuplicateCount(env, lockResult, key, cursor.getLocker());
    }

    private DIN getLatchedDuplicateTreeRoot(CursorImpl cursor) throws DatabaseException {
        int index = cursor.getIndex();
        BIN bin = cursor.getBIN();
        DIN duplicateRoot = (DIN)bin.fetchTarget(index);
        duplicateRoot.latch();
        return duplicateRoot;
    }

    private boolean maybeSplitDuplicateRoot(BIN bin, int index) throws DatabaseException {
        DIN curRoot = (DIN)bin.fetchTarget(index);
        if (curRoot.needsSplitting()) {
            EnvironmentImpl env = this.database.getDbEnvironment();
            LogManager logManager = env.getLogManager();
            INList inMemoryINs = env.getInMemoryINs();
            Key rootIdKey = curRoot.getKey(0);
            DIN newRoot = new DIN(this.database, rootIdKey, this.maxEntriesPerNode, curRoot.getDupKey(), curRoot.getDupCountLNRef(), curRoot.getLevel() + 1);
            newRoot.latch();
            newRoot.setIsRoot(true);
            curRoot.setDupCountLN(null);
            curRoot.setIsRoot(false);
            long curRootLsn = curRoot.logProvisional(logManager);
            boolean insertOk = newRoot.insertEntry(new ChildReference(curRoot, rootIdKey, bin.getLsn(index)));
            if (!$assertionsDisabled && !insertOk) {
                throw new AssertionError();
            }
            long logLsn = newRoot.log(logManager);
            inMemoryINs.add(newRoot);
            bin.updateEntry(index, newRoot, logLsn);
            curRoot.split(newRoot, 0, this.maxEntriesPerNode);
            curRoot.releaseLatch();
            this.traceSplitRoot(Level.FINE, TRACE_DUP_ROOT_SPLIT, newRoot, logLsn, curRoot, curRootLsn);
            return true;
        }
        return false;
    }

    private DIN createDuplicateTree(Key key, LogManager logManager, INList inMemoryINs, LN newLN, CursorImpl cursor) throws DatabaseException {
        boolean keysEqual;
        EnvironmentImpl env = this.database.getDbEnvironment();
        DIN duplicateRoot = null;
        DBIN duplicateBin = null;
        BIN bin = cursor.getBIN();
        int index = cursor.getIndex();
        LN existingLN = (LN)bin.fetchTarget(index);
        Key existingKey = new Key(existingLN.getData());
        Key newLNKey = new Key(newLN.getData());
        Comparator userComparisonFcn = this.database.getDuplicateComparator();
        boolean bl = keysEqual = (userComparisonFcn == null ? newLNKey.compareTo(existingKey) : userComparisonFcn.compare(newLNKey.getKey(), existingKey.getKey())) == 0;
        if (keysEqual) {
            return null;
        }
        Locker locker = cursor.getLocker();
        int startingCount = locker.createdNode(existingLN.getNodeId()) ? 0 : 1;
        DupCountLN dupCountLN = new DupCountLN(startingCount);
        long firstDupCountLNLsn = dupCountLN.logProvisional(env, this.database.getId(), key, -1L);
        duplicateRoot = new DIN(this.database, existingKey, this.maxEntriesPerNode, key, new ChildReference(dupCountLN, key, firstDupCountLNLsn), 2);
        duplicateRoot.latch();
        duplicateRoot.setIsRoot(true);
        duplicateBin = new DBIN(this.database, existingKey, this.maxEntriesPerNode, key, 1);
        duplicateBin.latch();
        ChildReference newExistingLNRef = new ChildReference(existingLN, existingKey, bin.getLsn(index));
        boolean insertOk = duplicateBin.insertEntry(newExistingLNRef);
        if (!$assertionsDisabled && !insertOk) {
            throw new AssertionError();
        }
        long dbinLsn = duplicateBin.logProvisional(logManager);
        inMemoryINs.add(duplicateBin);
        duplicateRoot.setEntry(0, duplicateBin, duplicateBin.getKey(0), dbinLsn, duplicateBin.getState(0));
        long dinLsn = duplicateRoot.log(logManager);
        inMemoryINs.add(duplicateRoot);
        LockResult lockResult = locker.lock(dupCountLN.getNodeId(), LockType.WRITE, this.database);
        LockGrantType lockStatus = lockResult.getLockGrant();
        lockResult.setAbortLsn(firstDupCountLNLsn, false);
        dupCountLN.setDupCount(2);
        long dupCountLsn = dupCountLN.log(env, this.database.getId(), key, firstDupCountLNLsn, locker);
        duplicateRoot.updateDupCountLNRef(dupCountLsn);
        long newLsn = newLN.log(env, this.database.getId(), key, -1L, locker);
        int duplicateEntryIndex = duplicateBin.insertEntry1(new ChildReference(newLN, newLNKey, newLsn));
        cursor.updateDBin(duplicateBin, duplicateEntryIndex &= 0xFFFDFFFF);
        bin.adjustCursorsForMutation(index, duplicateBin, duplicateEntryIndex ^ 1, cursor);
        duplicateBin.releaseLatch();
        bin.updateEntry(index, duplicateRoot, dinLsn);
        this.traceMutate(Level.FINE, bin, existingLN, newLN, newLsn, dupCountLN, dupCountLsn, duplicateRoot, dinLsn, duplicateBin, dbinLsn);
        return duplicateRoot;
    }

    private void validateInsertArgs(boolean allowDuplicates) throws DatabaseException {
        if (allowDuplicates && !this.database.getSortedDuplicates()) {
            throw new DatabaseException("allowDuplicates passed to insert but database doesn't have allow duplicates set.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private BIN findBinForInsert(Key key, LogManager logManager, INList inMemoryINs, CursorImpl cursor) throws DatabaseException {
        BIN bin;
        block9: {
            bin = cursor.latchBIN();
            if (bin != null) {
                if (!bin.needsSplitting() && bin.isKeyInBounds(key)) {
                    return bin;
                }
                bin.releaseLatch();
            }
            try {
                IN in;
                do {
                    this.rootLatch.acquire();
                    if (this.root == null) {
                        IN rootIN = new IN(this.database, key, this.maxEntriesPerNode, 2);
                        rootIN.setIsRoot(true);
                        long logLsn = rootIN.log(logManager);
                        this.root = new ChildReference(rootIN, new Key(new byte[0]), logLsn);
                        bin = new BIN(this.database, key, this.maxEntriesPerNode, 1);
                        bin.latch();
                        logLsn = bin.log(logManager);
                        boolean insertOk = rootIN.insertEntry(new ChildReference(bin, key, logLsn));
                        if (!$assertionsDisabled && !insertOk) {
                            throw new AssertionError();
                        }
                        inMemoryINs.add(bin);
                        inMemoryINs.add(rootIN);
                        this.rootLatch.release();
                        break block9;
                    }
                    this.rootLatch.release();
                    in = this.searchSplitsAllowed(key, -1L);
                } while (in == null);
                bin = (BIN)in;
            }
            finally {
                if (this.rootLatch.isOwner()) {
                    this.rootLatch.release();
                }
            }
        }
        return bin;
    }

    private void accountForSubtreeRemoval(INList inMemoryINs, IN subtreeRoot, Set modifiedFileSummaries) throws DatabaseException {
        subtreeRoot.accountForSubtreeRemoval(inMemoryINs, modifiedFileSummaries);
        Tracer.trace(Level.FINE, this.database.getDbEnvironment(), "SubtreeRemoval: subtreeRoot = " + subtreeRoot.getNodeId());
    }

    public int getLogSize() {
        int size = LogUtils.getBooleanLogSize();
        if (this.root != null) {
            size += this.root.getLogSize();
        }
        return size;
    }

    public void writeToLog(ByteBuffer logBuffer) {
        LogUtils.writeBoolean(logBuffer, this.root != null);
        if (this.root != null) {
            this.root.writeToLog(logBuffer);
        }
    }

    public void readFromLog(ByteBuffer itemBuffer) {
        boolean rootExists = LogUtils.readBoolean(itemBuffer);
        if (rootExists) {
            this.root = new ChildReference();
            this.root.readFromLog(itemBuffer);
        }
    }

    public void dumpLog(StringBuffer sb, boolean verbose) {
        sb.append("<root>");
        if (this.root != null) {
            this.root.dumpLog(sb, verbose);
        }
        sb.append("</root>");
    }

    public boolean logEntryIsTransactional() {
        return false;
    }

    public long getTransactionId() {
        return 0L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void rebuildINList() throws DatabaseException {
        INList inMemoryList = this.database.getDbEnvironment().getInMemoryINs();
        if (this.root != null) {
            this.rootLatch.acquire();
            try {
                Node rootIN = this.root.getTarget();
                if (rootIN != null) {
                    rootIN.rebuildINList(inMemoryList);
                }
            }
            finally {
                this.rootLatch.release();
            }
        }
    }

    public void dump() throws DatabaseException {
        System.out.println(this.dumpString(0));
    }

    public String dumpString(int nSpaces) throws DatabaseException {
        StringBuffer sb = new StringBuffer();
        sb.append(TreeUtils.indent(nSpaces));
        sb.append("<tree>");
        sb.append('\n');
        if (this.root != null) {
            sb.append(DbLsn.dumpString(this.root.getLsn(), nSpaces));
            sb.append('\n');
            IN rootIN = (IN)this.root.getTarget();
            if (rootIN == null) {
                sb.append("<in/>");
            } else {
                sb.append(rootIN.toString());
            }
            sb.append('\n');
        }
        sb.append(TreeUtils.indent(nSpaces));
        sb.append("</tree>");
        return sb.toString();
    }

    void dumpKeys() throws DatabaseException {
        IN nextBin = this.getFirstNode();
        while (nextBin != null) {
            BIN bin = (BIN)nextBin;
            System.out.println("-----------");
            bin.dumpKeys();
            nextBin = this.getNextBin(bin, null);
        }
        System.out.println("-----------");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean validateDelete(int index) throws DatabaseException {
        this.rootLatch.acquire();
        try {
            IN rootIN = (IN)this.root.fetchTarget(this.database, null);
            boolean bl = rootIN.validateSubtreeBeforeDelete(index);
            return bl;
        }
        finally {
            this.rootLatch.release();
        }
    }

    public void validateINList(IN parent) throws DatabaseException {
        if (parent == null) {
            parent = (IN)this.root.getTarget();
        }
        if (parent != null) {
            INList inList = this.database.getDbEnvironment().getInMemoryINs();
            if (!inList.getINs().contains(parent)) {
                throw new DatabaseException("IN " + parent.getNodeId() + " missing from INList");
            }
            int i = 0;
            while (true) {
                block9: {
                    try {
                        Node node = parent.getTarget(i);
                        if (i >= parent.getNEntries()) {
                            if (node != null) {
                                throw new DatabaseException("IN " + parent.getNodeId() + " has stray node " + node.getNodeId() + " at index " + i);
                            }
                            Key key = parent.getKey(i);
                            if (key != null) {
                                throw new DatabaseException("IN " + parent.getNodeId() + " has stray key " + key + " at index " + i);
                            }
                        }
                        if (!(node instanceof IN)) break block9;
                        this.validateINList((IN)node);
                    }
                    catch (ArrayIndexOutOfBoundsException e) {
                        break;
                    }
                }
                ++i;
            }
        }
    }

    private void traceSplitRoot(Level level, String splitType, IN newRoot, long newRootLsn, IN oldRoot, long oldRootLsn) {
        Logger logger = this.database.getDbEnvironment().getLogger();
        if (logger.isLoggable(level)) {
            StringBuffer sb = new StringBuffer();
            sb.append(splitType);
            sb.append(" newRoot=").append(newRoot.getNodeId());
            sb.append(" newRootLsn=").append(DbLsn.getNoFormatString(newRootLsn));
            sb.append(" oldRoot=").append(oldRoot.getNodeId());
            sb.append(" oldRootLsn=").append(DbLsn.getNoFormatString(oldRootLsn));
            logger.log(level, sb.toString());
        }
    }

    private void traceMutate(Level level, BIN theBin, LN existingLn, LN newLn, long newLsn, DupCountLN dupCountLN, long dupRootLsn, DIN duplicateDIN, long ddinLsn, DBIN duplicateBin, long dbinLsn) {
        Logger logger = this.database.getDbEnvironment().getLogger();
        if (logger.isLoggable(level)) {
            StringBuffer sb = new StringBuffer();
            sb.append(TRACE_MUTATE);
            sb.append(" existingLn=");
            sb.append(existingLn.getNodeId());
            sb.append(" newLn=");
            sb.append(newLn.getNodeId());
            sb.append(" newLnLsn=");
            sb.append(DbLsn.getNoFormatString(newLsn));
            sb.append(" dupCountLN=");
            sb.append(dupCountLN.getNodeId());
            sb.append(" dupRootLsn=");
            sb.append(DbLsn.getNoFormatString(dupRootLsn));
            sb.append(" rootdin=");
            sb.append(duplicateDIN.getNodeId());
            sb.append(" ddinLsn=");
            sb.append(DbLsn.getNoFormatString(ddinLsn));
            sb.append(" dbin=");
            sb.append(duplicateBin.getNodeId());
            sb.append(" dbinLsn=");
            sb.append(DbLsn.getNoFormatString(dbinLsn));
            sb.append(" bin=");
            sb.append(theBin.getNodeId());
            logger.log(level, sb.toString());
        }
    }

    private void traceInsert(Level level, EnvironmentImpl env, BIN insertingBin, LN ln, long lnLsn, int index) {
        Logger logger = env.getLogger();
        if (logger.isLoggable(level)) {
            StringBuffer sb = new StringBuffer();
            sb.append(TRACE_INSERT);
            sb.append(" bin=");
            sb.append(insertingBin.getNodeId());
            sb.append(" ln=");
            sb.append(ln.getNodeId());
            sb.append(" lnLsn=");
            sb.append(DbLsn.getNoFormatString(lnLsn));
            sb.append(" index=");
            sb.append(index);
            logger.log(level, sb.toString());
        }
    }

    private void traceInsertDuplicate(Level level, EnvironmentImpl env, BIN insertingDBin, LN ln, long lnLsn, BIN bin) {
        Logger logger = env.getLogger();
        if (logger.isLoggable(level)) {
            StringBuffer sb = new StringBuffer();
            sb.append(TRACE_INSERT_DUPLICATE);
            sb.append(" dbin=");
            sb.append(insertingDBin.getNodeId());
            sb.append(" bin=");
            sb.append(bin.getNodeId());
            sb.append(" ln=");
            sb.append(ln.getNodeId());
            sb.append(" lnLsn=");
            sb.append(DbLsn.getNoFormatString(lnLsn));
            logger.log(level, sb.toString());
        }
    }

    static {
        $assertionsDisabled = !Tree.class.desiredAssertionStatus();
    }

    private static class SplitInfo {
        IN parent;
        IN child;
        int index;

        SplitInfo(IN parent, IN child, int index) {
            this.parent = parent;
            this.child = child;
            this.index = index;
        }
    }

    public static class SearchType {
        public static final SearchType NORMAL = new SearchType();
        public static final SearchType LEFT = new SearchType();
        public static final SearchType RIGHT = new SearchType();
        public static final SearchType DELETE = new SearchType();

        private SearchType() {
        }
    }
}

