/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.je.recovery;

import com.sleepycat.je.CheckpointConfig;
import com.sleepycat.je.DatabaseException;
import com.sleepycat.je.DbInternal;
import com.sleepycat.je.EnvironmentStats;
import com.sleepycat.je.StatsConfig;
import com.sleepycat.je.cleaner.Cleaner;
import com.sleepycat.je.cleaner.TrackedFileSummary;
import com.sleepycat.je.cleaner.UtilizationProfile;
import com.sleepycat.je.config.EnvironmentParams;
import com.sleepycat.je.dbi.DatabaseImpl;
import com.sleepycat.je.dbi.DbConfigManager;
import com.sleepycat.je.dbi.DbTree;
import com.sleepycat.je.dbi.EnvironmentImpl;
import com.sleepycat.je.dbi.INList;
import com.sleepycat.je.dbi.MemoryBudget;
import com.sleepycat.je.evictor.Evictor;
import com.sleepycat.je.log.LogManager;
import com.sleepycat.je.recovery.CheckpointEnd;
import com.sleepycat.je.recovery.CheckpointStart;
import com.sleepycat.je.tree.BIN;
import com.sleepycat.je.tree.ChildReference;
import com.sleepycat.je.tree.IN;
import com.sleepycat.je.tree.Key;
import com.sleepycat.je.tree.Node;
import com.sleepycat.je.tree.SearchResult;
import com.sleepycat.je.tree.Tree;
import com.sleepycat.je.tree.WithRootLatched;
import com.sleepycat.je.utilint.DaemonThread;
import com.sleepycat.je.utilint.DbLsn;
import com.sleepycat.je.utilint.PropUtil;
import com.sleepycat.je.utilint.Tracer;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.logging.Level;

public class Checkpointer
extends DaemonThread {
    private EnvironmentImpl envImpl;
    private LogManager logManager;
    private long checkpointId;
    private long logSizeBytesInterval;
    private long logFileMax;
    private long timeInterval;
    private long lastCheckpointMillis;
    private int nCheckpoints;
    private long lastFirstActiveLsn;
    private long lastCheckpointStart;
    private long lastCheckpointEnd;
    private int nFullINFlush;
    private int nFullBINFlush;
    private int nDeltaINFlush;
    private int nFullINFlushThisRun;
    private int nDeltaINFlushThisRun;
    private volatile int highestFlushLevel;

    public Checkpointer(EnvironmentImpl envImpl, long waitTime, String name) throws DatabaseException {
        super(waitTime, name, envImpl);
        this.envImpl = envImpl;
        this.logSizeBytesInterval = envImpl.getConfigManager().getLong(EnvironmentParams.CHECKPOINTER_BYTES_INTERVAL);
        this.logFileMax = envImpl.getConfigManager().getLong(EnvironmentParams.LOG_FILE_MAX);
        this.nCheckpoints = 0;
        this.timeInterval = waitTime;
        this.lastCheckpointMillis = 0L;
        this.highestFlushLevel = -1;
        this.logManager = envImpl.getLogManager();
    }

    public int getHighestFlushLevel() {
        return this.highestFlushLevel;
    }

    public static long getWakeupPeriod(DbConfigManager configManager) throws IllegalArgumentException, DatabaseException {
        long wakeupPeriod = PropUtil.microsToMillis(configManager.getLong(EnvironmentParams.CHECKPOINTER_WAKEUP_INTERVAL));
        long bytePeriod = configManager.getLong(EnvironmentParams.CHECKPOINTER_BYTES_INTERVAL);
        if (wakeupPeriod == 0L && bytePeriod == 0L) {
            throw new IllegalArgumentException(EnvironmentParams.CHECKPOINTER_BYTES_INTERVAL.getName() + " and " + EnvironmentParams.CHECKPOINTER_WAKEUP_INTERVAL.getName() + " cannot both be 0. ");
        }
        if (bytePeriod == 0L) {
            return wakeupPeriod;
        }
        return 0L;
    }

    public synchronized void setCheckpointId(long lastCheckpointId) {
        this.checkpointId = lastCheckpointId;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("<Checkpointer name=\"").append(this.name).append("\"/>");
        return sb.toString();
    }

    public void loadStats(StatsConfig config, EnvironmentStats stat) throws DatabaseException {
        stat.setNCheckpoints(this.nCheckpoints);
        stat.setLastCheckpointStart(this.lastCheckpointStart);
        stat.setLastCheckpointEnd(this.lastCheckpointEnd);
        stat.setLastCheckpointId(this.checkpointId);
        stat.setNFullINFlush(this.nFullINFlush);
        stat.setNFullBINFlush(this.nFullBINFlush);
        stat.setNDeltaINFlush(this.nDeltaINFlush);
        if (config.getClear()) {
            this.nCheckpoints = 0;
            this.nFullINFlush = 0;
            this.nFullBINFlush = 0;
            this.nDeltaINFlush = 0;
        }
    }

    public long getFirstActiveLsn() {
        return this.lastFirstActiveLsn;
    }

    public synchronized void clearEnv() {
        this.envImpl = null;
    }

    protected int nDeadlockRetries() throws DatabaseException {
        return this.envImpl.getConfigManager().getInt(EnvironmentParams.CHECKPOINTER_RETRY);
    }

    protected void onWakeup() throws DatabaseException {
        if (this.envImpl.isClosed()) {
            return;
        }
        this.doCheckpoint(CheckpointConfig.DEFAULT, true, false, "daemon");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isRunnable(CheckpointConfig config) throws DatabaseException {
        long nextLsn;
        long useTimeInterval;
        long useBytesInterval;
        block30: {
            block31: {
                block28: {
                    block29: {
                        block27: {
                            StringBuffer sb2;
                            boolean bl;
                            useBytesInterval = 0L;
                            useTimeInterval = 0L;
                            nextLsn = -1L;
                            try {
                                if (!config.getForce()) break block27;
                                bl = true;
                                Object var12_10 = null;
                                sb2 = new StringBuffer();
                                sb2.append("size interval=").append(useBytesInterval);
                            }
                            catch (Throwable throwable) {
                                Object var12_16 = null;
                                StringBuffer sb2 = new StringBuffer();
                                sb2.append("size interval=").append(useBytesInterval);
                                if (nextLsn != -1L) {
                                    sb2.append(" nextLsn=").append(DbLsn.getNoFormatString(nextLsn));
                                }
                                if (this.lastCheckpointEnd != -1L) {
                                    sb2.append(" lastCkpt=");
                                    sb2.append(DbLsn.getNoFormatString(this.lastCheckpointEnd));
                                }
                                sb2.append(" time interval=").append(useTimeInterval);
                                sb2.append(" force=").append(config.getForce());
                                Tracer.trace(Level.FINEST, this.envImpl, sb2.toString());
                                throw throwable;
                            }
                            if (nextLsn != -1L) {
                                sb2.append(" nextLsn=").append(DbLsn.getNoFormatString(nextLsn));
                            }
                            if (this.lastCheckpointEnd != -1L) {
                                sb2.append(" lastCkpt=");
                                sb2.append(DbLsn.getNoFormatString(this.lastCheckpointEnd));
                            }
                            sb2.append(" time interval=").append(useTimeInterval);
                            sb2.append(" force=").append(config.getForce());
                            Tracer.trace(Level.FINEST, this.envImpl, sb2.toString());
                            return bl;
                        }
                        if (config.getKBytes() != 0) {
                            useBytesInterval = config.getKBytes() << 10;
                        } else if (config.getMinutes() != 0) {
                            useTimeInterval = config.getMinutes() * 60 * 1000;
                        } else if (this.logSizeBytesInterval != 0L) {
                            useBytesInterval = this.logSizeBytesInterval;
                        } else {
                            useTimeInterval = this.timeInterval;
                        }
                        if (useBytesInterval == 0L) break block28;
                        nextLsn = this.envImpl.getFileManager().getNextLsn();
                        if (DbLsn.getNoCleaningDistance(nextLsn, this.lastCheckpointEnd, this.logFileMax) < useBytesInterval) break block29;
                        boolean bl = true;
                        Object var12_11 = null;
                        StringBuffer sb2 = new StringBuffer();
                        sb2.append("size interval=").append(useBytesInterval);
                        if (nextLsn != -1L) {
                            sb2.append(" nextLsn=").append(DbLsn.getNoFormatString(nextLsn));
                        }
                        if (this.lastCheckpointEnd != -1L) {
                            sb2.append(" lastCkpt=");
                            sb2.append(DbLsn.getNoFormatString(this.lastCheckpointEnd));
                        }
                        sb2.append(" time interval=").append(useTimeInterval);
                        sb2.append(" force=").append(config.getForce());
                        Tracer.trace(Level.FINEST, this.envImpl, sb2.toString());
                        return bl;
                    }
                    boolean bl = false;
                    Object var12_12 = null;
                    StringBuffer sb2 = new StringBuffer();
                    sb2.append("size interval=").append(useBytesInterval);
                    if (nextLsn != -1L) {
                        sb2.append(" nextLsn=").append(DbLsn.getNoFormatString(nextLsn));
                    }
                    if (this.lastCheckpointEnd != -1L) {
                        sb2.append(" lastCkpt=");
                        sb2.append(DbLsn.getNoFormatString(this.lastCheckpointEnd));
                    }
                    sb2.append(" time interval=").append(useTimeInterval);
                    sb2.append(" force=").append(config.getForce());
                    Tracer.trace(Level.FINEST, this.envImpl, sb2.toString());
                    return bl;
                }
                if (useTimeInterval == 0L) break block30;
                long lastUsedLsn = this.envImpl.getFileManager().getLastUsedLsn();
                if (System.currentTimeMillis() - this.lastCheckpointMillis < useTimeInterval || DbLsn.compareTo(lastUsedLsn, this.lastCheckpointEnd) == 0) break block31;
                boolean bl = true;
                Object var12_13 = null;
                StringBuffer sb2 = new StringBuffer();
                sb2.append("size interval=").append(useBytesInterval);
                if (nextLsn != -1L) {
                    sb2.append(" nextLsn=").append(DbLsn.getNoFormatString(nextLsn));
                }
                if (this.lastCheckpointEnd != -1L) {
                    sb2.append(" lastCkpt=");
                    sb2.append(DbLsn.getNoFormatString(this.lastCheckpointEnd));
                }
                sb2.append(" time interval=").append(useTimeInterval);
                sb2.append(" force=").append(config.getForce());
                Tracer.trace(Level.FINEST, this.envImpl, sb2.toString());
                return bl;
            }
            boolean bl = false;
            Object var12_14 = null;
            StringBuffer sb2 = new StringBuffer();
            sb2.append("size interval=").append(useBytesInterval);
            if (nextLsn != -1L) {
                sb2.append(" nextLsn=").append(DbLsn.getNoFormatString(nextLsn));
            }
            if (this.lastCheckpointEnd != -1L) {
                sb2.append(" lastCkpt=");
                sb2.append(DbLsn.getNoFormatString(this.lastCheckpointEnd));
            }
            sb2.append(" time interval=").append(useTimeInterval);
            sb2.append(" force=").append(config.getForce());
            Tracer.trace(Level.FINEST, this.envImpl, sb2.toString());
            return bl;
        }
        boolean bl = false;
        Object var12_15 = null;
        StringBuffer sb2 = new StringBuffer();
        sb2.append("size interval=").append(useBytesInterval);
        if (nextLsn != -1L) {
            sb2.append(" nextLsn=").append(DbLsn.getNoFormatString(nextLsn));
        }
        if (this.lastCheckpointEnd != -1L) {
            sb2.append(" lastCkpt=");
            sb2.append(DbLsn.getNoFormatString(this.lastCheckpointEnd));
        }
        sb2.append(" time interval=").append(useTimeInterval);
        sb2.append(" force=").append(config.getForce());
        Tracer.trace(Level.FINEST, this.envImpl, sb2.toString());
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void doCheckpoint(CheckpointConfig config, boolean allowDeltas, boolean flushAll, String invokingSource) throws DatabaseException {
        if (!this.isRunnable(config)) {
            return;
        }
        boolean flushExtraLevel = false;
        Set cleanedFiles = null;
        Cleaner cleaner = this.envImpl.getCleaner();
        if (cleaner != null && (cleanedFiles = cleaner.getCleanedFiles()) != null) {
            flushExtraLevel = true;
        }
        this.lastCheckpointMillis = System.currentTimeMillis();
        this.resetPerRunCounters();
        ++this.checkpointId;
        ++this.nCheckpoints;
        boolean success = false;
        boolean traced = false;
        try {
            long checkpointStart = -1L;
            long firstActiveLsn = -1L;
            SortedMap dirtyMap = null;
            Evictor evictor = this.envImpl.getEvictor();
            synchronized (evictor) {
                CheckpointStart startEntry = new CheckpointStart(this.checkpointId, invokingSource);
                checkpointStart = this.logManager.log(startEntry);
                firstActiveLsn = this.envImpl.getTxnManager().getFirstActiveLsn();
                if (firstActiveLsn == -1L) {
                    firstActiveLsn = checkpointStart;
                } else if (DbLsn.compareTo(checkpointStart, firstActiveLsn) < 0) {
                    firstActiveLsn = checkpointStart;
                }
                dirtyMap = this.selectDirtyINs(flushAll, flushExtraLevel);
            }
            this.flushDirtyNodes(dirtyMap, flushAll, allowDeltas, flushExtraLevel, checkpointStart);
            this.flushUtilizationInfo();
            CheckpointEnd endEntry = new CheckpointEnd(invokingSource, checkpointStart, this.envImpl.getRootLsn(), firstActiveLsn, Node.getLastId(), this.envImpl.getDbMapTree().getLastDbId(), this.envImpl.getTxnManager().getLastTxnId(), this.checkpointId);
            this.trace(this.envImpl, invokingSource, true);
            traced = true;
            this.lastCheckpointEnd = this.logManager.logForceFlush(endEntry, true);
            this.lastFirstActiveLsn = firstActiveLsn;
            this.lastCheckpointStart = checkpointStart;
            this.highestFlushLevel = -1;
            success = true;
            if (cleaner != null && cleanedFiles != null) {
                cleaner.deleteCleanedFiles(cleanedFiles);
            }
        }
        catch (DatabaseException e) {
            Tracer.trace(this.envImpl, "Checkpointer", "doCheckpoint", "checkpointId=" + this.checkpointId, e);
            throw e;
        }
        finally {
            if (!traced) {
                this.trace(this.envImpl, invokingSource, success);
            }
        }
    }

    private void trace(EnvironmentImpl envImpl, String invokingSource, boolean success) {
        StringBuffer sb = new StringBuffer();
        sb.append("Checkpoint ").append(this.checkpointId);
        sb.append(": source=").append(invokingSource);
        sb.append(" success=").append(success);
        sb.append(" nFullINFlushThisRun=").append(this.nFullINFlushThisRun);
        sb.append(" nDeltaINFlushThisRun=").append(this.nDeltaINFlushThisRun);
        Tracer.trace(Level.INFO, envImpl, sb.toString());
    }

    private void flushUtilizationInfo() throws DatabaseException {
        if (!DbInternal.getCheckpointUP(this.envImpl.getConfigManager().getEnvironmentConfig())) {
            return;
        }
        UtilizationProfile profile = this.envImpl.getUtilizationProfile();
        TrackedFileSummary[] activeFiles = this.envImpl.getUtilizationTracker().getTrackedFiles();
        for (int i = 0; i < activeFiles.length; ++i) {
            TrackedFileSummary trackedFile = activeFiles[i];
            profile.putFileSummary(trackedFile);
        }
    }

    private void flushDirtyNodes(SortedMap dirtyMap, boolean flushAll, boolean allowDeltas, boolean flushExtraLevel, long checkpointStart) throws DatabaseException {
        while (dirtyMap.size() > 0) {
            Integer currentLevel = (Integer)dirtyMap.firstKey();
            boolean logProvisionally = currentLevel != this.highestFlushLevel;
            Set nodeSet = (Set)dirtyMap.get(currentLevel);
            Iterator iter = nodeSet.iterator();
            MemoryBudget mb = this.envImpl.getMemoryBudget();
            long levelSize = nodeSet.size() * 56;
            mb.updateCacheMemoryUsage(levelSize);
            while (iter.hasNext()) {
                CheckpointReference targetRef = (CheckpointReference)iter.next();
                if (!targetRef.db.getIsDeleted()) {
                    this.flushIN(targetRef, dirtyMap, currentLevel, logProvisionally, allowDeltas, checkpointStart);
                }
                iter.remove();
            }
            dirtyMap.remove(currentLevel);
            mb.updateCacheMemoryUsage(0L - levelSize);
            if (currentLevel != this.highestFlushLevel) continue;
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SortedMap selectDirtyINs(boolean flushAll, boolean flushExtraLevel) throws DatabaseException {
        TreeMap newDirtyMap = new TreeMap();
        INList inMemINs = this.envImpl.getInMemoryINs();
        inMemINs.latchMajor();
        long totalSize = 0L;
        MemoryBudget mb = this.envImpl.getMemoryBudget();
        try {
            Iterator iter = inMemINs.iterator();
            while (iter.hasNext()) {
                IN in = (IN)iter.next();
                in.latch();
                try {
                    Set<CheckpointReference> dirtySet;
                    totalSize = mb.accumulateNewUsage(in, totalSize);
                    if (!in.getDirty()) continue;
                    Integer level = new Integer(in.getLevel());
                    if (newDirtyMap.containsKey(level)) {
                        dirtySet = (Set)newDirtyMap.get(level);
                    } else {
                        dirtySet = new HashSet();
                        newDirtyMap.put(level, dirtySet);
                    }
                    dirtySet.add(new CheckpointReference(in.getDatabase(), in.getNodeId(), in.containsDuplicates(), in.isDbRoot(), in.getMainTreeKey(), in.getDupTreeKey()));
                }
                finally {
                    in.releaseLatch();
                }
            }
            if (newDirtyMap.size() > 0) {
                if (flushAll) {
                    this.highestFlushLevel = this.envImpl.getDbMapTree().getHighestLevel();
                } else {
                    this.highestFlushLevel = (Integer)newDirtyMap.lastKey();
                    if (flushExtraLevel) {
                        ++this.highestFlushLevel;
                    }
                }
            } else {
                this.highestFlushLevel = Integer.MAX_VALUE;
            }
        }
        finally {
            inMemINs.releaseMajorLatchIfHeld();
        }
        return newDirtyMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void flushIN(CheckpointReference targetRef, Map dirtyMap, int currentLevel, boolean logProvisionally, boolean allowDeltas, long checkpointStart) throws DatabaseException {
        Tree tree = targetRef.db.getTree();
        boolean targetWasRoot = false;
        if (targetRef.isDbRoot) {
            RootFlusher flusher = new RootFlusher(targetRef.db, this.logManager, targetRef.nodeId);
            tree.withRootLatched(flusher);
            boolean flushed = flusher.getFlushed();
            targetWasRoot = flusher.stillRoot();
            if (flushed) {
                DbTree dbTree = targetRef.db.getDbEnvironment().getDbMapTree();
                dbTree.modifyDbRoot(targetRef.db);
                ++this.nFullINFlushThisRun;
                ++this.nFullINFlush;
            }
        }
        if (!targetWasRoot) {
            SearchResult result = tree.getParentINForChildIN(targetRef.nodeId, targetRef.containsDuplicates, false, targetRef.mainTreeKey, targetRef.dupTreeKey, false, null, false);
            if (result.parent != null) {
                boolean mustLogParent = false;
                try {
                    if (result.exactParentFound) {
                        IN renewedTarget = (IN)result.parent.getTarget(result.index);
                        mustLogParent = renewedTarget == null ? true : this.logTargetAndUpdateParent(renewedTarget, result.parent, result.index, allowDeltas, checkpointStart, logProvisionally);
                    } else if (result.childNotResident && result.parent.getLevel() > currentLevel) {
                        mustLogParent = true;
                    }
                    if (mustLogParent) {
                        this.addToDirtyMap(dirtyMap, result.parent);
                    }
                }
                finally {
                    result.parent.releaseLatch();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean logTargetAndUpdateParent(IN target, IN parent, int index, boolean allowDeltas, long checkpointStart, boolean logProvisionally) throws DatabaseException {
        target.latch();
        long newLsn = -1L;
        boolean mustLogParent = true;
        try {
            if (target.getDirty()) {
                if (allowDeltas) {
                    newLsn = target.logAllowDeltas(this.logManager, logProvisionally);
                    if (newLsn == -1L) {
                        ++this.nDeltaINFlushThisRun;
                        ++this.nDeltaINFlush;
                        long lastFullLsn = target.getLastFullVersion();
                        if (DbLsn.compareTo(lastFullLsn, checkpointStart) < 0) {
                            mustLogParent = false;
                        }
                    }
                } else {
                    newLsn = target.log(this.logManager, logProvisionally);
                }
            }
        }
        finally {
            target.releaseLatch();
        }
        if (newLsn != -1L) {
            ++this.nFullINFlushThisRun;
            ++this.nFullINFlush;
            if (target instanceof BIN) {
                ++this.nFullBINFlush;
            }
            parent.updateEntry(index, newLsn);
        }
        return mustLogParent;
    }

    private void addToDirtyMap(Map dirtyMap, IN in) {
        Integer inLevel = new Integer(in.getLevel());
        HashSet<CheckpointReference> inSet = (HashSet<CheckpointReference>)dirtyMap.get(inLevel);
        if (inSet == null) {
            inSet = new HashSet<CheckpointReference>();
            dirtyMap.put(inLevel, inSet);
        }
        inSet.add(new CheckpointReference(in.getDatabase(), in.getNodeId(), in.containsDuplicates(), in.isDbRoot(), in.getMainTreeKey(), in.getDupTreeKey()));
    }

    private void resetPerRunCounters() {
        this.nFullINFlushThisRun = 0;
        this.nDeltaINFlushThisRun = 0;
    }

    static class CheckpointReference {
        DatabaseImpl db;
        long nodeId;
        boolean containsDuplicates;
        boolean isDbRoot;
        Key mainTreeKey;
        Key dupTreeKey;

        CheckpointReference(DatabaseImpl db, long nodeId, boolean containsDuplicates, boolean isDbRoot, Key mainTreeKey, Key dupTreeKey) {
            this.db = db;
            this.nodeId = nodeId;
            this.containsDuplicates = containsDuplicates;
            this.isDbRoot = isDbRoot;
            this.mainTreeKey = mainTreeKey;
            this.dupTreeKey = dupTreeKey;
        }

        public boolean equals(Object o) {
            if (!(o instanceof CheckpointReference)) {
                return false;
            }
            CheckpointReference other = (CheckpointReference)o;
            return this.nodeId == other.nodeId;
        }

        public int hashCode() {
            return (int)this.nodeId;
        }
    }

    private static class RootFlusher
    implements WithRootLatched {
        private DatabaseImpl db;
        private boolean flushed;
        private boolean stillRoot;
        private LogManager logManager;
        private long targetNodeId;

        RootFlusher(DatabaseImpl db, LogManager logManager, long targetNodeId) {
            this.db = db;
            this.flushed = false;
            this.logManager = logManager;
            this.targetNodeId = targetNodeId;
            this.stillRoot = false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public IN doWork(ChildReference root) throws DatabaseException {
            if (root == null) {
                return null;
            }
            IN rootIN = (IN)root.fetchTarget(this.db, null);
            rootIN.latch();
            try {
                if (rootIN.getNodeId() == this.targetNodeId) {
                    this.stillRoot = true;
                    if (rootIN.getDirty()) {
                        long newLsn = rootIN.log(this.logManager);
                        root.setLsn(newLsn);
                        this.flushed = true;
                    }
                }
            }
            finally {
                rootIN.releaseLatch();
            }
            return null;
        }

        boolean getFlushed() {
            return this.flushed;
        }

        boolean stillRoot() {
            return this.stillRoot;
        }
    }
}

