/*-
* See the file LICENSE for redistribution information.
*
* Copyright (c) 2002-2004
*      Sleepycat Software.  All rights reserved.
*
* $Id: KeyTest.java,v 1.9 2004/02/20 15:19:56 linda Exp $
*/

package com.sleepycat.je.tree;

import junit.framework.TestCase;

public class KeyTest extends TestCase {
    public void setUp() {
    }

    public void tearDown() {
    }

    public void testKeyComparisonPerformance() {
	Key key1 = new Key("abcdefghijabcdefghij".getBytes());
	Key key2 = new Key("abcdefghijabcdefghij".getBytes());

	for (int i = 0; i < 1000000; i++) {
	    assertTrue(key1.compareTo(key2) == 0);
	}
    }

    public void testKeyComparison() {
	Key key1 = new Key("aaa".getBytes());
	Key key2 = new Key("aab".getBytes());
	assertTrue(key1.compareTo(key2) < 0);
	assertTrue(key2.compareTo(key1) > 0);
	assertTrue(key1.compareTo(key1) == 0);

	key1 = new Key("aa".getBytes());
	key2 = new Key("aab".getBytes());
	assertTrue(key1.compareTo(key2) < 0);
	assertTrue(key2.compareTo(key1) > 0);

	key1 = new Key("".getBytes());
	key2 = new Key("aab".getBytes());
	assertTrue(key1.compareTo(key2) < 0);
	assertTrue(key2.compareTo(key1) > 0);
	assertTrue(key1.compareTo(key1) == 0);

	key1 = new Key("".getBytes());
	key2 = new Key("".getBytes());
	assertTrue(key1.compareTo(key2) == 0);

	byte[] ba1 = { -1, -1, -1 };
	byte[] ba2 = { 0x7f, 0x7f, 0x7f };
	key1 = new Key(ba1);
	key2 = new Key(ba2);
	assertTrue(key1.compareTo(key2) > 0);

	try {
	    key1.compareTo(null);
	    fail("NullPointerException not caught");
	} catch (NullPointerException NPE) {
	}

	try {
	    key1.compareTo(new String("foobar"));
	    fail("ClassCastException not caught");
	} catch (ClassCastException CCE) {
	}
    }
}
