/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.je.util;

import com.sleepycat.je.Cursor;
import com.sleepycat.je.Database;
import com.sleepycat.je.DatabaseConfig;
import com.sleepycat.je.DatabaseEntry;
import com.sleepycat.je.DatabaseException;
import com.sleepycat.je.DbInternal;
import com.sleepycat.je.Environment;
import com.sleepycat.je.EnvironmentConfig;
import com.sleepycat.je.JEVersion;
import com.sleepycat.je.LockMode;
import com.sleepycat.je.OperationStatus;
import com.sleepycat.je.utilint.Tracer;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Level;

public class DbDump {
    private static final int VERSION = 3;
    private File envHome = null;
    protected Environment env;
    private String dbName = null;
    private boolean formatUsingPrintable;
    private boolean dupSort;
    private String outputFileName = null;
    private PrintStream outputFile = null;
    private String usageString = "usage: DbDump [-f output-file] [-l] [-p] [-V]\n              [-s database] -h dbEnvHome\n";
    private static final String printableChars = " !\"#$%&'()*+,-./0123456789:;<=>?@ABCDEFGHIJKLMNOPQRSTUVWXYZ[\\]^_`abcdefghijklmnopqrstuvwxyz{|}~";

    private DbDump() {
    }

    public DbDump(Environment env, String dbName, PrintStream outputFile, boolean formatUsingPrintable) {
        this.env = env;
        this.dbName = dbName;
        this.outputFile = outputFile;
        this.formatUsingPrintable = formatUsingPrintable;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void main(String[] argv) throws DatabaseException, IOException {
        DbDump dumper = new DbDump();
        boolean listDbs = dumper.parseArgs(argv);
        if (listDbs) {
            dumper.listDbs();
            System.exit(0);
        }
        try {
            try {
                dumper.dump();
            }
            catch (Throwable T) {
                T.printStackTrace();
                Object var5_4 = null;
                dumper.env.close();
                if (dumper.outputFile == System.out) return;
                dumper.outputFile.close();
                return;
            }
            Object var5_3 = null;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            dumper.env.close();
            if (dumper.outputFile == System.out) throw throwable;
            dumper.outputFile.close();
            throw throwable;
        }
        dumper.env.close();
        if (dumper.outputFile == System.out) return;
        dumper.outputFile.close();
    }

    private void listDbs() throws DatabaseException {
        this.openEnv();
        List dbNames = this.env.getDatabaseNames();
        Iterator iter = dbNames.iterator();
        while (iter.hasNext()) {
            String name = (String)iter.next();
            System.out.println(name);
        }
    }

    private void printUsage(String msg) {
        System.err.println(msg);
        System.err.println(this.usageString);
        System.exit(-1);
    }

    private boolean parseArgs(String[] argv) throws IOException {
        int argc = 0;
        int nArgs = argv.length;
        boolean listDbs = false;
        while (argc < nArgs) {
            String thisArg;
            if ((thisArg = argv[argc++]).equals("-p")) {
                this.formatUsingPrintable = true;
                continue;
            }
            if (thisArg.equals("-V")) {
                System.out.println(JEVersion.CURRENT_VERSION);
                System.exit(0);
                continue;
            }
            if (thisArg.equals("-l")) {
                listDbs = true;
                continue;
            }
            if (thisArg.equals("-f")) {
                if (argc < nArgs) {
                    this.outputFileName = argv[argc++];
                    continue;
                }
                this.printUsage("-f requires an argument");
                continue;
            }
            if (thisArg.equals("-h")) {
                if (argc < nArgs) {
                    String envDir = argv[argc++];
                    this.envHome = new File(envDir);
                    continue;
                }
                this.printUsage("-h requires an argument");
                continue;
            }
            if (!thisArg.equals("-s")) continue;
            if (argc < nArgs) {
                this.dbName = argv[argc++];
                continue;
            }
            this.printUsage("-s requires an argument");
        }
        if (this.envHome == null) {
            this.printUsage("-h is a required argument");
        }
        if (!listDbs && this.dbName == null) {
            this.printUsage("Must supply a database name if -l not supplied.");
        }
        this.outputFile = this.outputFileName == null ? System.out : new PrintStream(new FileOutputStream(this.outputFileName));
        return listDbs;
    }

    private void openEnv() throws DatabaseException {
        if (this.env == null) {
            EnvironmentConfig envConfiguration = new EnvironmentConfig();
            envConfiguration.setReadOnly(true);
            this.env = new Environment(this.envHome, envConfiguration);
        }
    }

    public void dump() throws IOException, DatabaseException {
        this.openEnv();
        Tracer.trace(Level.INFO, DbInternal.envGetEnvironmentImpl(this.env), "DbDump.dump of " + this.dbName + " starting");
        DatabaseEntry foundKey = new DatabaseEntry();
        DatabaseEntry foundData = new DatabaseEntry();
        DatabaseConfig dbConfig = new DatabaseConfig();
        dbConfig.setReadOnly(true);
        DbInternal.setUseExistingConfig(dbConfig, true);
        Database db = this.env.openDatabase(null, this.dbName, dbConfig);
        this.dupSort = db.getConfig().getSortedDuplicates();
        this.printHeader(this.outputFile, this.formatUsingPrintable);
        Cursor cursor = db.openCursor(null, null);
        while (cursor.getNext(foundKey, foundData, LockMode.DEFAULT) == OperationStatus.SUCCESS) {
            this.dumpOne(this.outputFile, foundKey, this.formatUsingPrintable);
            this.dumpOne(this.outputFile, foundData, this.formatUsingPrintable);
        }
        cursor.close();
        db.close();
        this.outputFile.println("DATA=END");
        Tracer.trace(Level.INFO, DbInternal.envGetEnvironmentImpl(this.env), "DbDump.dump of " + this.dbName + " ending");
    }

    private void printHeader(PrintStream o, boolean formatUsingPrintable) {
        o.println("VERSION=3");
        if (formatUsingPrintable) {
            o.println("format=print");
        } else {
            o.println("format=bytevalue");
        }
        o.println("type=btree");
        o.println("dupsort=" + (this.dupSort ? "1" : "0"));
        o.println("HEADER=END");
    }

    private void dumpOne(PrintStream o, DatabaseEntry dbt, boolean formatUsingPrintable) {
        byte[] ba = dbt.getData();
        o.print(' ');
        for (int i = 0; i < ba.length; ++i) {
            String hex;
            int b = ba[i] & 0xFF;
            if (formatUsingPrintable) {
                if (this.isPrint(b)) {
                    if (b == 92) {
                        o.print('\\');
                    }
                    o.print(printableChars.charAt(b - 32));
                    continue;
                }
                o.print('\\');
                hex = Integer.toHexString(b);
                if (b < 16) {
                    o.print('0');
                }
                o.print(hex);
                continue;
            }
            hex = Integer.toHexString(b);
            if (b < 16) {
                o.print('0');
            }
            o.print(hex);
        }
        o.println("");
    }

    private boolean isPrint(int b) {
        return b < 127 && 31 < b;
    }
}

