/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.je.tree;

import com.sleepycat.je.DatabaseException;
import com.sleepycat.je.dbi.DatabaseImpl;
import com.sleepycat.je.dbi.EnvironmentImpl;
import com.sleepycat.je.log.LogFileNotFoundException;
import com.sleepycat.je.log.LogReadable;
import com.sleepycat.je.log.LogWritable;
import com.sleepycat.je.tree.IN;
import com.sleepycat.je.tree.Key;
import com.sleepycat.je.tree.Node;
import com.sleepycat.je.tree.TreeUtils;
import com.sleepycat.je.utilint.DbLsn;
import java.nio.ByteBuffer;

public final class ChildReference
implements LogWritable,
LogReadable {
    private Node target;
    private DbLsn lsn;
    private Key key;
    private byte state;
    private static final byte KNOWN_DELETED_BIT = 1;
    private static final byte CLEAR_KNOWN_DELETED_BIT = -2;
    private static final byte DIRTY_BIT = 2;
    private static final byte CLEAR_DIRTY_BIT = -3;
    static final /* synthetic */ boolean $assertionsDisabled;

    ChildReference() {
        this.init(null, new Key(), new DbLsn(), false, false);
    }

    public ChildReference(Node target, Key key, DbLsn lsn) {
        this.init(target, key, lsn, false, true);
    }

    ChildReference(Key key, DbLsn lsn, boolean knownDeleted) {
        this.init(null, key, lsn, knownDeleted, true);
    }

    private void init(Node target, Key key, DbLsn lsn, boolean knownDeleted, boolean dirty) {
        this.target = target;
        this.key = key;
        this.lsn = lsn;
        this.state = 0;
        if (knownDeleted) {
            this.state = (byte)(this.state | 1);
        }
        if (dirty) {
            this.state = (byte)(this.state | 2);
        }
    }

    public Key getKey() {
        return this.key;
    }

    public void setKey(Key key) {
        this.key = key;
        this.state = (byte)(this.state | 2);
    }

    public Node fetchTarget(DatabaseImpl database, IN in) throws DatabaseException {
        if (this.isKnownDeleted()) {
            throw new DatabaseException("attempt to fetch a deleted entry: " + this.lsn);
        }
        return this.fetchTargetInternal(database, in);
    }

    Node fetchTargetIgnoreKnownDeleted(DatabaseImpl database, IN in) throws DatabaseException {
        return this.fetchTargetInternal(database, in);
    }

    private Node fetchTargetInternal(DatabaseImpl database, IN in) throws DatabaseException {
        if (this.target == null) {
            try {
                EnvironmentImpl env = database.getDbEnvironment();
                Node node = (Node)env.getLogManager().get(this.lsn);
                node.postFetchInit(database);
                this.target = node;
            }
            catch (LogFileNotFoundException LNFE) {
                if (!this.isKnownDeleted()) {
                    throw new DatabaseException(this.makeFetchErrorMsg(in, LNFE), LNFE);
                }
            }
            catch (Exception e) {
                throw new DatabaseException(this.makeFetchErrorMsg(in, e), e);
            }
            if (in != null) {
                in.updateMemorySize(null, this.target);
            }
        }
        return this.target;
    }

    private String makeFetchErrorMsg(IN parent, Exception e) {
        StringBuffer sb = new StringBuffer();
        sb.append("fetchTarget of ");
        if (this.lsn == null) {
            sb.append("null lsn");
        } else {
            sb.append(this.lsn.getNoFormatString());
        }
        if (parent != null) {
            sb.append(" parent in=").append(parent.getNodeId());
        }
        sb.append(" state=").append(this.state);
        sb.append(" ").append(e);
        return sb.toString();
    }

    public Node getTarget() {
        return this.target;
    }

    public void setTarget(Node target) {
        this.target = target;
    }

    public void clearTarget() {
        this.target = null;
    }

    public DbLsn getLsn() {
        return this.lsn;
    }

    public void setLsn(DbLsn lsn) {
        this.lsn = lsn;
        this.state = (byte)(this.state | 2);
    }

    public boolean isKnownDeleted() {
        return (this.state & 1) != 0;
    }

    void setKnownDeleted() {
        this.state = (byte)(this.state | 1);
        this.state = (byte)(this.state | 2);
    }

    void clearKnownDeleted() {
        this.state = (byte)(this.state & 0xFFFFFFFE);
        this.state = (byte)(this.state | 2);
    }

    boolean isDirty() {
        return (this.state & 2) != 0;
    }

    long getInMemorySize() {
        long ret = 1L;
        if (this.key != null) {
            ret += (long)this.key.getKey().length + 32L;
        }
        if (this.lsn != null) {
            ret += 16L;
        }
        if (this.target != null) {
            ret += this.target.getMemorySizeIncludedByParent();
        }
        return ret;
    }

    public int getLogSize() {
        return this.key.getLogSize() + this.lsn.getLogSize() + 1;
    }

    public void writeToLog(ByteBuffer logBuffer) {
        this.key.writeToLog(logBuffer);
        if (!$assertionsDisabled && this.lsn == null) {
            throw new AssertionError();
        }
        this.lsn.writeToLog(logBuffer);
        logBuffer.put(this.state);
        this.state = (byte)(this.state & 0xFFFFFFFD);
    }

    public void readFromLog(ByteBuffer itemBuffer) {
        this.key.readFromLog(itemBuffer);
        this.lsn.readFromLog(itemBuffer);
        this.state = itemBuffer.get();
        this.state = (byte)(this.state & 0xFFFFFFFD);
    }

    public void dumpLog(StringBuffer sb, boolean verbose) {
        sb.append("<ref knownDeleted=\"").append(this.isKnownDeleted());
        sb.append("\">");
        this.key.dumpLog(sb, verbose);
        this.lsn.dumpLog(sb, verbose);
        sb.append("</ref>");
    }

    public boolean logEntryIsTransactional() {
        return false;
    }

    public long getTransactionId() {
        return 0L;
    }

    String dumpString(int nspaces, boolean dumpTags) {
        StringBuffer sb = new StringBuffer();
        if (this.lsn == null) {
            sb.append(TreeUtils.indent(nspaces));
            sb.append("<lsn/>");
        } else {
            sb.append(this.lsn.dumpString(nspaces));
        }
        sb.append('\n');
        if (this.key == null) {
            sb.append(TreeUtils.indent(nspaces));
            sb.append("<key/>");
        } else {
            sb.append(this.key.dumpString(nspaces));
        }
        sb.append('\n');
        if (this.target == null) {
            sb.append(TreeUtils.indent(nspaces));
            sb.append("<target/>");
        } else {
            sb.append(this.target.dumpString(nspaces, true));
        }
        sb.append('\n');
        sb.append(TreeUtils.indent(nspaces));
        sb.append("<knownDeleted val=\"");
        sb.append(this.isKnownDeleted()).append("\"/>");
        sb.append("<dirty val=\"").append(this.isDirty()).append("\"/>");
        return sb.toString();
    }

    public String toString() {
        return this.dumpString(0, false);
    }

    static {
        $assertionsDisabled = !ChildReference.class.desiredAssertionStatus();
    }
}

