/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.je.log;

import com.sleepycat.je.DatabaseException;
import com.sleepycat.je.dbi.DatabaseId;
import com.sleepycat.je.dbi.DbTree;
import com.sleepycat.je.dbi.EnvironmentImpl;
import com.sleepycat.je.log.FileReader;
import com.sleepycat.je.log.LogEntryType;
import com.sleepycat.je.log.entry.INContainingEntry;
import com.sleepycat.je.log.entry.LNLogEntry;
import com.sleepycat.je.log.entry.LogEntry;
import com.sleepycat.je.tree.IN;
import com.sleepycat.je.tree.INDeleteInfo;
import com.sleepycat.je.tree.Key;
import com.sleepycat.je.tree.MapLN;
import com.sleepycat.je.tree.Node;
import com.sleepycat.je.utilint.DbLsn;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.Map;

public class INFileReader
extends FileReader {
    private boolean lastEntryWasDelete;
    private Map targetEntryMap;
    private LogEntry targetLogEntry;
    private Map dbIdTrackingMap;
    private LNLogEntry dbIdTrackingEntry;
    private Map txnIdTrackingMap;
    private LNLogEntry txnIdTrackingEntry;
    private boolean trackIds;
    private long maxNodeId;
    private int maxDbId;
    private long maxTxnId;
    private boolean mapDbOnly;

    public INFileReader(EnvironmentImpl env, int readBufferSize, DbLsn startLsn, boolean trackIds, boolean mapDbOnly) throws IOException, DatabaseException {
        super(env, readBufferSize, true, startLsn, null, null, null);
        this.trackIds = trackIds;
        this.maxNodeId = 0L;
        this.maxDbId = 0;
        this.mapDbOnly = mapDbOnly;
        this.targetEntryMap = new HashMap();
        this.dbIdTrackingMap = new HashMap();
        this.txnIdTrackingMap = new HashMap();
        if (trackIds) {
            this.dbIdTrackingMap.put(LogEntryType.LOG_MAPLN_TRANSACTIONAL, LogEntryType.LOG_MAPLN_TRANSACTIONAL.getNewLogEntry());
            this.dbIdTrackingMap.put(LogEntryType.LOG_MAPLN, LogEntryType.LOG_MAPLN.getNewLogEntry());
            this.txnIdTrackingMap.put(LogEntryType.LOG_LN_TRANSACTIONAL, LogEntryType.LOG_LN_TRANSACTIONAL.getNewLogEntry());
            this.txnIdTrackingMap.put(LogEntryType.LOG_MAPLN_TRANSACTIONAL, LogEntryType.LOG_MAPLN_TRANSACTIONAL.getNewLogEntry());
            this.txnIdTrackingMap.put(LogEntryType.LOG_NAMELN_TRANSACTIONAL, LogEntryType.LOG_NAMELN_TRANSACTIONAL.getNewLogEntry());
        }
    }

    public void addTargetType(LogEntryType entryType) throws DatabaseException {
        this.targetEntryMap.put(entryType, entryType.getNewLogEntry());
    }

    protected boolean isTargetEntry(byte entryTypeNum, byte entryTypeVersion) {
        this.lastEntryWasDelete = false;
        this.targetLogEntry = null;
        this.dbIdTrackingEntry = null;
        this.txnIdTrackingEntry = null;
        if (!LogEntryType.isProvisional(entryTypeVersion)) {
            LogEntryType fromLogType = new LogEntryType(entryTypeNum, entryTypeVersion);
            this.targetLogEntry = (LogEntry)this.targetEntryMap.get(fromLogType);
            if (this.targetLogEntry == null) {
                this.dbIdTrackingEntry = (LNLogEntry)this.dbIdTrackingMap.get(fromLogType);
                this.txnIdTrackingEntry = (LNLogEntry)this.txnIdTrackingMap.get(fromLogType);
            } else if (LogEntryType.LOG_IN_DELETE_INFO.equals(fromLogType)) {
                this.lastEntryWasDelete = true;
            }
        }
        if (this.trackIds) {
            return this.targetLogEntry != null || this.dbIdTrackingEntry != null || LogEntryType.isNodeType(entryTypeNum, entryTypeVersion);
        }
        return this.targetLogEntry != null;
    }

    protected boolean processEntry(ByteBuffer entryBuffer) throws DatabaseException {
        long entryNodeId = 0L;
        boolean nodeIdSet = false;
        boolean useEntry = false;
        if (this.targetLogEntry != null) {
            this.targetLogEntry.readEntry(entryBuffer);
            DatabaseId dbId = this.getDatabaseId();
            boolean isMapDb = dbId.equals(DbTree.ID_DB_ID);
            if (this.mapDbOnly && !isMapDb) {
                useEntry = false;
            } else {
                if (!this.lastEntryWasDelete) {
                    entryNodeId = ((INContainingEntry)((Object)this.targetLogEntry)).getIN(this.env).getNodeId();
                }
                useEntry = true;
            }
        } else if (this.trackIds) {
            LNLogEntry lnEntry = null;
            if (this.dbIdTrackingEntry != null) {
                lnEntry = this.dbIdTrackingEntry;
                lnEntry.readEntry(entryBuffer);
                MapLN mapLN = (MapLN)lnEntry.getMainItem();
                int dbId = mapLN.getDatabase().getId().getId();
                if (dbId > this.maxDbId) {
                    this.maxDbId = dbId;
                }
                entryNodeId = lnEntry.getLN().getNodeId();
                nodeIdSet = true;
            }
            if (this.txnIdTrackingEntry != null) {
                long txnId;
                if (lnEntry == null) {
                    lnEntry = this.txnIdTrackingEntry;
                    lnEntry.readEntry(entryBuffer);
                }
                if ((txnId = lnEntry.getTxnId().longValue()) > this.maxTxnId) {
                    this.maxTxnId = txnId;
                }
                entryNodeId = lnEntry.getLN().getNodeId();
                nodeIdSet = true;
            }
            if (!nodeIdSet) {
                entryNodeId = Node.readNodeIdFromLog(entryBuffer, this.currentEntrySize);
            }
        }
        if (this.trackIds) {
            this.maxNodeId = entryNodeId > this.maxNodeId ? entryNodeId : this.maxNodeId;
        }
        return useEntry;
    }

    public IN getIN() throws DatabaseException {
        return ((INContainingEntry)((Object)this.targetLogEntry)).getIN(this.env);
    }

    public DatabaseId getDatabaseId() {
        if (this.lastEntryWasDelete) {
            return ((INDeleteInfo)this.targetLogEntry.getMainItem()).getDatabaseId();
        }
        return ((INContainingEntry)((Object)this.targetLogEntry)).getDbId();
    }

    public long getMaxNodeId() {
        return this.maxNodeId;
    }

    public int getMaxDbId() {
        return this.maxDbId;
    }

    public long getMaxTxnId() {
        return this.maxTxnId;
    }

    public boolean isDeleteInfo() {
        return this.lastEntryWasDelete;
    }

    public long getDeletedNodeId() {
        return ((INDeleteInfo)this.targetLogEntry.getMainItem()).getDeletedNodeId();
    }

    public Key getDeletedIdKey() {
        return ((INDeleteInfo)this.targetLogEntry.getMainItem()).getDeletedIdKey();
    }

    public DbLsn getLsnOfIN() {
        return ((INContainingEntry)((Object)this.targetLogEntry)).getLsnOfIN(this.getLastLsn());
    }
}

