/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.je.dbi;

import com.sleepycat.je.CheckpointConfig;
import com.sleepycat.je.Database;
import com.sleepycat.je.DatabaseConfig;
import com.sleepycat.je.DatabaseException;
import com.sleepycat.je.DbInternal;
import com.sleepycat.je.EnvironmentConfig;
import com.sleepycat.je.EnvironmentMutableConfig;
import com.sleepycat.je.EnvironmentStats;
import com.sleepycat.je.LockStats;
import com.sleepycat.je.RunRecoveryException;
import com.sleepycat.je.StatsConfig;
import com.sleepycat.je.Transaction;
import com.sleepycat.je.TransactionConfig;
import com.sleepycat.je.TransactionStats;
import com.sleepycat.je.VerifyConfig;
import com.sleepycat.je.cleaner.Cleaner;
import com.sleepycat.je.cleaner.UtilizationProfile;
import com.sleepycat.je.cleaner.UtilizationTracker;
import com.sleepycat.je.config.EnvironmentParams;
import com.sleepycat.je.dbi.DatabaseImpl;
import com.sleepycat.je.dbi.DbConfigManager;
import com.sleepycat.je.dbi.DbEnvPool;
import com.sleepycat.je.dbi.DbEnvState;
import com.sleepycat.je.dbi.DbTree;
import com.sleepycat.je.dbi.EnvConfigObserver;
import com.sleepycat.je.dbi.EnvironmentStatsInternal;
import com.sleepycat.je.dbi.INList;
import com.sleepycat.je.dbi.MemoryBudget;
import com.sleepycat.je.dbi.TruncateResult;
import com.sleepycat.je.evictor.Evictor;
import com.sleepycat.je.incomp.INCompressor;
import com.sleepycat.je.latch.Latch;
import com.sleepycat.je.latch.SharedLatch;
import com.sleepycat.je.log.FileManager;
import com.sleepycat.je.log.LatchedLogManager;
import com.sleepycat.je.log.LogManager;
import com.sleepycat.je.log.SyncedLogManager;
import com.sleepycat.je.log.TraceLogHandler;
import com.sleepycat.je.recovery.Checkpointer;
import com.sleepycat.je.recovery.RecoveryInfo;
import com.sleepycat.je.recovery.RecoveryManager;
import com.sleepycat.je.tree.BIN;
import com.sleepycat.je.tree.BINReference;
import com.sleepycat.je.tree.Key;
import com.sleepycat.je.txn.Locker;
import com.sleepycat.je.txn.Txn;
import com.sleepycat.je.txn.TxnManager;
import com.sleepycat.je.utilint.DbLsn;
import com.sleepycat.je.utilint.PropUtil;
import com.sleepycat.je.utilint.Tracer;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.logging.ConsoleHandler;
import java.util.logging.FileHandler;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.logging.SimpleFormatter;

public class EnvironmentImpl
implements EnvConfigObserver {
    private DbEnvState envState;
    private File envHome;
    private int referenceCount;
    private boolean isTransactional;
    private boolean isReadOnly;
    private boolean directNIO;
    private MemoryBudget memoryBudget;
    private long lockTimeout;
    private long txnTimeout;
    private DbTree dbMapTree;
    private DbLsn mapTreeRootLsn;
    private Latch mapTreeRootLatch;
    private INList inMemoryINs;
    private DbConfigManager configManager;
    private List configObservers;
    private Logger envLogger;
    protected LogManager logManager;
    private FileManager fileManager;
    private TxnManager txnManager;
    private Evictor evictor;
    private INCompressor inCompressor;
    private Checkpointer checkpointer;
    private Cleaner cleaner;
    private UtilizationProfile utilizationProfile;
    private UtilizationTracker utilizationTracker;
    RecoveryInfo lastRecoveryInfo;
    RunRecoveryException savedInvalidatingException;
    private static boolean forcedYield;
    private SharedLatch triggerLatch;
    static final /* synthetic */ boolean $assertionsDisabled;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public EnvironmentImpl(File envHome, EnvironmentConfig envConfig) throws DatabaseException {
        try {
            this.envHome = envHome;
            this.envState = DbEnvState.INIT;
            this.mapTreeRootLatch = new Latch("MapTreeRoot", this);
            this.configManager = new DbConfigManager(envConfig);
            this.configObservers = new ArrayList();
            this.addConfigObserver(this);
            this.memoryBudget = new MemoryBudget(this, this.configManager);
            this.envLogger = this.initLogger(envHome);
            forcedYield = this.configManager.getBoolean(EnvironmentParams.ENV_FORCED_YIELD);
            this.isTransactional = this.configManager.getBoolean(EnvironmentParams.ENV_INIT_TXN);
            this.directNIO = this.configManager.getBoolean(EnvironmentParams.LOG_DIRECT_NIO);
            this.isReadOnly = this.configManager.getBoolean(EnvironmentParams.ENV_RDONLY);
            this.fileManager = new FileManager(this, envHome, this.isReadOnly);
            if (!envConfig.getAllowCreate() && !this.fileManager.filesExist()) {
                throw new DatabaseException("Enviroment creation isn't allowed,  but there is no pre-existing  environment in " + envHome);
            }
            this.logManager = this.getConfigManager().getBoolean(EnvironmentParams.ENV_FAIR_LATCHES) ? new LatchedLogManager(this, this.isReadOnly) : new SyncedLogManager(this, this.isReadOnly);
            this.inMemoryINs = new INList(this);
            this.txnManager = new TxnManager(this);
            this.utilizationTracker = new UtilizationTracker(this);
            this.utilizationProfile = new UtilizationProfile(this, this.utilizationTracker);
            this.createDaemons();
            this.dbMapTree = new DbTree(this);
            this.referenceCount = 0;
            this.triggerLatch = new SharedLatch(this, "TriggerLatch", this);
            if (this.configManager.getBoolean(EnvironmentParams.ENV_RECOVERY)) {
                try {
                    RecoveryManager recoveryManager = new RecoveryManager(this);
                    this.lastRecoveryInfo = recoveryManager.recover(this.isReadOnly);
                    Object var5_5 = null;
                }
                catch (Throwable throwable) {
                    Object var5_6 = null;
                    try {
                        this.logManager.flush();
                        this.fileManager.clear();
                    }
                    catch (IOException e) {
                        throw new DatabaseException(e.getMessage());
                    }
                    throw throwable;
                }
                try {
                    this.logManager.flush();
                    this.fileManager.clear();
                }
                catch (IOException e) {
                    throw new DatabaseException(e.getMessage());
                }
            }
            this.isReadOnly = true;
            this.runOrPauseDaemons(this.configManager);
            this.lockTimeout = PropUtil.microsToMillis(this.configManager.getLong(EnvironmentParams.LOCK_TIMEOUT));
            this.txnTimeout = PropUtil.microsToMillis(this.configManager.getLong(EnvironmentParams.TXN_TIMEOUT));
            this.memoryBudget.initCacheMemoryUsage();
            this.open();
        }
        catch (DatabaseException e) {
            if (this.fileManager != null) {
                try {
                    this.fileManager.close();
                }
                catch (IOException IOE) {
                    // empty catch block
                }
            }
            throw e;
        }
    }

    public void envConfigUpdate(DbConfigManager mgr) throws DatabaseException {
        this.runOrPauseDaemons(mgr);
    }

    private void createDaemons() throws DatabaseException {
        int evictorNodeScanPercentage = this.configManager.getInt(EnvironmentParams.EVICTOR_NODE_SCAN_PERCENTAGE);
        int evictorEvictionBatchPercentage = this.configManager.getInt(EnvironmentParams.EVICTOR_EVICTION_BATCH_PERCENTAGE);
        this.evictor = new Evictor(this, "Evictor", evictorNodeScanPercentage, evictorEvictionBatchPercentage);
        long checkpointerWakeupTime = Checkpointer.getWakeupPeriod(this.configManager);
        this.checkpointer = new Checkpointer(this, checkpointerWakeupTime, "Checkpointer");
        long compressorWakeupInterval = PropUtil.microsToMillis(this.configManager.getLong(EnvironmentParams.COMPRESSOR_WAKEUP_INTERVAL));
        this.inCompressor = new INCompressor(this, compressorWakeupInterval, "INCompressor");
        this.cleaner = new Cleaner(this, 0L, "Cleaner", this.utilizationProfile);
    }

    private void runOrPauseDaemons(DbConfigManager mgr) throws DatabaseException {
        if (!this.isReadOnly) {
            this.inCompressor.runOrPause(mgr.getBoolean(EnvironmentParams.ENV_RUN_INCOMPRESSOR));
            this.cleaner.runOrPause(mgr.getBoolean(EnvironmentParams.ENV_RUN_CLEANER) && !mgr.getBoolean(EnvironmentParams.LOG_MEMORY_ONLY));
            this.checkpointer.runOrPause(mgr.getBoolean(EnvironmentParams.ENV_RUN_CHECKPOINTER));
        }
        this.evictor.runOrPause(mgr.getBoolean(EnvironmentParams.ENV_RUN_EVICTOR));
    }

    public INCompressor getINCompressor() {
        return this.inCompressor;
    }

    public UtilizationTracker getUtilizationTracker() {
        return this.utilizationTracker;
    }

    public UtilizationProfile getUtilizationProfile() {
        return this.utilizationProfile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void logMapTreeRoot() throws DatabaseException {
        this.mapTreeRootLatch.acquire();
        try {
            this.mapTreeRootLsn = this.logManager.log(this.dbMapTree);
        }
        finally {
            this.mapTreeRootLatch.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void rewriteMapTreeRoot(DbLsn cleanerTargetLsn) throws DatabaseException {
        this.mapTreeRootLatch.acquire();
        try {
            if (cleanerTargetLsn.compareTo(this.mapTreeRootLsn) == 0) {
                this.mapTreeRootLsn = this.logManager.log(this.dbMapTree);
            }
        }
        finally {
            this.mapTreeRootLatch.release();
        }
    }

    public DbLsn getRootLsn() {
        return this.mapTreeRootLsn;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void readMapTreeFromLog(DbLsn rootLsn) throws DatabaseException {
        this.dbMapTree = (DbTree)this.logManager.get(rootLsn);
        this.dbMapTree.setEnvironmentImpl(this);
        this.mapTreeRootLatch.acquire();
        try {
            this.mapTreeRootLsn = rootLsn;
        }
        finally {
            this.mapTreeRootLatch.release();
        }
    }

    public void addToCompressorQueue(BIN bin, Key deletedKey) throws DatabaseException {
        if (this.inCompressor != null) {
            this.inCompressor.addBinKeyToQueue(bin, deletedKey);
        }
    }

    public void addToCompressorQueue(BINReference binRef) throws DatabaseException {
        if (this.inCompressor != null) {
            this.inCompressor.addBinRefToQueue(binRef);
        }
    }

    public void addToCompressorQueue(Collection binRefs) throws DatabaseException {
        if (this.inCompressor != null) {
            this.inCompressor.addMultipleBinRefsToQueue(binRefs);
        }
    }

    private Logger initLogger(File envHome) throws DatabaseException {
        Logger logger = Logger.getAnonymousLogger();
        logger.setUseParentHandlers(false);
        Level level = Tracer.parseLevel(this, EnvironmentParams.JE_LOGGING_LEVEL);
        logger.setLevel(level);
        if (this.configManager.getBoolean(EnvironmentParams.JE_LOGGING_CONSOLE)) {
            ConsoleHandler consoleHandler = new ConsoleHandler();
            consoleHandler.setLevel(level);
            logger.addHandler(consoleHandler);
        }
        FileHandler fileHandler = null;
        try {
            if (this.configManager.getBoolean(EnvironmentParams.JE_LOGGING_FILE)) {
                int limit = this.configManager.getInt(EnvironmentParams.JE_LOGGING_FILE_LIMIT);
                int count = this.configManager.getInt(EnvironmentParams.JE_LOGGING_FILE_COUNT);
                String logFilePattern = envHome + "/" + "je.info";
                fileHandler = new FileHandler(logFilePattern, limit, count, true);
                fileHandler.setFormatter(new SimpleFormatter());
                fileHandler.setLevel(level);
                logger.addHandler(fileHandler);
            }
        }
        catch (IOException e) {
            throw new DatabaseException(e.getMessage());
        }
        return logger;
    }

    public void enableDebugLoggingToDbLog() throws DatabaseException {
        if (this.configManager.getBoolean(EnvironmentParams.JE_LOGGING_DBLOG)) {
            TraceLogHandler dbLogHandler = new TraceLogHandler(this);
            Level level = Level.parse(this.configManager.get(EnvironmentParams.JE_LOGGING_LEVEL));
            dbLogHandler.setLevel(level);
            this.envLogger.addHandler(dbLogHandler);
        }
    }

    public void closeLogger() {
        Handler[] handlers = this.envLogger.getHandlers();
        for (int i = 0; i < handlers.length; ++i) {
            handlers[i].close();
        }
    }

    public void open() {
        this.envState = DbEnvState.OPEN;
    }

    public void invalidate(RunRecoveryException e) {
        this.envState = DbEnvState.INVALID;
        this.savedInvalidatingException = e;
    }

    public boolean isOpen() {
        return this.envState == DbEnvState.OPEN;
    }

    public boolean isClosed() {
        return this.envState == DbEnvState.CLOSED;
    }

    public void checkIfInvalid() throws RunRecoveryException {
        if (this.envState == DbEnvState.INVALID) {
            this.savedInvalidatingException.setAlreadyThrown();
            throw this.savedInvalidatingException;
        }
    }

    public void checkNotClosed() throws DatabaseException {
        if (this.envState == DbEnvState.CLOSED) {
            throw new DatabaseException("Attempt to use a Environment that has been closed.");
        }
    }

    public synchronized void close() throws DatabaseException {
        if (--this.referenceCount <= 0) {
            this.doClose(true);
        }
    }

    public synchronized void close(boolean doCheckpoint) throws DatabaseException {
        if (--this.referenceCount <= 0) {
            this.doClose(doCheckpoint);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void doClose(boolean doCheckpoint) throws DatabaseException {
        StringBuffer errors = new StringBuffer();
        try {
            Tracer.trace(Level.FINE, this, "Close of environment " + this.envHome + " started");
            this.envState.checkState(DbEnvState.VALID_FOR_CLOSE, DbEnvState.CLOSED);
            if (doCheckpoint && !this.isReadOnly) {
                CheckpointConfig ckptConfig = new CheckpointConfig();
                ckptConfig.setForce(true);
                this.invokeCheckpoint(ckptConfig, false, true, "close");
            }
            try {
                this.shutdownDaemons();
            }
            catch (InterruptedException IE) {
                errors.append("\nException shutting down daemon threads: ");
                errors.append(IE.toString()).append("\n");
            }
            Tracer.trace(Level.FINE, this, "Env " + this.envHome + " daemons shutdown");
            try {
                this.logManager.flush();
            }
            catch (DatabaseException DBE) {
                errors.append("\nException flushing log manager: ");
                errors.append(DBE.toString()).append("\n");
            }
            try {
                this.fileManager.clear();
            }
            catch (IOException IOE) {
                errors.append("\nException clearing file manager: ");
                errors.append(IOE.toString()).append("\n");
            }
            catch (DatabaseException DBE) {
                errors.append("\nException clearing file manager: ");
                errors.append(DBE.toString()).append("\n");
            }
            try {
                this.fileManager.close();
            }
            catch (IOException IOE) {
                errors.append("\nException clearing file manager: ");
                errors.append(IOE.toString()).append("\n");
            }
            catch (DatabaseException DBE) {
                errors.append("\nException clearing file manager: ");
                errors.append(DBE.toString()).append("\n");
            }
            try {
                this.inMemoryINs.clear();
            }
            catch (DatabaseException DBE) {
                errors.append("\nException closing file manager: ");
                errors.append(DBE.toString()).append("\n");
            }
            this.closeLogger();
            DbEnvPool.getInstance().remove(this.envHome);
            try {
                this.checkLeaks();
                Latch.clearNotes();
            }
            catch (DatabaseException DBE) {
                errors.append("\nException performing validity checks: ");
                errors.append(DBE.toString()).append("\n");
            }
        }
        finally {
            this.envState = DbEnvState.CLOSED;
        }
        if (errors.length() > 0) {
            throw new RunRecoveryException(this, errors.toString());
        }
    }

    public synchronized void closeAfterRunRecovery() {
        try {
            this.shutdownDaemons();
        }
        catch (InterruptedException IE) {
            // empty catch block
        }
        try {
            this.fileManager.clear();
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            this.fileManager.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        DbEnvPool.getInstance().remove(this.envHome);
    }

    public synchronized void forceClose() throws DatabaseException {
        this.referenceCount = 1;
        this.close();
    }

    public synchronized void incReferenceCount() {
        ++this.referenceCount;
    }

    private void checkLeaks() throws DatabaseException {
        TransactionStats txnStat;
        if (!this.configManager.getBoolean(EnvironmentParams.ENV_CHECK_LEAKS)) {
            return;
        }
        boolean clean = true;
        StatsConfig statsConfig = new StatsConfig();
        statsConfig.setFast(true);
        LockStats lockStat = this.lockStat(statsConfig);
        if (lockStat.getNTotalLocks() != 0) {
            clean = false;
            System.out.println("Problem: " + lockStat.getNTotalLocks() + " locks left");
            this.txnManager.getLockManager().dump();
        }
        if ((txnStat = this.txnStat(statsConfig)).getNActive() != 0) {
            clean = false;
            System.out.println("Problem: " + txnStat.getNActive() + " txns left");
            TransactionStats.Active[] active = txnStat.getActiveTxns();
            if (active != null) {
                for (int i = 0; i < active.length; ++i) {
                    System.out.println(active[i]);
                }
            }
        }
        if (!$assertionsDisabled && !clean) {
            throw new AssertionError((Object)"Lock or transaction left behind at environment close");
        }
        if (Latch.countLatchesHeld() > 0) {
            System.out.println("Some latches held at env close.");
            Latch.dumpLatchesHeld();
        }
    }

    public boolean invokeCheckpoint(CheckpointConfig config, boolean flushAll, boolean deleteAllCleanedFiles, String invokingSource) throws DatabaseException {
        if (this.checkpointer != null) {
            this.checkpointer.doCheckpoint(config, true, flushAll, deleteAllCleanedFiles, invokingSource);
            return true;
        }
        return false;
    }

    public boolean invokeCompressor() throws DatabaseException {
        if (this.inCompressor != null) {
            this.inCompressor.doCompress();
            return true;
        }
        return false;
    }

    public void invokeEvictor() throws DatabaseException {
        if (this.evictor != null) {
            this.evictor.doEvict(true);
        }
    }

    public int invokeCleaner() throws DatabaseException {
        if (this.cleaner != null) {
            return this.cleaner.doClean(false, true, false);
        }
        return 0;
    }

    private void shutdownDaemons() throws InterruptedException {
        this.shutdownINCompressor();
        this.shutdownCleaner();
        this.shutdownCheckpointer();
        this.shutdownEvictor();
    }

    public void shutdownINCompressor() throws InterruptedException {
        if (this.inCompressor != null) {
            this.inCompressor.shutdown();
            this.inCompressor.clearEnv();
            this.inCompressor = null;
        }
    }

    public void shutdownEvictor() throws InterruptedException {
        if (this.evictor != null) {
            this.evictor.shutdown();
            this.evictor.clearEnv();
            this.evictor = null;
        }
    }

    void shutdownCheckpointer() throws InterruptedException {
        if (this.checkpointer != null) {
            this.checkpointer.shutdown();
            this.checkpointer.clearEnv();
            this.checkpointer = null;
        }
    }

    public void shutdownCleaner() throws InterruptedException {
        if (this.cleaner != null) {
            this.cleaner.shutdown();
            this.cleaner.clearEnv();
            this.cleaner = null;
        }
    }

    public boolean isTransactional() {
        return this.isTransactional;
    }

    public boolean isReadOnly() {
        return this.isReadOnly;
    }

    public boolean useDirectNIO() {
        return this.directNIO;
    }

    public DatabaseImpl createDb(Locker locker, String databaseName, DatabaseConfig dbConfig, Database databaseHandle) throws DatabaseException {
        return this.dbMapTree.createDb(locker, databaseName, dbConfig, databaseHandle);
    }

    public DatabaseImpl getDb(Locker locker, String databaseName, Database databaseHandle) throws DatabaseException {
        return this.dbMapTree.getDb(locker, databaseName, databaseHandle);
    }

    public List getDbNames() throws DatabaseException {
        return this.dbMapTree.getDbNames();
    }

    public void dumpMapTree() throws DatabaseException {
        this.dbMapTree.dump();
    }

    public void dbRename(Locker locker, String databaseName, String newName) throws DatabaseException {
        this.dbMapTree.dbRename(locker, databaseName, newName);
    }

    public void dbRemove(Locker locker, String databaseName) throws DatabaseException {
        this.dbMapTree.dbRemove(locker, databaseName);
    }

    public TruncateResult truncate(Locker locker, DatabaseImpl database) throws DatabaseException {
        return this.dbMapTree.truncate(locker, database);
    }

    public Txn txnBegin(Transaction parent, TransactionConfig txnConfig) throws DatabaseException {
        if (!this.isTransactional) {
            throw new DatabaseException("beginTransaction called,  but Environment was not opened with transactional cpabilities");
        }
        return this.txnManager.txnBegin(parent, txnConfig);
    }

    public LogManager getLogManager() {
        return this.logManager;
    }

    public FileManager getFileManager() {
        return this.fileManager;
    }

    public DbTree getDbMapTree() {
        return this.dbMapTree;
    }

    public DbConfigManager getConfigManager() {
        return this.configManager;
    }

    public EnvironmentConfig cloneConfig() {
        return DbInternal.cloneConfig(this.configManager.getEnvironmentConfig());
    }

    public EnvironmentMutableConfig cloneMutableConfig() {
        return DbInternal.cloneMutableConfig(this.configManager.getEnvironmentConfig());
    }

    public void checkImmutablePropsForEquality(EnvironmentConfig config) throws IllegalArgumentException {
        DbInternal.checkImmutablePropsForEquality(this.configManager.getEnvironmentConfig(), config);
    }

    public synchronized void setMutableConfig(EnvironmentMutableConfig config) throws DatabaseException {
        EnvironmentConfig newConfig = DbInternal.cloneConfig(this.configManager.getEnvironmentConfig());
        DbInternal.copyMutablePropsTo(config, newConfig);
        this.configManager = new DbConfigManager(newConfig);
        for (int i = 0; i < this.configObservers.size(); ++i) {
            EnvConfigObserver o = (EnvConfigObserver)this.configObservers.get(i);
            o.envConfigUpdate(this.configManager);
        }
    }

    public synchronized void addConfigObserver(EnvConfigObserver o) {
        this.configObservers.add(o);
    }

    public synchronized void removeConfigObserver(EnvConfigObserver o) {
        this.configObservers.remove(o);
    }

    public INList getInMemoryINs() {
        return this.inMemoryINs;
    }

    public TxnManager getTxnManager() {
        return this.txnManager;
    }

    public Checkpointer getCheckpointer() {
        return this.checkpointer;
    }

    public Cleaner getCleaner() {
        return this.cleaner;
    }

    public MemoryBudget getMemoryBudget() {
        return this.memoryBudget;
    }

    public Logger getLogger() {
        return this.envLogger;
    }

    public boolean verify(VerifyConfig config, PrintStream out) throws DatabaseException {
        boolean ret = this.dbMapTree.verify(config, out);
        this.checkLeaks();
        return ret;
    }

    public void verifyCursors() throws DatabaseException {
        this.inCompressor.verifyCursors();
    }

    public synchronized EnvironmentStats loadStats(StatsConfig config) throws DatabaseException {
        EnvironmentStatsInternal stats = new EnvironmentStatsInternal();
        this.inCompressor.loadStats(config, stats);
        this.evictor.loadStats(config, stats);
        this.checkpointer.loadStats(config, stats);
        this.cleaner.loadStats(config, stats);
        this.logManager.loadStats(config, stats);
        this.memoryBudget.loadStats(config, stats);
        return stats;
    }

    public synchronized LockStats lockStat(StatsConfig config) throws DatabaseException {
        return this.txnManager.lockStat(config);
    }

    public synchronized TransactionStats txnStat(StatsConfig config) throws DatabaseException {
        return this.txnManager.txnStat(config);
    }

    public int getInCompressorQueueSize() throws DatabaseException {
        return this.inCompressor.getQueueSize();
    }

    public RecoveryInfo getLastRecoveryInfo() {
        return this.lastRecoveryInfo;
    }

    public File getEnvironmentHome() {
        return this.envHome;
    }

    public long getTxnTimeout() {
        return this.txnTimeout;
    }

    public long getLockTimeout() {
        return this.lockTimeout;
    }

    public SharedLatch getTriggerLatch() {
        return this.triggerLatch;
    }

    public Evictor getEvictor() {
        return this.evictor;
    }

    void alertEvictor() {
        if (this.evictor != null) {
            this.evictor.alert();
        }
    }

    public static boolean getForcedYield() {
        return forcedYield;
    }

    static {
        $assertionsDisabled = !EnvironmentImpl.class.desiredAssertionStatus();
        forcedYield = false;
    }
}

