/* ----------------------------------------------------------------------------
 * This file was automatically generated by SWIG (http://www.swig.org).
 * Version 1.3.39
 * 
 * This file is not intended to be easily readable and contains a number of 
 * coding conventions designed to improve portability and efficiency. Do not make
 * changes to this file unless you know what you are doing--modify the SWIG 
 * interface file instead. 
 * ----------------------------------------------------------------------------- */

#define SWIGJAVA
#define SWIG_DIRECTORS


#ifdef __cplusplus
/* SwigValueWrapper is described in swig.swg */
template<typename T> class SwigValueWrapper {
  struct SwigMovePointer {
    T *ptr;
    SwigMovePointer(T *p) : ptr(p) { }
    ~SwigMovePointer() { delete ptr; }
    SwigMovePointer& operator=(SwigMovePointer& rhs) { T* oldptr = ptr; ptr = 0; delete oldptr; ptr = rhs.ptr; rhs.ptr = 0; return *this; }
  } pointer;
  SwigValueWrapper& operator=(const SwigValueWrapper<T>& rhs);
  SwigValueWrapper(const SwigValueWrapper<T>& rhs);
public:
  SwigValueWrapper() : pointer(0) { }
  SwigValueWrapper& operator=(const T& t) { SwigMovePointer tmp(new T(t)); pointer = tmp; return *this; }
  operator T&() const { return *pointer.ptr; }
  T *operator&() { return pointer.ptr; }
};

template <typename T> T SwigValueInit() {
  return T();
}
#endif

/* -----------------------------------------------------------------------------
 *  This section contains generic SWIG labels for method/variable
 *  declarations/attributes, and other compiler dependent labels.
 * ----------------------------------------------------------------------------- */

/* template workaround for compilers that cannot correctly implement the C++ standard */
#ifndef SWIGTEMPLATEDISAMBIGUATOR
# if defined(__SUNPRO_CC) && (__SUNPRO_CC <= 0x560)
#  define SWIGTEMPLATEDISAMBIGUATOR template
# elif defined(__HP_aCC)
/* Needed even with `aCC -AA' when `aCC -V' reports HP ANSI C++ B3910B A.03.55 */
/* If we find a maximum version that requires this, the test would be __HP_aCC <= 35500 for A.03.55 */
#  define SWIGTEMPLATEDISAMBIGUATOR template
# else
#  define SWIGTEMPLATEDISAMBIGUATOR
# endif
#endif

/* inline attribute */
#ifndef SWIGINLINE
# if defined(__cplusplus) || (defined(__GNUC__) && !defined(__STRICT_ANSI__))
#   define SWIGINLINE inline
# else
#   define SWIGINLINE
# endif
#endif

/* attribute recognised by some compilers to avoid 'unused' warnings */
#ifndef SWIGUNUSED
# if defined(__GNUC__)
#   if !(defined(__cplusplus)) || (__GNUC__ > 3 || (__GNUC__ == 3 && __GNUC_MINOR__ >= 4))
#     define SWIGUNUSED __attribute__ ((__unused__)) 
#   else
#     define SWIGUNUSED
#   endif
# elif defined(__ICC)
#   define SWIGUNUSED __attribute__ ((__unused__)) 
# else
#   define SWIGUNUSED 
# endif
#endif

#ifndef SWIG_MSC_UNSUPPRESS_4505
# if defined(_MSC_VER)
#   pragma warning(disable : 4505) /* unreferenced local function has been removed */
# endif 
#endif

#ifndef SWIGUNUSEDPARM
# ifdef __cplusplus
#   define SWIGUNUSEDPARM(p)
# else
#   define SWIGUNUSEDPARM(p) p SWIGUNUSED 
# endif
#endif

/* internal SWIG method */
#ifndef SWIGINTERN
# define SWIGINTERN static SWIGUNUSED
#endif

/* internal inline SWIG method */
#ifndef SWIGINTERNINLINE
# define SWIGINTERNINLINE SWIGINTERN SWIGINLINE
#endif

/* exporting methods */
#if (__GNUC__ >= 4) || (__GNUC__ == 3 && __GNUC_MINOR__ >= 4)
#  ifndef GCC_HASCLASSVISIBILITY
#    define GCC_HASCLASSVISIBILITY
#  endif
#endif

#ifndef SWIGEXPORT
# if defined(_WIN32) || defined(__WIN32__) || defined(__CYGWIN__)
#   if defined(STATIC_LINKED)
#     define SWIGEXPORT
#   else
#     define SWIGEXPORT __declspec(dllexport)
#   endif
# else
#   if defined(__GNUC__) && defined(GCC_HASCLASSVISIBILITY)
#     define SWIGEXPORT __attribute__ ((visibility("default")))
#   else
#     define SWIGEXPORT
#   endif
# endif
#endif

/* calling conventions for Windows */
#ifndef SWIGSTDCALL
# if defined(_WIN32) || defined(__WIN32__) || defined(__CYGWIN__)
#   define SWIGSTDCALL __stdcall
# else
#   define SWIGSTDCALL
# endif 
#endif

/* Deal with Microsoft's attempt at deprecating C standard runtime functions */
#if !defined(SWIG_NO_CRT_SECURE_NO_DEPRECATE) && defined(_MSC_VER) && !defined(_CRT_SECURE_NO_DEPRECATE)
# define _CRT_SECURE_NO_DEPRECATE
#endif

/* Deal with Microsoft's attempt at deprecating methods in the standard C++ library */
#if !defined(SWIG_NO_SCL_SECURE_NO_DEPRECATE) && defined(_MSC_VER) && !defined(_SCL_SECURE_NO_DEPRECATE)
# define _SCL_SECURE_NO_DEPRECATE
#endif



/* Fix for jlong on some versions of gcc on Windows */
#if defined(__GNUC__) && !defined(__INTEL_COMPILER)
  typedef long long __int64;
#endif

/* Fix for jlong on 64-bit x86 Solaris */
#if defined(__x86_64)
# ifdef _LP64
#   undef _LP64
# endif
#endif

#include <jni.h>
#include <stdlib.h>
#include <string.h>


/* Support for throwing Java exceptions */
typedef enum {
  SWIG_JavaOutOfMemoryError = 1, 
  SWIG_JavaIOException, 
  SWIG_JavaRuntimeException, 
  SWIG_JavaIndexOutOfBoundsException,
  SWIG_JavaArithmeticException,
  SWIG_JavaIllegalArgumentException,
  SWIG_JavaNullPointerException,
  SWIG_JavaDirectorPureVirtual,
  SWIG_JavaUnknownError
} SWIG_JavaExceptionCodes;

typedef struct {
  SWIG_JavaExceptionCodes code;
  const char *java_exception;
} SWIG_JavaExceptions_t;


static void SWIGUNUSED SWIG_JavaThrowException(JNIEnv *jenv, SWIG_JavaExceptionCodes code, const char *msg) {
  jclass excep;
  static const SWIG_JavaExceptions_t java_exceptions[] = {
    { SWIG_JavaOutOfMemoryError, "java/lang/OutOfMemoryError" },
    { SWIG_JavaIOException, "java/io/IOException" },
    { SWIG_JavaRuntimeException, "java/lang/RuntimeException" },
    { SWIG_JavaIndexOutOfBoundsException, "java/lang/IndexOutOfBoundsException" },
    { SWIG_JavaArithmeticException, "java/lang/ArithmeticException" },
    { SWIG_JavaIllegalArgumentException, "java/lang/IllegalArgumentException" },
    { SWIG_JavaNullPointerException, "java/lang/NullPointerException" },
    { SWIG_JavaDirectorPureVirtual, "java/lang/RuntimeException" },
    { SWIG_JavaUnknownError,  "java/lang/UnknownError" },
    { (SWIG_JavaExceptionCodes)0,  "java/lang/UnknownError" } };
  const SWIG_JavaExceptions_t *except_ptr = java_exceptions;

  while (except_ptr->code != code && except_ptr->code)
    except_ptr++;

  jenv->ExceptionClear();
  excep = jenv->FindClass(except_ptr->java_exception);
  if (excep)
    jenv->ThrowNew(excep, msg);
}


/* Contract support */

#define SWIG_contract_assert(nullreturn, expr, msg) if (!(expr)) {SWIG_JavaThrowException(jenv, SWIG_JavaIllegalArgumentException, msg); return nullreturn; } else

/*  Errors in SWIG */
#define  SWIG_UnknownError    	   -1 
#define  SWIG_IOError        	   -2 
#define  SWIG_RuntimeError   	   -3 
#define  SWIG_IndexError     	   -4 
#define  SWIG_TypeError      	   -5 
#define  SWIG_DivisionByZero 	   -6 
#define  SWIG_OverflowError  	   -7 
#define  SWIG_SyntaxError    	   -8 
#define  SWIG_ValueError     	   -9 
#define  SWIG_SystemError    	   -10
#define  SWIG_AttributeError 	   -11
#define  SWIG_MemoryError    	   -12 
#define  SWIG_NullReferenceError   -13



/* -----------------------------------------------------------------------------
 * See the LICENSE file for information on copyright, usage and redistribution
 * of SWIG, and the README file for authors - http://www.swig.org/release.html.
 *
 * director.swg
 *
 * This file contains support for director classes that proxy
 * method calls from C++ to Java extensions.
 * ----------------------------------------------------------------------------- */

#ifdef __cplusplus

#if defined(DEBUG_DIRECTOR_OWNED)
#include <iostream>
#endif

namespace Swig {
  /* Java object wrapper */
  class JObjectWrapper {
  public:
    JObjectWrapper() : jthis_(NULL), weak_global_(true) {
    }

    ~JObjectWrapper() {
      jthis_ = NULL;
      weak_global_ = true;
    }

    bool set(JNIEnv *jenv, jobject jobj, bool mem_own, bool weak_global) {
      if (!jthis_) {
        weak_global_ = weak_global;
        if (jobj)
          jthis_ = ((weak_global_ || !mem_own) ? jenv->NewWeakGlobalRef(jobj) : jenv->NewGlobalRef(jobj));
#if defined(DEBUG_DIRECTOR_OWNED)
        std::cout << "JObjectWrapper::set(" << jobj << ", " << (weak_global ? "weak_global" : "global_ref") << ") -> " << jthis_ << std::endl;
#endif
        return true;
      } else {
#if defined(DEBUG_DIRECTOR_OWNED)
        std::cout << "JObjectWrapper::set(" << jobj << ", " << (weak_global ? "weak_global" : "global_ref") << ") -> already set" << std::endl;
#endif
        return false;
      }
    }

    jobject get(JNIEnv *jenv) const {
#if defined(DEBUG_DIRECTOR_OWNED)
      std::cout << "JObjectWrapper::get(";
      if (jthis_)
        std::cout << jthis_;
      else
        std::cout << "null";
      std::cout << ") -> return new local ref" << std::endl;
#endif
      return (jthis_ ? jenv->NewLocalRef(jthis_) : jthis_);
    }

    void release(JNIEnv *jenv) {
#if defined(DEBUG_DIRECTOR_OWNED)
      std::cout << "JObjectWrapper::release(" << jthis_ << "): " << (weak_global_ ? "weak global ref" : "global ref") << std::endl;
#endif
      if (jthis_) {
        if (weak_global_) {
          if (jenv->IsSameObject(jthis_, NULL) == JNI_FALSE)
            jenv->DeleteWeakGlobalRef((jweak)jthis_);
        } else
          jenv->DeleteGlobalRef(jthis_);
      }

      jthis_ = NULL;
      weak_global_ = true;
    }

    jobject peek() {
      return jthis_;
    }

    /* Java proxy releases ownership of C++ object, C++ object is now
       responsible for destruction (creates NewGlobalRef to pin Java
       proxy) */
    void java_change_ownership(JNIEnv *jenv, jobject jself, bool take_or_release) {
      if (take_or_release) {  /* Java takes ownership of C++ object's lifetime. */
        if (!weak_global_) {
          jenv->DeleteGlobalRef(jthis_);
          jthis_ = jenv->NewWeakGlobalRef(jself);
          weak_global_ = true;
        }
      } else { /* Java releases ownership of C++ object's lifetime */
        if (weak_global_) {
          jenv->DeleteWeakGlobalRef((jweak)jthis_);
          jthis_ = jenv->NewGlobalRef(jself);
          weak_global_ = false;
        }
      }
    }

  private:
    /* pointer to Java object */
    jobject jthis_;
    /* Local or global reference flag */
    bool weak_global_;
  };

  /* director base class */
  class Director {
    /* pointer to Java virtual machine */
    JavaVM *swig_jvm_;

  protected:
#if defined (_MSC_VER) && (_MSC_VER<1300)
    class JNIEnvWrapper;
    friend class JNIEnvWrapper;
#endif
    /* Utility class for managing the JNI environment */
    class JNIEnvWrapper {
      const Director *director_;
      JNIEnv *jenv_;
    public:
      JNIEnvWrapper(const Director *director) : director_(director), jenv_(0) {
#if defined(SWIG_JAVA_ATTACH_CURRENT_THREAD_AS_DAEMON)
        // Attach a daemon thread to the JVM. Useful when the JVM should not wait for 
        // the thread to exit upon shutdown. Only for jdk-1.4 and later.
        director_->swig_jvm_->AttachCurrentThreadAsDaemon((void **) &jenv_, NULL);
#else
        director_->swig_jvm_->AttachCurrentThread((void **) &jenv_, NULL);
#endif
      }
      ~JNIEnvWrapper() {
#if !defined(SWIG_JAVA_NO_DETACH_CURRENT_THREAD)
        // Some JVMs, eg jdk-1.4.2 and lower on Solaris have a bug and crash with the DetachCurrentThread call.
        // However, without this call, the JVM hangs on exit when the thread was not created by the JVM and creates a memory leak.
        director_->swig_jvm_->DetachCurrentThread();
#endif
      }
      JNIEnv *getJNIEnv() const {
        return jenv_;
      }
    };

    /* Java object wrapper */
    JObjectWrapper swig_self_;

    /* Disconnect director from Java object */
    void swig_disconnect_director_self(const char *disconn_method) {
      JNIEnvWrapper jnienv(this) ;
      JNIEnv *jenv = jnienv.getJNIEnv() ;
      jobject jobj = swig_self_.peek();
#if defined(DEBUG_DIRECTOR_OWNED)
      std::cout << "Swig::Director::disconnect_director_self(" << jobj << ")" << std::endl;
#endif
      if (jobj && jenv->IsSameObject(jobj, NULL) == JNI_FALSE) {
        jmethodID disconn_meth = jenv->GetMethodID(jenv->GetObjectClass(jobj), disconn_method, "()V");
        if (disconn_meth) {
#if defined(DEBUG_DIRECTOR_OWNED)
          std::cout << "Swig::Director::disconnect_director_self upcall to " << disconn_method << std::endl;
#endif
          jenv->CallVoidMethod(jobj, disconn_meth);
        }
      }
    }

  public:
    Director(JNIEnv *jenv) : swig_jvm_((JavaVM *) NULL), swig_self_() {
      /* Acquire the Java VM pointer */
      jenv->GetJavaVM(&swig_jvm_);
    }

    virtual ~Director() {
      JNIEnvWrapper jnienv(this) ;
      JNIEnv *jenv = jnienv.getJNIEnv() ;
      swig_self_.release(jenv);
    }

    bool swig_set_self(JNIEnv *jenv, jobject jself, bool mem_own, bool weak_global) {
      return swig_self_.set(jenv, jself, mem_own, weak_global);
    }

    jobject swig_get_self(JNIEnv *jenv) const {
      return swig_self_.get(jenv);
    }

    // Change C++ object's ownership, relative to Java
    void swig_java_change_ownership(JNIEnv *jenv, jobject jself, bool take_or_release) {
      swig_self_.java_change_ownership(jenv, jself, take_or_release);
    }
  };
}

#endif /* __cplusplus */


namespace Swig {
  static jclass jclass_dbxml_javaJNI = NULL;
  static jmethodID director_methids[18];
}

SWIGINTERN void SWIG_JavaException(JNIEnv *jenv, int code, const char *msg) {
  SWIG_JavaExceptionCodes exception_code = SWIG_JavaUnknownError;
  switch(code) {
  case SWIG_MemoryError:
    exception_code = SWIG_JavaOutOfMemoryError;
    break;
  case SWIG_IOError:
    exception_code = SWIG_JavaIOException;
    break;
  case SWIG_SystemError:
  case SWIG_RuntimeError:
    exception_code = SWIG_JavaRuntimeException;
    break;
  case SWIG_OverflowError:
  case SWIG_IndexError:
    exception_code = SWIG_JavaIndexOutOfBoundsException;
    break;
  case SWIG_DivisionByZero:
    exception_code = SWIG_JavaArithmeticException;
    break;
  case SWIG_SyntaxError:
  case SWIG_ValueError:
  case SWIG_TypeError:
    exception_code = SWIG_JavaIllegalArgumentException;
    break;
  case SWIG_UnknownError:
  default:
    exception_code = SWIG_JavaUnknownError;
    break;
  }
  SWIG_JavaThrowException(jenv, exception_code, msg);
}


#include <stdexcept>


#include "db.h"
#include "dbxml/DbXml.hpp"
#include <errno.h>
#include <fstream>

/* compat w/pre-4.4 */
#ifndef DB_READ_COMMITTED
#define DB_READ_COMMITTED DB_DEGREE_2
#define DB_READ_UNCOMMITTED DB_DIRTY_READ
#endif

/* If these are not defined, there are no equivalents; just make things compile */
#ifndef DB_TXN_SNAPSHOT
#define DB_TXN_SNAPSHOT -1
#define DB_MULTIVERSION -1
#endif


#include <string>


#include "../dbxml/Value.hpp"
#include "../dbxml/RawNodeValue.hpp"
#include "../dbxml/Results.hpp"
#include "../dbxml/Document.hpp"
#include "../dbxml/ScopedDbt.hpp"

using namespace DbXml;

jthrowable createException(JNIEnv *jenv, const std::exception *se);
XmlDocument createCPPXmlDocument(JNIEnv *jenv, jobject jdoc, bool setData = true);
jobject createJavaXmlDocument(JNIEnv *jenv, XmlDocument &cdoc);


#if defined(SWIG_NOINCLUDE) || defined(SWIG_NOARRAYS)


int SWIG_JavaArrayInBool (JNIEnv *jenv, jboolean **jarr, bool **carr, jbooleanArray input);
void SWIG_JavaArrayArgoutBool (JNIEnv *jenv, jboolean *jarr, bool *carr, jbooleanArray input);
jbooleanArray SWIG_JavaArrayOutBool (JNIEnv *jenv, bool *result, jsize sz);


int SWIG_JavaArrayInSchar (JNIEnv *jenv, jbyte **jarr, signed char **carr, jbyteArray input);
void SWIG_JavaArrayArgoutSchar (JNIEnv *jenv, jbyte *jarr, signed char *carr, jbyteArray input);
jbyteArray SWIG_JavaArrayOutSchar (JNIEnv *jenv, signed char *result, jsize sz);


int SWIG_JavaArrayInUchar (JNIEnv *jenv, jshort **jarr, unsigned char **carr, jshortArray input);
void SWIG_JavaArrayArgoutUchar (JNIEnv *jenv, jshort *jarr, unsigned char *carr, jshortArray input);
jshortArray SWIG_JavaArrayOutUchar (JNIEnv *jenv, unsigned char *result, jsize sz);


int SWIG_JavaArrayInShort (JNIEnv *jenv, jshort **jarr, short **carr, jshortArray input);
void SWIG_JavaArrayArgoutShort (JNIEnv *jenv, jshort *jarr, short *carr, jshortArray input);
jshortArray SWIG_JavaArrayOutShort (JNIEnv *jenv, short *result, jsize sz);


int SWIG_JavaArrayInUshort (JNIEnv *jenv, jint **jarr, unsigned short **carr, jintArray input);
void SWIG_JavaArrayArgoutUshort (JNIEnv *jenv, jint *jarr, unsigned short *carr, jintArray input);
jintArray SWIG_JavaArrayOutUshort (JNIEnv *jenv, unsigned short *result, jsize sz);


int SWIG_JavaArrayInInt (JNIEnv *jenv, jint **jarr, int **carr, jintArray input);
void SWIG_JavaArrayArgoutInt (JNIEnv *jenv, jint *jarr, int *carr, jintArray input);
jintArray SWIG_JavaArrayOutInt (JNIEnv *jenv, int *result, jsize sz);


int SWIG_JavaArrayInUint (JNIEnv *jenv, jlong **jarr, unsigned int **carr, jlongArray input);
void SWIG_JavaArrayArgoutUint (JNIEnv *jenv, jlong *jarr, unsigned int *carr, jlongArray input);
jlongArray SWIG_JavaArrayOutUint (JNIEnv *jenv, unsigned int *result, jsize sz);


int SWIG_JavaArrayInLong (JNIEnv *jenv, jint **jarr, long **carr, jintArray input);
void SWIG_JavaArrayArgoutLong (JNIEnv *jenv, jint *jarr, long *carr, jintArray input);
jintArray SWIG_JavaArrayOutLong (JNIEnv *jenv, long *result, jsize sz);


int SWIG_JavaArrayInUlong (JNIEnv *jenv, jlong **jarr, unsigned long **carr, jlongArray input);
void SWIG_JavaArrayArgoutUlong (JNIEnv *jenv, jlong *jarr, unsigned long *carr, jlongArray input);
jlongArray SWIG_JavaArrayOutUlong (JNIEnv *jenv, unsigned long *result, jsize sz);


int SWIG_JavaArrayInLonglong (JNIEnv *jenv, jlong **jarr, jlong **carr, jlongArray input);
void SWIG_JavaArrayArgoutLonglong (JNIEnv *jenv, jlong *jarr, jlong *carr, jlongArray input);
jlongArray SWIG_JavaArrayOutLonglong (JNIEnv *jenv, jlong *result, jsize sz);


int SWIG_JavaArrayInFloat (JNIEnv *jenv, jfloat **jarr, float **carr, jfloatArray input);
void SWIG_JavaArrayArgoutFloat (JNIEnv *jenv, jfloat *jarr, float *carr, jfloatArray input);
jfloatArray SWIG_JavaArrayOutFloat (JNIEnv *jenv, float *result, jsize sz);


int SWIG_JavaArrayInDouble (JNIEnv *jenv, jdouble **jarr, double **carr, jdoubleArray input);
void SWIG_JavaArrayArgoutDouble (JNIEnv *jenv, jdouble *jarr, double *carr, jdoubleArray input);
jdoubleArray SWIG_JavaArrayOutDouble (JNIEnv *jenv, double *result, jsize sz);


#else


/* bool[] support */
int SWIG_JavaArrayInBool (JNIEnv *jenv, jboolean **jarr, bool **carr, jbooleanArray input) {
  int i;
  jsize sz;
  if (!input) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null array");
    return 0;
  }
  sz = jenv->GetArrayLength(input);
  *jarr = jenv->GetBooleanArrayElements(input, 0);
  if (!*jarr)
    return 0; 
  *carr = new bool[sz]; 
  if (!*carr) {
    SWIG_JavaThrowException(jenv, SWIG_JavaOutOfMemoryError, "array memory allocation failed");
    return 0;
  }
  for (i=0; i<sz; i++)
    (*carr)[i] = ((*jarr)[i] != 0);
  return 1;
}

void SWIG_JavaArrayArgoutBool (JNIEnv *jenv, jboolean *jarr, bool *carr, jbooleanArray input) {
  int i;
  jsize sz = jenv->GetArrayLength(input);
  for (i=0; i<sz; i++)
    jarr[i] = (jboolean)carr[i];
  jenv->ReleaseBooleanArrayElements(input, jarr, 0);
}

jbooleanArray SWIG_JavaArrayOutBool (JNIEnv *jenv, bool *result, jsize sz) {
  jboolean *arr;
  int i;
  jbooleanArray jresult = jenv->NewBooleanArray(sz);
  if (!jresult)
    return NULL;
  arr = jenv->GetBooleanArrayElements(jresult, 0);
  if (!arr)
    return NULL;
  for (i=0; i<sz; i++)
    arr[i] = (jboolean)result[i];
  jenv->ReleaseBooleanArrayElements(jresult, arr, 0);
  return jresult;
}


/* signed char[] support */
int SWIG_JavaArrayInSchar (JNIEnv *jenv, jbyte **jarr, signed char **carr, jbyteArray input) {
  int i;
  jsize sz;
  if (!input) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null array");
    return 0;
  }
  sz = jenv->GetArrayLength(input);
  *jarr = jenv->GetByteArrayElements(input, 0);
  if (!*jarr)
    return 0; 
  *carr = new signed char[sz]; 
  if (!*carr) {
    SWIG_JavaThrowException(jenv, SWIG_JavaOutOfMemoryError, "array memory allocation failed");
    return 0;
  }
  for (i=0; i<sz; i++)
    (*carr)[i] = (signed char)(*jarr)[i];
  return 1;
}

void SWIG_JavaArrayArgoutSchar (JNIEnv *jenv, jbyte *jarr, signed char *carr, jbyteArray input) {
  int i;
  jsize sz = jenv->GetArrayLength(input);
  for (i=0; i<sz; i++)
    jarr[i] = (jbyte)carr[i];
  jenv->ReleaseByteArrayElements(input, jarr, 0);
}

jbyteArray SWIG_JavaArrayOutSchar (JNIEnv *jenv, signed char *result, jsize sz) {
  jbyte *arr;
  int i;
  jbyteArray jresult = jenv->NewByteArray(sz);
  if (!jresult)
    return NULL;
  arr = jenv->GetByteArrayElements(jresult, 0);
  if (!arr)
    return NULL;
  for (i=0; i<sz; i++)
    arr[i] = (jbyte)result[i];
  jenv->ReleaseByteArrayElements(jresult, arr, 0);
  return jresult;
}


/* unsigned char[] support */
int SWIG_JavaArrayInUchar (JNIEnv *jenv, jshort **jarr, unsigned char **carr, jshortArray input) {
  int i;
  jsize sz;
  if (!input) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null array");
    return 0;
  }
  sz = jenv->GetArrayLength(input);
  *jarr = jenv->GetShortArrayElements(input, 0);
  if (!*jarr)
    return 0; 
  *carr = new unsigned char[sz]; 
  if (!*carr) {
    SWIG_JavaThrowException(jenv, SWIG_JavaOutOfMemoryError, "array memory allocation failed");
    return 0;
  }
  for (i=0; i<sz; i++)
    (*carr)[i] = (unsigned char)(*jarr)[i];
  return 1;
}

void SWIG_JavaArrayArgoutUchar (JNIEnv *jenv, jshort *jarr, unsigned char *carr, jshortArray input) {
  int i;
  jsize sz = jenv->GetArrayLength(input);
  for (i=0; i<sz; i++)
    jarr[i] = (jshort)carr[i];
  jenv->ReleaseShortArrayElements(input, jarr, 0);
}

jshortArray SWIG_JavaArrayOutUchar (JNIEnv *jenv, unsigned char *result, jsize sz) {
  jshort *arr;
  int i;
  jshortArray jresult = jenv->NewShortArray(sz);
  if (!jresult)
    return NULL;
  arr = jenv->GetShortArrayElements(jresult, 0);
  if (!arr)
    return NULL;
  for (i=0; i<sz; i++)
    arr[i] = (jshort)result[i];
  jenv->ReleaseShortArrayElements(jresult, arr, 0);
  return jresult;
}


/* short[] support */
int SWIG_JavaArrayInShort (JNIEnv *jenv, jshort **jarr, short **carr, jshortArray input) {
  int i;
  jsize sz;
  if (!input) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null array");
    return 0;
  }
  sz = jenv->GetArrayLength(input);
  *jarr = jenv->GetShortArrayElements(input, 0);
  if (!*jarr)
    return 0; 
  *carr = new short[sz]; 
  if (!*carr) {
    SWIG_JavaThrowException(jenv, SWIG_JavaOutOfMemoryError, "array memory allocation failed");
    return 0;
  }
  for (i=0; i<sz; i++)
    (*carr)[i] = (short)(*jarr)[i];
  return 1;
}

void SWIG_JavaArrayArgoutShort (JNIEnv *jenv, jshort *jarr, short *carr, jshortArray input) {
  int i;
  jsize sz = jenv->GetArrayLength(input);
  for (i=0; i<sz; i++)
    jarr[i] = (jshort)carr[i];
  jenv->ReleaseShortArrayElements(input, jarr, 0);
}

jshortArray SWIG_JavaArrayOutShort (JNIEnv *jenv, short *result, jsize sz) {
  jshort *arr;
  int i;
  jshortArray jresult = jenv->NewShortArray(sz);
  if (!jresult)
    return NULL;
  arr = jenv->GetShortArrayElements(jresult, 0);
  if (!arr)
    return NULL;
  for (i=0; i<sz; i++)
    arr[i] = (jshort)result[i];
  jenv->ReleaseShortArrayElements(jresult, arr, 0);
  return jresult;
}


/* unsigned short[] support */
int SWIG_JavaArrayInUshort (JNIEnv *jenv, jint **jarr, unsigned short **carr, jintArray input) {
  int i;
  jsize sz;
  if (!input) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null array");
    return 0;
  }
  sz = jenv->GetArrayLength(input);
  *jarr = jenv->GetIntArrayElements(input, 0);
  if (!*jarr)
    return 0; 
  *carr = new unsigned short[sz]; 
  if (!*carr) {
    SWIG_JavaThrowException(jenv, SWIG_JavaOutOfMemoryError, "array memory allocation failed");
    return 0;
  }
  for (i=0; i<sz; i++)
    (*carr)[i] = (unsigned short)(*jarr)[i];
  return 1;
}

void SWIG_JavaArrayArgoutUshort (JNIEnv *jenv, jint *jarr, unsigned short *carr, jintArray input) {
  int i;
  jsize sz = jenv->GetArrayLength(input);
  for (i=0; i<sz; i++)
    jarr[i] = (jint)carr[i];
  jenv->ReleaseIntArrayElements(input, jarr, 0);
}

jintArray SWIG_JavaArrayOutUshort (JNIEnv *jenv, unsigned short *result, jsize sz) {
  jint *arr;
  int i;
  jintArray jresult = jenv->NewIntArray(sz);
  if (!jresult)
    return NULL;
  arr = jenv->GetIntArrayElements(jresult, 0);
  if (!arr)
    return NULL;
  for (i=0; i<sz; i++)
    arr[i] = (jint)result[i];
  jenv->ReleaseIntArrayElements(jresult, arr, 0);
  return jresult;
}


/* int[] support */
int SWIG_JavaArrayInInt (JNIEnv *jenv, jint **jarr, int **carr, jintArray input) {
  int i;
  jsize sz;
  if (!input) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null array");
    return 0;
  }
  sz = jenv->GetArrayLength(input);
  *jarr = jenv->GetIntArrayElements(input, 0);
  if (!*jarr)
    return 0; 
  *carr = new int[sz]; 
  if (!*carr) {
    SWIG_JavaThrowException(jenv, SWIG_JavaOutOfMemoryError, "array memory allocation failed");
    return 0;
  }
  for (i=0; i<sz; i++)
    (*carr)[i] = (int)(*jarr)[i];
  return 1;
}

void SWIG_JavaArrayArgoutInt (JNIEnv *jenv, jint *jarr, int *carr, jintArray input) {
  int i;
  jsize sz = jenv->GetArrayLength(input);
  for (i=0; i<sz; i++)
    jarr[i] = (jint)carr[i];
  jenv->ReleaseIntArrayElements(input, jarr, 0);
}

jintArray SWIG_JavaArrayOutInt (JNIEnv *jenv, int *result, jsize sz) {
  jint *arr;
  int i;
  jintArray jresult = jenv->NewIntArray(sz);
  if (!jresult)
    return NULL;
  arr = jenv->GetIntArrayElements(jresult, 0);
  if (!arr)
    return NULL;
  for (i=0; i<sz; i++)
    arr[i] = (jint)result[i];
  jenv->ReleaseIntArrayElements(jresult, arr, 0);
  return jresult;
}


/* unsigned int[] support */
int SWIG_JavaArrayInUint (JNIEnv *jenv, jlong **jarr, unsigned int **carr, jlongArray input) {
  int i;
  jsize sz;
  if (!input) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null array");
    return 0;
  }
  sz = jenv->GetArrayLength(input);
  *jarr = jenv->GetLongArrayElements(input, 0);
  if (!*jarr)
    return 0; 
  *carr = new unsigned int[sz]; 
  if (!*carr) {
    SWIG_JavaThrowException(jenv, SWIG_JavaOutOfMemoryError, "array memory allocation failed");
    return 0;
  }
  for (i=0; i<sz; i++)
    (*carr)[i] = (unsigned int)(*jarr)[i];
  return 1;
}

void SWIG_JavaArrayArgoutUint (JNIEnv *jenv, jlong *jarr, unsigned int *carr, jlongArray input) {
  int i;
  jsize sz = jenv->GetArrayLength(input);
  for (i=0; i<sz; i++)
    jarr[i] = (jlong)carr[i];
  jenv->ReleaseLongArrayElements(input, jarr, 0);
}

jlongArray SWIG_JavaArrayOutUint (JNIEnv *jenv, unsigned int *result, jsize sz) {
  jlong *arr;
  int i;
  jlongArray jresult = jenv->NewLongArray(sz);
  if (!jresult)
    return NULL;
  arr = jenv->GetLongArrayElements(jresult, 0);
  if (!arr)
    return NULL;
  for (i=0; i<sz; i++)
    arr[i] = (jlong)result[i];
  jenv->ReleaseLongArrayElements(jresult, arr, 0);
  return jresult;
}


/* long[] support */
int SWIG_JavaArrayInLong (JNIEnv *jenv, jint **jarr, long **carr, jintArray input) {
  int i;
  jsize sz;
  if (!input) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null array");
    return 0;
  }
  sz = jenv->GetArrayLength(input);
  *jarr = jenv->GetIntArrayElements(input, 0);
  if (!*jarr)
    return 0; 
  *carr = new long[sz]; 
  if (!*carr) {
    SWIG_JavaThrowException(jenv, SWIG_JavaOutOfMemoryError, "array memory allocation failed");
    return 0;
  }
  for (i=0; i<sz; i++)
    (*carr)[i] = (long)(*jarr)[i];
  return 1;
}

void SWIG_JavaArrayArgoutLong (JNIEnv *jenv, jint *jarr, long *carr, jintArray input) {
  int i;
  jsize sz = jenv->GetArrayLength(input);
  for (i=0; i<sz; i++)
    jarr[i] = (jint)carr[i];
  jenv->ReleaseIntArrayElements(input, jarr, 0);
}

jintArray SWIG_JavaArrayOutLong (JNIEnv *jenv, long *result, jsize sz) {
  jint *arr;
  int i;
  jintArray jresult = jenv->NewIntArray(sz);
  if (!jresult)
    return NULL;
  arr = jenv->GetIntArrayElements(jresult, 0);
  if (!arr)
    return NULL;
  for (i=0; i<sz; i++)
    arr[i] = (jint)result[i];
  jenv->ReleaseIntArrayElements(jresult, arr, 0);
  return jresult;
}


/* unsigned long[] support */
int SWIG_JavaArrayInUlong (JNIEnv *jenv, jlong **jarr, unsigned long **carr, jlongArray input) {
  int i;
  jsize sz;
  if (!input) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null array");
    return 0;
  }
  sz = jenv->GetArrayLength(input);
  *jarr = jenv->GetLongArrayElements(input, 0);
  if (!*jarr)
    return 0; 
  *carr = new unsigned long[sz]; 
  if (!*carr) {
    SWIG_JavaThrowException(jenv, SWIG_JavaOutOfMemoryError, "array memory allocation failed");
    return 0;
  }
  for (i=0; i<sz; i++)
    (*carr)[i] = (unsigned long)(*jarr)[i];
  return 1;
}

void SWIG_JavaArrayArgoutUlong (JNIEnv *jenv, jlong *jarr, unsigned long *carr, jlongArray input) {
  int i;
  jsize sz = jenv->GetArrayLength(input);
  for (i=0; i<sz; i++)
    jarr[i] = (jlong)carr[i];
  jenv->ReleaseLongArrayElements(input, jarr, 0);
}

jlongArray SWIG_JavaArrayOutUlong (JNIEnv *jenv, unsigned long *result, jsize sz) {
  jlong *arr;
  int i;
  jlongArray jresult = jenv->NewLongArray(sz);
  if (!jresult)
    return NULL;
  arr = jenv->GetLongArrayElements(jresult, 0);
  if (!arr)
    return NULL;
  for (i=0; i<sz; i++)
    arr[i] = (jlong)result[i];
  jenv->ReleaseLongArrayElements(jresult, arr, 0);
  return jresult;
}


/* jlong[] support */
int SWIG_JavaArrayInLonglong (JNIEnv *jenv, jlong **jarr, jlong **carr, jlongArray input) {
  int i;
  jsize sz;
  if (!input) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null array");
    return 0;
  }
  sz = jenv->GetArrayLength(input);
  *jarr = jenv->GetLongArrayElements(input, 0);
  if (!*jarr)
    return 0; 
  *carr = new jlong[sz]; 
  if (!*carr) {
    SWIG_JavaThrowException(jenv, SWIG_JavaOutOfMemoryError, "array memory allocation failed");
    return 0;
  }
  for (i=0; i<sz; i++)
    (*carr)[i] = (jlong)(*jarr)[i];
  return 1;
}

void SWIG_JavaArrayArgoutLonglong (JNIEnv *jenv, jlong *jarr, jlong *carr, jlongArray input) {
  int i;
  jsize sz = jenv->GetArrayLength(input);
  for (i=0; i<sz; i++)
    jarr[i] = (jlong)carr[i];
  jenv->ReleaseLongArrayElements(input, jarr, 0);
}

jlongArray SWIG_JavaArrayOutLonglong (JNIEnv *jenv, jlong *result, jsize sz) {
  jlong *arr;
  int i;
  jlongArray jresult = jenv->NewLongArray(sz);
  if (!jresult)
    return NULL;
  arr = jenv->GetLongArrayElements(jresult, 0);
  if (!arr)
    return NULL;
  for (i=0; i<sz; i++)
    arr[i] = (jlong)result[i];
  jenv->ReleaseLongArrayElements(jresult, arr, 0);
  return jresult;
}


/* float[] support */
int SWIG_JavaArrayInFloat (JNIEnv *jenv, jfloat **jarr, float **carr, jfloatArray input) {
  int i;
  jsize sz;
  if (!input) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null array");
    return 0;
  }
  sz = jenv->GetArrayLength(input);
  *jarr = jenv->GetFloatArrayElements(input, 0);
  if (!*jarr)
    return 0; 
  *carr = new float[sz]; 
  if (!*carr) {
    SWIG_JavaThrowException(jenv, SWIG_JavaOutOfMemoryError, "array memory allocation failed");
    return 0;
  }
  for (i=0; i<sz; i++)
    (*carr)[i] = (float)(*jarr)[i];
  return 1;
}

void SWIG_JavaArrayArgoutFloat (JNIEnv *jenv, jfloat *jarr, float *carr, jfloatArray input) {
  int i;
  jsize sz = jenv->GetArrayLength(input);
  for (i=0; i<sz; i++)
    jarr[i] = (jfloat)carr[i];
  jenv->ReleaseFloatArrayElements(input, jarr, 0);
}

jfloatArray SWIG_JavaArrayOutFloat (JNIEnv *jenv, float *result, jsize sz) {
  jfloat *arr;
  int i;
  jfloatArray jresult = jenv->NewFloatArray(sz);
  if (!jresult)
    return NULL;
  arr = jenv->GetFloatArrayElements(jresult, 0);
  if (!arr)
    return NULL;
  for (i=0; i<sz; i++)
    arr[i] = (jfloat)result[i];
  jenv->ReleaseFloatArrayElements(jresult, arr, 0);
  return jresult;
}


/* double[] support */
int SWIG_JavaArrayInDouble (JNIEnv *jenv, jdouble **jarr, double **carr, jdoubleArray input) {
  int i;
  jsize sz;
  if (!input) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null array");
    return 0;
  }
  sz = jenv->GetArrayLength(input);
  *jarr = jenv->GetDoubleArrayElements(input, 0);
  if (!*jarr)
    return 0; 
  *carr = new double[sz]; 
  if (!*carr) {
    SWIG_JavaThrowException(jenv, SWIG_JavaOutOfMemoryError, "array memory allocation failed");
    return 0;
  }
  for (i=0; i<sz; i++)
    (*carr)[i] = (double)(*jarr)[i];
  return 1;
}

void SWIG_JavaArrayArgoutDouble (JNIEnv *jenv, jdouble *jarr, double *carr, jdoubleArray input) {
  int i;
  jsize sz = jenv->GetArrayLength(input);
  for (i=0; i<sz; i++)
    jarr[i] = (jdouble)carr[i];
  jenv->ReleaseDoubleArrayElements(input, jarr, 0);
}

jdoubleArray SWIG_JavaArrayOutDouble (JNIEnv *jenv, double *result, jsize sz) {
  jdouble *arr;
  int i;
  jdoubleArray jresult = jenv->NewDoubleArray(sz);
  if (!jresult)
    return NULL;
  arr = jenv->GetDoubleArrayElements(jresult, 0);
  if (!arr)
    return NULL;
  for (i=0; i<sz; i++)
    arr[i] = (jdouble)result[i];
  jenv->ReleaseDoubleArrayElements(jresult, arr, 0);
  return jresult;
}


#endif


    class JavaException {};

    class XmlInputStream_ReadBytes_InOutByteArray {
	public:
	    XmlInputStream_ReadBytes_InOutByteArray(JNIEnv *jenv, jbyteArray &jtoFill, char *toFill, unsigned int &result)
	    : jenv_(jenv), jtoFill_(jtoFill), toFill_(toFill), result_(result)
	{
	}
	~XmlInputStream_ReadBytes_InOutByteArray() {
	    if(jenv_->ExceptionOccurred()) {
		// This is caught in the exception handling routines
		throw JavaException();
	    } else {
		jenv_->GetByteArrayRegion(jtoFill_, (jsize)0, (jsize)result_, (jbyte*)toFill_);
	    }
	}
	private:
	    JNIEnv *jenv_;
	jbyteArray &jtoFill_;
	char *toFill_;
	unsigned int &result_;
    };
    

    /* don't use SWIG's array handling - save code space */
    #define SWIG_NOINCLUDE 1

	#if DB_VERSION_MAJOR > 4 || (DB_VERSION_MAJOR == 4 && DB_VERSION_MINOR >= 4)
				   #define DB_EXTRA_EXC 1
				   #endif

				   // XML classes
				   static jclass xml_indexdecl_class;
    static jclass xml_valuedecl_class;
    static jclass xml_docdecl_class;
    static jclass xmlex_class;
    static jclass np_class;
    // DB classes
    static jclass dbenv_class;
    static jclass dbtxn_class;
    // DB exception classes
    static jclass dbex_class, deadex_class, lockex_class, memex_class;
    static jclass runrecex_class, rephandledeadex_class;
    #ifdef DB_EXTRA_EXC
	// DB 4.4 TBD...
	static jclass repdupmasterex_class;
    static jclass repholdelectionex_class, repunavailex_class;
    static jclass versionex_class;
    #endif


	// fields
	jfieldID dbenv_private_fid;
    jfieldID dbtxn_private_fid;

    // method IDs
    static jmethodID xml_indexdecl_construct;
    static jmethodID xml_value_construct;
    static jmethodID xml_valuenull_construct;
    static jmethodID xml_doc_construct;
    static jmethodID xmlex_construct;
    // DB exception method ids
    static jmethodID dbex_construct, deadex_construct, lockex_construct;
    static jmethodID memex_construct;
    static jmethodID rephandledeadex_construct;
    static jmethodID runrecex_construct;
    #ifdef DB_EXTRA_EXC
	// DB 4.4. TBD
	static jmethodID repdupmasterex_construct, memex_update_method;
    static jmethodID repholdelectionex_construct, repunavailex_construct;
    static jmethodID versionex_construct;
    #endif

    #define DB_PKG "com/sleepycat/db/"
    #define DB_PKG_INT "com/sleepycat/db/internal/"
    #define XML_PKG "com/sleepycat/dbxml/"

    /* Forward declarations */
    static jthrowable __dbj_get_except(JNIEnv *jenv,
				       int err, const char *msg, jobject obj, jobject jdbenv);

    // all classes
    const struct {
	jclass *cl;
	const char *name;
    } all_classes[] = {
	// XML
	{ &xml_indexdecl_class, XML_PKG "XmlIndexDeclaration" },
	{ &xml_valuedecl_class, XML_PKG "XmlValue" },
	{ &xml_docdecl_class, XML_PKG "XmlDocument" },
	{ &xmlex_class, XML_PKG "XmlException" },
	// DB
	{ &dbenv_class, DB_PKG_INT "DbEnv" },
	{ &dbtxn_class, DB_PKG_INT "DbTxn" },
	{ &dbex_class, DB_PKG "DatabaseException" },
	{ &deadex_class, DB_PKG "DeadlockException" },
	{ &lockex_class, DB_PKG "LockNotGrantedException" },
	{ &memex_class, DB_PKG "MemoryException" },
	{ &rephandledeadex_class, DB_PKG "ReplicationHandleDeadException" },
	{ &runrecex_class, DB_PKG "RunRecoveryException" },
	#ifdef DB_EXTRA_EXC
	{ &repdupmasterex_class, DB_PKG "ReplicationDuplicateMasterException" },
	{ &repholdelectionex_class, DB_PKG "ReplicationHoldElectionException" },
	{ &repunavailex_class, DB_PKG "ReplicationSiteUnavailableException" },
	{ &versionex_class, DB_PKG "VersionMismatchException" },
	#endif
	// Misc
	{ &np_class, "java/lang/NullPointerException" }
    };

    const struct {
	jmethodID *mid;
	jclass *cl;
	const char *name;
	const char *sig;
    } all_methods[] = {
	// XML methods
	{ &xml_indexdecl_construct, &xml_indexdecl_class, "<init>",
	  "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;)V"  },
	{ &xml_value_construct, &xml_valuedecl_class, "<init>",
	  "(I[Ljava/lang/Object;)V"  },
	{ &xml_valuenull_construct, &xml_valuedecl_class, "<init>",
	  "()V"  },
	{ &xml_doc_construct, &xml_docdecl_class, "<init>",
	  "(JI[B)V"  },
	{ &xmlex_construct, &xmlex_class, "<init>",
	  "(ILjava/lang/String;L" DB_PKG "DatabaseException;III)V"  },
	// DB methods
	{ &dbex_construct, &dbex_class, "<init>",
	  "(Ljava/lang/String;I)V" },
	{ &deadex_construct, &deadex_class, "<init>",
	  "(Ljava/lang/String;IL" DB_PKG "internal/DbEnv;)V" },
	{ &lockex_construct, &lockex_class, "<init>",
	  "(Ljava/lang/String;IIL" DB_PKG "DatabaseEntry;L" DB_PKG "internal/DbLock;IL" DB_PKG "internal/DbEnv;)V" },
	{ &memex_construct, &memex_class, "<init>",
	  "(Ljava/lang/String;L" DB_PKG "DatabaseEntry;IL" DB_PKG "internal/DbEnv;)V" },
	{ &rephandledeadex_construct, &rephandledeadex_class, "<init>",
	  "(Ljava/lang/String;IL" DB_PKG "internal/DbEnv;)V" },
	{ &runrecex_construct, &runrecex_class, "<init>",
	  "(Ljava/lang/String;IL" DB_PKG "internal/DbEnv;)V" }
	#ifdef DB_EXTRA_EXC
	,{ &memex_update_method, &memex_class, "updateDatabaseEntry",
	   "(L" DB_PKG "DatabaseEntry;)V" },
	{ &repdupmasterex_construct, &repdupmasterex_class, "<init>",
	  "(Ljava/lang/String;IL" DB_PKG "internal/DbEnv;)V" },
	{ &repholdelectionex_construct, &repholdelectionex_class, "<init>",
	  "(Ljava/lang/String;IL" DB_PKG "internal/DbEnv;)V" },
	{ &repunavailex_construct, &repunavailex_class, "<init>",
	  "(Ljava/lang/String;IL" DB_PKG "internal/DbEnv;)V" },
	{ &versionex_construct, &versionex_class, "<init>",
	  "(Ljava/lang/String;IL" DB_PKG "internal/DbEnv;)V" }
	#endif
    };

    #define NELEM(x) (sizeof (x) / sizeof (x[0]))

	static bool checkDbVersion()
	{
	    int major, minor, patch, dmajor, dminor, dpatch;
	    (void) db_version(&major, &minor, &patch);
	    (void) DbXml::dbxml_db_version(&dmajor, &dminor, &dpatch);
	    // match major and minor numbers
	    // TBD: warn if patch level is different
	    if (major != dmajor || minor != dminor)
		return false;
	    return true;
	}

    extern "C"
	JNIEXPORT void JNICALL Java_com_sleepycat_dbxml_dbxml_1javaJNI_initialize
	(JNIEnv *jenv, jclass clazz)
	{
	    (void)clazz; /* unused */
	    jclass cl;
	    unsigned int i, j;

	    if (checkDbVersion() == false) {
		fprintf(stderr,
			"Mismatched Berkeley DB libraries");
		return;
	    }
	    // This initialization code comes from DB's java_util.i file
	    for (i = 0; i < NELEM(all_classes); i++) {
		cl = (jenv)->FindClass(all_classes[i].name);
		if (cl == NULL) {
		    fprintf(stderr,
			    "Failed to load class %s - check CLASSPATH\n",
			    all_classes[i].name);
		    return;
		}
		/*
		 * Wrap classes in GlobalRefs so we keep the reference between
		 * calls.
		 */
		*all_classes[i].cl = (jclass)(jenv)->NewGlobalRef(cl);

		if (*all_classes[i].cl == NULL) {
		    fprintf(stderr,
			    "Failed to create a global reference for %s\n",
			    all_classes[i].name);
		    return;
		}
	    }

	    // get some field ids
	    #if DB_VERSION_MAJOR < 4 || (DB_VERSION_MAJOR == 4 && DB_VERSION_MINOR <= 1)
				       dbenv_private_fid = jenv->GetFieldID(dbenv_class, "private_dbobj_", "J");
	    dbtxn_private_fid = jenv->GetFieldID(dbtxn_class, "private_dbobj_", "J");
	    #else
		dbenv_private_fid = jenv->GetFieldID(dbenv_class, "swigCPtr", "J");
	    dbtxn_private_fid = jenv->GetFieldID(dbtxn_class, "swigCPtr", "J");
	    #endif
		/* Get method IDs */
		for (i = 0; i < NELEM(all_methods); i++) {
		    *all_methods[i].mid = (jenv)->
			GetMethodID(*all_methods[i].cl, all_methods[i].name,
				    all_methods[i].sig);

		    if (*all_methods[i].mid == NULL) {
			for (j = 0; j < NELEM(all_classes); j++)
			    if (all_methods[i].cl == all_classes[j].cl)
				break;
			fprintf(stderr,
				"Failed to look up method %s.%s with sig %s\n",
				all_classes[j].name, all_methods[i].name,
				all_methods[i].sig);
			return;
		    }
		}
	}
	
    /* Union to convert longs to pointers (see {get,set}_private_dbobj). */
    typedef union {
	jlong java_long;
	void *ptr;
    } long_to_ptr;

    static DB_ENV *get_DB_ENV(JNIEnv *jenv, jobject jdbenv)
    {
	if (jdbenv == NULL)
	    return NULL;
	else {
	    #if DB_VERSION_MAJOR < 4 || (DB_VERSION_MAJOR == 4 && DB_VERSION_MINOR <= 1)
				       long_to_ptr lp;
	    lp.java_long = jenv->GetLongField(jdbenv, dbenv_private_fid);
	    return (DB_ENV *)lp.ptr;
	    #else
		jlong swigCPtr = jenv->GetLongField(jdbenv, dbenv_private_fid);
	    return *(DB_ENV **)&swigCPtr;
	    #endif
	}
    }

    static DB_TXN *get_DB_TXN(JNIEnv *jenv, jobject jtxn)
    {
	if (jtxn == NULL)
	    return NULL;
	else {
	    #if DB_VERSION_MAJOR < 4 || (DB_VERSION_MAJOR == 4 && DB_VERSION_MINOR <= 1)
				       long_to_ptr lp;
	    lp.java_long = jenv->GetLongField(jtxn, dbtxn_private_fid);
	    return (DB_TXN *)lp.ptr;
	    #else
		jlong swigCPtr = jenv->GetLongField(jtxn, dbtxn_private_fid);
	    return *(DB_TXN **)&swigCPtr;
	    #endif
	}
    }

    struct DBT_INFO {
	DBT dbt;
	jbyte *orig_data;
    };

    

// Deals with XmlException and std::exception 
jthrowable createException(JNIEnv *jenv, const std::exception *se)
{
    const XmlException *xe = dynamic_cast<const XmlException*>(se);
    if (xe) {
        // use 0 for dberr; otherwise, DatabaseException::toString
        // prints redundant information.  The DB error information
        // is already in the what() string.
	XmlException::ExceptionCode ecode = xe->getExceptionCode();
        if (ecode == XmlException::NULL_POINTER) {
	    // throw null pointer exception
	    jenv->ThrowNew(np_class, xe->what());
	    return NULL;
        } else {
	    jthrowable dt = 0;
	    const char *msg = xe->what();
	    int qLine = xe->getQueryLine();
	    int qCol = xe->getQueryColumn();
	    if (ecode == XmlException::DATABASE_ERROR) {
		dt = __dbj_get_except(jenv, xe->getDbErrno(),
				      msg, NULL, NULL);
	    }
	    return (jthrowable)jenv->
		NewObject(xmlex_class, xmlex_construct,
			  ecode, jenv->NewStringUTF(msg), dt, 0, qLine, qCol);
        }
    }
    std::string emsg = "std::exception thrown from C++ API: ";
    emsg += se->what();
    return (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
		XmlException::INTERNAL_ERROR,
		jenv->NewStringUTF(emsg.c_str()), 0, 0, 0, 0);
}


    //Creates a C++ XmlContainerConfig from the information in a Java XmlContainerConfig
    XmlContainerConfig createCPPXmlContainerConfig(JNIEnv *jenv, jintArray &configArray, jstring &jname)
    {
	    XmlContainerConfig cconfig;
	    jthrowable thr = NULL;
	    jint *info = 0;
	    const char *cname = 0;
	    
	    try {
			//get the mode, container type, xml flags, db flags, page size, and sequence increment
			info = jenv->GetIntArrayElements(configArray, 0);
			cconfig.setMode(info[0]);
			cconfig.setContainerType((XmlContainer::ContainerType)info[1]);
			(*cconfig).setXmlFlags(info[2]);
			(*cconfig).setDbOpenFlags(info[3]);
			cconfig.setPageSize(info[4]);
			cconfig.setSequenceIncrement(info[5]);
			(*cconfig).setDbSetFlags(info[6]);
			(*cconfig).setSeqFlags(info[7]);
			jenv->ReleaseIntArrayElements(configArray, info, JNI_ABORT);
			info = 0;
			
			//get the compression name
			cname = jenv->GetStringUTFChars(jname, (jboolean *)0);
			cconfig.setCompressionName(cname);
			jenv->ReleaseStringUTFChars(jname, cname);
			cname = 0;
		} catch (std::exception &se) {
			if (info) jenv->ReleaseIntArrayElements(configArray, info, JNI_ABORT);
			if (cname) jenv->ReleaseStringUTFChars(jname, cname);
		    thr = createException(jenv, &se);
	    }
	    catch(JavaException & /* je */) {
			if (info) jenv->ReleaseIntArrayElements(configArray, info, JNI_ABORT);
			if (cname) jenv->ReleaseStringUTFChars(jname, cname);
		    // This means there's already an exception waiting in the JVM
		    // Fall through
	    }
	    catch (...) {
			if (info) jenv->ReleaseIntArrayElements(configArray, info, JNI_ABORT);
			if (cname) jenv->ReleaseStringUTFChars(jname, cname);
		    thr = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
						      XmlException::INTERNAL_ERROR,
						      jenv->NewStringUTF("Uncaught exception from C++ API Constructing XmlDocument"), 0, 0, 0, 0);
	    }
	    if (thr)
		    jenv->Throw(thr);
		return cconfig;
	}
	
    

    static jthrowable __dbj_get_except(
				       JNIEnv *jenv,
				       int err, const char *msg, jobject obj, jobject jdbenv) {
	jobject jmsg;

	if (msg == NULL)
	    msg = db_strerror(err);

	jmsg = jenv->NewStringUTF(msg);

	switch (err) {
	    #if 0
		// don't map these (yet?)
	case EINVAL:
	    return (jthrowable)jenv->
		NewObject(
			  illegalargex_class, illegalargex_construct, jmsg);

	case ENOENT:
	    return (jthrowable)jenv->
		NewObject(filenotfoundex_class, filenotfoundex_construct, jmsg);

	case ENOMEM:
	    return (jthrowable)jenv->
		NewObject(outofmemerr_class, outofmemerr_construct, jmsg);
	    #endif
	case DB_BUFFER_SMALL:
	    return (jthrowable)jenv->
		NewObject(memex_class, memex_construct, jmsg, obj, err, jdbenv);

	case DB_REP_HANDLE_DEAD:
	    return (jthrowable)jenv->
		NewObject(rephandledeadex_class, rephandledeadex_construct,
			  jmsg, err, jdbenv);
	case DB_RUNRECOVERY:
	    return (jthrowable)jenv->
		NewObject(runrecex_class, runrecex_construct, jmsg, err, jdbenv);

	case DB_LOCK_DEADLOCK:
	    return (jthrowable)jenv->
		NewObject(deadex_class, deadex_construct, jmsg, err, jdbenv);

	case DB_LOCK_NOTGRANTED:
	    return (jthrowable)jenv->
		NewObject(lockex_class,lockex_construct,
			  jmsg, 0, 0, NULL, NULL, 0, jdbenv);

	    #ifdef DB_EXTRA_EXC
		// These are from DB 4.4, TBD...
	case DB_REP_DUPMASTER:
	    return (jthrowable)jenv->
		NewObject(repdupmasterex_class, repdupmasterex_construct,
			  jmsg, err, jdbenv);

	case DB_REP_HOLDELECTION:
	    return (jthrowable)jenv->
		NewObject(repholdelectionex_class, repholdelectionex_construct,
			  jmsg, err, jdbenv);

	case DB_REP_UNAVAIL:
	    return (jthrowable)jenv->
		NewObject(repunavailex_class, repunavailex_construct,
			  jmsg, err, jdbenv);

	case DB_VERSION_MISMATCH:
	    return (jthrowable)jenv->
		NewObject(versionex_class,
			  versionex_construct, jmsg, 0, 0, NULL, NULL, 0, jdbenv);
	    #endif //  DB 4.4
	default:
	    return (jthrowable)jenv->
		NewObject(dbex_class,
			  dbex_construct, jmsg, err, jdbenv);
	}
    }

    

//Translate a Java XmlValue to a C++ XmlValue when it is passed as an argument
//See XmlValue.java the function pack() to get the makeup of the object array
XmlValue createCPPXmlValue(JNIEnv *jenv, jobject jvalue, bool *valid = 0)
{
bool createdResults = false;
XmlResults xmlresult;
jlong resultPtr = 0;
jthrowable thr = NULL;
jbyte *bytes = 0;
jlong* state = 0;
jbyteArray value = 0;
jlongArray jstate = 0;
if(!jvalue) return XmlValue();
try {
	//Call pack() to get all the data of the value
	jclass cls = jenv->GetObjectClass(jvalue);
	jmethodID mid = jenv->GetMethodID(cls, "pack", "()[Ljava/lang/Object;");
	jobjectArray jdata = (jobjectArray)jenv->CallObjectMethod(jvalue, mid);
	if(!jdata) return XmlValue();
	
	//Get the type of the XmlValue
	jintArray jtypeArray = (jintArray)jenv->GetObjectArrayElement(jdata, 0);
	jint* jtype = jenv->GetIntArrayElements(jtypeArray, (jboolean *)0);
	int type = jtype[0];
	jenv->ReleaseIntArrayElements(jtypeArray, jtype, 0);
	if(type == XmlValue::NODE){
		/*If it is a node get the data held in the ID
		  and get the XmlResults object either from the
		  Java object or construct it */
		value = (jbyteArray)jenv->GetObjectArrayElement(jdata, 1);
		bytes = jenv->GetByteArrayElements(value, (jboolean *)0);
		jstate = (jlongArray)jenv->GetObjectArrayElement(jdata, 3);
		state = jenv->GetLongArrayElements(jstate, (jboolean *)0);
		resultPtr = state[0];
		if(resultPtr != 0)
			xmlresult = *(*(XmlResults **)&resultPtr);
		else{
			/* If the XmlResults object does not exist in the Java
			   then construct it from the XmlManager */
			createdResults = true;
			jlong mgrPtr = state[1];
			if (mgrPtr != 0){
				XmlManager *mgr = *(XmlManager **)&mgrPtr;
				jlong txnPtr = state[2];
				if(txnPtr != 0){
					XmlTransaction *txn = *(XmlTransaction **)&txnPtr;
					xmlresult = new ValueResults(*mgr, *txn);
				}else
					xmlresult = mgr->createResults();
			}else{
				XmlException e(XmlException::INVALID_VALUE, "The result set for this value has been closed, cannot access value.");
				throw e;
			}
		jenv->ReleaseLongArrayElements(jstate, state, JNI_ABORT);
		state = 0;
		}
		RawNodeValue *raw = RawNodeValue::create((void *)bytes, xmlresult);
		XmlValue returnValue(raw);
		jenv->ReleaseByteArrayElements(value, bytes, JNI_ABORT);
		bytes = 0;
		/*If the results where not created for this call then that
		  information should be recorded so that if the value is created
		  again in Java using the XmlResults.next/previous/peek function
		  then it will be set the its original XmlResults Java object */
		if(!createdResults) {
		    XmlResults *res = *(XmlResults **)&resultPtr;
		    raw->setReturnResults(res);
		}
		jobject jdoc = jenv->GetObjectArrayElement(jdata, 2);
		if(jdoc){
			XmlDocument cdoc = createCPPXmlDocument(jenv, jdoc);
			raw->setDocument(cdoc);
		}
		return returnValue;
	}else if(type == XmlValue::BINARY){
		jbyteArray value = (jbyteArray)jenv->GetObjectArrayElement(jdata, 1);
		if (value) {
			bytes = jenv->GetByteArrayElements(value, (jboolean *)0);
			if (bytes) {
				XmlData data((void *)bytes, jenv->GetArrayLength(value));
				XmlValue returnValue((XmlValue::Type)type, data);
				jenv->ReleaseByteArrayElements(value, bytes, JNI_ABORT);
				bytes = 0;
				return returnValue;
			}
		}
		XmlData data;
		XmlValue returnValue((XmlValue::Type)type, data);
		return returnValue;
	}else if(type == XmlValue::NONE){
		return XmlValue();
	}else{
		std::string stringValue;
		const char *str = 0;
		jstring value = (jstring)jenv->GetObjectArrayElement(jdata, 1);
		if (value) {
			str = jenv->GetStringUTFChars(value, (jboolean *)0);
			if (str) {
				stringValue = str;
				jenv->ReleaseStringUTFChars(value, str);
			}
		}
		//type name and type value are explicitly declared
		if(jenv->GetArrayLength(jdata) > 2) {
			std::string stringName;
			std::string stringURI;
			value = (jstring)jenv->GetObjectArrayElement(jdata, 2);
			if (value) {
				str = jenv->GetStringUTFChars(value, (jboolean *)0);
				if (str) {
					stringName = str;
					jenv->ReleaseStringUTFChars(value, str);
				}
			}
			value = (jstring)jenv->GetObjectArrayElement(jdata, 3);
			if (value) {
				str = jenv->GetStringUTFChars(value, (jboolean *)0);
				if (str) {
					stringURI = str;
					jenv->ReleaseStringUTFChars(value, str);
				}
			}
			return XmlValue(new AtomicTypeValue((XmlValue::Type)type, stringURI,
				stringName, stringValue));
		} else 
			return XmlValue((XmlValue::Type)type, stringValue);
	}
}catch (std::exception &se) {
	if(bytes) jenv->ReleaseByteArrayElements(value, bytes, JNI_ABORT);
	if(state) jenv->ReleaseLongArrayElements(jstate, state, JNI_ABORT);
	thr = createException(jenv, &se);
}
catch(JavaException & /* je */) {
	// This means there's already an exception waiting in the JVM
	if(bytes) jenv->ReleaseByteArrayElements(value, bytes, JNI_ABORT);
	if(state) jenv->ReleaseLongArrayElements(jstate, state, JNI_ABORT);
	XmlQueryContext nullContext;
	if (valid)
		*valid = false;
	return XmlValue();
}
catch (...) {
	if(bytes) jenv->ReleaseByteArrayElements(value, bytes, JNI_ABORT);
	if(state) jenv->ReleaseLongArrayElements(jstate, state, JNI_ABORT);
	thr = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
					  XmlException::INTERNAL_ERROR,
					  jenv->NewStringUTF("Uncaught exception from C++ API Constructing XmlValue"), 0, 0, 0, 0);
}
if (thr) {
	XmlQueryContext nullContext;
	jenv->Throw(thr);
}
if (valid)
	*valid = false;
return XmlValue(); // empty return
}

//Translate a C++ XmlValue into a java XmlValue when it is returned from a function
jobject createJavaXmlValue(JNIEnv *jenv, const XmlValue &xmlvalue)
{
jthrowable thr = NULL;
jobjectArray jvalue = 0;
jint jtype = xmlvalue.getType();
try {
	if(xmlvalue.isNode()){
		/* If the XmlValue is a node then create a Java XmlValue using
		   the type, node type, and ID. */
		RawNodeValue *node = const_cast<RawNodeValue*>((*xmlvalue).getRawNodeValueObject());
		if(!node){
			return 0;
		}else{
			jvalue = jenv->NewObjectArray(4, jenv->FindClass("Ljava/lang/Object;"), NULL);
			//Set the type in jvalue[0]
			jintArray types = jenv->NewIntArray(1);
			jint nodeType = xmlvalue.getNodeType();
			jenv->SetIntArrayRegion(types, 0, 1, &nodeType);
			jenv->SetObjectArrayElement(jvalue, 0, types);
			//Set the ID in jvalue[1]
			jbyte *data = 0;
			int size = node->dumpValue((void *&)data);
			jbyteArray dataBytes = jenv->NewByteArray(size);
			jenv->SetByteArrayRegion(dataBytes, 0, jenv->GetArrayLength(dataBytes), data);
			jenv->SetObjectArrayElement(jvalue, 1, dataBytes);
			/* If the new XmlValue was created from another Java XmlValue that had
			   an XmlResult, then set the new value's results to that of the old values */
			if(node->getReturnResults())
			{
				jlong resultsPtr = 0;
				*(XmlResults **)&resultsPtr = node->getReturnResults();
				jlongArray state = jenv->NewLongArray(4);
				jenv->SetLongArrayRegion(state, 3, 1, &resultsPtr);
				jenv->SetObjectArrayElement(jvalue, 3, state);
			}
			if(node->getNodeType() == XmlValue::DOCUMENT_NODE){
				XmlDocument cdoc = node->asDocument();
				jobject jdoc = createJavaXmlDocument(jenv, cdoc);
				jenv->SetObjectArrayElement(jvalue, 2, jdoc);
			}
		}
	}else if (xmlvalue.isNull()) {
		//Nothing to do
	}else{
		//Can be a binary or a string value
		try{
			std::string value = xmlvalue.asString();
			AtomicTypeValue atomic(xmlvalue.getType(), value);
			if(atomic.getTypeName() == xmlvalue.getTypeName()) 
				jvalue = jenv->NewObjectArray(1, jenv->FindClass("Ljava/lang/Object;"), NULL);
			else {
				jvalue = jenv->NewObjectArray(3, jenv->FindClass("Ljava/lang/Object;"), NULL);
				jenv->SetObjectArrayElement(jvalue, 1, 
					jenv->NewStringUTF(xmlvalue.getTypeName().c_str()));
				jenv->SetObjectArrayElement(jvalue, 2, 
					jenv->NewStringUTF(xmlvalue.getTypeURI().c_str()));
			}
			jenv->SetObjectArrayElement(jvalue, 0, jenv->NewStringUTF(value.c_str()));
		}catch(...){}
		if(!jvalue){
			try{
				jvalue = jenv->NewObjectArray(2, jenv->FindClass("Ljava/lang/Object;"), NULL);
				//Set the types in jvalue[0]
				XmlData value = xmlvalue.asBinary();
				jbyteArray valueBytes = jenv->NewByteArray(value.get_size());
				jbyte *valueData = static_cast<jbyte*>(value.get_data());
				jenv->SetByteArrayRegion(valueBytes, 0, jenv->GetArrayLength(valueBytes), valueData);
				jenv->SetObjectArrayElement(jvalue, 0, valueBytes);
			}catch(...){
				XmlException e(XmlException::INTERNAL_ERROR, "Uncaught exception from C++ API");
				throw e;
			}
		}
	}
	return jenv->NewObject(xml_valuedecl_class, xml_value_construct,
						 jtype, jvalue);
} catch (std::exception &se) {
	thr = createException(jenv, &se);
}
catch(JavaException & /* je */) {
	// This means there's already an exception waiting in the JVM
}
catch (...) {
	thr = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
					  XmlException::INTERNAL_ERROR,
					  jenv->NewStringUTF("Uncaught exception from C++ API Constructing Java XmlValue"), 0, 0, 0, 0);
}
if (thr) {
	jenv->Throw(thr);
}
return 0;
}



//Set the altered metadata in a Java XmlDocument from a C++ XmlDocument
void createJavaMetaData(JNIEnv *jenv, jobject jdoc, XmlDocument &cdoc, bool all = false)
{
if(!jdoc || cdoc.isNull()) return;
	
XmlMetaDataIterator itr = cdoc.getMetaDataIterator();
std::string uri, name;
XmlValue value;
std::vector<std::string> uris, names;
std::vector<jboolean> modifieds, removes;
std::vector<jobject> values;
while(itr.next(uri, name, value)){
    if(all || (*itr).previousIsModified() || (*itr).previousIsRemoved()){
		jobject jvalue = createJavaXmlValue(jenv, value);
		names.push_back(name);
		uris.push_back(uri);
		values.push_back(jvalue);
		modifieds.push_back((*itr).previousIsModified());
		removes.push_back((*itr).previousIsRemoved());
    }
}
int length = names.size();
if(length < 1) return;
jobjectArray jnames = jenv->NewObjectArray(length, jenv->FindClass("Ljava/lang/String;"), NULL); 
jobjectArray juris = jenv->NewObjectArray(length, jenv->FindClass("Ljava/lang/String;"), NULL);
jobjectArray jvalues = jenv->NewObjectArray(length, jenv->FindClass("Lcom/sleepycat/dbxml/XmlValue;"), NULL);
jbooleanArray jmodifieds = jenv->NewBooleanArray(length);
jbooleanArray jremoves = jenv->NewBooleanArray(length);

for(int i = 0; i < length; i++)
{
	jenv->SetObjectArrayElement(juris, i, jenv->NewStringUTF(uris[i].c_str()));
	jenv->SetObjectArrayElement(jnames, i, jenv->NewStringUTF(names[i].c_str()));
	jenv->SetObjectArrayElement(jvalues, i, values[i]);
	jboolean mod = modifieds[i];
	jenv->SetBooleanArrayRegion(jmodifieds, i, 1, &mod);
	mod = removes[i];
	jenv->SetBooleanArrayRegion(jremoves, i, 1, &mod);
}
jclass cls = jenv->GetObjectClass(jdoc);
jmethodID mid = jenv->GetMethodID(cls, "addMetaData", 
				  "([Ljava/lang/String;[Ljava/lang/String;[Lcom/sleepycat/dbxml/XmlValue;[Z[Z)V");
jenv->CallVoidMethod(jdoc, mid, juris, jnames, jvalues, jmodifieds, jremoves);
}

//Set all altered metadata in a C++ XmlDocument from a Java XmlDocument
void createCPPMetaData(JNIEnv *jenv, jobjectArray jdoc, XmlDocument &cdoc)
{
if(!jdoc || cdoc.isNull()) return;
	
int index = 0;
int size = jenv->GetArrayLength(jdoc);
jboolean *state = 0;
jbooleanArray jstate = 0;
jthrowable thr = NULL;
try {
	while(index < size)
	{
		jstring jname = (jstring)jenv->GetObjectArrayElement(jdoc, index);
		if(jname)
		{
			index++;
			std::string uri;
			const char *str = jenv->GetStringUTFChars(jname, (jboolean *)0);
			if (str) {
				uri = str;
				jenv->ReleaseStringUTFChars(jname, str);
			}
			std::string name;
			jname = (jstring)jenv->GetObjectArrayElement(jdoc, index++);
			if (jname) {
				str = jenv->GetStringUTFChars(jname, (jboolean *)0);
				if (str) {
					name = str;
					jenv->ReleaseStringUTFChars(jname, str);
				}
			}
			jobject jvalue = jenv->GetObjectArrayElement(jdoc, index++);
			jstate = (jbooleanArray)jenv->GetObjectArrayElement(jdoc, index++);
			state = jenv->GetBooleanArrayElements(jstate, (jboolean *)0);
			if(state[0] != JNI_FALSE) { //if modifed, add it to the doc
				XmlValue value = createCPPXmlValue(jenv, jvalue);
				cdoc.setMetaData(uri, name, value);
			}
			if(state[1] != JNI_FALSE) //if removed, remove it from the doc
				cdoc.removeMetaData(uri, name);
			jenv->ReleaseBooleanArrayElements(jstate, state, JNI_ABORT);
			state = 0;
		} else 
			index += 4;
	}
} catch (std::exception &se) {
	if (state) jenv->ReleaseBooleanArrayElements(jstate, state, JNI_ABORT);
	thr = createException(jenv, &se);
}
catch(JavaException & /* je */) {
	if (state) jenv->ReleaseBooleanArrayElements(jstate, state, JNI_ABORT);
}
catch (...) {
	if (state) jenv->ReleaseBooleanArrayElements(jstate, state, JNI_ABORT);
	thr = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
					  XmlException::INTERNAL_ERROR,
					  jenv->NewStringUTF("Uncaught exception from C++ API Constructing XmlQueryContext"), 0, 0, 0, 0);
}
if (thr) {
	jenv->Throw(thr);
}
}

jobject createJavaXmlDocument(JNIEnv *jenv, XmlDocument &cdoc)
{
jthrowable thr = NULL;
jobject jdoc = 0;
    try {
	if(cdoc.isNull()) return jdoc;
	int cid = (*cdoc).getContainerID();
	u_int64_t docid = *(u_int64_t *)((*cdoc).getID().rawPtr());
	jbyteArray bytes = 0;
	int contentType = (*cdoc).getDefinitiveContent();
	if(contentType != Document::NONE){
		/* If the data has been modified or the document is temporary then
		   the content has to be changed to a DBT so it will not be consumed
		   from the C++ document, which is what would happen if the content
		   was an INPUTSTREAM or EVENTREADER.  */
		if((*cdoc).isContentModified() || docid == 0){
			XmlData content = cdoc.getContent();
			bytes = jenv->NewByteArray(content.get_size());
			jbyte *data = static_cast<jbyte*>(content.get_data());
			jenv->SetByteArrayRegion(bytes, 0, jenv->GetArrayLength(bytes), data);
		}
	}
	jdoc = jenv->NewObject(xml_docdecl_class, xml_doc_construct, docid, cid, bytes);
	createJavaMetaData(jenv, jdoc, cdoc);
} catch (std::exception &se) {
	thr = createException(jenv, &se);
}
catch(JavaException & /* je */) {
	// This means there's already an exception waiting in the JVM
	jdoc = 0;
}
catch (...) {
	thr = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
					  XmlException::INTERNAL_ERROR,
					  jenv->NewStringUTF("Uncaught exception from C++ API Constructing Java XmlDocument"), 0, 0, 0, 0);
}
if (thr) {
	jenv->Throw(thr);
	jdoc = 0;
}
return jdoc;
}

//Look in XmlDocument.java at the function pack() to find the makeup of the
//jobjectArray.
XmlDocument createCPPXmlDocument(JNIEnv *jenv, jobject jdoc, bool setData)
{
    XmlDocument cdoc;
    jthrowable thr = NULL;
    jlong *state = 0;
    jlongArray jstate = 0;
    if(jdoc == 0)
	    return cdoc;
    try {
	    jclass cls = jenv->GetObjectClass(jdoc);	
	    jmethodID mid = jenv->GetMethodID(cls, "pack", "()[Ljava/lang/Object;");
	    jobjectArray jobj = (jobjectArray)jenv->CallObjectMethod(jdoc, mid);
	    jstate = (jlongArray)jenv->GetObjectArrayElement(jobj, 0);
	    state = jenv->GetLongArrayElements(jstate, (jboolean*)0);
	    jlong mgrPtr = state[3];
	    jlong resultPtr = state[2];
	    if (mgrPtr != 0){
		    XmlManager *mgr = *(XmlManager **)&mgrPtr;
		    cdoc = mgr->createDocument();
		    jlong txnPtr = state[4];
		    if(txnPtr != 0){
			    XmlTransaction *txn = *(XmlTransaction **)&txnPtr;
			    (*cdoc).getOperationContext().set(&**txn);
		    }
	    }else if(resultPtr != 0){
		    XmlResults &res = **(XmlResults **)&resultPtr;
		    XmlManager mgr = (*res).getManager();
		    cdoc = mgr.createDocument();
		    (*cdoc).getOperationContext().set((*res).getOperationContext().txn());
		    (*cdoc).setDbMinder((*res).getDbMinder());
	    }else{
		    XmlException e(XmlException::INVALID_VALUE, "Either the manager that created this document, or the results set that return it, has been deleted, cannot access the document.");
		    throw e;
	    }
	    //set doc id
	    u_int64_t docid = state[0];
	    DocID id(docid);
	    (*cdoc).setID(id);
	    
	    //set cid
	    jintArray jcidNType = (jintArray)jenv->GetObjectArrayElement(jobj, 1);
	    jint *cidNType = jenv->GetIntArrayElements(jcidNType, (jboolean*)0);
	    int cid = cidNType[0];
	    int type = cidNType[1];
	    jenv->ReleaseIntArrayElements(jcidNType, cidNType, JNI_ABORT);
	    (*cdoc).setContainerID(cid);
	    
	    if(!setData)
		    return cdoc;
		    
	    switch(type){
	    case Document::READER:
	    {
		    XmlEventReader *reader = *(XmlEventReader **)&(state[1]);
		    (*cdoc).setContentAsEventReader(*reader);
		    break;
	    }
	    case Document::INPUTSTREAM:
	    {
		    XmlInputStream *stream = *(XmlInputStream **)&(state[1]);
		    (*cdoc).setContentAsInputStream(&stream);
		    break;
	    }
	    case Document::DBT:
	    {
		    jbyteArray content = (jbyteArray)jenv->GetObjectArrayElement(jobj, 2);
		    jbyte *bytes = jenv->GetByteArrayElements(content, (jboolean *)0);
		    DbtOut *data;
		    if (bytes) {
				data = new DbtOut((void *)bytes, jenv->GetArrayLength(content));
				jenv->ReleaseByteArrayElements(content, bytes, JNI_ABORT);
			} else 
				data = new DbtOut(0, 0);
		    (*cdoc).setContentAsDbt(&data);
		    break;
	    }
	    default:
		    if(docid != 0 && cid != 0)
			    (*cdoc).setAsNotMaterialized();
			else if(!(*cdoc).getDbMinder().isNull() && cid == 0) {  //set query constructed documents as DOM
				(*cdoc).getDocDb();
				(*cdoc).setContentAsNsDom(docid, (*cdoc).getCacheDatabase());
			}
	    }
	    jenv->ReleaseLongArrayElements(jstate, state, JNI_ABORT);
	    state = 0;
	    
	    jobjectArray jmetadata = (jobjectArray)jenv->GetObjectArrayElement(jobj, 3);
	    createCPPMetaData(jenv, jmetadata, cdoc);
	    
	    return cdoc;
    } catch (std::exception &se) {
		if(state)
			jenv->ReleaseLongArrayElements(jstate, state, JNI_ABORT);
	    thr = createException(jenv, &se);
    }
    catch(JavaException & /* je */) {
		if(state)
			jenv->ReleaseLongArrayElements(jstate, state, JNI_ABORT);
	    // This means there's already an exception waiting in the JVM
	    // Fall through
    }
    catch (...) {
		if(state)
			jenv->ReleaseLongArrayElements(jstate, state, JNI_ABORT);
	    thr = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
					      XmlException::INTERNAL_ERROR,
					      jenv->NewStringUTF("Uncaught exception from C++ API Constructing XmlDocument"), 0, 0, 0, 0);
    }
    if (thr)
	    jenv->Throw(thr);
    return XmlDocument();
}

/*
 * Class:     com_sleepycat_dbxml_dbxml_javaJNI
 * Method:    materializeMetaData
 * Signature: (Lcom/sleepycat/dbxml/XmlDocument;)V
 * Copies all the meta data in a stored document to the java document.  Used
 * by the Java function XmlDocument.fetchAllData()
 */
extern "C"
JNIEXPORT void JNICALL Java_com_sleepycat_dbxml_dbxml_1javaJNI_materializeMetaData
(JNIEnv *jenv, jclass jcls, jobject jdoc)
{
    if(!jdoc) return;
    jthrowable thr = 0;
    try{
	XmlDocument cdoc = createCPPXmlDocument(jenv, jdoc, false);
	if (cdoc.isNull()) return;
	if ((*(u_int64_t *)((*cdoc).getID().rawPtr()) == 0)) return;
	(*cdoc).setAsNotMaterialized();
	createJavaMetaData(jenv, jdoc, cdoc, true);
    }catch (std::exception &se) {
	thr = createException(jenv, &se);
    }
    catch(JavaException & /* je */) {
	// This means there's already an exception waiting in the JVM
	return;
    }
    catch (...) {
	thr = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
					  XmlException::INTERNAL_ERROR,
					  jenv->NewStringUTF("Uncaught exception from C++ API"), 0, 0, 0, 0);
    }
    if (thr) {
	jenv->Throw(thr);
	return;
    }
}


//Create a C++ XmlQueryContext object from a Java XmlQueryContext object
XmlQueryContext createCPPXmlQueryContext(JNIEnv *jenv, 
					jlong mgrPtr, jlong dbgPtr, jint et, 
					jint queryTimeout, jobjectArray objects)
{
XmlQueryContext cqc;
{
    jthrowable thr = NULL;
    try {
	if (mgrPtr == 0){
	    XmlException e(XmlException::INVALID_VALUE, "No manager exists for the XmlQueryContext, cannot preceed.");
	    throw e;
	}
	XmlManager *mgr = *(XmlManager **)&mgrPtr;
	//get the return and evaluation types
	cqc = mgr->createQueryContext(XmlQueryContext::LiveValues, (XmlQueryContext::EvaluationType)et);
	int arrayLength = jenv->GetArrayLength(objects);
	//get the base uri
	int i = 0;
	const char *curi;
	jstring juri = (jstring)jenv->GetObjectArrayElement(objects, i++);
	if(juri != 0){
	    curi = jenv->GetStringUTFChars(juri, (jboolean *)0);
	    std::string uri(curi);
	    jenv->ReleaseStringUTFChars(juri, curi);
	    cqc.setBaseURI(uri);
	}
	//get the default collection
	juri = (jstring)jenv->GetObjectArrayElement(objects, i++);
	if(juri != 0){
	    curi = jenv->GetStringUTFChars(juri, (jboolean *)0);
	    std::string uri2(curi);
	    jenv->ReleaseStringUTFChars(juri, curi);
	    cqc.setDefaultCollection(uri2);
	}
	//get the debug listener
	XmlDebugListener *listener = *(XmlDebugListener**)&dbgPtr;
	cqc.setDebugListener(listener);
	//get the Query Interrupt time
	cqc.setQueryTimeoutSeconds(queryTimeout);
	//get the namespaces
	jobject jprefix = jenv->GetObjectArrayElement(objects, i++);
	while(arrayLength > i && jprefix != 0){
	    //prefix
	    curi = jenv->GetStringUTFChars((jstring)jprefix, (jboolean *)0);
	    std::string prefix;
	    if (curi) {
			prefix = curi;
			jenv->ReleaseStringUTFChars((jstring)jprefix, curi);
		}
	    //uri
	    juri = (jstring)jenv->GetObjectArrayElement(objects, i++);
	    std::string uri;
	    if (juri) {
			curi = jenv->GetStringUTFChars(juri, (jboolean *)0);
			if (curi) {
				uri = curi;
				jenv->ReleaseStringUTFChars(juri, curi);
			}
		}
	    cqc.setNamespace(prefix, uri);
	    jprefix = jenv->GetObjectArrayElement(objects, i++);
	}
	//get variables
	while(arrayLength > i){
	    //name
	    std::string name;
	    jstring jname = (jstring)jenv->GetObjectArrayElement(objects, i++);
	    if (jname) {
			curi = jenv->GetStringUTFChars(jname, (jboolean *)0);
			if (curi) {
				name = curi;
				jenv->ReleaseStringUTFChars(jname, curi);
			}
		}
	    //value
	    jobjectArray jvalues = (jobjectArray)jenv->GetObjectArrayElement(objects, i++);
	    int valueArrayLength = jenv->GetArrayLength(jvalues);
	    XmlResults results = mgr->createResults(); 
	    for(int i = 0; i < valueArrayLength; i++){
		jobject jvalue = jenv->GetObjectArrayElement(jvalues, i);
		XmlValue value = createCPPXmlValue(jenv, jvalue);
		if (value.isNode()) { //Force materialization of nodes
			const RawNodeValue *raw = (*value).getRawNodeValueObject();
			if (raw) {
				XmlDocument doc = raw->asDocument();
				if(!doc.isNull()) {
					if (raw->getDBMinder() && !raw->getDBMinder()->isNull() && (*doc).isUninitialized()) {
						(*doc).setDbMinder(*raw->getDBMinder());
						(*doc).getDocDb();
						(*doc).setContentAsNsDom((*doc).getID(), (*doc).getCacheDatabase());
					} else
						(*doc).changeContentToNsDom(0);
				}
			}
		}
		results.add(value); 
	    }
	    results.reset();
	    //set the variable
	    cqc.setVariableValue(name, results);
	}
    } catch (std::exception &se) {
	thr = createException(jenv, &se);
    }
    catch(JavaException & /* je */) {
	// This means there's already an exception waiting in the JVM
	    return XmlQueryContext();
    }
    catch (...) {
	    thr = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
					      XmlException::INTERNAL_ERROR,
					      jenv->NewStringUTF("Uncaught exception from C++ API Constructing XmlQueryContext"), 0, 0, 0, 0);
    }

    if (thr) {
	jenv->Throw(thr);
	return XmlQueryContext();
    }
}
return cqc;
}

/*
 * Class:     com_sleepycat_dbxml_dbxml_javaJNI
 * Method:    interruptQuery
 * Signature: (J)V
 */
extern "C"
JNIEXPORT void JNICALL Java_com_sleepycat_dbxml_dbxml_1javaJNI_interruptQuery
(JNIEnv *jenv, jclass cla, jlong contextPtr)
{
    XmlQueryContext context((QueryContext *)contextPtr);
    if(context.isNull()) return;
    context.interruptQuery();
}
	
struct queryContextRef {
public:
	queryContextRef(JNIEnv *jenv, jlong mgrPtr, jlong dbgPtr, jint eval, jint querySec, jobjectArray data, jobject obj) :
		env_(jenv), obj_(obj) {
		cls_ = env_->GetObjectClass(obj);
		setCPtr_ = env_->GetMethodID(cls_, "setCPtr", "(J)V");
		qc_ = createCPPXmlQueryContext(env_, mgrPtr, dbgPtr, eval, querySec, data);
		if (qc_.isNull()) return; //exception happened while creating context
		//Set the c pointer in Java so the query can be interrupted
		QueryContext *cptr = (QueryContext *)qc_;
		env_->CallVoidMethod(obj_, setCPtr_, (jlong)cptr);
	}
	~queryContextRef() {
		// clear pointer in Java object
		jthrowable ex = env_->ExceptionOccurred();
		if (ex != NULL)
		    env_->ExceptionClear();
		env_->CallVoidMethod(obj_, setCPtr_, (jlong)0);
		if(ex != NULL)
			env_->Throw(ex);
	}
	XmlQueryContext *getQC() { return &qc_; }
	XmlQueryContext qc_;
	JNIEnv *env_;
	jobject obj_;
	jclass cls_;
	jmethodID setCPtr_;
};

SWIGINTERN bool HelperFunctions_testXmlData(){
	XmlData data;
	
	if(!(data.get_size() == 0)) return false;
	if(!(data.get_data() == 0)) return false;
	if(!(data.getReservedSize() == 0)) return false;
	const char *str = "abc";
	const char *str2 = "def";
	const char *str3 = "abcdef";
	data.set((void*)str, 3);
	if(!(::strncmp((char *)data.get_data(), str, 3) == 0)) return false;
	if(!(data.get_size() == 3)) return false;
	if(!(data.getReservedSize() > 0)) return false;
	data.append((void*)str2, 3);
	if(!(::strncmp((char *)data.get_data(), str3, 6) == 0)) return false;
	if(!(data.get_size() == 6)) return false;
	if(!(data.getReservedSize() > 0)) return false;
	data.set((void*)str2, 3);
	if(!(::strncmp((char *)data.get_data(), str2, 3) == 0)) return false;
	if(!(data.get_size() == 3)) return false;
	if(!(data.getReservedSize() > 0)) return false;
	XmlData data2;
	data2.append((void*)str, 3);
	if(!(::strncmp((char *)data2.get_data(), str, 3) == 0)) return false;
	if(!(data2.get_size() == 3)) return false;
	if(!(data2.getReservedSize() > 0)) return false;
	XmlData data3((void*)str, 3);
	if(!(::strncmp((char *)data3.get_data(), str, 3) == 0)) return false;
	if(!(data3.get_size() == 3)) return false;
	if(!(data3.getReservedSize() > 0)) return false;
	try {
		data3.append((void*)str2,3);
		return false;
	} catch (XmlException e) {}
	XmlData data4;
	data4.reserve(6);
	if(!(data4.getReservedSize() == 6)) return false;
	data4.set((void*)str, 3);
	if(!(::strncmp((char *)data4.get_data(), str, 3) == 0)) return false;
	if(!(data4.get_size() == 3)) return false;

	XmlData data5;
	data5.reserve(3);
	void *dat = data5.get_data();
	memcpy(dat, str, 3);
	data5.set_size(3);
	if(!(::strncmp((char *)data5.get_data(), str, 3) == 0)) return false;

	XmlData data7((void*)str, 3);
	XmlData data8;
	data8.adoptBuffer(data7);
	if (data7.get_data()) return false;
	if(!(::strncmp((char *)data8.get_data(), str, 3) == 0)) return false;
	return true;
	}
SWIGINTERN bool HelperFunctions_testConfigDefault(XmlContainerConfig javaDefault){
	    XmlContainerConfig cppConfig;
		if(javaDefault.getAllowCreate() != cppConfig.getAllowCreate())
			throw XmlException(XmlException::INVALID_VALUE, "Default Allow Create does not match");
		if(javaDefault.getAllowValidation() != cppConfig.getAllowValidation())
			throw XmlException(XmlException::INVALID_VALUE, "Default Allow Validation does not match");
		if(javaDefault.getChecksum() != cppConfig.getChecksum())
			throw XmlException(XmlException::INVALID_VALUE, "Default checksum does not match");
		if(::strcmp(javaDefault.getCompressionName(),cppConfig.getCompressionName()) != 0)
			throw XmlException(XmlException::INVALID_VALUE, "Default compression name does not match");
		if(javaDefault.getContainerType() != cppConfig.getContainerType())
			throw XmlException(XmlException::INVALID_VALUE, "Default container type does not match");
		if(javaDefault.getEncrypted() != cppConfig.getEncrypted())
			throw XmlException(XmlException::INVALID_VALUE, "Default encrypted does not match");
		if(javaDefault.getExclusiveCreate() != cppConfig.getExclusiveCreate())
			throw XmlException(XmlException::INVALID_VALUE, "Default exclusive create does not match");
		if(javaDefault.getIndexNodes() != cppConfig.getIndexNodes())
			throw XmlException(XmlException::INVALID_VALUE, "Default index nodes does not match");
		if(javaDefault.getMode() != cppConfig.getMode())
			throw XmlException(XmlException::INVALID_VALUE, "Default mode does not match");
		if(javaDefault.getMultiversion() != cppConfig.getMultiversion())
			throw XmlException(XmlException::INVALID_VALUE, "Default multiversion does not match");
		if(javaDefault.getNoMMap() != cppConfig.getNoMMap())
			throw XmlException(XmlException::INVALID_VALUE, "Default no mmap does not match");
		if(javaDefault.getPageSize() != cppConfig.getPageSize())
			throw XmlException(XmlException::INVALID_VALUE, "Default container type does not match");
		if(javaDefault.getReadOnly() != cppConfig.getReadOnly())
			throw XmlException(XmlException::INVALID_VALUE, "Default read only does not match");
		if(javaDefault.getReadUncommitted() != cppConfig.getReadUncommitted())
			throw XmlException(XmlException::INVALID_VALUE, "Default read uncommitted does not match");
		if(javaDefault.getSequenceIncrement() != cppConfig.getSequenceIncrement())
			throw XmlException(XmlException::INVALID_VALUE, "Default sequence increment does not match");
		if(javaDefault.getStatistics() != cppConfig.getStatistics())
			throw XmlException(XmlException::INVALID_VALUE, "Default container type does not match");
		if(javaDefault.getThreaded() != cppConfig.getThreaded())
			throw XmlException(XmlException::INVALID_VALUE, "Default threaded does not match");
		if(javaDefault.getTransactional() != cppConfig.getTransactional())
			throw XmlException(XmlException::INVALID_VALUE, "Default transactional does not match");
		if(javaDefault.getTransactionNotDurable() != cppConfig.getTransactionNotDurable())
			throw XmlException(XmlException::INVALID_VALUE, "Default transaction not durable does not match");
		return true;
	}
SWIGINTERN bool HelperFunctions_testConfigBitOperator(XmlManager &mgr){
	    XmlContainerConfig config;
  	    config = (XmlContainerConfig)XmlContainer::WholedocContainer|DBXML_TRANSACTIONAL|DB_CREATE|"compressionname";
  	    if(config.getContainerType() != XmlContainer::WholedocContainer)
		throw XmlException(XmlException::INVALID_VALUE, "Bitwise operator filed to combine container type");
  	    if(!config.getTransactional())
		throw XmlException(XmlException::INVALID_VALUE, "Bitwise operator failed for transactional flag");
  	    if(!config.getAllowCreate())
		throw XmlException(XmlException::INVALID_VALUE, "Bitwise operator failed for allow create flag");
  	    if(::strcmp(config.getCompressionName(),"compressionname") != 0)
		throw XmlException(XmlException::INVALID_VALUE, "Bitwise operator failed for compression name");
    	    XmlContainer cont = mgr.openContainer("", (XmlContainerConfig)XmlContainer::WholedocContainer|DBXML_NO_STATISTICS|DB_CREATE|XmlContainerConfig::NO_COMPRESSION);
    	    if(cont.getContainerType() != XmlContainer::WholedocContainer)
		throw XmlException(XmlException::INVALID_VALUE, "Bitwise operator did not create the correct container");
		try {
			XmlContainerConfig config2(DB_TXN_NOT_DURABLE);
			return false;
		} catch (XmlException e) {}
		try {
			XmlContainerConfig config2(DB_READ_UNCOMMITTED);
			return false;
		} catch (XmlException e) {}
	    return true;
	}
SWIGINTERN bool HelperFunctions_testNullTxn(XmlManager &mgr){
	    XmlTransaction txn;
	    if(!txn.isNull())
		return false;
	    XmlContainer cont = mgr.createContainer(txn, "");
	    std::string name = "test.xml";
	    std::string content = "<a>b</a>";
	    XmlUpdateContext uc = mgr.createUpdateContext();
	    cont.putDocument(txn, name, content, uc);
	    XmlDocument doc = cont.getDocument(txn, name);
	    if(doc.getName() != name)
		return false;
	    std::string content2;
	    if(doc.getContent(content2) != content)
		return false;
	    return true;
	}
SWIGINTERN int HelperFunctions_getType(std::string URI,std::string name,std::string value){
	    AtomicTypeValue val(URI, name, value);
	    return val.getType();
	}
SWIGINTERN std::string HelperFunctions_getTypeURI(DBT *data,XmlResults *result){
	    XmlValue raw(RawNodeValue::create(data->data, *result));
	    return raw.getTypeURI();
	}
SWIGINTERN std::string HelperFunctions_getTypeName(DBT *data,XmlResults *result){
	    XmlValue raw(RawNodeValue::create(data->data, *result));
	    return raw.getTypeName();
	}
SWIGINTERN std::string HelperFunctions_asString(DBT *data,XmlResults *result){
	    XmlValue raw(RawNodeValue::create(data->data, *result));
	    return raw.asString();
	}
SWIGINTERN XmlDocument HelperFunctions_asDocument(DBT *data,XmlResults *result){
	    XmlValue raw(RawNodeValue::create(data->data, *result));
	    return raw.asDocument();
	}
SWIGINTERN XmlEventReader &HelperFunctions_asEventReader(DBT *data,XmlResults *result){
	    XmlValue raw(RawNodeValue::create(data->data, *result));
	    return raw.asEventReader();
	}
SWIGINTERN std::string HelperFunctions_getNodeHandle(DBT *data,XmlResults *result){
	    XmlValue raw(RawNodeValue::create(data->data, *result));
	    return raw.getNodeHandle();
	}
SWIGINTERN std::string HelperFunctions_getNodeName(DBT *data,XmlResults *result){
	    XmlValue raw(RawNodeValue::create(data->data, *result));
	    return raw.getNodeName();
	}
SWIGINTERN std::string HelperFunctions_getNodeValue(DBT *data,XmlResults *result){
	    XmlValue raw(RawNodeValue::create(data->data, *result));
	    return raw.getNodeValue();
	}
SWIGINTERN std::string HelperFunctions_getNamespaceURI(DBT *data,XmlResults *result){
	    XmlValue raw(RawNodeValue::create(data->data, *result));
	    return raw.getNamespaceURI();
	}
SWIGINTERN std::string HelperFunctions_getPrefix(DBT *data,XmlResults *result){
	    XmlValue raw(RawNodeValue::create(data->data, *result));
	    return raw.getPrefix();
	}
SWIGINTERN std::string HelperFunctions_getLocalName(DBT *data,XmlResults *result){
	    XmlValue raw(RawNodeValue::create(data->data, *result));
	    return raw.getLocalName();
	}
SWIGINTERN XmlValue HelperFunctions_getParentNode(DBT *data,XmlResults *result){
	    XmlValue raw(RawNodeValue::create(data->data, *result));
	    return raw.getParentNode();
	}
SWIGINTERN XmlValue HelperFunctions_getFirstChild(DBT *data,XmlResults *result){
	    XmlValue raw(RawNodeValue::create(data->data, *result));
	    return raw.getFirstChild();
	}
SWIGINTERN XmlValue HelperFunctions_getLastChild(DBT *data,XmlResults *result){
	    XmlValue raw(RawNodeValue::create(data->data, *result));
	    return raw.getLastChild();
	}
SWIGINTERN XmlValue HelperFunctions_getPreviousSibling(DBT *data,XmlResults *result){
	    XmlValue raw(RawNodeValue::create(data->data, *result));
	    return raw.getPreviousSibling();
	}
SWIGINTERN XmlValue HelperFunctions_getNextSibling(DBT *data,XmlResults *result){
	    XmlValue raw(RawNodeValue::create(data->data, *result));
	    return raw.getNextSibling();
	}
SWIGINTERN XmlResults *HelperFunctions_getAttributes(DBT *data,XmlResults *result){
	    XmlValue raw(RawNodeValue::create(data->data, *result));
	    return new XmlResults(raw.getAttributes());
	}
SWIGINTERN XmlValue HelperFunctions_getOwnerElement(DBT *data,XmlResults *result){
	    XmlValue raw(RawNodeValue::create(data->data, *result));
	    return raw.getOwnerElement();
	}
SWIGINTERN XmlValue HelperFunctions_createDocumentValue(XmlDocument &doc){
	    XmlManager mgr = (*doc).getManager();
	    XmlResults result = mgr.createResults();
	    XmlValue value(doc);
	    RawNodeValue *raw = RawNodeValue::create(value, result);
		XmlValue returnValue(raw);
	    raw->setDocument(doc);
	    return returnValue;
	}
SWIGINTERN XmlResults HelperFunctions_createResults(XmlTransaction *txn,XmlManager *mgr){
	    return new ValueResults(*mgr, *txn);
	}
SWIGINTERN std::string HelperFunctions_getAtomicTypeName(int type,std::string v){
	    AtomicTypeValue value((XmlValue::Type)type, v);
	    return value.getTypeName();
	}
SWIGINTERN std::string HelperFunctions_getAtomicTypeURI(int type,std::string v){
	    AtomicTypeValue value((XmlValue::Type)type, v);
	    return value.getTypeURI();
	}
SWIGINTERN void HelperFunctions_validateString(int type,std::string v){
	    XmlValue value((XmlValue::Type)type, v);
	}
SWIGINTERN XmlInputStream *HelperFunctions_getContentAsXmlInputStream(XmlDocument &doc){
		return doc.getContentAsXmlInputStream();
	}
SWIGINTERN XmlEventReader &HelperFunctions_getContentAsEventReader(XmlDocument &doc){
	    return doc.getContentAsEventReader();
	}
SWIGINTERN void HelperFunctions_getContentAsEventWriter(XmlDocument &doc,XmlEventWriter &writer){
	    doc.getContentAsEventWriter(writer);
	}
SWIGINTERN std::string HelperFunctions_getContentAsString(XmlDocument &doc){
	    std::string content;
	    doc.getContent(content);
	    return content;
	}
SWIGINTERN XmlData HelperFunctions_getContent(XmlDocument &doc){
		return doc.getContent();
	}
SWIGINTERN XmlValue HelperFunctions_getMetaData(std::string uri,std::string name,XmlDocument &doc){
	    XmlValue value;
	    doc.getMetaData(uri, name, value);
	    return value;
	}
SWIGINTERN std::string HelperFunctions_verifyDefaultCollection(XmlManager mgr,std::string defaultCollection,std::string baseURI){
	    XmlQueryContext context = mgr.createQueryContext();
	    if(baseURI.size() > 0)
		context.setBaseURI(baseURI);
	    context.setDefaultCollection(defaultCollection);
	    return context.getDefaultCollection();
	}
SWIGINTERN void HelperFunctions_verifyBaseURI(XmlManager mgr,std::string baseURI){
	    XmlQueryContext context = mgr.createQueryContext();
	    context.setBaseURI(baseURI);
	}
SWIGINTERN void XmlData_append(XmlData *self,DBT *data){
		self->append(data->data, data->size);
	}
SWIGINTERN void XmlData_set(XmlData *self,DBT *data){
		self->set(data->data, data->size);
	}

	  
	  /*
	 * Class:     com_sleepycat_dbxml_dbxml_javaJNI
	 * Method:    get_data
	 * Signature: (J)[B
	 */
	 extern "C"
	JNIEXPORT jbyteArray JNICALL Java_com_sleepycat_dbxml_dbxml_1javaJNI_get_1data
	  (JNIEnv *jenv, jclass jcla, jlong cptr)
	{
		if (!cptr) return jenv->NewByteArray(0);
		XmlData *self = *(XmlData **)&cptr;
		u_int32_t size = self->get_size();
		if(size >0){
			jbyteArray bytes = jenv->NewByteArray(size);
			jenv->SetByteArrayRegion(bytes, 0, size, (jbyte*)self->get_data());
			return bytes;
		}else
			return jenv->NewByteArray(0);
	}

// Not used for anything at the moment
	/*
	 * Class:    com_sleepycat_dbxml_dbxml_javaJNI
	 * Method:    set_data
	 * Signature: (J[B)V
	 */
	 extern "C"
	JNIEXPORT void JNICALL Java_com_sleepycat_dbxml_dbxml_1javaJNI_set_1data
	  (JNIEnv *jenv, jclass jcla, jlong cptr, jbyteArray bytes)
	{
		if (!cptr) return;
		XmlData *self = *(XmlData **)&cptr;
		if (!bytes) {
			self->set_size(0);
			return;
		}
		jbyte *jbytes = jenv->GetByteArrayElements(bytes, 0);
		if (jbytes) {
			self->set(jbytes, jenv->GetArrayLength(bytes));
			jenv->ReleaseByteArrayElements(bytes, jbytes, JNI_ABORT);
		} else
			self->set_size(0);
	}



class XmlIndexDeclaration {
public:
	XmlIndexDeclaration() {}
	XmlIndexDeclaration(const std::string &uri, const std::string &name, const std::string &index) : uri(uri), name(name), index(index) {}
#ifndef SWIGJAVA	
	const std::string &get_uri() const { return uri; }
	const std::string &get_name() const { return name; }
	const std::string &get_index() const { return index; }
#endif
	std::string uri, name, index;
};

class XmlMetaData {
public:
	XmlMetaData() {}
	XmlMetaData(const std::string &uri, const std::string &name, const
		    XmlValue &value) : uri(uri), name(name), value(value) {}
	
	const std::string &get_uri() const { return uri; }
	const std::string &get_name() const { return name; }
	const XmlValue &get_value() const { return value; }
	std::string uri, name;
	XmlValue value;
};


SWIGINTERN XmlInputStream *XmlManager_createStdInInputStream(XmlManager const *self){
		return self->createStdInInputStream();
	}
SWIGINTERN XmlInputStream *XmlManager_createLocalFileInputStream(XmlManager const *self,std::string const &filename){
		return self->createLocalFileInputStream(filename);
	}
SWIGINTERN XmlInputStream *XmlManager_createMemBufInputStream__SWIG_0(XmlManager const *self,char const *bytes,unsigned int const count,char const *id,bool const adopt=false){
		return self->createMemBufInputStream(bytes,
						     count,
						     id, adopt);
	}
SWIGINTERN XmlInputStream *XmlManager_createMemBufInputStream__SWIG_2(XmlManager const *self,char const *bytes,unsigned int const count,bool const copyBuffer){
		return self->createMemBufInputStream(bytes,
						     count,
						     copyBuffer);
	}
SWIGINTERN XmlInputStream *XmlManager_createURLInputStream__SWIG_0(XmlManager const *self,std::string const &baseId,std::string const &systemId,std::string const &publicId){
		return self->createURLInputStream(baseId, systemId, publicId);
	}
SWIGINTERN XmlInputStream *XmlManager_createURLInputStream__SWIG_1(XmlManager const *self,std::string const &baseId,std::string const &systemId){
		return self->createURLInputStream(baseId, systemId);
	}
SWIGINTERN void XmlManager_dumpContainer(XmlManager *self,std::string const &name,char const *filename){
		std::ofstream out(filename);
		self->dumpContainer(name, &out);
		out.close();
	}
SWIGINTERN void XmlManager_verifyContainer__SWIG_0(XmlManager *self,std::string const &name,char const *filename,u_int32_t flags=0){
		std::ofstream out;
		if (flags & DB_SALVAGE)
			out.open(filename);
		self->verifyContainer(name, &out, flags);
		if (flags & DB_SALVAGE)
			out.close();
	}
SWIGINTERN XmlQueryExpression *XmlManager_prepare__SWIG_0(XmlManager *self,std::string const &query,XmlQueryContext &context){
		return new XmlQueryExpression(self->prepare(query, context));
	}
SWIGINTERN XmlQueryExpression *XmlManager_prepare__SWIG_1(XmlManager *self,XmlTransaction &txn,std::string const &query,XmlQueryContext &context){
		return new XmlQueryExpression(self->prepare(
						      txn,query, context));
	}
SWIGINTERN XmlResults *XmlManager_query__SWIG_0(XmlManager *self,std::string const &query,XmlQueryContext &context,u_int32_t flags){
		return new XmlResults(self->query(query, context, flags));
	}
SWIGINTERN XmlResults *XmlManager_query__SWIG_1(XmlManager *self,XmlTransaction &txn,std::string const &query,XmlQueryContext &context,u_int32_t flags){
		return new XmlResults(self->query(txn, query, context, flags));
	}
SWIGINTERN XmlResults *XmlManager_query__SWIG_2(XmlManager *self,std::string const &query,XmlQueryContext &context){
		return new XmlResults(self->query(query, context, 0));
	}
SWIGINTERN XmlResults *XmlManager_query__SWIG_3(XmlManager *self,XmlTransaction &txn,std::string const &query,XmlQueryContext &context){
		return new XmlResults(self->query(txn, query, context, 0));
	}
SWIGINTERN XmlResults *XmlManager_createResults(XmlManager *self){
		return new XmlResults(self->createResults());
	}
SWIGINTERN XmlTransaction *XmlManager_createTransaction(XmlManager *self,DB_TXN *toAdopt){
		return new XmlTransaction(self->createTransaction(toAdopt));
        }
SWIGINTERN XmlIndexLookup *XmlManager_createIndexLookupInternal__SWIG_0(XmlManager *self,XmlContainer &cont,std::string const &uri,std::string const &name,std::string const &index,XmlValue const &value=XmlValue(),enum XmlIndexLookup::Operation op=XmlIndexLookup::NONE){
		return new XmlIndexLookup(self->createIndexLookup(cont, uri,name,
								  index, value,
								  op));
	}
SWIGINTERN void XmlManager_setLogLevel(enum LogLevel level,bool enabled){
		DbXml::setLogLevel(level, enabled);
	}
SWIGINTERN void XmlManager_setLogCategory(enum LogCategory category,bool enabled){
		DbXml::setLogCategory(category, enabled);
	}
SWIGINTERN int XmlManager_get_version_major(){
		int major;
		(void)dbxml_version(&major, NULL, NULL);
		return major;
	}
SWIGINTERN int XmlManager_get_version_minor(){
		int minor;
		(void)dbxml_version(NULL, &minor, NULL);
		return minor;
	}
SWIGINTERN int XmlManager_get_version_patch(){
		int patch;
		(void)dbxml_version(NULL, NULL, &patch);
		return patch;
	}
SWIGINTERN char const *XmlManager_get_version_string(){
		return dbxml_version(NULL, NULL, NULL);
	}
SWIGINTERN XmlContainer XmlManager_createContainerInternal__SWIG_0(XmlManager *self,std::string const &name,XmlContainerConfig &config){
		return self->createContainer(name, config);
	}
SWIGINTERN XmlContainer XmlManager_createContainerInternal__SWIG_1(XmlManager *self,XmlTransaction &txn,std::string const &name,XmlContainerConfig &config){
		return self->createContainer(txn, name, config);
	}
SWIGINTERN XmlContainer XmlManager_openContainerInternal__SWIG_0(XmlManager *self,std::string const &name,XmlContainerConfig &config){
		return self->openContainer(name, config);
	}
SWIGINTERN XmlContainer XmlManager_openContainerInternal__SWIG_1(XmlManager *self,XmlTransaction &txn,std::string const &name,XmlContainerConfig &config){
		return self->openContainer(txn, name, config);
	}
SWIGINTERN XmlDocument XmlManager_createDocumentInternal(XmlManager *self){
		return self->createDocument();
    }
SWIGINTERN void XmlManager_upgradeContainer(XmlManager *self,std::string const &name){
		XmlUpdateContext uc = self->createUpdateContext();
		self->upgradeContainer(name, uc);
    }
SWIGINTERN void XmlManager_compactContainer__SWIG_0(XmlManager *self,std::string const &name){
		XmlUpdateContext uc = self->createUpdateContext();
		self->compactContainer(name, uc);
    }
SWIGINTERN void XmlManager_compactContainer__SWIG_1(XmlManager *self,XmlTransaction &txn,std::string const &name){
		XmlUpdateContext uc = self->createUpdateContext();
		self->compactContainer(txn, name, uc);
	}
SWIGINTERN void XmlManager_truncateContainer__SWIG_0(XmlManager *self,std::string const &name){
		XmlUpdateContext uc = self->createUpdateContext();
		self->truncateContainer(name, uc);
	}
SWIGINTERN void XmlManager_truncateContainer__SWIG_1(XmlManager *self,XmlTransaction &txn,std::string const &name){
		XmlUpdateContext uc = self->createUpdateContext();
		self->truncateContainer(txn, name, uc);
	}
SWIGINTERN void XmlManager_reindexContainer__SWIG_0(XmlManager *self,std::string const &name,XmlContainerConfig flags){
		XmlUpdateContext uc = self->createUpdateContext();
		flags.setThreaded(false);
		self->reindexContainer(name, uc, flags);
	}
SWIGINTERN void XmlManager_reindexContainer__SWIG_1(XmlManager *self,XmlTransaction &txn,std::string const &name,XmlContainerConfig flags){
		XmlUpdateContext uc = self->createUpdateContext();
		flags.setThreaded(false);
		self->reindexContainer(txn, name, uc, flags);
	}
SWIGINTERN void XmlManager_loadContainer(XmlManager *self,std::string const &name,char const *filename){
		XmlUpdateContext uc = self->createUpdateContext();
		std::ifstream in(filename);
		unsigned long lineno = 0;
		self->loadContainer(name, &in, &lineno, uc);
		in.close();
	}
SWIGINTERN void XmlManager_registerCompressionInternal(XmlManager *self,char const *name,XmlCompression &compression){ 
		self->registerCompression(name, compression);
	}
SWIGINTERN void XmlManager_registerResolverInternal(XmlManager *self,XmlResolver *resolver){ 
		self->registerResolver(*resolver);
	}
SWIGINTERN XmlResults *XmlIndexLookup_execute__SWIG_0(XmlIndexLookup const *self,XmlQueryContext &context,u_int32_t flags=0){
		return new XmlResults(self->execute(context, flags));
	}
SWIGINTERN XmlResults *XmlIndexLookup_execute__SWIG_2(XmlIndexLookup const *self,XmlTransaction &txn,XmlQueryContext &context,u_int32_t flags=0){
		return new XmlResults(self->execute(txn, context, flags));
	}
SWIGINTERN XmlIndexLookup *XmlIndexLookup_copy(XmlIndexLookup const &o){
	return new XmlIndexLookup(o);
    }
SWIGINTERN XmlIndexSpecification *XmlContainer_getIndexSpecification__SWIG_0(XmlContainer const *self){
		return new XmlIndexSpecification(self->getIndexSpecification());
	}
SWIGINTERN XmlIndexSpecification *XmlContainer_getIndexSpecification__SWIG_1(XmlContainer const *self,XmlTransaction &txn){
		 return new XmlIndexSpecification(
			 self->getIndexSpecification(txn));
        }
SWIGINTERN XmlIndexSpecification *XmlContainer_getIndexSpecification__SWIG_2(XmlContainer const *self,XmlTransaction &txn,u_int32_t flags){
		 return new XmlIndexSpecification(
			 self->getIndexSpecification(txn, flags));
	 }
SWIGINTERN XmlResults *XmlContainer_getAllDocuments__SWIG_0(XmlContainer *self,u_int32_t flags){
		   return new XmlResults(self->getAllDocuments(flags));
	}
SWIGINTERN XmlResults *XmlContainer_getAllDocuments__SWIG_1(XmlContainer *self,XmlTransaction &txn,u_int32_t flags){
		   return new XmlResults(self->getAllDocuments(txn, flags));
	}
SWIGINTERN XmlResults *XmlContainer_lookupIndex__SWIG_0(XmlContainer *self,XmlQueryContext &context,std::string const &uri,std::string const &name,std::string const &index,XmlValue const &value=XmlValue(),u_int32_t flags=0){
		return new XmlResults(
			self->lookupIndex(context, uri, name, index,
					  value, flags));
	}
SWIGINTERN XmlResults *XmlContainer_lookupIndex__SWIG_3(XmlContainer *self,XmlQueryContext &context,std::string const &uri,std::string const &name,std::string const &parent_uri,std::string const &parent_name,std::string const &index,XmlValue const &value=XmlValue(),u_int32_t flags=0){
		return new XmlResults(self->lookupIndex(context, uri, name,
							parent_uri, parent_name,
							index, value, flags));
	}
SWIGINTERN XmlResults *XmlContainer_lookupIndex__SWIG_6(XmlContainer *self,XmlTransaction &txn,XmlQueryContext &context,std::string const &uri,std::string const &name,std::string const &index,XmlValue const &value=XmlValue(),u_int32_t flags=0){
                return new XmlResults(self->lookupIndex(txn, context, uri, name,
							index, value, flags));
        }
SWIGINTERN XmlResults *XmlContainer_lookupIndex__SWIG_9(XmlContainer *self,XmlTransaction &txn,XmlQueryContext &context,std::string const &uri,std::string const &name,std::string const &parent_uri,std::string const &parent_name,std::string const &index,XmlValue const &value=XmlValue(),u_int32_t flags=0){
	        return new XmlResults(self->lookupIndex(txn, context, uri, name,
							parent_uri, parent_name,
							index, value, flags));
	}
SWIGINTERN XmlStatistics *XmlContainer_lookupStatistics__SWIG_0(XmlContainer *self,std::string const &uri,std::string const &name,std::string const &index,XmlValue const &value=XmlValue()){
		return new XmlStatistics(self->lookupStatistics(uri, name, index,
								value));
	}
SWIGINTERN XmlStatistics *XmlContainer_lookupStatistics__SWIG_2(XmlContainer *self,std::string const &uri,std::string const &name,std::string const &parent_uri,std::string const &parent_name,std::string const &index,XmlValue const &value=XmlValue()){
		return new XmlStatistics(self->lookupStatistics(uri, name,
								parent_uri,
								parent_name,
								index, value));
	}
SWIGINTERN XmlStatistics *XmlContainer_lookupStatistics__SWIG_4(XmlContainer *self,XmlTransaction &txn,std::string const &uri,std::string const &name,std::string const &index,XmlValue const &value=XmlValue()){
		return new XmlStatistics(self->lookupStatistics(txn, uri, name,
								index, value));
	}
SWIGINTERN XmlStatistics *XmlContainer_lookupStatistics__SWIG_6(XmlContainer *self,XmlTransaction &txn,std::string const &uri,std::string const &name,std::string const &parent_uri,std::string const &parent_name,std::string const &index,XmlValue const &value=XmlValue()){
		return new XmlStatistics(self->lookupStatistics(txn, uri, name,
								parent_uri,
								parent_name,
								index, value));
	}
SWIGINTERN std::string XmlContainer_getContainerConfigData(XmlContainer *self,int data[]){
		XmlContainerConfig config = self->getContainerConfig();
		data[0] = config.getMode();
		data[1] = config.getContainerType();
		data[2] = (*config).getXmlFlags();
		data[3] = (*config).getDbOpenFlags();
		data[4] = config.getPageSize();
		data[5] = config.getSequenceIncrement();
		data[6] = (*config).getDbSetFlags();
		data[7] = (*config).getSeqFlags();
		std::string compName(config.getCompressionName());
		return compName;
	}
SWIGINTERN void XmlContainer_setAutoIndexing__SWIG_0(XmlContainer *self,bool value){
	    XmlUpdateContext uc = self->getManager().createUpdateContext();
	    self->setAutoIndexing(value, uc);
	}
SWIGINTERN void XmlContainer_setAutoIndexing__SWIG_1(XmlContainer *self,XmlTransaction &txn,bool value){
		XmlUpdateContext uc = self->getManager().createUpdateContext();
		self->setAutoIndexing(txn, value, uc);
	}
SWIGINTERN void XmlContainer_setIndexSpecification__SWIG_0(XmlContainer *self,XmlIndexSpecification const &index){
		XmlUpdateContext uc = self->getManager().createUpdateContext();
		self->setIndexSpecification(index, uc);
	}
SWIGINTERN void XmlContainer_addIndex__SWIG_0(XmlContainer *self,std::string const &uri,std::string const &name,std::string const &index){
		XmlUpdateContext uc = self->getManager().createUpdateContext();
		self->addIndex(uri, name, index, uc);
	}
SWIGINTERN void XmlContainer_addIndex__SWIG_1(XmlContainer *self,std::string const &uri,std::string const &name,enum XmlIndexSpecification::Type indexType,enum XmlValue::Type syntaxType){
		XmlUpdateContext uc = self->getManager().createUpdateContext();
		self->addIndex(uri, name, indexType, syntaxType, uc);
	}
SWIGINTERN void XmlContainer_deleteIndex__SWIG_0(XmlContainer *self,std::string const &uri,std::string const &name,std::string const &index){
		XmlUpdateContext uc = self->getManager().createUpdateContext();
		self->deleteIndex(uri, name, index, uc);
	}
SWIGINTERN void XmlContainer_replaceIndex__SWIG_0(XmlContainer *self,std::string const &uri,std::string const &name,std::string const &index){
		XmlUpdateContext uc = self->getManager().createUpdateContext();
		self->replaceIndex(uri, name, index, uc);
	}
SWIGINTERN void XmlContainer_addDefaultIndex__SWIG_0(XmlContainer *self,std::string const &index){
		XmlUpdateContext uc = self->getManager().createUpdateContext();
		self->addDefaultIndex(index, uc);
	}
SWIGINTERN void XmlContainer_deleteDefaultIndex__SWIG_0(XmlContainer *self,std::string const &index){
		XmlUpdateContext uc = self->getManager().createUpdateContext();
		self->deleteDefaultIndex(index, uc);
	}
SWIGINTERN void XmlContainer_replaceDefaultIndex__SWIG_0(XmlContainer *self,std::string const &index){
		XmlUpdateContext uc = self->getManager().createUpdateContext();
		self->replaceDefaultIndex(index, uc);
	}
SWIGINTERN void XmlContainer_setIndexSpecification__SWIG_1(XmlContainer *self,XmlTransaction &txn,XmlIndexSpecification const &index){
		XmlUpdateContext uc = self->getManager().createUpdateContext();
		self->setIndexSpecification(txn, index, uc);
	}
SWIGINTERN void XmlContainer_addIndex__SWIG_2(XmlContainer *self,XmlTransaction &txn,std::string const &uri,std::string const &name,std::string const &index){
		XmlUpdateContext uc = self->getManager().createUpdateContext();
		self->addIndex(txn, uri, name, index, uc);
	}
SWIGINTERN void XmlContainer_addIndex__SWIG_3(XmlContainer *self,XmlTransaction &txn,std::string const &uri,std::string const &name,enum XmlIndexSpecification::Type indexType,enum XmlValue::Type syntaxType){
		XmlUpdateContext uc = self->getManager().createUpdateContext();
		self->addIndex(txn, uri, name, indexType, syntaxType, uc);
	}
SWIGINTERN void XmlContainer_deleteIndex__SWIG_1(XmlContainer *self,XmlTransaction &txn,std::string const &uri,std::string const &name,std::string const &index){
		XmlUpdateContext uc = self->getManager().createUpdateContext();
		self->replaceIndex(txn, uri, name, index, uc);
	}
SWIGINTERN void XmlContainer_replaceIndex__SWIG_1(XmlContainer *self,XmlTransaction &txn,std::string const &uri,std::string const &name,std::string const &index){
		XmlUpdateContext uc = self->getManager().createUpdateContext();
		self->replaceIndex(txn, uri, name, index, uc);
	}
SWIGINTERN void XmlContainer_addDefaultIndex__SWIG_1(XmlContainer *self,XmlTransaction &txn,std::string const &index){
		XmlUpdateContext uc = self->getManager().createUpdateContext();
		self->addDefaultIndex(txn, index, uc);
	}
SWIGINTERN void XmlContainer_deleteDefaultIndex__SWIG_1(XmlContainer *self,XmlTransaction &txn,std::string const &index){
		XmlUpdateContext uc = self->getManager().createUpdateContext();
		self->deleteDefaultIndex(txn, index, uc);
	}
SWIGINTERN void XmlContainer_replaceDefaultIndex__SWIG_1(XmlContainer *self,XmlTransaction &txn,std::string const &index){
		XmlUpdateContext uc = self->getManager().createUpdateContext();
		self->replaceDefaultIndex(txn, index, uc);
	}
SWIGINTERN std::string XmlContainer_putDocument__SWIG_0(XmlContainer *self,std::string const &name,std::string const &contents,u_int32_t flags){
		XmlUpdateContext uc = self->getManager().createUpdateContext();
		return self->putDocument(name, contents, uc, flags);
	}
SWIGINTERN std::string XmlContainer_putDocument__SWIG_1(XmlContainer *self,std::string const &name,XmlEventReader &reader,u_int32_t flags){
		XmlUpdateContext uc = self->getManager().createUpdateContext();
		return self->putDocument(name, reader, uc, flags);
	}
SWIGINTERN std::string XmlContainer_putDocument__SWIG_2(XmlContainer *self,std::string const &name,XmlInputStream *input,u_int32_t flags){
		XmlUpdateContext uc = self->getManager().createUpdateContext();
		return self->putDocument(name, input, uc, flags);
	}
SWIGINTERN std::string XmlContainer_putDocument__SWIG_3(XmlContainer *self,XmlTransaction &txn,std::string const &name,XmlInputStream *input,u_int32_t flags){
		XmlUpdateContext uc = self->getManager().createUpdateContext();
		return self->putDocument(txn, name, input, uc, flags);
	}
SWIGINTERN std::string XmlContainer_putDocument__SWIG_4(XmlContainer *self,XmlTransaction &txn,std::string const &name,std::string const &contents,u_int32_t flags){
		XmlUpdateContext uc = self->getManager().createUpdateContext();
		return self->putDocument(txn, name, contents, uc, flags);
	}
SWIGINTERN std::string XmlContainer_putDocument__SWIG_5(XmlContainer *self,XmlTransaction &txn,std::string const &name,XmlEventReader &reader,u_int32_t flags){
		XmlUpdateContext uc = self->getManager().createUpdateContext();
		return self->putDocument(txn, name, reader, uc, flags);
	}
SWIGINTERN XmlDocument XmlContainer_getDocumentInternal__SWIG_0(XmlContainer *self,std::string const &name,u_int32_t flags){
		return self->getDocument(name, flags);
	}
SWIGINTERN XmlDocument XmlContainer_getDocumentInternal__SWIG_1(XmlContainer *self,XmlTransaction &txn,std::string const &name,u_int32_t flags){
		return self->getDocument(txn, name, flags);
	}
SWIGINTERN XmlDocument &XmlContainer_putDocumentInternal__SWIG_0(XmlContainer *self,XmlDocument &document,u_int32_t flags){
	    XmlUpdateContext context = self->getManager().createUpdateContext();
	    self->putDocument(document, context, flags);
	    return document;
	}
SWIGINTERN XmlDocument &XmlContainer_putDocumentInternal__SWIG_1(XmlContainer *self,XmlTransaction &txn,XmlDocument &document,u_int32_t flags){
	    XmlUpdateContext context = self->getManager().createUpdateContext();
	    self->putDocument(txn, document, context, flags);
	    return document;
	}
SWIGINTERN XmlEventWriter &XmlContainer_putDocumentAsEventWriter__SWIG_0(XmlContainer *self,XmlDocument &document,u_int32_t flags,u_int64_t *ids){
	XmlUpdateContext context = self->getManager().createUpdateContext();
	XmlEventWriter &writer = self->putDocumentAsEventWriter(document, context, flags);
	ids[1] = (*(document)).getContainerID();
	ids[0] = *(u_int64_t *)((*(document)).getID().rawPtr());
	return writer;
    }
SWIGINTERN XmlEventWriter &XmlContainer_putDocumentAsEventWriter__SWIG_1(XmlContainer *self,XmlTransaction &txn,XmlDocument &document,u_int32_t flags,u_int64_t *ids){
	XmlUpdateContext context = self->getManager().createUpdateContext();
	XmlEventWriter &writer = self->putDocumentAsEventWriter(txn, document, context, flags);
	ids[1] = (*(document)).getContainerID();
	ids[0] = *(u_int64_t *)((*(document)).getID().rawPtr());
	return writer;
    }
SWIGINTERN void XmlContainer_deleteDocument__SWIG_0(XmlContainer *self,std::string const &name){
		XmlUpdateContext uc = self->getManager().createUpdateContext();
	    self->deleteDocument(name, uc);
    }
SWIGINTERN void XmlContainer_deleteDocument__SWIG_1(XmlContainer *self,XmlTransaction &txn,std::string const &name){
		XmlUpdateContext context = self->getManager().createUpdateContext();
	    self->deleteDocument(txn, name, context);
	}
SWIGINTERN XmlDocument &XmlContainer_deleteDocumentInternal__SWIG_0(XmlContainer *self,XmlDocument &document){
	    XmlUpdateContext context = self->getManager().createUpdateContext();
	    self->deleteDocument(document, context);
	    return document;
	}
SWIGINTERN XmlDocument &XmlContainer_deleteDocumentInternal__SWIG_1(XmlContainer *self,XmlTransaction &txn,XmlDocument &document){
	    XmlUpdateContext context = self->getManager().createUpdateContext();
	    self->deleteDocument(txn, document, context);
	    return document;
	}
SWIGINTERN XmlDocument &XmlContainer_updateDocumentInternal__SWIG_0(XmlContainer *self,XmlDocument &document){
	    XmlUpdateContext context = self->getManager().createUpdateContext();
	    self->updateDocument(document, context);
	    return document;
	}
SWIGINTERN XmlDocument &XmlContainer_updateDocumentInternal__SWIG_1(XmlContainer *self,XmlTransaction &txn,XmlDocument &document){
	    XmlUpdateContext context = self->getManager().createUpdateContext();
	    self->updateDocument(txn, document, context);
	    return document;
	}
SWIGINTERN XmlResults XmlContainer_getNode__SWIG_0(XmlContainer *self,std::string const &name){
	XmlValue value = self->getNode(name, 0);
	XmlResults result = self->getManager().createResults();
	result.add(value);
	return result;
    }
SWIGINTERN XmlResults XmlContainer_getNode__SWIG_1(XmlContainer *self,XmlTransaction &txn,std::string const &name,u_int32_t flags){
	XmlValue value = self->getNode(txn, name, flags);
	XmlResults result = new ValueResults(self->getManager(), txn);
	result.add(value);
	return result;
    }
SWIGINTERN XmlResults *XmlResults_copy(XmlResults const &results){
	return new XmlResults(results);
    }
SWIGINTERN XmlValue XmlResults_nextInternal(XmlResults *self){
	XmlValue value;
	if (self->next(value)){
	    if(value.isNode()){
		if((*value).getDbXmlNodeValueObject()
			 && value.asDocument()
			 && (*value.asDocument()).getDbMinder() != 0
			 && (**self).getDbMinder() == 0){
		    (**self).getDbMinder() = (*value.asDocument()).getDbMinder();
		}
		if(!(*value).getRawNodeValueObject())
		    return RawNodeValue::create(value, *self);
	    }
	}
	return value;
    }
SWIGINTERN XmlValue XmlResults_previousInternal(XmlResults *self){
	XmlValue value;
	if (self->previous(value)){
	    if(value.isNode()){
		if ((*value).getDbXmlNodeValueObject()
			 && value.asDocument()
			 && (*value.asDocument()).getDbMinder() != 0
			 && (**self).getDbMinder() == 0){
		    (**self).getDbMinder() = (*value.asDocument()).getDbMinder();
		}
		if(!(*value).getRawNodeValueObject())
		    return RawNodeValue::create(value, *self);
	    }
	}
	return value;
    }
SWIGINTERN XmlValue XmlResults_peekInternal(XmlResults *self){
	XmlValue value;
	if (self->peek(value)){
	    if(value.isNode()){
		if((*value).getDbXmlNodeValueObject()
			 && value.asDocument()
			 && (*value.asDocument()).getDbMinder() != 0
			 && (**self).getDbMinder() == 0){
		    (**self).getDbMinder() = (*value.asDocument()).getDbMinder();
		}
		if(!(*value).getRawNodeValueObject())
		    return RawNodeValue::create(value, *self);
	    }
	}
	return value;
    }
SWIGINTERN void XmlResults_addInternal(XmlResults *self,XmlValue const &value){
	const RawNodeValue *raw = (*value).getRawNodeValueObject();
	if(raw){
	    Transaction *txn = raw->getTransaction();
	    if(txn){
		Transaction *resultsTxn = (**self).getOperationContext().txn();
		if(resultsTxn){
		    if(&*txn != &*resultsTxn){
			throw XmlException(XmlException::TRANSACTION_ERROR, "You should not use multiple transactions.");
		    }
		}else
		    (**self).getOperationContext().set(txn); 
	    }
	}
	self->add(value);
    }
SWIGINTERN XmlDocument XmlResults_nextDocumentInternal(XmlResults *self){
	XmlDocument cdoc;
	if(self->next(cdoc))
	    return cdoc;
	return 0;
    }
SWIGINTERN XmlDocument XmlResults_previousDocumentInternal(XmlResults *self){
	XmlDocument cdoc;
	if(self->previous(cdoc))
	    return cdoc;
	return 0;
    }
SWIGINTERN XmlDocument XmlResults_peekDocumentInternal(XmlResults *self){
	XmlDocument cdoc;
	if(self->peek(cdoc))
	    return cdoc;
	return 0;
    }
SWIGINTERN XmlIndexDeclaration *XmlIndexSpecification_find(XmlIndexSpecification *self,std::string const &uri,std::string const &name){
		XmlIndexDeclaration *idecl =
			new XmlIndexDeclaration(uri, name, "");
		if (self->find(idecl->uri, idecl->name, idecl->index))
			return idecl;
		else {
			delete idecl;
			return NULL;
		}
	}
SWIGINTERN XmlIndexDeclaration *XmlIndexSpecification_next(XmlIndexSpecification *self){
		XmlIndexDeclaration *idecl = new XmlIndexDeclaration;
		if (self->next(idecl->uri, idecl->name, idecl->index))
			return idecl;
		else {
			delete idecl;
			return NULL;
		}
	}
SWIGINTERN XmlResults *XmlQueryExpression_execute__SWIG_0(XmlQueryExpression const *self,XmlQueryContext &context,u_int32_t flags=0){
		return new XmlResults(self->execute(context, flags));
	}
SWIGINTERN XmlResults *XmlQueryExpression_execute__SWIG_2(XmlQueryExpression const *self,XmlValue const &contextItem,XmlQueryContext &context,u_int32_t flags=0){
		return new XmlResults(
			self->execute(contextItem, context, flags));
	}
SWIGINTERN XmlResults *XmlQueryExpression_execute__SWIG_4(XmlQueryExpression const *self,XmlTransaction &txn,XmlQueryContext &context,u_int32_t flags=0){
		return new XmlResults(self->execute(txn, context, flags));
	}
SWIGINTERN XmlResults *XmlQueryExpression_execute__SWIG_6(XmlQueryExpression const *self,XmlTransaction &txn,XmlValue const &contextItem,XmlQueryContext &context,u_int32_t flags=0){
		return new XmlResults(self->execute(txn, contextItem,
						    context, flags));
	}
SWIGINTERN void XmlInputStream_freeMemory(XmlInputStream *self){
		delete self;
	}
SWIGINTERN unsigned char const *XmlEventReader_getValue(XmlEventReader const *self){
		size_t len;
		return self->getValue(len);
	}
SWIGINTERN void XmlEventWriter_writeText__SWIG_1(XmlEventWriter *self,enum XmlEventReader::XmlEventType type,unsigned char const *text){
		self->writeText(type, text, 0);
	}
SWIGINTERN void XmlEventWriter_writeDTD__SWIG_1(XmlEventWriter *self,unsigned char const *dtd){
		self->writeDTD(dtd, 0);
	}


/* ---------------------------------------------------
 * C++ director class methods
 * --------------------------------------------------- */

#include "dbxml_java_wrap.h"

SwigDirector_XmlInputStream::SwigDirector_XmlInputStream(JNIEnv *jenv) : XmlInputStream(), Swig::Director(jenv) {
}

SwigDirector_XmlInputStream::~SwigDirector_XmlInputStream() {
  swig_disconnect_director_self("swigDirectorDisconnect");
}


unsigned int SwigDirector_XmlInputStream::curPos() const {
  unsigned int c_result = SwigValueInit< unsigned int >() ;
  jlong jresult = 0 ;
  JNIEnvWrapper swigjnienv(this) ;
  JNIEnv * jenv = swigjnienv.getJNIEnv() ;
  jobject swigjobj = (jobject) NULL ;
  
  if (!swig_override[0]) {
    SWIG_JavaThrowException(JNIEnvWrapper(this).getJNIEnv(), SWIG_JavaDirectorPureVirtual, "Attempted to invoke pure virtual method XmlInputStream::curPos.");
    return c_result;
  }
  swigjobj = swig_get_self(jenv);
  if (swigjobj && jenv->IsSameObject(swigjobj, NULL) == JNI_FALSE) {
    jresult = (jlong) jenv->CallStaticLongMethod(Swig::jclass_dbxml_javaJNI, Swig::director_methids[0], swigjobj);
    if (jenv->ExceptionOccurred()) return c_result;
    c_result = (unsigned int)jresult; 
  } else {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null upcall object");
  }
  if (swigjobj) jenv->DeleteLocalRef(swigjobj);
  return c_result;
}

unsigned int SwigDirector_XmlInputStream::readBytes(char *toFill, unsigned int const maxToRead) {
  unsigned int c_result = SwigValueInit< unsigned int >() ;
  jlong jresult = 0 ;
  JNIEnvWrapper swigjnienv(this) ;
  JNIEnv * jenv = swigjnienv.getJNIEnv() ;
  jobject swigjobj = (jobject) NULL ;
  jbyteArray jtoFill = 0 ;
  jlong jmaxToRead  ;
  
  if (!swig_override[1]) {
    SWIG_JavaThrowException(JNIEnvWrapper(this).getJNIEnv(), SWIG_JavaDirectorPureVirtual, "Attempted to invoke pure virtual method XmlInputStream::readBytes.");
    return c_result;
  }
  swigjobj = swig_get_self(jenv);
  if (swigjobj && jenv->IsSameObject(swigjobj, NULL) == JNI_FALSE) {
    jtoFill = jenv->NewByteArray((jsize)maxToRead);
    XmlInputStream_ReadBytes_InOutByteArray arg_guard1(jenv, jtoFill, toFill, c_result);
    
    jmaxToRead = (jlong) maxToRead;
    jresult = (jlong) jenv->CallStaticLongMethod(Swig::jclass_dbxml_javaJNI, Swig::director_methids[1], swigjobj, jtoFill, jmaxToRead);
    if (jenv->ExceptionOccurred()) return c_result;
    c_result = (unsigned int)jresult; 
  } else {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null upcall object");
  }
  if (swigjobj) jenv->DeleteLocalRef(swigjobj);
  return c_result;
}

void SwigDirector_XmlInputStream::swig_connect_director(JNIEnv *jenv, jobject jself, jclass jcls, bool swig_mem_own, bool weak_global) {
  static struct {
    const char *mname;
    const char *mdesc;
    jmethodID base_methid;
  } methods[] = {
    {
      "curPos", "()J", NULL 
    },
    {
      "readBytes", "([BJ)J", NULL 
    }
  };
  
  static jclass baseclass = 0 ;
  
  if (swig_set_self(jenv, jself, swig_mem_own, weak_global)) {
    if (!baseclass) {
      baseclass = jenv->FindClass("com/sleepycat/dbxml/XmlInputStream");
      if (!baseclass) return;
      baseclass = (jclass) jenv->NewGlobalRef(baseclass);
    }
    bool derived = (jenv->IsSameObject(baseclass, jcls) ? false : true);
    for (int i = 0; i < 2; ++i) {
      if (!methods[i].base_methid) {
        methods[i].base_methid = jenv->GetMethodID(baseclass, methods[i].mname, methods[i].mdesc);
        if (!methods[i].base_methid) return;
      }
      swig_override[i] = false;
      if (derived) {
        jmethodID methid = jenv->GetMethodID(jcls, methods[i].mname, methods[i].mdesc);
        swig_override[i] = (methid != methods[i].base_methid);
        jenv->ExceptionClear();
      }
    }
  }
}


SwigDirector_XmlResolver::SwigDirector_XmlResolver(JNIEnv *jenv) : XmlResolver(), Swig::Director(jenv) {
}

SwigDirector_XmlResolver::~SwigDirector_XmlResolver() {
  swig_disconnect_director_self("swigDirectorDisconnect");
}


bool SwigDirector_XmlResolver::resolveDocument(XmlTransaction *txn, XmlManager &mgr, std::string const &uri, XmlValue &reslt) const {
  bool c_result = SwigValueInit< bool >() ;
  jboolean jresult = 0 ;
  JNIEnvWrapper swigjnienv(this) ;
  JNIEnv * jenv = swigjnienv.getJNIEnv() ;
  jobject swigjobj = (jobject) NULL ;
  jlong jtxn = 0 ;
  jlong jmgr = 0 ;
  jstring juri = 0 ;
  jobject jreslt = 0 ;
  
  if (!swig_override[0]) {
    return XmlResolver::resolveDocument(txn,mgr,uri,reslt);
  }
  swigjobj = swig_get_self(jenv);
  if (swigjobj && jenv->IsSameObject(swigjobj, NULL) == JNI_FALSE) {
    *((XmlTransaction **)&jtxn) = (XmlTransaction *) txn; 
    *(XmlManager **)&jmgr = (XmlManager *) &mgr; 
    juri = jenv->NewStringUTF((&uri)->c_str()); 
    
    jreslt = jenv->NewObject(xml_valuedecl_class, xml_valuenull_construct);
#if 1
    jresult = (jboolean) jenv->CallStaticBooleanMethod(Swig::jclass_dbxml_javaJNI, Swig::director_methids[2], swigjobj, jtxn, jmgr, juri, jreslt);
#else
    jresult = (jboolean) jenv->CallStaticBooleanMethod(Swig::jclass_dbxml_javaJNI, Swig::director_methids[2], jobj, jtxn, jmgr, juri, jreslt);
#endif
    if (jenv->ExceptionOccurred()) return c_result;
    c_result = jresult ? true : false; 
  } else {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null upcall object");
  }
#if 1
  if (swigjobj) jenv->DeleteLocalRef(swigjobj);
#else
  if (jobj) jenv->DeleteLocalRef(jobj);
#endif
  jclass cls = jenv->GetObjectClass(jreslt);
  jmethodID mid = jenv->GetMethodID(cls, "asDocument", "()Lcom/sleepycat/dbxml/XmlDocument;");
  jobject jdoc = jenv->CallObjectMethod(jreslt, mid);
  if (jdoc) {
    XmlDocument cdoc = createCPPXmlDocument(jenv, jdoc);
    XmlValue val(cdoc);
    reslt = val;
  }
  if (jreslt) jenv->DeleteLocalRef(jreslt);
  return c_result;
  if (true) {
    jresult = (jboolean) jenv->CallStaticBooleanMethod(Swig::jclass_dbxml_javaJNI, Swig::director_methids[2], swigjobj, jtxn, jmgr, juri, jreslt);
    if (jenv->ExceptionOccurred()) return c_result;
    c_result = jresult ? true : false; 
  } else {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null upcall object");
  }
  if (swigjobj) jenv->DeleteLocalRef(swigjobj);
  return c_result;
}

bool SwigDirector_XmlResolver::resolveCollection(XmlTransaction *txn, XmlManager &mgr, std::string const &uri, XmlResults &reslt) const {
  bool c_result = SwigValueInit< bool >() ;
  jboolean jresult = 0 ;
  JNIEnvWrapper swigjnienv(this) ;
  JNIEnv * jenv = swigjnienv.getJNIEnv() ;
  jobject swigjobj = (jobject) NULL ;
  jlong jtxn = 0 ;
  jlong jmgr = 0 ;
  jstring juri = 0 ;
  jlong jreslt = 0 ;
  
  if (!swig_override[1]) {
    return XmlResolver::resolveCollection(txn,mgr,uri,reslt);
  }
  swigjobj = swig_get_self(jenv);
  if (swigjobj && jenv->IsSameObject(swigjobj, NULL) == JNI_FALSE) {
    *((XmlTransaction **)&jtxn) = (XmlTransaction *) txn; 
    *(XmlManager **)&jmgr = (XmlManager *) &mgr; 
    juri = jenv->NewStringUTF((&uri)->c_str()); 
    *(XmlResults **)&jreslt = (XmlResults *) &reslt; 
    jresult = (jboolean) jenv->CallStaticBooleanMethod(Swig::jclass_dbxml_javaJNI, Swig::director_methids[3], swigjobj, jtxn, jmgr, juri, jreslt);
    if (jenv->ExceptionOccurred()) return c_result;
    c_result = jresult ? true : false; 
  } else {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null upcall object");
  }
  if (swigjobj) jenv->DeleteLocalRef(swigjobj);
  return c_result;
}

XmlInputStream *SwigDirector_XmlResolver::resolveSchema(XmlTransaction *txn, XmlManager &mgr, std::string const &schemaLocation, std::string const &nameSpace) const {
  XmlInputStream *c_result = 0 ;
  jlong jresult = 0 ;
  JNIEnvWrapper swigjnienv(this) ;
  JNIEnv * jenv = swigjnienv.getJNIEnv() ;
  jobject swigjobj = (jobject) NULL ;
  jlong jtxn = 0 ;
  jlong jmgr = 0 ;
  jstring jschemaLocation = 0 ;
  jstring jnameSpace = 0 ;
  
  if (!swig_override[2]) {
    return XmlResolver::resolveSchema(txn,mgr,schemaLocation,nameSpace);
  }
  swigjobj = swig_get_self(jenv);
  if (swigjobj && jenv->IsSameObject(swigjobj, NULL) == JNI_FALSE) {
    *((XmlTransaction **)&jtxn) = (XmlTransaction *) txn; 
    *(XmlManager **)&jmgr = (XmlManager *) &mgr; 
    jschemaLocation = jenv->NewStringUTF((&schemaLocation)->c_str()); 
    jnameSpace = jenv->NewStringUTF((&nameSpace)->c_str()); 
    jresult = (jlong) jenv->CallStaticLongMethod(Swig::jclass_dbxml_javaJNI, Swig::director_methids[4], swigjobj, jtxn, jmgr, jschemaLocation, jnameSpace);
    if (jenv->ExceptionOccurred()) return c_result;
    c_result = *(XmlInputStream **)&jresult; 
  } else {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null upcall object");
  }
  if (swigjobj) jenv->DeleteLocalRef(swigjobj);
  return c_result;
}

XmlInputStream *SwigDirector_XmlResolver::resolveEntity(XmlTransaction *txn, XmlManager &mgr, std::string const &systemId, std::string const &publicId) const {
  XmlInputStream *c_result = 0 ;
  jlong jresult = 0 ;
  JNIEnvWrapper swigjnienv(this) ;
  JNIEnv * jenv = swigjnienv.getJNIEnv() ;
  jobject swigjobj = (jobject) NULL ;
  jlong jtxn = 0 ;
  jlong jmgr = 0 ;
  jstring jsystemId = 0 ;
  jstring jpublicId = 0 ;
  
  if (!swig_override[3]) {
    return XmlResolver::resolveEntity(txn,mgr,systemId,publicId);
  }
  swigjobj = swig_get_self(jenv);
  if (swigjobj && jenv->IsSameObject(swigjobj, NULL) == JNI_FALSE) {
    *((XmlTransaction **)&jtxn) = (XmlTransaction *) txn; 
    *(XmlManager **)&jmgr = (XmlManager *) &mgr; 
    jsystemId = jenv->NewStringUTF((&systemId)->c_str()); 
    jpublicId = jenv->NewStringUTF((&publicId)->c_str()); 
    jresult = (jlong) jenv->CallStaticLongMethod(Swig::jclass_dbxml_javaJNI, Swig::director_methids[5], swigjobj, jtxn, jmgr, jsystemId, jpublicId);
    if (jenv->ExceptionOccurred()) return c_result;
    c_result = *(XmlInputStream **)&jresult; 
  } else {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null upcall object");
  }
  if (swigjobj) jenv->DeleteLocalRef(swigjobj);
  return c_result;
}

bool SwigDirector_XmlResolver::resolveModuleLocation(XmlTransaction *txn, XmlManager &mgr, std::string const &nameSpace, XmlResults &reslt) const {
  bool c_result = SwigValueInit< bool >() ;
  jboolean jresult = 0 ;
  JNIEnvWrapper swigjnienv(this) ;
  JNIEnv * jenv = swigjnienv.getJNIEnv() ;
  jobject swigjobj = (jobject) NULL ;
  jlong jtxn = 0 ;
  jlong jmgr = 0 ;
  jstring jnameSpace = 0 ;
  jlong jreslt = 0 ;
  
  if (!swig_override[4]) {
    return XmlResolver::resolveModuleLocation(txn,mgr,nameSpace,reslt);
  }
  swigjobj = swig_get_self(jenv);
  if (swigjobj && jenv->IsSameObject(swigjobj, NULL) == JNI_FALSE) {
    *((XmlTransaction **)&jtxn) = (XmlTransaction *) txn; 
    *(XmlManager **)&jmgr = (XmlManager *) &mgr; 
    jnameSpace = jenv->NewStringUTF((&nameSpace)->c_str()); 
    *(XmlResults **)&jreslt = (XmlResults *) &reslt; 
    jresult = (jboolean) jenv->CallStaticBooleanMethod(Swig::jclass_dbxml_javaJNI, Swig::director_methids[6], swigjobj, jtxn, jmgr, jnameSpace, jreslt);
    if (jenv->ExceptionOccurred()) return c_result;
    c_result = jresult ? true : false; 
  } else {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null upcall object");
  }
  if (swigjobj) jenv->DeleteLocalRef(swigjobj);
  return c_result;
}

XmlInputStream *SwigDirector_XmlResolver::resolveModule(XmlTransaction *txn, XmlManager &mgr, std::string const &moduleLocation, std::string const &nameSpace) const {
  XmlInputStream *c_result = 0 ;
  jlong jresult = 0 ;
  JNIEnvWrapper swigjnienv(this) ;
  JNIEnv * jenv = swigjnienv.getJNIEnv() ;
  jobject swigjobj = (jobject) NULL ;
  jlong jtxn = 0 ;
  jlong jmgr = 0 ;
  jstring jmoduleLocation = 0 ;
  jstring jnameSpace = 0 ;
  
  if (!swig_override[5]) {
    return XmlResolver::resolveModule(txn,mgr,moduleLocation,nameSpace);
  }
  swigjobj = swig_get_self(jenv);
  if (swigjobj && jenv->IsSameObject(swigjobj, NULL) == JNI_FALSE) {
    *((XmlTransaction **)&jtxn) = (XmlTransaction *) txn; 
    *(XmlManager **)&jmgr = (XmlManager *) &mgr; 
    jmoduleLocation = jenv->NewStringUTF((&moduleLocation)->c_str()); 
    jnameSpace = jenv->NewStringUTF((&nameSpace)->c_str()); 
    jresult = (jlong) jenv->CallStaticLongMethod(Swig::jclass_dbxml_javaJNI, Swig::director_methids[7], swigjobj, jtxn, jmgr, jmoduleLocation, jnameSpace);
    if (jenv->ExceptionOccurred()) return c_result;
    c_result = *(XmlInputStream **)&jresult; 
  } else {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null upcall object");
  }
  if (swigjobj) jenv->DeleteLocalRef(swigjobj);
  return c_result;
}

XmlExternalFunction *SwigDirector_XmlResolver::resolveExternalFunction(XmlTransaction *txn, XmlManager &mgr, std::string const &uri, std::string const &name, size_t numberOfArgs) const {
  XmlExternalFunction *c_result = 0 ;
  jlong jresult = 0 ;
  JNIEnvWrapper swigjnienv(this) ;
  JNIEnv * jenv = swigjnienv.getJNIEnv() ;
  jobject swigjobj = (jobject) NULL ;
  jlong jtxn = 0 ;
  jlong jmgr = 0 ;
  jstring juri = 0 ;
  jstring jname = 0 ;
  jint jnumberOfArgs  ;
  
  if (!swig_override[6]) {
    return XmlResolver::resolveExternalFunction(txn,mgr,uri,name,numberOfArgs);
  }
  swigjobj = swig_get_self(jenv);
  if (swigjobj && jenv->IsSameObject(swigjobj, NULL) == JNI_FALSE) {
    *((XmlTransaction **)&jtxn) = (XmlTransaction *) txn; 
    *(XmlManager **)&jmgr = (XmlManager *) &mgr; 
    juri = jenv->NewStringUTF((&uri)->c_str()); 
    jname = jenv->NewStringUTF((&name)->c_str()); 
    jnumberOfArgs = (jint) numberOfArgs;
    jresult = (jlong) jenv->CallStaticLongMethod(Swig::jclass_dbxml_javaJNI, Swig::director_methids[8], swigjobj, jtxn, jmgr, juri, jname, jnumberOfArgs);
    if (jenv->ExceptionOccurred()) return c_result;
    c_result = *(XmlExternalFunction **)&jresult; 
  } else {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null upcall object");
  }
  if (swigjobj) jenv->DeleteLocalRef(swigjobj);
  return c_result;
}

void SwigDirector_XmlResolver::swig_connect_director(JNIEnv *jenv, jobject jself, jclass jcls, bool swig_mem_own, bool weak_global) {
  static struct {
    const char *mname;
    const char *mdesc;
    jmethodID base_methid;
  } methods[] = {
    {
      "resolveDocument", "(Lcom/sleepycat/dbxml/XmlTransaction;Lcom/sleepycat/dbxml/XmlManager;Ljava/lang/String;Lcom/sleepycat/dbxml/XmlValue;)Z", NULL 
    },
    {
      "resolveCollection", "(Lcom/sleepycat/dbxml/XmlTransaction;Lcom/sleepycat/dbxml/XmlManager;Ljava/lang/String;Lcom/sleepycat/dbxml/XmlResults;)Z", NULL 
    },
    {
      "resolveSchema", "(Lcom/sleepycat/dbxml/XmlTransaction;Lcom/sleepycat/dbxml/XmlManager;Ljava/lang/String;Ljava/lang/String;)Lcom/sleepycat/dbxml/XmlInputStream;", NULL 
    },
    {
      "resolveEntity", "(Lcom/sleepycat/dbxml/XmlTransaction;Lcom/sleepycat/dbxml/XmlManager;Ljava/lang/String;Ljava/lang/String;)Lcom/sleepycat/dbxml/XmlInputStream;", NULL 
    },
    {
      "resolveModuleLocation", "(Lcom/sleepycat/dbxml/XmlTransaction;Lcom/sleepycat/dbxml/XmlManager;Ljava/lang/String;Lcom/sleepycat/dbxml/XmlResults;)Z", NULL 
    },
    {
      "resolveModule", "(Lcom/sleepycat/dbxml/XmlTransaction;Lcom/sleepycat/dbxml/XmlManager;Ljava/lang/String;Ljava/lang/String;)Lcom/sleepycat/dbxml/XmlInputStream;", NULL 
    },
    {
      "resolveExternalFunction", "(Lcom/sleepycat/dbxml/XmlTransaction;Lcom/sleepycat/dbxml/XmlManager;Ljava/lang/String;Ljava/lang/String;I)Lcom/sleepycat/dbxml/XmlExternalFunctionBase;", NULL 
    }
  };
  
  static jclass baseclass = 0 ;
  
  if (swig_set_self(jenv, jself, swig_mem_own, weak_global)) {
    if (!baseclass) {
      baseclass = jenv->FindClass("com/sleepycat/dbxml/XmlResolver");
      if (!baseclass) return;
      baseclass = (jclass) jenv->NewGlobalRef(baseclass);
    }
    bool derived = (jenv->IsSameObject(baseclass, jcls) ? false : true);
    for (int i = 0; i < 7; ++i) {
      if (!methods[i].base_methid) {
        methods[i].base_methid = jenv->GetMethodID(baseclass, methods[i].mname, methods[i].mdesc);
        if (!methods[i].base_methid) return;
      }
      swig_override[i] = false;
      if (derived) {
        jmethodID methid = jenv->GetMethodID(jcls, methods[i].mname, methods[i].mdesc);
        swig_override[i] = (methid != methods[i].base_methid);
        jenv->ExceptionClear();
      }
    }
  }
}


SwigDirector_XmlExternalFunctionBase::SwigDirector_XmlExternalFunctionBase(JNIEnv *jenv) : XmlExternalFunction(), Swig::Director(jenv) {
}

SwigDirector_XmlExternalFunctionBase::~SwigDirector_XmlExternalFunctionBase() {
  swig_disconnect_director_self("swigDirectorDisconnect");
}


XmlResults SwigDirector_XmlExternalFunctionBase::execute(XmlTransaction &txn, XmlManager &mgr, XmlArguments const &args) const {
  XmlResults c_result ;
  jlong jresult = 0 ;
  JNIEnvWrapper swigjnienv(this) ;
  JNIEnv * jenv = swigjnienv.getJNIEnv() ;
  jobject swigjobj = (jobject) NULL ;
  jlong jtxn = 0 ;
  jlong jmgr = 0 ;
  jlong jargs = 0 ;
  XmlResults *argp ;
  
  if (!swig_override[0]) {
    SWIG_JavaThrowException(JNIEnvWrapper(this).getJNIEnv(), SWIG_JavaDirectorPureVirtual, "Attempted to invoke pure virtual method XmlExternalFunction::execute.");
    return c_result;
  }
  swigjobj = swig_get_self(jenv);
  if (swigjobj && jenv->IsSameObject(swigjobj, NULL) == JNI_FALSE) {
    *(XmlTransaction **)&jtxn = (XmlTransaction *) &txn; 
    *(XmlManager **)&jmgr = (XmlManager *) &mgr; 
    *(XmlArguments **)&jargs = (XmlArguments *) &args; 
    jresult = (jlong) jenv->CallStaticLongMethod(Swig::jclass_dbxml_javaJNI, Swig::director_methids[9], swigjobj, jtxn, jmgr, jargs);
    if (jenv->ExceptionOccurred()) return c_result;
    argp = *(XmlResults **)&jresult; 
    if (!argp) {
      SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Unexpected null return for type XmlResults");
      return c_result;
    }
    c_result = *argp; 
  } else {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null upcall object");
  }
  if (swigjobj) jenv->DeleteLocalRef(swigjobj);
  return c_result;
}

void SwigDirector_XmlExternalFunctionBase::close() {
  JNIEnvWrapper swigjnienv(this) ;
  JNIEnv * jenv = swigjnienv.getJNIEnv() ;
  jobject swigjobj = (jobject) NULL ;
  
  if (!swig_override[1]) {
    SWIG_JavaThrowException(JNIEnvWrapper(this).getJNIEnv(), SWIG_JavaDirectorPureVirtual, "Attempted to invoke pure virtual method XmlExternalFunction::close.");
    return;
  }
  swigjobj = swig_get_self(jenv);
  if (swigjobj && jenv->IsSameObject(swigjobj, NULL) == JNI_FALSE) {
    jenv->CallStaticVoidMethod(Swig::jclass_dbxml_javaJNI, Swig::director_methids[10], swigjobj);
    if (jenv->ExceptionOccurred()) return ;
  } else {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null upcall object");
  }
  if (swigjobj) jenv->DeleteLocalRef(swigjobj);
}

void SwigDirector_XmlExternalFunctionBase::swig_connect_director(JNIEnv *jenv, jobject jself, jclass jcls, bool swig_mem_own, bool weak_global) {
  static struct {
    const char *mname;
    const char *mdesc;
    jmethodID base_methid;
  } methods[] = {
    {
      "execute", "(Lcom/sleepycat/dbxml/XmlTransaction;Lcom/sleepycat/dbxml/XmlManager;Lcom/sleepycat/dbxml/XmlArguments;)Lcom/sleepycat/dbxml/XmlResults;", NULL 
    },
    {
      "close", "()V", NULL 
    }
  };
  
  static jclass baseclass = 0 ;
  
  if (swig_set_self(jenv, jself, swig_mem_own, weak_global)) {
    if (!baseclass) {
      baseclass = jenv->FindClass("com/sleepycat/dbxml/XmlExternalFunctionBase");
      if (!baseclass) return;
      baseclass = (jclass) jenv->NewGlobalRef(baseclass);
    }
    bool derived = (jenv->IsSameObject(baseclass, jcls) ? false : true);
    for (int i = 0; i < 2; ++i) {
      if (!methods[i].base_methid) {
        methods[i].base_methid = jenv->GetMethodID(baseclass, methods[i].mname, methods[i].mdesc);
        if (!methods[i].base_methid) return;
      }
      swig_override[i] = false;
      if (derived) {
        jmethodID methid = jenv->GetMethodID(jcls, methods[i].mname, methods[i].mdesc);
        swig_override[i] = (methid != methods[i].base_methid);
        jenv->ExceptionClear();
      }
    }
  }
}


SwigDirector_XmlDebugListener::SwigDirector_XmlDebugListener(JNIEnv *jenv) : XmlDebugListener(), Swig::Director(jenv) {
}

SwigDirector_XmlDebugListener::~SwigDirector_XmlDebugListener() {
  swig_disconnect_director_self("swigDirectorDisconnect");
}


void SwigDirector_XmlDebugListener::start(XmlStackFrame const *stack) {
  JNIEnvWrapper swigjnienv(this) ;
  JNIEnv * jenv = swigjnienv.getJNIEnv() ;
  jobject swigjobj = (jobject) NULL ;
  jlong jstack = 0 ;
  
  if (!swig_override[0]) {
    XmlDebugListener::start(stack);
    return;
  }
  swigjobj = swig_get_self(jenv);
  if (swigjobj && jenv->IsSameObject(swigjobj, NULL) == JNI_FALSE) {
    *((XmlStackFrame **)&jstack) = (XmlStackFrame *) stack; 
    jenv->CallStaticVoidMethod(Swig::jclass_dbxml_javaJNI, Swig::director_methids[11], swigjobj, jstack);
    if (jenv->ExceptionOccurred()) return ;
  } else {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null upcall object");
  }
  if (swigjobj) jenv->DeleteLocalRef(swigjobj);
}

void SwigDirector_XmlDebugListener::end(XmlStackFrame const *stack) {
  JNIEnvWrapper swigjnienv(this) ;
  JNIEnv * jenv = swigjnienv.getJNIEnv() ;
  jobject swigjobj = (jobject) NULL ;
  jlong jstack = 0 ;
  
  if (!swig_override[1]) {
    XmlDebugListener::end(stack);
    return;
  }
  swigjobj = swig_get_self(jenv);
  if (swigjobj && jenv->IsSameObject(swigjobj, NULL) == JNI_FALSE) {
    *((XmlStackFrame **)&jstack) = (XmlStackFrame *) stack; 
    jenv->CallStaticVoidMethod(Swig::jclass_dbxml_javaJNI, Swig::director_methids[12], swigjobj, jstack);
    if (jenv->ExceptionOccurred()) return ;
  } else {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null upcall object");
  }
  if (swigjobj) jenv->DeleteLocalRef(swigjobj);
}

void SwigDirector_XmlDebugListener::enter(XmlStackFrame const *stack) {
  JNIEnvWrapper swigjnienv(this) ;
  JNIEnv * jenv = swigjnienv.getJNIEnv() ;
  jobject swigjobj = (jobject) NULL ;
  jlong jstack = 0 ;
  
  if (!swig_override[2]) {
    XmlDebugListener::enter(stack);
    return;
  }
  swigjobj = swig_get_self(jenv);
  if (swigjobj && jenv->IsSameObject(swigjobj, NULL) == JNI_FALSE) {
    *((XmlStackFrame **)&jstack) = (XmlStackFrame *) stack; 
    jenv->CallStaticVoidMethod(Swig::jclass_dbxml_javaJNI, Swig::director_methids[13], swigjobj, jstack);
    if (jenv->ExceptionOccurred()) return ;
  } else {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null upcall object");
  }
  if (swigjobj) jenv->DeleteLocalRef(swigjobj);
}

void SwigDirector_XmlDebugListener::exit(XmlStackFrame const *stack) {
  JNIEnvWrapper swigjnienv(this) ;
  JNIEnv * jenv = swigjnienv.getJNIEnv() ;
  jobject swigjobj = (jobject) NULL ;
  jlong jstack = 0 ;
  
  if (!swig_override[3]) {
    XmlDebugListener::exit(stack);
    return;
  }
  swigjobj = swig_get_self(jenv);
  if (swigjobj && jenv->IsSameObject(swigjobj, NULL) == JNI_FALSE) {
    *((XmlStackFrame **)&jstack) = (XmlStackFrame *) stack; 
    jenv->CallStaticVoidMethod(Swig::jclass_dbxml_javaJNI, Swig::director_methids[14], swigjobj, jstack);
    if (jenv->ExceptionOccurred()) return ;
  } else {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null upcall object");
  }
  if (swigjobj) jenv->DeleteLocalRef(swigjobj);
}

void SwigDirector_XmlDebugListener::error(XmlException const &error, XmlStackFrame const *stack) {
  JNIEnvWrapper swigjnienv(this) ;
  JNIEnv * jenv = swigjnienv.getJNIEnv() ;
  jobject swigjobj = (jobject) NULL ;
  jobject jerror = 0 ;
  jlong jstack = 0 ;
  
  if (!swig_override[4]) {
    XmlDebugListener::error(error,stack);
    return;
  }
  swigjobj = swig_get_self(jenv);
  if (swigjobj && jenv->IsSameObject(swigjobj, NULL) == JNI_FALSE) {
    jerror = createException(jenv, &error);
    
    *((XmlStackFrame **)&jstack) = (XmlStackFrame *) stack; 
    jenv->CallStaticVoidMethod(Swig::jclass_dbxml_javaJNI, Swig::director_methids[15], swigjobj, jerror, jstack);
    if (jenv->ExceptionOccurred()) return ;
  } else {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null upcall object");
  }
  if (swigjobj) jenv->DeleteLocalRef(swigjobj);
}

void SwigDirector_XmlDebugListener::swig_connect_director(JNIEnv *jenv, jobject jself, jclass jcls, bool swig_mem_own, bool weak_global) {
  static struct {
    const char *mname;
    const char *mdesc;
    jmethodID base_methid;
  } methods[] = {
    {
      "start", "(Lcom/sleepycat/dbxml/XmlStackFrame;)V", NULL 
    },
    {
      "end", "(Lcom/sleepycat/dbxml/XmlStackFrame;)V", NULL 
    },
    {
      "enter", "(Lcom/sleepycat/dbxml/XmlStackFrame;)V", NULL 
    },
    {
      "exit", "(Lcom/sleepycat/dbxml/XmlStackFrame;)V", NULL 
    },
    {
      "error", "(Lcom/sleepycat/dbxml/XmlException;Lcom/sleepycat/dbxml/XmlStackFrame;)V", NULL 
    }
  };
  
  static jclass baseclass = 0 ;
  
  if (swig_set_self(jenv, jself, swig_mem_own, weak_global)) {
    if (!baseclass) {
      baseclass = jenv->FindClass("com/sleepycat/dbxml/XmlDebugListener");
      if (!baseclass) return;
      baseclass = (jclass) jenv->NewGlobalRef(baseclass);
    }
    bool derived = (jenv->IsSameObject(baseclass, jcls) ? false : true);
    for (int i = 0; i < 5; ++i) {
      if (!methods[i].base_methid) {
        methods[i].base_methid = jenv->GetMethodID(baseclass, methods[i].mname, methods[i].mdesc);
        if (!methods[i].base_methid) return;
      }
      swig_override[i] = false;
      if (derived) {
        jmethodID methid = jenv->GetMethodID(jcls, methods[i].mname, methods[i].mdesc);
        swig_override[i] = (methid != methods[i].base_methid);
        jenv->ExceptionClear();
      }
    }
  }
}


SwigDirector_XmlCompression::SwigDirector_XmlCompression(JNIEnv *jenv) : XmlCompression(), Swig::Director(jenv) {
}

SwigDirector_XmlCompression::~SwigDirector_XmlCompression() {
  swig_disconnect_director_self("swigDirectorDisconnect");
}


bool SwigDirector_XmlCompression::compress(XmlTransaction &txn, XmlData const &source, XmlData &dest) {
  bool c_result = SwigValueInit< bool >() ;
  jboolean jresult = 0 ;
  JNIEnvWrapper swigjnienv(this) ;
  JNIEnv * jenv = swigjnienv.getJNIEnv() ;
  jobject swigjobj = (jobject) NULL ;
  jlong jtxn = 0 ;
  jlong jsource = 0 ;
  jlong jdest = 0 ;
  
  if (!swig_override[0]) {
    SWIG_JavaThrowException(JNIEnvWrapper(this).getJNIEnv(), SWIG_JavaDirectorPureVirtual, "Attempted to invoke pure virtual method XmlCompression::compress.");
    return c_result;
  }
  swigjobj = swig_get_self(jenv);
  if (swigjobj && jenv->IsSameObject(swigjobj, NULL) == JNI_FALSE) {
    *(XmlTransaction **)&jtxn = (XmlTransaction *) &txn; 
    *(XmlData **)&jsource = (XmlData *) &source; 
    *(XmlData **)&jdest = (XmlData *) &dest; 
    jresult = (jboolean) jenv->CallStaticBooleanMethod(Swig::jclass_dbxml_javaJNI, Swig::director_methids[16], swigjobj, jtxn, jsource, jdest);
    if (jenv->ExceptionOccurred()) return c_result;
    c_result = jresult ? true : false; 
  } else {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null upcall object");
  }
  if (swigjobj) jenv->DeleteLocalRef(swigjobj);
  return c_result;
}

bool SwigDirector_XmlCompression::decompress(XmlTransaction &txn, XmlData const &source, XmlData &dest) {
  bool c_result = SwigValueInit< bool >() ;
  jboolean jresult = 0 ;
  JNIEnvWrapper swigjnienv(this) ;
  JNIEnv * jenv = swigjnienv.getJNIEnv() ;
  jobject swigjobj = (jobject) NULL ;
  jlong jtxn = 0 ;
  jlong jsource = 0 ;
  jlong jdest = 0 ;
  
  if (!swig_override[1]) {
    SWIG_JavaThrowException(JNIEnvWrapper(this).getJNIEnv(), SWIG_JavaDirectorPureVirtual, "Attempted to invoke pure virtual method XmlCompression::decompress.");
    return c_result;
  }
  swigjobj = swig_get_self(jenv);
  if (swigjobj && jenv->IsSameObject(swigjobj, NULL) == JNI_FALSE) {
    *(XmlTransaction **)&jtxn = (XmlTransaction *) &txn; 
    *(XmlData **)&jsource = (XmlData *) &source; 
    *(XmlData **)&jdest = (XmlData *) &dest; 
    jresult = (jboolean) jenv->CallStaticBooleanMethod(Swig::jclass_dbxml_javaJNI, Swig::director_methids[17], swigjobj, jtxn, jsource, jdest);
    if (jenv->ExceptionOccurred()) return c_result;
    c_result = jresult ? true : false; 
  } else {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null upcall object");
  }
  if (swigjobj) jenv->DeleteLocalRef(swigjobj);
  return c_result;
}

void SwigDirector_XmlCompression::swig_connect_director(JNIEnv *jenv, jobject jself, jclass jcls, bool swig_mem_own, bool weak_global) {
  static struct {
    const char *mname;
    const char *mdesc;
    jmethodID base_methid;
  } methods[] = {
    {
      "compress", "(Lcom/sleepycat/dbxml/XmlTransaction;Lcom/sleepycat/dbxml/XmlData;Lcom/sleepycat/dbxml/XmlData;)Z", NULL 
    },
    {
      "decompress", "(Lcom/sleepycat/dbxml/XmlTransaction;Lcom/sleepycat/dbxml/XmlData;Lcom/sleepycat/dbxml/XmlData;)Z", NULL 
    }
  };
  
  static jclass baseclass = 0 ;
  
  if (swig_set_self(jenv, jself, swig_mem_own, weak_global)) {
    if (!baseclass) {
      baseclass = jenv->FindClass("com/sleepycat/dbxml/XmlCompression");
      if (!baseclass) return;
      baseclass = (jclass) jenv->NewGlobalRef(baseclass);
    }
    bool derived = (jenv->IsSameObject(baseclass, jcls) ? false : true);
    for (int i = 0; i < 2; ++i) {
      if (!methods[i].base_methid) {
        methods[i].base_methid = jenv->GetMethodID(baseclass, methods[i].mname, methods[i].mdesc);
        if (!methods[i].base_methid) return;
      }
      swig_override[i] = false;
      if (derived) {
        jmethodID methid = jenv->GetMethodID(jcls, methods[i].mname, methods[i].mdesc);
        swig_override[i] = (methid != methods[i].base_methid);
        jenv->ExceptionClear();
      }
    }
  }
}



#ifdef __cplusplus
extern "C" {
#endif

SWIGEXPORT jboolean JNICALL Java_com_sleepycat_dbxml_dbxml_1javaJNI_HelperFunctions_1testXmlData(JNIEnv *jenv, jclass jcls) {
  jboolean jresult = 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  {
    jthrowable t = NULL;
    try {
      result = (bool)HelperFunctions_testXmlData();
    }
    catch (std::exception &se) {
      t = createException(jenv, &se);
      jenv->Throw(t);
      return 0;
    }
    catch(JavaException & /* je */) {
      // This means there's already an exception waiting in the JVM
      return 0;
    }
    catch (...) {
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("Uncaught exception from C++ API"), 0, 0, 0, 0);
      jenv->Throw(t);
      return 0;
    }
  }
  
  jresult = result ? JNI_TRUE : JNI_FALSE;
  
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_com_sleepycat_dbxml_dbxml_1javaJNI_HelperFunctions_1testConfigDefault(JNIEnv *jenv, jclass jcls, jintArray data1, jstring jarg1) {
  jboolean jresult = 0 ;
  XmlContainerConfig arg1 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  
  arg1 = createCPPXmlContainerConfig(jenv, data1, jarg1);	
  
  {
    jthrowable t = NULL;
    try {
      result = (bool)HelperFunctions_testConfigDefault(arg1);
    }
    catch (std::exception &se) {
      t = createException(jenv, &se);
      jenv->Throw(t);
      return 0;
    }
    catch(JavaException & /* je */) {
      // This means there's already an exception waiting in the JVM
      return 0;
    }
    catch (...) {
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("Uncaught exception from C++ API"), 0, 0, 0, 0);
      jenv->Throw(t);
      return 0;
    }
  }
  
  jresult = result ? JNI_TRUE : JNI_FALSE;
  
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_com_sleepycat_dbxml_dbxml_1javaJNI_HelperFunctions_1testConfigBitOperator(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jboolean jresult = 0 ;
  XmlManager *arg1 = 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(XmlManager **)&jarg1;
  if(!arg1) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "XmlManager & reference is null");
    return 0;
  } 
  {
    jthrowable t = NULL;
    try {
      result = (bool)HelperFunctions_testConfigBitOperator(*arg1);
    }
    catch (std::exception &se) {
      t = createException(jenv, &se);
      jenv->Throw(t);
      return 0;
    }
    catch(JavaException & /* je */) {
      // This means there's already an exception waiting in the JVM
      return 0;
    }
    catch (...) {
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("Uncaught exception from C++ API"), 0, 0, 0, 0);
      jenv->Throw(t);
      return 0;
    }
  }
  
  jresult = result ? JNI_TRUE : JNI_FALSE;
  
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_com_sleepycat_dbxml_dbxml_1javaJNI_HelperFunctions_1testNullTxn(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jboolean jresult = 0 ;
  XmlManager *arg1 = 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(XmlManager **)&jarg1;
  if(!arg1) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "XmlManager & reference is null");
    return 0;
  } 
  {
    jthrowable t = NULL;
    try {
      result = (bool)HelperFunctions_testNullTxn(*arg1);
    }
    catch (std::exception &se) {
      t = createException(jenv, &se);
      jenv->Throw(t);
      return 0;
    }
    catch(JavaException & /* je */) {
      // This means there's already an exception waiting in the JVM
      return 0;
    }
    catch (...) {
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("Uncaught exception from C++ API"), 0, 0, 0, 0);
      jenv->Throw(t);
      return 0;
    }
  }
  
  jresult = result ? JNI_TRUE : JNI_FALSE;
  
  return jresult;
}


SWIGEXPORT jint JNICALL Java_com_sleepycat_dbxml_dbxml_1javaJNI_HelperFunctions_1getType(JNIEnv *jenv, jclass jcls, jstring jarg1, jstring jarg2, jstring jarg3) {
  jint jresult = 0 ;
  std::string arg1 ;
  std::string arg2 ;
  std::string arg3 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  
  const char *arg1_pstr = "";
  if(jarg1) {
    arg1_pstr = (const char *)jenv->GetStringUTFChars(jarg1, 0);
  }
  if (!arg1_pstr) return 0;
  arg1 =  std::string(arg1_pstr);
  if (jarg1) {
    jenv->ReleaseStringUTFChars(jarg1, arg1_pstr);
  }
  
  
  const char *arg2_pstr = "";
  if(jarg2) {
    arg2_pstr = (const char *)jenv->GetStringUTFChars(jarg2, 0);
  }
  if (!arg2_pstr) return 0;
  arg2 =  std::string(arg2_pstr);
  if (jarg2) {
    jenv->ReleaseStringUTFChars(jarg2, arg2_pstr);
  }
  
  
  const char *arg3_pstr = "";
  if(jarg3) {
    arg3_pstr = (const char *)jenv->GetStringUTFChars(jarg3, 0);
  }
  if (!arg3_pstr) return 0;
  arg3 =  std::string(arg3_pstr);
  if (jarg3) {
    jenv->ReleaseStringUTFChars(jarg3, arg3_pstr);
  }
  
  {
    jthrowable t = NULL;
    try {
      result = (int)HelperFunctions_getType(arg1,arg2,arg3);
    }
    catch (std::exception &se) {
      t = createException(jenv, &se);
      jenv->Throw(t);
      return 0;
    }
    catch(JavaException & /* je */) {
      // This means there's already an exception waiting in the JVM
      return 0;
    }
    catch (...) {
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("Uncaught exception from C++ API"), 0, 0, 0, 0);
      jenv->Throw(t);
      return 0;
    }
  }
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jstring JNICALL Java_com_sleepycat_dbxml_dbxml_1javaJNI_HelperFunctions_1getTypeURI(JNIEnv *jenv, jclass jcls, jbyteArray jarg1, jlong jarg2, jobject jarg2_) {
  jstring jresult = 0 ;
  DBT *arg1 = (DBT *) 0 ;
  XmlResults *arg2 = (XmlResults *) 0 ;
  struct DBT_INFO ldbt1 ;
  std::string result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg2_;
  
  if (jarg1 != NULL) {
    ldbt1.dbt.data = ldbt1.orig_data = jenv->GetByteArrayElements(jarg1, (jboolean *)0);
    ldbt1.dbt.size = jenv->GetArrayLength(jarg1);
  } else {
    ldbt1.dbt.data = ldbt1.orig_data = 0;
    ldbt1.dbt.size = 0;
  }
  ldbt1.dbt.flags = DB_DBT_MALLOC;
  arg1 = &ldbt1.dbt;
  
  arg2 = *(XmlResults **)&jarg2; 
  {
    jthrowable t = NULL;
    try {
      result = HelperFunctions_getTypeURI(arg1,arg2);
    }
    catch (std::exception &se) {
      t = createException(jenv, &se);
      jenv->Throw(t);
      return 0;
    }
    catch(JavaException & /* je */) {
      // This means there's already an exception waiting in the JVM
      return 0;
    }
    catch (...) {
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("Uncaught exception from C++ API"), 0, 0, 0, 0);
      jenv->Throw(t);
      return 0;
    }
  }
  jresult = jenv->NewStringUTF((&result)->c_str()); 
  
  if (jarg1 != NULL)
  jenv->ReleaseByteArrayElements(jarg1, ldbt1.orig_data, JNI_ABORT);
  
  return jresult;
}


SWIGEXPORT jstring JNICALL Java_com_sleepycat_dbxml_dbxml_1javaJNI_HelperFunctions_1getTypeName(JNIEnv *jenv, jclass jcls, jbyteArray jarg1, jlong jarg2, jobject jarg2_) {
  jstring jresult = 0 ;
  DBT *arg1 = (DBT *) 0 ;
  XmlResults *arg2 = (XmlResults *) 0 ;
  struct DBT_INFO ldbt1 ;
  std::string result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg2_;
  
  if (jarg1 != NULL) {
    ldbt1.dbt.data = ldbt1.orig_data = jenv->GetByteArrayElements(jarg1, (jboolean *)0);
    ldbt1.dbt.size = jenv->GetArrayLength(jarg1);
  } else {
    ldbt1.dbt.data = ldbt1.orig_data = 0;
    ldbt1.dbt.size = 0;
  }
  ldbt1.dbt.flags = DB_DBT_MALLOC;
  arg1 = &ldbt1.dbt;
  
  arg2 = *(XmlResults **)&jarg2; 
  {
    jthrowable t = NULL;
    try {
      result = HelperFunctions_getTypeName(arg1,arg2);
    }
    catch (std::exception &se) {
      t = createException(jenv, &se);
      jenv->Throw(t);
      return 0;
    }
    catch(JavaException & /* je */) {
      // This means there's already an exception waiting in the JVM
      return 0;
    }
    catch (...) {
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("Uncaught exception from C++ API"), 0, 0, 0, 0);
      jenv->Throw(t);
      return 0;
    }
  }
  jresult = jenv->NewStringUTF((&result)->c_str()); 
  
  if (jarg1 != NULL)
  jenv->ReleaseByteArrayElements(jarg1, ldbt1.orig_data, JNI_ABORT);
  
  return jresult;
}


SWIGEXPORT jstring JNICALL Java_com_sleepycat_dbxml_dbxml_1javaJNI_HelperFunctions_1asString(JNIEnv *jenv, jclass jcls, jbyteArray jarg1, jlong jarg2, jobject jarg2_) {
  jstring jresult = 0 ;
  DBT *arg1 = (DBT *) 0 ;
  XmlResults *arg2 = (XmlResults *) 0 ;
  struct DBT_INFO ldbt1 ;
  std::string result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg2_;
  
  if (jarg1 != NULL) {
    ldbt1.dbt.data = ldbt1.orig_data = jenv->GetByteArrayElements(jarg1, (jboolean *)0);
    ldbt1.dbt.size = jenv->GetArrayLength(jarg1);
  } else {
    ldbt1.dbt.data = ldbt1.orig_data = 0;
    ldbt1.dbt.size = 0;
  }
  ldbt1.dbt.flags = DB_DBT_MALLOC;
  arg1 = &ldbt1.dbt;
  
  arg2 = *(XmlResults **)&jarg2; 
  {
    jthrowable t = NULL;
    try {
      result = HelperFunctions_asString(arg1,arg2);
    }
    catch (std::exception &se) {
      t = createException(jenv, &se);
      jenv->Throw(t);
      return 0;
    }
    catch(JavaException & /* je */) {
      // This means there's already an exception waiting in the JVM
      return 0;
    }
    catch (...) {
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("Uncaught exception from C++ API"), 0, 0, 0, 0);
      jenv->Throw(t);
      return 0;
    }
  }
  jresult = jenv->NewStringUTF((&result)->c_str()); 
  
  if (jarg1 != NULL)
  jenv->ReleaseByteArrayElements(jarg1, ldbt1.orig_data, JNI_ABORT);
  
  return jresult;
}


SWIGEXPORT jobject JNICALL Java_com_sleepycat_dbxml_dbxml_1javaJNI_HelperFunctions_1asDocument(JNIEnv *jenv, jclass jcls, jbyteArray jarg1, jlong jarg2, jobject jarg2_) {
  jobject jresult = 0 ;
  DBT *arg1 = (DBT *) 0 ;
  XmlResults *arg2 = (XmlResults *) 0 ;
  struct DBT_INFO ldbt1 ;
  XmlDocument result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg2_;
  
  if (jarg1 != NULL) {
    ldbt1.dbt.data = ldbt1.orig_data = jenv->GetByteArrayElements(jarg1, (jboolean *)0);
    ldbt1.dbt.size = jenv->GetArrayLength(jarg1);
  } else {
    ldbt1.dbt.data = ldbt1.orig_data = 0;
    ldbt1.dbt.size = 0;
  }
  ldbt1.dbt.flags = DB_DBT_MALLOC;
  arg1 = &ldbt1.dbt;
  
  arg2 = *(XmlResults **)&jarg2; 
  {
    jthrowable t = NULL;
    try {
      result = HelperFunctions_asDocument(arg1,arg2);
    }
    catch (std::exception &se) {
      t = createException(jenv, &se);
      jenv->Throw(t);
      return 0;
    }
    catch(JavaException & /* je */) {
      // This means there's already an exception waiting in the JVM
      return 0;
    }
    catch (...) {
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("Uncaught exception from C++ API"), 0, 0, 0, 0);
      jenv->Throw(t);
      return 0;
    }
  }
  {
    jresult = createJavaXmlDocument(jenv, result);
  }
  
  if (jarg1 != NULL)
  jenv->ReleaseByteArrayElements(jarg1, ldbt1.orig_data, JNI_ABORT);
  
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_sleepycat_dbxml_dbxml_1javaJNI_HelperFunctions_1asEventReader(JNIEnv *jenv, jclass jcls, jbyteArray jarg1, jlong jarg2, jobject jarg2_) {
  jlong jresult = 0 ;
  DBT *arg1 = (DBT *) 0 ;
  XmlResults *arg2 = (XmlResults *) 0 ;
  struct DBT_INFO ldbt1 ;
  XmlEventReader *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg2_;
  
  if (jarg1 != NULL) {
    ldbt1.dbt.data = ldbt1.orig_data = jenv->GetByteArrayElements(jarg1, (jboolean *)0);
    ldbt1.dbt.size = jenv->GetArrayLength(jarg1);
  } else {
    ldbt1.dbt.data = ldbt1.orig_data = 0;
    ldbt1.dbt.size = 0;
  }
  ldbt1.dbt.flags = DB_DBT_MALLOC;
  arg1 = &ldbt1.dbt;
  
  arg2 = *(XmlResults **)&jarg2; 
  {
    jthrowable t = NULL;
    try {
      result = (XmlEventReader *) &HelperFunctions_asEventReader(arg1,arg2);
    }
    catch (std::exception &se) {
      t = createException(jenv, &se);
      jenv->Throw(t);
      return 0;
    }
    catch(JavaException & /* je */) {
      // This means there's already an exception waiting in the JVM
      return 0;
    }
    catch (...) {
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("Uncaught exception from C++ API"), 0, 0, 0, 0);
      jenv->Throw(t);
      return 0;
    }
  }
  *(XmlEventReader **)&jresult = result; 
  
  if (jarg1 != NULL)
  jenv->ReleaseByteArrayElements(jarg1, ldbt1.orig_data, JNI_ABORT);
  
  return jresult;
}


SWIGEXPORT jstring JNICALL Java_com_sleepycat_dbxml_dbxml_1javaJNI_HelperFunctions_1getNodeHandle(JNIEnv *jenv, jclass jcls, jbyteArray jarg1, jlong jarg2, jobject jarg2_) {
  jstring jresult = 0 ;
  DBT *arg1 = (DBT *) 0 ;
  XmlResults *arg2 = (XmlResults *) 0 ;
  struct DBT_INFO ldbt1 ;
  std::string result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg2_;
  
  if (jarg1 != NULL) {
    ldbt1.dbt.data = ldbt1.orig_data = jenv->GetByteArrayElements(jarg1, (jboolean *)0);
    ldbt1.dbt.size = jenv->GetArrayLength(jarg1);
  } else {
    ldbt1.dbt.data = ldbt1.orig_data = 0;
    ldbt1.dbt.size = 0;
  }
  ldbt1.dbt.flags = DB_DBT_MALLOC;
  arg1 = &ldbt1.dbt;
  
  arg2 = *(XmlResults **)&jarg2; 
  {
    jthrowable t = NULL;
    try {
      result = HelperFunctions_getNodeHandle(arg1,arg2);
    }
    catch (std::exception &se) {
      t = createException(jenv, &se);
      jenv->Throw(t);
      return 0;
    }
    catch(JavaException & /* je */) {
      // This means there's already an exception waiting in the JVM
      return 0;
    }
    catch (...) {
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("Uncaught exception from C++ API"), 0, 0, 0, 0);
      jenv->Throw(t);
      return 0;
    }
  }
  jresult = jenv->NewStringUTF((&result)->c_str()); 
  
  if (jarg1 != NULL)
  jenv->ReleaseByteArrayElements(jarg1, ldbt1.orig_data, JNI_ABORT);
  
  return jresult;
}


SWIGEXPORT jstring JNICALL Java_com_sleepycat_dbxml_dbxml_1javaJNI_HelperFunctions_1getNodeName(JNIEnv *jenv, jclass jcls, jbyteArray jarg1, jlong jarg2, jobject jarg2_) {
  jstring jresult = 0 ;
  DBT *arg1 = (DBT *) 0 ;
  XmlResults *arg2 = (XmlResults *) 0 ;
  struct DBT_INFO ldbt1 ;
  std::string result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg2_;
  
  if (jarg1 != NULL) {
    ldbt1.dbt.data = ldbt1.orig_data = jenv->GetByteArrayElements(jarg1, (jboolean *)0);
    ldbt1.dbt.size = jenv->GetArrayLength(jarg1);
  } else {
    ldbt1.dbt.data = ldbt1.orig_data = 0;
    ldbt1.dbt.size = 0;
  }
  ldbt1.dbt.flags = DB_DBT_MALLOC;
  arg1 = &ldbt1.dbt;
  
  arg2 = *(XmlResults **)&jarg2; 
  {
    jthrowable t = NULL;
    try {
      result = HelperFunctions_getNodeName(arg1,arg2);
    }
    catch (std::exception &se) {
      t = createException(jenv, &se);
      jenv->Throw(t);
      return 0;
    }
    catch(JavaException & /* je */) {
      // This means there's already an exception waiting in the JVM
      return 0;
    }
    catch (...) {
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("Uncaught exception from C++ API"), 0, 0, 0, 0);
      jenv->Throw(t);
      return 0;
    }
  }
  jresult = jenv->NewStringUTF((&result)->c_str()); 
  
  if (jarg1 != NULL)
  jenv->ReleaseByteArrayElements(jarg1, ldbt1.orig_data, JNI_ABORT);
  
  return jresult;
}


SWIGEXPORT jstring JNICALL Java_com_sleepycat_dbxml_dbxml_1javaJNI_HelperFunctions_1getNodeValue(JNIEnv *jenv, jclass jcls, jbyteArray jarg1, jlong jarg2, jobject jarg2_) {
  jstring jresult = 0 ;
  DBT *arg1 = (DBT *) 0 ;
  XmlResults *arg2 = (XmlResults *) 0 ;
  struct DBT_INFO ldbt1 ;
  std::string result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg2_;
  
  if (jarg1 != NULL) {
    ldbt1.dbt.data = ldbt1.orig_data = jenv->GetByteArrayElements(jarg1, (jboolean *)0);
    ldbt1.dbt.size = jenv->GetArrayLength(jarg1);
  } else {
    ldbt1.dbt.data = ldbt1.orig_data = 0;
    ldbt1.dbt.size = 0;
  }
  ldbt1.dbt.flags = DB_DBT_MALLOC;
  arg1 = &ldbt1.dbt;
  
  arg2 = *(XmlResults **)&jarg2; 
  {
    jthrowable t = NULL;
    try {
      result = HelperFunctions_getNodeValue(arg1,arg2);
    }
    catch (std::exception &se) {
      t = createException(jenv, &se);
      jenv->Throw(t);
      return 0;
    }
    catch(JavaException & /* je */) {
      // This means there's already an exception waiting in the JVM
      return 0;
    }
    catch (...) {
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("Uncaught exception from C++ API"), 0, 0, 0, 0);
      jenv->Throw(t);
      return 0;
    }
  }
  jresult = jenv->NewStringUTF((&result)->c_str()); 
  
  if (jarg1 != NULL)
  jenv->ReleaseByteArrayElements(jarg1, ldbt1.orig_data, JNI_ABORT);
  
  return jresult;
}


SWIGEXPORT jstring JNICALL Java_com_sleepycat_dbxml_dbxml_1javaJNI_HelperFunctions_1getNamespaceURI(JNIEnv *jenv, jclass jcls, jbyteArray jarg1, jlong jarg2, jobject jarg2_) {
  jstring jresult = 0 ;
  DBT *arg1 = (DBT *) 0 ;
  XmlResults *arg2 = (XmlResults *) 0 ;
  struct DBT_INFO ldbt1 ;
  std::string result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg2_;
  
  if (jarg1 != NULL) {
    ldbt1.dbt.data = ldbt1.orig_data = jenv->GetByteArrayElements(jarg1, (jboolean *)0);
    ldbt1.dbt.size = jenv->GetArrayLength(jarg1);
  } else {
    ldbt1.dbt.data = ldbt1.orig_data = 0;
    ldbt1.dbt.size = 0;
  }
  ldbt1.dbt.flags = DB_DBT_MALLOC;
  arg1 = &ldbt1.dbt;
  
  arg2 = *(XmlResults **)&jarg2; 
  {
    jthrowable t = NULL;
    try {
      result = HelperFunctions_getNamespaceURI(arg1,arg2);
    }
    catch (std::exception &se) {
      t = createException(jenv, &se);
      jenv->Throw(t);
      return 0;
    }
    catch(JavaException & /* je */) {
      // This means there's already an exception waiting in the JVM
      return 0;
    }
    catch (...) {
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("Uncaught exception from C++ API"), 0, 0, 0, 0);
      jenv->Throw(t);
      return 0;
    }
  }
  jresult = jenv->NewStringUTF((&result)->c_str()); 
  
  if (jarg1 != NULL)
  jenv->ReleaseByteArrayElements(jarg1, ldbt1.orig_data, JNI_ABORT);
  
  return jresult;
}


SWIGEXPORT jstring JNICALL Java_com_sleepycat_dbxml_dbxml_1javaJNI_HelperFunctions_1getPrefix(JNIEnv *jenv, jclass jcls, jbyteArray jarg1, jlong jarg2, jobject jarg2_) {
  jstring jresult = 0 ;
  DBT *arg1 = (DBT *) 0 ;
  XmlResults *arg2 = (XmlResults *) 0 ;
  struct DBT_INFO ldbt1 ;
  std::string result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg2_;
  
  if (jarg1 != NULL) {
    ldbt1.dbt.data = ldbt1.orig_data = jenv->GetByteArrayElements(jarg1, (jboolean *)0);
    ldbt1.dbt.size = jenv->GetArrayLength(jarg1);
  } else {
    ldbt1.dbt.data = ldbt1.orig_data = 0;
    ldbt1.dbt.size = 0;
  }
  ldbt1.dbt.flags = DB_DBT_MALLOC;
  arg1 = &ldbt1.dbt;
  
  arg2 = *(XmlResults **)&jarg2; 
  {
    jthrowable t = NULL;
    try {
      result = HelperFunctions_getPrefix(arg1,arg2);
    }
    catch (std::exception &se) {
      t = createException(jenv, &se);
      jenv->Throw(t);
      return 0;
    }
    catch(JavaException & /* je */) {
      // This means there's already an exception waiting in the JVM
      return 0;
    }
    catch (...) {
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("Uncaught exception from C++ API"), 0, 0, 0, 0);
      jenv->Throw(t);
      return 0;
    }
  }
  jresult = jenv->NewStringUTF((&result)->c_str()); 
  
  if (jarg1 != NULL)
  jenv->ReleaseByteArrayElements(jarg1, ldbt1.orig_data, JNI_ABORT);
  
  return jresult;
}


SWIGEXPORT jstring JNICALL Java_com_sleepycat_dbxml_dbxml_1javaJNI_HelperFunctions_1getLocalName(JNIEnv *jenv, jclass jcls, jbyteArray jarg1, jlong jarg2, jobject jarg2_) {
  jstring jresult = 0 ;
  DBT *arg1 = (DBT *) 0 ;
  XmlResults *arg2 = (XmlResults *) 0 ;
  struct DBT_INFO ldbt1 ;
  std::string result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg2_;
  
  if (jarg1 != NULL) {
    ldbt1.dbt.data = ldbt1.orig_data = jenv->GetByteArrayElements(jarg1, (jboolean *)0);
    ldbt1.dbt.size = jenv->GetArrayLength(jarg1);
  } else {
    ldbt1.dbt.data = ldbt1.orig_data = 0;
    ldbt1.dbt.size = 0;
  }
  ldbt1.dbt.flags = DB_DBT_MALLOC;
  arg1 = &ldbt1.dbt;
  
  arg2 = *(XmlResults **)&jarg2; 
  {
    jthrowable t = NULL;
    try {
      result = HelperFunctions_getLocalName(arg1,arg2);
    }
    catch (std::exception &se) {
      t = createException(jenv, &se);
      jenv->Throw(t);
      return 0;
    }
    catch(JavaException & /* je */) {
      // This means there's already an exception waiting in the JVM
      return 0;
    }
    catch (...) {
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("Uncaught exception from C++ API"), 0, 0, 0, 0);
      jenv->Throw(t);
      return 0;
    }
  }
  jresult = jenv->NewStringUTF((&result)->c_str()); 
  
  if (jarg1 != NULL)
  jenv->ReleaseByteArrayElements(jarg1, ldbt1.orig_data, JNI_ABORT);
  
  return jresult;
}


SWIGEXPORT jobject JNICALL Java_com_sleepycat_dbxml_dbxml_1javaJNI_HelperFunctions_1getParentNode(JNIEnv *jenv, jclass jcls, jbyteArray jarg1, jlong jarg2, jobject jarg2_) {
  jobject jresult = 0 ;
  DBT *arg1 = (DBT *) 0 ;
  XmlResults *arg2 = (XmlResults *) 0 ;
  struct DBT_INFO ldbt1 ;
  XmlValue result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg2_;
  
  if (jarg1 != NULL) {
    ldbt1.dbt.data = ldbt1.orig_data = jenv->GetByteArrayElements(jarg1, (jboolean *)0);
    ldbt1.dbt.size = jenv->GetArrayLength(jarg1);
  } else {
    ldbt1.dbt.data = ldbt1.orig_data = 0;
    ldbt1.dbt.size = 0;
  }
  ldbt1.dbt.flags = DB_DBT_MALLOC;
  arg1 = &ldbt1.dbt;
  
  arg2 = *(XmlResults **)&jarg2; 
  {
    jthrowable t = NULL;
    try {
      result = HelperFunctions_getParentNode(arg1,arg2);
    }
    catch (std::exception &se) {
      t = createException(jenv, &se);
      jenv->Throw(t);
      return 0;
    }
    catch(JavaException & /* je */) {
      // This means there's already an exception waiting in the JVM
      return 0;
    }
    catch (...) {
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("Uncaught exception from C++ API"), 0, 0, 0, 0);
      jenv->Throw(t);
      return 0;
    }
  }
  {
    jresult = createJavaXmlValue(jenv, result);
  }
  
  if (jarg1 != NULL)
  jenv->ReleaseByteArrayElements(jarg1, ldbt1.orig_data, JNI_ABORT);
  
  return jresult;
}


SWIGEXPORT jobject JNICALL Java_com_sleepycat_dbxml_dbxml_1javaJNI_HelperFunctions_1getFirstChild(JNIEnv *jenv, jclass jcls, jbyteArray jarg1, jlong jarg2, jobject jarg2_) {
  jobject jresult = 0 ;
  DBT *arg1 = (DBT *) 0 ;
  XmlResults *arg2 = (XmlResults *) 0 ;
  struct DBT_INFO ldbt1 ;
  XmlValue result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg2_;
  
  if (jarg1 != NULL) {
    ldbt1.dbt.data = ldbt1.orig_data = jenv->GetByteArrayElements(jarg1, (jboolean *)0);
    ldbt1.dbt.size = jenv->GetArrayLength(jarg1);
  } else {
    ldbt1.dbt.data = ldbt1.orig_data = 0;
    ldbt1.dbt.size = 0;
  }
  ldbt1.dbt.flags = DB_DBT_MALLOC;
  arg1 = &ldbt1.dbt;
  
  arg2 = *(XmlResults **)&jarg2; 
  {
    jthrowable t = NULL;
    try {
      result = HelperFunctions_getFirstChild(arg1,arg2);
    }
    catch (std::exception &se) {
      t = createException(jenv, &se);
      jenv->Throw(t);
      return 0;
    }
    catch(JavaException & /* je */) {
      // This means there's already an exception waiting in the JVM
      return 0;
    }
    catch (...) {
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("Uncaught exception from C++ API"), 0, 0, 0, 0);
      jenv->Throw(t);
      return 0;
    }
  }
  {
    jresult = createJavaXmlValue(jenv, result);
  }
  
  if (jarg1 != NULL)
  jenv->ReleaseByteArrayElements(jarg1, ldbt1.orig_data, JNI_ABORT);
  
  return jresult;
}


SWIGEXPORT jobject JNICALL Java_com_sleepycat_dbxml_dbxml_1javaJNI_HelperFunctions_1getLastChild(JNIEnv *jenv, jclass jcls, jbyteArray jarg1, jlong jarg2, jobject jarg2_) {
  jobject jresult = 0 ;
  DBT *arg1 = (DBT *) 0 ;
  XmlResults *arg2 = (XmlResults *) 0 ;
  struct DBT_INFO ldbt1 ;
  XmlValue result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg2_;
  
  if (jarg1 != NULL) {
    ldbt1.dbt.data = ldbt1.orig_data = jenv->GetByteArrayElements(jarg1, (jboolean *)0);
    ldbt1.dbt.size = jenv->GetArrayLength(jarg1);
  } else {
    ldbt1.dbt.data = ldbt1.orig_data = 0;
    ldbt1.dbt.size = 0;
  }
  ldbt1.dbt.flags = DB_DBT_MALLOC;
  arg1 = &ldbt1.dbt;
  
  arg2 = *(XmlResults **)&jarg2; 
  {
    jthrowable t = NULL;
    try {
      result = HelperFunctions_getLastChild(arg1,arg2);
    }
    catch (std::exception &se) {
      t = createException(jenv, &se);
      jenv->Throw(t);
      return 0;
    }
    catch(JavaException & /* je */) {
      // This means there's already an exception waiting in the JVM
      return 0;
    }
    catch (...) {
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("Uncaught exception from C++ API"), 0, 0, 0, 0);
      jenv->Throw(t);
      return 0;
    }
  }
  {
    jresult = createJavaXmlValue(jenv, result);
  }
  
  if (jarg1 != NULL)
  jenv->ReleaseByteArrayElements(jarg1, ldbt1.orig_data, JNI_ABORT);
  
  return jresult;
}


SWIGEXPORT jobject JNICALL Java_com_sleepycat_dbxml_dbxml_1javaJNI_HelperFunctions_1getPreviousSibling(JNIEnv *jenv, jclass jcls, jbyteArray jarg1, jlong jarg2, jobject jarg2_) {
  jobject jresult = 0 ;
  DBT *arg1 = (DBT *) 0 ;
  XmlResults *arg2 = (XmlResults *) 0 ;
  struct DBT_INFO ldbt1 ;
  XmlValue result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg2_;
  
  if (jarg1 != NULL) {
    ldbt1.dbt.data = ldbt1.orig_data = jenv->GetByteArrayElements(jarg1, (jboolean *)0);
    ldbt1.dbt.size = jenv->GetArrayLength(jarg1);
  } else {
    ldbt1.dbt.data = ldbt1.orig_data = 0;
    ldbt1.dbt.size = 0;
  }
  ldbt1.dbt.flags = DB_DBT_MALLOC;
  arg1 = &ldbt1.dbt;
  
  arg2 = *(XmlResults **)&jarg2; 
  {
    jthrowable t = NULL;
    try {
      result = HelperFunctions_getPreviousSibling(arg1,arg2);
    }
    catch (std::exception &se) {
      t = createException(jenv, &se);
      jenv->Throw(t);
      return 0;
    }
    catch(JavaException & /* je */) {
      // This means there's already an exception waiting in the JVM
      return 0;
    }
    catch (...) {
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("Uncaught exception from C++ API"), 0, 0, 0, 0);
      jenv->Throw(t);
      return 0;
    }
  }
  {
    jresult = createJavaXmlValue(jenv, result);
  }
  
  if (jarg1 != NULL)
  jenv->ReleaseByteArrayElements(jarg1, ldbt1.orig_data, JNI_ABORT);
  
  return jresult;
}


SWIGEXPORT jobject JNICALL Java_com_sleepycat_dbxml_dbxml_1javaJNI_HelperFunctions_1getNextSibling(JNIEnv *jenv, jclass jcls, jbyteArray jarg1, jlong jarg2, jobject jarg2_) {
  jobject jresult = 0 ;
  DBT *arg1 = (DBT *) 0 ;
  XmlResults *arg2 = (XmlResults *) 0 ;
  struct DBT_INFO ldbt1 ;
  XmlValue result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg2_;
  
  if (jarg1 != NULL) {
    ldbt1.dbt.data = ldbt1.orig_data = jenv->GetByteArrayElements(jarg1, (jboolean *)0);
    ldbt1.dbt.size = jenv->GetArrayLength(jarg1);
  } else {
    ldbt1.dbt.data = ldbt1.orig_data = 0;
    ldbt1.dbt.size = 0;
  }
  ldbt1.dbt.flags = DB_DBT_MALLOC;
  arg1 = &ldbt1.dbt;
  
  arg2 = *(XmlResults **)&jarg2; 
  {
    jthrowable t = NULL;
    try {
      result = HelperFunctions_getNextSibling(arg1,arg2);
    }
    catch (std::exception &se) {
      t = createException(jenv, &se);
      jenv->Throw(t);
      return 0;
    }
    catch(JavaException & /* je */) {
      // This means there's already an exception waiting in the JVM
      return 0;
    }
    catch (...) {
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("Uncaught exception from C++ API"), 0, 0, 0, 0);
      jenv->Throw(t);
      return 0;
    }
  }
  {
    jresult = createJavaXmlValue(jenv, result);
  }
  
  if (jarg1 != NULL)
  jenv->ReleaseByteArrayElements(jarg1, ldbt1.orig_data, JNI_ABORT);
  
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_sleepycat_dbxml_dbxml_1javaJNI_HelperFunctions_1getAttributes(JNIEnv *jenv, jclass jcls, jbyteArray jarg1, jlong jarg2, jobject jarg2_) {
  jlong jresult = 0 ;
  DBT *arg1 = (DBT *) 0 ;
  XmlResults *arg2 = (XmlResults *) 0 ;
  struct DBT_INFO ldbt1 ;
  XmlResults *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg2_;
  
  if (jarg1 != NULL) {
    ldbt1.dbt.data = ldbt1.orig_data = jenv->GetByteArrayElements(jarg1, (jboolean *)0);
    ldbt1.dbt.size = jenv->GetArrayLength(jarg1);
  } else {
    ldbt1.dbt.data = ldbt1.orig_data = 0;
    ldbt1.dbt.size = 0;
  }
  ldbt1.dbt.flags = DB_DBT_MALLOC;
  arg1 = &ldbt1.dbt;
  
  arg2 = *(XmlResults **)&jarg2; 
  {
    jthrowable t = NULL;
    try {
      result = (XmlResults *)HelperFunctions_getAttributes(arg1,arg2);
    }
    catch (std::exception &se) {
      t = createException(jenv, &se);
      jenv->Throw(t);
      return 0;
    }
    catch(JavaException & /* je */) {
      // This means there's already an exception waiting in the JVM
      return 0;
    }
    catch (...) {
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("Uncaught exception from C++ API"), 0, 0, 0, 0);
      jenv->Throw(t);
      return 0;
    }
  }
  *(XmlResults **)&jresult = result; 
  
  if (jarg1 != NULL)
  jenv->ReleaseByteArrayElements(jarg1, ldbt1.orig_data, JNI_ABORT);
  
  return jresult;
}


SWIGEXPORT jobject JNICALL Java_com_sleepycat_dbxml_dbxml_1javaJNI_HelperFunctions_1getOwnerElement(JNIEnv *jenv, jclass jcls, jbyteArray jarg1, jlong jarg2, jobject jarg2_) {
  jobject jresult = 0 ;
  DBT *arg1 = (DBT *) 0 ;
  XmlResults *arg2 = (XmlResults *) 0 ;
  struct DBT_INFO ldbt1 ;
  XmlValue result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg2_;
  
  if (jarg1 != NULL) {
    ldbt1.dbt.data = ldbt1.orig_data = jenv->GetByteArrayElements(jarg1, (jboolean *)0);
    ldbt1.dbt.size = jenv->GetArrayLength(jarg1);
  } else {
    ldbt1.dbt.data = ldbt1.orig_data = 0;
    ldbt1.dbt.size = 0;
  }
  ldbt1.dbt.flags = DB_DBT_MALLOC;
  arg1 = &ldbt1.dbt;
  
  arg2 = *(XmlResults **)&jarg2; 
  {
    jthrowable t = NULL;
    try {
      result = HelperFunctions_getOwnerElement(arg1,arg2);
    }
    catch (std::exception &se) {
      t = createException(jenv, &se);
      jenv->Throw(t);
      return 0;
    }
    catch(JavaException & /* je */) {
      // This means there's already an exception waiting in the JVM
      return 0;
    }
    catch (...) {
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("Uncaught exception from C++ API"), 0, 0, 0, 0);
      jenv->Throw(t);
      return 0;
    }
  }
  {
    jresult = createJavaXmlValue(jenv, result);
  }
  
  if (jarg1 != NULL)
  jenv->ReleaseByteArrayElements(jarg1, ldbt1.orig_data, JNI_ABORT);
  
  return jresult;
}


SWIGEXPORT jobject JNICALL Java_com_sleepycat_dbxml_dbxml_1javaJNI_HelperFunctions_1createDocumentValue(JNIEnv *jenv, jclass jcls, jobject jarg1) {
  jobject jresult = 0 ;
  XmlDocument *arg1 = 0 ;
  XmlValue result;
  
  (void)jenv;
  (void)jcls;
  
  XmlDocument cdoc1 = createCPPXmlDocument(jenv, jarg1);
  if (cdoc1.isNull()) return 0;
  arg1 = &cdoc1;
  
  {
    jthrowable t = NULL;
    try {
      result = HelperFunctions_createDocumentValue(*arg1);
    }
    catch (std::exception &se) {
      t = createException(jenv, &se);
      jenv->Throw(t);
      return 0;
    }
    catch(JavaException & /* je */) {
      // This means there's already an exception waiting in the JVM
      return 0;
    }
    catch (...) {
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("Uncaught exception from C++ API"), 0, 0, 0, 0);
      jenv->Throw(t);
      return 0;
    }
  }
  {
    jresult = createJavaXmlValue(jenv, result);
  }
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_sleepycat_dbxml_dbxml_1javaJNI_HelperFunctions_1createResults(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  jlong jresult = 0 ;
  XmlTransaction *arg1 = (XmlTransaction *) 0 ;
  XmlManager *arg2 = (XmlManager *) 0 ;
  XmlResults result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(XmlTransaction **)&jarg1; 
  arg2 = *(XmlManager **)&jarg2; 
  {
    jthrowable t = NULL;
    try {
      result = HelperFunctions_createResults(arg1,arg2);
    }
    catch (std::exception &se) {
      t = createException(jenv, &se);
      jenv->Throw(t);
      return 0;
    }
    catch(JavaException & /* je */) {
      // This means there's already an exception waiting in the JVM
      return 0;
    }
    catch (...) {
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("Uncaught exception from C++ API"), 0, 0, 0, 0);
      jenv->Throw(t);
      return 0;
    }
  }
  *(XmlResults **)&jresult = new XmlResults((const XmlResults &)result); 
  return jresult;
}


SWIGEXPORT jstring JNICALL Java_com_sleepycat_dbxml_dbxml_1javaJNI_HelperFunctions_1getAtomicTypeName(JNIEnv *jenv, jclass jcls, jint jarg1, jstring jarg2) {
  jstring jresult = 0 ;
  int arg1 ;
  std::string arg2 ;
  std::string result;
  
  (void)jenv;
  (void)jcls;
  arg1 = (int)jarg1; 
  
  const char *arg2_pstr = "";
  if(jarg2) {
    arg2_pstr = (const char *)jenv->GetStringUTFChars(jarg2, 0);
  }
  if (!arg2_pstr) return 0;
  arg2 =  std::string(arg2_pstr);
  if (jarg2) {
    jenv->ReleaseStringUTFChars(jarg2, arg2_pstr);
  }
  
  {
    jthrowable t = NULL;
    try {
      result = HelperFunctions_getAtomicTypeName(arg1,arg2);
    }
    catch (std::exception &se) {
      t = createException(jenv, &se);
      jenv->Throw(t);
      return 0;
    }
    catch(JavaException & /* je */) {
      // This means there's already an exception waiting in the JVM
      return 0;
    }
    catch (...) {
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("Uncaught exception from C++ API"), 0, 0, 0, 0);
      jenv->Throw(t);
      return 0;
    }
  }
  jresult = jenv->NewStringUTF((&result)->c_str()); 
  return jresult;
}


SWIGEXPORT jstring JNICALL Java_com_sleepycat_dbxml_dbxml_1javaJNI_HelperFunctions_1getAtomicTypeURI(JNIEnv *jenv, jclass jcls, jint jarg1, jstring jarg2) {
  jstring jresult = 0 ;
  int arg1 ;
  std::string arg2 ;
  std::string result;
  
  (void)jenv;
  (void)jcls;
  arg1 = (int)jarg1; 
  
  const char *arg2_pstr = "";
  if(jarg2) {
    arg2_pstr = (const char *)jenv->GetStringUTFChars(jarg2, 0);
  }
  if (!arg2_pstr) return 0;
  arg2 =  std::string(arg2_pstr);
  if (jarg2) {
    jenv->ReleaseStringUTFChars(jarg2, arg2_pstr);
  }
  
  {
    jthrowable t = NULL;
    try {
      result = HelperFunctions_getAtomicTypeURI(arg1,arg2);
    }
    catch (std::exception &se) {
      t = createException(jenv, &se);
      jenv->Throw(t);
      return 0;
    }
    catch(JavaException & /* je */) {
      // This means there's already an exception waiting in the JVM
      return 0;
    }
    catch (...) {
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("Uncaught exception from C++ API"), 0, 0, 0, 0);
      jenv->Throw(t);
      return 0;
    }
  }
  jresult = jenv->NewStringUTF((&result)->c_str()); 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_sleepycat_dbxml_dbxml_1javaJNI_HelperFunctions_1validateString(JNIEnv *jenv, jclass jcls, jint jarg1, jstring jarg2) {
  int arg1 ;
  std::string arg2 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = (int)jarg1; 
  
  const char *arg2_pstr = "";
  if(jarg2) {
    arg2_pstr = (const char *)jenv->GetStringUTFChars(jarg2, 0);
  }
  if (!arg2_pstr) return ;
  arg2 =  std::string(arg2_pstr);
  if (jarg2) {
    jenv->ReleaseStringUTFChars(jarg2, arg2_pstr);
  }
  
  {
    jthrowable t = NULL;
    try {
      HelperFunctions_validateString(arg1,arg2);
    }
    catch (std::exception &se) {
      t = createException(jenv, &se);
      jenv->Throw(t);
      return ;
    }
    catch(JavaException & /* je */) {
      // This means there's already an exception waiting in the JVM
      return ;
    }
    catch (...) {
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("Uncaught exception from C++ API"), 0, 0, 0, 0);
      jenv->Throw(t);
      return ;
    }
  }
}


SWIGEXPORT jlong JNICALL Java_com_sleepycat_dbxml_dbxml_1javaJNI_HelperFunctions_1getContentAsXmlInputStream(JNIEnv *jenv, jclass jcls, jobject jarg1) {
  jlong jresult = 0 ;
  XmlDocument *arg1 = 0 ;
  XmlInputStream *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  
  XmlDocument cdoc1 = createCPPXmlDocument(jenv, jarg1);
  if (cdoc1.isNull()) return 0;
  arg1 = &cdoc1;
  
  {
    jthrowable t = NULL;
    try {
      result = (XmlInputStream *)HelperFunctions_getContentAsXmlInputStream(*arg1);
    }
    catch (std::exception &se) {
      t = createException(jenv, &se);
      jenv->Throw(t);
      return 0;
    }
    catch(JavaException & /* je */) {
      // This means there's already an exception waiting in the JVM
      return 0;
    }
    catch (...) {
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("Uncaught exception from C++ API"), 0, 0, 0, 0);
      jenv->Throw(t);
      return 0;
    }
  }
  *(XmlInputStream **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_sleepycat_dbxml_dbxml_1javaJNI_HelperFunctions_1getContentAsEventReader(JNIEnv *jenv, jclass jcls, jobject jarg1) {
  jlong jresult = 0 ;
  XmlDocument *arg1 = 0 ;
  XmlEventReader *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  
  XmlDocument cdoc1 = createCPPXmlDocument(jenv, jarg1);
  if (cdoc1.isNull()) return 0;
  arg1 = &cdoc1;
  
  {
    jthrowable t = NULL;
    try {
      result = (XmlEventReader *) &HelperFunctions_getContentAsEventReader(*arg1);
    }
    catch (std::exception &se) {
      t = createException(jenv, &se);
      jenv->Throw(t);
      return 0;
    }
    catch(JavaException & /* je */) {
      // This means there's already an exception waiting in the JVM
      return 0;
    }
    catch (...) {
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("Uncaught exception from C++ API"), 0, 0, 0, 0);
      jenv->Throw(t);
      return 0;
    }
  }
  *(XmlEventReader **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_sleepycat_dbxml_dbxml_1javaJNI_HelperFunctions_1getContentAsEventWriter(JNIEnv *jenv, jclass jcls, jobject jarg1, jlong jarg2, jobject jarg2_) {
  XmlDocument *arg1 = 0 ;
  XmlEventWriter *arg2 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg2_;
  
  XmlDocument cdoc1 = createCPPXmlDocument(jenv, jarg1);
  if (cdoc1.isNull()) return ;
  arg1 = &cdoc1;
  
  arg2 = *(XmlEventWriter **)&jarg2;
  if(!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "XmlEventWriter & reference is null");
    return ;
  } 
  {
    jthrowable t = NULL;
    try {
      HelperFunctions_getContentAsEventWriter(*arg1,*arg2);
    }
    catch (std::exception &se) {
      t = createException(jenv, &se);
      jenv->Throw(t);
      return ;
    }
    catch(JavaException & /* je */) {
      // This means there's already an exception waiting in the JVM
      return ;
    }
    catch (...) {
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("Uncaught exception from C++ API"), 0, 0, 0, 0);
      jenv->Throw(t);
      return ;
    }
  }
}


SWIGEXPORT jstring JNICALL Java_com_sleepycat_dbxml_dbxml_1javaJNI_HelperFunctions_1getContentAsString(JNIEnv *jenv, jclass jcls, jobject jarg1) {
  jstring jresult = 0 ;
  XmlDocument *arg1 = 0 ;
  std::string result;
  
  (void)jenv;
  (void)jcls;
  
  XmlDocument cdoc1 = createCPPXmlDocument(jenv, jarg1);
  if (cdoc1.isNull()) return 0;
  arg1 = &cdoc1;
  
  {
    jthrowable t = NULL;
    try {
      result = HelperFunctions_getContentAsString(*arg1);
    }
    catch (std::exception &se) {
      t = createException(jenv, &se);
      jenv->Throw(t);
      return 0;
    }
    catch(JavaException & /* je */) {
      // This means there's already an exception waiting in the JVM
      return 0;
    }
    catch (...) {
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("Uncaught exception from C++ API"), 0, 0, 0, 0);
      jenv->Throw(t);
      return 0;
    }
  }
  jresult = jenv->NewStringUTF((&result)->c_str()); 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_sleepycat_dbxml_dbxml_1javaJNI_HelperFunctions_1getContent(JNIEnv *jenv, jclass jcls, jobject jarg1) {
  jlong jresult = 0 ;
  XmlDocument *arg1 = 0 ;
  XmlData result;
  
  (void)jenv;
  (void)jcls;
  
  XmlDocument cdoc1 = createCPPXmlDocument(jenv, jarg1);
  if (cdoc1.isNull()) return 0;
  arg1 = &cdoc1;
  
  {
    jthrowable t = NULL;
    try {
      result = HelperFunctions_getContent(*arg1);
    }
    catch (std::exception &se) {
      t = createException(jenv, &se);
      jenv->Throw(t);
      return 0;
    }
    catch(JavaException & /* je */) {
      // This means there's already an exception waiting in the JVM
      return 0;
    }
    catch (...) {
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("Uncaught exception from C++ API"), 0, 0, 0, 0);
      jenv->Throw(t);
      return 0;
    }
  }
  *(XmlData **)&jresult = new XmlData((const XmlData &)result); 
  return jresult;
}


SWIGEXPORT jobject JNICALL Java_com_sleepycat_dbxml_dbxml_1javaJNI_HelperFunctions_1getMetaData(JNIEnv *jenv, jclass jcls, jstring jarg1, jstring jarg2, jobject jarg3) {
  jobject jresult = 0 ;
  std::string arg1 ;
  std::string arg2 ;
  XmlDocument *arg3 = 0 ;
  XmlValue result;
  
  (void)jenv;
  (void)jcls;
  
  const char *arg1_pstr = "";
  if(jarg1) {
    arg1_pstr = (const char *)jenv->GetStringUTFChars(jarg1, 0);
  }
  if (!arg1_pstr) return 0;
  arg1 =  std::string(arg1_pstr);
  if (jarg1) {
    jenv->ReleaseStringUTFChars(jarg1, arg1_pstr);
  }
  
  
  const char *arg2_pstr = "";
  if(jarg2) {
    arg2_pstr = (const char *)jenv->GetStringUTFChars(jarg2, 0);
  }
  if (!arg2_pstr) return 0;
  arg2 =  std::string(arg2_pstr);
  if (jarg2) {
    jenv->ReleaseStringUTFChars(jarg2, arg2_pstr);
  }
  
  
  XmlDocument cdoc3 = createCPPXmlDocument(jenv, jarg3);
  if (cdoc3.isNull()) return 0;
  arg3 = &cdoc3;
  
  {
    jthrowable t = NULL;
    try {
      result = HelperFunctions_getMetaData(arg1,arg2,*arg3);
    }
    catch (std::exception &se) {
      t = createException(jenv, &se);
      jenv->Throw(t);
      return 0;
    }
    catch(JavaException & /* je */) {
      // This means there's already an exception waiting in the JVM
      return 0;
    }
    catch (...) {
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("Uncaught exception from C++ API"), 0, 0, 0, 0);
      jenv->Throw(t);
      return 0;
    }
  }
  {
    jresult = createJavaXmlValue(jenv, result);
  }
  return jresult;
}


SWIGEXPORT jstring JNICALL Java_com_sleepycat_dbxml_dbxml_1javaJNI_HelperFunctions_1verifyDefaultCollection(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2, jstring jarg3) {
  jstring jresult = 0 ;
  SwigValueWrapper< XmlManager > arg1 ;
  std::string arg2 ;
  std::string arg3 ;
  XmlManager *argp1 ;
  std::string result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  argp1 = *(XmlManager **)&jarg1; 
  if (!argp1) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Attempt to dereference null XmlManager");
    return 0;
  }
  arg1 = *argp1; 
  
  const char *arg2_pstr = "";
  if(jarg2) {
    arg2_pstr = (const char *)jenv->GetStringUTFChars(jarg2, 0);
  }
  if (!arg2_pstr) return 0;
  arg2 =  std::string(arg2_pstr);
  if (jarg2) {
    jenv->ReleaseStringUTFChars(jarg2, arg2_pstr);
  }
  
  
  const char *arg3_pstr = "";
  if(jarg3) {
    arg3_pstr = (const char *)jenv->GetStringUTFChars(jarg3, 0);
  }
  if (!arg3_pstr) return 0;
  arg3 =  std::string(arg3_pstr);
  if (jarg3) {
    jenv->ReleaseStringUTFChars(jarg3, arg3_pstr);
  }
  
  {
    jthrowable t = NULL;
    try {
      result = HelperFunctions_verifyDefaultCollection(arg1,arg2,arg3);
    }
    catch (std::exception &se) {
      t = createException(jenv, &se);
      jenv->Throw(t);
      return 0;
    }
    catch(JavaException & /* je */) {
      // This means there's already an exception waiting in the JVM
      return 0;
    }
    catch (...) {
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("Uncaught exception from C++ API"), 0, 0, 0, 0);
      jenv->Throw(t);
      return 0;
    }
  }
  jresult = jenv->NewStringUTF((&result)->c_str()); 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_sleepycat_dbxml_dbxml_1javaJNI_HelperFunctions_1verifyBaseURI(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2) {
  SwigValueWrapper< XmlManager > arg1 ;
  std::string arg2 ;
  XmlManager *argp1 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  argp1 = *(XmlManager **)&jarg1; 
  if (!argp1) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Attempt to dereference null XmlManager");
    return ;
  }
  arg1 = *argp1; 
  
  const char *arg2_pstr = "";
  if(jarg2) {
    arg2_pstr = (const char *)jenv->GetStringUTFChars(jarg2, 0);
  }
  if (!arg2_pstr) return ;
  arg2 =  std::string(arg2_pstr);
  if (jarg2) {
    jenv->ReleaseStringUTFChars(jarg2, arg2_pstr);
  }
  
  {
    jthrowable t = NULL;
    try {
      HelperFunctions_verifyBaseURI(arg1,arg2);
    }
    catch (std::exception &se) {
      t = createException(jenv, &se);
      jenv->Throw(t);
      return ;
    }
    catch(JavaException & /* je */) {
      // This means there's already an exception waiting in the JVM
      return ;
    }
    catch (...) {
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("Uncaught exception from C++ API"), 0, 0, 0, 0);
      jenv->Throw(t);
      return ;
    }
  }
}


SWIGEXPORT jint JNICALL Java_com_sleepycat_dbxml_dbxml_1javaJNI_XmlData_1get_1size(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  XmlData *arg1 = (XmlData *) 0 ;
  size_t result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(XmlData **)&jarg1; 
  
  if (!jarg1) {
    jenv->Throw((jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INVALID_VALUE,
        jenv->NewStringUTF("null object - call after object destroyed?"),
        0, 0, 0, 0));					
    return 0;
  }
  
  {
    jthrowable t = NULL;
    try {
      result = ((XmlData const *)arg1)->get_size();
    }
    catch (std::exception &se) {
      t = createException(jenv, &se);
      jenv->Throw(t);
      return 0;
    }
    catch(JavaException & /* je */) {
      // This means there's already an exception waiting in the JVM
      return 0;
    }
    catch (...) {
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("Uncaught exception from C++ API"), 0, 0, 0, 0);
      jenv->Throw(t);
      return 0;
    }
  }
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_sleepycat_dbxml_dbxml_1javaJNI_XmlData_1set_1size(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  XmlData *arg1 = (XmlData *) 0 ;
  size_t arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(XmlData **)&jarg1; 
  arg2 = (size_t)jarg2; 
  
  if (!jarg1) {
    jenv->Throw((jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INVALID_VALUE,
        jenv->NewStringUTF("null object - call after object destroyed?"),
        0, 0, 0, 0));					
    return ;
  }
  
  {
    jthrowable t = NULL;
    try {
      (arg1)->set_size(arg2);
    }
    catch (std::exception &se) {
      t = createException(jenv, &se);
      jenv->Throw(t);
      return ;
    }
    catch(JavaException & /* je */) {
      // This means there's already an exception waiting in the JVM
      return ;
    }
    catch (...) {
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("Uncaught exception from C++ API"), 0, 0, 0, 0);
      jenv->Throw(t);
      return ;
    }
  }
}


SWIGEXPORT void JNICALL Java_com_sleepycat_dbxml_dbxml_1javaJNI_XmlData_1reserve(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  XmlData *arg1 = (XmlData *) 0 ;
  size_t arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(XmlData **)&jarg1; 
  arg2 = (size_t)jarg2; 
  
  if (!jarg1) {
    jenv->Throw((jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INVALID_VALUE,
        jenv->NewStringUTF("null object - call after object destroyed?"),
        0, 0, 0, 0));					
    return ;
  }
  
  {
    jthrowable t = NULL;
    try {
      (arg1)->reserve(arg2);
    }
    catch (std::exception &se) {
      t = createException(jenv, &se);
      jenv->Throw(t);
      return ;
    }
    catch(JavaException & /* je */) {
      // This means there's already an exception waiting in the JVM
      return ;
    }
    catch (...) {
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("Uncaught exception from C++ API"), 0, 0, 0, 0);
      jenv->Throw(t);
      return ;
    }
  }
}


SWIGEXPORT jint JNICALL Java_com_sleepycat_dbxml_dbxml_1javaJNI_XmlData_1getReservedSize(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  XmlData *arg1 = (XmlData *) 0 ;
  size_t result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(XmlData **)&jarg1; 
  
  if (!jarg1) {
    jenv->Throw((jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INVALID_VALUE,
        jenv->NewStringUTF("null object - call after object destroyed?"),
        0, 0, 0, 0));					
    return 0;
  }
  
  {
    jthrowable t = NULL;
    try {
      result = ((XmlData const *)arg1)->getReservedSize();
    }
    catch (std::exception &se) {
      t = createException(jenv, &se);
      jenv->Throw(t);
      return 0;
    }
    catch(JavaException & /* je */) {
      // This means there's already an exception waiting in the JVM
      return 0;
    }
    catch (...) {
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("Uncaught exception from C++ API"), 0, 0, 0, 0);
      jenv->Throw(t);
      return 0;
    }
  }
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_sleepycat_dbxml_dbxml_1javaJNI_XmlData_1adoptBuffer(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  XmlData *arg1 = (XmlData *) 0 ;
  XmlData *arg2 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(XmlData **)&jarg1; 
  arg2 = *(XmlData **)&jarg2;
  if(!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "XmlData & reference is null");
    return ;
  } 
  
  if (!jarg1) {
    jenv->Throw((jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INVALID_VALUE,
        jenv->NewStringUTF("null object - call after object destroyed?"),
        0, 0, 0, 0));					
    return ;
  }
  
  {
    jthrowable t = NULL;
    try {
      (arg1)->adoptBuffer(*arg2);
    }
    catch (std::exception &se) {
      t = createException(jenv, &se);
      jenv->Throw(t);
      return ;
    }
    catch(JavaException & /* je */) {
      // This means there's already an exception waiting in the JVM
      return ;
    }
    catch (...) {
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("Uncaught exception from C++ API"), 0, 0, 0, 0);
      jenv->Throw(t);
      return ;
    }
  }
}


SWIGEXPORT void JNICALL Java_com_sleepycat_dbxml_dbxml_1javaJNI_XmlData_1append(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jbyteArray jarg2) {
  XmlData *arg1 = (XmlData *) 0 ;
  DBT *arg2 = (DBT *) 0 ;
  struct DBT_INFO ldbt2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(XmlData **)&jarg1; 
  
  if (jarg2 != NULL) {
    ldbt2.dbt.data = ldbt2.orig_data = jenv->GetByteArrayElements(jarg2, (jboolean *)0);
    ldbt2.dbt.size = jenv->GetArrayLength(jarg2);
  } else {
    ldbt2.dbt.data = ldbt2.orig_data = 0;
    ldbt2.dbt.size = 0;
  }
  ldbt2.dbt.flags = DB_DBT_MALLOC;
  arg2 = &ldbt2.dbt;
  
  
  if (!jarg1) {
    jenv->Throw((jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INVALID_VALUE,
        jenv->NewStringUTF("null object - call after object destroyed?"),
        0, 0, 0, 0));					
    return ;
  }
  
  {
    jthrowable t = NULL;
    try {
      XmlData_append(arg1,arg2);
    }
    catch (std::exception &se) {
      t = createException(jenv, &se);
      jenv->Throw(t);
      return ;
    }
    catch(JavaException & /* je */) {
      // This means there's already an exception waiting in the JVM
      return ;
    }
    catch (...) {
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("Uncaught exception from C++ API"), 0, 0, 0, 0);
      jenv->Throw(t);
      return ;
    }
  }
  
  if (jarg2 != NULL)
  jenv->ReleaseByteArrayElements(jarg2, ldbt2.orig_data, JNI_ABORT);
  
}


SWIGEXPORT void JNICALL Java_com_sleepycat_dbxml_dbxml_1javaJNI_XmlData_1set(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jbyteArray jarg2) {
  XmlData *arg1 = (XmlData *) 0 ;
  DBT *arg2 = (DBT *) 0 ;
  struct DBT_INFO ldbt2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(XmlData **)&jarg1; 
  
  if (jarg2 != NULL) {
    ldbt2.dbt.data = ldbt2.orig_data = jenv->GetByteArrayElements(jarg2, (jboolean *)0);
    ldbt2.dbt.size = jenv->GetArrayLength(jarg2);
  } else {
    ldbt2.dbt.data = ldbt2.orig_data = 0;
    ldbt2.dbt.size = 0;
  }
  ldbt2.dbt.flags = DB_DBT_MALLOC;
  arg2 = &ldbt2.dbt;
  
  
  if (!jarg1) {
    jenv->Throw((jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INVALID_VALUE,
        jenv->NewStringUTF("null object - call after object destroyed?"),
        0, 0, 0, 0));					
    return ;
  }
  
  {
    jthrowable t = NULL;
    try {
      XmlData_set(arg1,arg2);
    }
    catch (std::exception &se) {
      t = createException(jenv, &se);
      jenv->Throw(t);
      return ;
    }
    catch(JavaException & /* je */) {
      // This means there's already an exception waiting in the JVM
      return ;
    }
    catch (...) {
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("Uncaught exception from C++ API"), 0, 0, 0, 0);
      jenv->Throw(t);
      return ;
    }
  }
  
  if (jarg2 != NULL)
  jenv->ReleaseByteArrayElements(jarg2, ldbt2.orig_data, JNI_ABORT);
  
}


SWIGEXPORT jlong JNICALL Java_com_sleepycat_dbxml_dbxml_1javaJNI_new_1XmlManager(JNIEnv *jenv, jclass jcls, jobject jarg1, jint jarg2) {
  jlong jresult = 0 ;
  DB_ENV *arg1 = (DB_ENV *) 0 ;
  u_int32_t arg2 ;
  XmlManager *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  {
    arg1 = get_DB_ENV(jenv, jarg1);
  }
  arg2 = (u_int32_t)jarg2; 
  {
    jthrowable t = NULL;
    try {
      result = (XmlManager *)new XmlManager(arg1,arg2);
    }
    catch (std::exception &se) {
      t = createException(jenv, &se);
      jenv->Throw(t);
      return 0;
    }
    catch(JavaException & /* je */) {
      // This means there's already an exception waiting in the JVM
      return 0;
    }
    catch (...) {
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("Uncaught exception from C++ API"), 0, 0, 0, 0);
      jenv->Throw(t);
      return 0;
    }
  }
  *(XmlManager **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_sleepycat_dbxml_dbxml_1javaJNI_delete_1XmlManager(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  XmlManager *arg1 = (XmlManager *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(XmlManager **)&jarg1; 
  
  if (!jarg1) {
    jenv->Throw((jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INVALID_VALUE,
        jenv->NewStringUTF("null object - call after object destroyed?"),
        0, 0, 0, 0));					
    return ;
  }
  
  {
    jthrowable t = NULL;
    try {
      delete arg1;
    }
    catch (std::exception &se) {
      t = createException(jenv, &se);
      jenv->Throw(t);
      return ;
    }
    catch(JavaException & /* je */) {
      // This means there's already an exception waiting in the JVM
      return ;
    }
    catch (...) {
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("Uncaught exception from C++ API"), 0, 0, 0, 0);
      jenv->Throw(t);
      return ;
    }
  }
}


SWIGEXPORT jstring JNICALL Java_com_sleepycat_dbxml_dbxml_1javaJNI_XmlManager_1getHome(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jstring jresult = 0 ;
  XmlManager *arg1 = (XmlManager *) 0 ;
  std::string *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(XmlManager **)&jarg1; 
  
  if (!jarg1) {
    jenv->Throw((jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INVALID_VALUE,
        jenv->NewStringUTF("null object - call after object destroyed?"),
        0, 0, 0, 0));					
    return 0;
  }
  
  {
    jthrowable t = NULL;
    try {
      result = (std::string *) &((XmlManager const *)arg1)->getHome();
    }
    catch (std::exception &se) {
      t = createException(jenv, &se);
      jenv->Throw(t);
      return 0;
    }
    catch(JavaException & /* je */) {
      // This means there's already an exception waiting in the JVM
      return 0;
    }
    catch (...) {
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("Uncaught exception from C++ API"), 0, 0, 0, 0);
      jenv->Throw(t);
      return 0;
    }
  }
  jresult = jenv->NewStringUTF(result->c_str()); 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_com_sleepycat_dbxml_dbxml_1javaJNI_XmlManager_1getImplicitTimezone(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  XmlManager *arg1 = (XmlManager *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(XmlManager **)&jarg1; 
  
  if (!jarg1) {
    jenv->Throw((jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INVALID_VALUE,
        jenv->NewStringUTF("null object - call after object destroyed?"),
        0, 0, 0, 0));					
    return 0;
  }
  
  {
    jthrowable t = NULL;
    try {
      result = (int)((XmlManager const *)arg1)->getImplicitTimezone();
    }
    catch (std::exception &se) {
      t = createException(jenv, &se);
      jenv->Throw(t);
      return 0;
    }
    catch(JavaException & /* je */) {
      // This means there's already an exception waiting in the JVM
      return 0;
    }
    catch (...) {
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("Uncaught exception from C++ API"), 0, 0, 0, 0);
      jenv->Throw(t);
      return 0;
    }
  }
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_sleepycat_dbxml_dbxml_1javaJNI_XmlManager_1setImplicitTimezone(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  XmlManager *arg1 = (XmlManager *) 0 ;
  int arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(XmlManager **)&jarg1; 
  arg2 = (int)jarg2; 
  
  if (!jarg1) {
    jenv->Throw((jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INVALID_VALUE,
        jenv->NewStringUTF("null object - call after object destroyed?"),
        0, 0, 0, 0));					
    return ;
  }
  
  {
    jthrowable t = NULL;
    try {
      (arg1)->setImplicitTimezone(arg2);
    }
    catch (std::exception &se) {
      t = createException(jenv, &se);
      jenv->Throw(t);
      return ;
    }
    catch(JavaException & /* je */) {
      // This means there's already an exception waiting in the JVM
      return ;
    }
    catch (...) {
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("Uncaught exception from C++ API"), 0, 0, 0, 0);
      jenv->Throw(t);
      return ;
    }
  }
}


SWIGEXPORT jint JNICALL Java_com_sleepycat_dbxml_dbxml_1javaJNI_XmlManager_1existsContainer(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2) {
  jint jresult = 0 ;
  XmlManager *arg1 = (XmlManager *) 0 ;
  std::string *arg2 = 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(XmlManager **)&jarg1; 
  
  const char *arg2_pstr = "";
  if(jarg2) {
    arg2_pstr = (const char *)jenv->GetStringUTFChars(jarg2, 0);
  }
  if (!arg2_pstr) return 0;
  std::string arg2_str(arg2_pstr);
  arg2 = &arg2_str;
  if (jarg2) {
    jenv->ReleaseStringUTFChars(jarg2, arg2_pstr);
  }
  
  
  if (!jarg1) {
    jenv->Throw((jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INVALID_VALUE,
        jenv->NewStringUTF("null object - call after object destroyed?"),
        0, 0, 0, 0));					
    return 0;
  }
  
  {
    jthrowable t = NULL;
    try {
      result = (int)(arg1)->existsContainer((std::string const &)*arg2);
    }
    catch (std::exception &se) {
      t = createException(jenv, &se);
      jenv->Throw(t);
      return 0;
    }
    catch(JavaException & /* je */) {
      // This means there's already an exception waiting in the JVM
      return 0;
    }
    catch (...) {
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("Uncaught exception from C++ API"), 0, 0, 0, 0);
      jenv->Throw(t);
      return 0;
    }
  }
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_sleepycat_dbxml_dbxml_1javaJNI_XmlManager_1removeContainer_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2) {
  XmlManager *arg1 = (XmlManager *) 0 ;
  std::string *arg2 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(XmlManager **)&jarg1; 
  
  const char *arg2_pstr = "";
  if(jarg2) {
    arg2_pstr = (const char *)jenv->GetStringUTFChars(jarg2, 0);
  }
  if (!arg2_pstr) return ;
  std::string arg2_str(arg2_pstr);
  arg2 = &arg2_str;
  if (jarg2) {
    jenv->ReleaseStringUTFChars(jarg2, arg2_pstr);
  }
  
  
  if (!jarg1) {
    jenv->Throw((jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INVALID_VALUE,
        jenv->NewStringUTF("null object - call after object destroyed?"),
        0, 0, 0, 0));					
    return ;
  }
  
  {
    jthrowable t = NULL;
    try {
      (arg1)->removeContainer((std::string const &)*arg2);
    }
    catch (std::exception &se) {
      t = createException(jenv, &se);
      jenv->Throw(t);
      return ;
    }
    catch(JavaException & /* je */) {
      // This means there's already an exception waiting in the JVM
      return ;
    }
    catch (...) {
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("Uncaught exception from C++ API"), 0, 0, 0, 0);
      jenv->Throw(t);
      return ;
    }
  }
}


SWIGEXPORT void JNICALL Java_com_sleepycat_dbxml_dbxml_1javaJNI_XmlManager_1removeContainer_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_, jstring jarg3) {
  XmlManager *arg1 = (XmlManager *) 0 ;
  XmlTransaction *arg2 = 0 ;
  std::string *arg3 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(XmlManager **)&jarg1; 
  arg2 = *(XmlTransaction **)&jarg2;
  if(!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "XmlTransaction & reference is null");
    return ;
  } 
  
  const char *arg3_pstr = "";
  if(jarg3) {
    arg3_pstr = (const char *)jenv->GetStringUTFChars(jarg3, 0);
  }
  if (!arg3_pstr) return ;
  std::string arg3_str(arg3_pstr);
  arg3 = &arg3_str;
  if (jarg3) {
    jenv->ReleaseStringUTFChars(jarg3, arg3_pstr);
  }
  
  
  if (!jarg1) {
    jenv->Throw((jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INVALID_VALUE,
        jenv->NewStringUTF("null object - call after object destroyed?"),
        0, 0, 0, 0));					
    return ;
  }
  
  {
    jthrowable t = NULL;
    try {
      (arg1)->removeContainer(*arg2,(std::string const &)*arg3);
    }
    catch (std::exception &se) {
      t = createException(jenv, &se);
      jenv->Throw(t);
      return ;
    }
    catch(JavaException & /* je */) {
      // This means there's already an exception waiting in the JVM
      return ;
    }
    catch (...) {
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("Uncaught exception from C++ API"), 0, 0, 0, 0);
      jenv->Throw(t);
      return ;
    }
  }
}


SWIGEXPORT void JNICALL Java_com_sleepycat_dbxml_dbxml_1javaJNI_XmlManager_1renameContainer_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2, jstring jarg3) {
  XmlManager *arg1 = (XmlManager *) 0 ;
  std::string *arg2 = 0 ;
  std::string *arg3 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(XmlManager **)&jarg1; 
  
  const char *arg2_pstr = "";
  if(jarg2) {
    arg2_pstr = (const char *)jenv->GetStringUTFChars(jarg2, 0);
  }
  if (!arg2_pstr) return ;
  std::string arg2_str(arg2_pstr);
  arg2 = &arg2_str;
  if (jarg2) {
    jenv->ReleaseStringUTFChars(jarg2, arg2_pstr);
  }
  
  
  const char *arg3_pstr = "";
  if(jarg3) {
    arg3_pstr = (const char *)jenv->GetStringUTFChars(jarg3, 0);
  }
  if (!arg3_pstr) return ;
  std::string arg3_str(arg3_pstr);
  arg3 = &arg3_str;
  if (jarg3) {
    jenv->ReleaseStringUTFChars(jarg3, arg3_pstr);
  }
  
  
  if (!jarg1) {
    jenv->Throw((jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INVALID_VALUE,
        jenv->NewStringUTF("null object - call after object destroyed?"),
        0, 0, 0, 0));					
    return ;
  }
  
  {
    jthrowable t = NULL;
    try {
      (arg1)->renameContainer((std::string const &)*arg2,(std::string const &)*arg3);
    }
    catch (std::exception &se) {
      t = createException(jenv, &se);
      jenv->Throw(t);
      return ;
    }
    catch(JavaException & /* je */) {
      // This means there's already an exception waiting in the JVM
      return ;
    }
    catch (...) {
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("Uncaught exception from C++ API"), 0, 0, 0, 0);
      jenv->Throw(t);
      return ;
    }
  }
}


SWIGEXPORT void JNICALL Java_com_sleepycat_dbxml_dbxml_1javaJNI_XmlManager_1renameContainer_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_, jstring jarg3, jstring jarg4) {
  XmlManager *arg1 = (XmlManager *) 0 ;
  XmlTransaction *arg2 = 0 ;
  std::string *arg3 = 0 ;
  std::string *arg4 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(XmlManager **)&jarg1; 
  arg2 = *(XmlTransaction **)&jarg2;
  if(!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "XmlTransaction & reference is null");
    return ;
  } 
  
  const char *arg3_pstr = "";
  if(jarg3) {
    arg3_pstr = (const char *)jenv->GetStringUTFChars(jarg3, 0);
  }
  if (!arg3_pstr) return ;
  std::string arg3_str(arg3_pstr);
  arg3 = &arg3_str;
  if (jarg3) {
    jenv->ReleaseStringUTFChars(jarg3, arg3_pstr);
  }
  
  
  const char *arg4_pstr = "";
  if(jarg4) {
    arg4_pstr = (const char *)jenv->GetStringUTFChars(jarg4, 0);
  }
  if (!arg4_pstr) return ;
  std::string arg4_str(arg4_pstr);
  arg4 = &arg4_str;
  if (jarg4) {
    jenv->ReleaseStringUTFChars(jarg4, arg4_pstr);
  }
  
  
  if (!jarg1) {
    jenv->Throw((jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INVALID_VALUE,
        jenv->NewStringUTF("null object - call after object destroyed?"),
        0, 0, 0, 0));					
    return ;
  }
  
  {
    jthrowable t = NULL;
    try {
      (arg1)->renameContainer(*arg2,(std::string const &)*arg3,(std::string const &)*arg4);
    }
    catch (std::exception &se) {
      t = createException(jenv, &se);
      jenv->Throw(t);
      return ;
    }
    catch(JavaException & /* je */) {
      // This means there's already an exception waiting in the JVM
      return ;
    }
    catch (...) {
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("Uncaught exception from C++ API"), 0, 0, 0, 0);
      jenv->Throw(t);
      return ;
    }
  }
}


SWIGEXPORT jlong JNICALL Java_com_sleepycat_dbxml_dbxml_1javaJNI_XmlManager_1createStdInInputStream(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  XmlManager *arg1 = (XmlManager *) 0 ;
  XmlInputStream *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(XmlManager **)&jarg1; 
  
  if (!jarg1) {
    jenv->Throw((jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INVALID_VALUE,
        jenv->NewStringUTF("null object - call after object destroyed?"),
        0, 0, 0, 0));					
    return 0;
  }
  
  {
    jthrowable t = NULL;
    try {
      result = (XmlInputStream *)XmlManager_createStdInInputStream((XmlManager const *)arg1);
    }
    catch (std::exception &se) {
      t = createException(jenv, &se);
      jenv->Throw(t);
      return 0;
    }
    catch(JavaException & /* je */) {
      // This means there's already an exception waiting in the JVM
      return 0;
    }
    catch (...) {
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("Uncaught exception from C++ API"), 0, 0, 0, 0);
      jenv->Throw(t);
      return 0;
    }
  }
  *(XmlInputStream **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_sleepycat_dbxml_dbxml_1javaJNI_XmlManager_1createLocalFileInputStream(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2) {
  jlong jresult = 0 ;
  XmlManager *arg1 = (XmlManager *) 0 ;
  std::string *arg2 = 0 ;
  XmlInputStream *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(XmlManager **)&jarg1; 
  
  const char *arg2_pstr = "";
  if(jarg2) {
    arg2_pstr = (const char *)jenv->GetStringUTFChars(jarg2, 0);
  }
  if (!arg2_pstr) return 0;
  std::string arg2_str(arg2_pstr);
  arg2 = &arg2_str;
  if (jarg2) {
    jenv->ReleaseStringUTFChars(jarg2, arg2_pstr);
  }
  
  
  if (!jarg1) {
    jenv->Throw((jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INVALID_VALUE,
        jenv->NewStringUTF("null object - call after object destroyed?"),
        0, 0, 0, 0));					
    return 0;
  }
  
  {
    jthrowable t = NULL;
    try {
      result = (XmlInputStream *)XmlManager_createLocalFileInputStream((XmlManager const *)arg1,(std::string const &)*arg2);
    }
    catch (std::exception &se) {
      t = createException(jenv, &se);
      jenv->Throw(t);
      return 0;
    }
    catch(JavaException & /* je */) {
      // This means there's already an exception waiting in the JVM
      return 0;
    }
    catch (...) {
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("Uncaught exception from C++ API"), 0, 0, 0, 0);
      jenv->Throw(t);
      return 0;
    }
  }
  *(XmlInputStream **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_sleepycat_dbxml_dbxml_1javaJNI_XmlManager_1createMemBufInputStream_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2, jlong jarg3, jstring jarg4, jboolean jarg5) {
  jlong jresult = 0 ;
  XmlManager *arg1 = (XmlManager *) 0 ;
  char *arg2 = (char *) 0 ;
  unsigned int arg3 ;
  char *arg4 = (char *) 0 ;
  bool arg5 ;
  XmlInputStream *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(XmlManager **)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)jenv->GetStringUTFChars(jarg2, 0);
    if (!arg2) return 0;
  }
  arg3 = (unsigned int)jarg3; 
  arg4 = 0;
  if (jarg4) {
    arg4 = (char *)jenv->GetStringUTFChars(jarg4, 0);
    if (!arg4) return 0;
  }
  
  arg5 = (jarg5 != JNI_FALSE);
  
  
  if (!jarg1) {
    jenv->Throw((jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INVALID_VALUE,
        jenv->NewStringUTF("null object - call after object destroyed?"),
        0, 0, 0, 0));					
    return 0;
  }
  
  {
    jthrowable t = NULL;
    try {
      result = (XmlInputStream *)XmlManager_createMemBufInputStream__SWIG_0((XmlManager const *)arg1,(char const *)arg2,arg3,(char const *)arg4,arg5);
    }
    catch (std::exception &se) {
      t = createException(jenv, &se);
      jenv->Throw(t);
      return 0;
    }
    catch(JavaException & /* je */) {
      // This means there's already an exception waiting in the JVM
      return 0;
    }
    catch (...) {
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("Uncaught exception from C++ API"), 0, 0, 0, 0);
      jenv->Throw(t);
      return 0;
    }
  }
  *(XmlInputStream **)&jresult = result; 
  if (arg2) jenv->ReleaseStringUTFChars(jarg2, (const char *)arg2);
  if (arg4) jenv->ReleaseStringUTFChars(jarg4, (const char *)arg4);
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_sleepycat_dbxml_dbxml_1javaJNI_XmlManager_1createMemBufInputStream_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2, jlong jarg3, jstring jarg4) {
  jlong jresult = 0 ;
  XmlManager *arg1 = (XmlManager *) 0 ;
  char *arg2 = (char *) 0 ;
  unsigned int arg3 ;
  char *arg4 = (char *) 0 ;
  XmlInputStream *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(XmlManager **)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)jenv->GetStringUTFChars(jarg2, 0);
    if (!arg2) return 0;
  }
  arg3 = (unsigned int)jarg3; 
  arg4 = 0;
  if (jarg4) {
    arg4 = (char *)jenv->GetStringUTFChars(jarg4, 0);
    if (!arg4) return 0;
  }
  
  if (!jarg1) {
    jenv->Throw((jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INVALID_VALUE,
        jenv->NewStringUTF("null object - call after object destroyed?"),
        0, 0, 0, 0));					
    return 0;
  }
  
  {
    jthrowable t = NULL;
    try {
      result = (XmlInputStream *)XmlManager_createMemBufInputStream__SWIG_0((XmlManager const *)arg1,(char const *)arg2,arg3,(char const *)arg4);
    }
    catch (std::exception &se) {
      t = createException(jenv, &se);
      jenv->Throw(t);
      return 0;
    }
    catch(JavaException & /* je */) {
      // This means there's already an exception waiting in the JVM
      return 0;
    }
    catch (...) {
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("Uncaught exception from C++ API"), 0, 0, 0, 0);
      jenv->Throw(t);
      return 0;
    }
  }
  *(XmlInputStream **)&jresult = result; 
  if (arg2) jenv->ReleaseStringUTFChars(jarg2, (const char *)arg2);
  if (arg4) jenv->ReleaseStringUTFChars(jarg4, (const char *)arg4);
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_sleepycat_dbxml_dbxml_1javaJNI_XmlManager_1createMemBufInputStream_1_1SWIG_12(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2, jlong jarg3, jboolean jarg4) {
  jlong jresult = 0 ;
  XmlManager *arg1 = (XmlManager *) 0 ;
  char *arg2 = (char *) 0 ;
  unsigned int arg3 ;
  bool arg4 ;
  XmlInputStream *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(XmlManager **)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)jenv->GetStringUTFChars(jarg2, 0);
    if (!arg2) return 0;
  }
  arg3 = (unsigned int)jarg3; 
  
  arg4 = (jarg4 != JNI_FALSE);
  
  
  if (!jarg1) {
    jenv->Throw((jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INVALID_VALUE,
        jenv->NewStringUTF("null object - call after object destroyed?"),
        0, 0, 0, 0));					
    return 0;
  }
  
  {
    jthrowable t = NULL;
    try {
      result = (XmlInputStream *)XmlManager_createMemBufInputStream__SWIG_2((XmlManager const *)arg1,(char const *)arg2,arg3,arg4);
    }
    catch (std::exception &se) {
      t = createException(jenv, &se);
      jenv->Throw(t);
      return 0;
    }
    catch(JavaException & /* je */) {
      // This means there's already an exception waiting in the JVM
      return 0;
    }
    catch (...) {
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("Uncaught exception from C++ API"), 0, 0, 0, 0);
      jenv->Throw(t);
      return 0;
    }
  }
  *(XmlInputStream **)&jresult = result; 
  if (arg2) jenv->ReleaseStringUTFChars(jarg2, (const char *)arg2);
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_sleepycat_dbxml_dbxml_1javaJNI_XmlManager_1createURLInputStream_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2, jstring jarg3, jstring jarg4) {
  jlong jresult = 0 ;
  XmlManager *arg1 = (XmlManager *) 0 ;
  std::string *arg2 = 0 ;
  std::string *arg3 = 0 ;
  std::string *arg4 = 0 ;
  XmlInputStream *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(XmlManager **)&jarg1; 
  
  const char *arg2_pstr = "";
  if(jarg2) {
    arg2_pstr = (const char *)jenv->GetStringUTFChars(jarg2, 0);
  }
  if (!arg2_pstr) return 0;
  std::string arg2_str(arg2_pstr);
  arg2 = &arg2_str;
  if (jarg2) {
    jenv->ReleaseStringUTFChars(jarg2, arg2_pstr);
  }
  
  
  const char *arg3_pstr = "";
  if(jarg3) {
    arg3_pstr = (const char *)jenv->GetStringUTFChars(jarg3, 0);
  }
  if (!arg3_pstr) return 0;
  std::string arg3_str(arg3_pstr);
  arg3 = &arg3_str;
  if (jarg3) {
    jenv->ReleaseStringUTFChars(jarg3, arg3_pstr);
  }
  
  
  const char *arg4_pstr = "";
  if(jarg4) {
    arg4_pstr = (const char *)jenv->GetStringUTFChars(jarg4, 0);
  }
  if (!arg4_pstr) return 0;
  std::string arg4_str(arg4_pstr);
  arg4 = &arg4_str;
  if (jarg4) {
    jenv->ReleaseStringUTFChars(jarg4, arg4_pstr);
  }
  
  
  if (!jarg1) {
    jenv->Throw((jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INVALID_VALUE,
        jenv->NewStringUTF("null object - call after object destroyed?"),
        0, 0, 0, 0));					
    return 0;
  }
  
  {
    jthrowable t = NULL;
    try {
      result = (XmlInputStream *)XmlManager_createURLInputStream__SWIG_0((XmlManager const *)arg1,(std::string const &)*arg2,(std::string const &)*arg3,(std::string const &)*arg4);
    }
    catch (std::exception &se) {
      t = createException(jenv, &se);
      jenv->Throw(t);
      return 0;
    }
    catch(JavaException & /* je */) {
      // This means there's already an exception waiting in the JVM
      return 0;
    }
    catch (...) {
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("Uncaught exception from C++ API"), 0, 0, 0, 0);
      jenv->Throw(t);
      return 0;
    }
  }
  *(XmlInputStream **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_sleepycat_dbxml_dbxml_1javaJNI_XmlManager_1createURLInputStream_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2, jstring jarg3) {
  jlong jresult = 0 ;
  XmlManager *arg1 = (XmlManager *) 0 ;
  std::string *arg2 = 0 ;
  std::string *arg3 = 0 ;
  XmlInputStream *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(XmlManager **)&jarg1; 
  
  const char *arg2_pstr = "";
  if(jarg2) {
    arg2_pstr = (const char *)jenv->GetStringUTFChars(jarg2, 0);
  }
  if (!arg2_pstr) return 0;
  std::string arg2_str(arg2_pstr);
  arg2 = &arg2_str;
  if (jarg2) {
    jenv->ReleaseStringUTFChars(jarg2, arg2_pstr);
  }
  
  
  const char *arg3_pstr = "";
  if(jarg3) {
    arg3_pstr = (const char *)jenv->GetStringUTFChars(jarg3, 0);
  }
  if (!arg3_pstr) return 0;
  std::string arg3_str(arg3_pstr);
  arg3 = &arg3_str;
  if (jarg3) {
    jenv->ReleaseStringUTFChars(jarg3, arg3_pstr);
  }
  
  
  if (!jarg1) {
    jenv->Throw((jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INVALID_VALUE,
        jenv->NewStringUTF("null object - call after object destroyed?"),
        0, 0, 0, 0));					
    return 0;
  }
  
  {
    jthrowable t = NULL;
    try {
      result = (XmlInputStream *)XmlManager_createURLInputStream__SWIG_1((XmlManager const *)arg1,(std::string const &)*arg2,(std::string const &)*arg3);
    }
    catch (std::exception &se) {
      t = createException(jenv, &se);
      jenv->Throw(t);
      return 0;
    }
    catch(JavaException & /* je */) {
      // This means there's already an exception waiting in the JVM
      return 0;
    }
    catch (...) {
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("Uncaught exception from C++ API"), 0, 0, 0, 0);
      jenv->Throw(t);
      return 0;
    }
  }
  *(XmlInputStream **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_sleepycat_dbxml_dbxml_1javaJNI_XmlManager_1dumpContainer(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2, jstring jarg3) {
  XmlManager *arg1 = (XmlManager *) 0 ;
  std::string *arg2 = 0 ;
  char *arg3 = (char *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(XmlManager **)&jarg1; 
  
  const char *arg2_pstr = "";
  if(jarg2) {
    arg2_pstr = (const char *)jenv->GetStringUTFChars(jarg2, 0);
  }
  if (!arg2_pstr) return ;
  std::string arg2_str(arg2_pstr);
  arg2 = &arg2_str;
  if (jarg2) {
    jenv->ReleaseStringUTFChars(jarg2, arg2_pstr);
  }
  
  arg3 = 0;
  if (jarg3) {
    arg3 = (char *)jenv->GetStringUTFChars(jarg3, 0);
    if (!arg3) return ;
  }
  
  if (!jarg1) {
    jenv->Throw((jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INVALID_VALUE,
        jenv->NewStringUTF("null object - call after object destroyed?"),
        0, 0, 0, 0));					
    return ;
  }
  
  {
    jthrowable t = NULL;
    try {
      XmlManager_dumpContainer(arg1,(std::string const &)*arg2,(char const *)arg3);
    }
    catch (std::exception &se) {
      t = createException(jenv, &se);
      jenv->Throw(t);
      return ;
    }
    catch(JavaException & /* je */) {
      // This means there's already an exception waiting in the JVM
      return ;
    }
    catch (...) {
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("Uncaught exception from C++ API"), 0, 0, 0, 0);
      jenv->Throw(t);
      return ;
    }
  }
  if (arg3) jenv->ReleaseStringUTFChars(jarg3, (const char *)arg3);
}


SWIGEXPORT void JNICALL Java_com_sleepycat_dbxml_dbxml_1javaJNI_XmlManager_1verifyContainer_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2, jstring jarg3, jint jarg4) {
  XmlManager *arg1 = (XmlManager *) 0 ;
  std::string *arg2 = 0 ;
  char *arg3 = (char *) 0 ;
  u_int32_t arg4 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(XmlManager **)&jarg1; 
  
  const char *arg2_pstr = "";
  if(jarg2) {
    arg2_pstr = (const char *)jenv->GetStringUTFChars(jarg2, 0);
  }
  if (!arg2_pstr) return ;
  std::string arg2_str(arg2_pstr);
  arg2 = &arg2_str;
  if (jarg2) {
    jenv->ReleaseStringUTFChars(jarg2, arg2_pstr);
  }
  
  arg3 = 0;
  if (jarg3) {
    arg3 = (char *)jenv->GetStringUTFChars(jarg3, 0);
    if (!arg3) return ;
  }
  arg4 = (u_int32_t)jarg4; 
  
  if (!jarg1) {
    jenv->Throw((jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INVALID_VALUE,
        jenv->NewStringUTF("null object - call after object destroyed?"),
        0, 0, 0, 0));					
    return ;
  }
  
  {
    jthrowable t = NULL;
    try {
      XmlManager_verifyContainer__SWIG_0(arg1,(std::string const &)*arg2,(char const *)arg3,arg4);
    }
    catch (std::exception &se) {
      t = createException(jenv, &se);
      jenv->Throw(t);
      return ;
    }
    catch(JavaException & /* je */) {
      // This means there's already an exception waiting in the JVM
      return ;
    }
    catch (...) {
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("Uncaught exception from C++ API"), 0, 0, 0, 0);
      jenv->Throw(t);
      return ;
    }
  }
  if (arg3) jenv->ReleaseStringUTFChars(jarg3, (const char *)arg3);
}


SWIGEXPORT void JNICALL Java_com_sleepycat_dbxml_dbxml_1javaJNI_XmlManager_1verifyContainer_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2, jstring jarg3) {
  XmlManager *arg1 = (XmlManager *) 0 ;
  std::string *arg2 = 0 ;
  char *arg3 = (char *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(XmlManager **)&jarg1; 
  
  const char *arg2_pstr = "";
  if(jarg2) {
    arg2_pstr = (const char *)jenv->GetStringUTFChars(jarg2, 0);
  }
  if (!arg2_pstr) return ;
  std::string arg2_str(arg2_pstr);
  arg2 = &arg2_str;
  if (jarg2) {
    jenv->ReleaseStringUTFChars(jarg2, arg2_pstr);
  }
  
  arg3 = 0;
  if (jarg3) {
    arg3 = (char *)jenv->GetStringUTFChars(jarg3, 0);
    if (!arg3) return ;
  }
  
  if (!jarg1) {
    jenv->Throw((jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INVALID_VALUE,
        jenv->NewStringUTF("null object - call after object destroyed?"),
        0, 0, 0, 0));					
    return ;
  }
  
  {
    jthrowable t = NULL;
    try {
      XmlManager_verifyContainer__SWIG_0(arg1,(std::string const &)*arg2,(char const *)arg3);
    }
    catch (std::exception &se) {
      t = createException(jenv, &se);
      jenv->Throw(t);
      return ;
    }
    catch(JavaException & /* je */) {
      // This means there's already an exception waiting in the JVM
      return ;
    }
    catch (...) {
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("Uncaught exception from C++ API"), 0, 0, 0, 0);
      jenv->Throw(t);
      return ;
    }
  }
  if (arg3) jenv->ReleaseStringUTFChars(jarg3, (const char *)arg3);
}


SWIGEXPORT jlong JNICALL Java_com_sleepycat_dbxml_dbxml_1javaJNI_XmlManager_1prepare_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2, jlong mgrPtr3, jlong dbgPtr3, jint eval3, jint querySec3, jobjectArray data3, jobject jarg3) {
  jlong jresult = 0 ;
  XmlManager *arg1 = (XmlManager *) 0 ;
  std::string *arg2 = 0 ;
  XmlQueryContext *arg3 = 0 ;
  XmlQueryExpression *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(XmlManager **)&jarg1; 
  
  const char *arg2_pstr = "";
  if(jarg2) {
    arg2_pstr = (const char *)jenv->GetStringUTFChars(jarg2, 0);
  }
  if (!arg2_pstr) return 0;
  std::string arg2_str(arg2_pstr);
  arg2 = &arg2_str;
  if (jarg2) {
    jenv->ReleaseStringUTFChars(jarg2, arg2_pstr);
  }
  
  
  queryContextRef qcRef(jenv, mgrPtr3, dbgPtr3, eval3, querySec3, data3, jarg3);
  if (qcRef.getQC()->isNull())
  return 0; // exception was thrown
  arg3 = qcRef.getQC();
  
  
  if (!jarg1) {
    jenv->Throw((jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INVALID_VALUE,
        jenv->NewStringUTF("null object - call after object destroyed?"),
        0, 0, 0, 0));					
    return 0;
  }
  
  {
    jthrowable t = NULL;
    try {
      result = (XmlQueryExpression *)XmlManager_prepare__SWIG_0(arg1,(std::string const &)*arg2,*arg3);
    }
    catch (std::exception &se) {
      t = createException(jenv, &se);
      jenv->Throw(t);
      return 0;
    }
    catch(JavaException & /* je */) {
      // This means there's already an exception waiting in the JVM
      return 0;
    }
    catch (...) {
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("Uncaught exception from C++ API"), 0, 0, 0, 0);
      jenv->Throw(t);
      return 0;
    }
  }
  *(XmlQueryExpression **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_sleepycat_dbxml_dbxml_1javaJNI_XmlManager_1prepare_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_, jstring jarg3, jlong mgrPtr4, jlong dbgPtr4, jint eval4, jint querySec4, jobjectArray data4, jobject jarg4) {
  jlong jresult = 0 ;
  XmlManager *arg1 = (XmlManager *) 0 ;
  XmlTransaction *arg2 = 0 ;
  std::string *arg3 = 0 ;
  XmlQueryContext *arg4 = 0 ;
  XmlQueryExpression *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(XmlManager **)&jarg1; 
  arg2 = *(XmlTransaction **)&jarg2;
  if(!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "XmlTransaction & reference is null");
    return 0;
  } 
  
  const char *arg3_pstr = "";
  if(jarg3) {
    arg3_pstr = (const char *)jenv->GetStringUTFChars(jarg3, 0);
  }
  if (!arg3_pstr) return 0;
  std::string arg3_str(arg3_pstr);
  arg3 = &arg3_str;
  if (jarg3) {
    jenv->ReleaseStringUTFChars(jarg3, arg3_pstr);
  }
  
  
  queryContextRef qcRef(jenv, mgrPtr4, dbgPtr4, eval4, querySec4, data4, jarg4);
  if (qcRef.getQC()->isNull())
  return 0; // exception was thrown
  arg4 = qcRef.getQC();
  
  
  if (!jarg1) {
    jenv->Throw((jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INVALID_VALUE,
        jenv->NewStringUTF("null object - call after object destroyed?"),
        0, 0, 0, 0));					
    return 0;
  }
  
  {
    jthrowable t = NULL;
    try {
      result = (XmlQueryExpression *)XmlManager_prepare__SWIG_1(arg1,*arg2,(std::string const &)*arg3,*arg4);
    }
    catch (std::exception &se) {
      t = createException(jenv, &se);
      jenv->Throw(t);
      return 0;
    }
    catch(JavaException & /* je */) {
      // This means there's already an exception waiting in the JVM
      return 0;
    }
    catch (...) {
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("Uncaught exception from C++ API"), 0, 0, 0, 0);
      jenv->Throw(t);
      return 0;
    }
  }
  *(XmlQueryExpression **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_sleepycat_dbxml_dbxml_1javaJNI_XmlManager_1query_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2, jlong mgrPtr3, jlong dbgPtr3, jint eval3, jint querySec3, jobjectArray data3, jobject jarg3, jint jarg4) {
  jlong jresult = 0 ;
  XmlManager *arg1 = (XmlManager *) 0 ;
  std::string *arg2 = 0 ;
  XmlQueryContext *arg3 = 0 ;
  u_int32_t arg4 ;
  XmlResults *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(XmlManager **)&jarg1; 
  
  const char *arg2_pstr = "";
  if(jarg2) {
    arg2_pstr = (const char *)jenv->GetStringUTFChars(jarg2, 0);
  }
  if (!arg2_pstr) return 0;
  std::string arg2_str(arg2_pstr);
  arg2 = &arg2_str;
  if (jarg2) {
    jenv->ReleaseStringUTFChars(jarg2, arg2_pstr);
  }
  
  
  queryContextRef qcRef(jenv, mgrPtr3, dbgPtr3, eval3, querySec3, data3, jarg3);
  if (qcRef.getQC()->isNull())
  return 0; // exception was thrown
  arg3 = qcRef.getQC();
  
  arg4 = (u_int32_t)jarg4; 
  
  if (!jarg1) {
    jenv->Throw((jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INVALID_VALUE,
        jenv->NewStringUTF("null object - call after object destroyed?"),
        0, 0, 0, 0));					
    return 0;
  }
  
  {
    jthrowable t = NULL;
    try {
      result = (XmlResults *)XmlManager_query__SWIG_0(arg1,(std::string const &)*arg2,*arg3,arg4);
    }
    catch (std::exception &se) {
      t = createException(jenv, &se);
      jenv->Throw(t);
      return 0;
    }
    catch(JavaException & /* je */) {
      // This means there's already an exception waiting in the JVM
      return 0;
    }
    catch (...) {
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("Uncaught exception from C++ API"), 0, 0, 0, 0);
      jenv->Throw(t);
      return 0;
    }
  }
  *(XmlResults **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_sleepycat_dbxml_dbxml_1javaJNI_XmlManager_1query_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_, jstring jarg3, jlong mgrPtr4, jlong dbgPtr4, jint eval4, jint querySec4, jobjectArray data4, jobject jarg4, jint jarg5) {
  jlong jresult = 0 ;
  XmlManager *arg1 = (XmlManager *) 0 ;
  XmlTransaction *arg2 = 0 ;
  std::string *arg3 = 0 ;
  XmlQueryContext *arg4 = 0 ;
  u_int32_t arg5 ;
  XmlResults *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(XmlManager **)&jarg1; 
  arg2 = *(XmlTransaction **)&jarg2;
  if(!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "XmlTransaction & reference is null");
    return 0;
  } 
  
  const char *arg3_pstr = "";
  if(jarg3) {
    arg3_pstr = (const char *)jenv->GetStringUTFChars(jarg3, 0);
  }
  if (!arg3_pstr) return 0;
  std::string arg3_str(arg3_pstr);
  arg3 = &arg3_str;
  if (jarg3) {
    jenv->ReleaseStringUTFChars(jarg3, arg3_pstr);
  }
  
  
  queryContextRef qcRef(jenv, mgrPtr4, dbgPtr4, eval4, querySec4, data4, jarg4);
  if (qcRef.getQC()->isNull())
  return 0; // exception was thrown
  arg4 = qcRef.getQC();
  
  arg5 = (u_int32_t)jarg5; 
  
  if (!jarg1) {
    jenv->Throw((jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INVALID_VALUE,
        jenv->NewStringUTF("null object - call after object destroyed?"),
        0, 0, 0, 0));					
    return 0;
  }
  
  {
    jthrowable t = NULL;
    try {
      result = (XmlResults *)XmlManager_query__SWIG_1(arg1,*arg2,(std::string const &)*arg3,*arg4,arg5);
    }
    catch (std::exception &se) {
      t = createException(jenv, &se);
      jenv->Throw(t);
      return 0;
    }
    catch(JavaException & /* je */) {
      // This means there's already an exception waiting in the JVM
      return 0;
    }
    catch (...) {
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("Uncaught exception from C++ API"), 0, 0, 0, 0);
      jenv->Throw(t);
      return 0;
    }
  }
  *(XmlResults **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_sleepycat_dbxml_dbxml_1javaJNI_XmlManager_1query_1_1SWIG_12(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2, jlong mgrPtr3, jlong dbgPtr3, jint eval3, jint querySec3, jobjectArray data3, jobject jarg3) {
  jlong jresult = 0 ;
  XmlManager *arg1 = (XmlManager *) 0 ;
  std::string *arg2 = 0 ;
  XmlQueryContext *arg3 = 0 ;
  XmlResults *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(XmlManager **)&jarg1; 
  
  const char *arg2_pstr = "";
  if(jarg2) {
    arg2_pstr = (const char *)jenv->GetStringUTFChars(jarg2, 0);
  }
  if (!arg2_pstr) return 0;
  std::string arg2_str(arg2_pstr);
  arg2 = &arg2_str;
  if (jarg2) {
    jenv->ReleaseStringUTFChars(jarg2, arg2_pstr);
  }
  
  
  queryContextRef qcRef(jenv, mgrPtr3, dbgPtr3, eval3, querySec3, data3, jarg3);
  if (qcRef.getQC()->isNull())
  return 0; // exception was thrown
  arg3 = qcRef.getQC();
  
  
  if (!jarg1) {
    jenv->Throw((jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INVALID_VALUE,
        jenv->NewStringUTF("null object - call after object destroyed?"),
        0, 0, 0, 0));					
    return 0;
  }
  
  {
    jthrowable t = NULL;
    try {
      result = (XmlResults *)XmlManager_query__SWIG_2(arg1,(std::string const &)*arg2,*arg3);
    }
    catch (std::exception &se) {
      t = createException(jenv, &se);
      jenv->Throw(t);
      return 0;
    }
    catch(JavaException & /* je */) {
      // This means there's already an exception waiting in the JVM
      return 0;
    }
    catch (...) {
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("Uncaught exception from C++ API"), 0, 0, 0, 0);
      jenv->Throw(t);
      return 0;
    }
  }
  *(XmlResults **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_sleepycat_dbxml_dbxml_1javaJNI_XmlManager_1query_1_1SWIG_13(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_, jstring jarg3, jlong mgrPtr4, jlong dbgPtr4, jint eval4, jint querySec4, jobjectArray data4, jobject jarg4) {
  jlong jresult = 0 ;
  XmlManager *arg1 = (XmlManager *) 0 ;
  XmlTransaction *arg2 = 0 ;
  std::string *arg3 = 0 ;
  XmlQueryContext *arg4 = 0 ;
  XmlResults *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(XmlManager **)&jarg1; 
  arg2 = *(XmlTransaction **)&jarg2;
  if(!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "XmlTransaction & reference is null");
    return 0;
  } 
  
  const char *arg3_pstr = "";
  if(jarg3) {
    arg3_pstr = (const char *)jenv->GetStringUTFChars(jarg3, 0);
  }
  if (!arg3_pstr) return 0;
  std::string arg3_str(arg3_pstr);
  arg3 = &arg3_str;
  if (jarg3) {
    jenv->ReleaseStringUTFChars(jarg3, arg3_pstr);
  }
  
  
  queryContextRef qcRef(jenv, mgrPtr4, dbgPtr4, eval4, querySec4, data4, jarg4);
  if (qcRef.getQC()->isNull())
  return 0; // exception was thrown
  arg4 = qcRef.getQC();
  
  
  if (!jarg1) {
    jenv->Throw((jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INVALID_VALUE,
        jenv->NewStringUTF("null object - call after object destroyed?"),
        0, 0, 0, 0));					
    return 0;
  }
  
  {
    jthrowable t = NULL;
    try {
      result = (XmlResults *)XmlManager_query__SWIG_3(arg1,*arg2,(std::string const &)*arg3,*arg4);
    }
    catch (std::exception &se) {
      t = createException(jenv, &se);
      jenv->Throw(t);
      return 0;
    }
    catch(JavaException & /* je */) {
      // This means there's already an exception waiting in the JVM
      return 0;
    }
    catch (...) {
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("Uncaught exception from C++ API"), 0, 0, 0, 0);
      jenv->Throw(t);
      return 0;
    }
  }
  *(XmlResults **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_sleepycat_dbxml_dbxml_1javaJNI_XmlManager_1createResults(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  XmlManager *arg1 = (XmlManager *) 0 ;
  XmlResults *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(XmlManager **)&jarg1; 
  
  if (!jarg1) {
    jenv->Throw((jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INVALID_VALUE,
        jenv->NewStringUTF("null object - call after object destroyed?"),
        0, 0, 0, 0));					
    return 0;
  }
  
  {
    jthrowable t = NULL;
    try {
      result = (XmlResults *)XmlManager_createResults(arg1);
    }
    catch (std::exception &se) {
      t = createException(jenv, &se);
      jenv->Throw(t);
      return 0;
    }
    catch(JavaException & /* je */) {
      // This means there's already an exception waiting in the JVM
      return 0;
    }
    catch (...) {
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("Uncaught exception from C++ API"), 0, 0, 0, 0);
      jenv->Throw(t);
      return 0;
    }
  }
  *(XmlResults **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_sleepycat_dbxml_dbxml_1javaJNI_XmlManager_1createTransaction(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jobject jarg2) {
  jlong jresult = 0 ;
  XmlManager *arg1 = (XmlManager *) 0 ;
  DB_TXN *arg2 = (DB_TXN *) 0 ;
  XmlTransaction *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(XmlManager **)&jarg1; 
  {
    arg2 = get_DB_TXN(jenv, jarg2);
  }
  
  if (!jarg1) {
    jenv->Throw((jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INVALID_VALUE,
        jenv->NewStringUTF("null object - call after object destroyed?"),
        0, 0, 0, 0));					
    return 0;
  }
  
  {
    jthrowable t = NULL;
    try {
      result = (XmlTransaction *)XmlManager_createTransaction(arg1,arg2);
    }
    catch (std::exception &se) {
      t = createException(jenv, &se);
      jenv->Throw(t);
      return 0;
    }
    catch(JavaException & /* je */) {
      // This means there's already an exception waiting in the JVM
      return 0;
    }
    catch (...) {
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("Uncaught exception from C++ API"), 0, 0, 0, 0);
      jenv->Throw(t);
      return 0;
    }
  }
  *(XmlTransaction **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_sleepycat_dbxml_dbxml_1javaJNI_XmlManager_1createIndexLookupInternal_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_, jstring jarg3, jstring jarg4, jstring jarg5, jobject jarg6, jint jarg7) {
  jlong jresult = 0 ;
  XmlManager *arg1 = (XmlManager *) 0 ;
  XmlContainer *arg2 = 0 ;
  std::string *arg3 = 0 ;
  std::string *arg4 = 0 ;
  std::string *arg5 = 0 ;
  XmlValue *arg6 = 0 ;
  enum XmlIndexLookup::Operation arg7 ;
  XmlIndexLookup *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(XmlManager **)&jarg1; 
  arg2 = *(XmlContainer **)&jarg2;
  if(!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "XmlContainer & reference is null");
    return 0;
  } 
  
  const char *arg3_pstr = "";
  if(jarg3) {
    arg3_pstr = (const char *)jenv->GetStringUTFChars(jarg3, 0);
  }
  if (!arg3_pstr) return 0;
  std::string arg3_str(arg3_pstr);
  arg3 = &arg3_str;
  if (jarg3) {
    jenv->ReleaseStringUTFChars(jarg3, arg3_pstr);
  }
  
  
  const char *arg4_pstr = "";
  if(jarg4) {
    arg4_pstr = (const char *)jenv->GetStringUTFChars(jarg4, 0);
  }
  if (!arg4_pstr) return 0;
  std::string arg4_str(arg4_pstr);
  arg4 = &arg4_str;
  if (jarg4) {
    jenv->ReleaseStringUTFChars(jarg4, arg4_pstr);
  }
  
  
  const char *arg5_pstr = "";
  if(jarg5) {
    arg5_pstr = (const char *)jenv->GetStringUTFChars(jarg5, 0);
  }
  if (!arg5_pstr) return 0;
  std::string arg5_str(arg5_pstr);
  arg5 = &arg5_str;
  if (jarg5) {
    jenv->ReleaseStringUTFChars(jarg5, arg5_pstr);
  }
  
  
  bool valid = true;
  XmlValue val6 = createCPPXmlValue(jenv, jarg6, &valid);
  if (!valid) return 0;
  arg6 = &val6;
  
  arg7 = (enum XmlIndexLookup::Operation)jarg7; 
  
  if (!jarg1) {
    jenv->Throw((jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INVALID_VALUE,
        jenv->NewStringUTF("null object - call after object destroyed?"),
        0, 0, 0, 0));					
    return 0;
  }
  
  {
    jthrowable t = NULL;
    try {
      result = (XmlIndexLookup *)XmlManager_createIndexLookupInternal__SWIG_0(arg1,*arg2,(std::string const &)*arg3,(std::string const &)*arg4,(std::string const &)*arg5,(XmlValue const &)*arg6,arg7);
    }
    catch (std::exception &se) {
      t = createException(jenv, &se);
      jenv->Throw(t);
      return 0;
    }
    catch(JavaException & /* je */) {
      // This means there's already an exception waiting in the JVM
      return 0;
    }
    catch (...) {
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("Uncaught exception from C++ API"), 0, 0, 0, 0);
      jenv->Throw(t);
      return 0;
    }
  }
  *(XmlIndexLookup **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_sleepycat_dbxml_dbxml_1javaJNI_XmlManager_1createIndexLookupInternal_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_, jstring jarg3, jstring jarg4, jstring jarg5, jobject jarg6) {
  jlong jresult = 0 ;
  XmlManager *arg1 = (XmlManager *) 0 ;
  XmlContainer *arg2 = 0 ;
  std::string *arg3 = 0 ;
  std::string *arg4 = 0 ;
  std::string *arg5 = 0 ;
  XmlValue *arg6 = 0 ;
  XmlIndexLookup *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(XmlManager **)&jarg1; 
  arg2 = *(XmlContainer **)&jarg2;
  if(!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "XmlContainer & reference is null");
    return 0;
  } 
  
  const char *arg3_pstr = "";
  if(jarg3) {
    arg3_pstr = (const char *)jenv->GetStringUTFChars(jarg3, 0);
  }
  if (!arg3_pstr) return 0;
  std::string arg3_str(arg3_pstr);
  arg3 = &arg3_str;
  if (jarg3) {
    jenv->ReleaseStringUTFChars(jarg3, arg3_pstr);
  }
  
  
  const char *arg4_pstr = "";
  if(jarg4) {
    arg4_pstr = (const char *)jenv->GetStringUTFChars(jarg4, 0);
  }
  if (!arg4_pstr) return 0;
  std::string arg4_str(arg4_pstr);
  arg4 = &arg4_str;
  if (jarg4) {
    jenv->ReleaseStringUTFChars(jarg4, arg4_pstr);
  }
  
  
  const char *arg5_pstr = "";
  if(jarg5) {
    arg5_pstr = (const char *)jenv->GetStringUTFChars(jarg5, 0);
  }
  if (!arg5_pstr) return 0;
  std::string arg5_str(arg5_pstr);
  arg5 = &arg5_str;
  if (jarg5) {
    jenv->ReleaseStringUTFChars(jarg5, arg5_pstr);
  }
  
  
  bool valid = true;
  XmlValue val6 = createCPPXmlValue(jenv, jarg6, &valid);
  if (!valid) return 0;
  arg6 = &val6;
  
  
  if (!jarg1) {
    jenv->Throw((jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INVALID_VALUE,
        jenv->NewStringUTF("null object - call after object destroyed?"),
        0, 0, 0, 0));					
    return 0;
  }
  
  {
    jthrowable t = NULL;
    try {
      result = (XmlIndexLookup *)XmlManager_createIndexLookupInternal__SWIG_0(arg1,*arg2,(std::string const &)*arg3,(std::string const &)*arg4,(std::string const &)*arg5,(XmlValue const &)*arg6);
    }
    catch (std::exception &se) {
      t = createException(jenv, &se);
      jenv->Throw(t);
      return 0;
    }
    catch(JavaException & /* je */) {
      // This means there's already an exception waiting in the JVM
      return 0;
    }
    catch (...) {
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("Uncaught exception from C++ API"), 0, 0, 0, 0);
      jenv->Throw(t);
      return 0;
    }
  }
  *(XmlIndexLookup **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_sleepycat_dbxml_dbxml_1javaJNI_XmlManager_1createIndexLookupInternal_1_1SWIG_12(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_, jstring jarg3, jstring jarg4, jstring jarg5) {
  jlong jresult = 0 ;
  XmlManager *arg1 = (XmlManager *) 0 ;
  XmlContainer *arg2 = 0 ;
  std::string *arg3 = 0 ;
  std::string *arg4 = 0 ;
  std::string *arg5 = 0 ;
  XmlIndexLookup *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(XmlManager **)&jarg1; 
  arg2 = *(XmlContainer **)&jarg2;
  if(!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "XmlContainer & reference is null");
    return 0;
  } 
  
  const char *arg3_pstr = "";
  if(jarg3) {
    arg3_pstr = (const char *)jenv->GetStringUTFChars(jarg3, 0);
  }
  if (!arg3_pstr) return 0;
  std::string arg3_str(arg3_pstr);
  arg3 = &arg3_str;
  if (jarg3) {
    jenv->ReleaseStringUTFChars(jarg3, arg3_pstr);
  }
  
  
  const char *arg4_pstr = "";
  if(jarg4) {
    arg4_pstr = (const char *)jenv->GetStringUTFChars(jarg4, 0);
  }
  if (!arg4_pstr) return 0;
  std::string arg4_str(arg4_pstr);
  arg4 = &arg4_str;
  if (jarg4) {
    jenv->ReleaseStringUTFChars(jarg4, arg4_pstr);
  }
  
  
  const char *arg5_pstr = "";
  if(jarg5) {
    arg5_pstr = (const char *)jenv->GetStringUTFChars(jarg5, 0);
  }
  if (!arg5_pstr) return 0;
  std::string arg5_str(arg5_pstr);
  arg5 = &arg5_str;
  if (jarg5) {
    jenv->ReleaseStringUTFChars(jarg5, arg5_pstr);
  }
  
  
  if (!jarg1) {
    jenv->Throw((jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INVALID_VALUE,
        jenv->NewStringUTF("null object - call after object destroyed?"),
        0, 0, 0, 0));					
    return 0;
  }
  
  {
    jthrowable t = NULL;
    try {
      result = (XmlIndexLookup *)XmlManager_createIndexLookupInternal__SWIG_0(arg1,*arg2,(std::string const &)*arg3,(std::string const &)*arg4,(std::string const &)*arg5);
    }
    catch (std::exception &se) {
      t = createException(jenv, &se);
      jenv->Throw(t);
      return 0;
    }
    catch(JavaException & /* je */) {
      // This means there's already an exception waiting in the JVM
      return 0;
    }
    catch (...) {
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("Uncaught exception from C++ API"), 0, 0, 0, 0);
      jenv->Throw(t);
      return 0;
    }
  }
  *(XmlIndexLookup **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_sleepycat_dbxml_dbxml_1javaJNI_XmlManager_1setLogLevel(JNIEnv *jenv, jclass jcls, jint jarg1, jboolean jarg2) {
  enum LogLevel arg1 ;
  bool arg2 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = (enum LogLevel)jarg1; 
  
  arg2 = (jarg2 != JNI_FALSE);
  
  {
    jthrowable t = NULL;
    try {
      XmlManager_setLogLevel(arg1,arg2);
    }
    catch (std::exception &se) {
      t = createException(jenv, &se);
      jenv->Throw(t);
      return ;
    }
    catch(JavaException & /* je */) {
      // This means there's already an exception waiting in the JVM
      return ;
    }
    catch (...) {
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("Uncaught exception from C++ API"), 0, 0, 0, 0);
      jenv->Throw(t);
      return ;
    }
  }
}


SWIGEXPORT void JNICALL Java_com_sleepycat_dbxml_dbxml_1javaJNI_XmlManager_1setLogCategory(JNIEnv *jenv, jclass jcls, jint jarg1, jboolean jarg2) {
  enum LogCategory arg1 ;
  bool arg2 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = (enum LogCategory)jarg1; 
  
  arg2 = (jarg2 != JNI_FALSE);
  
  {
    jthrowable t = NULL;
    try {
      XmlManager_setLogCategory(arg1,arg2);
    }
    catch (std::exception &se) {
      t = createException(jenv, &se);
      jenv->Throw(t);
      return ;
    }
    catch(JavaException & /* je */) {
      // This means there's already an exception waiting in the JVM
      return ;
    }
    catch (...) {
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("Uncaught exception from C++ API"), 0, 0, 0, 0);
      jenv->Throw(t);
      return ;
    }
  }
}


SWIGEXPORT jint JNICALL Java_com_sleepycat_dbxml_dbxml_1javaJNI_XmlManager_1get_1version_1major(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  {
    jthrowable t = NULL;
    try {
      result = (int)XmlManager_get_version_major();
    }
    catch (std::exception &se) {
      t = createException(jenv, &se);
      jenv->Throw(t);
      return 0;
    }
    catch(JavaException & /* je */) {
      // This means there's already an exception waiting in the JVM
      return 0;
    }
    catch (...) {
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("Uncaught exception from C++ API"), 0, 0, 0, 0);
      jenv->Throw(t);
      return 0;
    }
  }
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_com_sleepycat_dbxml_dbxml_1javaJNI_XmlManager_1get_1version_1minor(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  {
    jthrowable t = NULL;
    try {
      result = (int)XmlManager_get_version_minor();
    }
    catch (std::exception &se) {
      t = createException(jenv, &se);
      jenv->Throw(t);
      return 0;
    }
    catch(JavaException & /* je */) {
      // This means there's already an exception waiting in the JVM
      return 0;
    }
    catch (...) {
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("Uncaught exception from C++ API"), 0, 0, 0, 0);
      jenv->Throw(t);
      return 0;
    }
  }
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_com_sleepycat_dbxml_dbxml_1javaJNI_XmlManager_1get_1version_1patch(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  {
    jthrowable t = NULL;
    try {
      result = (int)XmlManager_get_version_patch();
    }
    catch (std::exception &se) {
      t = createException(jenv, &se);
      jenv->Throw(t);
      return 0;
    }
    catch(JavaException & /* je */) {
      // This means there's already an exception waiting in the JVM
      return 0;
    }
    catch (...) {
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("Uncaught exception from C++ API"), 0, 0, 0, 0);
      jenv->Throw(t);
      return 0;
    }
  }
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jstring JNICALL Java_com_sleepycat_dbxml_dbxml_1javaJNI_XmlManager_1get_1version_1string(JNIEnv *jenv, jclass jcls) {
  jstring jresult = 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  {
    jthrowable t = NULL;
    try {
      result = (char *)XmlManager_get_version_string();
    }
    catch (std::exception &se) {
      t = createException(jenv, &se);
      jenv->Throw(t);
      return 0;
    }
    catch(JavaException & /* je */) {
      // This means there's already an exception waiting in the JVM
      return 0;
    }
    catch (...) {
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("Uncaught exception from C++ API"), 0, 0, 0, 0);
      jenv->Throw(t);
      return 0;
    }
  }
  if(result) jresult = jenv->NewStringUTF((const char *)result);
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_sleepycat_dbxml_dbxml_1javaJNI_XmlManager_1createContainerInternal_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2, jintArray data3, jstring jarg3) {
  jlong jresult = 0 ;
  XmlManager *arg1 = (XmlManager *) 0 ;
  std::string *arg2 = 0 ;
  XmlContainerConfig *arg3 = 0 ;
  SwigValueWrapper< XmlContainer > result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(XmlManager **)&jarg1; 
  
  const char *arg2_pstr = "";
  if(jarg2) {
    arg2_pstr = (const char *)jenv->GetStringUTFChars(jarg2, 0);
  }
  if (!arg2_pstr) return 0;
  std::string arg2_str(arg2_pstr);
  arg2 = &arg2_str;
  if (jarg2) {
    jenv->ReleaseStringUTFChars(jarg2, arg2_pstr);
  }
  
  
  XmlContainerConfig config3 = createCPPXmlContainerConfig(jenv, data3, jarg3);	
  arg3 = &config3;
  
  
  if (!jarg1) {
    jenv->Throw((jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INVALID_VALUE,
        jenv->NewStringUTF("null object - call after object destroyed?"),
        0, 0, 0, 0));					
    return 0;
  }
  
  {
    jthrowable t = NULL;
    try {
      result = XmlManager_createContainerInternal__SWIG_0(arg1,(std::string const &)*arg2,*arg3);
    }
    catch (std::exception &se) {
      t = createException(jenv, &se);
      jenv->Throw(t);
      return 0;
    }
    catch(JavaException & /* je */) {
      // This means there's already an exception waiting in the JVM
      return 0;
    }
    catch (...) {
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("Uncaught exception from C++ API"), 0, 0, 0, 0);
      jenv->Throw(t);
      return 0;
    }
  }
  *(XmlContainer **)&jresult = new XmlContainer((const XmlContainer &)result); 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_sleepycat_dbxml_dbxml_1javaJNI_XmlManager_1createContainerInternal_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_, jstring jarg3, jintArray data4, jstring jarg4) {
  jlong jresult = 0 ;
  XmlManager *arg1 = (XmlManager *) 0 ;
  XmlTransaction *arg2 = 0 ;
  std::string *arg3 = 0 ;
  XmlContainerConfig *arg4 = 0 ;
  SwigValueWrapper< XmlContainer > result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(XmlManager **)&jarg1; 
  arg2 = *(XmlTransaction **)&jarg2;
  if(!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "XmlTransaction & reference is null");
    return 0;
  } 
  
  const char *arg3_pstr = "";
  if(jarg3) {
    arg3_pstr = (const char *)jenv->GetStringUTFChars(jarg3, 0);
  }
  if (!arg3_pstr) return 0;
  std::string arg3_str(arg3_pstr);
  arg3 = &arg3_str;
  if (jarg3) {
    jenv->ReleaseStringUTFChars(jarg3, arg3_pstr);
  }
  
  
  XmlContainerConfig config4 = createCPPXmlContainerConfig(jenv, data4, jarg4);	
  arg4 = &config4;
  
  
  if (!jarg1) {
    jenv->Throw((jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INVALID_VALUE,
        jenv->NewStringUTF("null object - call after object destroyed?"),
        0, 0, 0, 0));					
    return 0;
  }
  
  {
    jthrowable t = NULL;
    try {
      result = XmlManager_createContainerInternal__SWIG_1(arg1,*arg2,(std::string const &)*arg3,*arg4);
    }
    catch (std::exception &se) {
      t = createException(jenv, &se);
      jenv->Throw(t);
      return 0;
    }
    catch(JavaException & /* je */) {
      // This means there's already an exception waiting in the JVM
      return 0;
    }
    catch (...) {
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("Uncaught exception from C++ API"), 0, 0, 0, 0);
      jenv->Throw(t);
      return 0;
    }
  }
  *(XmlContainer **)&jresult = new XmlContainer((const XmlContainer &)result); 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_sleepycat_dbxml_dbxml_1javaJNI_XmlManager_1openContainerInternal_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2, jintArray data3, jstring jarg3) {
  jlong jresult = 0 ;
  XmlManager *arg1 = (XmlManager *) 0 ;
  std::string *arg2 = 0 ;
  XmlContainerConfig *arg3 = 0 ;
  SwigValueWrapper< XmlContainer > result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(XmlManager **)&jarg1; 
  
  const char *arg2_pstr = "";
  if(jarg2) {
    arg2_pstr = (const char *)jenv->GetStringUTFChars(jarg2, 0);
  }
  if (!arg2_pstr) return 0;
  std::string arg2_str(arg2_pstr);
  arg2 = &arg2_str;
  if (jarg2) {
    jenv->ReleaseStringUTFChars(jarg2, arg2_pstr);
  }
  
  
  XmlContainerConfig config3 = createCPPXmlContainerConfig(jenv, data3, jarg3);	
  arg3 = &config3;
  
  
  if (!jarg1) {
    jenv->Throw((jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INVALID_VALUE,
        jenv->NewStringUTF("null object - call after object destroyed?"),
        0, 0, 0, 0));					
    return 0;
  }
  
  {
    jthrowable t = NULL;
    try {
      result = XmlManager_openContainerInternal__SWIG_0(arg1,(std::string const &)*arg2,*arg3);
    }
    catch (std::exception &se) {
      t = createException(jenv, &se);
      jenv->Throw(t);
      return 0;
    }
    catch(JavaException & /* je */) {
      // This means there's already an exception waiting in the JVM
      return 0;
    }
    catch (...) {
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("Uncaught exception from C++ API"), 0, 0, 0, 0);
      jenv->Throw(t);
      return 0;
    }
  }
  *(XmlContainer **)&jresult = new XmlContainer((const XmlContainer &)result); 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_sleepycat_dbxml_dbxml_1javaJNI_XmlManager_1openContainerInternal_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_, jstring jarg3, jintArray data4, jstring jarg4) {
  jlong jresult = 0 ;
  XmlManager *arg1 = (XmlManager *) 0 ;
  XmlTransaction *arg2 = 0 ;
  std::string *arg3 = 0 ;
  XmlContainerConfig *arg4 = 0 ;
  SwigValueWrapper< XmlContainer > result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(XmlManager **)&jarg1; 
  arg2 = *(XmlTransaction **)&jarg2;
  if(!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "XmlTransaction & reference is null");
    return 0;
  } 
  
  const char *arg3_pstr = "";
  if(jarg3) {
    arg3_pstr = (const char *)jenv->GetStringUTFChars(jarg3, 0);
  }
  if (!arg3_pstr) return 0;
  std::string arg3_str(arg3_pstr);
  arg3 = &arg3_str;
  if (jarg3) {
    jenv->ReleaseStringUTFChars(jarg3, arg3_pstr);
  }
  
  
  XmlContainerConfig config4 = createCPPXmlContainerConfig(jenv, data4, jarg4);	
  arg4 = &config4;
  
  
  if (!jarg1) {
    jenv->Throw((jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INVALID_VALUE,
        jenv->NewStringUTF("null object - call after object destroyed?"),
        0, 0, 0, 0));					
    return 0;
  }
  
  {
    jthrowable t = NULL;
    try {
      result = XmlManager_openContainerInternal__SWIG_1(arg1,*arg2,(std::string const &)*arg3,*arg4);
    }
    catch (std::exception &se) {
      t = createException(jenv, &se);
      jenv->Throw(t);
      return 0;
    }
    catch(JavaException & /* je */) {
      // This means there's already an exception waiting in the JVM
      return 0;
    }
    catch (...) {
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("Uncaught exception from C++ API"), 0, 0, 0, 0);
      jenv->Throw(t);
      return 0;
    }
  }
  *(XmlContainer **)&jresult = new XmlContainer((const XmlContainer &)result); 
  return jresult;
}


SWIGEXPORT jobject JNICALL Java_com_sleepycat_dbxml_dbxml_1javaJNI_XmlManager_1createDocumentInternal(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jobject jresult = 0 ;
  XmlManager *arg1 = (XmlManager *) 0 ;
  XmlDocument result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(XmlManager **)&jarg1; 
  
  if (!jarg1) {
    jenv->Throw((jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INVALID_VALUE,
        jenv->NewStringUTF("null object - call after object destroyed?"),
        0, 0, 0, 0));					
    return 0;
  }
  
  {
    jthrowable t = NULL;
    try {
      result = XmlManager_createDocumentInternal(arg1);
    }
    catch (std::exception &se) {
      t = createException(jenv, &se);
      jenv->Throw(t);
      return 0;
    }
    catch(JavaException & /* je */) {
      // This means there's already an exception waiting in the JVM
      return 0;
    }
    catch (...) {
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("Uncaught exception from C++ API"), 0, 0, 0, 0);
      jenv->Throw(t);
      return 0;
    }
  }
  {
    jresult = createJavaXmlDocument(jenv, result);
  }
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_sleepycat_dbxml_dbxml_1javaJNI_XmlManager_1upgradeContainer(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2) {
  XmlManager *arg1 = (XmlManager *) 0 ;
  std::string *arg2 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(XmlManager **)&jarg1; 
  
  const char *arg2_pstr = "";
  if(jarg2) {
    arg2_pstr = (const char *)jenv->GetStringUTFChars(jarg2, 0);
  }
  if (!arg2_pstr) return ;
  std::string arg2_str(arg2_pstr);
  arg2 = &arg2_str;
  if (jarg2) {
    jenv->ReleaseStringUTFChars(jarg2, arg2_pstr);
  }
  
  
  if (!jarg1) {
    jenv->Throw((jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INVALID_VALUE,
        jenv->NewStringUTF("null object - call after object destroyed?"),
        0, 0, 0, 0));					
    return ;
  }
  
  {
    jthrowable t = NULL;
    try {
      XmlManager_upgradeContainer(arg1,(std::string const &)*arg2);
    }
    catch (std::exception &se) {
      t = createException(jenv, &se);
      jenv->Throw(t);
      return ;
    }
    catch(JavaException & /* je */) {
      // This means there's already an exception waiting in the JVM
      return ;
    }
    catch (...) {
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("Uncaught exception from C++ API"), 0, 0, 0, 0);
      jenv->Throw(t);
      return ;
    }
  }
}


SWIGEXPORT void JNICALL Java_com_sleepycat_dbxml_dbxml_1javaJNI_XmlManager_1compactContainer_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2) {
  XmlManager *arg1 = (XmlManager *) 0 ;
  std::string *arg2 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(XmlManager **)&jarg1; 
  
  const char *arg2_pstr = "";
  if(jarg2) {
    arg2_pstr = (const char *)jenv->GetStringUTFChars(jarg2, 0);
  }
  if (!arg2_pstr) return ;
  std::string arg2_str(arg2_pstr);
  arg2 = &arg2_str;
  if (jarg2) {
    jenv->ReleaseStringUTFChars(jarg2, arg2_pstr);
  }
  
  
  if (!jarg1) {
    jenv->Throw((jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INVALID_VALUE,
        jenv->NewStringUTF("null object - call after object destroyed?"),
        0, 0, 0, 0));					
    return ;
  }
  
  {
    jthrowable t = NULL;
    try {
      XmlManager_compactContainer__SWIG_0(arg1,(std::string const &)*arg2);
    }
    catch (std::exception &se) {
      t = createException(jenv, &se);
      jenv->Throw(t);
      return ;
    }
    catch(JavaException & /* je */) {
      // This means there's already an exception waiting in the JVM
      return ;
    }
    catch (...) {
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("Uncaught exception from C++ API"), 0, 0, 0, 0);
      jenv->Throw(t);
      return ;
    }
  }
}


SWIGEXPORT void JNICALL Java_com_sleepycat_dbxml_dbxml_1javaJNI_XmlManager_1compactContainer_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_, jstring jarg3) {
  XmlManager *arg1 = (XmlManager *) 0 ;
  XmlTransaction *arg2 = 0 ;
  std::string *arg3 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(XmlManager **)&jarg1; 
  arg2 = *(XmlTransaction **)&jarg2;
  if(!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "XmlTransaction & reference is null");
    return ;
  } 
  
  const char *arg3_pstr = "";
  if(jarg3) {
    arg3_pstr = (const char *)jenv->GetStringUTFChars(jarg3, 0);
  }
  if (!arg3_pstr) return ;
  std::string arg3_str(arg3_pstr);
  arg3 = &arg3_str;
  if (jarg3) {
    jenv->ReleaseStringUTFChars(jarg3, arg3_pstr);
  }
  
  
  if (!jarg1) {
    jenv->Throw((jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INVALID_VALUE,
        jenv->NewStringUTF("null object - call after object destroyed?"),
        0, 0, 0, 0));					
    return ;
  }
  
  {
    jthrowable t = NULL;
    try {
      XmlManager_compactContainer__SWIG_1(arg1,*arg2,(std::string const &)*arg3);
    }
    catch (std::exception &se) {
      t = createException(jenv, &se);
      jenv->Throw(t);
      return ;
    }
    catch(JavaException & /* je */) {
      // This means there's already an exception waiting in the JVM
      return ;
    }
    catch (...) {
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("Uncaught exception from C++ API"), 0, 0, 0, 0);
      jenv->Throw(t);
      return ;
    }
  }
}


SWIGEXPORT void JNICALL Java_com_sleepycat_dbxml_dbxml_1javaJNI_XmlManager_1truncateContainer_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2) {
  XmlManager *arg1 = (XmlManager *) 0 ;
  std::string *arg2 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(XmlManager **)&jarg1; 
  
  const char *arg2_pstr = "";
  if(jarg2) {
    arg2_pstr = (const char *)jenv->GetStringUTFChars(jarg2, 0);
  }
  if (!arg2_pstr) return ;
  std::string arg2_str(arg2_pstr);
  arg2 = &arg2_str;
  if (jarg2) {
    jenv->ReleaseStringUTFChars(jarg2, arg2_pstr);
  }
  
  
  if (!jarg1) {
    jenv->Throw((jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INVALID_VALUE,
        jenv->NewStringUTF("null object - call after object destroyed?"),
        0, 0, 0, 0));					
    return ;
  }
  
  {
    jthrowable t = NULL;
    try {
      XmlManager_truncateContainer__SWIG_0(arg1,(std::string const &)*arg2);
    }
    catch (std::exception &se) {
      t = createException(jenv, &se);
      jenv->Throw(t);
      return ;
    }
    catch(JavaException & /* je */) {
      // This means there's already an exception waiting in the JVM
      return ;
    }
    catch (...) {
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("Uncaught exception from C++ API"), 0, 0, 0, 0);
      jenv->Throw(t);
      return ;
    }
  }
}


SWIGEXPORT void JNICALL Java_com_sleepycat_dbxml_dbxml_1javaJNI_XmlManager_1truncateContainer_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_, jstring jarg3) {
  XmlManager *arg1 = (XmlManager *) 0 ;
  XmlTransaction *arg2 = 0 ;
  std::string *arg3 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(XmlManager **)&jarg1; 
  arg2 = *(XmlTransaction **)&jarg2;
  if(!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "XmlTransaction & reference is null");
    return ;
  } 
  
  const char *arg3_pstr = "";
  if(jarg3) {
    arg3_pstr = (const char *)jenv->GetStringUTFChars(jarg3, 0);
  }
  if (!arg3_pstr) return ;
  std::string arg3_str(arg3_pstr);
  arg3 = &arg3_str;
  if (jarg3) {
    jenv->ReleaseStringUTFChars(jarg3, arg3_pstr);
  }
  
  
  if (!jarg1) {
    jenv->Throw((jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INVALID_VALUE,
        jenv->NewStringUTF("null object - call after object destroyed?"),
        0, 0, 0, 0));					
    return ;
  }
  
  {
    jthrowable t = NULL;
    try {
      XmlManager_truncateContainer__SWIG_1(arg1,*arg2,(std::string const &)*arg3);
    }
    catch (std::exception &se) {
      t = createException(jenv, &se);
      jenv->Throw(t);
      return ;
    }
    catch(JavaException & /* je */) {
      // This means there's already an exception waiting in the JVM
      return ;
    }
    catch (...) {
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("Uncaught exception from C++ API"), 0, 0, 0, 0);
      jenv->Throw(t);
      return ;
    }
  }
}


SWIGEXPORT void JNICALL Java_com_sleepycat_dbxml_dbxml_1javaJNI_XmlManager_1reindexContainer_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2, jintArray data3, jstring jarg3) {
  XmlManager *arg1 = (XmlManager *) 0 ;
  std::string *arg2 = 0 ;
  XmlContainerConfig arg3 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(XmlManager **)&jarg1; 
  
  const char *arg2_pstr = "";
  if(jarg2) {
    arg2_pstr = (const char *)jenv->GetStringUTFChars(jarg2, 0);
  }
  if (!arg2_pstr) return ;
  std::string arg2_str(arg2_pstr);
  arg2 = &arg2_str;
  if (jarg2) {
    jenv->ReleaseStringUTFChars(jarg2, arg2_pstr);
  }
  
  
  arg3 = createCPPXmlContainerConfig(jenv, data3, jarg3);	
  
  
  if (!jarg1) {
    jenv->Throw((jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INVALID_VALUE,
        jenv->NewStringUTF("null object - call after object destroyed?"),
        0, 0, 0, 0));					
    return ;
  }
  
  {
    jthrowable t = NULL;
    try {
      XmlManager_reindexContainer__SWIG_0(arg1,(std::string const &)*arg2,arg3);
    }
    catch (std::exception &se) {
      t = createException(jenv, &se);
      jenv->Throw(t);
      return ;
    }
    catch(JavaException & /* je */) {
      // This means there's already an exception waiting in the JVM
      return ;
    }
    catch (...) {
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("Uncaught exception from C++ API"), 0, 0, 0, 0);
      jenv->Throw(t);
      return ;
    }
  }
}


SWIGEXPORT void JNICALL Java_com_sleepycat_dbxml_dbxml_1javaJNI_XmlManager_1reindexContainer_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_, jstring jarg3, jintArray data4, jstring jarg4) {
  XmlManager *arg1 = (XmlManager *) 0 ;
  XmlTransaction *arg2 = 0 ;
  std::string *arg3 = 0 ;
  XmlContainerConfig arg4 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(XmlManager **)&jarg1; 
  arg2 = *(XmlTransaction **)&jarg2;
  if(!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "XmlTransaction & reference is null");
    return ;
  } 
  
  const char *arg3_pstr = "";
  if(jarg3) {
    arg3_pstr = (const char *)jenv->GetStringUTFChars(jarg3, 0);
  }
  if (!arg3_pstr) return ;
  std::string arg3_str(arg3_pstr);
  arg3 = &arg3_str;
  if (jarg3) {
    jenv->ReleaseStringUTFChars(jarg3, arg3_pstr);
  }
  
  
  arg4 = createCPPXmlContainerConfig(jenv, data4, jarg4);	
  
  
  if (!jarg1) {
    jenv->Throw((jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INVALID_VALUE,
        jenv->NewStringUTF("null object - call after object destroyed?"),
        0, 0, 0, 0));					
    return ;
  }
  
  {
    jthrowable t = NULL;
    try {
      XmlManager_reindexContainer__SWIG_1(arg1,*arg2,(std::string const &)*arg3,arg4);
    }
    catch (std::exception &se) {
      t = createException(jenv, &se);
      jenv->Throw(t);
      return ;
    }
    catch(JavaException & /* je */) {
      // This means there's already an exception waiting in the JVM
      return ;
    }
    catch (...) {
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("Uncaught exception from C++ API"), 0, 0, 0, 0);
      jenv->Throw(t);
      return ;
    }
  }
}


SWIGEXPORT void JNICALL Java_com_sleepycat_dbxml_dbxml_1javaJNI_XmlManager_1loadContainer(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2, jstring jarg3) {
  XmlManager *arg1 = (XmlManager *) 0 ;
  std::string *arg2 = 0 ;
  char *arg3 = (char *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(XmlManager **)&jarg1; 
  
  const char *arg2_pstr = "";
  if(jarg2) {
    arg2_pstr = (const char *)jenv->GetStringUTFChars(jarg2, 0);
  }
  if (!arg2_pstr) return ;
  std::string arg2_str(arg2_pstr);
  arg2 = &arg2_str;
  if (jarg2) {
    jenv->ReleaseStringUTFChars(jarg2, arg2_pstr);
  }
  
  arg3 = 0;
  if (jarg3) {
    arg3 = (char *)jenv->GetStringUTFChars(jarg3, 0);
    if (!arg3) return ;
  }
  
  if (!jarg1) {
    jenv->Throw((jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INVALID_VALUE,
        jenv->NewStringUTF("null object - call after object destroyed?"),
        0, 0, 0, 0));					
    return ;
  }
  
  {
    jthrowable t = NULL;
    try {
      XmlManager_loadContainer(arg1,(std::string const &)*arg2,(char const *)arg3);
    }
    catch (std::exception &se) {
      t = createException(jenv, &se);
      jenv->Throw(t);
      return ;
    }
    catch(JavaException & /* je */) {
      // This means there's already an exception waiting in the JVM
      return ;
    }
    catch (...) {
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("Uncaught exception from C++ API"), 0, 0, 0, 0);
      jenv->Throw(t);
      return ;
    }
  }
  if (arg3) jenv->ReleaseStringUTFChars(jarg3, (const char *)arg3);
}


SWIGEXPORT void JNICALL Java_com_sleepycat_dbxml_dbxml_1javaJNI_XmlManager_1registerCompressionInternal(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2, jlong jarg3, jobject jarg3_) {
  XmlManager *arg1 = (XmlManager *) 0 ;
  char *arg2 = (char *) 0 ;
  XmlCompression *arg3 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg3_;
  arg1 = *(XmlManager **)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)jenv->GetStringUTFChars(jarg2, 0);
    if (!arg2) return ;
  }
  arg3 = *(XmlCompression **)&jarg3; 
  
  if (!jarg1) {
    jenv->Throw((jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INVALID_VALUE,
        jenv->NewStringUTF("null object - call after object destroyed?"),
        0, 0, 0, 0));					
    return ;
  }
  
  {
    jthrowable t = NULL;
    try {
      XmlManager_registerCompressionInternal(arg1,(char const *)arg2,*arg3);
    }
    catch (std::exception &se) {
      t = createException(jenv, &se);
      jenv->Throw(t);
      return ;
    }
    catch(JavaException & /* je */) {
      // This means there's already an exception waiting in the JVM
      return ;
    }
    catch (...) {
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("Uncaught exception from C++ API"), 0, 0, 0, 0);
      jenv->Throw(t);
      return ;
    }
  }
  if (arg2) jenv->ReleaseStringUTFChars(jarg2, (const char *)arg2);
}


SWIGEXPORT void JNICALL Java_com_sleepycat_dbxml_dbxml_1javaJNI_XmlManager_1registerResolverInternal(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  XmlManager *arg1 = (XmlManager *) 0 ;
  XmlResolver *arg2 = (XmlResolver *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(XmlManager **)&jarg1; 
  arg2 = *(XmlResolver **)&jarg2; 
  
  if (!jarg1) {
    jenv->Throw((jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INVALID_VALUE,
        jenv->NewStringUTF("null object - call after object destroyed?"),
        0, 0, 0, 0));					
    return ;
  }
  
  {
    jthrowable t = NULL;
    try {
      XmlManager_registerResolverInternal(arg1,arg2);
    }
    catch (std::exception &se) {
      t = createException(jenv, &se);
      jenv->Throw(t);
      return ;
    }
    catch(JavaException & /* je */) {
      // This means there's already an exception waiting in the JVM
      return ;
    }
    catch (...) {
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("Uncaught exception from C++ API"), 0, 0, 0, 0);
      jenv->Throw(t);
      return ;
    }
  }
}


SWIGEXPORT void JNICALL Java_com_sleepycat_dbxml_dbxml_1javaJNI_delete_1XmlIndexLookup(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  XmlIndexLookup *arg1 = (XmlIndexLookup *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(XmlIndexLookup **)&jarg1; 
  
  if (!jarg1) {
    jenv->Throw((jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INVALID_VALUE,
        jenv->NewStringUTF("null object - call after object destroyed?"),
        0, 0, 0, 0));					
    return ;
  }
  
  {
    jthrowable t = NULL;
    try {
      delete arg1;
    }
    catch (std::exception &se) {
      t = createException(jenv, &se);
      jenv->Throw(t);
      return ;
    }
    catch(JavaException & /* je */) {
      // This means there's already an exception waiting in the JVM
      return ;
    }
    catch (...) {
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("Uncaught exception from C++ API"), 0, 0, 0, 0);
      jenv->Throw(t);
      return ;
    }
  }
}


SWIGEXPORT jboolean JNICALL Java_com_sleepycat_dbxml_dbxml_1javaJNI_XmlIndexLookup_1isNull(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jboolean jresult = 0 ;
  XmlIndexLookup *arg1 = (XmlIndexLookup *) 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(XmlIndexLookup **)&jarg1; 
  
  if (!jarg1) {
    jenv->Throw((jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INVALID_VALUE,
        jenv->NewStringUTF("null object - call after object destroyed?"),
        0, 0, 0, 0));					
    return 0;
  }
  
  {
    jthrowable t = NULL;
    try {
      result = (bool)((XmlIndexLookup const *)arg1)->isNull();
    }
    catch (std::exception &se) {
      t = createException(jenv, &se);
      jenv->Throw(t);
      return 0;
    }
    catch(JavaException & /* je */) {
      // This means there's already an exception waiting in the JVM
      return 0;
    }
    catch (...) {
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("Uncaught exception from C++ API"), 0, 0, 0, 0);
      jenv->Throw(t);
      return 0;
    }
  }
  
  jresult = result ? JNI_TRUE : JNI_FALSE;
  
  return jresult;
}


SWIGEXPORT jstring JNICALL Java_com_sleepycat_dbxml_dbxml_1javaJNI_XmlIndexLookup_1getIndex(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jstring jresult = 0 ;
  XmlIndexLookup *arg1 = (XmlIndexLookup *) 0 ;
  std::string *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(XmlIndexLookup **)&jarg1; 
  
  if (!jarg1) {
    jenv->Throw((jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INVALID_VALUE,
        jenv->NewStringUTF("null object - call after object destroyed?"),
        0, 0, 0, 0));					
    return 0;
  }
  
  {
    jthrowable t = NULL;
    try {
      result = (std::string *) &((XmlIndexLookup const *)arg1)->getIndex();
    }
    catch (std::exception &se) {
      t = createException(jenv, &se);
      jenv->Throw(t);
      return 0;
    }
    catch(JavaException & /* je */) {
      // This means there's already an exception waiting in the JVM
      return 0;
    }
    catch (...) {
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("Uncaught exception from C++ API"), 0, 0, 0, 0);
      jenv->Throw(t);
      return 0;
    }
  }
  jresult = jenv->NewStringUTF(result->c_str()); 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_sleepycat_dbxml_dbxml_1javaJNI_XmlIndexLookup_1setIndex(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2) {
  XmlIndexLookup *arg1 = (XmlIndexLookup *) 0 ;
  std::string *arg2 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(XmlIndexLookup **)&jarg1; 
  
  const char *arg2_pstr = "";
  if(jarg2) {
    arg2_pstr = (const char *)jenv->GetStringUTFChars(jarg2, 0);
  }
  if (!arg2_pstr) return ;
  std::string arg2_str(arg2_pstr);
  arg2 = &arg2_str;
  if (jarg2) {
    jenv->ReleaseStringUTFChars(jarg2, arg2_pstr);
  }
  
  
  if (!jarg1) {
    jenv->Throw((jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INVALID_VALUE,
        jenv->NewStringUTF("null object - call after object destroyed?"),
        0, 0, 0, 0));					
    return ;
  }
  
  {
    jthrowable t = NULL;
    try {
      (arg1)->setIndex((std::string const &)*arg2);
    }
    catch (std::exception &se) {
      t = createException(jenv, &se);
      jenv->Throw(t);
      return ;
    }
    catch(JavaException & /* je */) {
      // This means there's already an exception waiting in the JVM
      return ;
    }
    catch (...) {
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("Uncaught exception from C++ API"), 0, 0, 0, 0);
      jenv->Throw(t);
      return ;
    }
  }
}


SWIGEXPORT jstring JNICALL Java_com_sleepycat_dbxml_dbxml_1javaJNI_XmlIndexLookup_1getNodeURI(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jstring jresult = 0 ;
  XmlIndexLookup *arg1 = (XmlIndexLookup *) 0 ;
  std::string *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(XmlIndexLookup **)&jarg1; 
  
  if (!jarg1) {
    jenv->Throw((jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INVALID_VALUE,
        jenv->NewStringUTF("null object - call after object destroyed?"),
        0, 0, 0, 0));					
    return 0;
  }
  
  {
    jthrowable t = NULL;
    try {
      result = (std::string *) &((XmlIndexLookup const *)arg1)->getNodeURI();
    }
    catch (std::exception &se) {
      t = createException(jenv, &se);
      jenv->Throw(t);
      return 0;
    }
    catch(JavaException & /* je */) {
      // This means there's already an exception waiting in the JVM
      return 0;
    }
    catch (...) {
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("Uncaught exception from C++ API"), 0, 0, 0, 0);
      jenv->Throw(t);
      return 0;
    }
  }
  jresult = jenv->NewStringUTF(result->c_str()); 
  return jresult;
}


SWIGEXPORT jstring JNICALL Java_com_sleepycat_dbxml_dbxml_1javaJNI_XmlIndexLookup_1getNodeName(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jstring jresult = 0 ;
  XmlIndexLookup *arg1 = (XmlIndexLookup *) 0 ;
  std::string *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(XmlIndexLookup **)&jarg1; 
  
  if (!jarg1) {
    jenv->Throw((jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INVALID_VALUE,
        jenv->NewStringUTF("null object - call after object destroyed?"),
        0, 0, 0, 0));					
    return 0;
  }
  
  {
    jthrowable t = NULL;
    try {
      result = (std::string *) &((XmlIndexLookup const *)arg1)->getNodeName();
    }
    catch (std::exception &se) {
      t = createException(jenv, &se);
      jenv->Throw(t);
      return 0;
    }
    catch(JavaException & /* je */) {
      // This means there's already an exception waiting in the JVM
      return 0;
    }
    catch (...) {
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("Uncaught exception from C++ API"), 0, 0, 0, 0);
      jenv->Throw(t);
      return 0;
    }
  }
  jresult = jenv->NewStringUTF(result->c_str()); 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_sleepycat_dbxml_dbxml_1javaJNI_XmlIndexLookup_1setNode(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2, jstring jarg3) {
  XmlIndexLookup *arg1 = (XmlIndexLookup *) 0 ;
  std::string *arg2 = 0 ;
  std::string *arg3 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(XmlIndexLookup **)&jarg1; 
  
  const char *arg2_pstr = "";
  if(jarg2) {
    arg2_pstr = (const char *)jenv->GetStringUTFChars(jarg2, 0);
  }
  if (!arg2_pstr) return ;
  std::string arg2_str(arg2_pstr);
  arg2 = &arg2_str;
  if (jarg2) {
    jenv->ReleaseStringUTFChars(jarg2, arg2_pstr);
  }
  
  
  const char *arg3_pstr = "";
  if(jarg3) {
    arg3_pstr = (const char *)jenv->GetStringUTFChars(jarg3, 0);
  }
  if (!arg3_pstr) return ;
  std::string arg3_str(arg3_pstr);
  arg3 = &arg3_str;
  if (jarg3) {
    jenv->ReleaseStringUTFChars(jarg3, arg3_pstr);
  }
  
  
  if (!jarg1) {
    jenv->Throw((jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INVALID_VALUE,
        jenv->NewStringUTF("null object - call after object destroyed?"),
        0, 0, 0, 0));					
    return ;
  }
  
  {
    jthrowable t = NULL;
    try {
      (arg1)->setNode((std::string const &)*arg2,(std::string const &)*arg3);
    }
    catch (std::exception &se) {
      t = createException(jenv, &se);
      jenv->Throw(t);
      return ;
    }
    catch(JavaException & /* je */) {
      // This means there's already an exception waiting in the JVM
      return ;
    }
    catch (...) {
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("Uncaught exception from C++ API"), 0, 0, 0, 0);
      jenv->Throw(t);
      return ;
    }
  }
}


SWIGEXPORT jstring JNICALL Java_com_sleepycat_dbxml_dbxml_1javaJNI_XmlIndexLookup_1getParentURI(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jstring jresult = 0 ;
  XmlIndexLookup *arg1 = (XmlIndexLookup *) 0 ;
  std::string *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(XmlIndexLookup **)&jarg1; 
  
  if (!jarg1) {
    jenv->Throw((jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INVALID_VALUE,
        jenv->NewStringUTF("null object - call after object destroyed?"),
        0, 0, 0, 0));					
    return 0;
  }
  
  {
    jthrowable t = NULL;
    try {
      result = (std::string *) &((XmlIndexLookup const *)arg1)->getParentURI();
    }
    catch (std::exception &se) {
      t = createException(jenv, &se);
      jenv->Throw(t);
      return 0;
    }
    catch(JavaException & /* je */) {
      // This means there's already an exception waiting in the JVM
      return 0;
    }
    catch (...) {
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("Uncaught exception from C++ API"), 0, 0, 0, 0);
      jenv->Throw(t);
      return 0;
    }
  }
  jresult = jenv->NewStringUTF(result->c_str()); 
  return jresult;
}


SWIGEXPORT jstring JNICALL Java_com_sleepycat_dbxml_dbxml_1javaJNI_XmlIndexLookup_1getParentName(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jstring jresult = 0 ;
  XmlIndexLookup *arg1 = (XmlIndexLookup *) 0 ;
  std::string *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(XmlIndexLookup **)&jarg1; 
  
  if (!jarg1) {
    jenv->Throw((jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INVALID_VALUE,
        jenv->NewStringUTF("null object - call after object destroyed?"),
        0, 0, 0, 0));					
    return 0;
  }
  
  {
    jthrowable t = NULL;
    try {
      result = (std::string *) &((XmlIndexLookup const *)arg1)->getParentName();
    }
    catch (std::exception &se) {
      t = createException(jenv, &se);
      jenv->Throw(t);
      return 0;
    }
    catch(JavaException & /* je */) {
      // This means there's already an exception waiting in the JVM
      return 0;
    }
    catch (...) {
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("Uncaught exception from C++ API"), 0, 0, 0, 0);
      jenv->Throw(t);
      return 0;
    }
  }
  jresult = jenv->NewStringUTF(result->c_str()); 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_sleepycat_dbxml_dbxml_1javaJNI_XmlIndexLookup_1setParent(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2, jstring jarg3) {
  XmlIndexLookup *arg1 = (XmlIndexLookup *) 0 ;
  std::string *arg2 = 0 ;
  std::string *arg3 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(XmlIndexLookup **)&jarg1; 
  
  const char *arg2_pstr = "";
  if(jarg2) {
    arg2_pstr = (const char *)jenv->GetStringUTFChars(jarg2, 0);
  }
  if (!arg2_pstr) return ;
  std::string arg2_str(arg2_pstr);
  arg2 = &arg2_str;
  if (jarg2) {
    jenv->ReleaseStringUTFChars(jarg2, arg2_pstr);
  }
  
  
  const char *arg3_pstr = "";
  if(jarg3) {
    arg3_pstr = (const char *)jenv->GetStringUTFChars(jarg3, 0);
  }
  if (!arg3_pstr) return ;
  std::string arg3_str(arg3_pstr);
  arg3 = &arg3_str;
  if (jarg3) {
    jenv->ReleaseStringUTFChars(jarg3, arg3_pstr);
  }
  
  
  if (!jarg1) {
    jenv->Throw((jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INVALID_VALUE,
        jenv->NewStringUTF("null object - call after object destroyed?"),
        0, 0, 0, 0));					
    return ;
  }
  
  {
    jthrowable t = NULL;
    try {
      (arg1)->setParent((std::string const &)*arg2,(std::string const &)*arg3);
    }
    catch (std::exception &se) {
      t = createException(jenv, &se);
      jenv->Throw(t);
      return ;
    }
    catch(JavaException & /* je */) {
      // This means there's already an exception waiting in the JVM
      return ;
    }
    catch (...) {
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("Uncaught exception from C++ API"), 0, 0, 0, 0);
      jenv->Throw(t);
      return ;
    }
  }
}


SWIGEXPORT jint JNICALL Java_com_sleepycat_dbxml_dbxml_1javaJNI_XmlIndexLookup_1getLowBoundOperation(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  XmlIndexLookup *arg1 = (XmlIndexLookup *) 0 ;
  enum XmlIndexLookup::Operation result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(XmlIndexLookup **)&jarg1; 
  
  if (!jarg1) {
    jenv->Throw((jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INVALID_VALUE,
        jenv->NewStringUTF("null object - call after object destroyed?"),
        0, 0, 0, 0));					
    return 0;
  }
  
  {
    jthrowable t = NULL;
    try {
      result = (enum XmlIndexLookup::Operation)((XmlIndexLookup const *)arg1)->getLowBoundOperation();
    }
    catch (std::exception &se) {
      t = createException(jenv, &se);
      jenv->Throw(t);
      return 0;
    }
    catch(JavaException & /* je */) {
      // This means there's already an exception waiting in the JVM
      return 0;
    }
    catch (...) {
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("Uncaught exception from C++ API"), 0, 0, 0, 0);
      jenv->Throw(t);
      return 0;
    }
  }
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_sleepycat_dbxml_dbxml_1javaJNI_XmlIndexLookup_1setLowBoundInternal(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jobject jarg2, jint jarg3) {
  XmlIndexLookup *arg1 = (XmlIndexLookup *) 0 ;
  XmlValue *arg2 = 0 ;
  enum XmlIndexLookup::Operation arg3 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(XmlIndexLookup **)&jarg1; 
  
  bool valid = true;
  XmlValue val2 = createCPPXmlValue(jenv, jarg2, &valid);
  if (!valid) return ;
  arg2 = &val2;
  
  arg3 = (enum XmlIndexLookup::Operation)jarg3; 
  
  if (!jarg1) {
    jenv->Throw((jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INVALID_VALUE,
        jenv->NewStringUTF("null object - call after object destroyed?"),
        0, 0, 0, 0));					
    return ;
  }
  
  {
    jthrowable t = NULL;
    try {
      (arg1)->setLowBound((XmlValue const &)*arg2,arg3);
    }
    catch (std::exception &se) {
      t = createException(jenv, &se);
      jenv->Throw(t);
      return ;
    }
    catch(JavaException & /* je */) {
      // This means there's already an exception waiting in the JVM
      return ;
    }
    catch (...) {
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("Uncaught exception from C++ API"), 0, 0, 0, 0);
      jenv->Throw(t);
      return ;
    }
  }
}


SWIGEXPORT jint JNICALL Java_com_sleepycat_dbxml_dbxml_1javaJNI_XmlIndexLookup_1getHighBoundOperation(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  XmlIndexLookup *arg1 = (XmlIndexLookup *) 0 ;
  enum XmlIndexLookup::Operation result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(XmlIndexLookup **)&jarg1; 
  
  if (!jarg1) {
    jenv->Throw((jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INVALID_VALUE,
        jenv->NewStringUTF("null object - call after object destroyed?"),
        0, 0, 0, 0));					
    return 0;
  }
  
  {
    jthrowable t = NULL;
    try {
      result = (enum XmlIndexLookup::Operation)((XmlIndexLookup const *)arg1)->getHighBoundOperation();
    }
    catch (std::exception &se) {
      t = createException(jenv, &se);
      jenv->Throw(t);
      return 0;
    }
    catch(JavaException & /* je */) {
      // This means there's already an exception waiting in the JVM
      return 0;
    }
    catch (...) {
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("Uncaught exception from C++ API"), 0, 0, 0, 0);
      jenv->Throw(t);
      return 0;
    }
  }
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_sleepycat_dbxml_dbxml_1javaJNI_XmlIndexLookup_1setHighBoundInternal(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jobject jarg2, jint jarg3) {
  XmlIndexLookup *arg1 = (XmlIndexLookup *) 0 ;
  XmlValue *arg2 = 0 ;
  enum XmlIndexLookup::Operation arg3 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(XmlIndexLookup **)&jarg1; 
  
  bool valid = true;
  XmlValue val2 = createCPPXmlValue(jenv, jarg2, &valid);
  if (!valid) return ;
  arg2 = &val2;
  
  arg3 = (enum XmlIndexLookup::Operation)jarg3; 
  
  if (!jarg1) {
    jenv->Throw((jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INVALID_VALUE,
        jenv->NewStringUTF("null object - call after object destroyed?"),
        0, 0, 0, 0));					
    return ;
  }
  
  {
    jthrowable t = NULL;
    try {
      (arg1)->setHighBound((XmlValue const &)*arg2,arg3);
    }
    catch (std::exception &se) {
      t = createException(jenv, &se);
      jenv->Throw(t);
      return ;
    }
    catch(JavaException & /* je */) {
      // This means there's already an exception waiting in the JVM
      return ;
    }
    catch (...) {
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("Uncaught exception from C++ API"), 0, 0, 0, 0);
      jenv->Throw(t);
      return ;
    }
  }
}


SWIGEXPORT void JNICALL Java_com_sleepycat_dbxml_dbxml_1javaJNI_XmlIndexLookup_1setContainerInternal(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  XmlIndexLookup *arg1 = (XmlIndexLookup *) 0 ;
  XmlContainer *arg2 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(XmlIndexLookup **)&jarg1; 
  arg2 = *(XmlContainer **)&jarg2;
  if(!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "XmlContainer & reference is null");
    return ;
  } 
  
  if (!jarg1) {
    jenv->Throw((jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INVALID_VALUE,
        jenv->NewStringUTF("null object - call after object destroyed?"),
        0, 0, 0, 0));					
    return ;
  }
  
  {
    jthrowable t = NULL;
    try {
      (arg1)->setContainer(*arg2);
    }
    catch (std::exception &se) {
      t = createException(jenv, &se);
      jenv->Throw(t);
      return ;
    }
    catch(JavaException & /* je */) {
      // This means there's already an exception waiting in the JVM
      return ;
    }
    catch (...) {
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("Uncaught exception from C++ API"), 0, 0, 0, 0);
      jenv->Throw(t);
      return ;
    }
  }
}


SWIGEXPORT jlong JNICALL Java_com_sleepycat_dbxml_dbxml_1javaJNI_XmlIndexLookup_1execute_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong mgrPtr2, jlong dbgPtr2, jint eval2, jint querySec2, jobjectArray data2, jobject jarg2, jint jarg3) {
  jlong jresult = 0 ;
  XmlIndexLookup *arg1 = (XmlIndexLookup *) 0 ;
  XmlQueryContext *arg2 = 0 ;
  u_int32_t arg3 ;
  XmlResults *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(XmlIndexLookup **)&jarg1; 
  
  queryContextRef qcRef(jenv, mgrPtr2, dbgPtr2, eval2, querySec2, data2, jarg2);
  if (qcRef.getQC()->isNull())
  return 0; // exception was thrown
  arg2 = qcRef.getQC();
  
  arg3 = (u_int32_t)jarg3; 
  
  if (!jarg1) {
    jenv->Throw((jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INVALID_VALUE,
        jenv->NewStringUTF("null object - call after object destroyed?"),
        0, 0, 0, 0));					
    return 0;
  }
  
  {
    jthrowable t = NULL;
    try {
      result = (XmlResults *)XmlIndexLookup_execute__SWIG_0((XmlIndexLookup const *)arg1,*arg2,arg3);
    }
    catch (std::exception &se) {
      t = createException(jenv, &se);
      jenv->Throw(t);
      return 0;
    }
    catch(JavaException & /* je */) {
      // This means there's already an exception waiting in the JVM
      return 0;
    }
    catch (...) {
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("Uncaught exception from C++ API"), 0, 0, 0, 0);
      jenv->Throw(t);
      return 0;
    }
  }
  *(XmlResults **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_sleepycat_dbxml_dbxml_1javaJNI_XmlIndexLookup_1execute_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong mgrPtr2, jlong dbgPtr2, jint eval2, jint querySec2, jobjectArray data2, jobject jarg2) {
  jlong jresult = 0 ;
  XmlIndexLookup *arg1 = (XmlIndexLookup *) 0 ;
  XmlQueryContext *arg2 = 0 ;
  XmlResults *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(XmlIndexLookup **)&jarg1; 
  
  queryContextRef qcRef(jenv, mgrPtr2, dbgPtr2, eval2, querySec2, data2, jarg2);
  if (qcRef.getQC()->isNull())
  return 0; // exception was thrown
  arg2 = qcRef.getQC();
  
  
  if (!jarg1) {
    jenv->Throw((jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INVALID_VALUE,
        jenv->NewStringUTF("null object - call after object destroyed?"),
        0, 0, 0, 0));					
    return 0;
  }
  
  {
    jthrowable t = NULL;
    try {
      result = (XmlResults *)XmlIndexLookup_execute__SWIG_0((XmlIndexLookup const *)arg1,*arg2);
    }
    catch (std::exception &se) {
      t = createException(jenv, &se);
      jenv->Throw(t);
      return 0;
    }
    catch(JavaException & /* je */) {
      // This means there's already an exception waiting in the JVM
      return 0;
    }
    catch (...) {
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("Uncaught exception from C++ API"), 0, 0, 0, 0);
      jenv->Throw(t);
      return 0;
    }
  }
  *(XmlResults **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_sleepycat_dbxml_dbxml_1javaJNI_XmlIndexLookup_1execute_1_1SWIG_12(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_, jlong mgrPtr3, jlong dbgPtr3, jint eval3, jint querySec3, jobjectArray data3, jobject jarg3, jint jarg4) {
  jlong jresult = 0 ;
  XmlIndexLookup *arg1 = (XmlIndexLookup *) 0 ;
  XmlTransaction *arg2 = 0 ;
  XmlQueryContext *arg3 = 0 ;
  u_int32_t arg4 ;
  XmlResults *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(XmlIndexLookup **)&jarg1; 
  arg2 = *(XmlTransaction **)&jarg2;
  if(!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "XmlTransaction & reference is null");
    return 0;
  } 
  
  queryContextRef qcRef(jenv, mgrPtr3, dbgPtr3, eval3, querySec3, data3, jarg3);
  if (qcRef.getQC()->isNull())
  return 0; // exception was thrown
  arg3 = qcRef.getQC();
  
  arg4 = (u_int32_t)jarg4; 
  
  if (!jarg1) {
    jenv->Throw((jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INVALID_VALUE,
        jenv->NewStringUTF("null object - call after object destroyed?"),
        0, 0, 0, 0));					
    return 0;
  }
  
  {
    jthrowable t = NULL;
    try {
      result = (XmlResults *)XmlIndexLookup_execute__SWIG_2((XmlIndexLookup const *)arg1,*arg2,*arg3,arg4);
    }
    catch (std::exception &se) {
      t = createException(jenv, &se);
      jenv->Throw(t);
      return 0;
    }
    catch(JavaException & /* je */) {
      // This means there's already an exception waiting in the JVM
      return 0;
    }
    catch (...) {
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("Uncaught exception from C++ API"), 0, 0, 0, 0);
      jenv->Throw(t);
      return 0;
    }
  }
  *(XmlResults **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_sleepycat_dbxml_dbxml_1javaJNI_XmlIndexLookup_1execute_1_1SWIG_13(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_, jlong mgrPtr3, jlong dbgPtr3, jint eval3, jint querySec3, jobjectArray data3, jobject jarg3) {
  jlong jresult = 0 ;
  XmlIndexLookup *arg1 = (XmlIndexLookup *) 0 ;
  XmlTransaction *arg2 = 0 ;
  XmlQueryContext *arg3 = 0 ;
  XmlResults *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(XmlIndexLookup **)&jarg1; 
  arg2 = *(XmlTransaction **)&jarg2;
  if(!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "XmlTransaction & reference is null");
    return 0;
  } 
  
  queryContextRef qcRef(jenv, mgrPtr3, dbgPtr3, eval3, querySec3, data3, jarg3);
  if (qcRef.getQC()->isNull())
  return 0; // exception was thrown
  arg3 = qcRef.getQC();
  
  
  if (!jarg1) {
    jenv->Throw((jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INVALID_VALUE,
        jenv->NewStringUTF("null object - call after object destroyed?"),
        0, 0, 0, 0));					
    return 0;
  }
  
  {
    jthrowable t = NULL;
    try {
      result = (XmlResults *)XmlIndexLookup_execute__SWIG_2((XmlIndexLookup const *)arg1,*arg2,*arg3);
    }
    catch (std::exception &se) {
      t = createException(jenv, &se);
      jenv->Throw(t);
      return 0;
    }
    catch(JavaException & /* je */) {
      // This means there's already an exception waiting in the JVM
      return 0;
    }
    catch (...) {
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("Uncaught exception from C++ API"), 0, 0, 0, 0);
      jenv->Throw(t);
      return 0;
    }
  }
  *(XmlResults **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_sleepycat_dbxml_dbxml_1javaJNI_XmlIndexLookup_1copy(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  XmlIndexLookup *arg1 = 0 ;
  XmlIndexLookup *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(XmlIndexLookup **)&jarg1;
  if(!arg1) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "XmlIndexLookup const & reference is null");
    return 0;
  } 
  {
    jthrowable t = NULL;
    try {
      result = (XmlIndexLookup *)XmlIndexLookup_copy((XmlIndexLookup const &)*arg1);
    }
    catch (std::exception &se) {
      t = createException(jenv, &se);
      jenv->Throw(t);
      return 0;
    }
    catch(JavaException & /* je */) {
      // This means there's already an exception waiting in the JVM
      return 0;
    }
    catch (...) {
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("Uncaught exception from C++ API"), 0, 0, 0, 0);
      jenv->Throw(t);
      return 0;
    }
  }
  *(XmlIndexLookup **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_sleepycat_dbxml_dbxml_1javaJNI_new_1XmlContainer(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  XmlContainer *arg1 = 0 ;
  XmlContainer *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(XmlContainer **)&jarg1;
  if(!arg1) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "XmlContainer const & reference is null");
    return 0;
  } 
  {
    jthrowable t = NULL;
    try {
      result = (XmlContainer *)new XmlContainer((XmlContainer const &)*arg1);
    }
    catch (std::exception &se) {
      t = createException(jenv, &se);
      jenv->Throw(t);
      return 0;
    }
    catch(JavaException & /* je */) {
      // This means there's already an exception waiting in the JVM
      return 0;
    }
    catch (...) {
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("Uncaught exception from C++ API"), 0, 0, 0, 0);
      jenv->Throw(t);
      return 0;
    }
  }
  *(XmlContainer **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_sleepycat_dbxml_dbxml_1javaJNI_delete_1XmlContainer(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  XmlContainer *arg1 = (XmlContainer *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(XmlContainer **)&jarg1; 
  
  if (!jarg1) {
    jenv->Throw((jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INVALID_VALUE,
        jenv->NewStringUTF("null object - call after object destroyed?"),
        0, 0, 0, 0));					
    return ;
  }
  
  {
    jthrowable t = NULL;
    try {
      delete arg1;
    }
    catch (std::exception &se) {
      t = createException(jenv, &se);
      jenv->Throw(t);
      return ;
    }
    catch(JavaException & /* je */) {
      // This means there's already an exception waiting in the JVM
      return ;
    }
    catch (...) {
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("Uncaught exception from C++ API"), 0, 0, 0, 0);
      jenv->Throw(t);
      return ;
    }
  }
}


SWIGEXPORT void JNICALL Java_com_sleepycat_dbxml_dbxml_1javaJNI_XmlContainer_1sync(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  XmlContainer *arg1 = (XmlContainer *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(XmlContainer **)&jarg1; 
  
  if (!jarg1) {
    jenv->Throw((jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INVALID_VALUE,
        jenv->NewStringUTF("null object - call after object destroyed?"),
        0, 0, 0, 0));					
    return ;
  }
  
  {
    jthrowable t = NULL;
    try {
      (arg1)->sync();
    }
    catch (std::exception &se) {
      t = createException(jenv, &se);
      jenv->Throw(t);
      return ;
    }
    catch(JavaException & /* je */) {
      // This means there's already an exception waiting in the JVM
      return ;
    }
    catch (...) {
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("Uncaught exception from C++ API"), 0, 0, 0, 0);
      jenv->Throw(t);
      return ;
    }
  }
}


SWIGEXPORT jboolean JNICALL Java_com_sleepycat_dbxml_dbxml_1javaJNI_XmlContainer_1addAlias(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2) {
  jboolean jresult = 0 ;
  XmlContainer *arg1 = (XmlContainer *) 0 ;
  std::string *arg2 = 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(XmlContainer **)&jarg1; 
  
  const char *arg2_pstr = "";
  if(jarg2) {
    arg2_pstr = (const char *)jenv->GetStringUTFChars(jarg2, 0);
  }
  if (!arg2_pstr) return 0;
  std::string arg2_str(arg2_pstr);
  arg2 = &arg2_str;
  if (jarg2) {
    jenv->ReleaseStringUTFChars(jarg2, arg2_pstr);
  }
  
  
  if (!jarg1) {
    jenv->Throw((jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INVALID_VALUE,
        jenv->NewStringUTF("null object - call after object destroyed?"),
        0, 0, 0, 0));					
    return 0;
  }
  
  {
    jthrowable t = NULL;
    try {
      result = (bool)(arg1)->addAlias((std::string const &)*arg2);
    }
    catch (std::exception &se) {
      t = createException(jenv, &se);
      jenv->Throw(t);
      return 0;
    }
    catch(JavaException & /* je */) {
      // This means there's already an exception waiting in the JVM
      return 0;
    }
    catch (...) {
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("Uncaught exception from C++ API"), 0, 0, 0, 0);
      jenv->Throw(t);
      return 0;
    }
  }
  
  jresult = result ? JNI_TRUE : JNI_FALSE;
  
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_com_sleepycat_dbxml_dbxml_1javaJNI_XmlContainer_1removeAlias(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2) {
  jboolean jresult = 0 ;
  XmlContainer *arg1 = (XmlContainer *) 0 ;
  std::string *arg2 = 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(XmlContainer **)&jarg1; 
  
  const char *arg2_pstr = "";
  if(jarg2) {
    arg2_pstr = (const char *)jenv->GetStringUTFChars(jarg2, 0);
  }
  if (!arg2_pstr) return 0;
  std::string arg2_str(arg2_pstr);
  arg2 = &arg2_str;
  if (jarg2) {
    jenv->ReleaseStringUTFChars(jarg2, arg2_pstr);
  }
  
  
  if (!jarg1) {
    jenv->Throw((jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INVALID_VALUE,
        jenv->NewStringUTF("null object - call after object destroyed?"),
        0, 0, 0, 0));					
    return 0;
  }
  
  {
    jthrowable t = NULL;
    try {
      result = (bool)(arg1)->removeAlias((std::string const &)*arg2);
    }
    catch (std::exception &se) {
      t = createException(jenv, &se);
      jenv->Throw(t);
      return 0;
    }
    catch(JavaException & /* je */) {
      // This means there's already an exception waiting in the JVM
      return 0;
    }
    catch (...) {
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("Uncaught exception from C++ API"), 0, 0, 0, 0);
      jenv->Throw(t);
      return 0;
    }
  }
  
  jresult = result ? JNI_TRUE : JNI_FALSE;
  
  return jresult;
}


SWIGEXPORT jstring JNICALL Java_com_sleepycat_dbxml_dbxml_1javaJNI_XmlContainer_1getName(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jstring jresult = 0 ;
  XmlContainer *arg1 = (XmlContainer *) 0 ;
  std::string *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(XmlContainer **)&jarg1; 
  
  if (!jarg1) {
    jenv->Throw((jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INVALID_VALUE,
        jenv->NewStringUTF("null object - call after object destroyed?"),
        0, 0, 0, 0));					
    return 0;
  }
  
  {
    jthrowable t = NULL;
    try {
      result = (std::string *) &((XmlContainer const *)arg1)->getName();
    }
    catch (std::exception &se) {
      t = createException(jenv, &se);
      jenv->Throw(t);
      return 0;
    }
    catch(JavaException & /* je */) {
      // This means there's already an exception waiting in the JVM
      return 0;
    }
    catch (...) {
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("Uncaught exception from C++ API"), 0, 0, 0, 0);
      jenv->Throw(t);
      return 0;
    }
  }
  jresult = jenv->NewStringUTF(result->c_str()); 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_com_sleepycat_dbxml_dbxml_1javaJNI_XmlContainer_1getContainerType(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  XmlContainer *arg1 = (XmlContainer *) 0 ;
  enum XmlContainer::ContainerType result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(XmlContainer **)&jarg1; 
  
  if (!jarg1) {
    jenv->Throw((jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INVALID_VALUE,
        jenv->NewStringUTF("null object - call after object destroyed?"),
        0, 0, 0, 0));					
    return 0;
  }
  
  {
    jthrowable t = NULL;
    try {
      result = (enum XmlContainer::ContainerType)((XmlContainer const *)arg1)->getContainerType();
    }
    catch (std::exception &se) {
      t = createException(jenv, &se);
      jenv->Throw(t);
      return 0;
    }
    catch(JavaException & /* je */) {
      // This means there's already an exception waiting in the JVM
      return 0;
    }
    catch (...) {
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("Uncaught exception from C++ API"), 0, 0, 0, 0);
      jenv->Throw(t);
      return 0;
    }
  }
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_com_sleepycat_dbxml_dbxml_1javaJNI_XmlContainer_1getIndexNodes(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jboolean jresult = 0 ;
  XmlContainer *arg1 = (XmlContainer *) 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(XmlContainer **)&jarg1; 
  
  if (!jarg1) {
    jenv->Throw((jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INVALID_VALUE,
        jenv->NewStringUTF("null object - call after object destroyed?"),
        0, 0, 0, 0));					
    return 0;
  }
  
  {
    jthrowable t = NULL;
    try {
      result = (bool)((XmlContainer const *)arg1)->getIndexNodes();
    }
    catch (std::exception &se) {
      t = createException(jenv, &se);
      jenv->Throw(t);
      return 0;
    }
    catch(JavaException & /* je */) {
      // This means there's already an exception waiting in the JVM
      return 0;
    }
    catch (...) {
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("Uncaught exception from C++ API"), 0, 0, 0, 0);
      jenv->Throw(t);
      return 0;
    }
  }
  
  jresult = result ? JNI_TRUE : JNI_FALSE;
  
  return jresult;
}


SWIGEXPORT jint JNICALL Java_com_sleepycat_dbxml_dbxml_1javaJNI_XmlContainer_1getPageSize(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  XmlContainer *arg1 = (XmlContainer *) 0 ;
  u_int32_t result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(XmlContainer **)&jarg1; 
  
  if (!jarg1) {
    jenv->Throw((jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INVALID_VALUE,
        jenv->NewStringUTF("null object - call after object destroyed?"),
        0, 0, 0, 0));					
    return 0;
  }
  
  {
    jthrowable t = NULL;
    try {
      result = ((XmlContainer const *)arg1)->getPageSize();
    }
    catch (std::exception &se) {
      t = createException(jenv, &se);
      jenv->Throw(t);
      return 0;
    }
    catch(JavaException & /* je */) {
      // This means there's already an exception waiting in the JVM
      return 0;
    }
    catch (...) {
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("Uncaught exception from C++ API"), 0, 0, 0, 0);
      jenv->Throw(t);
      return 0;
    }
  }
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_com_sleepycat_dbxml_dbxml_1javaJNI_XmlContainer_1getAutoIndexing_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jboolean jresult = 0 ;
  XmlContainer *arg1 = (XmlContainer *) 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(XmlContainer **)&jarg1; 
  
  if (!jarg1) {
    jenv->Throw((jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INVALID_VALUE,
        jenv->NewStringUTF("null object - call after object destroyed?"),
        0, 0, 0, 0));					
    return 0;
  }
  
  {
    jthrowable t = NULL;
    try {
      result = (bool)((XmlContainer const *)arg1)->getAutoIndexing();
    }
    catch (std::exception &se) {
      t = createException(jenv, &se);
      jenv->Throw(t);
      return 0;
    }
    catch(JavaException & /* je */) {
      // This means there's already an exception waiting in the JVM
      return 0;
    }
    catch (...) {
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("Uncaught exception from C++ API"), 0, 0, 0, 0);
      jenv->Throw(t);
      return 0;
    }
  }
  
  jresult = result ? JNI_TRUE : JNI_FALSE;
  
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_com_sleepycat_dbxml_dbxml_1javaJNI_XmlContainer_1getAutoIndexing_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  jboolean jresult = 0 ;
  XmlContainer *arg1 = (XmlContainer *) 0 ;
  XmlTransaction *arg2 = 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(XmlContainer **)&jarg1; 
  arg2 = *(XmlTransaction **)&jarg2;
  if(!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "XmlTransaction & reference is null");
    return 0;
  } 
  
  if (!jarg1) {
    jenv->Throw((jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INVALID_VALUE,
        jenv->NewStringUTF("null object - call after object destroyed?"),
        0, 0, 0, 0));					
    return 0;
  }
  
  {
    jthrowable t = NULL;
    try {
      result = (bool)((XmlContainer const *)arg1)->getAutoIndexing(*arg2);
    }
    catch (std::exception &se) {
      t = createException(jenv, &se);
      jenv->Throw(t);
      return 0;
    }
    catch(JavaException & /* je */) {
      // This means there's already an exception waiting in the JVM
      return 0;
    }
    catch (...) {
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("Uncaught exception from C++ API"), 0, 0, 0, 0);
      jenv->Throw(t);
      return 0;
    }
  }
  
  jresult = result ? JNI_TRUE : JNI_FALSE;
  
  return jresult;
}


SWIGEXPORT jint JNICALL Java_com_sleepycat_dbxml_dbxml_1javaJNI_XmlContainer_1getNumDocuments_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  XmlContainer *arg1 = (XmlContainer *) 0 ;
  size_t result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(XmlContainer **)&jarg1; 
  
  if (!jarg1) {
    jenv->Throw((jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INVALID_VALUE,
        jenv->NewStringUTF("null object - call after object destroyed?"),
        0, 0, 0, 0));					
    return 0;
  }
  
  {
    jthrowable t = NULL;
    try {
      result = (arg1)->getNumDocuments();
    }
    catch (std::exception &se) {
      t = createException(jenv, &se);
      jenv->Throw(t);
      return 0;
    }
    catch(JavaException & /* je */) {
      // This means there's already an exception waiting in the JVM
      return 0;
    }
    catch (...) {
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("Uncaught exception from C++ API"), 0, 0, 0, 0);
      jenv->Throw(t);
      return 0;
    }
  }
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_com_sleepycat_dbxml_dbxml_1javaJNI_XmlContainer_1getNumDocuments_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  jint jresult = 0 ;
  XmlContainer *arg1 = (XmlContainer *) 0 ;
  XmlTransaction *arg2 = 0 ;
  size_t result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(XmlContainer **)&jarg1; 
  arg2 = *(XmlTransaction **)&jarg2;
  if(!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "XmlTransaction & reference is null");
    return 0;
  } 
  
  if (!jarg1) {
    jenv->Throw((jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INVALID_VALUE,
        jenv->NewStringUTF("null object - call after object destroyed?"),
        0, 0, 0, 0));					
    return 0;
  }
  
  {
    jthrowable t = NULL;
    try {
      result = (arg1)->getNumDocuments(*arg2);
    }
    catch (std::exception &se) {
      t = createException(jenv, &se);
      jenv->Throw(t);
      return 0;
    }
    catch(JavaException & /* je */) {
      // This means there's already an exception waiting in the JVM
      return 0;
    }
    catch (...) {
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("Uncaught exception from C++ API"), 0, 0, 0, 0);
      jenv->Throw(t);
      return 0;
    }
  }
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_sleepycat_dbxml_dbxml_1javaJNI_XmlContainer_1getIndexSpecification_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  XmlContainer *arg1 = (XmlContainer *) 0 ;
  XmlIndexSpecification *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(XmlContainer **)&jarg1; 
  
  if (!jarg1) {
    jenv->Throw((jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INVALID_VALUE,
        jenv->NewStringUTF("null object - call after object destroyed?"),
        0, 0, 0, 0));					
    return 0;
  }
  
  {
    jthrowable t = NULL;
    try {
      result = (XmlIndexSpecification *)XmlContainer_getIndexSpecification__SWIG_0((XmlContainer const *)arg1);
    }
    catch (std::exception &se) {
      t = createException(jenv, &se);
      jenv->Throw(t);
      return 0;
    }
    catch(JavaException & /* je */) {
      // This means there's already an exception waiting in the JVM
      return 0;
    }
    catch (...) {
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("Uncaught exception from C++ API"), 0, 0, 0, 0);
      jenv->Throw(t);
      return 0;
    }
  }
  *(XmlIndexSpecification **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_sleepycat_dbxml_dbxml_1javaJNI_XmlContainer_1getIndexSpecification_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  jlong jresult = 0 ;
  XmlContainer *arg1 = (XmlContainer *) 0 ;
  XmlTransaction *arg2 = 0 ;
  XmlIndexSpecification *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(XmlContainer **)&jarg1; 
  arg2 = *(XmlTransaction **)&jarg2;
  if(!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "XmlTransaction & reference is null");
    return 0;
  } 
  
  if (!jarg1) {
    jenv->Throw((jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INVALID_VALUE,
        jenv->NewStringUTF("null object - call after object destroyed?"),
        0, 0, 0, 0));					
    return 0;
  }
  
  {
    jthrowable t = NULL;
    try {
      result = (XmlIndexSpecification *)XmlContainer_getIndexSpecification__SWIG_1((XmlContainer const *)arg1,*arg2);
    }
    catch (std::exception &se) {
      t = createException(jenv, &se);
      jenv->Throw(t);
      return 0;
    }
    catch(JavaException & /* je */) {
      // This means there's already an exception waiting in the JVM
      return 0;
    }
    catch (...) {
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("Uncaught exception from C++ API"), 0, 0, 0, 0);
      jenv->Throw(t);
      return 0;
    }
  }
  *(XmlIndexSpecification **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_sleepycat_dbxml_dbxml_1javaJNI_XmlContainer_1getIndexSpecification_1_1SWIG_12(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_, jint jarg3) {
  jlong jresult = 0 ;
  XmlContainer *arg1 = (XmlContainer *) 0 ;
  XmlTransaction *arg2 = 0 ;
  u_int32_t arg3 ;
  XmlIndexSpecification *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(XmlContainer **)&jarg1; 
  arg2 = *(XmlTransaction **)&jarg2;
  if(!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "XmlTransaction & reference is null");
    return 0;
  } 
  arg3 = (u_int32_t)jarg3; 
  
  if (!jarg1) {
    jenv->Throw((jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INVALID_VALUE,
        jenv->NewStringUTF("null object - call after object destroyed?"),
        0, 0, 0, 0));					
    return 0;
  }
  
  {
    jthrowable t = NULL;
    try {
      result = (XmlIndexSpecification *)XmlContainer_getIndexSpecification__SWIG_2((XmlContainer const *)arg1,*arg2,arg3);
    }
    catch (std::exception &se) {
      t = createException(jenv, &se);
      jenv->Throw(t);
      return 0;
    }
    catch(JavaException & /* je */) {
      // This means there's already an exception waiting in the JVM
      return 0;
    }
    catch (...) {
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("Uncaught exception from C++ API"), 0, 0, 0, 0);
      jenv->Throw(t);
      return 0;
    }
  }
  *(XmlIndexSpecification **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_sleepycat_dbxml_dbxml_1javaJNI_XmlContainer_1getAllDocuments_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  jlong jresult = 0 ;
  XmlContainer *arg1 = (XmlContainer *) 0 ;
  u_int32_t arg2 ;
  XmlResults *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(XmlContainer **)&jarg1; 
  arg2 = (u_int32_t)jarg2; 
  
  if (!jarg1) {
    jenv->Throw((jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INVALID_VALUE,
        jenv->NewStringUTF("null object - call after object destroyed?"),
        0, 0, 0, 0));					
    return 0;
  }
  
  {
    jthrowable t = NULL;
    try {
      result = (XmlResults *)XmlContainer_getAllDocuments__SWIG_0(arg1,arg2);
    }
    catch (std::exception &se) {
      t = createException(jenv, &se);
      jenv->Throw(t);
      return 0;
    }
    catch(JavaException & /* je */) {
      // This means there's already an exception waiting in the JVM
      return 0;
    }
    catch (...) {
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("Uncaught exception from C++ API"), 0, 0, 0, 0);
      jenv->Throw(t);
      return 0;
    }
  }
  *(XmlResults **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_sleepycat_dbxml_dbxml_1javaJNI_XmlContainer_1getAllDocuments_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_, jint jarg3) {
  jlong jresult = 0 ;
  XmlContainer *arg1 = (XmlContainer *) 0 ;
  XmlTransaction *arg2 = 0 ;
  u_int32_t arg3 ;
  XmlResults *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(XmlContainer **)&jarg1; 
  arg2 = *(XmlTransaction **)&jarg2;
  if(!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "XmlTransaction & reference is null");
    return 0;
  } 
  arg3 = (u_int32_t)jarg3; 
  
  if (!jarg1) {
    jenv->Throw((jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INVALID_VALUE,
        jenv->NewStringUTF("null object - call after object destroyed?"),
        0, 0, 0, 0));					
    return 0;
  }
  
  {
    jthrowable t = NULL;
    try {
      result = (XmlResults *)XmlContainer_getAllDocuments__SWIG_1(arg1,*arg2,arg3);
    }
    catch (std::exception &se) {
      t = createException(jenv, &se);
      jenv->Throw(t);
      return 0;
    }
    catch(JavaException & /* je */) {
      // This means there's already an exception waiting in the JVM
      return 0;
    }
    catch (...) {
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("Uncaught exception from C++ API"), 0, 0, 0, 0);
      jenv->Throw(t);
      return 0;
    }
  }
  *(XmlResults **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_sleepycat_dbxml_dbxml_1javaJNI_XmlContainer_1lookupIndex_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong mgrPtr2, jlong dbgPtr2, jint eval2, jint querySec2, jobjectArray data2, jobject jarg2, jstring jarg3, jstring jarg4, jstring jarg5, jobject jarg6, jint jarg7) {
  jlong jresult = 0 ;
  XmlContainer *arg1 = (XmlContainer *) 0 ;
  XmlQueryContext *arg2 = 0 ;
  std::string *arg3 = 0 ;
  std::string *arg4 = 0 ;
  std::string *arg5 = 0 ;
  XmlValue *arg6 = 0 ;
  u_int32_t arg7 ;
  XmlResults *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(XmlContainer **)&jarg1; 
  
  queryContextRef qcRef(jenv, mgrPtr2, dbgPtr2, eval2, querySec2, data2, jarg2);
  if (qcRef.getQC()->isNull())
  return 0; // exception was thrown
  arg2 = qcRef.getQC();
  
  
  const char *arg3_pstr = "";
  if(jarg3) {
    arg3_pstr = (const char *)jenv->GetStringUTFChars(jarg3, 0);
  }
  if (!arg3_pstr) return 0;
  std::string arg3_str(arg3_pstr);
  arg3 = &arg3_str;
  if (jarg3) {
    jenv->ReleaseStringUTFChars(jarg3, arg3_pstr);
  }
  
  
  const char *arg4_pstr = "";
  if(jarg4) {
    arg4_pstr = (const char *)jenv->GetStringUTFChars(jarg4, 0);
  }
  if (!arg4_pstr) return 0;
  std::string arg4_str(arg4_pstr);
  arg4 = &arg4_str;
  if (jarg4) {
    jenv->ReleaseStringUTFChars(jarg4, arg4_pstr);
  }
  
  
  const char *arg5_pstr = "";
  if(jarg5) {
    arg5_pstr = (const char *)jenv->GetStringUTFChars(jarg5, 0);
  }
  if (!arg5_pstr) return 0;
  std::string arg5_str(arg5_pstr);
  arg5 = &arg5_str;
  if (jarg5) {
    jenv->ReleaseStringUTFChars(jarg5, arg5_pstr);
  }
  
  
  bool valid = true;
  XmlValue val6 = createCPPXmlValue(jenv, jarg6, &valid);
  if (!valid) return 0;
  arg6 = &val6;
  
  arg7 = (u_int32_t)jarg7; 
  
  if (!jarg1) {
    jenv->Throw((jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INVALID_VALUE,
        jenv->NewStringUTF("null object - call after object destroyed?"),
        0, 0, 0, 0));					
    return 0;
  }
  
  {
    jthrowable t = NULL;
    try {
      result = (XmlResults *)XmlContainer_lookupIndex__SWIG_0(arg1,*arg2,(std::string const &)*arg3,(std::string const &)*arg4,(std::string const &)*arg5,(XmlValue const &)*arg6,arg7);
    }
    catch (std::exception &se) {
      t = createException(jenv, &se);
      jenv->Throw(t);
      return 0;
    }
    catch(JavaException & /* je */) {
      // This means there's already an exception waiting in the JVM
      return 0;
    }
    catch (...) {
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("Uncaught exception from C++ API"), 0, 0, 0, 0);
      jenv->Throw(t);
      return 0;
    }
  }
  *(XmlResults **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_sleepycat_dbxml_dbxml_1javaJNI_XmlContainer_1lookupIndex_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong mgrPtr2, jlong dbgPtr2, jint eval2, jint querySec2, jobjectArray data2, jobject jarg2, jstring jarg3, jstring jarg4, jstring jarg5, jobject jarg6) {
  jlong jresult = 0 ;
  XmlContainer *arg1 = (XmlContainer *) 0 ;
  XmlQueryContext *arg2 = 0 ;
  std::string *arg3 = 0 ;
  std::string *arg4 = 0 ;
  std::string *arg5 = 0 ;
  XmlValue *arg6 = 0 ;
  XmlResults *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(XmlContainer **)&jarg1; 
  
  queryContextRef qcRef(jenv, mgrPtr2, dbgPtr2, eval2, querySec2, data2, jarg2);
  if (qcRef.getQC()->isNull())
  return 0; // exception was thrown
  arg2 = qcRef.getQC();
  
  
  const char *arg3_pstr = "";
  if(jarg3) {
    arg3_pstr = (const char *)jenv->GetStringUTFChars(jarg3, 0);
  }
  if (!arg3_pstr) return 0;
  std::string arg3_str(arg3_pstr);
  arg3 = &arg3_str;
  if (jarg3) {
    jenv->ReleaseStringUTFChars(jarg3, arg3_pstr);
  }
  
  
  const char *arg4_pstr = "";
  if(jarg4) {
    arg4_pstr = (const char *)jenv->GetStringUTFChars(jarg4, 0);
  }
  if (!arg4_pstr) return 0;
  std::string arg4_str(arg4_pstr);
  arg4 = &arg4_str;
  if (jarg4) {
    jenv->ReleaseStringUTFChars(jarg4, arg4_pstr);
  }
  
  
  const char *arg5_pstr = "";
  if(jarg5) {
    arg5_pstr = (const char *)jenv->GetStringUTFChars(jarg5, 0);
  }
  if (!arg5_pstr) return 0;
  std::string arg5_str(arg5_pstr);
  arg5 = &arg5_str;
  if (jarg5) {
    jenv->ReleaseStringUTFChars(jarg5, arg5_pstr);
  }
  
  
  bool valid = true;
  XmlValue val6 = createCPPXmlValue(jenv, jarg6, &valid);
  if (!valid) return 0;
  arg6 = &val6;
  
  
  if (!jarg1) {
    jenv->Throw((jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INVALID_VALUE,
        jenv->NewStringUTF("null object - call after object destroyed?"),
        0, 0, 0, 0));					
    return 0;
  }
  
  {
    jthrowable t = NULL;
    try {
      result = (XmlResults *)XmlContainer_lookupIndex__SWIG_0(arg1,*arg2,(std::string const &)*arg3,(std::string const &)*arg4,(std::string const &)*arg5,(XmlValue const &)*arg6);
    }
    catch (std::exception &se) {
      t = createException(jenv, &se);
      jenv->Throw(t);
      return 0;
    }
    catch(JavaException & /* je */) {
      // This means there's already an exception waiting in the JVM
      return 0;
    }
    catch (...) {
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("Uncaught exception from C++ API"), 0, 0, 0, 0);
      jenv->Throw(t);
      return 0;
    }
  }
  *(XmlResults **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_sleepycat_dbxml_dbxml_1javaJNI_XmlContainer_1lookupIndex_1_1SWIG_12(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong mgrPtr2, jlong dbgPtr2, jint eval2, jint querySec2, jobjectArray data2, jobject jarg2, jstring jarg3, jstring jarg4, jstring jarg5) {
  jlong jresult = 0 ;
  XmlContainer *arg1 = (XmlContainer *) 0 ;
  XmlQueryContext *arg2 = 0 ;
  std::string *arg3 = 0 ;
  std::string *arg4 = 0 ;
  std::string *arg5 = 0 ;
  XmlResults *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(XmlContainer **)&jarg1; 
  
  queryContextRef qcRef(jenv, mgrPtr2, dbgPtr2, eval2, querySec2, data2, jarg2);
  if (qcRef.getQC()->isNull())
  return 0; // exception was thrown
  arg2 = qcRef.getQC();
  
  
  const char *arg3_pstr = "";
  if(jarg3) {
    arg3_pstr = (const char *)jenv->GetStringUTFChars(jarg3, 0);
  }
  if (!arg3_pstr) return 0;
  std::string arg3_str(arg3_pstr);
  arg3 = &arg3_str;
  if (jarg3) {
    jenv->ReleaseStringUTFChars(jarg3, arg3_pstr);
  }
  
  
  const char *arg4_pstr = "";
  if(jarg4) {
    arg4_pstr = (const char *)jenv->GetStringUTFChars(jarg4, 0);
  }
  if (!arg4_pstr) return 0;
  std::string arg4_str(arg4_pstr);
  arg4 = &arg4_str;
  if (jarg4) {
    jenv->ReleaseStringUTFChars(jarg4, arg4_pstr);
  }
  
  
  const char *arg5_pstr = "";
  if(jarg5) {
    arg5_pstr = (const char *)jenv->GetStringUTFChars(jarg5, 0);
  }
  if (!arg5_pstr) return 0;
  std::string arg5_str(arg5_pstr);
  arg5 = &arg5_str;
  if (jarg5) {
    jenv->ReleaseStringUTFChars(jarg5, arg5_pstr);
  }
  
  
  if (!jarg1) {
    jenv->Throw((jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INVALID_VALUE,
        jenv->NewStringUTF("null object - call after object destroyed?"),
        0, 0, 0, 0));					
    return 0;
  }
  
  {
    jthrowable t = NULL;
    try {
      result = (XmlResults *)XmlContainer_lookupIndex__SWIG_0(arg1,*arg2,(std::string const &)*arg3,(std::string const &)*arg4,(std::string const &)*arg5);
    }
    catch (std::exception &se) {
      t = createException(jenv, &se);
      jenv->Throw(t);
      return 0;
    }
    catch(JavaException & /* je */) {
      // This means there's already an exception waiting in the JVM
      return 0;
    }
    catch (...) {
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("Uncaught exception from C++ API"), 0, 0, 0, 0);
      jenv->Throw(t);
      return 0;
    }
  }
  *(XmlResults **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_sleepycat_dbxml_dbxml_1javaJNI_XmlContainer_1lookupIndex_1_1SWIG_13(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong mgrPtr2, jlong dbgPtr2, jint eval2, jint querySec2, jobjectArray data2, jobject jarg2, jstring jarg3, jstring jarg4, jstring jarg5, jstring jarg6, jstring jarg7, jobject jarg8, jint jarg9) {
  jlong jresult = 0 ;
  XmlContainer *arg1 = (XmlContainer *) 0 ;
  XmlQueryContext *arg2 = 0 ;
  std::string *arg3 = 0 ;
  std::string *arg4 = 0 ;
  std::string *arg5 = 0 ;
  std::string *arg6 = 0 ;
  std::string *arg7 = 0 ;
  XmlValue *arg8 = 0 ;
  u_int32_t arg9 ;
  XmlResults *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(XmlContainer **)&jarg1; 
  
  queryContextRef qcRef(jenv, mgrPtr2, dbgPtr2, eval2, querySec2, data2, jarg2);
  if (qcRef.getQC()->isNull())
  return 0; // exception was thrown
  arg2 = qcRef.getQC();
  
  
  const char *arg3_pstr = "";
  if(jarg3) {
    arg3_pstr = (const char *)jenv->GetStringUTFChars(jarg3, 0);
  }
  if (!arg3_pstr) return 0;
  std::string arg3_str(arg3_pstr);
  arg3 = &arg3_str;
  if (jarg3) {
    jenv->ReleaseStringUTFChars(jarg3, arg3_pstr);
  }
  
  
  const char *arg4_pstr = "";
  if(jarg4) {
    arg4_pstr = (const char *)jenv->GetStringUTFChars(jarg4, 0);
  }
  if (!arg4_pstr) return 0;
  std::string arg4_str(arg4_pstr);
  arg4 = &arg4_str;
  if (jarg4) {
    jenv->ReleaseStringUTFChars(jarg4, arg4_pstr);
  }
  
  
  const char *arg5_pstr = "";
  if(jarg5) {
    arg5_pstr = (const char *)jenv->GetStringUTFChars(jarg5, 0);
  }
  if (!arg5_pstr) return 0;
  std::string arg5_str(arg5_pstr);
  arg5 = &arg5_str;
  if (jarg5) {
    jenv->ReleaseStringUTFChars(jarg5, arg5_pstr);
  }
  
  
  const char *arg6_pstr = "";
  if(jarg6) {
    arg6_pstr = (const char *)jenv->GetStringUTFChars(jarg6, 0);
  }
  if (!arg6_pstr) return 0;
  std::string arg6_str(arg6_pstr);
  arg6 = &arg6_str;
  if (jarg6) {
    jenv->ReleaseStringUTFChars(jarg6, arg6_pstr);
  }
  
  
  const char *arg7_pstr = "";
  if(jarg7) {
    arg7_pstr = (const char *)jenv->GetStringUTFChars(jarg7, 0);
  }
  if (!arg7_pstr) return 0;
  std::string arg7_str(arg7_pstr);
  arg7 = &arg7_str;
  if (jarg7) {
    jenv->ReleaseStringUTFChars(jarg7, arg7_pstr);
  }
  
  
  bool valid = true;
  XmlValue val8 = createCPPXmlValue(jenv, jarg8, &valid);
  if (!valid) return 0;
  arg8 = &val8;
  
  arg9 = (u_int32_t)jarg9; 
  
  if (!jarg1) {
    jenv->Throw((jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INVALID_VALUE,
        jenv->NewStringUTF("null object - call after object destroyed?"),
        0, 0, 0, 0));					
    return 0;
  }
  
  {
    jthrowable t = NULL;
    try {
      result = (XmlResults *)XmlContainer_lookupIndex__SWIG_3(arg1,*arg2,(std::string const &)*arg3,(std::string const &)*arg4,(std::string const &)*arg5,(std::string const &)*arg6,(std::string const &)*arg7,(XmlValue const &)*arg8,arg9);
    }
    catch (std::exception &se) {
      t = createException(jenv, &se);
      jenv->Throw(t);
      return 0;
    }
    catch(JavaException & /* je */) {
      // This means there's already an exception waiting in the JVM
      return 0;
    }
    catch (...) {
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("Uncaught exception from C++ API"), 0, 0, 0, 0);
      jenv->Throw(t);
      return 0;
    }
  }
  *(XmlResults **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_sleepycat_dbxml_dbxml_1javaJNI_XmlContainer_1lookupIndex_1_1SWIG_14(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong mgrPtr2, jlong dbgPtr2, jint eval2, jint querySec2, jobjectArray data2, jobject jarg2, jstring jarg3, jstring jarg4, jstring jarg5, jstring jarg6, jstring jarg7, jobject jarg8) {
  jlong jresult = 0 ;
  XmlContainer *arg1 = (XmlContainer *) 0 ;
  XmlQueryContext *arg2 = 0 ;
  std::string *arg3 = 0 ;
  std::string *arg4 = 0 ;
  std::string *arg5 = 0 ;
  std::string *arg6 = 0 ;
  std::string *arg7 = 0 ;
  XmlValue *arg8 = 0 ;
  XmlResults *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(XmlContainer **)&jarg1; 
  
  queryContextRef qcRef(jenv, mgrPtr2, dbgPtr2, eval2, querySec2, data2, jarg2);
  if (qcRef.getQC()->isNull())
  return 0; // exception was thrown
  arg2 = qcRef.getQC();
  
  
  const char *arg3_pstr = "";
  if(jarg3) {
    arg3_pstr = (const char *)jenv->GetStringUTFChars(jarg3, 0);
  }
  if (!arg3_pstr) return 0;
  std::string arg3_str(arg3_pstr);
  arg3 = &arg3_str;
  if (jarg3) {
    jenv->ReleaseStringUTFChars(jarg3, arg3_pstr);
  }
  
  
  const char *arg4_pstr = "";
  if(jarg4) {
    arg4_pstr = (const char *)jenv->GetStringUTFChars(jarg4, 0);
  }
  if (!arg4_pstr) return 0;
  std::string arg4_str(arg4_pstr);
  arg4 = &arg4_str;
  if (jarg4) {
    jenv->ReleaseStringUTFChars(jarg4, arg4_pstr);
  }
  
  
  const char *arg5_pstr = "";
  if(jarg5) {
    arg5_pstr = (const char *)jenv->GetStringUTFChars(jarg5, 0);
  }
  if (!arg5_pstr) return 0;
  std::string arg5_str(arg5_pstr);
  arg5 = &arg5_str;
  if (jarg5) {
    jenv->ReleaseStringUTFChars(jarg5, arg5_pstr);
  }
  
  
  const char *arg6_pstr = "";
  if(jarg6) {
    arg6_pstr = (const char *)jenv->GetStringUTFChars(jarg6, 0);
  }
  if (!arg6_pstr) return 0;
  std::string arg6_str(arg6_pstr);
  arg6 = &arg6_str;
  if (jarg6) {
    jenv->ReleaseStringUTFChars(jarg6, arg6_pstr);
  }
  
  
  const char *arg7_pstr = "";
  if(jarg7) {
    arg7_pstr = (const char *)jenv->GetStringUTFChars(jarg7, 0);
  }
  if (!arg7_pstr) return 0;
  std::string arg7_str(arg7_pstr);
  arg7 = &arg7_str;
  if (jarg7) {
    jenv->ReleaseStringUTFChars(jarg7, arg7_pstr);
  }
  
  
  bool valid = true;
  XmlValue val8 = createCPPXmlValue(jenv, jarg8, &valid);
  if (!valid) return 0;
  arg8 = &val8;
  
  
  if (!jarg1) {
    jenv->Throw((jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INVALID_VALUE,
        jenv->NewStringUTF("null object - call after object destroyed?"),
        0, 0, 0, 0));					
    return 0;
  }
  
  {
    jthrowable t = NULL;
    try {
      result = (XmlResults *)XmlContainer_lookupIndex__SWIG_3(arg1,*arg2,(std::string const &)*arg3,(std::string const &)*arg4,(std::string const &)*arg5,(std::string const &)*arg6,(std::string const &)*arg7,(XmlValue const &)*arg8);
    }
    catch (std::exception &se) {
      t = createException(jenv, &se);
      jenv->Throw(t);
      return 0;
    }
    catch(JavaException & /* je */) {
      // This means there's already an exception waiting in the JVM
      return 0;
    }
    catch (...) {
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("Uncaught exception from C++ API"), 0, 0, 0, 0);
      jenv->Throw(t);
      return 0;
    }
  }
  *(XmlResults **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_sleepycat_dbxml_dbxml_1javaJNI_XmlContainer_1lookupIndex_1_1SWIG_15(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong mgrPtr2, jlong dbgPtr2, jint eval2, jint querySec2, jobjectArray data2, jobject jarg2, jstring jarg3, jstring jarg4, jstring jarg5, jstring jarg6, jstring jarg7) {
  jlong jresult = 0 ;
  XmlContainer *arg1 = (XmlContainer *) 0 ;
  XmlQueryContext *arg2 = 0 ;
  std::string *arg3 = 0 ;
  std::string *arg4 = 0 ;
  std::string *arg5 = 0 ;
  std::string *arg6 = 0 ;
  std::string *arg7 = 0 ;
  XmlResults *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(XmlContainer **)&jarg1; 
  
  queryContextRef qcRef(jenv, mgrPtr2, dbgPtr2, eval2, querySec2, data2, jarg2);
  if (qcRef.getQC()->isNull())
  return 0; // exception was thrown
  arg2 = qcRef.getQC();
  
  
  const char *arg3_pstr = "";
  if(jarg3) {
    arg3_pstr = (const char *)jenv->GetStringUTFChars(jarg3, 0);
  }
  if (!arg3_pstr) return 0;
  std::string arg3_str(arg3_pstr);
  arg3 = &arg3_str;
  if (jarg3) {
    jenv->ReleaseStringUTFChars(jarg3, arg3_pstr);
  }
  
  
  const char *arg4_pstr = "";
  if(jarg4) {
    arg4_pstr = (const char *)jenv->GetStringUTFChars(jarg4, 0);
  }
  if (!arg4_pstr) return 0;
  std::string arg4_str(arg4_pstr);
  arg4 = &arg4_str;
  if (jarg4) {
    jenv->ReleaseStringUTFChars(jarg4, arg4_pstr);
  }
  
  
  const char *arg5_pstr = "";
  if(jarg5) {
    arg5_pstr = (const char *)jenv->GetStringUTFChars(jarg5, 0);
  }
  if (!arg5_pstr) return 0;
  std::string arg5_str(arg5_pstr);
  arg5 = &arg5_str;
  if (jarg5) {
    jenv->ReleaseStringUTFChars(jarg5, arg5_pstr);
  }
  
  
  const char *arg6_pstr = "";
  if(jarg6) {
    arg6_pstr = (const char *)jenv->GetStringUTFChars(jarg6, 0);
  }
  if (!arg6_pstr) return 0;
  std::string arg6_str(arg6_pstr);
  arg6 = &arg6_str;
  if (jarg6) {
    jenv->ReleaseStringUTFChars(jarg6, arg6_pstr);
  }
  
  
  const char *arg7_pstr = "";
  if(jarg7) {
    arg7_pstr = (const char *)jenv->GetStringUTFChars(jarg7, 0);
  }
  if (!arg7_pstr) return 0;
  std::string arg7_str(arg7_pstr);
  arg7 = &arg7_str;
  if (jarg7) {
    jenv->ReleaseStringUTFChars(jarg7, arg7_pstr);
  }
  
  
  if (!jarg1) {
    jenv->Throw((jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INVALID_VALUE,
        jenv->NewStringUTF("null object - call after object destroyed?"),
        0, 0, 0, 0));					
    return 0;
  }
  
  {
    jthrowable t = NULL;
    try {
      result = (XmlResults *)XmlContainer_lookupIndex__SWIG_3(arg1,*arg2,(std::string const &)*arg3,(std::string const &)*arg4,(std::string const &)*arg5,(std::string const &)*arg6,(std::string const &)*arg7);
    }
    catch (std::exception &se) {
      t = createException(jenv, &se);
      jenv->Throw(t);
      return 0;
    }
    catch(JavaException & /* je */) {
      // This means there's already an exception waiting in the JVM
      return 0;
    }
    catch (...) {
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("Uncaught exception from C++ API"), 0, 0, 0, 0);
      jenv->Throw(t);
      return 0;
    }
  }
  *(XmlResults **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_sleepycat_dbxml_dbxml_1javaJNI_XmlContainer_1lookupIndex_1_1SWIG_16(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_, jlong mgrPtr3, jlong dbgPtr3, jint eval3, jint querySec3, jobjectArray data3, jobject jarg3, jstring jarg4, jstring jarg5, jstring jarg6, jobject jarg7, jint jarg8) {
  jlong jresult = 0 ;
  XmlContainer *arg1 = (XmlContainer *) 0 ;
  XmlTransaction *arg2 = 0 ;
  XmlQueryContext *arg3 = 0 ;
  std::string *arg4 = 0 ;
  std::string *arg5 = 0 ;
  std::string *arg6 = 0 ;
  XmlValue *arg7 = 0 ;
  u_int32_t arg8 ;
  XmlResults *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(XmlContainer **)&jarg1; 
  arg2 = *(XmlTransaction **)&jarg2;
  if(!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "XmlTransaction & reference is null");
    return 0;
  } 
  
  queryContextRef qcRef(jenv, mgrPtr3, dbgPtr3, eval3, querySec3, data3, jarg3);
  if (qcRef.getQC()->isNull())
  return 0; // exception was thrown
  arg3 = qcRef.getQC();
  
  
  const char *arg4_pstr = "";
  if(jarg4) {
    arg4_pstr = (const char *)jenv->GetStringUTFChars(jarg4, 0);
  }
  if (!arg4_pstr) return 0;
  std::string arg4_str(arg4_pstr);
  arg4 = &arg4_str;
  if (jarg4) {
    jenv->ReleaseStringUTFChars(jarg4, arg4_pstr);
  }
  
  
  const char *arg5_pstr = "";
  if(jarg5) {
    arg5_pstr = (const char *)jenv->GetStringUTFChars(jarg5, 0);
  }
  if (!arg5_pstr) return 0;
  std::string arg5_str(arg5_pstr);
  arg5 = &arg5_str;
  if (jarg5) {
    jenv->ReleaseStringUTFChars(jarg5, arg5_pstr);
  }
  
  
  const char *arg6_pstr = "";
  if(jarg6) {
    arg6_pstr = (const char *)jenv->GetStringUTFChars(jarg6, 0);
  }
  if (!arg6_pstr) return 0;
  std::string arg6_str(arg6_pstr);
  arg6 = &arg6_str;
  if (jarg6) {
    jenv->ReleaseStringUTFChars(jarg6, arg6_pstr);
  }
  
  
  bool valid = true;
  XmlValue val7 = createCPPXmlValue(jenv, jarg7, &valid);
  if (!valid) return 0;
  arg7 = &val7;
  
  arg8 = (u_int32_t)jarg8; 
  
  if (!jarg1) {
    jenv->Throw((jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INVALID_VALUE,
        jenv->NewStringUTF("null object - call after object destroyed?"),
        0, 0, 0, 0));					
    return 0;
  }
  
  {
    jthrowable t = NULL;
    try {
      result = (XmlResults *)XmlContainer_lookupIndex__SWIG_6(arg1,*arg2,*arg3,(std::string const &)*arg4,(std::string const &)*arg5,(std::string const &)*arg6,(XmlValue const &)*arg7,arg8);
    }
    catch (std::exception &se) {
      t = createException(jenv, &se);
      jenv->Throw(t);
      return 0;
    }
    catch(JavaException & /* je */) {
      // This means there's already an exception waiting in the JVM
      return 0;
    }
    catch (...) {
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("Uncaught exception from C++ API"), 0, 0, 0, 0);
      jenv->Throw(t);
      return 0;
    }
  }
  *(XmlResults **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_sleepycat_dbxml_dbxml_1javaJNI_XmlContainer_1lookupIndex_1_1SWIG_17(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_, jlong mgrPtr3, jlong dbgPtr3, jint eval3, jint querySec3, jobjectArray data3, jobject jarg3, jstring jarg4, jstring jarg5, jstring jarg6, jobject jarg7) {
  jlong jresult = 0 ;
  XmlContainer *arg1 = (XmlContainer *) 0 ;
  XmlTransaction *arg2 = 0 ;
  XmlQueryContext *arg3 = 0 ;
  std::string *arg4 = 0 ;
  std::string *arg5 = 0 ;
  std::string *arg6 = 0 ;
  XmlValue *arg7 = 0 ;
  XmlResults *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(XmlContainer **)&jarg1; 
  arg2 = *(XmlTransaction **)&jarg2;
  if(!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "XmlTransaction & reference is null");
    return 0;
  } 
  
  queryContextRef qcRef(jenv, mgrPtr3, dbgPtr3, eval3, querySec3, data3, jarg3);
  if (qcRef.getQC()->isNull())
  return 0; // exception was thrown
  arg3 = qcRef.getQC();
  
  
  const char *arg4_pstr = "";
  if(jarg4) {
    arg4_pstr = (const char *)jenv->GetStringUTFChars(jarg4, 0);
  }
  if (!arg4_pstr) return 0;
  std::string arg4_str(arg4_pstr);
  arg4 = &arg4_str;
  if (jarg4) {
    jenv->ReleaseStringUTFChars(jarg4, arg4_pstr);
  }
  
  
  const char *arg5_pstr = "";
  if(jarg5) {
    arg5_pstr = (const char *)jenv->GetStringUTFChars(jarg5, 0);
  }
  if (!arg5_pstr) return 0;
  std::string arg5_str(arg5_pstr);
  arg5 = &arg5_str;
  if (jarg5) {
    jenv->ReleaseStringUTFChars(jarg5, arg5_pstr);
  }
  
  
  const char *arg6_pstr = "";
  if(jarg6) {
    arg6_pstr = (const char *)jenv->GetStringUTFChars(jarg6, 0);
  }
  if (!arg6_pstr) return 0;
  std::string arg6_str(arg6_pstr);
  arg6 = &arg6_str;
  if (jarg6) {
    jenv->ReleaseStringUTFChars(jarg6, arg6_pstr);
  }
  
  
  bool valid = true;
  XmlValue val7 = createCPPXmlValue(jenv, jarg7, &valid);
  if (!valid) return 0;
  arg7 = &val7;
  
  
  if (!jarg1) {
    jenv->Throw((jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INVALID_VALUE,
        jenv->NewStringUTF("null object - call after object destroyed?"),
        0, 0, 0, 0));					
    return 0;
  }
  
  {
    jthrowable t = NULL;
    try {
      result = (XmlResults *)XmlContainer_lookupIndex__SWIG_6(arg1,*arg2,*arg3,(std::string const &)*arg4,(std::string const &)*arg5,(std::string const &)*arg6,(XmlValue const &)*arg7);
    }
    catch (std::exception &se) {
      t = createException(jenv, &se);
      jenv->Throw(t);
      return 0;
    }
    catch(JavaException & /* je */) {
      // This means there's already an exception waiting in the JVM
      return 0;
    }
    catch (...) {
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("Uncaught exception from C++ API"), 0, 0, 0, 0);
      jenv->Throw(t);
      return 0;
    }
  }
  *(XmlResults **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_sleepycat_dbxml_dbxml_1javaJNI_XmlContainer_1lookupIndex_1_1SWIG_18(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_, jlong mgrPtr3, jlong dbgPtr3, jint eval3, jint querySec3, jobjectArray data3, jobject jarg3, jstring jarg4, jstring jarg5, jstring jarg6) {
  jlong jresult = 0 ;
  XmlContainer *arg1 = (XmlContainer *) 0 ;
  XmlTransaction *arg2 = 0 ;
  XmlQueryContext *arg3 = 0 ;
  std::string *arg4 = 0 ;
  std::string *arg5 = 0 ;
  std::string *arg6 = 0 ;
  XmlResults *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(XmlContainer **)&jarg1; 
  arg2 = *(XmlTransaction **)&jarg2;
  if(!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "XmlTransaction & reference is null");
    return 0;
  } 
  
  queryContextRef qcRef(jenv, mgrPtr3, dbgPtr3, eval3, querySec3, data3, jarg3);
  if (qcRef.getQC()->isNull())
  return 0; // exception was thrown
  arg3 = qcRef.getQC();
  
  
  const char *arg4_pstr = "";
  if(jarg4) {
    arg4_pstr = (const char *)jenv->GetStringUTFChars(jarg4, 0);
  }
  if (!arg4_pstr) return 0;
  std::string arg4_str(arg4_pstr);
  arg4 = &arg4_str;
  if (jarg4) {
    jenv->ReleaseStringUTFChars(jarg4, arg4_pstr);
  }
  
  
  const char *arg5_pstr = "";
  if(jarg5) {
    arg5_pstr = (const char *)jenv->GetStringUTFChars(jarg5, 0);
  }
  if (!arg5_pstr) return 0;
  std::string arg5_str(arg5_pstr);
  arg5 = &arg5_str;
  if (jarg5) {
    jenv->ReleaseStringUTFChars(jarg5, arg5_pstr);
  }
  
  
  const char *arg6_pstr = "";
  if(jarg6) {
    arg6_pstr = (const char *)jenv->GetStringUTFChars(jarg6, 0);
  }
  if (!arg6_pstr) return 0;
  std::string arg6_str(arg6_pstr);
  arg6 = &arg6_str;
  if (jarg6) {
    jenv->ReleaseStringUTFChars(jarg6, arg6_pstr);
  }
  
  
  if (!jarg1) {
    jenv->Throw((jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INVALID_VALUE,
        jenv->NewStringUTF("null object - call after object destroyed?"),
        0, 0, 0, 0));					
    return 0;
  }
  
  {
    jthrowable t = NULL;
    try {
      result = (XmlResults *)XmlContainer_lookupIndex__SWIG_6(arg1,*arg2,*arg3,(std::string const &)*arg4,(std::string const &)*arg5,(std::string const &)*arg6);
    }
    catch (std::exception &se) {
      t = createException(jenv, &se);
      jenv->Throw(t);
      return 0;
    }
    catch(JavaException & /* je */) {
      // This means there's already an exception waiting in the JVM
      return 0;
    }
    catch (...) {
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("Uncaught exception from C++ API"), 0, 0, 0, 0);
      jenv->Throw(t);
      return 0;
    }
  }
  *(XmlResults **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_sleepycat_dbxml_dbxml_1javaJNI_XmlContainer_1lookupIndex_1_1SWIG_19(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_, jlong mgrPtr3, jlong dbgPtr3, jint eval3, jint querySec3, jobjectArray data3, jobject jarg3, jstring jarg4, jstring jarg5, jstring jarg6, jstring jarg7, jstring jarg8, jobject jarg9, jint jarg10) {
  jlong jresult = 0 ;
  XmlContainer *arg1 = (XmlContainer *) 0 ;
  XmlTransaction *arg2 = 0 ;
  XmlQueryContext *arg3 = 0 ;
  std::string *arg4 = 0 ;
  std::string *arg5 = 0 ;
  std::string *arg6 = 0 ;
  std::string *arg7 = 0 ;
  std::string *arg8 = 0 ;
  XmlValue *arg9 = 0 ;
  u_int32_t arg10 ;
  XmlResults *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(XmlContainer **)&jarg1; 
  arg2 = *(XmlTransaction **)&jarg2;
  if(!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "XmlTransaction & reference is null");
    return 0;
  } 
  
  queryContextRef qcRef(jenv, mgrPtr3, dbgPtr3, eval3, querySec3, data3, jarg3);
  if (qcRef.getQC()->isNull())
  return 0; // exception was thrown
  arg3 = qcRef.getQC();
  
  
  const char *arg4_pstr = "";
  if(jarg4) {
    arg4_pstr = (const char *)jenv->GetStringUTFChars(jarg4, 0);
  }
  if (!arg4_pstr) return 0;
  std::string arg4_str(arg4_pstr);
  arg4 = &arg4_str;
  if (jarg4) {
    jenv->ReleaseStringUTFChars(jarg4, arg4_pstr);
  }
  
  
  const char *arg5_pstr = "";
  if(jarg5) {
    arg5_pstr = (const char *)jenv->GetStringUTFChars(jarg5, 0);
  }
  if (!arg5_pstr) return 0;
  std::string arg5_str(arg5_pstr);
  arg5 = &arg5_str;
  if (jarg5) {
    jenv->ReleaseStringUTFChars(jarg5, arg5_pstr);
  }
  
  
  const char *arg6_pstr = "";
  if(jarg6) {
    arg6_pstr = (const char *)jenv->GetStringUTFChars(jarg6, 0);
  }
  if (!arg6_pstr) return 0;
  std::string arg6_str(arg6_pstr);
  arg6 = &arg6_str;
  if (jarg6) {
    jenv->ReleaseStringUTFChars(jarg6, arg6_pstr);
  }
  
  
  const char *arg7_pstr = "";
  if(jarg7) {
    arg7_pstr = (const char *)jenv->GetStringUTFChars(jarg7, 0);
  }
  if (!arg7_pstr) return 0;
  std::string arg7_str(arg7_pstr);
  arg7 = &arg7_str;
  if (jarg7) {
    jenv->ReleaseStringUTFChars(jarg7, arg7_pstr);
  }
  
  
  const char *arg8_pstr = "";
  if(jarg8) {
    arg8_pstr = (const char *)jenv->GetStringUTFChars(jarg8, 0);
  }
  if (!arg8_pstr) return 0;
  std::string arg8_str(arg8_pstr);
  arg8 = &arg8_str;
  if (jarg8) {
    jenv->ReleaseStringUTFChars(jarg8, arg8_pstr);
  }
  
  
  bool valid = true;
  XmlValue val9 = createCPPXmlValue(jenv, jarg9, &valid);
  if (!valid) return 0;
  arg9 = &val9;
  
  arg10 = (u_int32_t)jarg10; 
  
  if (!jarg1) {
    jenv->Throw((jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INVALID_VALUE,
        jenv->NewStringUTF("null object - call after object destroyed?"),
        0, 0, 0, 0));					
    return 0;
  }
  
  {
    jthrowable t = NULL;
    try {
      result = (XmlResults *)XmlContainer_lookupIndex__SWIG_9(arg1,*arg2,*arg3,(std::string const &)*arg4,(std::string const &)*arg5,(std::string const &)*arg6,(std::string const &)*arg7,(std::string const &)*arg8,(XmlValue const &)*arg9,arg10);
    }
    catch (std::exception &se) {
      t = createException(jenv, &se);
      jenv->Throw(t);
      return 0;
    }
    catch(JavaException & /* je */) {
      // This means there's already an exception waiting in the JVM
      return 0;
    }
    catch (...) {
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("Uncaught exception from C++ API"), 0, 0, 0, 0);
      jenv->Throw(t);
      return 0;
    }
  }
  *(XmlResults **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_sleepycat_dbxml_dbxml_1javaJNI_XmlContainer_1lookupIndex_1_1SWIG_110(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_, jlong mgrPtr3, jlong dbgPtr3, jint eval3, jint querySec3, jobjectArray data3, jobject jarg3, jstring jarg4, jstring jarg5, jstring jarg6, jstring jarg7, jstring jarg8, jobject jarg9) {
  jlong jresult = 0 ;
  XmlContainer *arg1 = (XmlContainer *) 0 ;
  XmlTransaction *arg2 = 0 ;
  XmlQueryContext *arg3 = 0 ;
  std::string *arg4 = 0 ;
  std::string *arg5 = 0 ;
  std::string *arg6 = 0 ;
  std::string *arg7 = 0 ;
  std::string *arg8 = 0 ;
  XmlValue *arg9 = 0 ;
  XmlResults *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(XmlContainer **)&jarg1; 
  arg2 = *(XmlTransaction **)&jarg2;
  if(!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "XmlTransaction & reference is null");
    return 0;
  } 
  
  queryContextRef qcRef(jenv, mgrPtr3, dbgPtr3, eval3, querySec3, data3, jarg3);
  if (qcRef.getQC()->isNull())
  return 0; // exception was thrown
  arg3 = qcRef.getQC();
  
  
  const char *arg4_pstr = "";
  if(jarg4) {
    arg4_pstr = (const char *)jenv->GetStringUTFChars(jarg4, 0);
  }
  if (!arg4_pstr) return 0;
  std::string arg4_str(arg4_pstr);
  arg4 = &arg4_str;
  if (jarg4) {
    jenv->ReleaseStringUTFChars(jarg4, arg4_pstr);
  }
  
  
  const char *arg5_pstr = "";
  if(jarg5) {
    arg5_pstr = (const char *)jenv->GetStringUTFChars(jarg5, 0);
  }
  if (!arg5_pstr) return 0;
  std::string arg5_str(arg5_pstr);
  arg5 = &arg5_str;
  if (jarg5) {
    jenv->ReleaseStringUTFChars(jarg5, arg5_pstr);
  }
  
  
  const char *arg6_pstr = "";
  if(jarg6) {
    arg6_pstr = (const char *)jenv->GetStringUTFChars(jarg6, 0);
  }
  if (!arg6_pstr) return 0;
  std::string arg6_str(arg6_pstr);
  arg6 = &arg6_str;
  if (jarg6) {
    jenv->ReleaseStringUTFChars(jarg6, arg6_pstr);
  }
  
  
  const char *arg7_pstr = "";
  if(jarg7) {
    arg7_pstr = (const char *)jenv->GetStringUTFChars(jarg7, 0);
  }
  if (!arg7_pstr) return 0;
  std::string arg7_str(arg7_pstr);
  arg7 = &arg7_str;
  if (jarg7) {
    jenv->ReleaseStringUTFChars(jarg7, arg7_pstr);
  }
  
  
  const char *arg8_pstr = "";
  if(jarg8) {
    arg8_pstr = (const char *)jenv->GetStringUTFChars(jarg8, 0);
  }
  if (!arg8_pstr) return 0;
  std::string arg8_str(arg8_pstr);
  arg8 = &arg8_str;
  if (jarg8) {
    jenv->ReleaseStringUTFChars(jarg8, arg8_pstr);
  }
  
  
  bool valid = true;
  XmlValue val9 = createCPPXmlValue(jenv, jarg9, &valid);
  if (!valid) return 0;
  arg9 = &val9;
  
  
  if (!jarg1) {
    jenv->Throw((jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INVALID_VALUE,
        jenv->NewStringUTF("null object - call after object destroyed?"),
        0, 0, 0, 0));					
    return 0;
  }
  
  {
    jthrowable t = NULL;
    try {
      result = (XmlResults *)XmlContainer_lookupIndex__SWIG_9(arg1,*arg2,*arg3,(std::string const &)*arg4,(std::string const &)*arg5,(std::string const &)*arg6,(std::string const &)*arg7,(std::string const &)*arg8,(XmlValue const &)*arg9);
    }
    catch (std::exception &se) {
      t = createException(jenv, &se);
      jenv->Throw(t);
      return 0;
    }
    catch(JavaException & /* je */) {
      // This means there's already an exception waiting in the JVM
      return 0;
    }
    catch (...) {
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("Uncaught exception from C++ API"), 0, 0, 0, 0);
      jenv->Throw(t);
      return 0;
    }
  }
  *(XmlResults **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_sleepycat_dbxml_dbxml_1javaJNI_XmlContainer_1lookupIndex_1_1SWIG_111(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_, jlong mgrPtr3, jlong dbgPtr3, jint eval3, jint querySec3, jobjectArray data3, jobject jarg3, jstring jarg4, jstring jarg5, jstring jarg6, jstring jarg7, jstring jarg8) {
  jlong jresult = 0 ;
  XmlContainer *arg1 = (XmlContainer *) 0 ;
  XmlTransaction *arg2 = 0 ;
  XmlQueryContext *arg3 = 0 ;
  std::string *arg4 = 0 ;
  std::string *arg5 = 0 ;
  std::string *arg6 = 0 ;
  std::string *arg7 = 0 ;
  std::string *arg8 = 0 ;
  XmlResults *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(XmlContainer **)&jarg1; 
  arg2 = *(XmlTransaction **)&jarg2;
  if(!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "XmlTransaction & reference is null");
    return 0;
  } 
  
  queryContextRef qcRef(jenv, mgrPtr3, dbgPtr3, eval3, querySec3, data3, jarg3);
  if (qcRef.getQC()->isNull())
  return 0; // exception was thrown
  arg3 = qcRef.getQC();
  
  
  const char *arg4_pstr = "";
  if(jarg4) {
    arg4_pstr = (const char *)jenv->GetStringUTFChars(jarg4, 0);
  }
  if (!arg4_pstr) return 0;
  std::string arg4_str(arg4_pstr);
  arg4 = &arg4_str;
  if (jarg4) {
    jenv->ReleaseStringUTFChars(jarg4, arg4_pstr);
  }
  
  
  const char *arg5_pstr = "";
  if(jarg5) {
    arg5_pstr = (const char *)jenv->GetStringUTFChars(jarg5, 0);
  }
  if (!arg5_pstr) return 0;
  std::string arg5_str(arg5_pstr);
  arg5 = &arg5_str;
  if (jarg5) {
    jenv->ReleaseStringUTFChars(jarg5, arg5_pstr);
  }
  
  
  const char *arg6_pstr = "";
  if(jarg6) {
    arg6_pstr = (const char *)jenv->GetStringUTFChars(jarg6, 0);
  }
  if (!arg6_pstr) return 0;
  std::string arg6_str(arg6_pstr);
  arg6 = &arg6_str;
  if (jarg6) {
    jenv->ReleaseStringUTFChars(jarg6, arg6_pstr);
  }
  
  
  const char *arg7_pstr = "";
  if(jarg7) {
    arg7_pstr = (const char *)jenv->GetStringUTFChars(jarg7, 0);
  }
  if (!arg7_pstr) return 0;
  std::string arg7_str(arg7_pstr);
  arg7 = &arg7_str;
  if (jarg7) {
    jenv->ReleaseStringUTFChars(jarg7, arg7_pstr);
  }
  
  
  const char *arg8_pstr = "";
  if(jarg8) {
    arg8_pstr = (const char *)jenv->GetStringUTFChars(jarg8, 0);
  }
  if (!arg8_pstr) return 0;
  std::string arg8_str(arg8_pstr);
  arg8 = &arg8_str;
  if (jarg8) {
    jenv->ReleaseStringUTFChars(jarg8, arg8_pstr);
  }
  
  
  if (!jarg1) {
    jenv->Throw((jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INVALID_VALUE,
        jenv->NewStringUTF("null object - call after object destroyed?"),
        0, 0, 0, 0));					
    return 0;
  }
  
  {
    jthrowable t = NULL;
    try {
      result = (XmlResults *)XmlContainer_lookupIndex__SWIG_9(arg1,*arg2,*arg3,(std::string const &)*arg4,(std::string const &)*arg5,(std::string const &)*arg6,(std::string const &)*arg7,(std::string const &)*arg8);
    }
    catch (std::exception &se) {
      t = createException(jenv, &se);
      jenv->Throw(t);
      return 0;
    }
    catch(JavaException & /* je */) {
      // This means there's already an exception waiting in the JVM
      return 0;
    }
    catch (...) {
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("Uncaught exception from C++ API"), 0, 0, 0, 0);
      jenv->Throw(t);
      return 0;
    }
  }
  *(XmlResults **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_sleepycat_dbxml_dbxml_1javaJNI_XmlContainer_1lookupStatistics_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2, jstring jarg3, jstring jarg4, jobject jarg5) {
  jlong jresult = 0 ;
  XmlContainer *arg1 = (XmlContainer *) 0 ;
  std::string *arg2 = 0 ;
  std::string *arg3 = 0 ;
  std::string *arg4 = 0 ;
  XmlValue *arg5 = 0 ;
  XmlStatistics *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(XmlContainer **)&jarg1; 
  
  const char *arg2_pstr = "";
  if(jarg2) {
    arg2_pstr = (const char *)jenv->GetStringUTFChars(jarg2, 0);
  }
  if (!arg2_pstr) return 0;
  std::string arg2_str(arg2_pstr);
  arg2 = &arg2_str;
  if (jarg2) {
    jenv->ReleaseStringUTFChars(jarg2, arg2_pstr);
  }
  
  
  const char *arg3_pstr = "";
  if(jarg3) {
    arg3_pstr = (const char *)jenv->GetStringUTFChars(jarg3, 0);
  }
  if (!arg3_pstr) return 0;
  std::string arg3_str(arg3_pstr);
  arg3 = &arg3_str;
  if (jarg3) {
    jenv->ReleaseStringUTFChars(jarg3, arg3_pstr);
  }
  
  
  const char *arg4_pstr = "";
  if(jarg4) {
    arg4_pstr = (const char *)jenv->GetStringUTFChars(jarg4, 0);
  }
  if (!arg4_pstr) return 0;
  std::string arg4_str(arg4_pstr);
  arg4 = &arg4_str;
  if (jarg4) {
    jenv->ReleaseStringUTFChars(jarg4, arg4_pstr);
  }
  
  
  bool valid = true;
  XmlValue val5 = createCPPXmlValue(jenv, jarg5, &valid);
  if (!valid) return 0;
  arg5 = &val5;
  
  
  if (!jarg1) {
    jenv->Throw((jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INVALID_VALUE,
        jenv->NewStringUTF("null object - call after object destroyed?"),
        0, 0, 0, 0));					
    return 0;
  }
  
  {
    jthrowable t = NULL;
    try {
      result = (XmlStatistics *)XmlContainer_lookupStatistics__SWIG_0(arg1,(std::string const &)*arg2,(std::string const &)*arg3,(std::string const &)*arg4,(XmlValue const &)*arg5);
    }
    catch (std::exception &se) {
      t = createException(jenv, &se);
      jenv->Throw(t);
      return 0;
    }
    catch(JavaException & /* je */) {
      // This means there's already an exception waiting in the JVM
      return 0;
    }
    catch (...) {
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("Uncaught exception from C++ API"), 0, 0, 0, 0);
      jenv->Throw(t);
      return 0;
    }
  }
  *(XmlStatistics **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_sleepycat_dbxml_dbxml_1javaJNI_XmlContainer_1lookupStatistics_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2, jstring jarg3, jstring jarg4) {
  jlong jresult = 0 ;
  XmlContainer *arg1 = (XmlContainer *) 0 ;
  std::string *arg2 = 0 ;
  std::string *arg3 = 0 ;
  std::string *arg4 = 0 ;
  XmlStatistics *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(XmlContainer **)&jarg1; 
  
  const char *arg2_pstr = "";
  if(jarg2) {
    arg2_pstr = (const char *)jenv->GetStringUTFChars(jarg2, 0);
  }
  if (!arg2_pstr) return 0;
  std::string arg2_str(arg2_pstr);
  arg2 = &arg2_str;
  if (jarg2) {
    jenv->ReleaseStringUTFChars(jarg2, arg2_pstr);
  }
  
  
  const char *arg3_pstr = "";
  if(jarg3) {
    arg3_pstr = (const char *)jenv->GetStringUTFChars(jarg3, 0);
  }
  if (!arg3_pstr) return 0;
  std::string arg3_str(arg3_pstr);
  arg3 = &arg3_str;
  if (jarg3) {
    jenv->ReleaseStringUTFChars(jarg3, arg3_pstr);
  }
  
  
  const char *arg4_pstr = "";
  if(jarg4) {
    arg4_pstr = (const char *)jenv->GetStringUTFChars(jarg4, 0);
  }
  if (!arg4_pstr) return 0;
  std::string arg4_str(arg4_pstr);
  arg4 = &arg4_str;
  if (jarg4) {
    jenv->ReleaseStringUTFChars(jarg4, arg4_pstr);
  }
  
  
  if (!jarg1) {
    jenv->Throw((jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INVALID_VALUE,
        jenv->NewStringUTF("null object - call after object destroyed?"),
        0, 0, 0, 0));					
    return 0;
  }
  
  {
    jthrowable t = NULL;
    try {
      result = (XmlStatistics *)XmlContainer_lookupStatistics__SWIG_0(arg1,(std::string const &)*arg2,(std::string const &)*arg3,(std::string const &)*arg4);
    }
    catch (std::exception &se) {
      t = createException(jenv, &se);
      jenv->Throw(t);
      return 0;
    }
    catch(JavaException & /* je */) {
      // This means there's already an exception waiting in the JVM
      return 0;
    }
    catch (...) {
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("Uncaught exception from C++ API"), 0, 0, 0, 0);
      jenv->Throw(t);
      return 0;
    }
  }
  *(XmlStatistics **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_sleepycat_dbxml_dbxml_1javaJNI_XmlContainer_1lookupStatistics_1_1SWIG_12(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2, jstring jarg3, jstring jarg4, jstring jarg5, jstring jarg6, jobject jarg7) {
  jlong jresult = 0 ;
  XmlContainer *arg1 = (XmlContainer *) 0 ;
  std::string *arg2 = 0 ;
  std::string *arg3 = 0 ;
  std::string *arg4 = 0 ;
  std::string *arg5 = 0 ;
  std::string *arg6 = 0 ;
  XmlValue *arg7 = 0 ;
  XmlStatistics *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(XmlContainer **)&jarg1; 
  
  const char *arg2_pstr = "";
  if(jarg2) {
    arg2_pstr = (const char *)jenv->GetStringUTFChars(jarg2, 0);
  }
  if (!arg2_pstr) return 0;
  std::string arg2_str(arg2_pstr);
  arg2 = &arg2_str;
  if (jarg2) {
    jenv->ReleaseStringUTFChars(jarg2, arg2_pstr);
  }
  
  
  const char *arg3_pstr = "";
  if(jarg3) {
    arg3_pstr = (const char *)jenv->GetStringUTFChars(jarg3, 0);
  }
  if (!arg3_pstr) return 0;
  std::string arg3_str(arg3_pstr);
  arg3 = &arg3_str;
  if (jarg3) {
    jenv->ReleaseStringUTFChars(jarg3, arg3_pstr);
  }
  
  
  const char *arg4_pstr = "";
  if(jarg4) {
    arg4_pstr = (const char *)jenv->GetStringUTFChars(jarg4, 0);
  }
  if (!arg4_pstr) return 0;
  std::string arg4_str(arg4_pstr);
  arg4 = &arg4_str;
  if (jarg4) {
    jenv->ReleaseStringUTFChars(jarg4, arg4_pstr);
  }
  
  
  const char *arg5_pstr = "";
  if(jarg5) {
    arg5_pstr = (const char *)jenv->GetStringUTFChars(jarg5, 0);
  }
  if (!arg5_pstr) return 0;
  std::string arg5_str(arg5_pstr);
  arg5 = &arg5_str;
  if (jarg5) {
    jenv->ReleaseStringUTFChars(jarg5, arg5_pstr);
  }
  
  
  const char *arg6_pstr = "";
  if(jarg6) {
    arg6_pstr = (const char *)jenv->GetStringUTFChars(jarg6, 0);
  }
  if (!arg6_pstr) return 0;
  std::string arg6_str(arg6_pstr);
  arg6 = &arg6_str;
  if (jarg6) {
    jenv->ReleaseStringUTFChars(jarg6, arg6_pstr);
  }
  
  
  bool valid = true;
  XmlValue val7 = createCPPXmlValue(jenv, jarg7, &valid);
  if (!valid) return 0;
  arg7 = &val7;
  
  
  if (!jarg1) {
    jenv->Throw((jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INVALID_VALUE,
        jenv->NewStringUTF("null object - call after object destroyed?"),
        0, 0, 0, 0));					
    return 0;
  }
  
  {
    jthrowable t = NULL;
    try {
      result = (XmlStatistics *)XmlContainer_lookupStatistics__SWIG_2(arg1,(std::string const &)*arg2,(std::string const &)*arg3,(std::string const &)*arg4,(std::string const &)*arg5,(std::string const &)*arg6,(XmlValue const &)*arg7);
    }
    catch (std::exception &se) {
      t = createException(jenv, &se);
      jenv->Throw(t);
      return 0;
    }
    catch(JavaException & /* je */) {
      // This means there's already an exception waiting in the JVM
      return 0;
    }
    catch (...) {
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("Uncaught exception from C++ API"), 0, 0, 0, 0);
      jenv->Throw(t);
      return 0;
    }
  }
  *(XmlStatistics **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_sleepycat_dbxml_dbxml_1javaJNI_XmlContainer_1lookupStatistics_1_1SWIG_13(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2, jstring jarg3, jstring jarg4, jstring jarg5, jstring jarg6) {
  jlong jresult = 0 ;
  XmlContainer *arg1 = (XmlContainer *) 0 ;
  std::string *arg2 = 0 ;
  std::string *arg3 = 0 ;
  std::string *arg4 = 0 ;
  std::string *arg5 = 0 ;
  std::string *arg6 = 0 ;
  XmlStatistics *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(XmlContainer **)&jarg1; 
  
  const char *arg2_pstr = "";
  if(jarg2) {
    arg2_pstr = (const char *)jenv->GetStringUTFChars(jarg2, 0);
  }
  if (!arg2_pstr) return 0;
  std::string arg2_str(arg2_pstr);
  arg2 = &arg2_str;
  if (jarg2) {
    jenv->ReleaseStringUTFChars(jarg2, arg2_pstr);
  }
  
  
  const char *arg3_pstr = "";
  if(jarg3) {
    arg3_pstr = (const char *)jenv->GetStringUTFChars(jarg3, 0);
  }
  if (!arg3_pstr) return 0;
  std::string arg3_str(arg3_pstr);
  arg3 = &arg3_str;
  if (jarg3) {
    jenv->ReleaseStringUTFChars(jarg3, arg3_pstr);
  }
  
  
  const char *arg4_pstr = "";
  if(jarg4) {
    arg4_pstr = (const char *)jenv->GetStringUTFChars(jarg4, 0);
  }
  if (!arg4_pstr) return 0;
  std::string arg4_str(arg4_pstr);
  arg4 = &arg4_str;
  if (jarg4) {
    jenv->ReleaseStringUTFChars(jarg4, arg4_pstr);
  }
  
  
  const char *arg5_pstr = "";
  if(jarg5) {
    arg5_pstr = (const char *)jenv->GetStringUTFChars(jarg5, 0);
  }
  if (!arg5_pstr) return 0;
  std::string arg5_str(arg5_pstr);
  arg5 = &arg5_str;
  if (jarg5) {
    jenv->ReleaseStringUTFChars(jarg5, arg5_pstr);
  }
  
  
  const char *arg6_pstr = "";
  if(jarg6) {
    arg6_pstr = (const char *)jenv->GetStringUTFChars(jarg6, 0);
  }
  if (!arg6_pstr) return 0;
  std::string arg6_str(arg6_pstr);
  arg6 = &arg6_str;
  if (jarg6) {
    jenv->ReleaseStringUTFChars(jarg6, arg6_pstr);
  }
  
  
  if (!jarg1) {
    jenv->Throw((jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INVALID_VALUE,
        jenv->NewStringUTF("null object - call after object destroyed?"),
        0, 0, 0, 0));					
    return 0;
  }
  
  {
    jthrowable t = NULL;
    try {
      result = (XmlStatistics *)XmlContainer_lookupStatistics__SWIG_2(arg1,(std::string const &)*arg2,(std::string const &)*arg3,(std::string const &)*arg4,(std::string const &)*arg5,(std::string const &)*arg6);
    }
    catch (std::exception &se) {
      t = createException(jenv, &se);
      jenv->Throw(t);
      return 0;
    }
    catch(JavaException & /* je */) {
      // This means there's already an exception waiting in the JVM
      return 0;
    }
    catch (...) {
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("Uncaught exception from C++ API"), 0, 0, 0, 0);
      jenv->Throw(t);
      return 0;
    }
  }
  *(XmlStatistics **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_sleepycat_dbxml_dbxml_1javaJNI_XmlContainer_1lookupStatistics_1_1SWIG_14(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_, jstring jarg3, jstring jarg4, jstring jarg5, jobject jarg6) {
  jlong jresult = 0 ;
  XmlContainer *arg1 = (XmlContainer *) 0 ;
  XmlTransaction *arg2 = 0 ;
  std::string *arg3 = 0 ;
  std::string *arg4 = 0 ;
  std::string *arg5 = 0 ;
  XmlValue *arg6 = 0 ;
  XmlStatistics *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(XmlContainer **)&jarg1; 
  arg2 = *(XmlTransaction **)&jarg2;
  if(!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "XmlTransaction & reference is null");
    return 0;
  } 
  
  const char *arg3_pstr = "";
  if(jarg3) {
    arg3_pstr = (const char *)jenv->GetStringUTFChars(jarg3, 0);
  }
  if (!arg3_pstr) return 0;
  std::string arg3_str(arg3_pstr);
  arg3 = &arg3_str;
  if (jarg3) {
    jenv->ReleaseStringUTFChars(jarg3, arg3_pstr);
  }
  
  
  const char *arg4_pstr = "";
  if(jarg4) {
    arg4_pstr = (const char *)jenv->GetStringUTFChars(jarg4, 0);
  }
  if (!arg4_pstr) return 0;
  std::string arg4_str(arg4_pstr);
  arg4 = &arg4_str;
  if (jarg4) {
    jenv->ReleaseStringUTFChars(jarg4, arg4_pstr);
  }
  
  
  const char *arg5_pstr = "";
  if(jarg5) {
    arg5_pstr = (const char *)jenv->GetStringUTFChars(jarg5, 0);
  }
  if (!arg5_pstr) return 0;
  std::string arg5_str(arg5_pstr);
  arg5 = &arg5_str;
  if (jarg5) {
    jenv->ReleaseStringUTFChars(jarg5, arg5_pstr);
  }
  
  
  bool valid = true;
  XmlValue val6 = createCPPXmlValue(jenv, jarg6, &valid);
  if (!valid) return 0;
  arg6 = &val6;
  
  
  if (!jarg1) {
    jenv->Throw((jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INVALID_VALUE,
        jenv->NewStringUTF("null object - call after object destroyed?"),
        0, 0, 0, 0));					
    return 0;
  }
  
  {
    jthrowable t = NULL;
    try {
      result = (XmlStatistics *)XmlContainer_lookupStatistics__SWIG_4(arg1,*arg2,(std::string const &)*arg3,(std::string const &)*arg4,(std::string const &)*arg5,(XmlValue const &)*arg6);
    }
    catch (std::exception &se) {
      t = createException(jenv, &se);
      jenv->Throw(t);
      return 0;
    }
    catch(JavaException & /* je */) {
      // This means there's already an exception waiting in the JVM
      return 0;
    }
    catch (...) {
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("Uncaught exception from C++ API"), 0, 0, 0, 0);
      jenv->Throw(t);
      return 0;
    }
  }
  *(XmlStatistics **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_sleepycat_dbxml_dbxml_1javaJNI_XmlContainer_1lookupStatistics_1_1SWIG_15(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_, jstring jarg3, jstring jarg4, jstring jarg5) {
  jlong jresult = 0 ;
  XmlContainer *arg1 = (XmlContainer *) 0 ;
  XmlTransaction *arg2 = 0 ;
  std::string *arg3 = 0 ;
  std::string *arg4 = 0 ;
  std::string *arg5 = 0 ;
  XmlStatistics *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(XmlContainer **)&jarg1; 
  arg2 = *(XmlTransaction **)&jarg2;
  if(!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "XmlTransaction & reference is null");
    return 0;
  } 
  
  const char *arg3_pstr = "";
  if(jarg3) {
    arg3_pstr = (const char *)jenv->GetStringUTFChars(jarg3, 0);
  }
  if (!arg3_pstr) return 0;
  std::string arg3_str(arg3_pstr);
  arg3 = &arg3_str;
  if (jarg3) {
    jenv->ReleaseStringUTFChars(jarg3, arg3_pstr);
  }
  
  
  const char *arg4_pstr = "";
  if(jarg4) {
    arg4_pstr = (const char *)jenv->GetStringUTFChars(jarg4, 0);
  }
  if (!arg4_pstr) return 0;
  std::string arg4_str(arg4_pstr);
  arg4 = &arg4_str;
  if (jarg4) {
    jenv->ReleaseStringUTFChars(jarg4, arg4_pstr);
  }
  
  
  const char *arg5_pstr = "";
  if(jarg5) {
    arg5_pstr = (const char *)jenv->GetStringUTFChars(jarg5, 0);
  }
  if (!arg5_pstr) return 0;
  std::string arg5_str(arg5_pstr);
  arg5 = &arg5_str;
  if (jarg5) {
    jenv->ReleaseStringUTFChars(jarg5, arg5_pstr);
  }
  
  
  if (!jarg1) {
    jenv->Throw((jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INVALID_VALUE,
        jenv->NewStringUTF("null object - call after object destroyed?"),
        0, 0, 0, 0));					
    return 0;
  }
  
  {
    jthrowable t = NULL;
    try {
      result = (XmlStatistics *)XmlContainer_lookupStatistics__SWIG_4(arg1,*arg2,(std::string const &)*arg3,(std::string const &)*arg4,(std::string const &)*arg5);
    }
    catch (std::exception &se) {
      t = createException(jenv, &se);
      jenv->Throw(t);
      return 0;
    }
    catch(JavaException & /* je */) {
      // This means there's already an exception waiting in the JVM
      return 0;
    }
    catch (...) {
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("Uncaught exception from C++ API"), 0, 0, 0, 0);
      jenv->Throw(t);
      return 0;
    }
  }
  *(XmlStatistics **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_sleepycat_dbxml_dbxml_1javaJNI_XmlContainer_1lookupStatistics_1_1SWIG_16(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_, jstring jarg3, jstring jarg4, jstring jarg5, jstring jarg6, jstring jarg7, jobject jarg8) {
  jlong jresult = 0 ;
  XmlContainer *arg1 = (XmlContainer *) 0 ;
  XmlTransaction *arg2 = 0 ;
  std::string *arg3 = 0 ;
  std::string *arg4 = 0 ;
  std::string *arg5 = 0 ;
  std::string *arg6 = 0 ;
  std::string *arg7 = 0 ;
  XmlValue *arg8 = 0 ;
  XmlStatistics *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(XmlContainer **)&jarg1; 
  arg2 = *(XmlTransaction **)&jarg2;
  if(!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "XmlTransaction & reference is null");
    return 0;
  } 
  
  const char *arg3_pstr = "";
  if(jarg3) {
    arg3_pstr = (const char *)jenv->GetStringUTFChars(jarg3, 0);
  }
  if (!arg3_pstr) return 0;
  std::string arg3_str(arg3_pstr);
  arg3 = &arg3_str;
  if (jarg3) {
    jenv->ReleaseStringUTFChars(jarg3, arg3_pstr);
  }
  
  
  const char *arg4_pstr = "";
  if(jarg4) {
    arg4_pstr = (const char *)jenv->GetStringUTFChars(jarg4, 0);
  }
  if (!arg4_pstr) return 0;
  std::string arg4_str(arg4_pstr);
  arg4 = &arg4_str;
  if (jarg4) {
    jenv->ReleaseStringUTFChars(jarg4, arg4_pstr);
  }
  
  
  const char *arg5_pstr = "";
  if(jarg5) {
    arg5_pstr = (const char *)jenv->GetStringUTFChars(jarg5, 0);
  }
  if (!arg5_pstr) return 0;
  std::string arg5_str(arg5_pstr);
  arg5 = &arg5_str;
  if (jarg5) {
    jenv->ReleaseStringUTFChars(jarg5, arg5_pstr);
  }
  
  
  const char *arg6_pstr = "";
  if(jarg6) {
    arg6_pstr = (const char *)jenv->GetStringUTFChars(jarg6, 0);
  }
  if (!arg6_pstr) return 0;
  std::string arg6_str(arg6_pstr);
  arg6 = &arg6_str;
  if (jarg6) {
    jenv->ReleaseStringUTFChars(jarg6, arg6_pstr);
  }
  
  
  const char *arg7_pstr = "";
  if(jarg7) {
    arg7_pstr = (const char *)jenv->GetStringUTFChars(jarg7, 0);
  }
  if (!arg7_pstr) return 0;
  std::string arg7_str(arg7_pstr);
  arg7 = &arg7_str;
  if (jarg7) {
    jenv->ReleaseStringUTFChars(jarg7, arg7_pstr);
  }
  
  
  bool valid = true;
  XmlValue val8 = createCPPXmlValue(jenv, jarg8, &valid);
  if (!valid) return 0;
  arg8 = &val8;
  
  
  if (!jarg1) {
    jenv->Throw((jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INVALID_VALUE,
        jenv->NewStringUTF("null object - call after object destroyed?"),
        0, 0, 0, 0));					
    return 0;
  }
  
  {
    jthrowable t = NULL;
    try {
      result = (XmlStatistics *)XmlContainer_lookupStatistics__SWIG_6(arg1,*arg2,(std::string const &)*arg3,(std::string const &)*arg4,(std::string const &)*arg5,(std::string const &)*arg6,(std::string const &)*arg7,(XmlValue const &)*arg8);
    }
    catch (std::exception &se) {
      t = createException(jenv, &se);
      jenv->Throw(t);
      return 0;
    }
    catch(JavaException & /* je */) {
      // This means there's already an exception waiting in the JVM
      return 0;
    }
    catch (...) {
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("Uncaught exception from C++ API"), 0, 0, 0, 0);
      jenv->Throw(t);
      return 0;
    }
  }
  *(XmlStatistics **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_sleepycat_dbxml_dbxml_1javaJNI_XmlContainer_1lookupStatistics_1_1SWIG_17(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_, jstring jarg3, jstring jarg4, jstring jarg5, jstring jarg6, jstring jarg7) {
  jlong jresult = 0 ;
  XmlContainer *arg1 = (XmlContainer *) 0 ;
  XmlTransaction *arg2 = 0 ;
  std::string *arg3 = 0 ;
  std::string *arg4 = 0 ;
  std::string *arg5 = 0 ;
  std::string *arg6 = 0 ;
  std::string *arg7 = 0 ;
  XmlStatistics *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(XmlContainer **)&jarg1; 
  arg2 = *(XmlTransaction **)&jarg2;
  if(!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "XmlTransaction & reference is null");
    return 0;
  } 
  
  const char *arg3_pstr = "";
  if(jarg3) {
    arg3_pstr = (const char *)jenv->GetStringUTFChars(jarg3, 0);
  }
  if (!arg3_pstr) return 0;
  std::string arg3_str(arg3_pstr);
  arg3 = &arg3_str;
  if (jarg3) {
    jenv->ReleaseStringUTFChars(jarg3, arg3_pstr);
  }
  
  
  const char *arg4_pstr = "";
  if(jarg4) {
    arg4_pstr = (const char *)jenv->GetStringUTFChars(jarg4, 0);
  }
  if (!arg4_pstr) return 0;
  std::string arg4_str(arg4_pstr);
  arg4 = &arg4_str;
  if (jarg4) {
    jenv->ReleaseStringUTFChars(jarg4, arg4_pstr);
  }
  
  
  const char *arg5_pstr = "";
  if(jarg5) {
    arg5_pstr = (const char *)jenv->GetStringUTFChars(jarg5, 0);
  }
  if (!arg5_pstr) return 0;
  std::string arg5_str(arg5_pstr);
  arg5 = &arg5_str;
  if (jarg5) {
    jenv->ReleaseStringUTFChars(jarg5, arg5_pstr);
  }
  
  
  const char *arg6_pstr = "";
  if(jarg6) {
    arg6_pstr = (const char *)jenv->GetStringUTFChars(jarg6, 0);
  }
  if (!arg6_pstr) return 0;
  std::string arg6_str(arg6_pstr);
  arg6 = &arg6_str;
  if (jarg6) {
    jenv->ReleaseStringUTFChars(jarg6, arg6_pstr);
  }
  
  
  const char *arg7_pstr = "";
  if(jarg7) {
    arg7_pstr = (const char *)jenv->GetStringUTFChars(jarg7, 0);
  }
  if (!arg7_pstr) return 0;
  std::string arg7_str(arg7_pstr);
  arg7 = &arg7_str;
  if (jarg7) {
    jenv->ReleaseStringUTFChars(jarg7, arg7_pstr);
  }
  
  
  if (!jarg1) {
    jenv->Throw((jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INVALID_VALUE,
        jenv->NewStringUTF("null object - call after object destroyed?"),
        0, 0, 0, 0));					
    return 0;
  }
  
  {
    jthrowable t = NULL;
    try {
      result = (XmlStatistics *)XmlContainer_lookupStatistics__SWIG_6(arg1,*arg2,(std::string const &)*arg3,(std::string const &)*arg4,(std::string const &)*arg5,(std::string const &)*arg6,(std::string const &)*arg7);
    }
    catch (std::exception &se) {
      t = createException(jenv, &se);
      jenv->Throw(t);
      return 0;
    }
    catch(JavaException & /* je */) {
      // This means there's already an exception waiting in the JVM
      return 0;
    }
    catch (...) {
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("Uncaught exception from C++ API"), 0, 0, 0, 0);
      jenv->Throw(t);
      return 0;
    }
  }
  *(XmlStatistics **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jstring JNICALL Java_com_sleepycat_dbxml_dbxml_1javaJNI_XmlContainer_1getContainerConfigData(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jintArray jarg2) {
  jstring jresult = 0 ;
  XmlContainer *arg1 = (XmlContainer *) 0 ;
  int *arg2 ;
  jint *jarr2 ;
  std::string result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(XmlContainer **)&jarg1; 
  if (!SWIG_JavaArrayInInt(jenv, &jarr2, &arg2, jarg2)) return 0; 
  
  if (!jarg1) {
    jenv->Throw((jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INVALID_VALUE,
        jenv->NewStringUTF("null object - call after object destroyed?"),
        0, 0, 0, 0));					
    return 0;
  }
  
  {
    jthrowable t = NULL;
    try {
      result = XmlContainer_getContainerConfigData(arg1,arg2);
    }
    catch (std::exception &se) {
      t = createException(jenv, &se);
      jenv->Throw(t);
      return 0;
    }
    catch(JavaException & /* je */) {
      // This means there's already an exception waiting in the JVM
      return 0;
    }
    catch (...) {
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("Uncaught exception from C++ API"), 0, 0, 0, 0);
      jenv->Throw(t);
      return 0;
    }
  }
  jresult = jenv->NewStringUTF((&result)->c_str()); 
  SWIG_JavaArrayArgoutInt(jenv, jarr2, arg2, jarg2); 
  delete [] arg2; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_sleepycat_dbxml_dbxml_1javaJNI_XmlContainer_1setAutoIndexing_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jboolean jarg2) {
  XmlContainer *arg1 = (XmlContainer *) 0 ;
  bool arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(XmlContainer **)&jarg1; 
  
  arg2 = (jarg2 != JNI_FALSE);
  
  
  if (!jarg1) {
    jenv->Throw((jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INVALID_VALUE,
        jenv->NewStringUTF("null object - call after object destroyed?"),
        0, 0, 0, 0));					
    return ;
  }
  
  {
    jthrowable t = NULL;
    try {
      XmlContainer_setAutoIndexing__SWIG_0(arg1,arg2);
    }
    catch (std::exception &se) {
      t = createException(jenv, &se);
      jenv->Throw(t);
      return ;
    }
    catch(JavaException & /* je */) {
      // This means there's already an exception waiting in the JVM
      return ;
    }
    catch (...) {
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("Uncaught exception from C++ API"), 0, 0, 0, 0);
      jenv->Throw(t);
      return ;
    }
  }
}


SWIGEXPORT void JNICALL Java_com_sleepycat_dbxml_dbxml_1javaJNI_XmlContainer_1setAutoIndexing_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_, jboolean jarg3) {
  XmlContainer *arg1 = (XmlContainer *) 0 ;
  XmlTransaction *arg2 = 0 ;
  bool arg3 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(XmlContainer **)&jarg1; 
  arg2 = *(XmlTransaction **)&jarg2;
  if(!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "XmlTransaction & reference is null");
    return ;
  } 
  
  arg3 = (jarg3 != JNI_FALSE);
  
  
  if (!jarg1) {
    jenv->Throw((jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INVALID_VALUE,
        jenv->NewStringUTF("null object - call after object destroyed?"),
        0, 0, 0, 0));					
    return ;
  }
  
  {
    jthrowable t = NULL;
    try {
      XmlContainer_setAutoIndexing__SWIG_1(arg1,*arg2,arg3);
    }
    catch (std::exception &se) {
      t = createException(jenv, &se);
      jenv->Throw(t);
      return ;
    }
    catch(JavaException & /* je */) {
      // This means there's already an exception waiting in the JVM
      return ;
    }
    catch (...) {
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("Uncaught exception from C++ API"), 0, 0, 0, 0);
      jenv->Throw(t);
      return ;
    }
  }
}


SWIGEXPORT void JNICALL Java_com_sleepycat_dbxml_dbxml_1javaJNI_XmlContainer_1setIndexSpecification_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  XmlContainer *arg1 = (XmlContainer *) 0 ;
  XmlIndexSpecification *arg2 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(XmlContainer **)&jarg1; 
  arg2 = *(XmlIndexSpecification **)&jarg2;
  if(!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "XmlIndexSpecification const & reference is null");
    return ;
  } 
  
  if (!jarg1) {
    jenv->Throw((jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INVALID_VALUE,
        jenv->NewStringUTF("null object - call after object destroyed?"),
        0, 0, 0, 0));					
    return ;
  }
  
  {
    jthrowable t = NULL;
    try {
      XmlContainer_setIndexSpecification__SWIG_0(arg1,(XmlIndexSpecification const &)*arg2);
    }
    catch (std::exception &se) {
      t = createException(jenv, &se);
      jenv->Throw(t);
      return ;
    }
    catch(JavaException & /* je */) {
      // This means there's already an exception waiting in the JVM
      return ;
    }
    catch (...) {
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("Uncaught exception from C++ API"), 0, 0, 0, 0);
      jenv->Throw(t);
      return ;
    }
  }
}


SWIGEXPORT void JNICALL Java_com_sleepycat_dbxml_dbxml_1javaJNI_XmlContainer_1addIndex_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2, jstring jarg3, jstring jarg4) {
  XmlContainer *arg1 = (XmlContainer *) 0 ;
  std::string *arg2 = 0 ;
  std::string *arg3 = 0 ;
  std::string *arg4 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(XmlContainer **)&jarg1; 
  
  const char *arg2_pstr = "";
  if(jarg2) {
    arg2_pstr = (const char *)jenv->GetStringUTFChars(jarg2, 0);
  }
  if (!arg2_pstr) return ;
  std::string arg2_str(arg2_pstr);
  arg2 = &arg2_str;
  if (jarg2) {
    jenv->ReleaseStringUTFChars(jarg2, arg2_pstr);
  }
  
  
  const char *arg3_pstr = "";
  if(jarg3) {
    arg3_pstr = (const char *)jenv->GetStringUTFChars(jarg3, 0);
  }
  if (!arg3_pstr) return ;
  std::string arg3_str(arg3_pstr);
  arg3 = &arg3_str;
  if (jarg3) {
    jenv->ReleaseStringUTFChars(jarg3, arg3_pstr);
  }
  
  
  const char *arg4_pstr = "";
  if(jarg4) {
    arg4_pstr = (const char *)jenv->GetStringUTFChars(jarg4, 0);
  }
  if (!arg4_pstr) return ;
  std::string arg4_str(arg4_pstr);
  arg4 = &arg4_str;
  if (jarg4) {
    jenv->ReleaseStringUTFChars(jarg4, arg4_pstr);
  }
  
  
  if (!jarg1) {
    jenv->Throw((jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INVALID_VALUE,
        jenv->NewStringUTF("null object - call after object destroyed?"),
        0, 0, 0, 0));					
    return ;
  }
  
  {
    jthrowable t = NULL;
    try {
      XmlContainer_addIndex__SWIG_0(arg1,(std::string const &)*arg2,(std::string const &)*arg3,(std::string const &)*arg4);
    }
    catch (std::exception &se) {
      t = createException(jenv, &se);
      jenv->Throw(t);
      return ;
    }
    catch(JavaException & /* je */) {
      // This means there's already an exception waiting in the JVM
      return ;
    }
    catch (...) {
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("Uncaught exception from C++ API"), 0, 0, 0, 0);
      jenv->Throw(t);
      return ;
    }
  }
}


SWIGEXPORT void JNICALL Java_com_sleepycat_dbxml_dbxml_1javaJNI_XmlContainer_1addIndex_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2, jstring jarg3, jint jarg4, jint jarg5) {
  XmlContainer *arg1 = (XmlContainer *) 0 ;
  std::string *arg2 = 0 ;
  std::string *arg3 = 0 ;
  enum XmlIndexSpecification::Type arg4 ;
  enum XmlValue::Type arg5 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(XmlContainer **)&jarg1; 
  
  const char *arg2_pstr = "";
  if(jarg2) {
    arg2_pstr = (const char *)jenv->GetStringUTFChars(jarg2, 0);
  }
  if (!arg2_pstr) return ;
  std::string arg2_str(arg2_pstr);
  arg2 = &arg2_str;
  if (jarg2) {
    jenv->ReleaseStringUTFChars(jarg2, arg2_pstr);
  }
  
  
  const char *arg3_pstr = "";
  if(jarg3) {
    arg3_pstr = (const char *)jenv->GetStringUTFChars(jarg3, 0);
  }
  if (!arg3_pstr) return ;
  std::string arg3_str(arg3_pstr);
  arg3 = &arg3_str;
  if (jarg3) {
    jenv->ReleaseStringUTFChars(jarg3, arg3_pstr);
  }
  
  arg4 = (enum XmlIndexSpecification::Type)jarg4; 
  arg5 = (enum XmlValue::Type)jarg5; 
  
  if (!jarg1) {
    jenv->Throw((jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INVALID_VALUE,
        jenv->NewStringUTF("null object - call after object destroyed?"),
        0, 0, 0, 0));					
    return ;
  }
  
  {
    jthrowable t = NULL;
    try {
      XmlContainer_addIndex__SWIG_1(arg1,(std::string const &)*arg2,(std::string const &)*arg3,arg4,arg5);
    }
    catch (std::exception &se) {
      t = createException(jenv, &se);
      jenv->Throw(t);
      return ;
    }
    catch(JavaException & /* je */) {
      // This means there's already an exception waiting in the JVM
      return ;
    }
    catch (...) {
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("Uncaught exception from C++ API"), 0, 0, 0, 0);
      jenv->Throw(t);
      return ;
    }
  }
}


SWIGEXPORT void JNICALL Java_com_sleepycat_dbxml_dbxml_1javaJNI_XmlContainer_1deleteIndex_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2, jstring jarg3, jstring jarg4) {
  XmlContainer *arg1 = (XmlContainer *) 0 ;
  std::string *arg2 = 0 ;
  std::string *arg3 = 0 ;
  std::string *arg4 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(XmlContainer **)&jarg1; 
  
  const char *arg2_pstr = "";
  if(jarg2) {
    arg2_pstr = (const char *)jenv->GetStringUTFChars(jarg2, 0);
  }
  if (!arg2_pstr) return ;
  std::string arg2_str(arg2_pstr);
  arg2 = &arg2_str;
  if (jarg2) {
    jenv->ReleaseStringUTFChars(jarg2, arg2_pstr);
  }
  
  
  const char *arg3_pstr = "";
  if(jarg3) {
    arg3_pstr = (const char *)jenv->GetStringUTFChars(jarg3, 0);
  }
  if (!arg3_pstr) return ;
  std::string arg3_str(arg3_pstr);
  arg3 = &arg3_str;
  if (jarg3) {
    jenv->ReleaseStringUTFChars(jarg3, arg3_pstr);
  }
  
  
  const char *arg4_pstr = "";
  if(jarg4) {
    arg4_pstr = (const char *)jenv->GetStringUTFChars(jarg4, 0);
  }
  if (!arg4_pstr) return ;
  std::string arg4_str(arg4_pstr);
  arg4 = &arg4_str;
  if (jarg4) {
    jenv->ReleaseStringUTFChars(jarg4, arg4_pstr);
  }
  
  
  if (!jarg1) {
    jenv->Throw((jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INVALID_VALUE,
        jenv->NewStringUTF("null object - call after object destroyed?"),
        0, 0, 0, 0));					
    return ;
  }
  
  {
    jthrowable t = NULL;
    try {
      XmlContainer_deleteIndex__SWIG_0(arg1,(std::string const &)*arg2,(std::string const &)*arg3,(std::string const &)*arg4);
    }
    catch (std::exception &se) {
      t = createException(jenv, &se);
      jenv->Throw(t);
      return ;
    }
    catch(JavaException & /* je */) {
      // This means there's already an exception waiting in the JVM
      return ;
    }
    catch (...) {
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("Uncaught exception from C++ API"), 0, 0, 0, 0);
      jenv->Throw(t);
      return ;
    }
  }
}


SWIGEXPORT void JNICALL Java_com_sleepycat_dbxml_dbxml_1javaJNI_XmlContainer_1replaceIndex_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2, jstring jarg3, jstring jarg4) {
  XmlContainer *arg1 = (XmlContainer *) 0 ;
  std::string *arg2 = 0 ;
  std::string *arg3 = 0 ;
  std::string *arg4 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(XmlContainer **)&jarg1; 
  
  const char *arg2_pstr = "";
  if(jarg2) {
    arg2_pstr = (const char *)jenv->GetStringUTFChars(jarg2, 0);
  }
  if (!arg2_pstr) return ;
  std::string arg2_str(arg2_pstr);
  arg2 = &arg2_str;
  if (jarg2) {
    jenv->ReleaseStringUTFChars(jarg2, arg2_pstr);
  }
  
  
  const char *arg3_pstr = "";
  if(jarg3) {
    arg3_pstr = (const char *)jenv->GetStringUTFChars(jarg3, 0);
  }
  if (!arg3_pstr) return ;
  std::string arg3_str(arg3_pstr);
  arg3 = &arg3_str;
  if (jarg3) {
    jenv->ReleaseStringUTFChars(jarg3, arg3_pstr);
  }
  
  
  const char *arg4_pstr = "";
  if(jarg4) {
    arg4_pstr = (const char *)jenv->GetStringUTFChars(jarg4, 0);
  }
  if (!arg4_pstr) return ;
  std::string arg4_str(arg4_pstr);
  arg4 = &arg4_str;
  if (jarg4) {
    jenv->ReleaseStringUTFChars(jarg4, arg4_pstr);
  }
  
  
  if (!jarg1) {
    jenv->Throw((jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INVALID_VALUE,
        jenv->NewStringUTF("null object - call after object destroyed?"),
        0, 0, 0, 0));					
    return ;
  }
  
  {
    jthrowable t = NULL;
    try {
      XmlContainer_replaceIndex__SWIG_0(arg1,(std::string const &)*arg2,(std::string const &)*arg3,(std::string const &)*arg4);
    }
    catch (std::exception &se) {
      t = createException(jenv, &se);
      jenv->Throw(t);
      return ;
    }
    catch(JavaException & /* je */) {
      // This means there's already an exception waiting in the JVM
      return ;
    }
    catch (...) {
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("Uncaught exception from C++ API"), 0, 0, 0, 0);
      jenv->Throw(t);
      return ;
    }
  }
}


SWIGEXPORT void JNICALL Java_com_sleepycat_dbxml_dbxml_1javaJNI_XmlContainer_1addDefaultIndex_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2) {
  XmlContainer *arg1 = (XmlContainer *) 0 ;
  std::string *arg2 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(XmlContainer **)&jarg1; 
  
  const char *arg2_pstr = "";
  if(jarg2) {
    arg2_pstr = (const char *)jenv->GetStringUTFChars(jarg2, 0);
  }
  if (!arg2_pstr) return ;
  std::string arg2_str(arg2_pstr);
  arg2 = &arg2_str;
  if (jarg2) {
    jenv->ReleaseStringUTFChars(jarg2, arg2_pstr);
  }
  
  
  if (!jarg1) {
    jenv->Throw((jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INVALID_VALUE,
        jenv->NewStringUTF("null object - call after object destroyed?"),
        0, 0, 0, 0));					
    return ;
  }
  
  {
    jthrowable t = NULL;
    try {
      XmlContainer_addDefaultIndex__SWIG_0(arg1,(std::string const &)*arg2);
    }
    catch (std::exception &se) {
      t = createException(jenv, &se);
      jenv->Throw(t);
      return ;
    }
    catch(JavaException & /* je */) {
      // This means there's already an exception waiting in the JVM
      return ;
    }
    catch (...) {
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("Uncaught exception from C++ API"), 0, 0, 0, 0);
      jenv->Throw(t);
      return ;
    }
  }
}


SWIGEXPORT void JNICALL Java_com_sleepycat_dbxml_dbxml_1javaJNI_XmlContainer_1deleteDefaultIndex_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2) {
  XmlContainer *arg1 = (XmlContainer *) 0 ;
  std::string *arg2 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(XmlContainer **)&jarg1; 
  
  const char *arg2_pstr = "";
  if(jarg2) {
    arg2_pstr = (const char *)jenv->GetStringUTFChars(jarg2, 0);
  }
  if (!arg2_pstr) return ;
  std::string arg2_str(arg2_pstr);
  arg2 = &arg2_str;
  if (jarg2) {
    jenv->ReleaseStringUTFChars(jarg2, arg2_pstr);
  }
  
  
  if (!jarg1) {
    jenv->Throw((jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INVALID_VALUE,
        jenv->NewStringUTF("null object - call after object destroyed?"),
        0, 0, 0, 0));					
    return ;
  }
  
  {
    jthrowable t = NULL;
    try {
      XmlContainer_deleteDefaultIndex__SWIG_0(arg1,(std::string const &)*arg2);
    }
    catch (std::exception &se) {
      t = createException(jenv, &se);
      jenv->Throw(t);
      return ;
    }
    catch(JavaException & /* je */) {
      // This means there's already an exception waiting in the JVM
      return ;
    }
    catch (...) {
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("Uncaught exception from C++ API"), 0, 0, 0, 0);
      jenv->Throw(t);
      return ;
    }
  }
}


SWIGEXPORT void JNICALL Java_com_sleepycat_dbxml_dbxml_1javaJNI_XmlContainer_1replaceDefaultIndex_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2) {
  XmlContainer *arg1 = (XmlContainer *) 0 ;
  std::string *arg2 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(XmlContainer **)&jarg1; 
  
  const char *arg2_pstr = "";
  if(jarg2) {
    arg2_pstr = (const char *)jenv->GetStringUTFChars(jarg2, 0);
  }
  if (!arg2_pstr) return ;
  std::string arg2_str(arg2_pstr);
  arg2 = &arg2_str;
  if (jarg2) {
    jenv->ReleaseStringUTFChars(jarg2, arg2_pstr);
  }
  
  
  if (!jarg1) {
    jenv->Throw((jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INVALID_VALUE,
        jenv->NewStringUTF("null object - call after object destroyed?"),
        0, 0, 0, 0));					
    return ;
  }
  
  {
    jthrowable t = NULL;
    try {
      XmlContainer_replaceDefaultIndex__SWIG_0(arg1,(std::string const &)*arg2);
    }
    catch (std::exception &se) {
      t = createException(jenv, &se);
      jenv->Throw(t);
      return ;
    }
    catch(JavaException & /* je */) {
      // This means there's already an exception waiting in the JVM
      return ;
    }
    catch (...) {
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("Uncaught exception from C++ API"), 0, 0, 0, 0);
      jenv->Throw(t);
      return ;
    }
  }
}


SWIGEXPORT void JNICALL Java_com_sleepycat_dbxml_dbxml_1javaJNI_XmlContainer_1setIndexSpecification_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_, jlong jarg3, jobject jarg3_) {
  XmlContainer *arg1 = (XmlContainer *) 0 ;
  XmlTransaction *arg2 = 0 ;
  XmlIndexSpecification *arg3 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  (void)jarg3_;
  arg1 = *(XmlContainer **)&jarg1; 
  arg2 = *(XmlTransaction **)&jarg2;
  if(!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "XmlTransaction & reference is null");
    return ;
  } 
  arg3 = *(XmlIndexSpecification **)&jarg3;
  if(!arg3) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "XmlIndexSpecification const & reference is null");
    return ;
  } 
  
  if (!jarg1) {
    jenv->Throw((jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INVALID_VALUE,
        jenv->NewStringUTF("null object - call after object destroyed?"),
        0, 0, 0, 0));					
    return ;
  }
  
  {
    jthrowable t = NULL;
    try {
      XmlContainer_setIndexSpecification__SWIG_1(arg1,*arg2,(XmlIndexSpecification const &)*arg3);
    }
    catch (std::exception &se) {
      t = createException(jenv, &se);
      jenv->Throw(t);
      return ;
    }
    catch(JavaException & /* je */) {
      // This means there's already an exception waiting in the JVM
      return ;
    }
    catch (...) {
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("Uncaught exception from C++ API"), 0, 0, 0, 0);
      jenv->Throw(t);
      return ;
    }
  }
}


SWIGEXPORT void JNICALL Java_com_sleepycat_dbxml_dbxml_1javaJNI_XmlContainer_1addIndex_1_1SWIG_12(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_, jstring jarg3, jstring jarg4, jstring jarg5) {
  XmlContainer *arg1 = (XmlContainer *) 0 ;
  XmlTransaction *arg2 = 0 ;
  std::string *arg3 = 0 ;
  std::string *arg4 = 0 ;
  std::string *arg5 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(XmlContainer **)&jarg1; 
  arg2 = *(XmlTransaction **)&jarg2;
  if(!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "XmlTransaction & reference is null");
    return ;
  } 
  
  const char *arg3_pstr = "";
  if(jarg3) {
    arg3_pstr = (const char *)jenv->GetStringUTFChars(jarg3, 0);
  }
  if (!arg3_pstr) return ;
  std::string arg3_str(arg3_pstr);
  arg3 = &arg3_str;
  if (jarg3) {
    jenv->ReleaseStringUTFChars(jarg3, arg3_pstr);
  }
  
  
  const char *arg4_pstr = "";
  if(jarg4) {
    arg4_pstr = (const char *)jenv->GetStringUTFChars(jarg4, 0);
  }
  if (!arg4_pstr) return ;
  std::string arg4_str(arg4_pstr);
  arg4 = &arg4_str;
  if (jarg4) {
    jenv->ReleaseStringUTFChars(jarg4, arg4_pstr);
  }
  
  
  const char *arg5_pstr = "";
  if(jarg5) {
    arg5_pstr = (const char *)jenv->GetStringUTFChars(jarg5, 0);
  }
  if (!arg5_pstr) return ;
  std::string arg5_str(arg5_pstr);
  arg5 = &arg5_str;
  if (jarg5) {
    jenv->ReleaseStringUTFChars(jarg5, arg5_pstr);
  }
  
  
  if (!jarg1) {
    jenv->Throw((jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INVALID_VALUE,
        jenv->NewStringUTF("null object - call after object destroyed?"),
        0, 0, 0, 0));					
    return ;
  }
  
  {
    jthrowable t = NULL;
    try {
      XmlContainer_addIndex__SWIG_2(arg1,*arg2,(std::string const &)*arg3,(std::string const &)*arg4,(std::string const &)*arg5);
    }
    catch (std::exception &se) {
      t = createException(jenv, &se);
      jenv->Throw(t);
      return ;
    }
    catch(JavaException & /* je */) {
      // This means there's already an exception waiting in the JVM
      return ;
    }
    catch (...) {
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("Uncaught exception from C++ API"), 0, 0, 0, 0);
      jenv->Throw(t);
      return ;
    }
  }
}


SWIGEXPORT void JNICALL Java_com_sleepycat_dbxml_dbxml_1javaJNI_XmlContainer_1addIndex_1_1SWIG_13(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_, jstring jarg3, jstring jarg4, jint jarg5, jint jarg6) {
  XmlContainer *arg1 = (XmlContainer *) 0 ;
  XmlTransaction *arg2 = 0 ;
  std::string *arg3 = 0 ;
  std::string *arg4 = 0 ;
  enum XmlIndexSpecification::Type arg5 ;
  enum XmlValue::Type arg6 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(XmlContainer **)&jarg1; 
  arg2 = *(XmlTransaction **)&jarg2;
  if(!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "XmlTransaction & reference is null");
    return ;
  } 
  
  const char *arg3_pstr = "";
  if(jarg3) {
    arg3_pstr = (const char *)jenv->GetStringUTFChars(jarg3, 0);
  }
  if (!arg3_pstr) return ;
  std::string arg3_str(arg3_pstr);
  arg3 = &arg3_str;
  if (jarg3) {
    jenv->ReleaseStringUTFChars(jarg3, arg3_pstr);
  }
  
  
  const char *arg4_pstr = "";
  if(jarg4) {
    arg4_pstr = (const char *)jenv->GetStringUTFChars(jarg4, 0);
  }
  if (!arg4_pstr) return ;
  std::string arg4_str(arg4_pstr);
  arg4 = &arg4_str;
  if (jarg4) {
    jenv->ReleaseStringUTFChars(jarg4, arg4_pstr);
  }
  
  arg5 = (enum XmlIndexSpecification::Type)jarg5; 
  arg6 = (enum XmlValue::Type)jarg6; 
  
  if (!jarg1) {
    jenv->Throw((jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INVALID_VALUE,
        jenv->NewStringUTF("null object - call after object destroyed?"),
        0, 0, 0, 0));					
    return ;
  }
  
  {
    jthrowable t = NULL;
    try {
      XmlContainer_addIndex__SWIG_3(arg1,*arg2,(std::string const &)*arg3,(std::string const &)*arg4,arg5,arg6);
    }
    catch (std::exception &se) {
      t = createException(jenv, &se);
      jenv->Throw(t);
      return ;
    }
    catch(JavaException & /* je */) {
      // This means there's already an exception waiting in the JVM
      return ;
    }
    catch (...) {
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("Uncaught exception from C++ API"), 0, 0, 0, 0);
      jenv->Throw(t);
      return ;
    }
  }
}


SWIGEXPORT void JNICALL Java_com_sleepycat_dbxml_dbxml_1javaJNI_XmlContainer_1deleteIndex_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_, jstring jarg3, jstring jarg4, jstring jarg5) {
  XmlContainer *arg1 = (XmlContainer *) 0 ;
  XmlTransaction *arg2 = 0 ;
  std::string *arg3 = 0 ;
  std::string *arg4 = 0 ;
  std::string *arg5 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(XmlContainer **)&jarg1; 
  arg2 = *(XmlTransaction **)&jarg2;
  if(!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "XmlTransaction & reference is null");
    return ;
  } 
  
  const char *arg3_pstr = "";
  if(jarg3) {
    arg3_pstr = (const char *)jenv->GetStringUTFChars(jarg3, 0);
  }
  if (!arg3_pstr) return ;
  std::string arg3_str(arg3_pstr);
  arg3 = &arg3_str;
  if (jarg3) {
    jenv->ReleaseStringUTFChars(jarg3, arg3_pstr);
  }
  
  
  const char *arg4_pstr = "";
  if(jarg4) {
    arg4_pstr = (const char *)jenv->GetStringUTFChars(jarg4, 0);
  }
  if (!arg4_pstr) return ;
  std::string arg4_str(arg4_pstr);
  arg4 = &arg4_str;
  if (jarg4) {
    jenv->ReleaseStringUTFChars(jarg4, arg4_pstr);
  }
  
  
  const char *arg5_pstr = "";
  if(jarg5) {
    arg5_pstr = (const char *)jenv->GetStringUTFChars(jarg5, 0);
  }
  if (!arg5_pstr) return ;
  std::string arg5_str(arg5_pstr);
  arg5 = &arg5_str;
  if (jarg5) {
    jenv->ReleaseStringUTFChars(jarg5, arg5_pstr);
  }
  
  
  if (!jarg1) {
    jenv->Throw((jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INVALID_VALUE,
        jenv->NewStringUTF("null object - call after object destroyed?"),
        0, 0, 0, 0));					
    return ;
  }
  
  {
    jthrowable t = NULL;
    try {
      XmlContainer_deleteIndex__SWIG_1(arg1,*arg2,(std::string const &)*arg3,(std::string const &)*arg4,(std::string const &)*arg5);
    }
    catch (std::exception &se) {
      t = createException(jenv, &se);
      jenv->Throw(t);
      return ;
    }
    catch(JavaException & /* je */) {
      // This means there's already an exception waiting in the JVM
      return ;
    }
    catch (...) {
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("Uncaught exception from C++ API"), 0, 0, 0, 0);
      jenv->Throw(t);
      return ;
    }
  }
}


SWIGEXPORT void JNICALL Java_com_sleepycat_dbxml_dbxml_1javaJNI_XmlContainer_1replaceIndex_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_, jstring jarg3, jstring jarg4, jstring jarg5) {
  XmlContainer *arg1 = (XmlContainer *) 0 ;
  XmlTransaction *arg2 = 0 ;
  std::string *arg3 = 0 ;
  std::string *arg4 = 0 ;
  std::string *arg5 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(XmlContainer **)&jarg1; 
  arg2 = *(XmlTransaction **)&jarg2;
  if(!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "XmlTransaction & reference is null");
    return ;
  } 
  
  const char *arg3_pstr = "";
  if(jarg3) {
    arg3_pstr = (const char *)jenv->GetStringUTFChars(jarg3, 0);
  }
  if (!arg3_pstr) return ;
  std::string arg3_str(arg3_pstr);
  arg3 = &arg3_str;
  if (jarg3) {
    jenv->ReleaseStringUTFChars(jarg3, arg3_pstr);
  }
  
  
  const char *arg4_pstr = "";
  if(jarg4) {
    arg4_pstr = (const char *)jenv->GetStringUTFChars(jarg4, 0);
  }
  if (!arg4_pstr) return ;
  std::string arg4_str(arg4_pstr);
  arg4 = &arg4_str;
  if (jarg4) {
    jenv->ReleaseStringUTFChars(jarg4, arg4_pstr);
  }
  
  
  const char *arg5_pstr = "";
  if(jarg5) {
    arg5_pstr = (const char *)jenv->GetStringUTFChars(jarg5, 0);
  }
  if (!arg5_pstr) return ;
  std::string arg5_str(arg5_pstr);
  arg5 = &arg5_str;
  if (jarg5) {
    jenv->ReleaseStringUTFChars(jarg5, arg5_pstr);
  }
  
  
  if (!jarg1) {
    jenv->Throw((jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INVALID_VALUE,
        jenv->NewStringUTF("null object - call after object destroyed?"),
        0, 0, 0, 0));					
    return ;
  }
  
  {
    jthrowable t = NULL;
    try {
      XmlContainer_replaceIndex__SWIG_1(arg1,*arg2,(std::string const &)*arg3,(std::string const &)*arg4,(std::string const &)*arg5);
    }
    catch (std::exception &se) {
      t = createException(jenv, &se);
      jenv->Throw(t);
      return ;
    }
    catch(JavaException & /* je */) {
      // This means there's already an exception waiting in the JVM
      return ;
    }
    catch (...) {
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("Uncaught exception from C++ API"), 0, 0, 0, 0);
      jenv->Throw(t);
      return ;
    }
  }
}


SWIGEXPORT void JNICALL Java_com_sleepycat_dbxml_dbxml_1javaJNI_XmlContainer_1addDefaultIndex_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_, jstring jarg3) {
  XmlContainer *arg1 = (XmlContainer *) 0 ;
  XmlTransaction *arg2 = 0 ;
  std::string *arg3 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(XmlContainer **)&jarg1; 
  arg2 = *(XmlTransaction **)&jarg2;
  if(!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "XmlTransaction & reference is null");
    return ;
  } 
  
  const char *arg3_pstr = "";
  if(jarg3) {
    arg3_pstr = (const char *)jenv->GetStringUTFChars(jarg3, 0);
  }
  if (!arg3_pstr) return ;
  std::string arg3_str(arg3_pstr);
  arg3 = &arg3_str;
  if (jarg3) {
    jenv->ReleaseStringUTFChars(jarg3, arg3_pstr);
  }
  
  
  if (!jarg1) {
    jenv->Throw((jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INVALID_VALUE,
        jenv->NewStringUTF("null object - call after object destroyed?"),
        0, 0, 0, 0));					
    return ;
  }
  
  {
    jthrowable t = NULL;
    try {
      XmlContainer_addDefaultIndex__SWIG_1(arg1,*arg2,(std::string const &)*arg3);
    }
    catch (std::exception &se) {
      t = createException(jenv, &se);
      jenv->Throw(t);
      return ;
    }
    catch(JavaException & /* je */) {
      // This means there's already an exception waiting in the JVM
      return ;
    }
    catch (...) {
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("Uncaught exception from C++ API"), 0, 0, 0, 0);
      jenv->Throw(t);
      return ;
    }
  }
}


SWIGEXPORT void JNICALL Java_com_sleepycat_dbxml_dbxml_1javaJNI_XmlContainer_1deleteDefaultIndex_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_, jstring jarg3) {
  XmlContainer *arg1 = (XmlContainer *) 0 ;
  XmlTransaction *arg2 = 0 ;
  std::string *arg3 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(XmlContainer **)&jarg1; 
  arg2 = *(XmlTransaction **)&jarg2;
  if(!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "XmlTransaction & reference is null");
    return ;
  } 
  
  const char *arg3_pstr = "";
  if(jarg3) {
    arg3_pstr = (const char *)jenv->GetStringUTFChars(jarg3, 0);
  }
  if (!arg3_pstr) return ;
  std::string arg3_str(arg3_pstr);
  arg3 = &arg3_str;
  if (jarg3) {
    jenv->ReleaseStringUTFChars(jarg3, arg3_pstr);
  }
  
  
  if (!jarg1) {
    jenv->Throw((jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INVALID_VALUE,
        jenv->NewStringUTF("null object - call after object destroyed?"),
        0, 0, 0, 0));					
    return ;
  }
  
  {
    jthrowable t = NULL;
    try {
      XmlContainer_deleteDefaultIndex__SWIG_1(arg1,*arg2,(std::string const &)*arg3);
    }
    catch (std::exception &se) {
      t = createException(jenv, &se);
      jenv->Throw(t);
      return ;
    }
    catch(JavaException & /* je */) {
      // This means there's already an exception waiting in the JVM
      return ;
    }
    catch (...) {
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("Uncaught exception from C++ API"), 0, 0, 0, 0);
      jenv->Throw(t);
      return ;
    }
  }
}


SWIGEXPORT void JNICALL Java_com_sleepycat_dbxml_dbxml_1javaJNI_XmlContainer_1replaceDefaultIndex_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_, jstring jarg3) {
  XmlContainer *arg1 = (XmlContainer *) 0 ;
  XmlTransaction *arg2 = 0 ;
  std::string *arg3 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(XmlContainer **)&jarg1; 
  arg2 = *(XmlTransaction **)&jarg2;
  if(!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "XmlTransaction & reference is null");
    return ;
  } 
  
  const char *arg3_pstr = "";
  if(jarg3) {
    arg3_pstr = (const char *)jenv->GetStringUTFChars(jarg3, 0);
  }
  if (!arg3_pstr) return ;
  std::string arg3_str(arg3_pstr);
  arg3 = &arg3_str;
  if (jarg3) {
    jenv->ReleaseStringUTFChars(jarg3, arg3_pstr);
  }
  
  
  if (!jarg1) {
    jenv->Throw((jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INVALID_VALUE,
        jenv->NewStringUTF("null object - call after object destroyed?"),
        0, 0, 0, 0));					
    return ;
  }
  
  {
    jthrowable t = NULL;
    try {
      XmlContainer_replaceDefaultIndex__SWIG_1(arg1,*arg2,(std::string const &)*arg3);
    }
    catch (std::exception &se) {
      t = createException(jenv, &se);
      jenv->Throw(t);
      return ;
    }
    catch(JavaException & /* je */) {
      // This means there's already an exception waiting in the JVM
      return ;
    }
    catch (...) {
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("Uncaught exception from C++ API"), 0, 0, 0, 0);
      jenv->Throw(t);
      return ;
    }
  }
}


SWIGEXPORT jstring JNICALL Java_com_sleepycat_dbxml_dbxml_1javaJNI_XmlContainer_1putDocument_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2, jstring jarg3, jint jarg4) {
  jstring jresult = 0 ;
  XmlContainer *arg1 = (XmlContainer *) 0 ;
  std::string *arg2 = 0 ;
  std::string *arg3 = 0 ;
  u_int32_t arg4 ;
  std::string result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(XmlContainer **)&jarg1; 
  
  const char *arg2_pstr = "";
  if(jarg2) {
    arg2_pstr = (const char *)jenv->GetStringUTFChars(jarg2, 0);
  }
  if (!arg2_pstr) return 0;
  std::string arg2_str(arg2_pstr);
  arg2 = &arg2_str;
  if (jarg2) {
    jenv->ReleaseStringUTFChars(jarg2, arg2_pstr);
  }
  
  
  const char *arg3_pstr = "";
  if(jarg3) {
    arg3_pstr = (const char *)jenv->GetStringUTFChars(jarg3, 0);
  }
  if (!arg3_pstr) return 0;
  std::string arg3_str(arg3_pstr);
  arg3 = &arg3_str;
  if (jarg3) {
    jenv->ReleaseStringUTFChars(jarg3, arg3_pstr);
  }
  
  arg4 = (u_int32_t)jarg4; 
  
  if (!jarg1) {
    jenv->Throw((jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INVALID_VALUE,
        jenv->NewStringUTF("null object - call after object destroyed?"),
        0, 0, 0, 0));					
    return 0;
  }
  
  {
    jthrowable t = NULL;
    try {
      result = XmlContainer_putDocument__SWIG_0(arg1,(std::string const &)*arg2,(std::string const &)*arg3,arg4);
    }
    catch (std::exception &se) {
      t = createException(jenv, &se);
      jenv->Throw(t);
      return 0;
    }
    catch(JavaException & /* je */) {
      // This means there's already an exception waiting in the JVM
      return 0;
    }
    catch (...) {
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("Uncaught exception from C++ API"), 0, 0, 0, 0);
      jenv->Throw(t);
      return 0;
    }
  }
  jresult = jenv->NewStringUTF((&result)->c_str()); 
  return jresult;
}


SWIGEXPORT jstring JNICALL Java_com_sleepycat_dbxml_dbxml_1javaJNI_XmlContainer_1putDocument_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2, jlong jarg3, jobject jarg3_, jint jarg4) {
  jstring jresult = 0 ;
  XmlContainer *arg1 = (XmlContainer *) 0 ;
  std::string *arg2 = 0 ;
  XmlEventReader *arg3 = 0 ;
  u_int32_t arg4 ;
  std::string result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg3_;
  arg1 = *(XmlContainer **)&jarg1; 
  
  const char *arg2_pstr = "";
  if(jarg2) {
    arg2_pstr = (const char *)jenv->GetStringUTFChars(jarg2, 0);
  }
  if (!arg2_pstr) return 0;
  std::string arg2_str(arg2_pstr);
  arg2 = &arg2_str;
  if (jarg2) {
    jenv->ReleaseStringUTFChars(jarg2, arg2_pstr);
  }
  
  arg3 = *(XmlEventReader **)&jarg3;
  if(!arg3) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "XmlEventReader & reference is null");
    return 0;
  } 
  arg4 = (u_int32_t)jarg4; 
  
  if (!jarg1) {
    jenv->Throw((jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INVALID_VALUE,
        jenv->NewStringUTF("null object - call after object destroyed?"),
        0, 0, 0, 0));					
    return 0;
  }
  
  {
    jthrowable t = NULL;
    try {
      result = XmlContainer_putDocument__SWIG_1(arg1,(std::string const &)*arg2,*arg3,arg4);
    }
    catch (std::exception &se) {
      t = createException(jenv, &se);
      jenv->Throw(t);
      return 0;
    }
    catch(JavaException & /* je */) {
      // This means there's already an exception waiting in the JVM
      return 0;
    }
    catch (...) {
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("Uncaught exception from C++ API"), 0, 0, 0, 0);
      jenv->Throw(t);
      return 0;
    }
  }
  jresult = jenv->NewStringUTF((&result)->c_str()); 
  return jresult;
}


SWIGEXPORT jstring JNICALL Java_com_sleepycat_dbxml_dbxml_1javaJNI_XmlContainer_1putDocument_1_1SWIG_12(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2, jlong jarg3, jobject jarg3_, jint jarg4) {
  jstring jresult = 0 ;
  XmlContainer *arg1 = (XmlContainer *) 0 ;
  std::string *arg2 = 0 ;
  XmlInputStream *arg3 = (XmlInputStream *) 0 ;
  u_int32_t arg4 ;
  std::string result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg3_;
  arg1 = *(XmlContainer **)&jarg1; 
  
  const char *arg2_pstr = "";
  if(jarg2) {
    arg2_pstr = (const char *)jenv->GetStringUTFChars(jarg2, 0);
  }
  if (!arg2_pstr) return 0;
  std::string arg2_str(arg2_pstr);
  arg2 = &arg2_str;
  if (jarg2) {
    jenv->ReleaseStringUTFChars(jarg2, arg2_pstr);
  }
  
  arg3 = *(XmlInputStream **)&jarg3; 
  arg4 = (u_int32_t)jarg4; 
  
  if (!jarg1) {
    jenv->Throw((jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INVALID_VALUE,
        jenv->NewStringUTF("null object - call after object destroyed?"),
        0, 0, 0, 0));					
    return 0;
  }
  
  {
    jthrowable t = NULL;
    try {
      result = XmlContainer_putDocument__SWIG_2(arg1,(std::string const &)*arg2,arg3,arg4);
    }
    catch (std::exception &se) {
      t = createException(jenv, &se);
      jenv->Throw(t);
      return 0;
    }
    catch(JavaException & /* je */) {
      // This means there's already an exception waiting in the JVM
      return 0;
    }
    catch (...) {
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("Uncaught exception from C++ API"), 0, 0, 0, 0);
      jenv->Throw(t);
      return 0;
    }
  }
  jresult = jenv->NewStringUTF((&result)->c_str()); 
  return jresult;
}


SWIGEXPORT jstring JNICALL Java_com_sleepycat_dbxml_dbxml_1javaJNI_XmlContainer_1putDocument_1_1SWIG_13(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_, jstring jarg3, jlong jarg4, jobject jarg4_, jint jarg5) {
  jstring jresult = 0 ;
  XmlContainer *arg1 = (XmlContainer *) 0 ;
  XmlTransaction *arg2 = 0 ;
  std::string *arg3 = 0 ;
  XmlInputStream *arg4 = (XmlInputStream *) 0 ;
  u_int32_t arg5 ;
  std::string result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  (void)jarg4_;
  arg1 = *(XmlContainer **)&jarg1; 
  arg2 = *(XmlTransaction **)&jarg2;
  if(!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "XmlTransaction & reference is null");
    return 0;
  } 
  
  const char *arg3_pstr = "";
  if(jarg3) {
    arg3_pstr = (const char *)jenv->GetStringUTFChars(jarg3, 0);
  }
  if (!arg3_pstr) return 0;
  std::string arg3_str(arg3_pstr);
  arg3 = &arg3_str;
  if (jarg3) {
    jenv->ReleaseStringUTFChars(jarg3, arg3_pstr);
  }
  
  arg4 = *(XmlInputStream **)&jarg4; 
  arg5 = (u_int32_t)jarg5; 
  
  if (!jarg1) {
    jenv->Throw((jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INVALID_VALUE,
        jenv->NewStringUTF("null object - call after object destroyed?"),
        0, 0, 0, 0));					
    return 0;
  }
  
  {
    jthrowable t = NULL;
    try {
      result = XmlContainer_putDocument__SWIG_3(arg1,*arg2,(std::string const &)*arg3,arg4,arg5);
    }
    catch (std::exception &se) {
      t = createException(jenv, &se);
      jenv->Throw(t);
      return 0;
    }
    catch(JavaException & /* je */) {
      // This means there's already an exception waiting in the JVM
      return 0;
    }
    catch (...) {
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("Uncaught exception from C++ API"), 0, 0, 0, 0);
      jenv->Throw(t);
      return 0;
    }
  }
  jresult = jenv->NewStringUTF((&result)->c_str()); 
  return jresult;
}


SWIGEXPORT jstring JNICALL Java_com_sleepycat_dbxml_dbxml_1javaJNI_XmlContainer_1putDocument_1_1SWIG_14(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_, jstring jarg3, jstring jarg4, jint jarg5) {
  jstring jresult = 0 ;
  XmlContainer *arg1 = (XmlContainer *) 0 ;
  XmlTransaction *arg2 = 0 ;
  std::string *arg3 = 0 ;
  std::string *arg4 = 0 ;
  u_int32_t arg5 ;
  std::string result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(XmlContainer **)&jarg1; 
  arg2 = *(XmlTransaction **)&jarg2;
  if(!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "XmlTransaction & reference is null");
    return 0;
  } 
  
  const char *arg3_pstr = "";
  if(jarg3) {
    arg3_pstr = (const char *)jenv->GetStringUTFChars(jarg3, 0);
  }
  if (!arg3_pstr) return 0;
  std::string arg3_str(arg3_pstr);
  arg3 = &arg3_str;
  if (jarg3) {
    jenv->ReleaseStringUTFChars(jarg3, arg3_pstr);
  }
  
  
  const char *arg4_pstr = "";
  if(jarg4) {
    arg4_pstr = (const char *)jenv->GetStringUTFChars(jarg4, 0);
  }
  if (!arg4_pstr) return 0;
  std::string arg4_str(arg4_pstr);
  arg4 = &arg4_str;
  if (jarg4) {
    jenv->ReleaseStringUTFChars(jarg4, arg4_pstr);
  }
  
  arg5 = (u_int32_t)jarg5; 
  
  if (!jarg1) {
    jenv->Throw((jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INVALID_VALUE,
        jenv->NewStringUTF("null object - call after object destroyed?"),
        0, 0, 0, 0));					
    return 0;
  }
  
  {
    jthrowable t = NULL;
    try {
      result = XmlContainer_putDocument__SWIG_4(arg1,*arg2,(std::string const &)*arg3,(std::string const &)*arg4,arg5);
    }
    catch (std::exception &se) {
      t = createException(jenv, &se);
      jenv->Throw(t);
      return 0;
    }
    catch(JavaException & /* je */) {
      // This means there's already an exception waiting in the JVM
      return 0;
    }
    catch (...) {
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("Uncaught exception from C++ API"), 0, 0, 0, 0);
      jenv->Throw(t);
      return 0;
    }
  }
  jresult = jenv->NewStringUTF((&result)->c_str()); 
  return jresult;
}


SWIGEXPORT jstring JNICALL Java_com_sleepycat_dbxml_dbxml_1javaJNI_XmlContainer_1putDocument_1_1SWIG_15(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_, jstring jarg3, jlong jarg4, jobject jarg4_, jint jarg5) {
  jstring jresult = 0 ;
  XmlContainer *arg1 = (XmlContainer *) 0 ;
  XmlTransaction *arg2 = 0 ;
  std::string *arg3 = 0 ;
  XmlEventReader *arg4 = 0 ;
  u_int32_t arg5 ;
  std::string result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  (void)jarg4_;
  arg1 = *(XmlContainer **)&jarg1; 
  arg2 = *(XmlTransaction **)&jarg2;
  if(!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "XmlTransaction & reference is null");
    return 0;
  } 
  
  const char *arg3_pstr = "";
  if(jarg3) {
    arg3_pstr = (const char *)jenv->GetStringUTFChars(jarg3, 0);
  }
  if (!arg3_pstr) return 0;
  std::string arg3_str(arg3_pstr);
  arg3 = &arg3_str;
  if (jarg3) {
    jenv->ReleaseStringUTFChars(jarg3, arg3_pstr);
  }
  
  arg4 = *(XmlEventReader **)&jarg4;
  if(!arg4) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "XmlEventReader & reference is null");
    return 0;
  } 
  arg5 = (u_int32_t)jarg5; 
  
  if (!jarg1) {
    jenv->Throw((jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INVALID_VALUE,
        jenv->NewStringUTF("null object - call after object destroyed?"),
        0, 0, 0, 0));					
    return 0;
  }
  
  {
    jthrowable t = NULL;
    try {
      result = XmlContainer_putDocument__SWIG_5(arg1,*arg2,(std::string const &)*arg3,*arg4,arg5);
    }
    catch (std::exception &se) {
      t = createException(jenv, &se);
      jenv->Throw(t);
      return 0;
    }
    catch(JavaException & /* je */) {
      // This means there's already an exception waiting in the JVM
      return 0;
    }
    catch (...) {
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("Uncaught exception from C++ API"), 0, 0, 0, 0);
      jenv->Throw(t);
      return 0;
    }
  }
  jresult = jenv->NewStringUTF((&result)->c_str()); 
  return jresult;
}


SWIGEXPORT jobject JNICALL Java_com_sleepycat_dbxml_dbxml_1javaJNI_XmlContainer_1getDocumentInternal_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2, jint jarg3) {
  jobject jresult = 0 ;
  XmlContainer *arg1 = (XmlContainer *) 0 ;
  std::string *arg2 = 0 ;
  u_int32_t arg3 ;
  XmlDocument result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(XmlContainer **)&jarg1; 
  
  const char *arg2_pstr = "";
  if(jarg2) {
    arg2_pstr = (const char *)jenv->GetStringUTFChars(jarg2, 0);
  }
  if (!arg2_pstr) return 0;
  std::string arg2_str(arg2_pstr);
  arg2 = &arg2_str;
  if (jarg2) {
    jenv->ReleaseStringUTFChars(jarg2, arg2_pstr);
  }
  
  arg3 = (u_int32_t)jarg3; 
  
  if (!jarg1) {
    jenv->Throw((jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INVALID_VALUE,
        jenv->NewStringUTF("null object - call after object destroyed?"),
        0, 0, 0, 0));					
    return 0;
  }
  
  {
    jthrowable t = NULL;
    try {
      result = XmlContainer_getDocumentInternal__SWIG_0(arg1,(std::string const &)*arg2,arg3);
    }
    catch (std::exception &se) {
      t = createException(jenv, &se);
      jenv->Throw(t);
      return 0;
    }
    catch(JavaException & /* je */) {
      // This means there's already an exception waiting in the JVM
      return 0;
    }
    catch (...) {
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("Uncaught exception from C++ API"), 0, 0, 0, 0);
      jenv->Throw(t);
      return 0;
    }
  }
  {
    jresult = createJavaXmlDocument(jenv, result);
  }
  return jresult;
}


SWIGEXPORT jobject JNICALL Java_com_sleepycat_dbxml_dbxml_1javaJNI_XmlContainer_1getDocumentInternal_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_, jstring jarg3, jint jarg4) {
  jobject jresult = 0 ;
  XmlContainer *arg1 = (XmlContainer *) 0 ;
  XmlTransaction *arg2 = 0 ;
  std::string *arg3 = 0 ;
  u_int32_t arg4 ;
  XmlDocument result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(XmlContainer **)&jarg1; 
  arg2 = *(XmlTransaction **)&jarg2;
  if(!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "XmlTransaction & reference is null");
    return 0;
  } 
  
  const char *arg3_pstr = "";
  if(jarg3) {
    arg3_pstr = (const char *)jenv->GetStringUTFChars(jarg3, 0);
  }
  if (!arg3_pstr) return 0;
  std::string arg3_str(arg3_pstr);
  arg3 = &arg3_str;
  if (jarg3) {
    jenv->ReleaseStringUTFChars(jarg3, arg3_pstr);
  }
  
  arg4 = (u_int32_t)jarg4; 
  
  if (!jarg1) {
    jenv->Throw((jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INVALID_VALUE,
        jenv->NewStringUTF("null object - call after object destroyed?"),
        0, 0, 0, 0));					
    return 0;
  }
  
  {
    jthrowable t = NULL;
    try {
      result = XmlContainer_getDocumentInternal__SWIG_1(arg1,*arg2,(std::string const &)*arg3,arg4);
    }
    catch (std::exception &se) {
      t = createException(jenv, &se);
      jenv->Throw(t);
      return 0;
    }
    catch(JavaException & /* je */) {
      // This means there's already an exception waiting in the JVM
      return 0;
    }
    catch (...) {
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("Uncaught exception from C++ API"), 0, 0, 0, 0);
      jenv->Throw(t);
      return 0;
    }
  }
  {
    jresult = createJavaXmlDocument(jenv, result);
  }
  return jresult;
}


SWIGEXPORT jobject JNICALL Java_com_sleepycat_dbxml_dbxml_1javaJNI_XmlContainer_1putDocumentInternal_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jobject jarg2, jint jarg3) {
  jobject jresult = 0 ;
  XmlContainer *arg1 = (XmlContainer *) 0 ;
  XmlDocument *arg2 = 0 ;
  u_int32_t arg3 ;
  XmlDocument *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(XmlContainer **)&jarg1; 
  
  XmlDocument cdoc2 = createCPPXmlDocument(jenv, jarg2);
  if (cdoc2.isNull()) return 0;
  arg2 = &cdoc2;
  
  arg3 = (u_int32_t)jarg3; 
  
  if (!jarg1) {
    jenv->Throw((jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INVALID_VALUE,
        jenv->NewStringUTF("null object - call after object destroyed?"),
        0, 0, 0, 0));					
    return 0;
  }
  
  {
    jthrowable t = NULL;
    try {
      result = (XmlDocument *) &XmlContainer_putDocumentInternal__SWIG_0(arg1,*arg2,arg3);
    }
    catch (std::exception &se) {
      t = createException(jenv, &se);
      jenv->Throw(t);
      return 0;
    }
    catch(JavaException & /* je */) {
      // This means there's already an exception waiting in the JVM
      return 0;
    }
    catch (...) {
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("Uncaught exception from C++ API"), 0, 0, 0, 0);
      jenv->Throw(t);
      return 0;
    }
  }
  {
    jresult = createJavaXmlDocument(jenv, *result);
  }
  return jresult;
}


SWIGEXPORT jobject JNICALL Java_com_sleepycat_dbxml_dbxml_1javaJNI_XmlContainer_1putDocumentInternal_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_, jobject jarg3, jint jarg4) {
  jobject jresult = 0 ;
  XmlContainer *arg1 = (XmlContainer *) 0 ;
  XmlTransaction *arg2 = 0 ;
  XmlDocument *arg3 = 0 ;
  u_int32_t arg4 ;
  XmlDocument *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(XmlContainer **)&jarg1; 
  arg2 = *(XmlTransaction **)&jarg2;
  if(!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "XmlTransaction & reference is null");
    return 0;
  } 
  
  XmlDocument cdoc3 = createCPPXmlDocument(jenv, jarg3);
  if (cdoc3.isNull()) return 0;
  arg3 = &cdoc3;
  
  arg4 = (u_int32_t)jarg4; 
  
  if (!jarg1) {
    jenv->Throw((jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INVALID_VALUE,
        jenv->NewStringUTF("null object - call after object destroyed?"),
        0, 0, 0, 0));					
    return 0;
  }
  
  {
    jthrowable t = NULL;
    try {
      result = (XmlDocument *) &XmlContainer_putDocumentInternal__SWIG_1(arg1,*arg2,*arg3,arg4);
    }
    catch (std::exception &se) {
      t = createException(jenv, &se);
      jenv->Throw(t);
      return 0;
    }
    catch(JavaException & /* je */) {
      // This means there's already an exception waiting in the JVM
      return 0;
    }
    catch (...) {
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("Uncaught exception from C++ API"), 0, 0, 0, 0);
      jenv->Throw(t);
      return 0;
    }
  }
  {
    jresult = createJavaXmlDocument(jenv, *result);
  }
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_sleepycat_dbxml_dbxml_1javaJNI_XmlContainer_1putDocumentAsEventWriter_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jobject jarg2, jint jarg3, jlongArray jarg4) {
  jlong jresult = 0 ;
  XmlContainer *arg1 = (XmlContainer *) 0 ;
  XmlDocument *arg2 = 0 ;
  u_int32_t arg3 ;
  u_int64_t *arg4 = (u_int64_t *) 0 ;
  XmlEventWriter *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(XmlContainer **)&jarg1; 
  
  XmlDocument cdoc2 = createCPPXmlDocument(jenv, jarg2);
  if (cdoc2.isNull()) return 0;
  arg2 = &cdoc2;
  
  arg3 = (u_int32_t)jarg3; 
  
  jlong *jids4 = jenv->GetLongArrayElements(jarg4, (jboolean *)0);
  arg4 = (u_int64_t*)jids4;
  
  
  if (!jarg1) {
    jenv->Throw((jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INVALID_VALUE,
        jenv->NewStringUTF("null object - call after object destroyed?"),
        0, 0, 0, 0));					
    return 0;
  }
  
  {
    jthrowable t = NULL;
    try {
      result = (XmlEventWriter *) &XmlContainer_putDocumentAsEventWriter__SWIG_0(arg1,*arg2,arg3,arg4);
    }
    catch (std::exception &se) {
      t = createException(jenv, &se);
      jenv->Throw(t);
      return 0;
    }
    catch(JavaException & /* je */) {
      // This means there's already an exception waiting in the JVM
      return 0;
    }
    catch (...) {
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("Uncaught exception from C++ API"), 0, 0, 0, 0);
      jenv->Throw(t);
      return 0;
    }
  }
  *(XmlEventWriter **)&jresult = result; 
  
  jenv->ReleaseLongArrayElements(jarg4, jids4, 0);
  
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_sleepycat_dbxml_dbxml_1javaJNI_XmlContainer_1putDocumentAsEventWriter_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_, jobject jarg3, jint jarg4, jlongArray jarg5) {
  jlong jresult = 0 ;
  XmlContainer *arg1 = (XmlContainer *) 0 ;
  XmlTransaction *arg2 = 0 ;
  XmlDocument *arg3 = 0 ;
  u_int32_t arg4 ;
  u_int64_t *arg5 = (u_int64_t *) 0 ;
  XmlEventWriter *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(XmlContainer **)&jarg1; 
  arg2 = *(XmlTransaction **)&jarg2;
  if(!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "XmlTransaction & reference is null");
    return 0;
  } 
  
  XmlDocument cdoc3 = createCPPXmlDocument(jenv, jarg3);
  if (cdoc3.isNull()) return 0;
  arg3 = &cdoc3;
  
  arg4 = (u_int32_t)jarg4; 
  
  jlong *jids5 = jenv->GetLongArrayElements(jarg5, (jboolean *)0);
  arg5 = (u_int64_t*)jids5;
  
  
  if (!jarg1) {
    jenv->Throw((jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INVALID_VALUE,
        jenv->NewStringUTF("null object - call after object destroyed?"),
        0, 0, 0, 0));					
    return 0;
  }
  
  {
    jthrowable t = NULL;
    try {
      result = (XmlEventWriter *) &XmlContainer_putDocumentAsEventWriter__SWIG_1(arg1,*arg2,*arg3,arg4,arg5);
    }
    catch (std::exception &se) {
      t = createException(jenv, &se);
      jenv->Throw(t);
      return 0;
    }
    catch(JavaException & /* je */) {
      // This means there's already an exception waiting in the JVM
      return 0;
    }
    catch (...) {
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("Uncaught exception from C++ API"), 0, 0, 0, 0);
      jenv->Throw(t);
      return 0;
    }
  }
  *(XmlEventWriter **)&jresult = result; 
  
  jenv->ReleaseLongArrayElements(jarg5, jids5, 0);
  
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_sleepycat_dbxml_dbxml_1javaJNI_XmlContainer_1deleteDocument_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2) {
  XmlContainer *arg1 = (XmlContainer *) 0 ;
  std::string *arg2 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(XmlContainer **)&jarg1; 
  
  const char *arg2_pstr = "";
  if(jarg2) {
    arg2_pstr = (const char *)jenv->GetStringUTFChars(jarg2, 0);
  }
  if (!arg2_pstr) return ;
  std::string arg2_str(arg2_pstr);
  arg2 = &arg2_str;
  if (jarg2) {
    jenv->ReleaseStringUTFChars(jarg2, arg2_pstr);
  }
  
  
  if (!jarg1) {
    jenv->Throw((jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INVALID_VALUE,
        jenv->NewStringUTF("null object - call after object destroyed?"),
        0, 0, 0, 0));					
    return ;
  }
  
  {
    jthrowable t = NULL;
    try {
      XmlContainer_deleteDocument__SWIG_0(arg1,(std::string const &)*arg2);
    }
    catch (std::exception &se) {
      t = createException(jenv, &se);
      jenv->Throw(t);
      return ;
    }
    catch(JavaException & /* je */) {
      // This means there's already an exception waiting in the JVM
      return ;
    }
    catch (...) {
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("Uncaught exception from C++ API"), 0, 0, 0, 0);
      jenv->Throw(t);
      return ;
    }
  }
}


SWIGEXPORT void JNICALL Java_com_sleepycat_dbxml_dbxml_1javaJNI_XmlContainer_1deleteDocument_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_, jstring jarg3) {
  XmlContainer *arg1 = (XmlContainer *) 0 ;
  XmlTransaction *arg2 = 0 ;
  std::string *arg3 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(XmlContainer **)&jarg1; 
  arg2 = *(XmlTransaction **)&jarg2;
  if(!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "XmlTransaction & reference is null");
    return ;
  } 
  
  const char *arg3_pstr = "";
  if(jarg3) {
    arg3_pstr = (const char *)jenv->GetStringUTFChars(jarg3, 0);
  }
  if (!arg3_pstr) return ;
  std::string arg3_str(arg3_pstr);
  arg3 = &arg3_str;
  if (jarg3) {
    jenv->ReleaseStringUTFChars(jarg3, arg3_pstr);
  }
  
  
  if (!jarg1) {
    jenv->Throw((jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INVALID_VALUE,
        jenv->NewStringUTF("null object - call after object destroyed?"),
        0, 0, 0, 0));					
    return ;
  }
  
  {
    jthrowable t = NULL;
    try {
      XmlContainer_deleteDocument__SWIG_1(arg1,*arg2,(std::string const &)*arg3);
    }
    catch (std::exception &se) {
      t = createException(jenv, &se);
      jenv->Throw(t);
      return ;
    }
    catch(JavaException & /* je */) {
      // This means there's already an exception waiting in the JVM
      return ;
    }
    catch (...) {
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("Uncaught exception from C++ API"), 0, 0, 0, 0);
      jenv->Throw(t);
      return ;
    }
  }
}


SWIGEXPORT jobject JNICALL Java_com_sleepycat_dbxml_dbxml_1javaJNI_XmlContainer_1deleteDocumentInternal_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jobject jarg2) {
  jobject jresult = 0 ;
  XmlContainer *arg1 = (XmlContainer *) 0 ;
  XmlDocument *arg2 = 0 ;
  XmlDocument *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(XmlContainer **)&jarg1; 
  
  XmlDocument cdoc2 = createCPPXmlDocument(jenv, jarg2);
  if (cdoc2.isNull()) return 0;
  arg2 = &cdoc2;
  
  
  if (!jarg1) {
    jenv->Throw((jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INVALID_VALUE,
        jenv->NewStringUTF("null object - call after object destroyed?"),
        0, 0, 0, 0));					
    return 0;
  }
  
  {
    jthrowable t = NULL;
    try {
      result = (XmlDocument *) &XmlContainer_deleteDocumentInternal__SWIG_0(arg1,*arg2);
    }
    catch (std::exception &se) {
      t = createException(jenv, &se);
      jenv->Throw(t);
      return 0;
    }
    catch(JavaException & /* je */) {
      // This means there's already an exception waiting in the JVM
      return 0;
    }
    catch (...) {
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("Uncaught exception from C++ API"), 0, 0, 0, 0);
      jenv->Throw(t);
      return 0;
    }
  }
  {
    jresult = createJavaXmlDocument(jenv, *result);
  }
  return jresult;
}


SWIGEXPORT jobject JNICALL Java_com_sleepycat_dbxml_dbxml_1javaJNI_XmlContainer_1deleteDocumentInternal_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_, jobject jarg3) {
  jobject jresult = 0 ;
  XmlContainer *arg1 = (XmlContainer *) 0 ;
  XmlTransaction *arg2 = 0 ;
  XmlDocument *arg3 = 0 ;
  XmlDocument *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(XmlContainer **)&jarg1; 
  arg2 = *(XmlTransaction **)&jarg2;
  if(!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "XmlTransaction & reference is null");
    return 0;
  } 
  
  XmlDocument cdoc3 = createCPPXmlDocument(jenv, jarg3);
  if (cdoc3.isNull()) return 0;
  arg3 = &cdoc3;
  
  
  if (!jarg1) {
    jenv->Throw((jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INVALID_VALUE,
        jenv->NewStringUTF("null object - call after object destroyed?"),
        0, 0, 0, 0));					
    return 0;
  }
  
  {
    jthrowable t = NULL;
    try {
      result = (XmlDocument *) &XmlContainer_deleteDocumentInternal__SWIG_1(arg1,*arg2,*arg3);
    }
    catch (std::exception &se) {
      t = createException(jenv, &se);
      jenv->Throw(t);
      return 0;
    }
    catch(JavaException & /* je */) {
      // This means there's already an exception waiting in the JVM
      return 0;
    }
    catch (...) {
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("Uncaught exception from C++ API"), 0, 0, 0, 0);
      jenv->Throw(t);
      return 0;
    }
  }
  {
    jresult = createJavaXmlDocument(jenv, *result);
  }
  return jresult;
}


SWIGEXPORT jobject JNICALL Java_com_sleepycat_dbxml_dbxml_1javaJNI_XmlContainer_1updateDocumentInternal_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jobject jarg2) {
  jobject jresult = 0 ;
  XmlContainer *arg1 = (XmlContainer *) 0 ;
  XmlDocument *arg2 = 0 ;
  XmlDocument *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(XmlContainer **)&jarg1; 
  
  XmlDocument cdoc2 = createCPPXmlDocument(jenv, jarg2);
  if (cdoc2.isNull()) return 0;
  arg2 = &cdoc2;
  
  
  if (!jarg1) {
    jenv->Throw((jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INVALID_VALUE,
        jenv->NewStringUTF("null object - call after object destroyed?"),
        0, 0, 0, 0));					
    return 0;
  }
  
  {
    jthrowable t = NULL;
    try {
      result = (XmlDocument *) &XmlContainer_updateDocumentInternal__SWIG_0(arg1,*arg2);
    }
    catch (std::exception &se) {
      t = createException(jenv, &se);
      jenv->Throw(t);
      return 0;
    }
    catch(JavaException & /* je */) {
      // This means there's already an exception waiting in the JVM
      return 0;
    }
    catch (...) {
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("Uncaught exception from C++ API"), 0, 0, 0, 0);
      jenv->Throw(t);
      return 0;
    }
  }
  {
    jresult = createJavaXmlDocument(jenv, *result);
  }
  return jresult;
}


SWIGEXPORT jobject JNICALL Java_com_sleepycat_dbxml_dbxml_1javaJNI_XmlContainer_1updateDocumentInternal_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_, jobject jarg3) {
  jobject jresult = 0 ;
  XmlContainer *arg1 = (XmlContainer *) 0 ;
  XmlTransaction *arg2 = 0 ;
  XmlDocument *arg3 = 0 ;
  XmlDocument *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(XmlContainer **)&jarg1; 
  arg2 = *(XmlTransaction **)&jarg2;
  if(!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "XmlTransaction & reference is null");
    return 0;
  } 
  
  XmlDocument cdoc3 = createCPPXmlDocument(jenv, jarg3);
  if (cdoc3.isNull()) return 0;
  arg3 = &cdoc3;
  
  
  if (!jarg1) {
    jenv->Throw((jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INVALID_VALUE,
        jenv->NewStringUTF("null object - call after object destroyed?"),
        0, 0, 0, 0));					
    return 0;
  }
  
  {
    jthrowable t = NULL;
    try {
      result = (XmlDocument *) &XmlContainer_updateDocumentInternal__SWIG_1(arg1,*arg2,*arg3);
    }
    catch (std::exception &se) {
      t = createException(jenv, &se);
      jenv->Throw(t);
      return 0;
    }
    catch(JavaException & /* je */) {
      // This means there's already an exception waiting in the JVM
      return 0;
    }
    catch (...) {
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("Uncaught exception from C++ API"), 0, 0, 0, 0);
      jenv->Throw(t);
      return 0;
    }
  }
  {
    jresult = createJavaXmlDocument(jenv, *result);
  }
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_sleepycat_dbxml_dbxml_1javaJNI_XmlContainer_1getNode_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2) {
  jlong jresult = 0 ;
  XmlContainer *arg1 = (XmlContainer *) 0 ;
  std::string *arg2 = 0 ;
  XmlResults result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(XmlContainer **)&jarg1; 
  
  const char *arg2_pstr = "";
  if(jarg2) {
    arg2_pstr = (const char *)jenv->GetStringUTFChars(jarg2, 0);
  }
  if (!arg2_pstr) return 0;
  std::string arg2_str(arg2_pstr);
  arg2 = &arg2_str;
  if (jarg2) {
    jenv->ReleaseStringUTFChars(jarg2, arg2_pstr);
  }
  
  
  if (!jarg1) {
    jenv->Throw((jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INVALID_VALUE,
        jenv->NewStringUTF("null object - call after object destroyed?"),
        0, 0, 0, 0));					
    return 0;
  }
  
  {
    jthrowable t = NULL;
    try {
      result = XmlContainer_getNode__SWIG_0(arg1,(std::string const &)*arg2);
    }
    catch (std::exception &se) {
      t = createException(jenv, &se);
      jenv->Throw(t);
      return 0;
    }
    catch(JavaException & /* je */) {
      // This means there's already an exception waiting in the JVM
      return 0;
    }
    catch (...) {
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("Uncaught exception from C++ API"), 0, 0, 0, 0);
      jenv->Throw(t);
      return 0;
    }
  }
  *(XmlResults **)&jresult = new XmlResults((const XmlResults &)result); 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_sleepycat_dbxml_dbxml_1javaJNI_XmlContainer_1getNode_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_, jstring jarg3, jint jarg4) {
  jlong jresult = 0 ;
  XmlContainer *arg1 = (XmlContainer *) 0 ;
  XmlTransaction *arg2 = 0 ;
  std::string *arg3 = 0 ;
  u_int32_t arg4 ;
  XmlResults result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(XmlContainer **)&jarg1; 
  arg2 = *(XmlTransaction **)&jarg2;
  if(!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "XmlTransaction & reference is null");
    return 0;
  } 
  
  const char *arg3_pstr = "";
  if(jarg3) {
    arg3_pstr = (const char *)jenv->GetStringUTFChars(jarg3, 0);
  }
  if (!arg3_pstr) return 0;
  std::string arg3_str(arg3_pstr);
  arg3 = &arg3_str;
  if (jarg3) {
    jenv->ReleaseStringUTFChars(jarg3, arg3_pstr);
  }
  
  arg4 = (u_int32_t)jarg4; 
  
  if (!jarg1) {
    jenv->Throw((jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INVALID_VALUE,
        jenv->NewStringUTF("null object - call after object destroyed?"),
        0, 0, 0, 0));					
    return 0;
  }
  
  {
    jthrowable t = NULL;
    try {
      result = XmlContainer_getNode__SWIG_1(arg1,*arg2,(std::string const &)*arg3,arg4);
    }
    catch (std::exception &se) {
      t = createException(jenv, &se);
      jenv->Throw(t);
      return 0;
    }
    catch(JavaException & /* je */) {
      // This means there's already an exception waiting in the JVM
      return 0;
    }
    catch (...) {
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("Uncaught exception from C++ API"), 0, 0, 0, 0);
      jenv->Throw(t);
      return 0;
    }
  }
  *(XmlResults **)&jresult = new XmlResults((const XmlResults &)result); 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_sleepycat_dbxml_dbxml_1javaJNI_delete_1XmlResults(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  XmlResults *arg1 = (XmlResults *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(XmlResults **)&jarg1; 
  
  if (!jarg1) {
    jenv->Throw((jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INVALID_VALUE,
        jenv->NewStringUTF("null object - call after object destroyed?"),
        0, 0, 0, 0));					
    return ;
  }
  
  {
    jthrowable t = NULL;
    try {
      delete arg1;
    }
    catch (std::exception &se) {
      t = createException(jenv, &se);
      jenv->Throw(t);
      return ;
    }
    catch(JavaException & /* je */) {
      // This means there's already an exception waiting in the JVM
      return ;
    }
    catch (...) {
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("Uncaught exception from C++ API"), 0, 0, 0, 0);
      jenv->Throw(t);
      return ;
    }
  }
}


SWIGEXPORT jboolean JNICALL Java_com_sleepycat_dbxml_dbxml_1javaJNI_XmlResults_1hasNext(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jboolean jresult = 0 ;
  XmlResults *arg1 = (XmlResults *) 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(XmlResults **)&jarg1; 
  
  if (!jarg1) {
    jenv->Throw((jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INVALID_VALUE,
        jenv->NewStringUTF("null object - call after object destroyed?"),
        0, 0, 0, 0));					
    return 0;
  }
  
  {
    jthrowable t = NULL;
    try {
      result = (bool)(arg1)->hasNext();
    }
    catch (std::exception &se) {
      t = createException(jenv, &se);
      jenv->Throw(t);
      return 0;
    }
    catch(JavaException & /* je */) {
      // This means there's already an exception waiting in the JVM
      return 0;
    }
    catch (...) {
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("Uncaught exception from C++ API"), 0, 0, 0, 0);
      jenv->Throw(t);
      return 0;
    }
  }
  
  jresult = result ? JNI_TRUE : JNI_FALSE;
  
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_com_sleepycat_dbxml_dbxml_1javaJNI_XmlResults_1hasPrevious(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jboolean jresult = 0 ;
  XmlResults *arg1 = (XmlResults *) 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(XmlResults **)&jarg1; 
  
  if (!jarg1) {
    jenv->Throw((jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INVALID_VALUE,
        jenv->NewStringUTF("null object - call after object destroyed?"),
        0, 0, 0, 0));					
    return 0;
  }
  
  {
    jthrowable t = NULL;
    try {
      result = (bool)(arg1)->hasPrevious();
    }
    catch (std::exception &se) {
      t = createException(jenv, &se);
      jenv->Throw(t);
      return 0;
    }
    catch(JavaException & /* je */) {
      // This means there's already an exception waiting in the JVM
      return 0;
    }
    catch (...) {
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("Uncaught exception from C++ API"), 0, 0, 0, 0);
      jenv->Throw(t);
      return 0;
    }
  }
  
  jresult = result ? JNI_TRUE : JNI_FALSE;
  
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_com_sleepycat_dbxml_dbxml_1javaJNI_XmlResults_1isNull(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jboolean jresult = 0 ;
  XmlResults *arg1 = (XmlResults *) 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(XmlResults **)&jarg1; 
  
  if (!jarg1) {
    jenv->Throw((jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INVALID_VALUE,
        jenv->NewStringUTF("null object - call after object destroyed?"),
        0, 0, 0, 0));					
    return 0;
  }
  
  {
    jthrowable t = NULL;
    try {
      result = (bool)((XmlResults const *)arg1)->isNull();
    }
    catch (std::exception &se) {
      t = createException(jenv, &se);
      jenv->Throw(t);
      return 0;
    }
    catch(JavaException & /* je */) {
      // This means there's already an exception waiting in the JVM
      return 0;
    }
    catch (...) {
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("Uncaught exception from C++ API"), 0, 0, 0, 0);
      jenv->Throw(t);
      return 0;
    }
  }
  
  jresult = result ? JNI_TRUE : JNI_FALSE;
  
  return jresult;
}


SWIGEXPORT jint JNICALL Java_com_sleepycat_dbxml_dbxml_1javaJNI_XmlResults_1getEvaluationType(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  XmlResults *arg1 = (XmlResults *) 0 ;
  enum XmlQueryContext::EvaluationType result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(XmlResults **)&jarg1; 
  
  if (!jarg1) {
    jenv->Throw((jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INVALID_VALUE,
        jenv->NewStringUTF("null object - call after object destroyed?"),
        0, 0, 0, 0));					
    return 0;
  }
  
  {
    jthrowable t = NULL;
    try {
      result = (enum XmlQueryContext::EvaluationType)((XmlResults const *)arg1)->getEvaluationType();
    }
    catch (std::exception &se) {
      t = createException(jenv, &se);
      jenv->Throw(t);
      return 0;
    }
    catch(JavaException & /* je */) {
      // This means there's already an exception waiting in the JVM
      return 0;
    }
    catch (...) {
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("Uncaught exception from C++ API"), 0, 0, 0, 0);
      jenv->Throw(t);
      return 0;
    }
  }
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_com_sleepycat_dbxml_dbxml_1javaJNI_XmlResults_1size(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  XmlResults *arg1 = (XmlResults *) 0 ;
  size_t result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(XmlResults **)&jarg1; 
  
  if (!jarg1) {
    jenv->Throw((jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INVALID_VALUE,
        jenv->NewStringUTF("null object - call after object destroyed?"),
        0, 0, 0, 0));					
    return 0;
  }
  
  {
    jthrowable t = NULL;
    try {
      result = ((XmlResults const *)arg1)->size();
    }
    catch (std::exception &se) {
      t = createException(jenv, &se);
      jenv->Throw(t);
      return 0;
    }
    catch(JavaException & /* je */) {
      // This means there's already an exception waiting in the JVM
      return 0;
    }
    catch (...) {
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("Uncaught exception from C++ API"), 0, 0, 0, 0);
      jenv->Throw(t);
      return 0;
    }
  }
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_sleepycat_dbxml_dbxml_1javaJNI_XmlResults_1resetInternal(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  XmlResults *arg1 = (XmlResults *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(XmlResults **)&jarg1; 
  
  if (!jarg1) {
    jenv->Throw((jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INVALID_VALUE,
        jenv->NewStringUTF("null object - call after object destroyed?"),
        0, 0, 0, 0));					
    return ;
  }
  
  {
    jthrowable t = NULL;
    try {
      (arg1)->reset();
    }
    catch (std::exception &se) {
      t = createException(jenv, &se);
      jenv->Throw(t);
      return ;
    }
    catch(JavaException & /* je */) {
      // This means there's already an exception waiting in the JVM
      return ;
    }
    catch (...) {
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("Uncaught exception from C++ API"), 0, 0, 0, 0);
      jenv->Throw(t);
      return ;
    }
  }
}


SWIGEXPORT jlong JNICALL Java_com_sleepycat_dbxml_dbxml_1javaJNI_XmlResults_1asEventWriter(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  XmlResults *arg1 = (XmlResults *) 0 ;
  XmlEventWriter *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(XmlResults **)&jarg1; 
  
  if (!jarg1) {
    jenv->Throw((jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INVALID_VALUE,
        jenv->NewStringUTF("null object - call after object destroyed?"),
        0, 0, 0, 0));					
    return 0;
  }
  
  {
    jthrowable t = NULL;
    try {
      result = (XmlEventWriter *) &(arg1)->asEventWriter();
    }
    catch (std::exception &se) {
      t = createException(jenv, &se);
      jenv->Throw(t);
      return 0;
    }
    catch(JavaException & /* je */) {
      // This means there's already an exception waiting in the JVM
      return 0;
    }
    catch (...) {
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("Uncaught exception from C++ API"), 0, 0, 0, 0);
      jenv->Throw(t);
      return 0;
    }
  }
  *(XmlEventWriter **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_sleepycat_dbxml_dbxml_1javaJNI_XmlResults_1copyResults(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  XmlResults *arg1 = (XmlResults *) 0 ;
  XmlResults result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(XmlResults **)&jarg1; 
  
  if (!jarg1) {
    jenv->Throw((jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INVALID_VALUE,
        jenv->NewStringUTF("null object - call after object destroyed?"),
        0, 0, 0, 0));					
    return 0;
  }
  
  {
    jthrowable t = NULL;
    try {
      result = (arg1)->copyResults();
    }
    catch (std::exception &se) {
      t = createException(jenv, &se);
      jenv->Throw(t);
      return 0;
    }
    catch(JavaException & /* je */) {
      // This means there's already an exception waiting in the JVM
      return 0;
    }
    catch (...) {
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("Uncaught exception from C++ API"), 0, 0, 0, 0);
      jenv->Throw(t);
      return 0;
    }
  }
  *(XmlResults **)&jresult = new XmlResults((const XmlResults &)result); 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_sleepycat_dbxml_dbxml_1javaJNI_XmlResults_1concatResults(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  XmlResults *arg1 = (XmlResults *) 0 ;
  XmlResults *arg2 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(XmlResults **)&jarg1; 
  arg2 = *(XmlResults **)&jarg2;
  if(!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "XmlResults & reference is null");
    return ;
  } 
  
  if (!jarg1) {
    jenv->Throw((jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INVALID_VALUE,
        jenv->NewStringUTF("null object - call after object destroyed?"),
        0, 0, 0, 0));					
    return ;
  }
  
  {
    jthrowable t = NULL;
    try {
      (arg1)->concatResults(*arg2);
    }
    catch (std::exception &se) {
      t = createException(jenv, &se);
      jenv->Throw(t);
      return ;
    }
    catch(JavaException & /* je */) {
      // This means there's already an exception waiting in the JVM
      return ;
    }
    catch (...) {
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("Uncaught exception from C++ API"), 0, 0, 0, 0);
      jenv->Throw(t);
      return ;
    }
  }
}


SWIGEXPORT jlong JNICALL Java_com_sleepycat_dbxml_dbxml_1javaJNI_XmlResults_1copy(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  XmlResults *arg1 = 0 ;
  XmlResults *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(XmlResults **)&jarg1;
  if(!arg1) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "XmlResults const & reference is null");
    return 0;
  } 
  {
    jthrowable t = NULL;
    try {
      result = (XmlResults *)XmlResults_copy((XmlResults const &)*arg1);
    }
    catch (std::exception &se) {
      t = createException(jenv, &se);
      jenv->Throw(t);
      return 0;
    }
    catch(JavaException & /* je */) {
      // This means there's already an exception waiting in the JVM
      return 0;
    }
    catch (...) {
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("Uncaught exception from C++ API"), 0, 0, 0, 0);
      jenv->Throw(t);
      return 0;
    }
  }
  *(XmlResults **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jobject JNICALL Java_com_sleepycat_dbxml_dbxml_1javaJNI_XmlResults_1nextInternal(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jobject jresult = 0 ;
  XmlResults *arg1 = (XmlResults *) 0 ;
  XmlValue result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(XmlResults **)&jarg1; 
  
  if (!jarg1) {
    jenv->Throw((jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INVALID_VALUE,
        jenv->NewStringUTF("null object - call after object destroyed?"),
        0, 0, 0, 0));					
    return 0;
  }
  
  {
    jthrowable t = NULL;
    try {
      result = XmlResults_nextInternal(arg1);
    }
    catch (std::exception &se) {
      t = createException(jenv, &se);
      jenv->Throw(t);
      return 0;
    }
    catch(JavaException & /* je */) {
      // This means there's already an exception waiting in the JVM
      return 0;
    }
    catch (...) {
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("Uncaught exception from C++ API"), 0, 0, 0, 0);
      jenv->Throw(t);
      return 0;
    }
  }
  {
    jresult = createJavaXmlValue(jenv, result);
  }
  return jresult;
}


SWIGEXPORT jobject JNICALL Java_com_sleepycat_dbxml_dbxml_1javaJNI_XmlResults_1previousInternal(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jobject jresult = 0 ;
  XmlResults *arg1 = (XmlResults *) 0 ;
  XmlValue result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(XmlResults **)&jarg1; 
  
  if (!jarg1) {
    jenv->Throw((jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INVALID_VALUE,
        jenv->NewStringUTF("null object - call after object destroyed?"),
        0, 0, 0, 0));					
    return 0;
  }
  
  {
    jthrowable t = NULL;
    try {
      result = XmlResults_previousInternal(arg1);
    }
    catch (std::exception &se) {
      t = createException(jenv, &se);
      jenv->Throw(t);
      return 0;
    }
    catch(JavaException & /* je */) {
      // This means there's already an exception waiting in the JVM
      return 0;
    }
    catch (...) {
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("Uncaught exception from C++ API"), 0, 0, 0, 0);
      jenv->Throw(t);
      return 0;
    }
  }
  {
    jresult = createJavaXmlValue(jenv, result);
  }
  return jresult;
}


SWIGEXPORT jobject JNICALL Java_com_sleepycat_dbxml_dbxml_1javaJNI_XmlResults_1peekInternal(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jobject jresult = 0 ;
  XmlResults *arg1 = (XmlResults *) 0 ;
  XmlValue result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(XmlResults **)&jarg1; 
  
  if (!jarg1) {
    jenv->Throw((jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INVALID_VALUE,
        jenv->NewStringUTF("null object - call after object destroyed?"),
        0, 0, 0, 0));					
    return 0;
  }
  
  {
    jthrowable t = NULL;
    try {
      result = XmlResults_peekInternal(arg1);
    }
    catch (std::exception &se) {
      t = createException(jenv, &se);
      jenv->Throw(t);
      return 0;
    }
    catch(JavaException & /* je */) {
      // This means there's already an exception waiting in the JVM
      return 0;
    }
    catch (...) {
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("Uncaught exception from C++ API"), 0, 0, 0, 0);
      jenv->Throw(t);
      return 0;
    }
  }
  {
    jresult = createJavaXmlValue(jenv, result);
  }
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_sleepycat_dbxml_dbxml_1javaJNI_XmlResults_1addInternal(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jobject jarg2) {
  XmlResults *arg1 = (XmlResults *) 0 ;
  XmlValue *arg2 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(XmlResults **)&jarg1; 
  
  bool valid = true;
  XmlValue val2 = createCPPXmlValue(jenv, jarg2, &valid);
  if (!valid) return ;
  arg2 = &val2;
  
  
  if (!jarg1) {
    jenv->Throw((jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INVALID_VALUE,
        jenv->NewStringUTF("null object - call after object destroyed?"),
        0, 0, 0, 0));					
    return ;
  }
  
  {
    jthrowable t = NULL;
    try {
      XmlResults_addInternal(arg1,(XmlValue const &)*arg2);
    }
    catch (std::exception &se) {
      t = createException(jenv, &se);
      jenv->Throw(t);
      return ;
    }
    catch(JavaException & /* je */) {
      // This means there's already an exception waiting in the JVM
      return ;
    }
    catch (...) {
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("Uncaught exception from C++ API"), 0, 0, 0, 0);
      jenv->Throw(t);
      return ;
    }
  }
}


SWIGEXPORT jobject JNICALL Java_com_sleepycat_dbxml_dbxml_1javaJNI_XmlResults_1nextDocumentInternal(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jobject jresult = 0 ;
  XmlResults *arg1 = (XmlResults *) 0 ;
  XmlDocument result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(XmlResults **)&jarg1; 
  
  if (!jarg1) {
    jenv->Throw((jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INVALID_VALUE,
        jenv->NewStringUTF("null object - call after object destroyed?"),
        0, 0, 0, 0));					
    return 0;
  }
  
  {
    jthrowable t = NULL;
    try {
      result = XmlResults_nextDocumentInternal(arg1);
    }
    catch (std::exception &se) {
      t = createException(jenv, &se);
      jenv->Throw(t);
      return 0;
    }
    catch(JavaException & /* je */) {
      // This means there's already an exception waiting in the JVM
      return 0;
    }
    catch (...) {
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("Uncaught exception from C++ API"), 0, 0, 0, 0);
      jenv->Throw(t);
      return 0;
    }
  }
  {
    jresult = createJavaXmlDocument(jenv, result);
  }
  return jresult;
}


SWIGEXPORT jobject JNICALL Java_com_sleepycat_dbxml_dbxml_1javaJNI_XmlResults_1previousDocumentInternal(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jobject jresult = 0 ;
  XmlResults *arg1 = (XmlResults *) 0 ;
  XmlDocument result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(XmlResults **)&jarg1; 
  
  if (!jarg1) {
    jenv->Throw((jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INVALID_VALUE,
        jenv->NewStringUTF("null object - call after object destroyed?"),
        0, 0, 0, 0));					
    return 0;
  }
  
  {
    jthrowable t = NULL;
    try {
      result = XmlResults_previousDocumentInternal(arg1);
    }
    catch (std::exception &se) {
      t = createException(jenv, &se);
      jenv->Throw(t);
      return 0;
    }
    catch(JavaException & /* je */) {
      // This means there's already an exception waiting in the JVM
      return 0;
    }
    catch (...) {
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("Uncaught exception from C++ API"), 0, 0, 0, 0);
      jenv->Throw(t);
      return 0;
    }
  }
  {
    jresult = createJavaXmlDocument(jenv, result);
  }
  return jresult;
}


SWIGEXPORT jobject JNICALL Java_com_sleepycat_dbxml_dbxml_1javaJNI_XmlResults_1peekDocumentInternal(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jobject jresult = 0 ;
  XmlResults *arg1 = (XmlResults *) 0 ;
  XmlDocument result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(XmlResults **)&jarg1; 
  
  if (!jarg1) {
    jenv->Throw((jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INVALID_VALUE,
        jenv->NewStringUTF("null object - call after object destroyed?"),
        0, 0, 0, 0));					
    return 0;
  }
  
  {
    jthrowable t = NULL;
    try {
      result = XmlResults_peekDocumentInternal(arg1);
    }
    catch (std::exception &se) {
      t = createException(jenv, &se);
      jenv->Throw(t);
      return 0;
    }
    catch(JavaException & /* je */) {
      // This means there's already an exception waiting in the JVM
      return 0;
    }
    catch (...) {
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("Uncaught exception from C++ API"), 0, 0, 0, 0);
      jenv->Throw(t);
      return 0;
    }
  }
  {
    jresult = createJavaXmlDocument(jenv, result);
  }
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_sleepycat_dbxml_dbxml_1javaJNI_delete_1XmlIndexSpecification(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  XmlIndexSpecification *arg1 = (XmlIndexSpecification *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(XmlIndexSpecification **)&jarg1; 
  
  if (!jarg1) {
    jenv->Throw((jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INVALID_VALUE,
        jenv->NewStringUTF("null object - call after object destroyed?"),
        0, 0, 0, 0));					
    return ;
  }
  
  {
    jthrowable t = NULL;
    try {
      delete arg1;
    }
    catch (std::exception &se) {
      t = createException(jenv, &se);
      jenv->Throw(t);
      return ;
    }
    catch(JavaException & /* je */) {
      // This means there's already an exception waiting in the JVM
      return ;
    }
    catch (...) {
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("Uncaught exception from C++ API"), 0, 0, 0, 0);
      jenv->Throw(t);
      return ;
    }
  }
}


SWIGEXPORT void JNICALL Java_com_sleepycat_dbxml_dbxml_1javaJNI_XmlIndexSpecification_1addIndex_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2, jstring jarg3, jint jarg4, jint jarg5) {
  XmlIndexSpecification *arg1 = (XmlIndexSpecification *) 0 ;
  std::string *arg2 = 0 ;
  std::string *arg3 = 0 ;
  enum XmlIndexSpecification::Type arg4 ;
  enum XmlValue::Type arg5 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(XmlIndexSpecification **)&jarg1; 
  
  const char *arg2_pstr = "";
  if(jarg2) {
    arg2_pstr = (const char *)jenv->GetStringUTFChars(jarg2, 0);
  }
  if (!arg2_pstr) return ;
  std::string arg2_str(arg2_pstr);
  arg2 = &arg2_str;
  if (jarg2) {
    jenv->ReleaseStringUTFChars(jarg2, arg2_pstr);
  }
  
  
  const char *arg3_pstr = "";
  if(jarg3) {
    arg3_pstr = (const char *)jenv->GetStringUTFChars(jarg3, 0);
  }
  if (!arg3_pstr) return ;
  std::string arg3_str(arg3_pstr);
  arg3 = &arg3_str;
  if (jarg3) {
    jenv->ReleaseStringUTFChars(jarg3, arg3_pstr);
  }
  
  arg4 = (enum XmlIndexSpecification::Type)jarg4; 
  arg5 = (enum XmlValue::Type)jarg5; 
  
  if (!jarg1) {
    jenv->Throw((jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INVALID_VALUE,
        jenv->NewStringUTF("null object - call after object destroyed?"),
        0, 0, 0, 0));					
    return ;
  }
  
  {
    jthrowable t = NULL;
    try {
      (arg1)->addIndex((std::string const &)*arg2,(std::string const &)*arg3,arg4,arg5);
    }
    catch (std::exception &se) {
      t = createException(jenv, &se);
      jenv->Throw(t);
      return ;
    }
    catch(JavaException & /* je */) {
      // This means there's already an exception waiting in the JVM
      return ;
    }
    catch (...) {
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("Uncaught exception from C++ API"), 0, 0, 0, 0);
      jenv->Throw(t);
      return ;
    }
  }
}


SWIGEXPORT void JNICALL Java_com_sleepycat_dbxml_dbxml_1javaJNI_XmlIndexSpecification_1addIndex_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2, jstring jarg3, jstring jarg4) {
  XmlIndexSpecification *arg1 = (XmlIndexSpecification *) 0 ;
  std::string *arg2 = 0 ;
  std::string *arg3 = 0 ;
  std::string *arg4 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(XmlIndexSpecification **)&jarg1; 
  
  const char *arg2_pstr = "";
  if(jarg2) {
    arg2_pstr = (const char *)jenv->GetStringUTFChars(jarg2, 0);
  }
  if (!arg2_pstr) return ;
  std::string arg2_str(arg2_pstr);
  arg2 = &arg2_str;
  if (jarg2) {
    jenv->ReleaseStringUTFChars(jarg2, arg2_pstr);
  }
  
  
  const char *arg3_pstr = "";
  if(jarg3) {
    arg3_pstr = (const char *)jenv->GetStringUTFChars(jarg3, 0);
  }
  if (!arg3_pstr) return ;
  std::string arg3_str(arg3_pstr);
  arg3 = &arg3_str;
  if (jarg3) {
    jenv->ReleaseStringUTFChars(jarg3, arg3_pstr);
  }
  
  
  const char *arg4_pstr = "";
  if(jarg4) {
    arg4_pstr = (const char *)jenv->GetStringUTFChars(jarg4, 0);
  }
  if (!arg4_pstr) return ;
  std::string arg4_str(arg4_pstr);
  arg4 = &arg4_str;
  if (jarg4) {
    jenv->ReleaseStringUTFChars(jarg4, arg4_pstr);
  }
  
  
  if (!jarg1) {
    jenv->Throw((jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INVALID_VALUE,
        jenv->NewStringUTF("null object - call after object destroyed?"),
        0, 0, 0, 0));					
    return ;
  }
  
  {
    jthrowable t = NULL;
    try {
      (arg1)->addIndex((std::string const &)*arg2,(std::string const &)*arg3,(std::string const &)*arg4);
    }
    catch (std::exception &se) {
      t = createException(jenv, &se);
      jenv->Throw(t);
      return ;
    }
    catch(JavaException & /* je */) {
      // This means there's already an exception waiting in the JVM
      return ;
    }
    catch (...) {
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("Uncaught exception from C++ API"), 0, 0, 0, 0);
      jenv->Throw(t);
      return ;
    }
  }
}


SWIGEXPORT void JNICALL Java_com_sleepycat_dbxml_dbxml_1javaJNI_XmlIndexSpecification_1deleteIndex_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2, jstring jarg3, jint jarg4, jint jarg5) {
  XmlIndexSpecification *arg1 = (XmlIndexSpecification *) 0 ;
  std::string *arg2 = 0 ;
  std::string *arg3 = 0 ;
  enum XmlIndexSpecification::Type arg4 ;
  enum XmlValue::Type arg5 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(XmlIndexSpecification **)&jarg1; 
  
  const char *arg2_pstr = "";
  if(jarg2) {
    arg2_pstr = (const char *)jenv->GetStringUTFChars(jarg2, 0);
  }
  if (!arg2_pstr) return ;
  std::string arg2_str(arg2_pstr);
  arg2 = &arg2_str;
  if (jarg2) {
    jenv->ReleaseStringUTFChars(jarg2, arg2_pstr);
  }
  
  
  const char *arg3_pstr = "";
  if(jarg3) {
    arg3_pstr = (const char *)jenv->GetStringUTFChars(jarg3, 0);
  }
  if (!arg3_pstr) return ;
  std::string arg3_str(arg3_pstr);
  arg3 = &arg3_str;
  if (jarg3) {
    jenv->ReleaseStringUTFChars(jarg3, arg3_pstr);
  }
  
  arg4 = (enum XmlIndexSpecification::Type)jarg4; 
  arg5 = (enum XmlValue::Type)jarg5; 
  
  if (!jarg1) {
    jenv->Throw((jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INVALID_VALUE,
        jenv->NewStringUTF("null object - call after object destroyed?"),
        0, 0, 0, 0));					
    return ;
  }
  
  {
    jthrowable t = NULL;
    try {
      (arg1)->deleteIndex((std::string const &)*arg2,(std::string const &)*arg3,arg4,arg5);
    }
    catch (std::exception &se) {
      t = createException(jenv, &se);
      jenv->Throw(t);
      return ;
    }
    catch(JavaException & /* je */) {
      // This means there's already an exception waiting in the JVM
      return ;
    }
    catch (...) {
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("Uncaught exception from C++ API"), 0, 0, 0, 0);
      jenv->Throw(t);
      return ;
    }
  }
}


SWIGEXPORT void JNICALL Java_com_sleepycat_dbxml_dbxml_1javaJNI_XmlIndexSpecification_1deleteIndex_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2, jstring jarg3, jstring jarg4) {
  XmlIndexSpecification *arg1 = (XmlIndexSpecification *) 0 ;
  std::string *arg2 = 0 ;
  std::string *arg3 = 0 ;
  std::string *arg4 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(XmlIndexSpecification **)&jarg1; 
  
  const char *arg2_pstr = "";
  if(jarg2) {
    arg2_pstr = (const char *)jenv->GetStringUTFChars(jarg2, 0);
  }
  if (!arg2_pstr) return ;
  std::string arg2_str(arg2_pstr);
  arg2 = &arg2_str;
  if (jarg2) {
    jenv->ReleaseStringUTFChars(jarg2, arg2_pstr);
  }
  
  
  const char *arg3_pstr = "";
  if(jarg3) {
    arg3_pstr = (const char *)jenv->GetStringUTFChars(jarg3, 0);
  }
  if (!arg3_pstr) return ;
  std::string arg3_str(arg3_pstr);
  arg3 = &arg3_str;
  if (jarg3) {
    jenv->ReleaseStringUTFChars(jarg3, arg3_pstr);
  }
  
  
  const char *arg4_pstr = "";
  if(jarg4) {
    arg4_pstr = (const char *)jenv->GetStringUTFChars(jarg4, 0);
  }
  if (!arg4_pstr) return ;
  std::string arg4_str(arg4_pstr);
  arg4 = &arg4_str;
  if (jarg4) {
    jenv->ReleaseStringUTFChars(jarg4, arg4_pstr);
  }
  
  
  if (!jarg1) {
    jenv->Throw((jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INVALID_VALUE,
        jenv->NewStringUTF("null object - call after object destroyed?"),
        0, 0, 0, 0));					
    return ;
  }
  
  {
    jthrowable t = NULL;
    try {
      (arg1)->deleteIndex((std::string const &)*arg2,(std::string const &)*arg3,(std::string const &)*arg4);
    }
    catch (std::exception &se) {
      t = createException(jenv, &se);
      jenv->Throw(t);
      return ;
    }
    catch(JavaException & /* je */) {
      // This means there's already an exception waiting in the JVM
      return ;
    }
    catch (...) {
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("Uncaught exception from C++ API"), 0, 0, 0, 0);
      jenv->Throw(t);
      return ;
    }
  }
}


SWIGEXPORT void JNICALL Java_com_sleepycat_dbxml_dbxml_1javaJNI_XmlIndexSpecification_1replaceIndex_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2, jstring jarg3, jint jarg4, jint jarg5) {
  XmlIndexSpecification *arg1 = (XmlIndexSpecification *) 0 ;
  std::string *arg2 = 0 ;
  std::string *arg3 = 0 ;
  enum XmlIndexSpecification::Type arg4 ;
  enum XmlValue::Type arg5 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(XmlIndexSpecification **)&jarg1; 
  
  const char *arg2_pstr = "";
  if(jarg2) {
    arg2_pstr = (const char *)jenv->GetStringUTFChars(jarg2, 0);
  }
  if (!arg2_pstr) return ;
  std::string arg2_str(arg2_pstr);
  arg2 = &arg2_str;
  if (jarg2) {
    jenv->ReleaseStringUTFChars(jarg2, arg2_pstr);
  }
  
  
  const char *arg3_pstr = "";
  if(jarg3) {
    arg3_pstr = (const char *)jenv->GetStringUTFChars(jarg3, 0);
  }
  if (!arg3_pstr) return ;
  std::string arg3_str(arg3_pstr);
  arg3 = &arg3_str;
  if (jarg3) {
    jenv->ReleaseStringUTFChars(jarg3, arg3_pstr);
  }
  
  arg4 = (enum XmlIndexSpecification::Type)jarg4; 
  arg5 = (enum XmlValue::Type)jarg5; 
  
  if (!jarg1) {
    jenv->Throw((jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INVALID_VALUE,
        jenv->NewStringUTF("null object - call after object destroyed?"),
        0, 0, 0, 0));					
    return ;
  }
  
  {
    jthrowable t = NULL;
    try {
      (arg1)->replaceIndex((std::string const &)*arg2,(std::string const &)*arg3,arg4,arg5);
    }
    catch (std::exception &se) {
      t = createException(jenv, &se);
      jenv->Throw(t);
      return ;
    }
    catch(JavaException & /* je */) {
      // This means there's already an exception waiting in the JVM
      return ;
    }
    catch (...) {
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("Uncaught exception from C++ API"), 0, 0, 0, 0);
      jenv->Throw(t);
      return ;
    }
  }
}


SWIGEXPORT void JNICALL Java_com_sleepycat_dbxml_dbxml_1javaJNI_XmlIndexSpecification_1replaceIndex_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2, jstring jarg3, jstring jarg4) {
  XmlIndexSpecification *arg1 = (XmlIndexSpecification *) 0 ;
  std::string *arg2 = 0 ;
  std::string *arg3 = 0 ;
  std::string *arg4 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(XmlIndexSpecification **)&jarg1; 
  
  const char *arg2_pstr = "";
  if(jarg2) {
    arg2_pstr = (const char *)jenv->GetStringUTFChars(jarg2, 0);
  }
  if (!arg2_pstr) return ;
  std::string arg2_str(arg2_pstr);
  arg2 = &arg2_str;
  if (jarg2) {
    jenv->ReleaseStringUTFChars(jarg2, arg2_pstr);
  }
  
  
  const char *arg3_pstr = "";
  if(jarg3) {
    arg3_pstr = (const char *)jenv->GetStringUTFChars(jarg3, 0);
  }
  if (!arg3_pstr) return ;
  std::string arg3_str(arg3_pstr);
  arg3 = &arg3_str;
  if (jarg3) {
    jenv->ReleaseStringUTFChars(jarg3, arg3_pstr);
  }
  
  
  const char *arg4_pstr = "";
  if(jarg4) {
    arg4_pstr = (const char *)jenv->GetStringUTFChars(jarg4, 0);
  }
  if (!arg4_pstr) return ;
  std::string arg4_str(arg4_pstr);
  arg4 = &arg4_str;
  if (jarg4) {
    jenv->ReleaseStringUTFChars(jarg4, arg4_pstr);
  }
  
  
  if (!jarg1) {
    jenv->Throw((jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INVALID_VALUE,
        jenv->NewStringUTF("null object - call after object destroyed?"),
        0, 0, 0, 0));					
    return ;
  }
  
  {
    jthrowable t = NULL;
    try {
      (arg1)->replaceIndex((std::string const &)*arg2,(std::string const &)*arg3,(std::string const &)*arg4);
    }
    catch (std::exception &se) {
      t = createException(jenv, &se);
      jenv->Throw(t);
      return ;
    }
    catch(JavaException & /* je */) {
      // This means there's already an exception waiting in the JVM
      return ;
    }
    catch (...) {
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("Uncaught exception from C++ API"), 0, 0, 0, 0);
      jenv->Throw(t);
      return ;
    }
  }
}


SWIGEXPORT void JNICALL Java_com_sleepycat_dbxml_dbxml_1javaJNI_XmlIndexSpecification_1addDefaultIndex_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2, jint jarg3) {
  XmlIndexSpecification *arg1 = (XmlIndexSpecification *) 0 ;
  enum XmlIndexSpecification::Type arg2 ;
  enum XmlValue::Type arg3 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(XmlIndexSpecification **)&jarg1; 
  arg2 = (enum XmlIndexSpecification::Type)jarg2; 
  arg3 = (enum XmlValue::Type)jarg3; 
  
  if (!jarg1) {
    jenv->Throw((jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INVALID_VALUE,
        jenv->NewStringUTF("null object - call after object destroyed?"),
        0, 0, 0, 0));					
    return ;
  }
  
  {
    jthrowable t = NULL;
    try {
      (arg1)->addDefaultIndex(arg2,arg3);
    }
    catch (std::exception &se) {
      t = createException(jenv, &se);
      jenv->Throw(t);
      return ;
    }
    catch(JavaException & /* je */) {
      // This means there's already an exception waiting in the JVM
      return ;
    }
    catch (...) {
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("Uncaught exception from C++ API"), 0, 0, 0, 0);
      jenv->Throw(t);
      return ;
    }
  }
}


SWIGEXPORT void JNICALL Java_com_sleepycat_dbxml_dbxml_1javaJNI_XmlIndexSpecification_1addDefaultIndex_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2) {
  XmlIndexSpecification *arg1 = (XmlIndexSpecification *) 0 ;
  std::string *arg2 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(XmlIndexSpecification **)&jarg1; 
  
  const char *arg2_pstr = "";
  if(jarg2) {
    arg2_pstr = (const char *)jenv->GetStringUTFChars(jarg2, 0);
  }
  if (!arg2_pstr) return ;
  std::string arg2_str(arg2_pstr);
  arg2 = &arg2_str;
  if (jarg2) {
    jenv->ReleaseStringUTFChars(jarg2, arg2_pstr);
  }
  
  
  if (!jarg1) {
    jenv->Throw((jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INVALID_VALUE,
        jenv->NewStringUTF("null object - call after object destroyed?"),
        0, 0, 0, 0));					
    return ;
  }
  
  {
    jthrowable t = NULL;
    try {
      (arg1)->addDefaultIndex((std::string const &)*arg2);
    }
    catch (std::exception &se) {
      t = createException(jenv, &se);
      jenv->Throw(t);
      return ;
    }
    catch(JavaException & /* je */) {
      // This means there's already an exception waiting in the JVM
      return ;
    }
    catch (...) {
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("Uncaught exception from C++ API"), 0, 0, 0, 0);
      jenv->Throw(t);
      return ;
    }
  }
}


SWIGEXPORT void JNICALL Java_com_sleepycat_dbxml_dbxml_1javaJNI_XmlIndexSpecification_1deleteDefaultIndex_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2, jint jarg3) {
  XmlIndexSpecification *arg1 = (XmlIndexSpecification *) 0 ;
  enum XmlIndexSpecification::Type arg2 ;
  enum XmlValue::Type arg3 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(XmlIndexSpecification **)&jarg1; 
  arg2 = (enum XmlIndexSpecification::Type)jarg2; 
  arg3 = (enum XmlValue::Type)jarg3; 
  
  if (!jarg1) {
    jenv->Throw((jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INVALID_VALUE,
        jenv->NewStringUTF("null object - call after object destroyed?"),
        0, 0, 0, 0));					
    return ;
  }
  
  {
    jthrowable t = NULL;
    try {
      (arg1)->deleteDefaultIndex(arg2,arg3);
    }
    catch (std::exception &se) {
      t = createException(jenv, &se);
      jenv->Throw(t);
      return ;
    }
    catch(JavaException & /* je */) {
      // This means there's already an exception waiting in the JVM
      return ;
    }
    catch (...) {
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("Uncaught exception from C++ API"), 0, 0, 0, 0);
      jenv->Throw(t);
      return ;
    }
  }
}


SWIGEXPORT void JNICALL Java_com_sleepycat_dbxml_dbxml_1javaJNI_XmlIndexSpecification_1deleteDefaultIndex_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2) {
  XmlIndexSpecification *arg1 = (XmlIndexSpecification *) 0 ;
  std::string *arg2 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(XmlIndexSpecification **)&jarg1; 
  
  const char *arg2_pstr = "";
  if(jarg2) {
    arg2_pstr = (const char *)jenv->GetStringUTFChars(jarg2, 0);
  }
  if (!arg2_pstr) return ;
  std::string arg2_str(arg2_pstr);
  arg2 = &arg2_str;
  if (jarg2) {
    jenv->ReleaseStringUTFChars(jarg2, arg2_pstr);
  }
  
  
  if (!jarg1) {
    jenv->Throw((jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INVALID_VALUE,
        jenv->NewStringUTF("null object - call after object destroyed?"),
        0, 0, 0, 0));					
    return ;
  }
  
  {
    jthrowable t = NULL;
    try {
      (arg1)->deleteDefaultIndex((std::string const &)*arg2);
    }
    catch (std::exception &se) {
      t = createException(jenv, &se);
      jenv->Throw(t);
      return ;
    }
    catch(JavaException & /* je */) {
      // This means there's already an exception waiting in the JVM
      return ;
    }
    catch (...) {
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("Uncaught exception from C++ API"), 0, 0, 0, 0);
      jenv->Throw(t);
      return ;
    }
  }
}


SWIGEXPORT void JNICALL Java_com_sleepycat_dbxml_dbxml_1javaJNI_XmlIndexSpecification_1replaceDefaultIndex_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2, jint jarg3) {
  XmlIndexSpecification *arg1 = (XmlIndexSpecification *) 0 ;
  enum XmlIndexSpecification::Type arg2 ;
  enum XmlValue::Type arg3 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(XmlIndexSpecification **)&jarg1; 
  arg2 = (enum XmlIndexSpecification::Type)jarg2; 
  arg3 = (enum XmlValue::Type)jarg3; 
  
  if (!jarg1) {
    jenv->Throw((jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INVALID_VALUE,
        jenv->NewStringUTF("null object - call after object destroyed?"),
        0, 0, 0, 0));					
    return ;
  }
  
  {
    jthrowable t = NULL;
    try {
      (arg1)->replaceDefaultIndex(arg2,arg3);
    }
    catch (std::exception &se) {
      t = createException(jenv, &se);
      jenv->Throw(t);
      return ;
    }
    catch(JavaException & /* je */) {
      // This means there's already an exception waiting in the JVM
      return ;
    }
    catch (...) {
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("Uncaught exception from C++ API"), 0, 0, 0, 0);
      jenv->Throw(t);
      return ;
    }
  }
}


SWIGEXPORT void JNICALL Java_com_sleepycat_dbxml_dbxml_1javaJNI_XmlIndexSpecification_1replaceDefaultIndex_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2) {
  XmlIndexSpecification *arg1 = (XmlIndexSpecification *) 0 ;
  std::string *arg2 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(XmlIndexSpecification **)&jarg1; 
  
  const char *arg2_pstr = "";
  if(jarg2) {
    arg2_pstr = (const char *)jenv->GetStringUTFChars(jarg2, 0);
  }
  if (!arg2_pstr) return ;
  std::string arg2_str(arg2_pstr);
  arg2 = &arg2_str;
  if (jarg2) {
    jenv->ReleaseStringUTFChars(jarg2, arg2_pstr);
  }
  
  
  if (!jarg1) {
    jenv->Throw((jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INVALID_VALUE,
        jenv->NewStringUTF("null object - call after object destroyed?"),
        0, 0, 0, 0));					
    return ;
  }
  
  {
    jthrowable t = NULL;
    try {
      (arg1)->replaceDefaultIndex((std::string const &)*arg2);
    }
    catch (std::exception &se) {
      t = createException(jenv, &se);
      jenv->Throw(t);
      return ;
    }
    catch(JavaException & /* je */) {
      // This means there's already an exception waiting in the JVM
      return ;
    }
    catch (...) {
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("Uncaught exception from C++ API"), 0, 0, 0, 0);
      jenv->Throw(t);
      return ;
    }
  }
}


SWIGEXPORT void JNICALL Java_com_sleepycat_dbxml_dbxml_1javaJNI_XmlIndexSpecification_1reset(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  XmlIndexSpecification *arg1 = (XmlIndexSpecification *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(XmlIndexSpecification **)&jarg1; 
  
  if (!jarg1) {
    jenv->Throw((jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INVALID_VALUE,
        jenv->NewStringUTF("null object - call after object destroyed?"),
        0, 0, 0, 0));					
    return ;
  }
  
  {
    jthrowable t = NULL;
    try {
      (arg1)->reset();
    }
    catch (std::exception &se) {
      t = createException(jenv, &se);
      jenv->Throw(t);
      return ;
    }
    catch(JavaException & /* je */) {
      // This means there's already an exception waiting in the JVM
      return ;
    }
    catch (...) {
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("Uncaught exception from C++ API"), 0, 0, 0, 0);
      jenv->Throw(t);
      return ;
    }
  }
}


SWIGEXPORT jboolean JNICALL Java_com_sleepycat_dbxml_dbxml_1javaJNI_XmlIndexSpecification_1getAutoIndexing(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jboolean jresult = 0 ;
  XmlIndexSpecification *arg1 = (XmlIndexSpecification *) 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(XmlIndexSpecification **)&jarg1; 
  
  if (!jarg1) {
    jenv->Throw((jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INVALID_VALUE,
        jenv->NewStringUTF("null object - call after object destroyed?"),
        0, 0, 0, 0));					
    return 0;
  }
  
  {
    jthrowable t = NULL;
    try {
      result = (bool)((XmlIndexSpecification const *)arg1)->getAutoIndexing();
    }
    catch (std::exception &se) {
      t = createException(jenv, &se);
      jenv->Throw(t);
      return 0;
    }
    catch(JavaException & /* je */) {
      // This means there's already an exception waiting in the JVM
      return 0;
    }
    catch (...) {
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("Uncaught exception from C++ API"), 0, 0, 0, 0);
      jenv->Throw(t);
      return 0;
    }
  }
  
  jresult = result ? JNI_TRUE : JNI_FALSE;
  
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_sleepycat_dbxml_dbxml_1javaJNI_XmlIndexSpecification_1setAutoIndexing(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jboolean jarg2) {
  XmlIndexSpecification *arg1 = (XmlIndexSpecification *) 0 ;
  bool arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(XmlIndexSpecification **)&jarg1; 
  
  arg2 = (jarg2 != JNI_FALSE);
  
  
  if (!jarg1) {
    jenv->Throw((jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INVALID_VALUE,
        jenv->NewStringUTF("null object - call after object destroyed?"),
        0, 0, 0, 0));					
    return ;
  }
  
  {
    jthrowable t = NULL;
    try {
      (arg1)->setAutoIndexing(arg2);
    }
    catch (std::exception &se) {
      t = createException(jenv, &se);
      jenv->Throw(t);
      return ;
    }
    catch(JavaException & /* je */) {
      // This means there's already an exception waiting in the JVM
      return ;
    }
    catch (...) {
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("Uncaught exception from C++ API"), 0, 0, 0, 0);
      jenv->Throw(t);
      return ;
    }
  }
}


SWIGEXPORT jobject JNICALL Java_com_sleepycat_dbxml_dbxml_1javaJNI_XmlIndexSpecification_1find(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2, jstring jarg3) {
  jobject jresult = 0 ;
  XmlIndexSpecification *arg1 = (XmlIndexSpecification *) 0 ;
  std::string *arg2 = 0 ;
  std::string *arg3 = 0 ;
  XmlIndexDeclaration *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(XmlIndexSpecification **)&jarg1; 
  
  const char *arg2_pstr = "";
  if(jarg2) {
    arg2_pstr = (const char *)jenv->GetStringUTFChars(jarg2, 0);
  }
  if (!arg2_pstr) return 0;
  std::string arg2_str(arg2_pstr);
  arg2 = &arg2_str;
  if (jarg2) {
    jenv->ReleaseStringUTFChars(jarg2, arg2_pstr);
  }
  
  
  const char *arg3_pstr = "";
  if(jarg3) {
    arg3_pstr = (const char *)jenv->GetStringUTFChars(jarg3, 0);
  }
  if (!arg3_pstr) return 0;
  std::string arg3_str(arg3_pstr);
  arg3 = &arg3_str;
  if (jarg3) {
    jenv->ReleaseStringUTFChars(jarg3, arg3_pstr);
  }
  
  
  if (!jarg1) {
    jenv->Throw((jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INVALID_VALUE,
        jenv->NewStringUTF("null object - call after object destroyed?"),
        0, 0, 0, 0));					
    return 0;
  }
  
  {
    jthrowable t = NULL;
    try {
      result = (XmlIndexDeclaration *)XmlIndexSpecification_find(arg1,(std::string const &)*arg2,(std::string const &)*arg3);
    }
    catch (std::exception &se) {
      t = createException(jenv, &se);
      jenv->Throw(t);
      return 0;
    }
    catch(JavaException & /* je */) {
      // This means there's already an exception waiting in the JVM
      return 0;
    }
    catch (...) {
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("Uncaught exception from C++ API"), 0, 0, 0, 0);
      jenv->Throw(t);
      return 0;
    }
  }
  
  if (result == NULL)
  jresult = NULL;
  else {
    jresult = jenv->NewObject(xml_indexdecl_class, xml_indexdecl_construct,
      jenv->NewStringUTF(result->uri.c_str()),
      jenv->NewStringUTF(result->name.c_str()),
      jenv->NewStringUTF(result->index.c_str()));
    delete result;
  }
  
  return jresult;
}


SWIGEXPORT jobject JNICALL Java_com_sleepycat_dbxml_dbxml_1javaJNI_XmlIndexSpecification_1next(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jobject jresult = 0 ;
  XmlIndexSpecification *arg1 = (XmlIndexSpecification *) 0 ;
  XmlIndexDeclaration *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(XmlIndexSpecification **)&jarg1; 
  
  if (!jarg1) {
    jenv->Throw((jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INVALID_VALUE,
        jenv->NewStringUTF("null object - call after object destroyed?"),
        0, 0, 0, 0));					
    return 0;
  }
  
  {
    jthrowable t = NULL;
    try {
      result = (XmlIndexDeclaration *)XmlIndexSpecification_next(arg1);
    }
    catch (std::exception &se) {
      t = createException(jenv, &se);
      jenv->Throw(t);
      return 0;
    }
    catch(JavaException & /* je */) {
      // This means there's already an exception waiting in the JVM
      return 0;
    }
    catch (...) {
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("Uncaught exception from C++ API"), 0, 0, 0, 0);
      jenv->Throw(t);
      return 0;
    }
  }
  
  if (result == NULL)
  jresult = NULL;
  else {
    jresult = jenv->NewObject(xml_indexdecl_class, xml_indexdecl_construct,
      jenv->NewStringUTF(result->uri.c_str()),
      jenv->NewStringUTF(result->name.c_str()),
      jenv->NewStringUTF(result->index.c_str()));
    delete result;
  }
  
  return jresult;
}


SWIGEXPORT jstring JNICALL Java_com_sleepycat_dbxml_dbxml_1javaJNI_XmlIndexSpecification_1getDefaultIndex(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jstring jresult = 0 ;
  XmlIndexSpecification *arg1 = (XmlIndexSpecification *) 0 ;
  std::string result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(XmlIndexSpecification **)&jarg1; 
  
  if (!jarg1) {
    jenv->Throw((jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INVALID_VALUE,
        jenv->NewStringUTF("null object - call after object destroyed?"),
        0, 0, 0, 0));					
    return 0;
  }
  
  {
    jthrowable t = NULL;
    try {
      result = ((XmlIndexSpecification const *)arg1)->getDefaultIndex();
    }
    catch (std::exception &se) {
      t = createException(jenv, &se);
      jenv->Throw(t);
      return 0;
    }
    catch(JavaException & /* je */) {
      // This means there's already an exception waiting in the JVM
      return 0;
    }
    catch (...) {
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("Uncaught exception from C++ API"), 0, 0, 0, 0);
      jenv->Throw(t);
      return 0;
    }
  }
  jresult = jenv->NewStringUTF((&result)->c_str()); 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_com_sleepycat_dbxml_dbxml_1javaJNI_XmlIndexSpecification_1getValueType(JNIEnv *jenv, jclass jcls, jstring jarg1) {
  jint jresult = 0 ;
  std::string *arg1 = 0 ;
  enum XmlValue::Type result;
  
  (void)jenv;
  (void)jcls;
  
  const char *arg1_pstr = "";
  if(jarg1) {
    arg1_pstr = (const char *)jenv->GetStringUTFChars(jarg1, 0);
  }
  if (!arg1_pstr) return 0;
  std::string arg1_str(arg1_pstr);
  arg1 = &arg1_str;
  if (jarg1) {
    jenv->ReleaseStringUTFChars(jarg1, arg1_pstr);
  }
  
  {
    jthrowable t = NULL;
    try {
      result = (enum XmlValue::Type)XmlIndexSpecification::getValueType((std::string const &)*arg1);
    }
    catch (std::exception &se) {
      t = createException(jenv, &se);
      jenv->Throw(t);
      return 0;
    }
    catch(JavaException & /* je */) {
      // This means there's already an exception waiting in the JVM
      return 0;
    }
    catch (...) {
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("Uncaught exception from C++ API"), 0, 0, 0, 0);
      jenv->Throw(t);
      return 0;
    }
  }
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_sleepycat_dbxml_dbxml_1javaJNI_new_1XmlQueryExpression(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  XmlQueryExpression *arg1 = 0 ;
  XmlQueryExpression *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(XmlQueryExpression **)&jarg1;
  if(!arg1) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "XmlQueryExpression const & reference is null");
    return 0;
  } 
  {
    jthrowable t = NULL;
    try {
      result = (XmlQueryExpression *)new XmlQueryExpression((XmlQueryExpression const &)*arg1);
    }
    catch (std::exception &se) {
      t = createException(jenv, &se);
      jenv->Throw(t);
      return 0;
    }
    catch(JavaException & /* je */) {
      // This means there's already an exception waiting in the JVM
      return 0;
    }
    catch (...) {
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("Uncaught exception from C++ API"), 0, 0, 0, 0);
      jenv->Throw(t);
      return 0;
    }
  }
  *(XmlQueryExpression **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_sleepycat_dbxml_dbxml_1javaJNI_delete_1XmlQueryExpression(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  XmlQueryExpression *arg1 = (XmlQueryExpression *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(XmlQueryExpression **)&jarg1; 
  
  if (!jarg1) {
    jenv->Throw((jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INVALID_VALUE,
        jenv->NewStringUTF("null object - call after object destroyed?"),
        0, 0, 0, 0));					
    return ;
  }
  
  {
    jthrowable t = NULL;
    try {
      delete arg1;
    }
    catch (std::exception &se) {
      t = createException(jenv, &se);
      jenv->Throw(t);
      return ;
    }
    catch(JavaException & /* je */) {
      // This means there's already an exception waiting in the JVM
      return ;
    }
    catch (...) {
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("Uncaught exception from C++ API"), 0, 0, 0, 0);
      jenv->Throw(t);
      return ;
    }
  }
}


SWIGEXPORT jstring JNICALL Java_com_sleepycat_dbxml_dbxml_1javaJNI_XmlQueryExpression_1getQuery(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jstring jresult = 0 ;
  XmlQueryExpression *arg1 = (XmlQueryExpression *) 0 ;
  std::string *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(XmlQueryExpression **)&jarg1; 
  
  if (!jarg1) {
    jenv->Throw((jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INVALID_VALUE,
        jenv->NewStringUTF("null object - call after object destroyed?"),
        0, 0, 0, 0));					
    return 0;
  }
  
  {
    jthrowable t = NULL;
    try {
      result = (std::string *) &((XmlQueryExpression const *)arg1)->getQuery();
    }
    catch (std::exception &se) {
      t = createException(jenv, &se);
      jenv->Throw(t);
      return 0;
    }
    catch(JavaException & /* je */) {
      // This means there's already an exception waiting in the JVM
      return 0;
    }
    catch (...) {
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("Uncaught exception from C++ API"), 0, 0, 0, 0);
      jenv->Throw(t);
      return 0;
    }
  }
  jresult = jenv->NewStringUTF(result->c_str()); 
  return jresult;
}


SWIGEXPORT jstring JNICALL Java_com_sleepycat_dbxml_dbxml_1javaJNI_XmlQueryExpression_1getQueryPlan(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jstring jresult = 0 ;
  XmlQueryExpression *arg1 = (XmlQueryExpression *) 0 ;
  std::string result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(XmlQueryExpression **)&jarg1; 
  
  if (!jarg1) {
    jenv->Throw((jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INVALID_VALUE,
        jenv->NewStringUTF("null object - call after object destroyed?"),
        0, 0, 0, 0));					
    return 0;
  }
  
  {
    jthrowable t = NULL;
    try {
      result = ((XmlQueryExpression const *)arg1)->getQueryPlan();
    }
    catch (std::exception &se) {
      t = createException(jenv, &se);
      jenv->Throw(t);
      return 0;
    }
    catch(JavaException & /* je */) {
      // This means there's already an exception waiting in the JVM
      return 0;
    }
    catch (...) {
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("Uncaught exception from C++ API"), 0, 0, 0, 0);
      jenv->Throw(t);
      return 0;
    }
  }
  jresult = jenv->NewStringUTF((&result)->c_str()); 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_com_sleepycat_dbxml_dbxml_1javaJNI_XmlQueryExpression_1isUpdateExpression(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jboolean jresult = 0 ;
  XmlQueryExpression *arg1 = (XmlQueryExpression *) 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(XmlQueryExpression **)&jarg1; 
  
  if (!jarg1) {
    jenv->Throw((jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INVALID_VALUE,
        jenv->NewStringUTF("null object - call after object destroyed?"),
        0, 0, 0, 0));					
    return 0;
  }
  
  {
    jthrowable t = NULL;
    try {
      result = (bool)((XmlQueryExpression const *)arg1)->isUpdateExpression();
    }
    catch (std::exception &se) {
      t = createException(jenv, &se);
      jenv->Throw(t);
      return 0;
    }
    catch(JavaException & /* je */) {
      // This means there's already an exception waiting in the JVM
      return 0;
    }
    catch (...) {
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("Uncaught exception from C++ API"), 0, 0, 0, 0);
      jenv->Throw(t);
      return 0;
    }
  }
  
  jresult = result ? JNI_TRUE : JNI_FALSE;
  
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_sleepycat_dbxml_dbxml_1javaJNI_XmlQueryExpression_1execute_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong mgrPtr2, jlong dbgPtr2, jint eval2, jint querySec2, jobjectArray data2, jobject jarg2, jint jarg3) {
  jlong jresult = 0 ;
  XmlQueryExpression *arg1 = (XmlQueryExpression *) 0 ;
  XmlQueryContext *arg2 = 0 ;
  u_int32_t arg3 ;
  XmlResults *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(XmlQueryExpression **)&jarg1; 
  
  queryContextRef qcRef(jenv, mgrPtr2, dbgPtr2, eval2, querySec2, data2, jarg2);
  if (qcRef.getQC()->isNull())
  return 0; // exception was thrown
  arg2 = qcRef.getQC();
  
  arg3 = (u_int32_t)jarg3; 
  
  if (!jarg1) {
    jenv->Throw((jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INVALID_VALUE,
        jenv->NewStringUTF("null object - call after object destroyed?"),
        0, 0, 0, 0));					
    return 0;
  }
  
  {
    jthrowable t = NULL;
    try {
      result = (XmlResults *)XmlQueryExpression_execute__SWIG_0((XmlQueryExpression const *)arg1,*arg2,arg3);
    }
    catch (std::exception &se) {
      t = createException(jenv, &se);
      jenv->Throw(t);
      return 0;
    }
    catch(JavaException & /* je */) {
      // This means there's already an exception waiting in the JVM
      return 0;
    }
    catch (...) {
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("Uncaught exception from C++ API"), 0, 0, 0, 0);
      jenv->Throw(t);
      return 0;
    }
  }
  *(XmlResults **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_sleepycat_dbxml_dbxml_1javaJNI_XmlQueryExpression_1execute_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong mgrPtr2, jlong dbgPtr2, jint eval2, jint querySec2, jobjectArray data2, jobject jarg2) {
  jlong jresult = 0 ;
  XmlQueryExpression *arg1 = (XmlQueryExpression *) 0 ;
  XmlQueryContext *arg2 = 0 ;
  XmlResults *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(XmlQueryExpression **)&jarg1; 
  
  queryContextRef qcRef(jenv, mgrPtr2, dbgPtr2, eval2, querySec2, data2, jarg2);
  if (qcRef.getQC()->isNull())
  return 0; // exception was thrown
  arg2 = qcRef.getQC();
  
  
  if (!jarg1) {
    jenv->Throw((jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INVALID_VALUE,
        jenv->NewStringUTF("null object - call after object destroyed?"),
        0, 0, 0, 0));					
    return 0;
  }
  
  {
    jthrowable t = NULL;
    try {
      result = (XmlResults *)XmlQueryExpression_execute__SWIG_0((XmlQueryExpression const *)arg1,*arg2);
    }
    catch (std::exception &se) {
      t = createException(jenv, &se);
      jenv->Throw(t);
      return 0;
    }
    catch(JavaException & /* je */) {
      // This means there's already an exception waiting in the JVM
      return 0;
    }
    catch (...) {
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("Uncaught exception from C++ API"), 0, 0, 0, 0);
      jenv->Throw(t);
      return 0;
    }
  }
  *(XmlResults **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_sleepycat_dbxml_dbxml_1javaJNI_XmlQueryExpression_1execute_1_1SWIG_12(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jobject jarg2, jlong mgrPtr3, jlong dbgPtr3, jint eval3, jint querySec3, jobjectArray data3, jobject jarg3, jint jarg4) {
  jlong jresult = 0 ;
  XmlQueryExpression *arg1 = (XmlQueryExpression *) 0 ;
  XmlValue *arg2 = 0 ;
  XmlQueryContext *arg3 = 0 ;
  u_int32_t arg4 ;
  XmlResults *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(XmlQueryExpression **)&jarg1; 
  
  bool valid = true;
  XmlValue val2 = createCPPXmlValue(jenv, jarg2, &valid);
  if (!valid) return 0;
  arg2 = &val2;
  
  
  queryContextRef qcRef(jenv, mgrPtr3, dbgPtr3, eval3, querySec3, data3, jarg3);
  if (qcRef.getQC()->isNull())
  return 0; // exception was thrown
  arg3 = qcRef.getQC();
  
  arg4 = (u_int32_t)jarg4; 
  
  if (!jarg1) {
    jenv->Throw((jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INVALID_VALUE,
        jenv->NewStringUTF("null object - call after object destroyed?"),
        0, 0, 0, 0));					
    return 0;
  }
  
  {
    jthrowable t = NULL;
    try {
      result = (XmlResults *)XmlQueryExpression_execute__SWIG_2((XmlQueryExpression const *)arg1,(XmlValue const &)*arg2,*arg3,arg4);
    }
    catch (std::exception &se) {
      t = createException(jenv, &se);
      jenv->Throw(t);
      return 0;
    }
    catch(JavaException & /* je */) {
      // This means there's already an exception waiting in the JVM
      return 0;
    }
    catch (...) {
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("Uncaught exception from C++ API"), 0, 0, 0, 0);
      jenv->Throw(t);
      return 0;
    }
  }
  *(XmlResults **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_sleepycat_dbxml_dbxml_1javaJNI_XmlQueryExpression_1execute_1_1SWIG_13(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jobject jarg2, jlong mgrPtr3, jlong dbgPtr3, jint eval3, jint querySec3, jobjectArray data3, jobject jarg3) {
  jlong jresult = 0 ;
  XmlQueryExpression *arg1 = (XmlQueryExpression *) 0 ;
  XmlValue *arg2 = 0 ;
  XmlQueryContext *arg3 = 0 ;
  XmlResults *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(XmlQueryExpression **)&jarg1; 
  
  bool valid = true;
  XmlValue val2 = createCPPXmlValue(jenv, jarg2, &valid);
  if (!valid) return 0;
  arg2 = &val2;
  
  
  queryContextRef qcRef(jenv, mgrPtr3, dbgPtr3, eval3, querySec3, data3, jarg3);
  if (qcRef.getQC()->isNull())
  return 0; // exception was thrown
  arg3 = qcRef.getQC();
  
  
  if (!jarg1) {
    jenv->Throw((jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INVALID_VALUE,
        jenv->NewStringUTF("null object - call after object destroyed?"),
        0, 0, 0, 0));					
    return 0;
  }
  
  {
    jthrowable t = NULL;
    try {
      result = (XmlResults *)XmlQueryExpression_execute__SWIG_2((XmlQueryExpression const *)arg1,(XmlValue const &)*arg2,*arg3);
    }
    catch (std::exception &se) {
      t = createException(jenv, &se);
      jenv->Throw(t);
      return 0;
    }
    catch(JavaException & /* je */) {
      // This means there's already an exception waiting in the JVM
      return 0;
    }
    catch (...) {
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("Uncaught exception from C++ API"), 0, 0, 0, 0);
      jenv->Throw(t);
      return 0;
    }
  }
  *(XmlResults **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_sleepycat_dbxml_dbxml_1javaJNI_XmlQueryExpression_1execute_1_1SWIG_14(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_, jlong mgrPtr3, jlong dbgPtr3, jint eval3, jint querySec3, jobjectArray data3, jobject jarg3, jint jarg4) {
  jlong jresult = 0 ;
  XmlQueryExpression *arg1 = (XmlQueryExpression *) 0 ;
  XmlTransaction *arg2 = 0 ;
  XmlQueryContext *arg3 = 0 ;
  u_int32_t arg4 ;
  XmlResults *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(XmlQueryExpression **)&jarg1; 
  arg2 = *(XmlTransaction **)&jarg2;
  if(!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "XmlTransaction & reference is null");
    return 0;
  } 
  
  queryContextRef qcRef(jenv, mgrPtr3, dbgPtr3, eval3, querySec3, data3, jarg3);
  if (qcRef.getQC()->isNull())
  return 0; // exception was thrown
  arg3 = qcRef.getQC();
  
  arg4 = (u_int32_t)jarg4; 
  
  if (!jarg1) {
    jenv->Throw((jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INVALID_VALUE,
        jenv->NewStringUTF("null object - call after object destroyed?"),
        0, 0, 0, 0));					
    return 0;
  }
  
  {
    jthrowable t = NULL;
    try {
      result = (XmlResults *)XmlQueryExpression_execute__SWIG_4((XmlQueryExpression const *)arg1,*arg2,*arg3,arg4);
    }
    catch (std::exception &se) {
      t = createException(jenv, &se);
      jenv->Throw(t);
      return 0;
    }
    catch(JavaException & /* je */) {
      // This means there's already an exception waiting in the JVM
      return 0;
    }
    catch (...) {
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("Uncaught exception from C++ API"), 0, 0, 0, 0);
      jenv->Throw(t);
      return 0;
    }
  }
  *(XmlResults **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_sleepycat_dbxml_dbxml_1javaJNI_XmlQueryExpression_1execute_1_1SWIG_15(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_, jlong mgrPtr3, jlong dbgPtr3, jint eval3, jint querySec3, jobjectArray data3, jobject jarg3) {
  jlong jresult = 0 ;
  XmlQueryExpression *arg1 = (XmlQueryExpression *) 0 ;
  XmlTransaction *arg2 = 0 ;
  XmlQueryContext *arg3 = 0 ;
  XmlResults *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(XmlQueryExpression **)&jarg1; 
  arg2 = *(XmlTransaction **)&jarg2;
  if(!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "XmlTransaction & reference is null");
    return 0;
  } 
  
  queryContextRef qcRef(jenv, mgrPtr3, dbgPtr3, eval3, querySec3, data3, jarg3);
  if (qcRef.getQC()->isNull())
  return 0; // exception was thrown
  arg3 = qcRef.getQC();
  
  
  if (!jarg1) {
    jenv->Throw((jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INVALID_VALUE,
        jenv->NewStringUTF("null object - call after object destroyed?"),
        0, 0, 0, 0));					
    return 0;
  }
  
  {
    jthrowable t = NULL;
    try {
      result = (XmlResults *)XmlQueryExpression_execute__SWIG_4((XmlQueryExpression const *)arg1,*arg2,*arg3);
    }
    catch (std::exception &se) {
      t = createException(jenv, &se);
      jenv->Throw(t);
      return 0;
    }
    catch(JavaException & /* je */) {
      // This means there's already an exception waiting in the JVM
      return 0;
    }
    catch (...) {
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("Uncaught exception from C++ API"), 0, 0, 0, 0);
      jenv->Throw(t);
      return 0;
    }
  }
  *(XmlResults **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_sleepycat_dbxml_dbxml_1javaJNI_XmlQueryExpression_1execute_1_1SWIG_16(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_, jobject jarg3, jlong mgrPtr4, jlong dbgPtr4, jint eval4, jint querySec4, jobjectArray data4, jobject jarg4, jint jarg5) {
  jlong jresult = 0 ;
  XmlQueryExpression *arg1 = (XmlQueryExpression *) 0 ;
  XmlTransaction *arg2 = 0 ;
  XmlValue *arg3 = 0 ;
  XmlQueryContext *arg4 = 0 ;
  u_int32_t arg5 ;
  XmlResults *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(XmlQueryExpression **)&jarg1; 
  arg2 = *(XmlTransaction **)&jarg2;
  if(!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "XmlTransaction & reference is null");
    return 0;
  } 
  
  bool valid = true;
  XmlValue val3 = createCPPXmlValue(jenv, jarg3, &valid);
  if (!valid) return 0;
  arg3 = &val3;
  
  
  queryContextRef qcRef(jenv, mgrPtr4, dbgPtr4, eval4, querySec4, data4, jarg4);
  if (qcRef.getQC()->isNull())
  return 0; // exception was thrown
  arg4 = qcRef.getQC();
  
  arg5 = (u_int32_t)jarg5; 
  
  if (!jarg1) {
    jenv->Throw((jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INVALID_VALUE,
        jenv->NewStringUTF("null object - call after object destroyed?"),
        0, 0, 0, 0));					
    return 0;
  }
  
  {
    jthrowable t = NULL;
    try {
      result = (XmlResults *)XmlQueryExpression_execute__SWIG_6((XmlQueryExpression const *)arg1,*arg2,(XmlValue const &)*arg3,*arg4,arg5);
    }
    catch (std::exception &se) {
      t = createException(jenv, &se);
      jenv->Throw(t);
      return 0;
    }
    catch(JavaException & /* je */) {
      // This means there's already an exception waiting in the JVM
      return 0;
    }
    catch (...) {
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("Uncaught exception from C++ API"), 0, 0, 0, 0);
      jenv->Throw(t);
      return 0;
    }
  }
  *(XmlResults **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_sleepycat_dbxml_dbxml_1javaJNI_XmlQueryExpression_1execute_1_1SWIG_17(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_, jobject jarg3, jlong mgrPtr4, jlong dbgPtr4, jint eval4, jint querySec4, jobjectArray data4, jobject jarg4) {
  jlong jresult = 0 ;
  XmlQueryExpression *arg1 = (XmlQueryExpression *) 0 ;
  XmlTransaction *arg2 = 0 ;
  XmlValue *arg3 = 0 ;
  XmlQueryContext *arg4 = 0 ;
  XmlResults *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(XmlQueryExpression **)&jarg1; 
  arg2 = *(XmlTransaction **)&jarg2;
  if(!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "XmlTransaction & reference is null");
    return 0;
  } 
  
  bool valid = true;
  XmlValue val3 = createCPPXmlValue(jenv, jarg3, &valid);
  if (!valid) return 0;
  arg3 = &val3;
  
  
  queryContextRef qcRef(jenv, mgrPtr4, dbgPtr4, eval4, querySec4, data4, jarg4);
  if (qcRef.getQC()->isNull())
  return 0; // exception was thrown
  arg4 = qcRef.getQC();
  
  
  if (!jarg1) {
    jenv->Throw((jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INVALID_VALUE,
        jenv->NewStringUTF("null object - call after object destroyed?"),
        0, 0, 0, 0));					
    return 0;
  }
  
  {
    jthrowable t = NULL;
    try {
      result = (XmlResults *)XmlQueryExpression_execute__SWIG_6((XmlQueryExpression const *)arg1,*arg2,(XmlValue const &)*arg3,*arg4);
    }
    catch (std::exception &se) {
      t = createException(jenv, &se);
      jenv->Throw(t);
      return 0;
    }
    catch(JavaException & /* je */) {
      // This means there's already an exception waiting in the JVM
      return 0;
    }
    catch (...) {
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("Uncaught exception from C++ API"), 0, 0, 0, 0);
      jenv->Throw(t);
      return 0;
    }
  }
  *(XmlResults **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_sleepycat_dbxml_dbxml_1javaJNI_new_1XmlInputStream(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  XmlInputStream *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  {
    jthrowable t = NULL;
    try {
      result = (XmlInputStream *)new SwigDirector_XmlInputStream(jenv);
    }
    catch (std::exception &se) {
      t = createException(jenv, &se);
      jenv->Throw(t);
      return 0;
    }
    catch(JavaException & /* je */) {
      // This means there's already an exception waiting in the JVM
      return 0;
    }
    catch (...) {
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("Uncaught exception from C++ API"), 0, 0, 0, 0);
      jenv->Throw(t);
      return 0;
    }
  }
  *(XmlInputStream **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_sleepycat_dbxml_dbxml_1javaJNI_delete_1XmlInputStream(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  XmlInputStream *arg1 = (XmlInputStream *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(XmlInputStream **)&jarg1; 
  
  if (!jarg1) {
    jenv->Throw((jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INVALID_VALUE,
        jenv->NewStringUTF("null object - call after object destroyed?"),
        0, 0, 0, 0));					
    return ;
  }
  
  {
    jthrowable t = NULL;
    try {
      delete arg1;
    }
    catch (std::exception &se) {
      t = createException(jenv, &se);
      jenv->Throw(t);
      return ;
    }
    catch(JavaException & /* je */) {
      // This means there's already an exception waiting in the JVM
      return ;
    }
    catch (...) {
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("Uncaught exception from C++ API"), 0, 0, 0, 0);
      jenv->Throw(t);
      return ;
    }
  }
}


SWIGEXPORT jlong JNICALL Java_com_sleepycat_dbxml_dbxml_1javaJNI_XmlInputStream_1curPos(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  XmlInputStream *arg1 = (XmlInputStream *) 0 ;
  unsigned int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(XmlInputStream **)&jarg1; 
  
  if (!jarg1) {
    jenv->Throw((jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INVALID_VALUE,
        jenv->NewStringUTF("null object - call after object destroyed?"),
        0, 0, 0, 0));					
    return 0;
  }
  
  {
    jthrowable t = NULL;
    try {
      result = (unsigned int)((XmlInputStream const *)arg1)->curPos();
    }
    catch (std::exception &se) {
      t = createException(jenv, &se);
      jenv->Throw(t);
      return 0;
    }
    catch(JavaException & /* je */) {
      // This means there's already an exception waiting in the JVM
      return 0;
    }
    catch (...) {
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("Uncaught exception from C++ API"), 0, 0, 0, 0);
      jenv->Throw(t);
      return 0;
    }
  }
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_sleepycat_dbxml_dbxml_1javaJNI_XmlInputStream_1readBytes(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jbyteArray jarg2, jlong jarg3) {
  jlong jresult = 0 ;
  XmlInputStream *arg1 = (XmlInputStream *) 0 ;
  char *arg2 = (char *) 0 ;
  unsigned int arg3 ;
  unsigned int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(XmlInputStream **)&jarg1; 
  {
    if (!jarg2) {
      SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "array null");
      return 0;
    }
    if (jenv->GetArrayLength(jarg2) == 0) {
      SWIG_JavaThrowException(jenv, SWIG_JavaIndexOutOfBoundsException, "Array must contain at least 1 element");
      return 0;
    }
    arg2 = (char *) jenv->GetByteArrayElements(jarg2, 0); 
  }
  arg3 = (unsigned int)jarg3; 
  
  if (!jarg1) {
    jenv->Throw((jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INVALID_VALUE,
        jenv->NewStringUTF("null object - call after object destroyed?"),
        0, 0, 0, 0));					
    return 0;
  }
  
  {
    jthrowable t = NULL;
    try {
      result = (unsigned int)(arg1)->readBytes(arg2,arg3);
    }
    catch (std::exception &se) {
      t = createException(jenv, &se);
      jenv->Throw(t);
      return 0;
    }
    catch(JavaException & /* je */) {
      // This means there's already an exception waiting in the JVM
      return 0;
    }
    catch (...) {
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("Uncaught exception from C++ API"), 0, 0, 0, 0);
      jenv->Throw(t);
      return 0;
    }
  }
  jresult = (jlong)result; 
  {
    jenv->ReleaseByteArrayElements(jarg2, (jbyte *)arg2, 0); 
  }
  
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_sleepycat_dbxml_dbxml_1javaJNI_XmlInputStream_1freeMemory(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  XmlInputStream *arg1 = (XmlInputStream *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(XmlInputStream **)&jarg1; 
  
  if (!jarg1) {
    jenv->Throw((jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INVALID_VALUE,
        jenv->NewStringUTF("null object - call after object destroyed?"),
        0, 0, 0, 0));					
    return ;
  }
  
  {
    jthrowable t = NULL;
    try {
      XmlInputStream_freeMemory(arg1);
    }
    catch (std::exception &se) {
      t = createException(jenv, &se);
      jenv->Throw(t);
      return ;
    }
    catch(JavaException & /* je */) {
      // This means there's already an exception waiting in the JVM
      return ;
    }
    catch (...) {
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("Uncaught exception from C++ API"), 0, 0, 0, 0);
      jenv->Throw(t);
      return ;
    }
  }
}


SWIGEXPORT void JNICALL Java_com_sleepycat_dbxml_dbxml_1javaJNI_XmlInputStream_1director_1connect(JNIEnv *jenv, jclass jcls, jobject jself, jlong objarg, jboolean jswig_mem_own, jboolean jweak_global) {
  XmlInputStream *obj = *((XmlInputStream **)&objarg);
  (void)jcls;
  SwigDirector_XmlInputStream *director = dynamic_cast<SwigDirector_XmlInputStream *>(obj);
  if (director) {
    director->swig_connect_director(jenv, jself, jenv->GetObjectClass(jself), (jswig_mem_own == JNI_TRUE), (jweak_global == JNI_TRUE));
  }
}


SWIGEXPORT void JNICALL Java_com_sleepycat_dbxml_dbxml_1javaJNI_XmlInputStream_1change_1ownership(JNIEnv *jenv, jclass jcls, jobject jself, jlong objarg, jboolean jtake_or_release) {
  XmlInputStream *obj = *((XmlInputStream **)&objarg);
  SwigDirector_XmlInputStream *director = dynamic_cast<SwigDirector_XmlInputStream *>(obj);
  (void)jcls;
  if (director) {
    director->swig_java_change_ownership(jenv, jself, jtake_or_release ? true : false);
  }
}


SWIGEXPORT jlong JNICALL Java_com_sleepycat_dbxml_dbxml_1javaJNI_new_1XmlResolver(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  XmlResolver *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  {
    jthrowable t = NULL;
    try {
      result = (XmlResolver *)new SwigDirector_XmlResolver(jenv);
    }
    catch (std::exception &se) {
      t = createException(jenv, &se);
      jenv->Throw(t);
      return 0;
    }
    catch(JavaException & /* je */) {
      // This means there's already an exception waiting in the JVM
      return 0;
    }
    catch (...) {
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("Uncaught exception from C++ API"), 0, 0, 0, 0);
      jenv->Throw(t);
      return 0;
    }
  }
  *(XmlResolver **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_sleepycat_dbxml_dbxml_1javaJNI_delete_1XmlResolver(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  XmlResolver *arg1 = (XmlResolver *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(XmlResolver **)&jarg1; 
  
  if (!jarg1) {
    jenv->Throw((jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INVALID_VALUE,
        jenv->NewStringUTF("null object - call after object destroyed?"),
        0, 0, 0, 0));					
    return ;
  }
  
  {
    jthrowable t = NULL;
    try {
      delete arg1;
    }
    catch (std::exception &se) {
      t = createException(jenv, &se);
      jenv->Throw(t);
      return ;
    }
    catch(JavaException & /* je */) {
      // This means there's already an exception waiting in the JVM
      return ;
    }
    catch (...) {
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("Uncaught exception from C++ API"), 0, 0, 0, 0);
      jenv->Throw(t);
      return ;
    }
  }
}


SWIGEXPORT jboolean JNICALL Java_com_sleepycat_dbxml_dbxml_1javaJNI_XmlResolver_1resolveDocument(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_, jlong jarg3, jobject jarg3_, jstring jarg4, jobject jarg5) {
  jboolean jresult = 0 ;
  XmlResolver *arg1 = (XmlResolver *) 0 ;
  XmlTransaction *arg2 = (XmlTransaction *) 0 ;
  XmlManager *arg3 = 0 ;
  std::string *arg4 = 0 ;
  XmlValue *arg5 = 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  (void)jarg3_;
  arg1 = *(XmlResolver **)&jarg1; 
  arg2 = *(XmlTransaction **)&jarg2; 
  arg3 = *(XmlManager **)&jarg3;
  if(!arg3) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "XmlManager & reference is null");
    return 0;
  } 
  
  const char *arg4_pstr = "";
  if(jarg4) {
    arg4_pstr = (const char *)jenv->GetStringUTFChars(jarg4, 0);
  }
  if (!arg4_pstr) return 0;
  std::string arg4_str(arg4_pstr);
  arg4 = &arg4_str;
  if (jarg4) {
    jenv->ReleaseStringUTFChars(jarg4, arg4_pstr);
  }
  
  
  bool valid = true;
  XmlValue val5 = createCPPXmlValue(jenv, jarg5, &valid);
  if (!valid) return 0;
  arg5 = &val5;
  
  
  if (!jarg1) {
    jenv->Throw((jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INVALID_VALUE,
        jenv->NewStringUTF("null object - call after object destroyed?"),
        0, 0, 0, 0));					
    return 0;
  }
  
  {
    jthrowable t = NULL;
    try {
      result = (bool)((XmlResolver const *)arg1)->resolveDocument(arg2,*arg3,(std::string const &)*arg4,*arg5);
    }
    catch (std::exception &se) {
      t = createException(jenv, &se);
      jenv->Throw(t);
      return 0;
    }
    catch(JavaException & /* je */) {
      // This means there's already an exception waiting in the JVM
      return 0;
    }
    catch (...) {
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("Uncaught exception from C++ API"), 0, 0, 0, 0);
      jenv->Throw(t);
      return 0;
    }
  }
  
  jresult = result ? JNI_TRUE : JNI_FALSE;
  
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_com_sleepycat_dbxml_dbxml_1javaJNI_XmlResolver_1resolveDocumentSwigExplicitXmlResolver(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_, jlong jarg3, jobject jarg3_, jstring jarg4, jobject jarg5) {
  jboolean jresult = 0 ;
  XmlResolver *arg1 = (XmlResolver *) 0 ;
  XmlTransaction *arg2 = (XmlTransaction *) 0 ;
  XmlManager *arg3 = 0 ;
  std::string *arg4 = 0 ;
  XmlValue *arg5 = 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  (void)jarg3_;
  arg1 = *(XmlResolver **)&jarg1; 
  arg2 = *(XmlTransaction **)&jarg2; 
  arg3 = *(XmlManager **)&jarg3;
  if(!arg3) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "XmlManager & reference is null");
    return 0;
  } 
  
  const char *arg4_pstr = "";
  if(jarg4) {
    arg4_pstr = (const char *)jenv->GetStringUTFChars(jarg4, 0);
  }
  if (!arg4_pstr) return 0;
  std::string arg4_str(arg4_pstr);
  arg4 = &arg4_str;
  if (jarg4) {
    jenv->ReleaseStringUTFChars(jarg4, arg4_pstr);
  }
  
  
  bool valid = true;
  XmlValue val5 = createCPPXmlValue(jenv, jarg5, &valid);
  if (!valid) return 0;
  arg5 = &val5;
  
  
  if (!jarg1) {
    jenv->Throw((jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INVALID_VALUE,
        jenv->NewStringUTF("null object - call after object destroyed?"),
        0, 0, 0, 0));					
    return 0;
  }
  
  {
    jthrowable t = NULL;
    try {
      result = (bool)((XmlResolver const *)arg1)->XmlResolver::resolveDocument(arg2,*arg3,(std::string const &)*arg4,*arg5);
    }
    catch (std::exception &se) {
      t = createException(jenv, &se);
      jenv->Throw(t);
      return 0;
    }
    catch(JavaException & /* je */) {
      // This means there's already an exception waiting in the JVM
      return 0;
    }
    catch (...) {
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("Uncaught exception from C++ API"), 0, 0, 0, 0);
      jenv->Throw(t);
      return 0;
    }
  }
  
  jresult = result ? JNI_TRUE : JNI_FALSE;
  
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_com_sleepycat_dbxml_dbxml_1javaJNI_XmlResolver_1resolveCollection(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_, jlong jarg3, jobject jarg3_, jstring jarg4, jlong jarg5, jobject jarg5_) {
  jboolean jresult = 0 ;
  XmlResolver *arg1 = (XmlResolver *) 0 ;
  XmlTransaction *arg2 = (XmlTransaction *) 0 ;
  XmlManager *arg3 = 0 ;
  std::string *arg4 = 0 ;
  XmlResults *arg5 = 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  (void)jarg3_;
  (void)jarg5_;
  arg1 = *(XmlResolver **)&jarg1; 
  arg2 = *(XmlTransaction **)&jarg2; 
  arg3 = *(XmlManager **)&jarg3;
  if(!arg3) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "XmlManager & reference is null");
    return 0;
  } 
  
  const char *arg4_pstr = "";
  if(jarg4) {
    arg4_pstr = (const char *)jenv->GetStringUTFChars(jarg4, 0);
  }
  if (!arg4_pstr) return 0;
  std::string arg4_str(arg4_pstr);
  arg4 = &arg4_str;
  if (jarg4) {
    jenv->ReleaseStringUTFChars(jarg4, arg4_pstr);
  }
  
  arg5 = *(XmlResults **)&jarg5;
  if(!arg5) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "XmlResults & reference is null");
    return 0;
  } 
  
  if (!jarg1) {
    jenv->Throw((jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INVALID_VALUE,
        jenv->NewStringUTF("null object - call after object destroyed?"),
        0, 0, 0, 0));					
    return 0;
  }
  
  {
    jthrowable t = NULL;
    try {
      result = (bool)((XmlResolver const *)arg1)->resolveCollection(arg2,*arg3,(std::string const &)*arg4,*arg5);
    }
    catch (std::exception &se) {
      t = createException(jenv, &se);
      jenv->Throw(t);
      return 0;
    }
    catch(JavaException & /* je */) {
      // This means there's already an exception waiting in the JVM
      return 0;
    }
    catch (...) {
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("Uncaught exception from C++ API"), 0, 0, 0, 0);
      jenv->Throw(t);
      return 0;
    }
  }
  
  jresult = result ? JNI_TRUE : JNI_FALSE;
  
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_com_sleepycat_dbxml_dbxml_1javaJNI_XmlResolver_1resolveCollectionSwigExplicitXmlResolver(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_, jlong jarg3, jobject jarg3_, jstring jarg4, jlong jarg5, jobject jarg5_) {
  jboolean jresult = 0 ;
  XmlResolver *arg1 = (XmlResolver *) 0 ;
  XmlTransaction *arg2 = (XmlTransaction *) 0 ;
  XmlManager *arg3 = 0 ;
  std::string *arg4 = 0 ;
  XmlResults *arg5 = 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  (void)jarg3_;
  (void)jarg5_;
  arg1 = *(XmlResolver **)&jarg1; 
  arg2 = *(XmlTransaction **)&jarg2; 
  arg3 = *(XmlManager **)&jarg3;
  if(!arg3) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "XmlManager & reference is null");
    return 0;
  } 
  
  const char *arg4_pstr = "";
  if(jarg4) {
    arg4_pstr = (const char *)jenv->GetStringUTFChars(jarg4, 0);
  }
  if (!arg4_pstr) return 0;
  std::string arg4_str(arg4_pstr);
  arg4 = &arg4_str;
  if (jarg4) {
    jenv->ReleaseStringUTFChars(jarg4, arg4_pstr);
  }
  
  arg5 = *(XmlResults **)&jarg5;
  if(!arg5) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "XmlResults & reference is null");
    return 0;
  } 
  
  if (!jarg1) {
    jenv->Throw((jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INVALID_VALUE,
        jenv->NewStringUTF("null object - call after object destroyed?"),
        0, 0, 0, 0));					
    return 0;
  }
  
  {
    jthrowable t = NULL;
    try {
      result = (bool)((XmlResolver const *)arg1)->XmlResolver::resolveCollection(arg2,*arg3,(std::string const &)*arg4,*arg5);
    }
    catch (std::exception &se) {
      t = createException(jenv, &se);
      jenv->Throw(t);
      return 0;
    }
    catch(JavaException & /* je */) {
      // This means there's already an exception waiting in the JVM
      return 0;
    }
    catch (...) {
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("Uncaught exception from C++ API"), 0, 0, 0, 0);
      jenv->Throw(t);
      return 0;
    }
  }
  
  jresult = result ? JNI_TRUE : JNI_FALSE;
  
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_sleepycat_dbxml_dbxml_1javaJNI_XmlResolver_1resolveSchema(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_, jlong jarg3, jobject jarg3_, jstring jarg4, jstring jarg5) {
  jlong jresult = 0 ;
  XmlResolver *arg1 = (XmlResolver *) 0 ;
  XmlTransaction *arg2 = (XmlTransaction *) 0 ;
  XmlManager *arg3 = 0 ;
  std::string *arg4 = 0 ;
  std::string *arg5 = 0 ;
  XmlInputStream *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  (void)jarg3_;
  arg1 = *(XmlResolver **)&jarg1; 
  arg2 = *(XmlTransaction **)&jarg2; 
  arg3 = *(XmlManager **)&jarg3;
  if(!arg3) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "XmlManager & reference is null");
    return 0;
  } 
  
  const char *arg4_pstr = "";
  if(jarg4) {
    arg4_pstr = (const char *)jenv->GetStringUTFChars(jarg4, 0);
  }
  if (!arg4_pstr) return 0;
  std::string arg4_str(arg4_pstr);
  arg4 = &arg4_str;
  if (jarg4) {
    jenv->ReleaseStringUTFChars(jarg4, arg4_pstr);
  }
  
  
  const char *arg5_pstr = "";
  if(jarg5) {
    arg5_pstr = (const char *)jenv->GetStringUTFChars(jarg5, 0);
  }
  if (!arg5_pstr) return 0;
  std::string arg5_str(arg5_pstr);
  arg5 = &arg5_str;
  if (jarg5) {
    jenv->ReleaseStringUTFChars(jarg5, arg5_pstr);
  }
  
  
  if (!jarg1) {
    jenv->Throw((jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INVALID_VALUE,
        jenv->NewStringUTF("null object - call after object destroyed?"),
        0, 0, 0, 0));					
    return 0;
  }
  
  {
    jthrowable t = NULL;
    try {
      result = (XmlInputStream *)((XmlResolver const *)arg1)->resolveSchema(arg2,*arg3,(std::string const &)*arg4,(std::string const &)*arg5);
    }
    catch (std::exception &se) {
      t = createException(jenv, &se);
      jenv->Throw(t);
      return 0;
    }
    catch(JavaException & /* je */) {
      // This means there's already an exception waiting in the JVM
      return 0;
    }
    catch (...) {
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("Uncaught exception from C++ API"), 0, 0, 0, 0);
      jenv->Throw(t);
      return 0;
    }
  }
  *(XmlInputStream **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_sleepycat_dbxml_dbxml_1javaJNI_XmlResolver_1resolveSchemaSwigExplicitXmlResolver(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_, jlong jarg3, jobject jarg3_, jstring jarg4, jstring jarg5) {
  jlong jresult = 0 ;
  XmlResolver *arg1 = (XmlResolver *) 0 ;
  XmlTransaction *arg2 = (XmlTransaction *) 0 ;
  XmlManager *arg3 = 0 ;
  std::string *arg4 = 0 ;
  std::string *arg5 = 0 ;
  XmlInputStream *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  (void)jarg3_;
  arg1 = *(XmlResolver **)&jarg1; 
  arg2 = *(XmlTransaction **)&jarg2; 
  arg3 = *(XmlManager **)&jarg3;
  if(!arg3) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "XmlManager & reference is null");
    return 0;
  } 
  
  const char *arg4_pstr = "";
  if(jarg4) {
    arg4_pstr = (const char *)jenv->GetStringUTFChars(jarg4, 0);
  }
  if (!arg4_pstr) return 0;
  std::string arg4_str(arg4_pstr);
  arg4 = &arg4_str;
  if (jarg4) {
    jenv->ReleaseStringUTFChars(jarg4, arg4_pstr);
  }
  
  
  const char *arg5_pstr = "";
  if(jarg5) {
    arg5_pstr = (const char *)jenv->GetStringUTFChars(jarg5, 0);
  }
  if (!arg5_pstr) return 0;
  std::string arg5_str(arg5_pstr);
  arg5 = &arg5_str;
  if (jarg5) {
    jenv->ReleaseStringUTFChars(jarg5, arg5_pstr);
  }
  
  
  if (!jarg1) {
    jenv->Throw((jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INVALID_VALUE,
        jenv->NewStringUTF("null object - call after object destroyed?"),
        0, 0, 0, 0));					
    return 0;
  }
  
  {
    jthrowable t = NULL;
    try {
      result = (XmlInputStream *)((XmlResolver const *)arg1)->XmlResolver::resolveSchema(arg2,*arg3,(std::string const &)*arg4,(std::string const &)*arg5);
    }
    catch (std::exception &se) {
      t = createException(jenv, &se);
      jenv->Throw(t);
      return 0;
    }
    catch(JavaException & /* je */) {
      // This means there's already an exception waiting in the JVM
      return 0;
    }
    catch (...) {
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("Uncaught exception from C++ API"), 0, 0, 0, 0);
      jenv->Throw(t);
      return 0;
    }
  }
  *(XmlInputStream **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_sleepycat_dbxml_dbxml_1javaJNI_XmlResolver_1resolveEntity(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_, jlong jarg3, jobject jarg3_, jstring jarg4, jstring jarg5) {
  jlong jresult = 0 ;
  XmlResolver *arg1 = (XmlResolver *) 0 ;
  XmlTransaction *arg2 = (XmlTransaction *) 0 ;
  XmlManager *arg3 = 0 ;
  std::string *arg4 = 0 ;
  std::string *arg5 = 0 ;
  XmlInputStream *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  (void)jarg3_;
  arg1 = *(XmlResolver **)&jarg1; 
  arg2 = *(XmlTransaction **)&jarg2; 
  arg3 = *(XmlManager **)&jarg3;
  if(!arg3) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "XmlManager & reference is null");
    return 0;
  } 
  
  const char *arg4_pstr = "";
  if(jarg4) {
    arg4_pstr = (const char *)jenv->GetStringUTFChars(jarg4, 0);
  }
  if (!arg4_pstr) return 0;
  std::string arg4_str(arg4_pstr);
  arg4 = &arg4_str;
  if (jarg4) {
    jenv->ReleaseStringUTFChars(jarg4, arg4_pstr);
  }
  
  
  const char *arg5_pstr = "";
  if(jarg5) {
    arg5_pstr = (const char *)jenv->GetStringUTFChars(jarg5, 0);
  }
  if (!arg5_pstr) return 0;
  std::string arg5_str(arg5_pstr);
  arg5 = &arg5_str;
  if (jarg5) {
    jenv->ReleaseStringUTFChars(jarg5, arg5_pstr);
  }
  
  
  if (!jarg1) {
    jenv->Throw((jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INVALID_VALUE,
        jenv->NewStringUTF("null object - call after object destroyed?"),
        0, 0, 0, 0));					
    return 0;
  }
  
  {
    jthrowable t = NULL;
    try {
      result = (XmlInputStream *)((XmlResolver const *)arg1)->resolveEntity(arg2,*arg3,(std::string const &)*arg4,(std::string const &)*arg5);
    }
    catch (std::exception &se) {
      t = createException(jenv, &se);
      jenv->Throw(t);
      return 0;
    }
    catch(JavaException & /* je */) {
      // This means there's already an exception waiting in the JVM
      return 0;
    }
    catch (...) {
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("Uncaught exception from C++ API"), 0, 0, 0, 0);
      jenv->Throw(t);
      return 0;
    }
  }
  *(XmlInputStream **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_sleepycat_dbxml_dbxml_1javaJNI_XmlResolver_1resolveEntitySwigExplicitXmlResolver(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_, jlong jarg3, jobject jarg3_, jstring jarg4, jstring jarg5) {
  jlong jresult = 0 ;
  XmlResolver *arg1 = (XmlResolver *) 0 ;
  XmlTransaction *arg2 = (XmlTransaction *) 0 ;
  XmlManager *arg3 = 0 ;
  std::string *arg4 = 0 ;
  std::string *arg5 = 0 ;
  XmlInputStream *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  (void)jarg3_;
  arg1 = *(XmlResolver **)&jarg1; 
  arg2 = *(XmlTransaction **)&jarg2; 
  arg3 = *(XmlManager **)&jarg3;
  if(!arg3) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "XmlManager & reference is null");
    return 0;
  } 
  
  const char *arg4_pstr = "";
  if(jarg4) {
    arg4_pstr = (const char *)jenv->GetStringUTFChars(jarg4, 0);
  }
  if (!arg4_pstr) return 0;
  std::string arg4_str(arg4_pstr);
  arg4 = &arg4_str;
  if (jarg4) {
    jenv->ReleaseStringUTFChars(jarg4, arg4_pstr);
  }
  
  
  const char *arg5_pstr = "";
  if(jarg5) {
    arg5_pstr = (const char *)jenv->GetStringUTFChars(jarg5, 0);
  }
  if (!arg5_pstr) return 0;
  std::string arg5_str(arg5_pstr);
  arg5 = &arg5_str;
  if (jarg5) {
    jenv->ReleaseStringUTFChars(jarg5, arg5_pstr);
  }
  
  
  if (!jarg1) {
    jenv->Throw((jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INVALID_VALUE,
        jenv->NewStringUTF("null object - call after object destroyed?"),
        0, 0, 0, 0));					
    return 0;
  }
  
  {
    jthrowable t = NULL;
    try {
      result = (XmlInputStream *)((XmlResolver const *)arg1)->XmlResolver::resolveEntity(arg2,*arg3,(std::string const &)*arg4,(std::string const &)*arg5);
    }
    catch (std::exception &se) {
      t = createException(jenv, &se);
      jenv->Throw(t);
      return 0;
    }
    catch(JavaException & /* je */) {
      // This means there's already an exception waiting in the JVM
      return 0;
    }
    catch (...) {
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("Uncaught exception from C++ API"), 0, 0, 0, 0);
      jenv->Throw(t);
      return 0;
    }
  }
  *(XmlInputStream **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_com_sleepycat_dbxml_dbxml_1javaJNI_XmlResolver_1resolveModuleLocation(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_, jlong jarg3, jobject jarg3_, jstring jarg4, jlong jarg5, jobject jarg5_) {
  jboolean jresult = 0 ;
  XmlResolver *arg1 = (XmlResolver *) 0 ;
  XmlTransaction *arg2 = (XmlTransaction *) 0 ;
  XmlManager *arg3 = 0 ;
  std::string *arg4 = 0 ;
  XmlResults *arg5 = 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  (void)jarg3_;
  (void)jarg5_;
  arg1 = *(XmlResolver **)&jarg1; 
  arg2 = *(XmlTransaction **)&jarg2; 
  arg3 = *(XmlManager **)&jarg3;
  if(!arg3) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "XmlManager & reference is null");
    return 0;
  } 
  
  const char *arg4_pstr = "";
  if(jarg4) {
    arg4_pstr = (const char *)jenv->GetStringUTFChars(jarg4, 0);
  }
  if (!arg4_pstr) return 0;
  std::string arg4_str(arg4_pstr);
  arg4 = &arg4_str;
  if (jarg4) {
    jenv->ReleaseStringUTFChars(jarg4, arg4_pstr);
  }
  
  arg5 = *(XmlResults **)&jarg5;
  if(!arg5) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "XmlResults & reference is null");
    return 0;
  } 
  
  if (!jarg1) {
    jenv->Throw((jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INVALID_VALUE,
        jenv->NewStringUTF("null object - call after object destroyed?"),
        0, 0, 0, 0));					
    return 0;
  }
  
  {
    jthrowable t = NULL;
    try {
      result = (bool)((XmlResolver const *)arg1)->resolveModuleLocation(arg2,*arg3,(std::string const &)*arg4,*arg5);
    }
    catch (std::exception &se) {
      t = createException(jenv, &se);
      jenv->Throw(t);
      return 0;
    }
    catch(JavaException & /* je */) {
      // This means there's already an exception waiting in the JVM
      return 0;
    }
    catch (...) {
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("Uncaught exception from C++ API"), 0, 0, 0, 0);
      jenv->Throw(t);
      return 0;
    }
  }
  
  jresult = result ? JNI_TRUE : JNI_FALSE;
  
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_com_sleepycat_dbxml_dbxml_1javaJNI_XmlResolver_1resolveModuleLocationSwigExplicitXmlResolver(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_, jlong jarg3, jobject jarg3_, jstring jarg4, jlong jarg5, jobject jarg5_) {
  jboolean jresult = 0 ;
  XmlResolver *arg1 = (XmlResolver *) 0 ;
  XmlTransaction *arg2 = (XmlTransaction *) 0 ;
  XmlManager *arg3 = 0 ;
  std::string *arg4 = 0 ;
  XmlResults *arg5 = 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  (void)jarg3_;
  (void)jarg5_;
  arg1 = *(XmlResolver **)&jarg1; 
  arg2 = *(XmlTransaction **)&jarg2; 
  arg3 = *(XmlManager **)&jarg3;
  if(!arg3) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "XmlManager & reference is null");
    return 0;
  } 
  
  const char *arg4_pstr = "";
  if(jarg4) {
    arg4_pstr = (const char *)jenv->GetStringUTFChars(jarg4, 0);
  }
  if (!arg4_pstr) return 0;
  std::string arg4_str(arg4_pstr);
  arg4 = &arg4_str;
  if (jarg4) {
    jenv->ReleaseStringUTFChars(jarg4, arg4_pstr);
  }
  
  arg5 = *(XmlResults **)&jarg5;
  if(!arg5) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "XmlResults & reference is null");
    return 0;
  } 
  
  if (!jarg1) {
    jenv->Throw((jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INVALID_VALUE,
        jenv->NewStringUTF("null object - call after object destroyed?"),
        0, 0, 0, 0));					
    return 0;
  }
  
  {
    jthrowable t = NULL;
    try {
      result = (bool)((XmlResolver const *)arg1)->XmlResolver::resolveModuleLocation(arg2,*arg3,(std::string const &)*arg4,*arg5);
    }
    catch (std::exception &se) {
      t = createException(jenv, &se);
      jenv->Throw(t);
      return 0;
    }
    catch(JavaException & /* je */) {
      // This means there's already an exception waiting in the JVM
      return 0;
    }
    catch (...) {
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("Uncaught exception from C++ API"), 0, 0, 0, 0);
      jenv->Throw(t);
      return 0;
    }
  }
  
  jresult = result ? JNI_TRUE : JNI_FALSE;
  
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_sleepycat_dbxml_dbxml_1javaJNI_XmlResolver_1resolveModule(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_, jlong jarg3, jobject jarg3_, jstring jarg4, jstring jarg5) {
  jlong jresult = 0 ;
  XmlResolver *arg1 = (XmlResolver *) 0 ;
  XmlTransaction *arg2 = (XmlTransaction *) 0 ;
  XmlManager *arg3 = 0 ;
  std::string *arg4 = 0 ;
  std::string *arg5 = 0 ;
  XmlInputStream *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  (void)jarg3_;
  arg1 = *(XmlResolver **)&jarg1; 
  arg2 = *(XmlTransaction **)&jarg2; 
  arg3 = *(XmlManager **)&jarg3;
  if(!arg3) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "XmlManager & reference is null");
    return 0;
  } 
  
  const char *arg4_pstr = "";
  if(jarg4) {
    arg4_pstr = (const char *)jenv->GetStringUTFChars(jarg4, 0);
  }
  if (!arg4_pstr) return 0;
  std::string arg4_str(arg4_pstr);
  arg4 = &arg4_str;
  if (jarg4) {
    jenv->ReleaseStringUTFChars(jarg4, arg4_pstr);
  }
  
  
  const char *arg5_pstr = "";
  if(jarg5) {
    arg5_pstr = (const char *)jenv->GetStringUTFChars(jarg5, 0);
  }
  if (!arg5_pstr) return 0;
  std::string arg5_str(arg5_pstr);
  arg5 = &arg5_str;
  if (jarg5) {
    jenv->ReleaseStringUTFChars(jarg5, arg5_pstr);
  }
  
  
  if (!jarg1) {
    jenv->Throw((jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INVALID_VALUE,
        jenv->NewStringUTF("null object - call after object destroyed?"),
        0, 0, 0, 0));					
    return 0;
  }
  
  {
    jthrowable t = NULL;
    try {
      result = (XmlInputStream *)((XmlResolver const *)arg1)->resolveModule(arg2,*arg3,(std::string const &)*arg4,(std::string const &)*arg5);
    }
    catch (std::exception &se) {
      t = createException(jenv, &se);
      jenv->Throw(t);
      return 0;
    }
    catch(JavaException & /* je */) {
      // This means there's already an exception waiting in the JVM
      return 0;
    }
    catch (...) {
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("Uncaught exception from C++ API"), 0, 0, 0, 0);
      jenv->Throw(t);
      return 0;
    }
  }
  *(XmlInputStream **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_sleepycat_dbxml_dbxml_1javaJNI_XmlResolver_1resolveModuleSwigExplicitXmlResolver(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_, jlong jarg3, jobject jarg3_, jstring jarg4, jstring jarg5) {
  jlong jresult = 0 ;
  XmlResolver *arg1 = (XmlResolver *) 0 ;
  XmlTransaction *arg2 = (XmlTransaction *) 0 ;
  XmlManager *arg3 = 0 ;
  std::string *arg4 = 0 ;
  std::string *arg5 = 0 ;
  XmlInputStream *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  (void)jarg3_;
  arg1 = *(XmlResolver **)&jarg1; 
  arg2 = *(XmlTransaction **)&jarg2; 
  arg3 = *(XmlManager **)&jarg3;
  if(!arg3) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "XmlManager & reference is null");
    return 0;
  } 
  
  const char *arg4_pstr = "";
  if(jarg4) {
    arg4_pstr = (const char *)jenv->GetStringUTFChars(jarg4, 0);
  }
  if (!arg4_pstr) return 0;
  std::string arg4_str(arg4_pstr);
  arg4 = &arg4_str;
  if (jarg4) {
    jenv->ReleaseStringUTFChars(jarg4, arg4_pstr);
  }
  
  
  const char *arg5_pstr = "";
  if(jarg5) {
    arg5_pstr = (const char *)jenv->GetStringUTFChars(jarg5, 0);
  }
  if (!arg5_pstr) return 0;
  std::string arg5_str(arg5_pstr);
  arg5 = &arg5_str;
  if (jarg5) {
    jenv->ReleaseStringUTFChars(jarg5, arg5_pstr);
  }
  
  
  if (!jarg1) {
    jenv->Throw((jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INVALID_VALUE,
        jenv->NewStringUTF("null object - call after object destroyed?"),
        0, 0, 0, 0));					
    return 0;
  }
  
  {
    jthrowable t = NULL;
    try {
      result = (XmlInputStream *)((XmlResolver const *)arg1)->XmlResolver::resolveModule(arg2,*arg3,(std::string const &)*arg4,(std::string const &)*arg5);
    }
    catch (std::exception &se) {
      t = createException(jenv, &se);
      jenv->Throw(t);
      return 0;
    }
    catch(JavaException & /* je */) {
      // This means there's already an exception waiting in the JVM
      return 0;
    }
    catch (...) {
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("Uncaught exception from C++ API"), 0, 0, 0, 0);
      jenv->Throw(t);
      return 0;
    }
  }
  *(XmlInputStream **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_sleepycat_dbxml_dbxml_1javaJNI_XmlResolver_1resolveExternalFunction(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_, jlong jarg3, jobject jarg3_, jstring jarg4, jstring jarg5, jint jarg6) {
  jlong jresult = 0 ;
  XmlResolver *arg1 = (XmlResolver *) 0 ;
  XmlTransaction *arg2 = (XmlTransaction *) 0 ;
  XmlManager *arg3 = 0 ;
  std::string *arg4 = 0 ;
  std::string *arg5 = 0 ;
  size_t arg6 ;
  XmlExternalFunction *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  (void)jarg3_;
  arg1 = *(XmlResolver **)&jarg1; 
  arg2 = *(XmlTransaction **)&jarg2; 
  arg3 = *(XmlManager **)&jarg3;
  if(!arg3) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "XmlManager & reference is null");
    return 0;
  } 
  
  const char *arg4_pstr = "";
  if(jarg4) {
    arg4_pstr = (const char *)jenv->GetStringUTFChars(jarg4, 0);
  }
  if (!arg4_pstr) return 0;
  std::string arg4_str(arg4_pstr);
  arg4 = &arg4_str;
  if (jarg4) {
    jenv->ReleaseStringUTFChars(jarg4, arg4_pstr);
  }
  
  
  const char *arg5_pstr = "";
  if(jarg5) {
    arg5_pstr = (const char *)jenv->GetStringUTFChars(jarg5, 0);
  }
  if (!arg5_pstr) return 0;
  std::string arg5_str(arg5_pstr);
  arg5 = &arg5_str;
  if (jarg5) {
    jenv->ReleaseStringUTFChars(jarg5, arg5_pstr);
  }
  
  arg6 = (size_t)jarg6; 
  
  if (!jarg1) {
    jenv->Throw((jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INVALID_VALUE,
        jenv->NewStringUTF("null object - call after object destroyed?"),
        0, 0, 0, 0));					
    return 0;
  }
  
  {
    jthrowable t = NULL;
    try {
      result = (XmlExternalFunction *)((XmlResolver const *)arg1)->resolveExternalFunction(arg2,*arg3,(std::string const &)*arg4,(std::string const &)*arg5,arg6);
    }
    catch (std::exception &se) {
      t = createException(jenv, &se);
      jenv->Throw(t);
      return 0;
    }
    catch(JavaException & /* je */) {
      // This means there's already an exception waiting in the JVM
      return 0;
    }
    catch (...) {
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("Uncaught exception from C++ API"), 0, 0, 0, 0);
      jenv->Throw(t);
      return 0;
    }
  }
  *(XmlExternalFunction **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_sleepycat_dbxml_dbxml_1javaJNI_XmlResolver_1resolveExternalFunctionSwigExplicitXmlResolver(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_, jlong jarg3, jobject jarg3_, jstring jarg4, jstring jarg5, jint jarg6) {
  jlong jresult = 0 ;
  XmlResolver *arg1 = (XmlResolver *) 0 ;
  XmlTransaction *arg2 = (XmlTransaction *) 0 ;
  XmlManager *arg3 = 0 ;
  std::string *arg4 = 0 ;
  std::string *arg5 = 0 ;
  size_t arg6 ;
  XmlExternalFunction *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  (void)jarg3_;
  arg1 = *(XmlResolver **)&jarg1; 
  arg2 = *(XmlTransaction **)&jarg2; 
  arg3 = *(XmlManager **)&jarg3;
  if(!arg3) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "XmlManager & reference is null");
    return 0;
  } 
  
  const char *arg4_pstr = "";
  if(jarg4) {
    arg4_pstr = (const char *)jenv->GetStringUTFChars(jarg4, 0);
  }
  if (!arg4_pstr) return 0;
  std::string arg4_str(arg4_pstr);
  arg4 = &arg4_str;
  if (jarg4) {
    jenv->ReleaseStringUTFChars(jarg4, arg4_pstr);
  }
  
  
  const char *arg5_pstr = "";
  if(jarg5) {
    arg5_pstr = (const char *)jenv->GetStringUTFChars(jarg5, 0);
  }
  if (!arg5_pstr) return 0;
  std::string arg5_str(arg5_pstr);
  arg5 = &arg5_str;
  if (jarg5) {
    jenv->ReleaseStringUTFChars(jarg5, arg5_pstr);
  }
  
  arg6 = (size_t)jarg6; 
  
  if (!jarg1) {
    jenv->Throw((jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INVALID_VALUE,
        jenv->NewStringUTF("null object - call after object destroyed?"),
        0, 0, 0, 0));					
    return 0;
  }
  
  {
    jthrowable t = NULL;
    try {
      result = (XmlExternalFunction *)((XmlResolver const *)arg1)->XmlResolver::resolveExternalFunction(arg2,*arg3,(std::string const &)*arg4,(std::string const &)*arg5,arg6);
    }
    catch (std::exception &se) {
      t = createException(jenv, &se);
      jenv->Throw(t);
      return 0;
    }
    catch(JavaException & /* je */) {
      // This means there's already an exception waiting in the JVM
      return 0;
    }
    catch (...) {
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("Uncaught exception from C++ API"), 0, 0, 0, 0);
      jenv->Throw(t);
      return 0;
    }
  }
  *(XmlExternalFunction **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_sleepycat_dbxml_dbxml_1javaJNI_XmlResolver_1director_1connect(JNIEnv *jenv, jclass jcls, jobject jself, jlong objarg, jboolean jswig_mem_own, jboolean jweak_global) {
  XmlResolver *obj = *((XmlResolver **)&objarg);
  (void)jcls;
  SwigDirector_XmlResolver *director = dynamic_cast<SwigDirector_XmlResolver *>(obj);
  if (director) {
    director->swig_connect_director(jenv, jself, jenv->GetObjectClass(jself), (jswig_mem_own == JNI_TRUE), (jweak_global == JNI_TRUE));
  }
}


SWIGEXPORT void JNICALL Java_com_sleepycat_dbxml_dbxml_1javaJNI_XmlResolver_1change_1ownership(JNIEnv *jenv, jclass jcls, jobject jself, jlong objarg, jboolean jtake_or_release) {
  XmlResolver *obj = *((XmlResolver **)&objarg);
  SwigDirector_XmlResolver *director = dynamic_cast<SwigDirector_XmlResolver *>(obj);
  (void)jcls;
  if (director) {
    director->swig_java_change_ownership(jenv, jself, jtake_or_release ? true : false);
  }
}


SWIGEXPORT void JNICALL Java_com_sleepycat_dbxml_dbxml_1javaJNI_delete_1XmlArguments(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  XmlArguments *arg1 = (XmlArguments *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(XmlArguments **)&jarg1; 
  
  if (!jarg1) {
    jenv->Throw((jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INVALID_VALUE,
        jenv->NewStringUTF("null object - call after object destroyed?"),
        0, 0, 0, 0));					
    return ;
  }
  
  {
    jthrowable t = NULL;
    try {
      delete arg1;
    }
    catch (std::exception &se) {
      t = createException(jenv, &se);
      jenv->Throw(t);
      return ;
    }
    catch(JavaException & /* je */) {
      // This means there's already an exception waiting in the JVM
      return ;
    }
    catch (...) {
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("Uncaught exception from C++ API"), 0, 0, 0, 0);
      jenv->Throw(t);
      return ;
    }
  }
}


SWIGEXPORT jlong JNICALL Java_com_sleepycat_dbxml_dbxml_1javaJNI_XmlArguments_1getArgument(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  jlong jresult = 0 ;
  XmlArguments *arg1 = (XmlArguments *) 0 ;
  size_t arg2 ;
  XmlResults result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(XmlArguments **)&jarg1; 
  arg2 = (size_t)jarg2; 
  
  if (!jarg1) {
    jenv->Throw((jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INVALID_VALUE,
        jenv->NewStringUTF("null object - call after object destroyed?"),
        0, 0, 0, 0));					
    return 0;
  }
  
  {
    jthrowable t = NULL;
    try {
      result = ((XmlArguments const *)arg1)->getArgument(arg2);
    }
    catch (std::exception &se) {
      t = createException(jenv, &se);
      jenv->Throw(t);
      return 0;
    }
    catch(JavaException & /* je */) {
      // This means there's already an exception waiting in the JVM
      return 0;
    }
    catch (...) {
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("Uncaught exception from C++ API"), 0, 0, 0, 0);
      jenv->Throw(t);
      return 0;
    }
  }
  *(XmlResults **)&jresult = new XmlResults((const XmlResults &)result); 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_sleepycat_dbxml_dbxml_1javaJNI_XmlArguments_1getNumberOfArgs(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  XmlArguments *arg1 = (XmlArguments *) 0 ;
  unsigned int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(XmlArguments **)&jarg1; 
  
  if (!jarg1) {
    jenv->Throw((jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INVALID_VALUE,
        jenv->NewStringUTF("null object - call after object destroyed?"),
        0, 0, 0, 0));					
    return 0;
  }
  
  {
    jthrowable t = NULL;
    try {
      result = (unsigned int)((XmlArguments const *)arg1)->getNumberOfArgs();
    }
    catch (std::exception &se) {
      t = createException(jenv, &se);
      jenv->Throw(t);
      return 0;
    }
    catch(JavaException & /* je */) {
      // This means there's already an exception waiting in the JVM
      return 0;
    }
    catch (...) {
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("Uncaught exception from C++ API"), 0, 0, 0, 0);
      jenv->Throw(t);
      return 0;
    }
  }
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_sleepycat_dbxml_dbxml_1javaJNI_new_1XmlExternalFunctionBase(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  XmlExternalFunction *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  {
    jthrowable t = NULL;
    try {
      result = (XmlExternalFunction *)new SwigDirector_XmlExternalFunctionBase(jenv);
    }
    catch (std::exception &se) {
      t = createException(jenv, &se);
      jenv->Throw(t);
      return 0;
    }
    catch(JavaException & /* je */) {
      // This means there's already an exception waiting in the JVM
      return 0;
    }
    catch (...) {
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("Uncaught exception from C++ API"), 0, 0, 0, 0);
      jenv->Throw(t);
      return 0;
    }
  }
  *(XmlExternalFunction **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_sleepycat_dbxml_dbxml_1javaJNI_delete_1XmlExternalFunctionBase(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  XmlExternalFunction *arg1 = (XmlExternalFunction *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(XmlExternalFunction **)&jarg1; 
  
  if (!jarg1) {
    jenv->Throw((jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INVALID_VALUE,
        jenv->NewStringUTF("null object - call after object destroyed?"),
        0, 0, 0, 0));					
    return ;
  }
  
  {
    jthrowable t = NULL;
    try {
      delete arg1;
    }
    catch (std::exception &se) {
      t = createException(jenv, &se);
      jenv->Throw(t);
      return ;
    }
    catch(JavaException & /* je */) {
      // This means there's already an exception waiting in the JVM
      return ;
    }
    catch (...) {
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("Uncaught exception from C++ API"), 0, 0, 0, 0);
      jenv->Throw(t);
      return ;
    }
  }
}


SWIGEXPORT jlong JNICALL Java_com_sleepycat_dbxml_dbxml_1javaJNI_XmlExternalFunctionBase_1execute(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_, jlong jarg3, jobject jarg3_, jlong jarg4, jobject jarg4_) {
  jlong jresult = 0 ;
  XmlExternalFunction *arg1 = (XmlExternalFunction *) 0 ;
  XmlTransaction *arg2 = 0 ;
  XmlManager *arg3 = 0 ;
  XmlArguments *arg4 = 0 ;
  XmlResults result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  (void)jarg3_;
  (void)jarg4_;
  arg1 = *(XmlExternalFunction **)&jarg1; 
  arg2 = *(XmlTransaction **)&jarg2;
  if(!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "XmlTransaction & reference is null");
    return 0;
  } 
  arg3 = *(XmlManager **)&jarg3;
  if(!arg3) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "XmlManager & reference is null");
    return 0;
  } 
  arg4 = *(XmlArguments **)&jarg4;
  if(!arg4) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "XmlArguments const & reference is null");
    return 0;
  } 
  
  if (!jarg1) {
    jenv->Throw((jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INVALID_VALUE,
        jenv->NewStringUTF("null object - call after object destroyed?"),
        0, 0, 0, 0));					
    return 0;
  }
  
  {
    jthrowable t = NULL;
    try {
      result = ((XmlExternalFunction const *)arg1)->execute(*arg2,*arg3,(XmlArguments const &)*arg4);
    }
    catch (std::exception &se) {
      t = createException(jenv, &se);
      jenv->Throw(t);
      return 0;
    }
    catch(JavaException & /* je */) {
      // This means there's already an exception waiting in the JVM
      return 0;
    }
    catch (...) {
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("Uncaught exception from C++ API"), 0, 0, 0, 0);
      jenv->Throw(t);
      return 0;
    }
  }
  *(XmlResults **)&jresult = new XmlResults((const XmlResults &)result); 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_sleepycat_dbxml_dbxml_1javaJNI_XmlExternalFunctionBase_1close(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  XmlExternalFunction *arg1 = (XmlExternalFunction *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(XmlExternalFunction **)&jarg1; 
  
  if (!jarg1) {
    jenv->Throw((jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INVALID_VALUE,
        jenv->NewStringUTF("null object - call after object destroyed?"),
        0, 0, 0, 0));					
    return ;
  }
  
  {
    jthrowable t = NULL;
    try {
      (arg1)->close();
    }
    catch (std::exception &se) {
      t = createException(jenv, &se);
      jenv->Throw(t);
      return ;
    }
    catch(JavaException & /* je */) {
      // This means there's already an exception waiting in the JVM
      return ;
    }
    catch (...) {
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("Uncaught exception from C++ API"), 0, 0, 0, 0);
      jenv->Throw(t);
      return ;
    }
  }
}


SWIGEXPORT void JNICALL Java_com_sleepycat_dbxml_dbxml_1javaJNI_XmlExternalFunctionBase_1director_1connect(JNIEnv *jenv, jclass jcls, jobject jself, jlong objarg, jboolean jswig_mem_own, jboolean jweak_global) {
  XmlExternalFunction *obj = *((XmlExternalFunction **)&objarg);
  (void)jcls;
  SwigDirector_XmlExternalFunctionBase *director = dynamic_cast<SwigDirector_XmlExternalFunctionBase *>(obj);
  if (director) {
    director->swig_connect_director(jenv, jself, jenv->GetObjectClass(jself), (jswig_mem_own == JNI_TRUE), (jweak_global == JNI_TRUE));
  }
}


SWIGEXPORT void JNICALL Java_com_sleepycat_dbxml_dbxml_1javaJNI_XmlExternalFunctionBase_1change_1ownership(JNIEnv *jenv, jclass jcls, jobject jself, jlong objarg, jboolean jtake_or_release) {
  XmlExternalFunction *obj = *((XmlExternalFunction **)&objarg);
  SwigDirector_XmlExternalFunctionBase *director = dynamic_cast<SwigDirector_XmlExternalFunctionBase *>(obj);
  (void)jcls;
  if (director) {
    director->swig_java_change_ownership(jenv, jself, jtake_or_release ? true : false);
  }
}


SWIGEXPORT jstring JNICALL Java_com_sleepycat_dbxml_dbxml_1javaJNI_XmlStackFrame_1getQueryFile(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jstring jresult = 0 ;
  XmlStackFrame *arg1 = (XmlStackFrame *) 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(XmlStackFrame **)&jarg1; 
  
  if (!jarg1) {
    jenv->Throw((jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INVALID_VALUE,
        jenv->NewStringUTF("null object - call after object destroyed?"),
        0, 0, 0, 0));					
    return 0;
  }
  
  {
    jthrowable t = NULL;
    try {
      result = (char *)((XmlStackFrame const *)arg1)->getQueryFile();
    }
    catch (std::exception &se) {
      t = createException(jenv, &se);
      jenv->Throw(t);
      return 0;
    }
    catch(JavaException & /* je */) {
      // This means there's already an exception waiting in the JVM
      return 0;
    }
    catch (...) {
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("Uncaught exception from C++ API"), 0, 0, 0, 0);
      jenv->Throw(t);
      return 0;
    }
  }
  if(result) jresult = jenv->NewStringUTF((const char *)result);
  return jresult;
}


SWIGEXPORT jint JNICALL Java_com_sleepycat_dbxml_dbxml_1javaJNI_XmlStackFrame_1getQueryLine(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  XmlStackFrame *arg1 = (XmlStackFrame *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(XmlStackFrame **)&jarg1; 
  
  if (!jarg1) {
    jenv->Throw((jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INVALID_VALUE,
        jenv->NewStringUTF("null object - call after object destroyed?"),
        0, 0, 0, 0));					
    return 0;
  }
  
  {
    jthrowable t = NULL;
    try {
      result = (int)((XmlStackFrame const *)arg1)->getQueryLine();
    }
    catch (std::exception &se) {
      t = createException(jenv, &se);
      jenv->Throw(t);
      return 0;
    }
    catch(JavaException & /* je */) {
      // This means there's already an exception waiting in the JVM
      return 0;
    }
    catch (...) {
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("Uncaught exception from C++ API"), 0, 0, 0, 0);
      jenv->Throw(t);
      return 0;
    }
  }
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_com_sleepycat_dbxml_dbxml_1javaJNI_XmlStackFrame_1getQueryColumn(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  XmlStackFrame *arg1 = (XmlStackFrame *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(XmlStackFrame **)&jarg1; 
  
  if (!jarg1) {
    jenv->Throw((jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INVALID_VALUE,
        jenv->NewStringUTF("null object - call after object destroyed?"),
        0, 0, 0, 0));					
    return 0;
  }
  
  {
    jthrowable t = NULL;
    try {
      result = (int)((XmlStackFrame const *)arg1)->getQueryColumn();
    }
    catch (std::exception &se) {
      t = createException(jenv, &se);
      jenv->Throw(t);
      return 0;
    }
    catch(JavaException & /* je */) {
      // This means there's already an exception waiting in the JVM
      return 0;
    }
    catch (...) {
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("Uncaught exception from C++ API"), 0, 0, 0, 0);
      jenv->Throw(t);
      return 0;
    }
  }
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_sleepycat_dbxml_dbxml_1javaJNI_XmlStackFrame_1query(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2) {
  jlong jresult = 0 ;
  XmlStackFrame *arg1 = (XmlStackFrame *) 0 ;
  std::string *arg2 = 0 ;
  XmlResults result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(XmlStackFrame **)&jarg1; 
  
  const char *arg2_pstr = "";
  if(jarg2) {
    arg2_pstr = (const char *)jenv->GetStringUTFChars(jarg2, 0);
  }
  if (!arg2_pstr) return 0;
  std::string arg2_str(arg2_pstr);
  arg2 = &arg2_str;
  if (jarg2) {
    jenv->ReleaseStringUTFChars(jarg2, arg2_pstr);
  }
  
  
  if (!jarg1) {
    jenv->Throw((jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INVALID_VALUE,
        jenv->NewStringUTF("null object - call after object destroyed?"),
        0, 0, 0, 0));					
    return 0;
  }
  
  {
    jthrowable t = NULL;
    try {
      result = ((XmlStackFrame const *)arg1)->query((std::string const &)*arg2);
    }
    catch (std::exception &se) {
      t = createException(jenv, &se);
      jenv->Throw(t);
      return 0;
    }
    catch(JavaException & /* je */) {
      // This means there's already an exception waiting in the JVM
      return 0;
    }
    catch (...) {
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("Uncaught exception from C++ API"), 0, 0, 0, 0);
      jenv->Throw(t);
      return 0;
    }
  }
  *(XmlResults **)&jresult = new XmlResults((const XmlResults &)result); 
  return jresult;
}


SWIGEXPORT jstring JNICALL Java_com_sleepycat_dbxml_dbxml_1javaJNI_XmlStackFrame_1getQueryPlan(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jstring jresult = 0 ;
  XmlStackFrame *arg1 = (XmlStackFrame *) 0 ;
  std::string result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(XmlStackFrame **)&jarg1; 
  
  if (!jarg1) {
    jenv->Throw((jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INVALID_VALUE,
        jenv->NewStringUTF("null object - call after object destroyed?"),
        0, 0, 0, 0));					
    return 0;
  }
  
  {
    jthrowable t = NULL;
    try {
      result = ((XmlStackFrame const *)arg1)->getQueryPlan();
    }
    catch (std::exception &se) {
      t = createException(jenv, &se);
      jenv->Throw(t);
      return 0;
    }
    catch(JavaException & /* je */) {
      // This means there's already an exception waiting in the JVM
      return 0;
    }
    catch (...) {
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("Uncaught exception from C++ API"), 0, 0, 0, 0);
      jenv->Throw(t);
      return 0;
    }
  }
  jresult = jenv->NewStringUTF((&result)->c_str()); 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_sleepycat_dbxml_dbxml_1javaJNI_XmlStackFrame_1getPreviousStackFrame(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  XmlStackFrame *arg1 = (XmlStackFrame *) 0 ;
  XmlStackFrame *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(XmlStackFrame **)&jarg1; 
  
  if (!jarg1) {
    jenv->Throw((jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INVALID_VALUE,
        jenv->NewStringUTF("null object - call after object destroyed?"),
        0, 0, 0, 0));					
    return 0;
  }
  
  {
    jthrowable t = NULL;
    try {
      result = (XmlStackFrame *)((XmlStackFrame const *)arg1)->getPreviousStackFrame();
    }
    catch (std::exception &se) {
      t = createException(jenv, &se);
      jenv->Throw(t);
      return 0;
    }
    catch(JavaException & /* je */) {
      // This means there's already an exception waiting in the JVM
      return 0;
    }
    catch (...) {
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("Uncaught exception from C++ API"), 0, 0, 0, 0);
      jenv->Throw(t);
      return 0;
    }
  }
  *(XmlStackFrame **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_com_sleepycat_dbxml_dbxml_1javaJNI_new_1XmlDebugListener(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  XmlDebugListener *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  {
    jthrowable t = NULL;
    try {
      result = (XmlDebugListener *)new SwigDirector_XmlDebugListener(jenv);
    }
    catch (std::exception &se) {
      t = createException(jenv, &se);
      jenv->Throw(t);
      return 0;
    }
    catch(JavaException & /* je */) {
      // This means there's already an exception waiting in the JVM
      return 0;
    }
    catch (...) {
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("Uncaught exception from C++ API"), 0, 0, 0, 0);
      jenv->Throw(t);
      return 0;
    }
  }
  *(XmlDebugListener **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_sleepycat_dbxml_dbxml_1javaJNI_delete_1XmlDebugListener(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  XmlDebugListener *arg1 = (XmlDebugListener *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(XmlDebugListener **)&jarg1; 
  
  if (!jarg1) {
    jenv->Throw((jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INVALID_VALUE,
        jenv->NewStringUTF("null object - call after object destroyed?"),
        0, 0, 0, 0));					
    return ;
  }
  
  {
    jthrowable t = NULL;
    try {
      delete arg1;
    }
    catch (std::exception &se) {
      t = createException(jenv, &se);
      jenv->Throw(t);
      return ;
    }
    catch(JavaException & /* je */) {
      // This means there's already an exception waiting in the JVM
      return ;
    }
    catch (...) {
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("Uncaught exception from C++ API"), 0, 0, 0, 0);
      jenv->Throw(t);
      return ;
    }
  }
}


SWIGEXPORT void JNICALL Java_com_sleepycat_dbxml_dbxml_1javaJNI_XmlDebugListener_1start(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  XmlDebugListener *arg1 = (XmlDebugListener *) 0 ;
  XmlStackFrame *arg2 = (XmlStackFrame *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(XmlDebugListener **)&jarg1; 
  arg2 = *(XmlStackFrame **)&jarg2; 
  
  if (!jarg1) {
    jenv->Throw((jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INVALID_VALUE,
        jenv->NewStringUTF("null object - call after object destroyed?"),
        0, 0, 0, 0));					
    return ;
  }
  
  {
    jthrowable t = NULL;
    try {
      (arg1)->start((XmlStackFrame const *)arg2);
    }
    catch (std::exception &se) {
      t = createException(jenv, &se);
      jenv->Throw(t);
      return ;
    }
    catch(JavaException & /* je */) {
      // This means there's already an exception waiting in the JVM
      return ;
    }
    catch (...) {
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("Uncaught exception from C++ API"), 0, 0, 0, 0);
      jenv->Throw(t);
      return ;
    }
  }
}


SWIGEXPORT void JNICALL Java_com_sleepycat_dbxml_dbxml_1javaJNI_XmlDebugListener_1startSwigExplicitXmlDebugListener(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  XmlDebugListener *arg1 = (XmlDebugListener *) 0 ;
  XmlStackFrame *arg2 = (XmlStackFrame *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(XmlDebugListener **)&jarg1; 
  arg2 = *(XmlStackFrame **)&jarg2; 
  
  if (!jarg1) {
    jenv->Throw((jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INVALID_VALUE,
        jenv->NewStringUTF("null object - call after object destroyed?"),
        0, 0, 0, 0));					
    return ;
  }
  
  {
    jthrowable t = NULL;
    try {
      (arg1)->XmlDebugListener::start((XmlStackFrame const *)arg2);
    }
    catch (std::exception &se) {
      t = createException(jenv, &se);
      jenv->Throw(t);
      return ;
    }
    catch(JavaException & /* je */) {
      // This means there's already an exception waiting in the JVM
      return ;
    }
    catch (...) {
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("Uncaught exception from C++ API"), 0, 0, 0, 0);
      jenv->Throw(t);
      return ;
    }
  }
}


SWIGEXPORT void JNICALL Java_com_sleepycat_dbxml_dbxml_1javaJNI_XmlDebugListener_1end(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  XmlDebugListener *arg1 = (XmlDebugListener *) 0 ;
  XmlStackFrame *arg2 = (XmlStackFrame *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(XmlDebugListener **)&jarg1; 
  arg2 = *(XmlStackFrame **)&jarg2; 
  
  if (!jarg1) {
    jenv->Throw((jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INVALID_VALUE,
        jenv->NewStringUTF("null object - call after object destroyed?"),
        0, 0, 0, 0));					
    return ;
  }
  
  {
    jthrowable t = NULL;
    try {
      (arg1)->end((XmlStackFrame const *)arg2);
    }
    catch (std::exception &se) {
      t = createException(jenv, &se);
      jenv->Throw(t);
      return ;
    }
    catch(JavaException & /* je */) {
      // This means there's already an exception waiting in the JVM
      return ;
    }
    catch (...) {
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("Uncaught exception from C++ API"), 0, 0, 0, 0);
      jenv->Throw(t);
      return ;
    }
  }
}


SWIGEXPORT void JNICALL Java_com_sleepycat_dbxml_dbxml_1javaJNI_XmlDebugListener_1endSwigExplicitXmlDebugListener(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  XmlDebugListener *arg1 = (XmlDebugListener *) 0 ;
  XmlStackFrame *arg2 = (XmlStackFrame *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(XmlDebugListener **)&jarg1; 
  arg2 = *(XmlStackFrame **)&jarg2; 
  
  if (!jarg1) {
    jenv->Throw((jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INVALID_VALUE,
        jenv->NewStringUTF("null object - call after object destroyed?"),
        0, 0, 0, 0));					
    return ;
  }
  
  {
    jthrowable t = NULL;
    try {
      (arg1)->XmlDebugListener::end((XmlStackFrame const *)arg2);
    }
    catch (std::exception &se) {
      t = createException(jenv, &se);
      jenv->Throw(t);
      return ;
    }
    catch(JavaException & /* je */) {
      // This means there's already an exception waiting in the JVM
      return ;
    }
    catch (...) {
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("Uncaught exception from C++ API"), 0, 0, 0, 0);
      jenv->Throw(t);
      return ;
    }
  }
}


SWIGEXPORT void JNICALL Java_com_sleepycat_dbxml_dbxml_1javaJNI_XmlDebugListener_1enter(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  XmlDebugListener *arg1 = (XmlDebugListener *) 0 ;
  XmlStackFrame *arg2 = (XmlStackFrame *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(XmlDebugListener **)&jarg1; 
  arg2 = *(XmlStackFrame **)&jarg2; 
  
  if (!jarg1) {
    jenv->Throw((jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INVALID_VALUE,
        jenv->NewStringUTF("null object - call after object destroyed?"),
        0, 0, 0, 0));					
    return ;
  }
  
  {
    jthrowable t = NULL;
    try {
      (arg1)->enter((XmlStackFrame const *)arg2);
    }
    catch (std::exception &se) {
      t = createException(jenv, &se);
      jenv->Throw(t);
      return ;
    }
    catch(JavaException & /* je */) {
      // This means there's already an exception waiting in the JVM
      return ;
    }
    catch (...) {
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("Uncaught exception from C++ API"), 0, 0, 0, 0);
      jenv->Throw(t);
      return ;
    }
  }
}


SWIGEXPORT void JNICALL Java_com_sleepycat_dbxml_dbxml_1javaJNI_XmlDebugListener_1enterSwigExplicitXmlDebugListener(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  XmlDebugListener *arg1 = (XmlDebugListener *) 0 ;
  XmlStackFrame *arg2 = (XmlStackFrame *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(XmlDebugListener **)&jarg1; 
  arg2 = *(XmlStackFrame **)&jarg2; 
  
  if (!jarg1) {
    jenv->Throw((jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INVALID_VALUE,
        jenv->NewStringUTF("null object - call after object destroyed?"),
        0, 0, 0, 0));					
    return ;
  }
  
  {
    jthrowable t = NULL;
    try {
      (arg1)->XmlDebugListener::enter((XmlStackFrame const *)arg2);
    }
    catch (std::exception &se) {
      t = createException(jenv, &se);
      jenv->Throw(t);
      return ;
    }
    catch(JavaException & /* je */) {
      // This means there's already an exception waiting in the JVM
      return ;
    }
    catch (...) {
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("Uncaught exception from C++ API"), 0, 0, 0, 0);
      jenv->Throw(t);
      return ;
    }
  }
}


SWIGEXPORT void JNICALL Java_com_sleepycat_dbxml_dbxml_1javaJNI_XmlDebugListener_1exit(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  XmlDebugListener *arg1 = (XmlDebugListener *) 0 ;
  XmlStackFrame *arg2 = (XmlStackFrame *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(XmlDebugListener **)&jarg1; 
  arg2 = *(XmlStackFrame **)&jarg2; 
  
  if (!jarg1) {
    jenv->Throw((jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INVALID_VALUE,
        jenv->NewStringUTF("null object - call after object destroyed?"),
        0, 0, 0, 0));					
    return ;
  }
  
  {
    jthrowable t = NULL;
    try {
      (arg1)->exit((XmlStackFrame const *)arg2);
    }
    catch (std::exception &se) {
      t = createException(jenv, &se);
      jenv->Throw(t);
      return ;
    }
    catch(JavaException & /* je */) {
      // This means there's already an exception waiting in the JVM
      return ;
    }
    catch (...) {
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("Uncaught exception from C++ API"), 0, 0, 0, 0);
      jenv->Throw(t);
      return ;
    }
  }
}


SWIGEXPORT void JNICALL Java_com_sleepycat_dbxml_dbxml_1javaJNI_XmlDebugListener_1exitSwigExplicitXmlDebugListener(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  XmlDebugListener *arg1 = (XmlDebugListener *) 0 ;
  XmlStackFrame *arg2 = (XmlStackFrame *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(XmlDebugListener **)&jarg1; 
  arg2 = *(XmlStackFrame **)&jarg2; 
  
  if (!jarg1) {
    jenv->Throw((jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INVALID_VALUE,
        jenv->NewStringUTF("null object - call after object destroyed?"),
        0, 0, 0, 0));					
    return ;
  }
  
  {
    jthrowable t = NULL;
    try {
      (arg1)->XmlDebugListener::exit((XmlStackFrame const *)arg2);
    }
    catch (std::exception &se) {
      t = createException(jenv, &se);
      jenv->Throw(t);
      return ;
    }
    catch(JavaException & /* je */) {
      // This means there's already an exception waiting in the JVM
      return ;
    }
    catch (...) {
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("Uncaught exception from C++ API"), 0, 0, 0, 0);
      jenv->Throw(t);
      return ;
    }
  }
}


SWIGEXPORT void JNICALL Java_com_sleepycat_dbxml_dbxml_1javaJNI_XmlDebugListener_1error(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jobject jarg2, jlong jarg3, jobject jarg3_) {
  XmlDebugListener *arg1 = (XmlDebugListener *) 0 ;
  XmlException *arg2 = 0 ;
  XmlStackFrame *arg3 = (XmlStackFrame *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg3_;
  arg1 = *(XmlDebugListener **)&jarg1; 
  
  /* Create a fake XmlException - it won't be needed */
  XmlException ex2(XmlException::INTERNAL_ERROR, "Pure virtual method called");
  arg2 = &ex2;
  
  arg3 = *(XmlStackFrame **)&jarg3; 
  
  if (!jarg1) {
    jenv->Throw((jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INVALID_VALUE,
        jenv->NewStringUTF("null object - call after object destroyed?"),
        0, 0, 0, 0));					
    return ;
  }
  
  {
    jthrowable t = NULL;
    try {
      (arg1)->error((XmlException const &)*arg2,(XmlStackFrame const *)arg3);
    }
    catch (std::exception &se) {
      t = createException(jenv, &se);
      jenv->Throw(t);
      return ;
    }
    catch(JavaException & /* je */) {
      // This means there's already an exception waiting in the JVM
      return ;
    }
    catch (...) {
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("Uncaught exception from C++ API"), 0, 0, 0, 0);
      jenv->Throw(t);
      return ;
    }
  }
}


SWIGEXPORT void JNICALL Java_com_sleepycat_dbxml_dbxml_1javaJNI_XmlDebugListener_1errorSwigExplicitXmlDebugListener(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jobject jarg2, jlong jarg3, jobject jarg3_) {
  XmlDebugListener *arg1 = (XmlDebugListener *) 0 ;
  XmlException *arg2 = 0 ;
  XmlStackFrame *arg3 = (XmlStackFrame *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg3_;
  arg1 = *(XmlDebugListener **)&jarg1; 
  
  /* Create a fake XmlException - it won't be needed */
  XmlException ex2(XmlException::INTERNAL_ERROR, "Pure virtual method called");
  arg2 = &ex2;
  
  arg3 = *(XmlStackFrame **)&jarg3; 
  
  if (!jarg1) {
    jenv->Throw((jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INVALID_VALUE,
        jenv->NewStringUTF("null object - call after object destroyed?"),
        0, 0, 0, 0));					
    return ;
  }
  
  {
    jthrowable t = NULL;
    try {
      (arg1)->XmlDebugListener::error((XmlException const &)*arg2,(XmlStackFrame const *)arg3);
    }
    catch (std::exception &se) {
      t = createException(jenv, &se);
      jenv->Throw(t);
      return ;
    }
    catch(JavaException & /* je */) {
      // This means there's already an exception waiting in the JVM
      return ;
    }
    catch (...) {
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("Uncaught exception from C++ API"), 0, 0, 0, 0);
      jenv->Throw(t);
      return ;
    }
  }
}


SWIGEXPORT void JNICALL Java_com_sleepycat_dbxml_dbxml_1javaJNI_XmlDebugListener_1director_1connect(JNIEnv *jenv, jclass jcls, jobject jself, jlong objarg, jboolean jswig_mem_own, jboolean jweak_global) {
  XmlDebugListener *obj = *((XmlDebugListener **)&objarg);
  (void)jcls;
  SwigDirector_XmlDebugListener *director = dynamic_cast<SwigDirector_XmlDebugListener *>(obj);
  if (director) {
    director->swig_connect_director(jenv, jself, jenv->GetObjectClass(jself), (jswig_mem_own == JNI_TRUE), (jweak_global == JNI_TRUE));
  }
}


SWIGEXPORT void JNICALL Java_com_sleepycat_dbxml_dbxml_1javaJNI_XmlDebugListener_1change_1ownership(JNIEnv *jenv, jclass jcls, jobject jself, jlong objarg, jboolean jtake_or_release) {
  XmlDebugListener *obj = *((XmlDebugListener **)&objarg);
  SwigDirector_XmlDebugListener *director = dynamic_cast<SwigDirector_XmlDebugListener *>(obj);
  (void)jcls;
  if (director) {
    director->swig_java_change_ownership(jenv, jself, jtake_or_release ? true : false);
  }
}


SWIGEXPORT jlong JNICALL Java_com_sleepycat_dbxml_dbxml_1javaJNI_new_1XmlCompression(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  XmlCompression *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  {
    jthrowable t = NULL;
    try {
      result = (XmlCompression *)new SwigDirector_XmlCompression(jenv);
    }
    catch (std::exception &se) {
      t = createException(jenv, &se);
      jenv->Throw(t);
      return 0;
    }
    catch(JavaException & /* je */) {
      // This means there's already an exception waiting in the JVM
      return 0;
    }
    catch (...) {
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("Uncaught exception from C++ API"), 0, 0, 0, 0);
      jenv->Throw(t);
      return 0;
    }
  }
  *(XmlCompression **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_sleepycat_dbxml_dbxml_1javaJNI_delete_1XmlCompression(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  XmlCompression *arg1 = (XmlCompression *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(XmlCompression **)&jarg1; 
  
  if (!jarg1) {
    jenv->Throw((jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INVALID_VALUE,
        jenv->NewStringUTF("null object - call after object destroyed?"),
        0, 0, 0, 0));					
    return ;
  }
  
  {
    jthrowable t = NULL;
    try {
      delete arg1;
    }
    catch (std::exception &se) {
      t = createException(jenv, &se);
      jenv->Throw(t);
      return ;
    }
    catch(JavaException & /* je */) {
      // This means there's already an exception waiting in the JVM
      return ;
    }
    catch (...) {
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("Uncaught exception from C++ API"), 0, 0, 0, 0);
      jenv->Throw(t);
      return ;
    }
  }
}


SWIGEXPORT jboolean JNICALL Java_com_sleepycat_dbxml_dbxml_1javaJNI_XmlCompression_1compress(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_, jlong jarg3, jobject jarg3_, jlong jarg4, jobject jarg4_) {
  jboolean jresult = 0 ;
  XmlCompression *arg1 = (XmlCompression *) 0 ;
  XmlTransaction *arg2 = 0 ;
  XmlData *arg3 = 0 ;
  XmlData *arg4 = 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  (void)jarg3_;
  (void)jarg4_;
  arg1 = *(XmlCompression **)&jarg1; 
  arg2 = *(XmlTransaction **)&jarg2;
  if(!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "XmlTransaction & reference is null");
    return 0;
  } 
  arg3 = *(XmlData **)&jarg3;
  if(!arg3) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "XmlData const & reference is null");
    return 0;
  } 
  arg4 = *(XmlData **)&jarg4;
  if(!arg4) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "XmlData & reference is null");
    return 0;
  } 
  
  if (!jarg1) {
    jenv->Throw((jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INVALID_VALUE,
        jenv->NewStringUTF("null object - call after object destroyed?"),
        0, 0, 0, 0));					
    return 0;
  }
  
  {
    jthrowable t = NULL;
    try {
      result = (bool)(arg1)->compress(*arg2,(XmlData const &)*arg3,*arg4);
    }
    catch (std::exception &se) {
      t = createException(jenv, &se);
      jenv->Throw(t);
      return 0;
    }
    catch(JavaException & /* je */) {
      // This means there's already an exception waiting in the JVM
      return 0;
    }
    catch (...) {
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("Uncaught exception from C++ API"), 0, 0, 0, 0);
      jenv->Throw(t);
      return 0;
    }
  }
  
  jresult = result ? JNI_TRUE : JNI_FALSE;
  
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_com_sleepycat_dbxml_dbxml_1javaJNI_XmlCompression_1decompress(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_, jlong jarg3, jobject jarg3_, jlong jarg4, jobject jarg4_) {
  jboolean jresult = 0 ;
  XmlCompression *arg1 = (XmlCompression *) 0 ;
  XmlTransaction *arg2 = 0 ;
  XmlData *arg3 = 0 ;
  XmlData *arg4 = 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  (void)jarg3_;
  (void)jarg4_;
  arg1 = *(XmlCompression **)&jarg1; 
  arg2 = *(XmlTransaction **)&jarg2;
  if(!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "XmlTransaction & reference is null");
    return 0;
  } 
  arg3 = *(XmlData **)&jarg3;
  if(!arg3) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "XmlData const & reference is null");
    return 0;
  } 
  arg4 = *(XmlData **)&jarg4;
  if(!arg4) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "XmlData & reference is null");
    return 0;
  } 
  
  if (!jarg1) {
    jenv->Throw((jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INVALID_VALUE,
        jenv->NewStringUTF("null object - call after object destroyed?"),
        0, 0, 0, 0));					
    return 0;
  }
  
  {
    jthrowable t = NULL;
    try {
      result = (bool)(arg1)->decompress(*arg2,(XmlData const &)*arg3,*arg4);
    }
    catch (std::exception &se) {
      t = createException(jenv, &se);
      jenv->Throw(t);
      return 0;
    }
    catch(JavaException & /* je */) {
      // This means there's already an exception waiting in the JVM
      return 0;
    }
    catch (...) {
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("Uncaught exception from C++ API"), 0, 0, 0, 0);
      jenv->Throw(t);
      return 0;
    }
  }
  
  jresult = result ? JNI_TRUE : JNI_FALSE;
  
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_sleepycat_dbxml_dbxml_1javaJNI_XmlCompression_1director_1connect(JNIEnv *jenv, jclass jcls, jobject jself, jlong objarg, jboolean jswig_mem_own, jboolean jweak_global) {
  XmlCompression *obj = *((XmlCompression **)&objarg);
  (void)jcls;
  SwigDirector_XmlCompression *director = dynamic_cast<SwigDirector_XmlCompression *>(obj);
  if (director) {
    director->swig_connect_director(jenv, jself, jenv->GetObjectClass(jself), (jswig_mem_own == JNI_TRUE), (jweak_global == JNI_TRUE));
  }
}


SWIGEXPORT void JNICALL Java_com_sleepycat_dbxml_dbxml_1javaJNI_XmlCompression_1change_1ownership(JNIEnv *jenv, jclass jcls, jobject jself, jlong objarg, jboolean jtake_or_release) {
  XmlCompression *obj = *((XmlCompression **)&objarg);
  SwigDirector_XmlCompression *director = dynamic_cast<SwigDirector_XmlCompression *>(obj);
  (void)jcls;
  if (director) {
    director->swig_java_change_ownership(jenv, jself, jtake_or_release ? true : false);
  }
}


SWIGEXPORT void JNICALL Java_com_sleepycat_dbxml_dbxml_1javaJNI_delete_1XmlTransaction(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  XmlTransaction *arg1 = (XmlTransaction *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(XmlTransaction **)&jarg1; 
  
  if (!jarg1) {
    jenv->Throw((jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INVALID_VALUE,
        jenv->NewStringUTF("null object - call after object destroyed?"),
        0, 0, 0, 0));					
    return ;
  }
  
  {
    jthrowable t = NULL;
    try {
      delete arg1;
    }
    catch (std::exception &se) {
      t = createException(jenv, &se);
      jenv->Throw(t);
      return ;
    }
    catch(JavaException & /* je */) {
      // This means there's already an exception waiting in the JVM
      return ;
    }
    catch (...) {
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("Uncaught exception from C++ API"), 0, 0, 0, 0);
      jenv->Throw(t);
      return ;
    }
  }
}


SWIGEXPORT jlong JNICALL Java_com_sleepycat_dbxml_dbxml_1javaJNI_new_1XmlStatistics(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  XmlStatistics *arg1 = 0 ;
  XmlStatistics *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(XmlStatistics **)&jarg1;
  if(!arg1) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "XmlStatistics const & reference is null");
    return 0;
  } 
  {
    jthrowable t = NULL;
    try {
      result = (XmlStatistics *)new XmlStatistics((XmlStatistics const &)*arg1);
    }
    catch (std::exception &se) {
      t = createException(jenv, &se);
      jenv->Throw(t);
      return 0;
    }
    catch(JavaException & /* je */) {
      // This means there's already an exception waiting in the JVM
      return 0;
    }
    catch (...) {
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("Uncaught exception from C++ API"), 0, 0, 0, 0);
      jenv->Throw(t);
      return 0;
    }
  }
  *(XmlStatistics **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_sleepycat_dbxml_dbxml_1javaJNI_delete_1XmlStatistics(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  XmlStatistics *arg1 = (XmlStatistics *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(XmlStatistics **)&jarg1; 
  
  if (!jarg1) {
    jenv->Throw((jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INVALID_VALUE,
        jenv->NewStringUTF("null object - call after object destroyed?"),
        0, 0, 0, 0));					
    return ;
  }
  
  {
    jthrowable t = NULL;
    try {
      delete arg1;
    }
    catch (std::exception &se) {
      t = createException(jenv, &se);
      jenv->Throw(t);
      return ;
    }
    catch(JavaException & /* je */) {
      // This means there's already an exception waiting in the JVM
      return ;
    }
    catch (...) {
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("Uncaught exception from C++ API"), 0, 0, 0, 0);
      jenv->Throw(t);
      return ;
    }
  }
}


SWIGEXPORT jdouble JNICALL Java_com_sleepycat_dbxml_dbxml_1javaJNI_XmlStatistics_1getNumberOfIndexedKeys(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jdouble jresult = 0 ;
  XmlStatistics *arg1 = (XmlStatistics *) 0 ;
  double result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(XmlStatistics **)&jarg1; 
  
  if (!jarg1) {
    jenv->Throw((jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INVALID_VALUE,
        jenv->NewStringUTF("null object - call after object destroyed?"),
        0, 0, 0, 0));					
    return 0;
  }
  
  {
    jthrowable t = NULL;
    try {
      result = (double)((XmlStatistics const *)arg1)->getNumberOfIndexedKeys();
    }
    catch (std::exception &se) {
      t = createException(jenv, &se);
      jenv->Throw(t);
      return 0;
    }
    catch(JavaException & /* je */) {
      // This means there's already an exception waiting in the JVM
      return 0;
    }
    catch (...) {
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("Uncaught exception from C++ API"), 0, 0, 0, 0);
      jenv->Throw(t);
      return 0;
    }
  }
  jresult = (jdouble)result; 
  return jresult;
}


SWIGEXPORT jdouble JNICALL Java_com_sleepycat_dbxml_dbxml_1javaJNI_XmlStatistics_1getNumberOfUniqueKeys(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jdouble jresult = 0 ;
  XmlStatistics *arg1 = (XmlStatistics *) 0 ;
  double result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(XmlStatistics **)&jarg1; 
  
  if (!jarg1) {
    jenv->Throw((jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INVALID_VALUE,
        jenv->NewStringUTF("null object - call after object destroyed?"),
        0, 0, 0, 0));					
    return 0;
  }
  
  {
    jthrowable t = NULL;
    try {
      result = (double)((XmlStatistics const *)arg1)->getNumberOfUniqueKeys();
    }
    catch (std::exception &se) {
      t = createException(jenv, &se);
      jenv->Throw(t);
      return 0;
    }
    catch(JavaException & /* je */) {
      // This means there's already an exception waiting in the JVM
      return 0;
    }
    catch (...) {
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("Uncaught exception from C++ API"), 0, 0, 0, 0);
      jenv->Throw(t);
      return 0;
    }
  }
  jresult = (jdouble)result; 
  return jresult;
}


SWIGEXPORT jdouble JNICALL Java_com_sleepycat_dbxml_dbxml_1javaJNI_XmlStatistics_1getSumKeyValueSize(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jdouble jresult = 0 ;
  XmlStatistics *arg1 = (XmlStatistics *) 0 ;
  double result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(XmlStatistics **)&jarg1; 
  
  if (!jarg1) {
    jenv->Throw((jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INVALID_VALUE,
        jenv->NewStringUTF("null object - call after object destroyed?"),
        0, 0, 0, 0));					
    return 0;
  }
  
  {
    jthrowable t = NULL;
    try {
      result = (double)((XmlStatistics const *)arg1)->getSumKeyValueSize();
    }
    catch (std::exception &se) {
      t = createException(jenv, &se);
      jenv->Throw(t);
      return 0;
    }
    catch(JavaException & /* je */) {
      // This means there's already an exception waiting in the JVM
      return 0;
    }
    catch (...) {
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("Uncaught exception from C++ API"), 0, 0, 0, 0);
      jenv->Throw(t);
      return 0;
    }
  }
  jresult = (jdouble)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_sleepycat_dbxml_dbxml_1javaJNI_delete_1XmlEventReader(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  XmlEventReader *arg1 = (XmlEventReader *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(XmlEventReader **)&jarg1; 
  
  if (!jarg1) {
    jenv->Throw((jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INVALID_VALUE,
        jenv->NewStringUTF("null object - call after object destroyed?"),
        0, 0, 0, 0));					
    return ;
  }
  
  {
    jthrowable t = NULL;
    try {
      delete arg1;
    }
    catch (std::exception &se) {
      t = createException(jenv, &se);
      jenv->Throw(t);
      return ;
    }
    catch(JavaException & /* je */) {
      // This means there's already an exception waiting in the JVM
      return ;
    }
    catch (...) {
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("Uncaught exception from C++ API"), 0, 0, 0, 0);
      jenv->Throw(t);
      return ;
    }
  }
}


SWIGEXPORT void JNICALL Java_com_sleepycat_dbxml_dbxml_1javaJNI_XmlEventReader_1closeInternal(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  XmlEventReader *arg1 = (XmlEventReader *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(XmlEventReader **)&jarg1; 
  
  if (!jarg1) {
    jenv->Throw((jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INVALID_VALUE,
        jenv->NewStringUTF("null object - call after object destroyed?"),
        0, 0, 0, 0));					
    return ;
  }
  
  {
    jthrowable t = NULL;
    try {
      (arg1)->close();
    }
    catch (std::exception &se) {
      t = createException(jenv, &se);
      jenv->Throw(t);
      return ;
    }
    catch(JavaException & /* je */) {
      // This means there's already an exception waiting in the JVM
      return ;
    }
    catch (...) {
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("Uncaught exception from C++ API"), 0, 0, 0, 0);
      jenv->Throw(t);
      return ;
    }
  }
}


SWIGEXPORT void JNICALL Java_com_sleepycat_dbxml_dbxml_1javaJNI_XmlEventReader_1setReportEntityInfo(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jboolean jarg2) {
  XmlEventReader *arg1 = (XmlEventReader *) 0 ;
  bool arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(XmlEventReader **)&jarg1; 
  
  arg2 = (jarg2 != JNI_FALSE);
  
  
  if (!jarg1) {
    jenv->Throw((jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INVALID_VALUE,
        jenv->NewStringUTF("null object - call after object destroyed?"),
        0, 0, 0, 0));					
    return ;
  }
  
  {
    jthrowable t = NULL;
    try {
      (arg1)->setReportEntityInfo(arg2);
    }
    catch (std::exception &se) {
      t = createException(jenv, &se);
      jenv->Throw(t);
      return ;
    }
    catch(JavaException & /* je */) {
      // This means there's already an exception waiting in the JVM
      return ;
    }
    catch (...) {
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("Uncaught exception from C++ API"), 0, 0, 0, 0);
      jenv->Throw(t);
      return ;
    }
  }
}


SWIGEXPORT jboolean JNICALL Java_com_sleepycat_dbxml_dbxml_1javaJNI_XmlEventReader_1getReportEntityInfo(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jboolean jresult = 0 ;
  XmlEventReader *arg1 = (XmlEventReader *) 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(XmlEventReader **)&jarg1; 
  
  if (!jarg1) {
    jenv->Throw((jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INVALID_VALUE,
        jenv->NewStringUTF("null object - call after object destroyed?"),
        0, 0, 0, 0));					
    return 0;
  }
  
  {
    jthrowable t = NULL;
    try {
      result = (bool)((XmlEventReader const *)arg1)->getReportEntityInfo();
    }
    catch (std::exception &se) {
      t = createException(jenv, &se);
      jenv->Throw(t);
      return 0;
    }
    catch(JavaException & /* je */) {
      // This means there's already an exception waiting in the JVM
      return 0;
    }
    catch (...) {
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("Uncaught exception from C++ API"), 0, 0, 0, 0);
      jenv->Throw(t);
      return 0;
    }
  }
  
  jresult = result ? JNI_TRUE : JNI_FALSE;
  
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_sleepycat_dbxml_dbxml_1javaJNI_XmlEventReader_1setExpandEntities(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jboolean jarg2) {
  XmlEventReader *arg1 = (XmlEventReader *) 0 ;
  bool arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(XmlEventReader **)&jarg1; 
  
  arg2 = (jarg2 != JNI_FALSE);
  
  
  if (!jarg1) {
    jenv->Throw((jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INVALID_VALUE,
        jenv->NewStringUTF("null object - call after object destroyed?"),
        0, 0, 0, 0));					
    return ;
  }
  
  {
    jthrowable t = NULL;
    try {
      (arg1)->setExpandEntities(arg2);
    }
    catch (std::exception &se) {
      t = createException(jenv, &se);
      jenv->Throw(t);
      return ;
    }
    catch(JavaException & /* je */) {
      // This means there's already an exception waiting in the JVM
      return ;
    }
    catch (...) {
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("Uncaught exception from C++ API"), 0, 0, 0, 0);
      jenv->Throw(t);
      return ;
    }
  }
}


SWIGEXPORT jboolean JNICALL Java_com_sleepycat_dbxml_dbxml_1javaJNI_XmlEventReader_1getExpandEntities(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jboolean jresult = 0 ;
  XmlEventReader *arg1 = (XmlEventReader *) 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(XmlEventReader **)&jarg1; 
  
  if (!jarg1) {
    jenv->Throw((jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INVALID_VALUE,
        jenv->NewStringUTF("null object - call after object destroyed?"),
        0, 0, 0, 0));					
    return 0;
  }
  
  {
    jthrowable t = NULL;
    try {
      result = (bool)((XmlEventReader const *)arg1)->getExpandEntities();
    }
    catch (std::exception &se) {
      t = createException(jenv, &se);
      jenv->Throw(t);
      return 0;
    }
    catch(JavaException & /* je */) {
      // This means there's already an exception waiting in the JVM
      return 0;
    }
    catch (...) {
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("Uncaught exception from C++ API"), 0, 0, 0, 0);
      jenv->Throw(t);
      return 0;
    }
  }
  
  jresult = result ? JNI_TRUE : JNI_FALSE;
  
  return jresult;
}


SWIGEXPORT jint JNICALL Java_com_sleepycat_dbxml_dbxml_1javaJNI_XmlEventReader_1next(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  XmlEventReader *arg1 = (XmlEventReader *) 0 ;
  enum XmlEventReader::XmlEventType result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(XmlEventReader **)&jarg1; 
  
  if (!jarg1) {
    jenv->Throw((jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INVALID_VALUE,
        jenv->NewStringUTF("null object - call after object destroyed?"),
        0, 0, 0, 0));					
    return 0;
  }
  
  {
    jthrowable t = NULL;
    try {
      result = (enum XmlEventReader::XmlEventType)(arg1)->next();
    }
    catch (std::exception &se) {
      t = createException(jenv, &se);
      jenv->Throw(t);
      return 0;
    }
    catch(JavaException & /* je */) {
      // This means there's already an exception waiting in the JVM
      return 0;
    }
    catch (...) {
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("Uncaught exception from C++ API"), 0, 0, 0, 0);
      jenv->Throw(t);
      return 0;
    }
  }
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_com_sleepycat_dbxml_dbxml_1javaJNI_XmlEventReader_1nextTag(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  XmlEventReader *arg1 = (XmlEventReader *) 0 ;
  enum XmlEventReader::XmlEventType result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(XmlEventReader **)&jarg1; 
  
  if (!jarg1) {
    jenv->Throw((jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INVALID_VALUE,
        jenv->NewStringUTF("null object - call after object destroyed?"),
        0, 0, 0, 0));					
    return 0;
  }
  
  {
    jthrowable t = NULL;
    try {
      result = (enum XmlEventReader::XmlEventType)(arg1)->nextTag();
    }
    catch (std::exception &se) {
      t = createException(jenv, &se);
      jenv->Throw(t);
      return 0;
    }
    catch(JavaException & /* je */) {
      // This means there's already an exception waiting in the JVM
      return 0;
    }
    catch (...) {
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("Uncaught exception from C++ API"), 0, 0, 0, 0);
      jenv->Throw(t);
      return 0;
    }
  }
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_com_sleepycat_dbxml_dbxml_1javaJNI_XmlEventReader_1hasNext(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jboolean jresult = 0 ;
  XmlEventReader *arg1 = (XmlEventReader *) 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(XmlEventReader **)&jarg1; 
  
  if (!jarg1) {
    jenv->Throw((jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INVALID_VALUE,
        jenv->NewStringUTF("null object - call after object destroyed?"),
        0, 0, 0, 0));					
    return 0;
  }
  
  {
    jthrowable t = NULL;
    try {
      result = (bool)((XmlEventReader const *)arg1)->hasNext();
    }
    catch (std::exception &se) {
      t = createException(jenv, &se);
      jenv->Throw(t);
      return 0;
    }
    catch(JavaException & /* je */) {
      // This means there's already an exception waiting in the JVM
      return 0;
    }
    catch (...) {
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("Uncaught exception from C++ API"), 0, 0, 0, 0);
      jenv->Throw(t);
      return 0;
    }
  }
  
  jresult = result ? JNI_TRUE : JNI_FALSE;
  
  return jresult;
}


SWIGEXPORT jint JNICALL Java_com_sleepycat_dbxml_dbxml_1javaJNI_XmlEventReader_1getEventType(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  XmlEventReader *arg1 = (XmlEventReader *) 0 ;
  enum XmlEventReader::XmlEventType result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(XmlEventReader **)&jarg1; 
  
  if (!jarg1) {
    jenv->Throw((jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INVALID_VALUE,
        jenv->NewStringUTF("null object - call after object destroyed?"),
        0, 0, 0, 0));					
    return 0;
  }
  
  {
    jthrowable t = NULL;
    try {
      result = (enum XmlEventReader::XmlEventType)((XmlEventReader const *)arg1)->getEventType();
    }
    catch (std::exception &se) {
      t = createException(jenv, &se);
      jenv->Throw(t);
      return 0;
    }
    catch(JavaException & /* je */) {
      // This means there's already an exception waiting in the JVM
      return 0;
    }
    catch (...) {
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("Uncaught exception from C++ API"), 0, 0, 0, 0);
      jenv->Throw(t);
      return 0;
    }
  }
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jstring JNICALL Java_com_sleepycat_dbxml_dbxml_1javaJNI_XmlEventReader_1getNamespaceURI(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jstring jresult = 0 ;
  XmlEventReader *arg1 = (XmlEventReader *) 0 ;
  unsigned char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(XmlEventReader **)&jarg1; 
  
  if (!jarg1) {
    jenv->Throw((jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INVALID_VALUE,
        jenv->NewStringUTF("null object - call after object destroyed?"),
        0, 0, 0, 0));					
    return 0;
  }
  
  {
    jthrowable t = NULL;
    try {
      result = (unsigned char *)((XmlEventReader const *)arg1)->getNamespaceURI();
    }
    catch (std::exception &se) {
      t = createException(jenv, &se);
      jenv->Throw(t);
      return 0;
    }
    catch(JavaException & /* je */) {
      // This means there's already an exception waiting in the JVM
      return 0;
    }
    catch (...) {
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("Uncaught exception from C++ API"), 0, 0, 0, 0);
      jenv->Throw(t);
      return 0;
    }
  }
  if (result) jresult = jenv->NewStringUTF((const char *) result);
  return jresult;
}


SWIGEXPORT jstring JNICALL Java_com_sleepycat_dbxml_dbxml_1javaJNI_XmlEventReader_1getLocalName(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jstring jresult = 0 ;
  XmlEventReader *arg1 = (XmlEventReader *) 0 ;
  unsigned char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(XmlEventReader **)&jarg1; 
  
  if (!jarg1) {
    jenv->Throw((jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INVALID_VALUE,
        jenv->NewStringUTF("null object - call after object destroyed?"),
        0, 0, 0, 0));					
    return 0;
  }
  
  {
    jthrowable t = NULL;
    try {
      result = (unsigned char *)((XmlEventReader const *)arg1)->getLocalName();
    }
    catch (std::exception &se) {
      t = createException(jenv, &se);
      jenv->Throw(t);
      return 0;
    }
    catch(JavaException & /* je */) {
      // This means there's already an exception waiting in the JVM
      return 0;
    }
    catch (...) {
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("Uncaught exception from C++ API"), 0, 0, 0, 0);
      jenv->Throw(t);
      return 0;
    }
  }
  if (result) jresult = jenv->NewStringUTF((const char *) result);
  return jresult;
}


SWIGEXPORT jstring JNICALL Java_com_sleepycat_dbxml_dbxml_1javaJNI_XmlEventReader_1getPrefix(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jstring jresult = 0 ;
  XmlEventReader *arg1 = (XmlEventReader *) 0 ;
  unsigned char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(XmlEventReader **)&jarg1; 
  
  if (!jarg1) {
    jenv->Throw((jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INVALID_VALUE,
        jenv->NewStringUTF("null object - call after object destroyed?"),
        0, 0, 0, 0));					
    return 0;
  }
  
  {
    jthrowable t = NULL;
    try {
      result = (unsigned char *)((XmlEventReader const *)arg1)->getPrefix();
    }
    catch (std::exception &se) {
      t = createException(jenv, &se);
      jenv->Throw(t);
      return 0;
    }
    catch(JavaException & /* je */) {
      // This means there's already an exception waiting in the JVM
      return 0;
    }
    catch (...) {
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("Uncaught exception from C++ API"), 0, 0, 0, 0);
      jenv->Throw(t);
      return 0;
    }
  }
  if (result) jresult = jenv->NewStringUTF((const char *) result);
  return jresult;
}


SWIGEXPORT jstring JNICALL Java_com_sleepycat_dbxml_dbxml_1javaJNI_XmlEventReader_1getValue(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jstring jresult = 0 ;
  XmlEventReader *arg1 = (XmlEventReader *) 0 ;
  unsigned char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(XmlEventReader **)&jarg1; 
  
  if (!jarg1) {
    jenv->Throw((jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INVALID_VALUE,
        jenv->NewStringUTF("null object - call after object destroyed?"),
        0, 0, 0, 0));					
    return 0;
  }
  
  {
    jthrowable t = NULL;
    try {
      result = (unsigned char *)XmlEventReader_getValue((XmlEventReader const *)arg1);
    }
    catch (std::exception &se) {
      t = createException(jenv, &se);
      jenv->Throw(t);
      return 0;
    }
    catch(JavaException & /* je */) {
      // This means there's already an exception waiting in the JVM
      return 0;
    }
    catch (...) {
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("Uncaught exception from C++ API"), 0, 0, 0, 0);
      jenv->Throw(t);
      return 0;
    }
  }
  if (result) jresult = jenv->NewStringUTF((const char *) result);
  return jresult;
}


SWIGEXPORT jint JNICALL Java_com_sleepycat_dbxml_dbxml_1javaJNI_XmlEventReader_1getAttributeCount(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  XmlEventReader *arg1 = (XmlEventReader *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(XmlEventReader **)&jarg1; 
  
  if (!jarg1) {
    jenv->Throw((jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INVALID_VALUE,
        jenv->NewStringUTF("null object - call after object destroyed?"),
        0, 0, 0, 0));					
    return 0;
  }
  
  {
    jthrowable t = NULL;
    try {
      result = (int)((XmlEventReader const *)arg1)->getAttributeCount();
    }
    catch (std::exception &se) {
      t = createException(jenv, &se);
      jenv->Throw(t);
      return 0;
    }
    catch(JavaException & /* je */) {
      // This means there's already an exception waiting in the JVM
      return 0;
    }
    catch (...) {
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("Uncaught exception from C++ API"), 0, 0, 0, 0);
      jenv->Throw(t);
      return 0;
    }
  }
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_com_sleepycat_dbxml_dbxml_1javaJNI_XmlEventReader_1isAttributeSpecified(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  jboolean jresult = 0 ;
  XmlEventReader *arg1 = (XmlEventReader *) 0 ;
  int arg2 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(XmlEventReader **)&jarg1; 
  arg2 = (int)jarg2; 
  
  if (!jarg1) {
    jenv->Throw((jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INVALID_VALUE,
        jenv->NewStringUTF("null object - call after object destroyed?"),
        0, 0, 0, 0));					
    return 0;
  }
  
  {
    jthrowable t = NULL;
    try {
      result = (bool)((XmlEventReader const *)arg1)->isAttributeSpecified(arg2);
    }
    catch (std::exception &se) {
      t = createException(jenv, &se);
      jenv->Throw(t);
      return 0;
    }
    catch(JavaException & /* je */) {
      // This means there's already an exception waiting in the JVM
      return 0;
    }
    catch (...) {
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("Uncaught exception from C++ API"), 0, 0, 0, 0);
      jenv->Throw(t);
      return 0;
    }
  }
  
  jresult = result ? JNI_TRUE : JNI_FALSE;
  
  return jresult;
}


SWIGEXPORT jstring JNICALL Java_com_sleepycat_dbxml_dbxml_1javaJNI_XmlEventReader_1getAttributeLocalName(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  jstring jresult = 0 ;
  XmlEventReader *arg1 = (XmlEventReader *) 0 ;
  int arg2 ;
  unsigned char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(XmlEventReader **)&jarg1; 
  arg2 = (int)jarg2; 
  
  if (!jarg1) {
    jenv->Throw((jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INVALID_VALUE,
        jenv->NewStringUTF("null object - call after object destroyed?"),
        0, 0, 0, 0));					
    return 0;
  }
  
  {
    jthrowable t = NULL;
    try {
      result = (unsigned char *)((XmlEventReader const *)arg1)->getAttributeLocalName(arg2);
    }
    catch (std::exception &se) {
      t = createException(jenv, &se);
      jenv->Throw(t);
      return 0;
    }
    catch(JavaException & /* je */) {
      // This means there's already an exception waiting in the JVM
      return 0;
    }
    catch (...) {
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("Uncaught exception from C++ API"), 0, 0, 0, 0);
      jenv->Throw(t);
      return 0;
    }
  }
  if (result) jresult = jenv->NewStringUTF((const char *) result);
  return jresult;
}


SWIGEXPORT jstring JNICALL Java_com_sleepycat_dbxml_dbxml_1javaJNI_XmlEventReader_1getAttributeNamespaceURI(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  jstring jresult = 0 ;
  XmlEventReader *arg1 = (XmlEventReader *) 0 ;
  int arg2 ;
  unsigned char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(XmlEventReader **)&jarg1; 
  arg2 = (int)jarg2; 
  
  if (!jarg1) {
    jenv->Throw((jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INVALID_VALUE,
        jenv->NewStringUTF("null object - call after object destroyed?"),
        0, 0, 0, 0));					
    return 0;
  }
  
  {
    jthrowable t = NULL;
    try {
      result = (unsigned char *)((XmlEventReader const *)arg1)->getAttributeNamespaceURI(arg2);
    }
    catch (std::exception &se) {
      t = createException(jenv, &se);
      jenv->Throw(t);
      return 0;
    }
    catch(JavaException & /* je */) {
      // This means there's already an exception waiting in the JVM
      return 0;
    }
    catch (...) {
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("Uncaught exception from C++ API"), 0, 0, 0, 0);
      jenv->Throw(t);
      return 0;
    }
  }
  if (result) jresult = jenv->NewStringUTF((const char *) result);
  return jresult;
}


SWIGEXPORT jstring JNICALL Java_com_sleepycat_dbxml_dbxml_1javaJNI_XmlEventReader_1getAttributePrefix(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  jstring jresult = 0 ;
  XmlEventReader *arg1 = (XmlEventReader *) 0 ;
  int arg2 ;
  unsigned char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(XmlEventReader **)&jarg1; 
  arg2 = (int)jarg2; 
  
  if (!jarg1) {
    jenv->Throw((jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INVALID_VALUE,
        jenv->NewStringUTF("null object - call after object destroyed?"),
        0, 0, 0, 0));					
    return 0;
  }
  
  {
    jthrowable t = NULL;
    try {
      result = (unsigned char *)((XmlEventReader const *)arg1)->getAttributePrefix(arg2);
    }
    catch (std::exception &se) {
      t = createException(jenv, &se);
      jenv->Throw(t);
      return 0;
    }
    catch(JavaException & /* je */) {
      // This means there's already an exception waiting in the JVM
      return 0;
    }
    catch (...) {
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("Uncaught exception from C++ API"), 0, 0, 0, 0);
      jenv->Throw(t);
      return 0;
    }
  }
  if (result) jresult = jenv->NewStringUTF((const char *) result);
  return jresult;
}


SWIGEXPORT jstring JNICALL Java_com_sleepycat_dbxml_dbxml_1javaJNI_XmlEventReader_1getAttributeValue(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  jstring jresult = 0 ;
  XmlEventReader *arg1 = (XmlEventReader *) 0 ;
  int arg2 ;
  unsigned char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(XmlEventReader **)&jarg1; 
  arg2 = (int)jarg2; 
  
  if (!jarg1) {
    jenv->Throw((jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INVALID_VALUE,
        jenv->NewStringUTF("null object - call after object destroyed?"),
        0, 0, 0, 0));					
    return 0;
  }
  
  {
    jthrowable t = NULL;
    try {
      result = (unsigned char *)((XmlEventReader const *)arg1)->getAttributeValue(arg2);
    }
    catch (std::exception &se) {
      t = createException(jenv, &se);
      jenv->Throw(t);
      return 0;
    }
    catch(JavaException & /* je */) {
      // This means there's already an exception waiting in the JVM
      return 0;
    }
    catch (...) {
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("Uncaught exception from C++ API"), 0, 0, 0, 0);
      jenv->Throw(t);
      return 0;
    }
  }
  if (result) jresult = jenv->NewStringUTF((const char *) result);
  return jresult;
}


SWIGEXPORT jstring JNICALL Java_com_sleepycat_dbxml_dbxml_1javaJNI_XmlEventReader_1getEncoding(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jstring jresult = 0 ;
  XmlEventReader *arg1 = (XmlEventReader *) 0 ;
  unsigned char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(XmlEventReader **)&jarg1; 
  
  if (!jarg1) {
    jenv->Throw((jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INVALID_VALUE,
        jenv->NewStringUTF("null object - call after object destroyed?"),
        0, 0, 0, 0));					
    return 0;
  }
  
  {
    jthrowable t = NULL;
    try {
      result = (unsigned char *)((XmlEventReader const *)arg1)->getEncoding();
    }
    catch (std::exception &se) {
      t = createException(jenv, &se);
      jenv->Throw(t);
      return 0;
    }
    catch(JavaException & /* je */) {
      // This means there's already an exception waiting in the JVM
      return 0;
    }
    catch (...) {
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("Uncaught exception from C++ API"), 0, 0, 0, 0);
      jenv->Throw(t);
      return 0;
    }
  }
  if (result) jresult = jenv->NewStringUTF((const char *) result);
  return jresult;
}


SWIGEXPORT jstring JNICALL Java_com_sleepycat_dbxml_dbxml_1javaJNI_XmlEventReader_1getVersion(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jstring jresult = 0 ;
  XmlEventReader *arg1 = (XmlEventReader *) 0 ;
  unsigned char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(XmlEventReader **)&jarg1; 
  
  if (!jarg1) {
    jenv->Throw((jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INVALID_VALUE,
        jenv->NewStringUTF("null object - call after object destroyed?"),
        0, 0, 0, 0));					
    return 0;
  }
  
  {
    jthrowable t = NULL;
    try {
      result = (unsigned char *)((XmlEventReader const *)arg1)->getVersion();
    }
    catch (std::exception &se) {
      t = createException(jenv, &se);
      jenv->Throw(t);
      return 0;
    }
    catch(JavaException & /* je */) {
      // This means there's already an exception waiting in the JVM
      return 0;
    }
    catch (...) {
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("Uncaught exception from C++ API"), 0, 0, 0, 0);
      jenv->Throw(t);
      return 0;
    }
  }
  if (result) jresult = jenv->NewStringUTF((const char *) result);
  return jresult;
}


SWIGEXPORT jstring JNICALL Java_com_sleepycat_dbxml_dbxml_1javaJNI_XmlEventReader_1getSystemId(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jstring jresult = 0 ;
  XmlEventReader *arg1 = (XmlEventReader *) 0 ;
  unsigned char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(XmlEventReader **)&jarg1; 
  
  if (!jarg1) {
    jenv->Throw((jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INVALID_VALUE,
        jenv->NewStringUTF("null object - call after object destroyed?"),
        0, 0, 0, 0));					
    return 0;
  }
  
  {
    jthrowable t = NULL;
    try {
      result = (unsigned char *)((XmlEventReader const *)arg1)->getSystemId();
    }
    catch (std::exception &se) {
      t = createException(jenv, &se);
      jenv->Throw(t);
      return 0;
    }
    catch(JavaException & /* je */) {
      // This means there's already an exception waiting in the JVM
      return 0;
    }
    catch (...) {
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("Uncaught exception from C++ API"), 0, 0, 0, 0);
      jenv->Throw(t);
      return 0;
    }
  }
  if (result) jresult = jenv->NewStringUTF((const char *) result);
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_com_sleepycat_dbxml_dbxml_1javaJNI_XmlEventReader_1isStandalone(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jboolean jresult = 0 ;
  XmlEventReader *arg1 = (XmlEventReader *) 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(XmlEventReader **)&jarg1; 
  
  if (!jarg1) {
    jenv->Throw((jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INVALID_VALUE,
        jenv->NewStringUTF("null object - call after object destroyed?"),
        0, 0, 0, 0));					
    return 0;
  }
  
  {
    jthrowable t = NULL;
    try {
      result = (bool)((XmlEventReader const *)arg1)->isStandalone();
    }
    catch (std::exception &se) {
      t = createException(jenv, &se);
      jenv->Throw(t);
      return 0;
    }
    catch(JavaException & /* je */) {
      // This means there's already an exception waiting in the JVM
      return 0;
    }
    catch (...) {
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("Uncaught exception from C++ API"), 0, 0, 0, 0);
      jenv->Throw(t);
      return 0;
    }
  }
  
  jresult = result ? JNI_TRUE : JNI_FALSE;
  
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_com_sleepycat_dbxml_dbxml_1javaJNI_XmlEventReader_1standaloneSet(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jboolean jresult = 0 ;
  XmlEventReader *arg1 = (XmlEventReader *) 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(XmlEventReader **)&jarg1; 
  
  if (!jarg1) {
    jenv->Throw((jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INVALID_VALUE,
        jenv->NewStringUTF("null object - call after object destroyed?"),
        0, 0, 0, 0));					
    return 0;
  }
  
  {
    jthrowable t = NULL;
    try {
      result = (bool)((XmlEventReader const *)arg1)->standaloneSet();
    }
    catch (std::exception &se) {
      t = createException(jenv, &se);
      jenv->Throw(t);
      return 0;
    }
    catch(JavaException & /* je */) {
      // This means there's already an exception waiting in the JVM
      return 0;
    }
    catch (...) {
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("Uncaught exception from C++ API"), 0, 0, 0, 0);
      jenv->Throw(t);
      return 0;
    }
  }
  
  jresult = result ? JNI_TRUE : JNI_FALSE;
  
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_com_sleepycat_dbxml_dbxml_1javaJNI_XmlEventReader_1encodingSet(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jboolean jresult = 0 ;
  XmlEventReader *arg1 = (XmlEventReader *) 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(XmlEventReader **)&jarg1; 
  
  if (!jarg1) {
    jenv->Throw((jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INVALID_VALUE,
        jenv->NewStringUTF("null object - call after object destroyed?"),
        0, 0, 0, 0));					
    return 0;
  }
  
  {
    jthrowable t = NULL;
    try {
      result = (bool)((XmlEventReader const *)arg1)->encodingSet();
    }
    catch (std::exception &se) {
      t = createException(jenv, &se);
      jenv->Throw(t);
      return 0;
    }
    catch(JavaException & /* je */) {
      // This means there's already an exception waiting in the JVM
      return 0;
    }
    catch (...) {
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("Uncaught exception from C++ API"), 0, 0, 0, 0);
      jenv->Throw(t);
      return 0;
    }
  }
  
  jresult = result ? JNI_TRUE : JNI_FALSE;
  
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_com_sleepycat_dbxml_dbxml_1javaJNI_XmlEventReader_1hasEntityEscapeInfo(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jboolean jresult = 0 ;
  XmlEventReader *arg1 = (XmlEventReader *) 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(XmlEventReader **)&jarg1; 
  
  if (!jarg1) {
    jenv->Throw((jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INVALID_VALUE,
        jenv->NewStringUTF("null object - call after object destroyed?"),
        0, 0, 0, 0));					
    return 0;
  }
  
  {
    jthrowable t = NULL;
    try {
      result = (bool)((XmlEventReader const *)arg1)->hasEntityEscapeInfo();
    }
    catch (std::exception &se) {
      t = createException(jenv, &se);
      jenv->Throw(t);
      return 0;
    }
    catch(JavaException & /* je */) {
      // This means there's already an exception waiting in the JVM
      return 0;
    }
    catch (...) {
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("Uncaught exception from C++ API"), 0, 0, 0, 0);
      jenv->Throw(t);
      return 0;
    }
  }
  
  jresult = result ? JNI_TRUE : JNI_FALSE;
  
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_com_sleepycat_dbxml_dbxml_1javaJNI_XmlEventReader_1needsEntityEscape_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  jboolean jresult = 0 ;
  XmlEventReader *arg1 = (XmlEventReader *) 0 ;
  int arg2 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(XmlEventReader **)&jarg1; 
  arg2 = (int)jarg2; 
  
  if (!jarg1) {
    jenv->Throw((jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INVALID_VALUE,
        jenv->NewStringUTF("null object - call after object destroyed?"),
        0, 0, 0, 0));					
    return 0;
  }
  
  {
    jthrowable t = NULL;
    try {
      result = (bool)((XmlEventReader const *)arg1)->needsEntityEscape(arg2);
    }
    catch (std::exception &se) {
      t = createException(jenv, &se);
      jenv->Throw(t);
      return 0;
    }
    catch(JavaException & /* je */) {
      // This means there's already an exception waiting in the JVM
      return 0;
    }
    catch (...) {
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("Uncaught exception from C++ API"), 0, 0, 0, 0);
      jenv->Throw(t);
      return 0;
    }
  }
  
  jresult = result ? JNI_TRUE : JNI_FALSE;
  
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_com_sleepycat_dbxml_dbxml_1javaJNI_XmlEventReader_1needsEntityEscape_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jboolean jresult = 0 ;
  XmlEventReader *arg1 = (XmlEventReader *) 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(XmlEventReader **)&jarg1; 
  
  if (!jarg1) {
    jenv->Throw((jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INVALID_VALUE,
        jenv->NewStringUTF("null object - call after object destroyed?"),
        0, 0, 0, 0));					
    return 0;
  }
  
  {
    jthrowable t = NULL;
    try {
      result = (bool)((XmlEventReader const *)arg1)->needsEntityEscape();
    }
    catch (std::exception &se) {
      t = createException(jenv, &se);
      jenv->Throw(t);
      return 0;
    }
    catch(JavaException & /* je */) {
      // This means there's already an exception waiting in the JVM
      return 0;
    }
    catch (...) {
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("Uncaught exception from C++ API"), 0, 0, 0, 0);
      jenv->Throw(t);
      return 0;
    }
  }
  
  jresult = result ? JNI_TRUE : JNI_FALSE;
  
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_com_sleepycat_dbxml_dbxml_1javaJNI_XmlEventReader_1hasEmptyElementInfo(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jboolean jresult = 0 ;
  XmlEventReader *arg1 = (XmlEventReader *) 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(XmlEventReader **)&jarg1; 
  
  if (!jarg1) {
    jenv->Throw((jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INVALID_VALUE,
        jenv->NewStringUTF("null object - call after object destroyed?"),
        0, 0, 0, 0));					
    return 0;
  }
  
  {
    jthrowable t = NULL;
    try {
      result = (bool)((XmlEventReader const *)arg1)->hasEmptyElementInfo();
    }
    catch (std::exception &se) {
      t = createException(jenv, &se);
      jenv->Throw(t);
      return 0;
    }
    catch(JavaException & /* je */) {
      // This means there's already an exception waiting in the JVM
      return 0;
    }
    catch (...) {
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("Uncaught exception from C++ API"), 0, 0, 0, 0);
      jenv->Throw(t);
      return 0;
    }
  }
  
  jresult = result ? JNI_TRUE : JNI_FALSE;
  
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_com_sleepycat_dbxml_dbxml_1javaJNI_XmlEventReader_1isEmptyElement(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jboolean jresult = 0 ;
  XmlEventReader *arg1 = (XmlEventReader *) 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(XmlEventReader **)&jarg1; 
  
  if (!jarg1) {
    jenv->Throw((jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INVALID_VALUE,
        jenv->NewStringUTF("null object - call after object destroyed?"),
        0, 0, 0, 0));					
    return 0;
  }
  
  {
    jthrowable t = NULL;
    try {
      result = (bool)((XmlEventReader const *)arg1)->isEmptyElement();
    }
    catch (std::exception &se) {
      t = createException(jenv, &se);
      jenv->Throw(t);
      return 0;
    }
    catch(JavaException & /* je */) {
      // This means there's already an exception waiting in the JVM
      return 0;
    }
    catch (...) {
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("Uncaught exception from C++ API"), 0, 0, 0, 0);
      jenv->Throw(t);
      return 0;
    }
  }
  
  jresult = result ? JNI_TRUE : JNI_FALSE;
  
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_com_sleepycat_dbxml_dbxml_1javaJNI_XmlEventReader_1isWhiteSpace(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jboolean jresult = 0 ;
  XmlEventReader *arg1 = (XmlEventReader *) 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(XmlEventReader **)&jarg1; 
  
  if (!jarg1) {
    jenv->Throw((jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INVALID_VALUE,
        jenv->NewStringUTF("null object - call after object destroyed?"),
        0, 0, 0, 0));					
    return 0;
  }
  
  {
    jthrowable t = NULL;
    try {
      result = (bool)((XmlEventReader const *)arg1)->isWhiteSpace();
    }
    catch (std::exception &se) {
      t = createException(jenv, &se);
      jenv->Throw(t);
      return 0;
    }
    catch(JavaException & /* je */) {
      // This means there's already an exception waiting in the JVM
      return 0;
    }
    catch (...) {
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("Uncaught exception from C++ API"), 0, 0, 0, 0);
      jenv->Throw(t);
      return 0;
    }
  }
  
  jresult = result ? JNI_TRUE : JNI_FALSE;
  
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_sleepycat_dbxml_dbxml_1javaJNI_delete_1XmlEventWriter(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  XmlEventWriter *arg1 = (XmlEventWriter *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(XmlEventWriter **)&jarg1; 
  
  if (!jarg1) {
    jenv->Throw((jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INVALID_VALUE,
        jenv->NewStringUTF("null object - call after object destroyed?"),
        0, 0, 0, 0));					
    return ;
  }
  
  {
    jthrowable t = NULL;
    try {
      delete arg1;
    }
    catch (std::exception &se) {
      t = createException(jenv, &se);
      jenv->Throw(t);
      return ;
    }
    catch(JavaException & /* je */) {
      // This means there's already an exception waiting in the JVM
      return ;
    }
    catch (...) {
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("Uncaught exception from C++ API"), 0, 0, 0, 0);
      jenv->Throw(t);
      return ;
    }
  }
}


SWIGEXPORT void JNICALL Java_com_sleepycat_dbxml_dbxml_1javaJNI_XmlEventWriter_1closeInternal(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  XmlEventWriter *arg1 = (XmlEventWriter *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(XmlEventWriter **)&jarg1; 
  
  if (!jarg1) {
    jenv->Throw((jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INVALID_VALUE,
        jenv->NewStringUTF("null object - call after object destroyed?"),
        0, 0, 0, 0));					
    return ;
  }
  
  {
    jthrowable t = NULL;
    try {
      (arg1)->close();
    }
    catch (std::exception &se) {
      t = createException(jenv, &se);
      jenv->Throw(t);
      return ;
    }
    catch(JavaException & /* je */) {
      // This means there's already an exception waiting in the JVM
      return ;
    }
    catch (...) {
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("Uncaught exception from C++ API"), 0, 0, 0, 0);
      jenv->Throw(t);
      return ;
    }
  }
}


SWIGEXPORT void JNICALL Java_com_sleepycat_dbxml_dbxml_1javaJNI_XmlEventWriter_1writeAttribute(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2, jstring jarg3, jstring jarg4, jstring jarg5, jboolean jarg6) {
  XmlEventWriter *arg1 = (XmlEventWriter *) 0 ;
  unsigned char *arg2 = (unsigned char *) 0 ;
  unsigned char *arg3 = (unsigned char *) 0 ;
  unsigned char *arg4 = (unsigned char *) 0 ;
  unsigned char *arg5 = (unsigned char *) 0 ;
  bool arg6 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(XmlEventWriter **)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (unsigned char *)jenv->GetStringUTFChars(jarg2, 0);
    if (!arg2) return ;
  }
  arg3 = 0;
  if (jarg3) {
    arg3 = (unsigned char *)jenv->GetStringUTFChars(jarg3, 0);
    if (!arg3) return ;
  }
  arg4 = 0;
  if (jarg4) {
    arg4 = (unsigned char *)jenv->GetStringUTFChars(jarg4, 0);
    if (!arg4) return ;
  }
  arg5 = 0;
  if (jarg5) {
    arg5 = (unsigned char *)jenv->GetStringUTFChars(jarg5, 0);
    if (!arg5) return ;
  }
  
  arg6 = (jarg6 != JNI_FALSE);
  
  
  if (!jarg1) {
    jenv->Throw((jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INVALID_VALUE,
        jenv->NewStringUTF("null object - call after object destroyed?"),
        0, 0, 0, 0));					
    return ;
  }
  
  {
    jthrowable t = NULL;
    try {
      (arg1)->writeAttribute((unsigned char const *)arg2,(unsigned char const *)arg3,(unsigned char const *)arg4,(unsigned char const *)arg5,arg6);
    }
    catch (std::exception &se) {
      t = createException(jenv, &se);
      jenv->Throw(t);
      return ;
    }
    catch(JavaException & /* je */) {
      // This means there's already an exception waiting in the JVM
      return ;
    }
    catch (...) {
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("Uncaught exception from C++ API"), 0, 0, 0, 0);
      jenv->Throw(t);
      return ;
    }
  }
}


SWIGEXPORT void JNICALL Java_com_sleepycat_dbxml_dbxml_1javaJNI_XmlEventWriter_1writeText_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2, jstring jarg3, jint jarg4) {
  XmlEventWriter *arg1 = (XmlEventWriter *) 0 ;
  enum XmlEventReader::XmlEventType arg2 ;
  unsigned char *arg3 = (unsigned char *) 0 ;
  size_t arg4 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(XmlEventWriter **)&jarg1; 
  arg2 = (enum XmlEventReader::XmlEventType)jarg2; 
  arg3 = 0;
  if (jarg3) {
    arg3 = (unsigned char *)jenv->GetStringUTFChars(jarg3, 0);
    if (!arg3) return ;
  }
  arg4 = (size_t)jarg4; 
  
  if (!jarg1) {
    jenv->Throw((jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INVALID_VALUE,
        jenv->NewStringUTF("null object - call after object destroyed?"),
        0, 0, 0, 0));					
    return ;
  }
  
  {
    jthrowable t = NULL;
    try {
      (arg1)->writeText(arg2,(unsigned char const *)arg3,arg4);
    }
    catch (std::exception &se) {
      t = createException(jenv, &se);
      jenv->Throw(t);
      return ;
    }
    catch(JavaException & /* je */) {
      // This means there's already an exception waiting in the JVM
      return ;
    }
    catch (...) {
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("Uncaught exception from C++ API"), 0, 0, 0, 0);
      jenv->Throw(t);
      return ;
    }
  }
}


SWIGEXPORT void JNICALL Java_com_sleepycat_dbxml_dbxml_1javaJNI_XmlEventWriter_1writeDTD_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2, jint jarg3) {
  XmlEventWriter *arg1 = (XmlEventWriter *) 0 ;
  unsigned char *arg2 = (unsigned char *) 0 ;
  size_t arg3 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(XmlEventWriter **)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (unsigned char *)jenv->GetStringUTFChars(jarg2, 0);
    if (!arg2) return ;
  }
  arg3 = (size_t)jarg3; 
  
  if (!jarg1) {
    jenv->Throw((jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INVALID_VALUE,
        jenv->NewStringUTF("null object - call after object destroyed?"),
        0, 0, 0, 0));					
    return ;
  }
  
  {
    jthrowable t = NULL;
    try {
      (arg1)->writeDTD((unsigned char const *)arg2,arg3);
    }
    catch (std::exception &se) {
      t = createException(jenv, &se);
      jenv->Throw(t);
      return ;
    }
    catch(JavaException & /* je */) {
      // This means there's already an exception waiting in the JVM
      return ;
    }
    catch (...) {
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("Uncaught exception from C++ API"), 0, 0, 0, 0);
      jenv->Throw(t);
      return ;
    }
  }
}


SWIGEXPORT void JNICALL Java_com_sleepycat_dbxml_dbxml_1javaJNI_XmlEventWriter_1writeText_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2, jstring jarg3) {
  XmlEventWriter *arg1 = (XmlEventWriter *) 0 ;
  enum XmlEventReader::XmlEventType arg2 ;
  unsigned char *arg3 = (unsigned char *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(XmlEventWriter **)&jarg1; 
  arg2 = (enum XmlEventReader::XmlEventType)jarg2; 
  arg3 = 0;
  if (jarg3) {
    arg3 = (unsigned char *)jenv->GetStringUTFChars(jarg3, 0);
    if (!arg3) return ;
  }
  
  if (!jarg1) {
    jenv->Throw((jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INVALID_VALUE,
        jenv->NewStringUTF("null object - call after object destroyed?"),
        0, 0, 0, 0));					
    return ;
  }
  
  {
    jthrowable t = NULL;
    try {
      XmlEventWriter_writeText__SWIG_1(arg1,arg2,(unsigned char const *)arg3);
    }
    catch (std::exception &se) {
      t = createException(jenv, &se);
      jenv->Throw(t);
      return ;
    }
    catch(JavaException & /* je */) {
      // This means there's already an exception waiting in the JVM
      return ;
    }
    catch (...) {
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("Uncaught exception from C++ API"), 0, 0, 0, 0);
      jenv->Throw(t);
      return ;
    }
  }
}


SWIGEXPORT void JNICALL Java_com_sleepycat_dbxml_dbxml_1javaJNI_XmlEventWriter_1writeDTD_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2) {
  XmlEventWriter *arg1 = (XmlEventWriter *) 0 ;
  unsigned char *arg2 = (unsigned char *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(XmlEventWriter **)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (unsigned char *)jenv->GetStringUTFChars(jarg2, 0);
    if (!arg2) return ;
  }
  
  if (!jarg1) {
    jenv->Throw((jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INVALID_VALUE,
        jenv->NewStringUTF("null object - call after object destroyed?"),
        0, 0, 0, 0));					
    return ;
  }
  
  {
    jthrowable t = NULL;
    try {
      XmlEventWriter_writeDTD__SWIG_1(arg1,(unsigned char const *)arg2);
    }
    catch (std::exception &se) {
      t = createException(jenv, &se);
      jenv->Throw(t);
      return ;
    }
    catch(JavaException & /* je */) {
      // This means there's already an exception waiting in the JVM
      return ;
    }
    catch (...) {
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("Uncaught exception from C++ API"), 0, 0, 0, 0);
      jenv->Throw(t);
      return ;
    }
  }
}


SWIGEXPORT void JNICALL Java_com_sleepycat_dbxml_dbxml_1javaJNI_XmlEventWriter_1writeProcessingInstruction(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2, jstring jarg3) {
  XmlEventWriter *arg1 = (XmlEventWriter *) 0 ;
  unsigned char *arg2 = (unsigned char *) 0 ;
  unsigned char *arg3 = (unsigned char *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(XmlEventWriter **)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (unsigned char *)jenv->GetStringUTFChars(jarg2, 0);
    if (!arg2) return ;
  }
  arg3 = 0;
  if (jarg3) {
    arg3 = (unsigned char *)jenv->GetStringUTFChars(jarg3, 0);
    if (!arg3) return ;
  }
  
  if (!jarg1) {
    jenv->Throw((jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INVALID_VALUE,
        jenv->NewStringUTF("null object - call after object destroyed?"),
        0, 0, 0, 0));					
    return ;
  }
  
  {
    jthrowable t = NULL;
    try {
      (arg1)->writeProcessingInstruction((unsigned char const *)arg2,(unsigned char const *)arg3);
    }
    catch (std::exception &se) {
      t = createException(jenv, &se);
      jenv->Throw(t);
      return ;
    }
    catch(JavaException & /* je */) {
      // This means there's already an exception waiting in the JVM
      return ;
    }
    catch (...) {
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("Uncaught exception from C++ API"), 0, 0, 0, 0);
      jenv->Throw(t);
      return ;
    }
  }
}


SWIGEXPORT void JNICALL Java_com_sleepycat_dbxml_dbxml_1javaJNI_XmlEventWriter_1writeStartElement(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2, jstring jarg3, jstring jarg4, jint jarg5, jboolean jarg6) {
  XmlEventWriter *arg1 = (XmlEventWriter *) 0 ;
  unsigned char *arg2 = (unsigned char *) 0 ;
  unsigned char *arg3 = (unsigned char *) 0 ;
  unsigned char *arg4 = (unsigned char *) 0 ;
  int arg5 ;
  bool arg6 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(XmlEventWriter **)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (unsigned char *)jenv->GetStringUTFChars(jarg2, 0);
    if (!arg2) return ;
  }
  arg3 = 0;
  if (jarg3) {
    arg3 = (unsigned char *)jenv->GetStringUTFChars(jarg3, 0);
    if (!arg3) return ;
  }
  arg4 = 0;
  if (jarg4) {
    arg4 = (unsigned char *)jenv->GetStringUTFChars(jarg4, 0);
    if (!arg4) return ;
  }
  arg5 = (int)jarg5; 
  
  arg6 = (jarg6 != JNI_FALSE);
  
  
  if (!jarg1) {
    jenv->Throw((jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INVALID_VALUE,
        jenv->NewStringUTF("null object - call after object destroyed?"),
        0, 0, 0, 0));					
    return ;
  }
  
  {
    jthrowable t = NULL;
    try {
      (arg1)->writeStartElement((unsigned char const *)arg2,(unsigned char const *)arg3,(unsigned char const *)arg4,arg5,arg6);
    }
    catch (std::exception &se) {
      t = createException(jenv, &se);
      jenv->Throw(t);
      return ;
    }
    catch(JavaException & /* je */) {
      // This means there's already an exception waiting in the JVM
      return ;
    }
    catch (...) {
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("Uncaught exception from C++ API"), 0, 0, 0, 0);
      jenv->Throw(t);
      return ;
    }
  }
}


SWIGEXPORT void JNICALL Java_com_sleepycat_dbxml_dbxml_1javaJNI_XmlEventWriter_1writeEndElement(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2, jstring jarg3, jstring jarg4) {
  XmlEventWriter *arg1 = (XmlEventWriter *) 0 ;
  unsigned char *arg2 = (unsigned char *) 0 ;
  unsigned char *arg3 = (unsigned char *) 0 ;
  unsigned char *arg4 = (unsigned char *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(XmlEventWriter **)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (unsigned char *)jenv->GetStringUTFChars(jarg2, 0);
    if (!arg2) return ;
  }
  arg3 = 0;
  if (jarg3) {
    arg3 = (unsigned char *)jenv->GetStringUTFChars(jarg3, 0);
    if (!arg3) return ;
  }
  arg4 = 0;
  if (jarg4) {
    arg4 = (unsigned char *)jenv->GetStringUTFChars(jarg4, 0);
    if (!arg4) return ;
  }
  
  if (!jarg1) {
    jenv->Throw((jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INVALID_VALUE,
        jenv->NewStringUTF("null object - call after object destroyed?"),
        0, 0, 0, 0));					
    return ;
  }
  
  {
    jthrowable t = NULL;
    try {
      (arg1)->writeEndElement((unsigned char const *)arg2,(unsigned char const *)arg3,(unsigned char const *)arg4);
    }
    catch (std::exception &se) {
      t = createException(jenv, &se);
      jenv->Throw(t);
      return ;
    }
    catch(JavaException & /* je */) {
      // This means there's already an exception waiting in the JVM
      return ;
    }
    catch (...) {
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("Uncaught exception from C++ API"), 0, 0, 0, 0);
      jenv->Throw(t);
      return ;
    }
  }
}


SWIGEXPORT void JNICALL Java_com_sleepycat_dbxml_dbxml_1javaJNI_XmlEventWriter_1writeStartDocument(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2, jstring jarg3, jstring jarg4) {
  XmlEventWriter *arg1 = (XmlEventWriter *) 0 ;
  unsigned char *arg2 = (unsigned char *) 0 ;
  unsigned char *arg3 = (unsigned char *) 0 ;
  unsigned char *arg4 = (unsigned char *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(XmlEventWriter **)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (unsigned char *)jenv->GetStringUTFChars(jarg2, 0);
    if (!arg2) return ;
  }
  arg3 = 0;
  if (jarg3) {
    arg3 = (unsigned char *)jenv->GetStringUTFChars(jarg3, 0);
    if (!arg3) return ;
  }
  arg4 = 0;
  if (jarg4) {
    arg4 = (unsigned char *)jenv->GetStringUTFChars(jarg4, 0);
    if (!arg4) return ;
  }
  
  if (!jarg1) {
    jenv->Throw((jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INVALID_VALUE,
        jenv->NewStringUTF("null object - call after object destroyed?"),
        0, 0, 0, 0));					
    return ;
  }
  
  {
    jthrowable t = NULL;
    try {
      (arg1)->writeStartDocument((unsigned char const *)arg2,(unsigned char const *)arg3,(unsigned char const *)arg4);
    }
    catch (std::exception &se) {
      t = createException(jenv, &se);
      jenv->Throw(t);
      return ;
    }
    catch(JavaException & /* je */) {
      // This means there's already an exception waiting in the JVM
      return ;
    }
    catch (...) {
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("Uncaught exception from C++ API"), 0, 0, 0, 0);
      jenv->Throw(t);
      return ;
    }
  }
}


SWIGEXPORT void JNICALL Java_com_sleepycat_dbxml_dbxml_1javaJNI_XmlEventWriter_1writeEndDocument(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  XmlEventWriter *arg1 = (XmlEventWriter *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(XmlEventWriter **)&jarg1; 
  
  if (!jarg1) {
    jenv->Throw((jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INVALID_VALUE,
        jenv->NewStringUTF("null object - call after object destroyed?"),
        0, 0, 0, 0));					
    return ;
  }
  
  {
    jthrowable t = NULL;
    try {
      (arg1)->writeEndDocument();
    }
    catch (std::exception &se) {
      t = createException(jenv, &se);
      jenv->Throw(t);
      return ;
    }
    catch(JavaException & /* je */) {
      // This means there's already an exception waiting in the JVM
      return ;
    }
    catch (...) {
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("Uncaught exception from C++ API"), 0, 0, 0, 0);
      jenv->Throw(t);
      return ;
    }
  }
}


SWIGEXPORT void JNICALL Java_com_sleepycat_dbxml_dbxml_1javaJNI_XmlEventWriter_1writeStartEntity(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2, jboolean jarg3) {
  XmlEventWriter *arg1 = (XmlEventWriter *) 0 ;
  unsigned char *arg2 = (unsigned char *) 0 ;
  bool arg3 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(XmlEventWriter **)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (unsigned char *)jenv->GetStringUTFChars(jarg2, 0);
    if (!arg2) return ;
  }
  
  arg3 = (jarg3 != JNI_FALSE);
  
  
  if (!jarg1) {
    jenv->Throw((jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INVALID_VALUE,
        jenv->NewStringUTF("null object - call after object destroyed?"),
        0, 0, 0, 0));					
    return ;
  }
  
  {
    jthrowable t = NULL;
    try {
      (arg1)->writeStartEntity((unsigned char const *)arg2,arg3);
    }
    catch (std::exception &se) {
      t = createException(jenv, &se);
      jenv->Throw(t);
      return ;
    }
    catch(JavaException & /* je */) {
      // This means there's already an exception waiting in the JVM
      return ;
    }
    catch (...) {
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("Uncaught exception from C++ API"), 0, 0, 0, 0);
      jenv->Throw(t);
      return ;
    }
  }
}


SWIGEXPORT void JNICALL Java_com_sleepycat_dbxml_dbxml_1javaJNI_XmlEventWriter_1writeEndEntity(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2) {
  XmlEventWriter *arg1 = (XmlEventWriter *) 0 ;
  unsigned char *arg2 = (unsigned char *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(XmlEventWriter **)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (unsigned char *)jenv->GetStringUTFChars(jarg2, 0);
    if (!arg2) return ;
  }
  
  if (!jarg1) {
    jenv->Throw((jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INVALID_VALUE,
        jenv->NewStringUTF("null object - call after object destroyed?"),
        0, 0, 0, 0));					
    return ;
  }
  
  {
    jthrowable t = NULL;
    try {
      (arg1)->writeEndEntity((unsigned char const *)arg2);
    }
    catch (std::exception &se) {
      t = createException(jenv, &se);
      jenv->Throw(t);
      return ;
    }
    catch(JavaException & /* je */) {
      // This means there's already an exception waiting in the JVM
      return ;
    }
    catch (...) {
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("Uncaught exception from C++ API"), 0, 0, 0, 0);
      jenv->Throw(t);
      return ;
    }
  }
}


SWIGEXPORT jlong JNICALL Java_com_sleepycat_dbxml_dbxml_1javaJNI_new_1XmlEventReaderToWriter(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_, jboolean jarg3, jboolean jarg4) {
  jlong jresult = 0 ;
  XmlEventReader *arg1 = 0 ;
  XmlEventWriter *arg2 = 0 ;
  bool arg3 ;
  bool arg4 ;
  XmlEventReaderToWriter *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(XmlEventReader **)&jarg1;
  if(!arg1) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "XmlEventReader & reference is null");
    return 0;
  } 
  arg2 = *(XmlEventWriter **)&jarg2;
  if(!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "XmlEventWriter & reference is null");
    return 0;
  } 
  
  arg3 = (jarg3 != JNI_FALSE);
  
  
  arg4 = (jarg4 != JNI_FALSE);
  
  {
    jthrowable t = NULL;
    try {
      result = (XmlEventReaderToWriter *)new XmlEventReaderToWriter(*arg1,*arg2,arg3,arg4);
    }
    catch (std::exception &se) {
      t = createException(jenv, &se);
      jenv->Throw(t);
      return 0;
    }
    catch(JavaException & /* je */) {
      // This means there's already an exception waiting in the JVM
      return 0;
    }
    catch (...) {
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("Uncaught exception from C++ API"), 0, 0, 0, 0);
      jenv->Throw(t);
      return 0;
    }
  }
  *(XmlEventReaderToWriter **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_com_sleepycat_dbxml_dbxml_1javaJNI_delete_1XmlEventReaderToWriter(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  XmlEventReaderToWriter *arg1 = (XmlEventReaderToWriter *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(XmlEventReaderToWriter **)&jarg1; 
  
  if (!jarg1) {
    jenv->Throw((jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INVALID_VALUE,
        jenv->NewStringUTF("null object - call after object destroyed?"),
        0, 0, 0, 0));					
    return ;
  }
  
  {
    jthrowable t = NULL;
    try {
      delete arg1;
    }
    catch (std::exception &se) {
      t = createException(jenv, &se);
      jenv->Throw(t);
      return ;
    }
    catch(JavaException & /* je */) {
      // This means there's already an exception waiting in the JVM
      return ;
    }
    catch (...) {
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("Uncaught exception from C++ API"), 0, 0, 0, 0);
      jenv->Throw(t);
      return ;
    }
  }
}


SWIGEXPORT void JNICALL Java_com_sleepycat_dbxml_dbxml_1javaJNI_XmlEventReaderToWriter_1start(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  XmlEventReaderToWriter *arg1 = (XmlEventReaderToWriter *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(XmlEventReaderToWriter **)&jarg1; 
  
  if (!jarg1) {
    jenv->Throw((jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INVALID_VALUE,
        jenv->NewStringUTF("null object - call after object destroyed?"),
        0, 0, 0, 0));					
    return ;
  }
  
  {
    jthrowable t = NULL;
    try {
      (arg1)->start();
    }
    catch (std::exception &se) {
      t = createException(jenv, &se);
      jenv->Throw(t);
      return ;
    }
    catch(JavaException & /* je */) {
      // This means there's already an exception waiting in the JVM
      return ;
    }
    catch (...) {
      t = (jthrowable)jenv->NewObject(xmlex_class, xmlex_construct,
        XmlException::INTERNAL_ERROR,
        jenv->NewStringUTF("Uncaught exception from C++ API"), 0, 0, 0, 0);
      jenv->Throw(t);
      return ;
    }
  }
}


SWIGEXPORT void JNICALL Java_com_sleepycat_dbxml_dbxml_1javaJNI_swig_1module_1init(JNIEnv *jenv, jclass jcls) {
  int i;
  
  static struct {
    const char *method;
    const char *signature;
  } methods[18] = {
    {
      "SwigDirector_XmlInputStream_curPos", "(Lcom/sleepycat/dbxml/XmlInputStream;)J" 
    },
    {
      "SwigDirector_XmlInputStream_readBytes", "(Lcom/sleepycat/dbxml/XmlInputStream;[BJ)J" 
    },
    {
      "SwigDirector_XmlResolver_resolveDocument", "(Lcom/sleepycat/dbxml/XmlResolver;JJLjava/lang/String;Lcom/sleepycat/dbxml/XmlValue;)Z" 
    },
    {
      "SwigDirector_XmlResolver_resolveCollection", "(Lcom/sleepycat/dbxml/XmlResolver;JJLjava/lang/String;J)Z" 
    },
    {
      "SwigDirector_XmlResolver_resolveSchema", "(Lcom/sleepycat/dbxml/XmlResolver;JJLjava/lang/String;Ljava/lang/String;)J" 
    },
    {
      "SwigDirector_XmlResolver_resolveEntity", "(Lcom/sleepycat/dbxml/XmlResolver;JJLjava/lang/String;Ljava/lang/String;)J" 
    },
    {
      "SwigDirector_XmlResolver_resolveModuleLocation", "(Lcom/sleepycat/dbxml/XmlResolver;JJLjava/lang/String;J)Z" 
    },
    {
      "SwigDirector_XmlResolver_resolveModule", "(Lcom/sleepycat/dbxml/XmlResolver;JJLjava/lang/String;Ljava/lang/String;)J" 
    },
    {
      "SwigDirector_XmlResolver_resolveExternalFunction", "(Lcom/sleepycat/dbxml/XmlResolver;JJLjava/lang/String;Ljava/lang/String;I)J" 
    },
    {
      "SwigDirector_XmlExternalFunctionBase_execute", "(Lcom/sleepycat/dbxml/XmlExternalFunctionBase;JJJ)J" 
    },
    {
      "SwigDirector_XmlExternalFunctionBase_close", "(Lcom/sleepycat/dbxml/XmlExternalFunctionBase;)V" 
    },
    {
      "SwigDirector_XmlDebugListener_start", "(Lcom/sleepycat/dbxml/XmlDebugListener;J)V" 
    },
    {
      "SwigDirector_XmlDebugListener_end", "(Lcom/sleepycat/dbxml/XmlDebugListener;J)V" 
    },
    {
      "SwigDirector_XmlDebugListener_enter", "(Lcom/sleepycat/dbxml/XmlDebugListener;J)V" 
    },
    {
      "SwigDirector_XmlDebugListener_exit", "(Lcom/sleepycat/dbxml/XmlDebugListener;J)V" 
    },
    {
      "SwigDirector_XmlDebugListener_error", "(Lcom/sleepycat/dbxml/XmlDebugListener;Lcom/sleepycat/dbxml/XmlException;J)V" 
    },
    {
      "SwigDirector_XmlCompression_compress", "(Lcom/sleepycat/dbxml/XmlCompression;JJJ)Z" 
    },
    {
      "SwigDirector_XmlCompression_decompress", "(Lcom/sleepycat/dbxml/XmlCompression;JJJ)Z" 
    }
  };
  Swig::jclass_dbxml_javaJNI = (jclass) jenv->NewGlobalRef(jcls);
  if (!Swig::jclass_dbxml_javaJNI) return;
  for (i = 0; i < (int) (sizeof(methods)/sizeof(methods[0])); ++i) {
    Swig::director_methids[i] = jenv->GetStaticMethodID(jcls, methods[i].method, methods[i].signature);
    if (!Swig::director_methids[i]) return;
  }
}


#ifdef __cplusplus
}
#endif

