/*-
 * See the file LICENSE for redistribution information.
 *
 * Copyright (c) 1998,2006 Oracle.  All rights reserved.
 *
 * $Id: perf_workload.hpp,v 1.5 2006/10/30 17:46:17 bostic Exp $
 */

#ifndef __PERF_WORKLOAD
#define	__PERF_WORKLOAD

#include "perf_work.h"

/*
 * The run() method does this:
 *   o call setup() one time, single-threaded
 *   o call work() N times for each thread specified
 *     in the globals, where N is the number of iterations
 *   o wait for threds
 *   o call cleanup() one time, single-threaded.
 */

/*
 * Virtual interface for performance workload
 */
class PerfWorkload {
public:
	PerfWorkload(struct perf_globals *globals) :
		pwGlobals(globals) {}
	virtual ~PerfWorkload() {}
	virtual int setup() { return 0; }
	virtual int work(int id, int *iteration) = 0;
	virtual int cleanup() { return 0; }

	// run the workload
	void run();
protected:
	struct perf_globals *pwGlobals;
private:
	static int pwSetup(struct perf_globals *globals);
	static int pwWork(struct perf_globals *globals, int id, int *iteration);
	static int pwCleanup(struct perf_globals *globals);
};

#endif       
