/*
 * See the file LICENSE for redistribution information.
 *
 * Copyright (c) 1998,2006 Oracle.  All rights reserved.
 *
 * $Id: perf_workload.cpp,v 1.5 2006/10/30 17:46:17 bostic Exp $
 */

#include "perf_workload.hpp"
#include <iostream>

//
// PerfWorkload
//
void PerfWorkload::run()
{
	struct perf_workload wl;
	wl.w_setup = pwSetup;
	wl.w_work = pwWork;
	wl.w_cleanup = pwCleanup;
	pwGlobals->g_private = (void *)this;
	(void) perf_run_workload(&wl, pwGlobals);
}

/* static */
int PerfWorkload::pwSetup(struct perf_globals *globals)
{
	PerfWorkload *load = (PerfWorkload*)globals->g_private;
	if (load)
		return load->setup();
	return -1;
}

int PerfWorkload::pwWork(struct perf_globals *globals, int id, int *i)
{
	PerfWorkload *load = (PerfWorkload*)globals->g_private;
	if (load)
		return load->work(id, i);
	return -1;
}

int PerfWorkload::pwCleanup(struct perf_globals *globals)
{
	PerfWorkload *load = (PerfWorkload*)globals->g_private;
	if (load)
		return load->cleanup();
	return -1;
}
