/*-
 * See the file LICENSE for redistribution information.
 *
 * Copyright (c) 1998,2006 Oracle.  All rights reserved.
 *
 * $Id: perf_work.h,v 1.6 2006/10/30 17:46:17 bostic Exp $
 */

#ifndef __PERF_WORK
#define	__PERF_WORK

#include <db.h>

#ifdef __cplusplus
extern "C" {
#endif

/*
 * TODO:
 *  o processes (allow arbitrary process forks)
 *  o threads
 *  o platform-specific code
 *  o allow work flows of multiple loads
 */

struct perf_timeval {
	u_int32_t secs;
	u_int32_t usecs;
};

struct perf_timer {
	struct perf_timeval pt_start;
	struct perf_timeval pt_end;
};
	
struct perf_globals {
	int g_iterations;
	int g_nthreads; /* 0 is treated as 1 -- current thread */
	int g_nprocs;  /*  0 is treated as 1 -- current proc */
	struct perf_timer **g_timers; /* per-iteration timers */
	struct perf_timer g_total_timer; /* total time for process */
	/* ... */
	void *g_private; /* owned by controlling process */
};

/* a non-zero return means failure, stop the run */
typedef int (*setup_func)(struct perf_globals *);
typedef int (*work_func)(struct perf_globals *, int id, int *iteration);
struct perf_workload {
	setup_func w_setup;   /* called once */
	work_func w_work;    /* the workload itself */
	setup_func w_cleanup; /* called once */
	struct perf_globals *w_globals;
};

/* public functions */
int perf_run_workload(struct perf_workload *load,
		      struct perf_globals *globals);

int perf_init_globals(struct perf_globals *globals,
		      int iterations, int nthreads, int timeops);
void perf_uninit_globals(struct perf_globals *globals);

/* timers -- unit is usecs unless specified */
int perf_start_timer(struct perf_timer *timer);
int perf_end_timer(struct perf_timer *timer);
long perf_timer_duration(struct perf_timer *timer);
void perf_dump_timers(struct perf_globals *globals);	

#ifdef __cplusplus
};
#endif

#endif       
