/*-
 * See the file LICENSE for redistribution information.
 *
 * Copyright (c) 1998,2006 Oracle.  All rights reserved.
 *
 * $Id: perf_os.h,v 1.5 2006/10/30 17:46:17 bostic Exp $
 */

#ifndef __PERF_OS
#define	__PERF_OS

#ifdef WIN32
#include <windows.h>
#else
#define HAVE_UNISTD_H /* XXX */
#endif
#ifdef HAVE_UNISTD_H
#include <unistd.h>
#endif

#if !defined(HAVE_VXWORKS) && !defined(WIN32)
#include <pthread.h>
#endif

/* platform TBD -- for malloc */
#include <stdlib.h>
#define perf_malloc malloc
#define perf_free free

#ifdef __cplusplus
extern "C" {
#endif

typedef void *(*thread_func)(void *);
void * run_threads(void *arg, thread_func func, int nthreads);
int wait_threads(void *handles);
	
#ifdef WIN32
  typedef HANDLE          os_thread_t;
  #define os_thread_id()  GetCurrentThreadId()
  #define os_thread_create(name, pid, func, arg)                    \
       ((*pid = CreateThread(NULL, 0, (LPTHREAD_START_ROUTINE)func, \
       arg, 0, NULL)) != NULL)
  #define S_ISDIR(m) ((m) & _S_IFDIR)
#else
  typedef pthread_t       os_thread_t;
  #define os_thread_id()  pthread_self()
  #define os_thread_create(name, pid, func, arg)                    \
       (0 == pthread_create(pid, NULL, func, arg))
#endif

/* thread functions get a pointer to this as arg */	
struct perf_thread_arg {
  void *pt_load;
  int pt_id;
  os_thread_t pt_thread;
};
	
#ifdef __cplusplus
};
#endif

#endif       
