/*-
 * See the file LICENSE for redistribution information.
 *
 * Copyright (c) 1998,2006 Oracle.  All rights reserved.
 *
 * $Id: perf_os.c,v 1.4 2006/10/30 17:46:17 bostic Exp $
 */

#include "perf_os.h"
#include <stdio.h>

void * run_threads(void *arg, thread_func func, int nthreads)
{
  int i;
  struct perf_thread_arg *threads = (struct perf_thread_arg *)
    perf_malloc((nthreads + 1)*sizeof(struct perf_thread_arg));

  if (threads) {
    threads[nthreads].pt_thread = 0;
    for (i = 0; i < nthreads; i++) {
      threads[i].pt_load = arg;
      threads[i].pt_id = i;
      if (!os_thread_create("perfthd", &(threads[i].pt_thread), func, 
			    &(threads[i]))) {
	printf("Failed to create thread\n");
	perf_free(threads);
	threads = 0;
	break;
      }
    }
  }
  return threads;
}

int wait_threads(void *handles)
{
  int i, status;
  struct perf_thread_arg *threads = (struct perf_thread_arg *)handles;
#if defined(WIN32)
  status = 0;
  for (i = 0; threads[i].pt_thread != (os_thread_t)NULL; i++) {
	if (WaitForSingleObject(threads[i].pt_thread, INFINITE) == WAIT_FAILED) {
      status = 1;
      printf("wait_threads: child %ld exited with error %s\n",
	      (long)i, strerror(GetLastError()));
    }
  }
#else
  void *retp;
  status = 0;
  for (i = 0; threads[i].pt_thread != (os_thread_t)NULL; i++) {
    pthread_join(threads[i].pt_thread, &retp);
    if (retp != NULL) {
      status = 1;
      printf("wait_threads: child %ld exited with error\n",
	     (long)i);
    }
  }
#endif
  perf_free(threads);
  return (status);
}

