/*
 * See the file LICENSE for redistribution information.
 *
 * Copyright (c) 1998,2006 Oracle.  All rights reserved.
 *
 * $Id: QueryWorkload.hpp,v 1.5 2006/10/30 17:46:17 bostic Exp $
 */

#ifndef __QUERYWORKLOAD_HPP
#define	__QUERYWORKLOAD_HPP

#include "DbXmlWorkload.hpp"

class QueryThreadGlobal : public ThreadGlobal {
public:
	DbXml::XmlQueryContext qc;
};

class QueryWorkload : public DbXmlWorkload {
public:
	QueryWorkload(struct perf_globals *globals, PerfParams &params)
		: DbXmlWorkload(globals, params)
	{}

	virtual int setup();
	virtual int work(int id, int *iteration, ThreadGlobal *tglob);
	virtual int cleanup();

protected:
	virtual ThreadGlobal *createThreadGlobal(int id);

	DbXml::XmlQueryExpression expr_;
};

class Query2Workload : public QueryWorkload {
public:
	Query2Workload(struct perf_globals *globals, PerfParams &params)
		: QueryWorkload(globals, params)
	{}

	virtual int setup();
	virtual int work(int id, int *iteration, ThreadGlobal *tglob);
	virtual int cleanup();
};

#endif
